/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.selectable.MaintNotificationItemCauseSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemCause
 * MaintNotificationItemCause} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class MaintNotificationItemCauseByKeyFluentHelper
    extends
    FluentHelperByKey<MaintNotificationItemCauseByKeyFluentHelper, MaintNotificationItemCause, MaintNotificationItemCauseSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemCause
     * MaintNotificationItemCause} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param maintenanceNotificationItem
     *            Item Number in Item Record
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code MaintNotificationItemCause}
     * @param maintenanceNotificationCause
     *            Sequential Number for Cause
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code MaintNotificationItemCause}
     * @param maintenanceNotification
     *            Notification Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     */
    public MaintNotificationItemCauseByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String maintenanceNotification,
        final String maintenanceNotificationItem,
        final String maintenanceNotificationCause )
    {
        super(servicePath, entityCollection);
        this.key.put("MaintenanceNotification", maintenanceNotification);
        this.key.put("MaintenanceNotificationItem", maintenanceNotificationItem);
        this.key.put("MaintenanceNotificationCause", maintenanceNotificationCause);
    }

    @Override
    @Nonnull
    protected Class<MaintNotificationItemCause> getEntityClass()
    {
        return MaintNotificationItemCause.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
