/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification;

import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.field.MaintenanceNotificationField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.link.MaintenanceNotificationLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.selectable.MaintenanceNotificationSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Maintenance Notification
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MaintenanceNotificationType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MaintenanceNotification extends VdmEntity<MaintenanceNotification>
{

    /**
     * Selector for all available fields of MaintenanceNotification.
     *
     */
    public final static MaintenanceNotificationSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceNotification</b>
     * </p>
     *
     * @return Notification Number
     */
    @Key
    @SerializedName( "MaintenanceNotification" )
    @JsonProperty( "MaintenanceNotification" )
    @Nullable
    @ODataField( odataName = "MaintenanceNotification" )
    private String maintenanceNotification;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceNotification</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> MAINTENANCE_NOTIFICATION =
        new MaintenanceNotificationField<String>("MaintenanceNotification");
    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifInternalID</b>
     * </p>
     *
     * @return Object Number for Status Management
     */
    @SerializedName( "MaintNotifInternalID" )
    @JsonProperty( "MaintNotifInternalID" )
    @Nullable
    @ODataField( odataName = "MaintNotifInternalID" )
    private String maintNotifInternalID;
    /**
     * Use with available fluent helpers to apply the <b>MaintNotifInternalID</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> MAINT_NOTIF_INTERNAL_ID =
        new MaintenanceNotificationField<String>("MaintNotifInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>NotificationText</b>
     * </p>
     *
     * @return Short Text
     */
    @SerializedName( "NotificationText" )
    @JsonProperty( "NotificationText" )
    @Nullable
    @ODataField( odataName = "NotificationText" )
    private String notificationText;
    /**
     * Use with available fluent helpers to apply the <b>NotificationText</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> NOTIFICATION_TEXT =
        new MaintenanceNotificationField<String>("NotificationText");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintPriority</b>
     * </p>
     *
     * @return Priority
     */
    @SerializedName( "MaintPriority" )
    @JsonProperty( "MaintPriority" )
    @Nullable
    @ODataField( odataName = "MaintPriority" )
    private String maintPriority;
    /**
     * Use with available fluent helpers to apply the <b>MaintPriority</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> MAINT_PRIORITY =
        new MaintenanceNotificationField<String>("MaintPriority");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>NotificationType</b>
     * </p>
     *
     * @return Notification Type
     */
    @SerializedName( "NotificationType" )
    @JsonProperty( "NotificationType" )
    @Nullable
    @ODataField( odataName = "NotificationType" )
    private String notificationType;
    /**
     * Use with available fluent helpers to apply the <b>NotificationType</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> NOTIFICATION_TYPE =
        new MaintenanceNotificationField<String>("NotificationType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NotifProcessingPhase</b>
     * </p>
     *
     * @return Notification Processing Phase
     */
    @SerializedName( "NotifProcessingPhase" )
    @JsonProperty( "NotifProcessingPhase" )
    @Nullable
    @ODataField( odataName = "NotifProcessingPhase" )
    private String notifProcessingPhase;
    /**
     * Use with available fluent helpers to apply the <b>NotifProcessingPhase</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> NOTIF_PROCESSING_PHASE =
        new MaintenanceNotificationField<String>("NotifProcessingPhase");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>NotifProcessingPhaseDesc</b>
     * </p>
     *
     * @return Short Text for Fixed Values
     */
    @SerializedName( "NotifProcessingPhaseDesc" )
    @JsonProperty( "NotifProcessingPhaseDesc" )
    @Nullable
    @ODataField( odataName = "NotifProcessingPhaseDesc" )
    private String notifProcessingPhaseDesc;
    /**
     * Use with available fluent helpers to apply the <b>NotifProcessingPhaseDesc</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> NOTIF_PROCESSING_PHASE_DESC =
        new MaintenanceNotificationField<String>("NotifProcessingPhaseDesc");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>MaintPriorityDesc</b>
     * </p>
     *
     * @return Priority Text
     */
    @SerializedName( "MaintPriorityDesc" )
    @JsonProperty( "MaintPriorityDesc" )
    @Nullable
    @ODataField( odataName = "MaintPriorityDesc" )
    private String maintPriorityDesc;
    /**
     * Use with available fluent helpers to apply the <b>MaintPriorityDesc</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> MAINT_PRIORITY_DESC =
        new MaintenanceNotificationField<String>("MaintPriorityDesc");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Record Created On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<LocalDateTime> CREATION_DATE =
        new MaintenanceNotificationField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeTime</b>
     * </p>
     *
     * @return Time of Change
     */
    @SerializedName( "LastChangeTime" )
    @JsonProperty( "LastChangeTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime lastChangeTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeTime</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<LocalTime> LAST_CHANGE_TIME =
        new MaintenanceNotificationField<LocalTime>("LastChangeTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Last Changed On
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<LocalDateTime> LAST_CHANGE_DATE =
        new MaintenanceNotificationField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new MaintenanceNotificationField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     *
     * @return Time at Which Record Was Added
     */
    @SerializedName( "CreationTime" )
    @JsonProperty( "CreationTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "CreationTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime creationTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationTime</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<LocalTime> CREATION_TIME =
        new MaintenanceNotificationField<LocalTime>("CreationTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ReportedByUser</b>
     * </p>
     *
     * @return Name of Person Reporting Notification
     */
    @SerializedName( "ReportedByUser" )
    @JsonProperty( "ReportedByUser" )
    @Nullable
    @ODataField( odataName = "ReportedByUser" )
    private String reportedByUser;
    /**
     * Use with available fluent helpers to apply the <b>ReportedByUser</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> REPORTED_BY_USER =
        new MaintenanceNotificationField<String>("ReportedByUser");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>ReporterFullName</b>
     * </p>
     *
     * @return Full Name of Person
     */
    @SerializedName( "ReporterFullName" )
    @JsonProperty( "ReporterFullName" )
    @Nullable
    @ODataField( odataName = "ReporterFullName" )
    private String reporterFullName;
    /**
     * Use with available fluent helpers to apply the <b>ReporterFullName</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> REPORTER_FULL_NAME =
        new MaintenanceNotificationField<String>("ReporterFullName");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>PersonResponsible</b>
     * </p>
     *
     * @return Person Responsible ID
     */
    @SerializedName( "PersonResponsible" )
    @JsonProperty( "PersonResponsible" )
    @Nullable
    @ODataField( odataName = "PersonResponsible" )
    private String personResponsible;
    /**
     * Use with available fluent helpers to apply the <b>PersonResponsible</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> PERSON_RESPONSIBLE =
        new MaintenanceNotificationField<String>("PersonResponsible");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MalfunctionEffect</b>
     * </p>
     *
     * @return Effect on Operation
     */
    @SerializedName( "MalfunctionEffect" )
    @JsonProperty( "MalfunctionEffect" )
    @Nullable
    @ODataField( odataName = "MalfunctionEffect" )
    private String malfunctionEffect;
    /**
     * Use with available fluent helpers to apply the <b>MalfunctionEffect</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> MALFUNCTION_EFFECT =
        new MaintenanceNotificationField<String>("MalfunctionEffect");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MalfunctionEffectText</b>
     * </p>
     *
     * @return Text - Effect on Operation
     */
    @SerializedName( "MalfunctionEffectText" )
    @JsonProperty( "MalfunctionEffectText" )
    @Nullable
    @ODataField( odataName = "MalfunctionEffectText" )
    private String malfunctionEffectText;
    /**
     * Use with available fluent helpers to apply the <b>MalfunctionEffectText</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> MALFUNCTION_EFFECT_TEXT =
        new MaintenanceNotificationField<String>("MalfunctionEffectText");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MalfunctionStartDate</b>
     * </p>
     *
     * @return Start of Malfunction (Date)
     */
    @SerializedName( "MalfunctionStartDate" )
    @JsonProperty( "MalfunctionStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "MalfunctionStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime malfunctionStartDate;
    /**
     * Use with available fluent helpers to apply the <b>MalfunctionStartDate</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<LocalDateTime> MALFUNCTION_START_DATE =
        new MaintenanceNotificationField<LocalDateTime>("MalfunctionStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MalfunctionStartTime</b>
     * </p>
     *
     * @return Start of Malfunction (Time)
     */
    @SerializedName( "MalfunctionStartTime" )
    @JsonProperty( "MalfunctionStartTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "MalfunctionStartTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime malfunctionStartTime;
    /**
     * Use with available fluent helpers to apply the <b>MalfunctionStartTime</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<LocalTime> MALFUNCTION_START_TIME =
        new MaintenanceNotificationField<LocalTime>("MalfunctionStartTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MalfunctionEndDate</b>
     * </p>
     *
     * @return End of Malfunction (Date)
     */
    @SerializedName( "MalfunctionEndDate" )
    @JsonProperty( "MalfunctionEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "MalfunctionEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime malfunctionEndDate;
    /**
     * Use with available fluent helpers to apply the <b>MalfunctionEndDate</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<LocalDateTime> MALFUNCTION_END_DATE =
        new MaintenanceNotificationField<LocalDateTime>("MalfunctionEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MalfunctionEndTime</b>
     * </p>
     *
     * @return End of Malfunction (Time)
     */
    @SerializedName( "MalfunctionEndTime" )
    @JsonProperty( "MalfunctionEndTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "MalfunctionEndTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime malfunctionEndTime;
    /**
     * Use with available fluent helpers to apply the <b>MalfunctionEndTime</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<LocalTime> MALFUNCTION_END_TIME =
        new MaintenanceNotificationField<LocalTime>("MalfunctionEndTime");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotificationCatalog</b>
     * </p>
     *
     * @return Catalog Type - Coding
     */
    @SerializedName( "MaintNotificationCatalog" )
    @JsonProperty( "MaintNotificationCatalog" )
    @Nullable
    @ODataField( odataName = "MaintNotificationCatalog" )
    private String maintNotificationCatalog;
    /**
     * Use with available fluent helpers to apply the <b>MaintNotificationCatalog</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> MAINT_NOTIFICATION_CATALOG =
        new MaintenanceNotificationField<String>("MaintNotificationCatalog");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotificationCode</b>
     * </p>
     *
     * @return Coding
     */
    @SerializedName( "MaintNotificationCode" )
    @JsonProperty( "MaintNotificationCode" )
    @Nullable
    @ODataField( odataName = "MaintNotificationCode" )
    private String maintNotificationCode;
    /**
     * Use with available fluent helpers to apply the <b>MaintNotificationCode</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> MAINT_NOTIFICATION_CODE =
        new MaintenanceNotificationField<String>("MaintNotificationCode");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotificationCodeGroup</b>
     * </p>
     *
     * @return Code Group - Coding
     */
    @SerializedName( "MaintNotificationCodeGroup" )
    @JsonProperty( "MaintNotificationCodeGroup" )
    @Nullable
    @ODataField( odataName = "MaintNotificationCodeGroup" )
    private String maintNotificationCodeGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaintNotificationCodeGroup</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> MAINT_NOTIFICATION_CODE_GROUP =
        new MaintenanceNotificationField<String>("MaintNotificationCodeGroup");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>CatalogProfile</b>
     * </p>
     *
     * @return Catalog Profile
     */
    @SerializedName( "CatalogProfile" )
    @JsonProperty( "CatalogProfile" )
    @Nullable
    @ODataField( odataName = "CatalogProfile" )
    private String catalogProfile;
    /**
     * Use with available fluent helpers to apply the <b>CatalogProfile</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> CATALOG_PROFILE =
        new MaintenanceNotificationField<String>("CatalogProfile");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>NotificationCreationDate</b>
     * </p>
     *
     * @return Date of Notification
     */
    @SerializedName( "NotificationCreationDate" )
    @JsonProperty( "NotificationCreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "NotificationCreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime notificationCreationDate;
    /**
     * Use with available fluent helpers to apply the <b>NotificationCreationDate</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<LocalDateTime> NOTIFICATION_CREATION_DATE =
        new MaintenanceNotificationField<LocalDateTime>("NotificationCreationDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>NotificationCreationTime</b>
     * </p>
     *
     * @return Time of Notification
     */
    @SerializedName( "NotificationCreationTime" )
    @JsonProperty( "NotificationCreationTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "NotificationCreationTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime notificationCreationTime;
    /**
     * Use with available fluent helpers to apply the <b>NotificationCreationTime</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<LocalTime> NOTIFICATION_CREATION_TIME =
        new MaintenanceNotificationField<LocalTime>("NotificationCreationTime");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>NotificationTimeZone</b>
     * </p>
     *
     * @return Time Zone for Notification
     */
    @SerializedName( "NotificationTimeZone" )
    @JsonProperty( "NotificationTimeZone" )
    @Nullable
    @ODataField( odataName = "NotificationTimeZone" )
    private String notificationTimeZone;
    /**
     * Use with available fluent helpers to apply the <b>NotificationTimeZone</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> NOTIFICATION_TIME_ZONE =
        new MaintenanceNotificationField<String>("NotificationTimeZone");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequiredStartDate</b>
     * </p>
     *
     * @return Required Start Date
     */
    @SerializedName( "RequiredStartDate" )
    @JsonProperty( "RequiredStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "RequiredStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime requiredStartDate;
    /**
     * Use with available fluent helpers to apply the <b>RequiredStartDate</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<LocalDateTime> REQUIRED_START_DATE =
        new MaintenanceNotificationField<LocalDateTime>("RequiredStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequiredStartTime</b>
     * </p>
     *
     * @return Required Start Time
     */
    @SerializedName( "RequiredStartTime" )
    @JsonProperty( "RequiredStartTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "RequiredStartTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime requiredStartTime;
    /**
     * Use with available fluent helpers to apply the <b>RequiredStartTime</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<LocalTime> REQUIRED_START_TIME =
        new MaintenanceNotificationField<LocalTime>("RequiredStartTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequiredEndDate</b>
     * </p>
     *
     * @return Required End Date
     */
    @SerializedName( "RequiredEndDate" )
    @JsonProperty( "RequiredEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "RequiredEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime requiredEndDate;
    /**
     * Use with available fluent helpers to apply the <b>RequiredEndDate</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<LocalDateTime> REQUIRED_END_DATE =
        new MaintenanceNotificationField<LocalDateTime>("RequiredEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequiredEndTime</b>
     * </p>
     *
     * @return Required End Time
     */
    @SerializedName( "RequiredEndTime" )
    @JsonProperty( "RequiredEndTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "RequiredEndTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime requiredEndTime;
    /**
     * Use with available fluent helpers to apply the <b>RequiredEndTime</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<LocalTime> REQUIRED_END_TIME =
        new MaintenanceNotificationField<LocalTime>("RequiredEndTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LatestAcceptableCompletionDate</b>
     * </p>
     *
     * @return Final Due Date
     */
    @SerializedName( "LatestAcceptableCompletionDate" )
    @JsonProperty( "LatestAcceptableCompletionDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LatestAcceptableCompletionDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime latestAcceptableCompletionDate;
    /**
     * Use with available fluent helpers to apply the <b>LatestAcceptableCompletionDate</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<LocalDateTime> LATEST_ACCEPTABLE_COMPLETION_DATE =
        new MaintenanceNotificationField<LocalDateTime>("LatestAcceptableCompletionDate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceObjectIsDown</b>
     * </p>
     *
     * @return Breakdown Indicator
     */
    @SerializedName( "MaintenanceObjectIsDown" )
    @JsonProperty( "MaintenanceObjectIsDown" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "MaintenanceObjectIsDown" )
    private Boolean maintenanceObjectIsDown;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceObjectIsDown</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<Boolean> MAINTENANCE_OBJECT_IS_DOWN =
        new MaintenanceNotificationField<Boolean>("MaintenanceObjectIsDown");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotificationLongText</b>
     * </p>
     *
     * @return Long Text
     */
    @SerializedName( "MaintNotificationLongText" )
    @JsonProperty( "MaintNotificationLongText" )
    @Nullable
    @ODataField( odataName = "MaintNotificationLongText" )
    private String maintNotificationLongText;
    /**
     * Use with available fluent helpers to apply the <b>MaintNotificationLongText</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> MAINT_NOTIFICATION_LONG_TEXT =
        new MaintenanceNotificationField<String>("MaintNotificationLongText");
    /**
     * Constraints: Not nullable, Maximum length: 1333
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifLongTextForEdit</b>
     * </p>
     *
     * @return Long Text
     */
    @SerializedName( "MaintNotifLongTextForEdit" )
    @JsonProperty( "MaintNotifLongTextForEdit" )
    @Nullable
    @ODataField( odataName = "MaintNotifLongTextForEdit" )
    private String maintNotifLongTextForEdit;
    /**
     * Use with available fluent helpers to apply the <b>MaintNotifLongTextForEdit</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> MAINT_NOTIF_LONG_TEXT_FOR_EDIT =
        new MaintenanceNotificationField<String>("MaintNotifLongTextForEdit");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>TechnicalObject</b>
     * </p>
     *
     * @return Technical Object
     */
    @SerializedName( "TechnicalObject" )
    @JsonProperty( "TechnicalObject" )
    @Nullable
    @ODataField( odataName = "TechnicalObject" )
    private String technicalObject;
    /**
     * Use with available fluent helpers to apply the <b>TechnicalObject</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> TECHNICAL_OBJECT =
        new MaintenanceNotificationField<String>("TechnicalObject");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>TechObjIsEquipOrFuncnlLoc</b>
     * </p>
     *
     * @return Technical Object Type
     */
    @SerializedName( "TechObjIsEquipOrFuncnlLoc" )
    @JsonProperty( "TechObjIsEquipOrFuncnlLoc" )
    @Nullable
    @ODataField( odataName = "TechObjIsEquipOrFuncnlLoc" )
    private String techObjIsEquipOrFuncnlLoc;
    /**
     * Use with available fluent helpers to apply the <b>TechObjIsEquipOrFuncnlLoc</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> TECH_OBJ_IS_EQUIP_OR_FUNCNL_LOC =
        new MaintenanceNotificationField<String>("TechObjIsEquipOrFuncnlLoc");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>TechnicalObjectLabel</b>
     * </p>
     *
     * @return Technical Object Identifier
     */
    @SerializedName( "TechnicalObjectLabel" )
    @JsonProperty( "TechnicalObjectLabel" )
    @Nullable
    @ODataField( odataName = "TechnicalObjectLabel" )
    private String technicalObjectLabel;
    /**
     * Use with available fluent helpers to apply the <b>TechnicalObjectLabel</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> TECHNICAL_OBJECT_LABEL =
        new MaintenanceNotificationField<String>("TechnicalObjectLabel");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlanningPlant</b>
     * </p>
     *
     * @return Maintenance Planning Plant
     */
    @SerializedName( "MaintenancePlanningPlant" )
    @JsonProperty( "MaintenancePlanningPlant" )
    @Nullable
    @ODataField( odataName = "MaintenancePlanningPlant" )
    private String maintenancePlanningPlant;
    /**
     * Use with available fluent helpers to apply the <b>MaintenancePlanningPlant</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> MAINTENANCE_PLANNING_PLANT =
        new MaintenanceNotificationField<String>("MaintenancePlanningPlant");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlannerGroup</b>
     * </p>
     *
     * @return Planner Group for Customer Service and Plant Maintenance
     */
    @SerializedName( "MaintenancePlannerGroup" )
    @JsonProperty( "MaintenancePlannerGroup" )
    @Nullable
    @ODataField( odataName = "MaintenancePlannerGroup" )
    private String maintenancePlannerGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaintenancePlannerGroup</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> MAINTENANCE_PLANNER_GROUP =
        new MaintenanceNotificationField<String>("MaintenancePlannerGroup");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlantSection</b>
     * </p>
     *
     * @return Plant Section
     */
    @SerializedName( "PlantSection" )
    @JsonProperty( "PlantSection" )
    @Nullable
    @ODataField( odataName = "PlantSection" )
    private String plantSection;
    /**
     * Use with available fluent helpers to apply the <b>PlantSection</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> PLANT_SECTION =
        new MaintenanceNotificationField<String>("PlantSection");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ABCIndicator</b>
     * </p>
     *
     * @return ABC Indicator for Technical Object
     */
    @SerializedName( "ABCIndicator" )
    @JsonProperty( "ABCIndicator" )
    @Nullable
    @ODataField( odataName = "ABCIndicator" )
    private String aBCIndicator;
    /**
     * Use with available fluent helpers to apply the <b>ABCIndicator</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> ABC_INDICATOR =
        new MaintenanceNotificationField<String>("ABCIndicator");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SuperiorTechnicalObject</b>
     * </p>
     *
     * @return Technical Object
     */
    @SerializedName( "SuperiorTechnicalObject" )
    @JsonProperty( "SuperiorTechnicalObject" )
    @Nullable
    @ODataField( odataName = "SuperiorTechnicalObject" )
    private String superiorTechnicalObject;
    /**
     * Use with available fluent helpers to apply the <b>SuperiorTechnicalObject</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> SUPERIOR_TECHNICAL_OBJECT =
        new MaintenanceNotificationField<String>("SuperiorTechnicalObject");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SuperiorTechnicalObjectName</b>
     * </p>
     *
     * @return Technical Object Description
     */
    @SerializedName( "SuperiorTechnicalObjectName" )
    @JsonProperty( "SuperiorTechnicalObjectName" )
    @Nullable
    @ODataField( odataName = "SuperiorTechnicalObjectName" )
    private String superiorTechnicalObjectName;
    /**
     * Use with available fluent helpers to apply the <b>SuperiorTechnicalObjectName</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> SUPERIOR_TECHNICAL_OBJECT_NAME =
        new MaintenanceNotificationField<String>("SuperiorTechnicalObjectName");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SuperiorObjIsEquipOrFuncnlLoc</b>
     * </p>
     *
     * @return Technical Object Type
     */
    @SerializedName( "SuperiorObjIsEquipOrFuncnlLoc" )
    @JsonProperty( "SuperiorObjIsEquipOrFuncnlLoc" )
    @Nullable
    @ODataField( odataName = "SuperiorObjIsEquipOrFuncnlLoc" )
    private String superiorObjIsEquipOrFuncnlLoc;
    /**
     * Use with available fluent helpers to apply the <b>SuperiorObjIsEquipOrFuncnlLoc</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> SUPERIOR_OBJ_IS_EQUIP_OR_FUNCNL_LOC =
        new MaintenanceNotificationField<String>("SuperiorObjIsEquipOrFuncnlLoc");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SuperiorTechnicalObjectLabel</b>
     * </p>
     *
     * @return Technical Object Identifier
     */
    @SerializedName( "SuperiorTechnicalObjectLabel" )
    @JsonProperty( "SuperiorTechnicalObjectLabel" )
    @Nullable
    @ODataField( odataName = "SuperiorTechnicalObjectLabel" )
    private String superiorTechnicalObjectLabel;
    /**
     * Use with available fluent helpers to apply the <b>SuperiorTechnicalObjectLabel</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> SUPERIOR_TECHNICAL_OBJECT_LABEL =
        new MaintenanceNotificationField<String>("SuperiorTechnicalObjectLabel");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturerPartTypeName</b>
     * </p>
     *
     * @return Manufacturer model number
     */
    @SerializedName( "ManufacturerPartTypeName" )
    @JsonProperty( "ManufacturerPartTypeName" )
    @Nullable
    @ODataField( odataName = "ManufacturerPartTypeName" )
    private String manufacturerPartTypeName;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturerPartTypeName</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> MANUFACTURER_PART_TYPE_NAME =
        new MaintenanceNotificationField<String>("ManufacturerPartTypeName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>TechObjIsEquipOrFuncnlLocDesc</b>
     * </p>
     *
     * @return Description of Technical Object Type
     */
    @SerializedName( "TechObjIsEquipOrFuncnlLocDesc" )
    @JsonProperty( "TechObjIsEquipOrFuncnlLocDesc" )
    @Nullable
    @ODataField( odataName = "TechObjIsEquipOrFuncnlLocDesc" )
    private String techObjIsEquipOrFuncnlLocDesc;
    /**
     * Use with available fluent helpers to apply the <b>TechObjIsEquipOrFuncnlLocDesc</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> TECH_OBJ_IS_EQUIP_OR_FUNCNL_LOC_DESC =
        new MaintenanceNotificationField<String>("TechObjIsEquipOrFuncnlLocDesc");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocation</b>
     * </p>
     *
     * @return Object ID of Functional Location or Equipment
     */
    @SerializedName( "FunctionalLocation" )
    @JsonProperty( "FunctionalLocation" )
    @Nullable
    @ODataField( odataName = "FunctionalLocation" )
    private String functionalLocation;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalLocation</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> FUNCTIONAL_LOCATION =
        new MaintenanceNotificationField<String>("FunctionalLocation");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocationLabelName</b>
     * </p>
     *
     * @return Functional Location Label
     */
    @SerializedName( "FunctionalLocationLabelName" )
    @JsonProperty( "FunctionalLocationLabelName" )
    @Nullable
    @ODataField( odataName = "FunctionalLocationLabelName" )
    private String functionalLocationLabelName;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalLocationLabelName</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> FUNCTIONAL_LOCATION_LABEL_NAME =
        new MaintenanceNotificationField<String>("FunctionalLocationLabelName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>TechnicalObjectDescription</b>
     * </p>
     *
     * @return Technical Object Description
     */
    @SerializedName( "TechnicalObjectDescription" )
    @JsonProperty( "TechnicalObjectDescription" )
    @Nullable
    @ODataField( odataName = "TechnicalObjectDescription" )
    private String technicalObjectDescription;
    /**
     * Use with available fluent helpers to apply the <b>TechnicalObjectDescription</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> TECHNICAL_OBJECT_DESCRIPTION =
        new MaintenanceNotificationField<String>("TechnicalObjectDescription");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AssetLocation</b>
     * </p>
     *
     * @return Location of maintenance object
     */
    @SerializedName( "AssetLocation" )
    @JsonProperty( "AssetLocation" )
    @Nullable
    @ODataField( odataName = "AssetLocation" )
    private String assetLocation;
    /**
     * Use with available fluent helpers to apply the <b>AssetLocation</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> ASSET_LOCATION =
        new MaintenanceNotificationField<String>("AssetLocation");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>LocationName</b>
     * </p>
     *
     * @return Location Name
     */
    @SerializedName( "LocationName" )
    @JsonProperty( "LocationName" )
    @Nullable
    @ODataField( odataName = "LocationName" )
    private String locationName;
    /**
     * Use with available fluent helpers to apply the <b>LocationName</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> LOCATION_NAME =
        new MaintenanceNotificationField<String>("LocationName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @return Business Area
     */
    @SerializedName( "BusinessArea" )
    @JsonProperty( "BusinessArea" )
    @Nullable
    @ODataField( odataName = "BusinessArea" )
    private String businessArea;
    /**
     * Use with available fluent helpers to apply the <b>BusinessArea</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> BUSINESS_AREA =
        new MaintenanceNotificationField<String>("BusinessArea");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> COMPANY_CODE =
        new MaintenanceNotificationField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TechnicalObjectCategory</b>
     * </p>
     *
     * @return Technical Object Category
     */
    @SerializedName( "TechnicalObjectCategory" )
    @JsonProperty( "TechnicalObjectCategory" )
    @Nullable
    @ODataField( odataName = "TechnicalObjectCategory" )
    private String technicalObjectCategory;
    /**
     * Use with available fluent helpers to apply the <b>TechnicalObjectCategory</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> TECHNICAL_OBJECT_CATEGORY =
        new MaintenanceNotificationField<String>("TechnicalObjectCategory");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>TechnicalObjectType</b>
     * </p>
     *
     * @return Type of Technical Object
     */
    @SerializedName( "TechnicalObjectType" )
    @JsonProperty( "TechnicalObjectType" )
    @Nullable
    @ODataField( odataName = "TechnicalObjectType" )
    private String technicalObjectType;
    /**
     * Use with available fluent helpers to apply the <b>TechnicalObjectType</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> TECHNICAL_OBJECT_TYPE =
        new MaintenanceNotificationField<String>("TechnicalObjectType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MainWorkCenterPlant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "MainWorkCenterPlant" )
    @JsonProperty( "MainWorkCenterPlant" )
    @Nullable
    @ODataField( odataName = "MainWorkCenterPlant" )
    private String mainWorkCenterPlant;
    /**
     * Use with available fluent helpers to apply the <b>MainWorkCenterPlant</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> MAIN_WORK_CENTER_PLANT =
        new MaintenanceNotificationField<String>("MainWorkCenterPlant");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MainWorkCenter</b>
     * </p>
     *
     * @return Work Center
     */
    @SerializedName( "MainWorkCenter" )
    @JsonProperty( "MainWorkCenter" )
    @Nullable
    @ODataField( odataName = "MainWorkCenter" )
    private String mainWorkCenter;
    /**
     * Use with available fluent helpers to apply the <b>MainWorkCenter</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> MAIN_WORK_CENTER =
        new MaintenanceNotificationField<String>("MainWorkCenter");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PlantName</b>
     * </p>
     *
     * @return Plant Name
     */
    @SerializedName( "PlantName" )
    @JsonProperty( "PlantName" )
    @Nullable
    @ODataField( odataName = "PlantName" )
    private String plantName;
    /**
     * Use with available fluent helpers to apply the <b>PlantName</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> PLANT_NAME =
        new MaintenanceNotificationField<String>("PlantName");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlannerGroupName</b>
     * </p>
     *
     * @return Name of the Maintenance Planner Group
     */
    @SerializedName( "MaintenancePlannerGroupName" )
    @JsonProperty( "MaintenancePlannerGroupName" )
    @Nullable
    @ODataField( odataName = "MaintenancePlannerGroupName" )
    private String maintenancePlannerGroupName;
    /**
     * Use with available fluent helpers to apply the <b>MaintenancePlannerGroupName</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> MAINTENANCE_PLANNER_GROUP_NAME =
        new MaintenanceNotificationField<String>("MaintenancePlannerGroupName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlant</b>
     * </p>
     *
     * @return Maintenance Plant
     */
    @SerializedName( "MaintenancePlant" )
    @JsonProperty( "MaintenancePlant" )
    @Nullable
    @ODataField( odataName = "MaintenancePlant" )
    private String maintenancePlant;
    /**
     * Use with available fluent helpers to apply the <b>MaintenancePlant</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> MAINTENANCE_PLANT =
        new MaintenanceNotificationField<String>("MaintenancePlant");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>LocationDescription</b>
     * </p>
     *
     * @return Description of Current Location
     */
    @SerializedName( "LocationDescription" )
    @JsonProperty( "LocationDescription" )
    @Nullable
    @ODataField( odataName = "LocationDescription" )
    private String locationDescription;
    /**
     * Use with available fluent helpers to apply the <b>LocationDescription</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> LOCATION_DESCRIPTION =
        new MaintenanceNotificationField<String>("LocationDescription");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MainWorkCenterText</b>
     * </p>
     *
     * @return Work Center Text
     */
    @SerializedName( "MainWorkCenterText" )
    @JsonProperty( "MainWorkCenterText" )
    @Nullable
    @ODataField( odataName = "MainWorkCenterText" )
    private String mainWorkCenterText;
    /**
     * Use with available fluent helpers to apply the <b>MainWorkCenterText</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> MAIN_WORK_CENTER_TEXT =
        new MaintenanceNotificationField<String>("MainWorkCenterText");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>MainWorkCenterPlantName</b>
     * </p>
     *
     * @return Plant Name
     */
    @SerializedName( "MainWorkCenterPlantName" )
    @JsonProperty( "MainWorkCenterPlantName" )
    @Nullable
    @ODataField( odataName = "MainWorkCenterPlantName" )
    private String mainWorkCenterPlantName;
    /**
     * Use with available fluent helpers to apply the <b>MainWorkCenterPlantName</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> MAIN_WORK_CENTER_PLANT_NAME =
        new MaintenanceNotificationField<String>("MainWorkCenterPlantName");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlantName</b>
     * </p>
     *
     * @return Plant Name
     */
    @SerializedName( "MaintenancePlantName" )
    @JsonProperty( "MaintenancePlantName" )
    @Nullable
    @ODataField( odataName = "MaintenancePlantName" )
    private String maintenancePlantName;
    /**
     * Use with available fluent helpers to apply the <b>MaintenancePlantName</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> MAINTENANCE_PLANT_NAME =
        new MaintenanceNotificationField<String>("MaintenancePlantName");
    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>PlantSectionPersonRespName</b>
     * </p>
     *
     * @return Group of Employees Responsible for Company Area
     */
    @SerializedName( "PlantSectionPersonRespName" )
    @JsonProperty( "PlantSectionPersonRespName" )
    @Nullable
    @ODataField( odataName = "PlantSectionPersonRespName" )
    private String plantSectionPersonRespName;
    /**
     * Use with available fluent helpers to apply the <b>PlantSectionPersonRespName</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> PLANT_SECTION_PERSON_RESP_NAME =
        new MaintenanceNotificationField<String>("PlantSectionPersonRespName");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ABCIndicatorDesc</b>
     * </p>
     *
     * @return Description of ABC Indicator of Technical Object
     */
    @SerializedName( "ABCIndicatorDesc" )
    @JsonProperty( "ABCIndicatorDesc" )
    @Nullable
    @ODataField( odataName = "ABCIndicatorDesc" )
    private String aBCIndicatorDesc;
    /**
     * Use with available fluent helpers to apply the <b>ABCIndicatorDesc</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> ABC_INDICATOR_DESC =
        new MaintenanceNotificationField<String>("ABCIndicatorDesc");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PersonResponsibleName</b>
     * </p>
     *
     * @return Person Responsible Name
     */
    @SerializedName( "PersonResponsibleName" )
    @JsonProperty( "PersonResponsibleName" )
    @Nullable
    @ODataField( odataName = "PersonResponsibleName" )
    private String personResponsibleName;
    /**
     * Use with available fluent helpers to apply the <b>PersonResponsibleName</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> PERSON_RESPONSIBLE_NAME =
        new MaintenanceNotificationField<String>("PersonResponsibleName");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrder</b>
     * </p>
     *
     * @return Order Number
     */
    @SerializedName( "MaintenanceOrder" )
    @JsonProperty( "MaintenanceOrder" )
    @Nullable
    @ODataField( odataName = "MaintenanceOrder" )
    private String maintenanceOrder;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceOrder</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> MAINTENANCE_ORDER =
        new MaintenanceNotificationField<String>("MaintenanceOrder");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderType</b>
     * </p>
     *
     * @return Order Type
     */
    @SerializedName( "MaintenanceOrderType" )
    @JsonProperty( "MaintenanceOrderType" )
    @Nullable
    @ODataField( odataName = "MaintenanceOrderType" )
    private String maintenanceOrderType;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceOrderType</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> MAINTENANCE_ORDER_TYPE =
        new MaintenanceNotificationField<String>("MaintenanceOrderType");
    /**
     * Constraints: Not nullable, Maximum length: 224
     * <p>
     * Original property name from the Odata EDM: <b>ConcatenatedActiveSystStsName</b>
     * </p>
     *
     * @return Concatenated System Status
     */
    @SerializedName( "ConcatenatedActiveSystStsName" )
    @JsonProperty( "ConcatenatedActiveSystStsName" )
    @Nullable
    @ODataField( odataName = "ConcatenatedActiveSystStsName" )
    private String concatenatedActiveSystStsName;
    /**
     * Use with available fluent helpers to apply the <b>ConcatenatedActiveSystStsName</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> CONCATENATED_ACTIVE_SYST_STS_NAME =
        new MaintenanceNotificationField<String>("ConcatenatedActiveSystStsName");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceActivityType</b>
     * </p>
     *
     * @return Maintenance Activity Type
     */
    @SerializedName( "MaintenanceActivityType" )
    @JsonProperty( "MaintenanceActivityType" )
    @Nullable
    @ODataField( odataName = "MaintenanceActivityType" )
    private String maintenanceActivityType;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceActivityType</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> MAINTENANCE_ACTIVITY_TYPE =
        new MaintenanceNotificationField<String>("MaintenanceActivityType");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaintObjDowntimeDurationUnit</b>
     * </p>
     *
     * @return Unit for Breakdown Duration
     */
    @SerializedName( "MaintObjDowntimeDurationUnit" )
    @JsonProperty( "MaintObjDowntimeDurationUnit" )
    @Nullable
    @ODataField( odataName = "MaintObjDowntimeDurationUnit" )
    private String maintObjDowntimeDurationUnit;
    /**
     * Use with available fluent helpers to apply the <b>MaintObjDowntimeDurationUnit</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> MAINT_OBJ_DOWNTIME_DURATION_UNIT =
        new MaintenanceNotificationField<String>("MaintObjDowntimeDurationUnit");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaintObjectDowntimeDuration</b>
     * </p>
     *
     * @return Breakdown Duration
     */
    @SerializedName( "MaintObjectDowntimeDuration" )
    @JsonProperty( "MaintObjectDowntimeDuration" )
    @Nullable
    @ODataField( odataName = "MaintObjectDowntimeDuration" )
    private Double maintObjectDowntimeDuration;
    /**
     * Use with available fluent helpers to apply the <b>MaintObjectDowntimeDuration</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<Double> MAINT_OBJECT_DOWNTIME_DURATION =
        new MaintenanceNotificationField<Double>("MaintObjectDowntimeDuration");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlan</b>
     * </p>
     *
     * @return Maintenance Plan
     */
    @SerializedName( "MaintenancePlan" )
    @JsonProperty( "MaintenancePlan" )
    @Nullable
    @ODataField( odataName = "MaintenancePlan" )
    private String maintenancePlan;
    /**
     * Use with available fluent helpers to apply the <b>MaintenancePlan</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> MAINTENANCE_PLAN =
        new MaintenanceNotificationField<String>("MaintenancePlan");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceItem</b>
     * </p>
     *
     * @return Maintenance Item
     */
    @SerializedName( "MaintenanceItem" )
    @JsonProperty( "MaintenanceItem" )
    @Nullable
    @ODataField( odataName = "MaintenanceItem" )
    private String maintenanceItem;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceItem</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> MAINTENANCE_ITEM =
        new MaintenanceNotificationField<String>("MaintenanceItem");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>TaskListGroup</b>
     * </p>
     *
     * @return Key for Task List Group
     */
    @SerializedName( "TaskListGroup" )
    @JsonProperty( "TaskListGroup" )
    @Nullable
    @ODataField( odataName = "TaskListGroup" )
    private String taskListGroup;
    /**
     * Use with available fluent helpers to apply the <b>TaskListGroup</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> TASK_LIST_GROUP =
        new MaintenanceNotificationField<String>("TaskListGroup");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaskListGroupCounter</b>
     * </p>
     *
     * @return Group Counter
     */
    @SerializedName( "TaskListGroupCounter" )
    @JsonProperty( "TaskListGroupCounter" )
    @Nullable
    @ODataField( odataName = "TaskListGroupCounter" )
    private String taskListGroupCounter;
    /**
     * Use with available fluent helpers to apply the <b>TaskListGroupCounter</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> TASK_LIST_GROUP_COUNTER =
        new MaintenanceNotificationField<String>("TaskListGroupCounter");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlanCallNumber</b>
     * </p>
     *
     * @return Maintenance Plan Call Number
     */
    @SerializedName( "MaintenancePlanCallNumber" )
    @JsonProperty( "MaintenancePlanCallNumber" )
    @Nullable
    @ODataField( odataName = "MaintenancePlanCallNumber" )
    private Integer maintenancePlanCallNumber;
    /**
     * Use with available fluent helpers to apply the <b>MaintenancePlanCallNumber</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<Integer> MAINTENANCE_PLAN_CALL_NUMBER =
        new MaintenanceNotificationField<Integer>("MaintenancePlanCallNumber");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceTaskListType</b>
     * </p>
     *
     * @return Task List Type
     */
    @SerializedName( "MaintenanceTaskListType" )
    @JsonProperty( "MaintenanceTaskListType" )
    @Nullable
    @ODataField( odataName = "MaintenanceTaskListType" )
    private String maintenanceTaskListType;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceTaskListType</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> MAINTENANCE_TASK_LIST_TYPE =
        new MaintenanceNotificationField<String>("MaintenanceTaskListType");
    /**
     * Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>TaskList</b>
     * </p>
     *
     * @return The taskList contained in this entity.
     */
    @SerializedName( "TaskList" )
    @JsonProperty( "TaskList" )
    @Nullable
    @ODataField( odataName = "TaskList" )
    private String taskList;
    /**
     * Use with available fluent helpers to apply the <b>TaskList</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> TASK_LIST =
        new MaintenanceNotificationField<String>("TaskList");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>NotificationReferenceDate</b>
     * </p>
     *
     * @return Notification Reference Date
     */
    @SerializedName( "NotificationReferenceDate" )
    @JsonProperty( "NotificationReferenceDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "NotificationReferenceDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime notificationReferenceDate;
    /**
     * Use with available fluent helpers to apply the <b>NotificationReferenceDate</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<LocalDateTime> NOTIFICATION_REFERENCE_DATE =
        new MaintenanceNotificationField<LocalDateTime>("NotificationReferenceDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>NotificationReferenceTime</b>
     * </p>
     *
     * @return Notification Reference Time
     */
    @SerializedName( "NotificationReferenceTime" )
    @JsonProperty( "NotificationReferenceTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "NotificationReferenceTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime notificationReferenceTime;
    /**
     * Use with available fluent helpers to apply the <b>NotificationReferenceTime</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<LocalTime> NOTIFICATION_REFERENCE_TIME =
        new MaintenanceNotificationField<LocalTime>("NotificationReferenceTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>NotificationCompletionDate</b>
     * </p>
     *
     * @return Date for Notification Completion
     */
    @SerializedName( "NotificationCompletionDate" )
    @JsonProperty( "NotificationCompletionDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "NotificationCompletionDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime notificationCompletionDate;
    /**
     * Use with available fluent helpers to apply the <b>NotificationCompletionDate</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<LocalDateTime> NOTIFICATION_COMPLETION_DATE =
        new MaintenanceNotificationField<LocalDateTime>("NotificationCompletionDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CompletionTime</b>
     * </p>
     *
     * @return Completion Time of Notification
     */
    @SerializedName( "CompletionTime" )
    @JsonProperty( "CompletionTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "CompletionTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime completionTime;
    /**
     * Use with available fluent helpers to apply the <b>CompletionTime</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<LocalTime> COMPLETION_TIME =
        new MaintenanceNotificationField<LocalTime>("CompletionTime");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>AssetRoom</b>
     * </p>
     *
     * @return Room
     */
    @SerializedName( "AssetRoom" )
    @JsonProperty( "AssetRoom" )
    @Nullable
    @ODataField( odataName = "AssetRoom" )
    private String assetRoom;
    /**
     * Use with available fluent helpers to apply the <b>AssetRoom</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> ASSET_ROOM =
        new MaintenanceNotificationField<String>("AssetRoom");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifExtReferenceNumber</b>
     * </p>
     *
     * @return External Reference Number
     */
    @SerializedName( "MaintNotifExtReferenceNumber" )
    @JsonProperty( "MaintNotifExtReferenceNumber" )
    @Nullable
    @ODataField( odataName = "MaintNotifExtReferenceNumber" )
    private String maintNotifExtReferenceNumber;
    /**
     * Use with available fluent helpers to apply the <b>MaintNotifExtReferenceNumber</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> MAINT_NOTIF_EXT_REFERENCE_NUMBER =
        new MaintenanceNotificationField<String>("MaintNotifExtReferenceNumber");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifRejectionReasonCode</b>
     * </p>
     *
     * @return Maintenance Reason Code
     */
    @SerializedName( "MaintNotifRejectionReasonCode" )
    @JsonProperty( "MaintNotifRejectionReasonCode" )
    @Nullable
    @ODataField( odataName = "MaintNotifRejectionReasonCode" )
    private String maintNotifRejectionReasonCode;
    /**
     * Use with available fluent helpers to apply the <b>MaintNotifRejectionReasonCode</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> MAINT_NOTIF_REJECTION_REASON_CODE =
        new MaintenanceNotificationField<String>("MaintNotifRejectionReasonCode");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifRejectionRsnCodeTxt</b>
     * </p>
     *
     * @return Maintenance Reason Code Description
     */
    @SerializedName( "MaintNotifRejectionRsnCodeTxt" )
    @JsonProperty( "MaintNotifRejectionRsnCodeTxt" )
    @Nullable
    @ODataField( odataName = "MaintNotifRejectionRsnCodeTxt" )
    private String maintNotifRejectionRsnCodeTxt;
    /**
     * Use with available fluent helpers to apply the <b>MaintNotifRejectionRsnCodeTxt</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> MAINT_NOTIF_REJECTION_RSN_CODE_TXT =
        new MaintenanceNotificationField<String>("MaintNotifRejectionRsnCodeTxt");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifDetectionCatalog</b>
     * </p>
     *
     * @return Detection Method Profile
     */
    @SerializedName( "MaintNotifDetectionCatalog" )
    @JsonProperty( "MaintNotifDetectionCatalog" )
    @Nullable
    @ODataField( odataName = "MaintNotifDetectionCatalog" )
    private String maintNotifDetectionCatalog;
    /**
     * Use with available fluent helpers to apply the <b>MaintNotifDetectionCatalog</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> MAINT_NOTIF_DETECTION_CATALOG =
        new MaintenanceNotificationField<String>("MaintNotifDetectionCatalog");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifDetectionCode</b>
     * </p>
     *
     * @return Detection Method
     */
    @SerializedName( "MaintNotifDetectionCode" )
    @JsonProperty( "MaintNotifDetectionCode" )
    @Nullable
    @ODataField( odataName = "MaintNotifDetectionCode" )
    private String maintNotifDetectionCode;
    /**
     * Use with available fluent helpers to apply the <b>MaintNotifDetectionCode</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> MAINT_NOTIF_DETECTION_CODE =
        new MaintenanceNotificationField<String>("MaintNotifDetectionCode");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifDetectionCodeText</b>
     * </p>
     *
     * @return Detection Method Description
     */
    @SerializedName( "MaintNotifDetectionCodeText" )
    @JsonProperty( "MaintNotifDetectionCodeText" )
    @Nullable
    @ODataField( odataName = "MaintNotifDetectionCodeText" )
    private String maintNotifDetectionCodeText;
    /**
     * Use with available fluent helpers to apply the <b>MaintNotifDetectionCodeText</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> MAINT_NOTIF_DETECTION_CODE_TEXT =
        new MaintenanceNotificationField<String>("MaintNotifDetectionCodeText");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifDetectionCodeGroup</b>
     * </p>
     *
     * @return Detection Method Group
     */
    @SerializedName( "MaintNotifDetectionCodeGroup" )
    @JsonProperty( "MaintNotifDetectionCodeGroup" )
    @Nullable
    @ODataField( odataName = "MaintNotifDetectionCodeGroup" )
    private String maintNotifDetectionCodeGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaintNotifDetectionCodeGroup</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> MAINT_NOTIF_DETECTION_CODE_GROUP =
        new MaintenanceNotificationField<String>("MaintNotifDetectionCodeGroup");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifDetectionCodeGrpTxt</b>
     * </p>
     *
     * @return Detection Method Group Description
     */
    @SerializedName( "MaintNotifDetectionCodeGrpTxt" )
    @JsonProperty( "MaintNotifDetectionCodeGrpTxt" )
    @Nullable
    @ODataField( odataName = "MaintNotifDetectionCodeGrpTxt" )
    private String maintNotifDetectionCodeGrpTxt;
    /**
     * Use with available fluent helpers to apply the <b>MaintNotifDetectionCodeGrpTxt</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> MAINT_NOTIF_DETECTION_CODE_GRP_TXT =
        new MaintenanceNotificationField<String>("MaintNotifDetectionCodeGrpTxt");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifProcessPhaseCode</b>
     * </p>
     *
     * @return Process Phase
     */
    @SerializedName( "MaintNotifProcessPhaseCode" )
    @JsonProperty( "MaintNotifProcessPhaseCode" )
    @Nullable
    @ODataField( odataName = "MaintNotifProcessPhaseCode" )
    private String maintNotifProcessPhaseCode;
    /**
     * Use with available fluent helpers to apply the <b>MaintNotifProcessPhaseCode</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> MAINT_NOTIF_PROCESS_PHASE_CODE =
        new MaintenanceNotificationField<String>("MaintNotifProcessPhaseCode");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifProcessSubPhaseCode</b>
     * </p>
     *
     * @return Process Subphase
     */
    @SerializedName( "MaintNotifProcessSubPhaseCode" )
    @JsonProperty( "MaintNotifProcessSubPhaseCode" )
    @Nullable
    @ODataField( odataName = "MaintNotifProcessSubPhaseCode" )
    private String maintNotifProcessSubPhaseCode;
    /**
     * Use with available fluent helpers to apply the <b>MaintNotifProcessSubPhaseCode</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> MAINT_NOTIF_PROCESS_SUB_PHASE_CODE =
        new MaintenanceNotificationField<String>("MaintNotifProcessSubPhaseCode");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>EAMProcessPhaseCodeDesc</b>
     * </p>
     *
     * @return Short Text for Fixed Values
     */
    @SerializedName( "EAMProcessPhaseCodeDesc" )
    @JsonProperty( "EAMProcessPhaseCodeDesc" )
    @Nullable
    @ODataField( odataName = "EAMProcessPhaseCodeDesc" )
    private String eAMProcessPhaseCodeDesc;
    /**
     * Use with available fluent helpers to apply the <b>EAMProcessPhaseCodeDesc</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> EAM_PROCESS_PHASE_CODE_DESC =
        new MaintenanceNotificationField<String>("EAMProcessPhaseCodeDesc");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>EAMProcessSubPhaseCodeDesc</b>
     * </p>
     *
     * @return Description of Overall Process Subphase
     */
    @SerializedName( "EAMProcessSubPhaseCodeDesc" )
    @JsonProperty( "EAMProcessSubPhaseCodeDesc" )
    @Nullable
    @ODataField( odataName = "EAMProcessSubPhaseCodeDesc" )
    private String eAMProcessSubPhaseCodeDesc;
    /**
     * Use with available fluent helpers to apply the <b>EAMProcessSubPhaseCodeDesc</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<String> EAM_PROCESS_SUB_PHASE_CODE_DESC =
        new MaintenanceNotificationField<String>("EAMProcessSubPhaseCodeDesc");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "CreationDateTime" )
    @JsonProperty( "CreationDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime creationDateTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationDateTime</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<ZonedDateTime> CREATION_DATE_TIME =
        new MaintenanceNotificationField<ZonedDateTime>("CreationDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MalfunctionStartDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "MalfunctionStartDateTime" )
    @JsonProperty( "MalfunctionStartDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "MalfunctionStartDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime malfunctionStartDateTime;
    /**
     * Use with available fluent helpers to apply the <b>MalfunctionStartDateTime</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<ZonedDateTime> MALFUNCTION_START_DATE_TIME =
        new MaintenanceNotificationField<ZonedDateTime>("MalfunctionStartDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MalfunctionEndDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "MalfunctionEndDateTime" )
    @JsonProperty( "MalfunctionEndDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "MalfunctionEndDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime malfunctionEndDateTime;
    /**
     * Use with available fluent helpers to apply the <b>MalfunctionEndDateTime</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<ZonedDateTime> MALFUNCTION_END_DATE_TIME =
        new MaintenanceNotificationField<ZonedDateTime>("MalfunctionEndDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>NotificationCreationDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "NotificationCreationDateTime" )
    @JsonProperty( "NotificationCreationDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "NotificationCreationDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime notificationCreationDateTime;
    /**
     * Use with available fluent helpers to apply the <b>NotificationCreationDateTime</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<ZonedDateTime> NOTIFICATION_CREATION_DATE_TIME =
        new MaintenanceNotificationField<ZonedDateTime>("NotificationCreationDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifRqdStartDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "MaintNotifRqdStartDateTime" )
    @JsonProperty( "MaintNotifRqdStartDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "MaintNotifRqdStartDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime maintNotifRqdStartDateTime;
    /**
     * Use with available fluent helpers to apply the <b>MaintNotifRqdStartDateTime</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<ZonedDateTime> MAINT_NOTIF_RQD_START_DATE_TIME =
        new MaintenanceNotificationField<ZonedDateTime>("MaintNotifRqdStartDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifRqdEndDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "MaintNotifRqdEndDateTime" )
    @JsonProperty( "MaintNotifRqdEndDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "MaintNotifRqdEndDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime maintNotifRqdEndDateTime;
    /**
     * Use with available fluent helpers to apply the <b>MaintNotifRqdEndDateTime</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<ZonedDateTime> MAINT_NOTIF_RQD_END_DATE_TIME =
        new MaintenanceNotificationField<ZonedDateTime>("MaintNotifRqdEndDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PreviousFinalDueDate</b>
     * </p>
     *
     * @return Previous Final Due Date
     */
    @SerializedName( "PreviousFinalDueDate" )
    @JsonProperty( "PreviousFinalDueDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PreviousFinalDueDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime previousFinalDueDate;
    /**
     * Use with available fluent helpers to apply the <b>PreviousFinalDueDate</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationField<LocalDateTime> PREVIOUS_FINAL_DUE_DATE =
        new MaintenanceNotificationField<LocalDateTime>("PreviousFinalDueDate");
    /**
     * Navigation property <b>to_Item</b> for <b>MaintenanceNotification</b> to multiple
     * <b>MaintenanceNotificationItem</b>.
     *
     */
    @SerializedName( "to_Item" )
    @JsonProperty( "to_Item" )
    @ODataField( odataName = "to_Item" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MaintenanceNotificationItem> toItem;
    /**
     * Navigation property <b>to_Partner</b> for <b>MaintenanceNotification</b> to multiple
     * <b>MaintenanceNotificationPartner</b>.
     *
     */
    @SerializedName( "to_Partner" )
    @JsonProperty( "to_Partner" )
    @ODataField( odataName = "to_Partner" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MaintenanceNotificationPartner> toPartner;
    /**
     * Use with available fluent helpers to apply the <b>to_Item</b> navigation property to query operations.
     *
     */
    public final static MaintenanceNotificationLink<MaintenanceNotificationItem> TO_ITEM =
        new MaintenanceNotificationLink<MaintenanceNotificationItem>("to_Item");
    /**
     * Use with available fluent helpers to apply the <b>to_Partner</b> navigation property to query operations.
     *
     */
    public final static MaintenanceNotificationLink<MaintenanceNotificationPartner> TO_PARTNER =
        new MaintenanceNotificationLink<MaintenanceNotificationPartner>("to_Partner");

    @Nonnull
    @Override
    public Class<MaintenanceNotification> getType()
    {
        return MaintenanceNotification.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceNotification</b>
     * </p>
     *
     * @param maintenanceNotification
     *            Notification Number
     */
    public void setMaintenanceNotification( @Nullable final String maintenanceNotification )
    {
        rememberChangedField("MaintenanceNotification", this.maintenanceNotification);
        this.maintenanceNotification = maintenanceNotification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifInternalID</b>
     * </p>
     *
     * @param maintNotifInternalID
     *            Object Number for Status Management
     */
    public void setMaintNotifInternalID( @Nullable final String maintNotifInternalID )
    {
        rememberChangedField("MaintNotifInternalID", this.maintNotifInternalID);
        this.maintNotifInternalID = maintNotifInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>NotificationText</b>
     * </p>
     *
     * @param notificationText
     *            Short Text
     */
    public void setNotificationText( @Nullable final String notificationText )
    {
        rememberChangedField("NotificationText", this.notificationText);
        this.notificationText = notificationText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintPriority</b>
     * </p>
     *
     * @param maintPriority
     *            Priority
     */
    public void setMaintPriority( @Nullable final String maintPriority )
    {
        rememberChangedField("MaintPriority", this.maintPriority);
        this.maintPriority = maintPriority;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>NotificationType</b>
     * </p>
     *
     * @param notificationType
     *            Notification Type
     */
    public void setNotificationType( @Nullable final String notificationType )
    {
        rememberChangedField("NotificationType", this.notificationType);
        this.notificationType = notificationType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NotifProcessingPhase</b>
     * </p>
     *
     * @param notifProcessingPhase
     *            Notification Processing Phase
     */
    public void setNotifProcessingPhase( @Nullable final String notifProcessingPhase )
    {
        rememberChangedField("NotifProcessingPhase", this.notifProcessingPhase);
        this.notifProcessingPhase = notifProcessingPhase;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>NotifProcessingPhaseDesc</b>
     * </p>
     *
     * @param notifProcessingPhaseDesc
     *            Short Text for Fixed Values
     */
    public void setNotifProcessingPhaseDesc( @Nullable final String notifProcessingPhaseDesc )
    {
        rememberChangedField("NotifProcessingPhaseDesc", this.notifProcessingPhaseDesc);
        this.notifProcessingPhaseDesc = notifProcessingPhaseDesc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>MaintPriorityDesc</b>
     * </p>
     *
     * @param maintPriorityDesc
     *            Priority Text
     */
    public void setMaintPriorityDesc( @Nullable final String maintPriorityDesc )
    {
        rememberChangedField("MaintPriorityDesc", this.maintPriorityDesc);
        this.maintPriorityDesc = maintPriorityDesc;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Record Created On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeTime</b>
     * </p>
     *
     * @param lastChangeTime
     *            Time of Change
     */
    public void setLastChangeTime( @Nullable final LocalTime lastChangeTime )
    {
        rememberChangedField("LastChangeTime", this.lastChangeTime);
        this.lastChangeTime = lastChangeTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Last Changed On
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     *
     * @param creationTime
     *            Time at Which Record Was Added
     */
    public void setCreationTime( @Nullable final LocalTime creationTime )
    {
        rememberChangedField("CreationTime", this.creationTime);
        this.creationTime = creationTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ReportedByUser</b>
     * </p>
     *
     * @param reportedByUser
     *            Name of Person Reporting Notification
     */
    public void setReportedByUser( @Nullable final String reportedByUser )
    {
        rememberChangedField("ReportedByUser", this.reportedByUser);
        this.reportedByUser = reportedByUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>ReporterFullName</b>
     * </p>
     *
     * @param reporterFullName
     *            Full Name of Person
     */
    public void setReporterFullName( @Nullable final String reporterFullName )
    {
        rememberChangedField("ReporterFullName", this.reporterFullName);
        this.reporterFullName = reporterFullName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>PersonResponsible</b>
     * </p>
     *
     * @param personResponsible
     *            Person Responsible ID
     */
    public void setPersonResponsible( @Nullable final String personResponsible )
    {
        rememberChangedField("PersonResponsible", this.personResponsible);
        this.personResponsible = personResponsible;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MalfunctionEffect</b>
     * </p>
     *
     * @param malfunctionEffect
     *            Effect on Operation
     */
    public void setMalfunctionEffect( @Nullable final String malfunctionEffect )
    {
        rememberChangedField("MalfunctionEffect", this.malfunctionEffect);
        this.malfunctionEffect = malfunctionEffect;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MalfunctionEffectText</b>
     * </p>
     *
     * @param malfunctionEffectText
     *            Text - Effect on Operation
     */
    public void setMalfunctionEffectText( @Nullable final String malfunctionEffectText )
    {
        rememberChangedField("MalfunctionEffectText", this.malfunctionEffectText);
        this.malfunctionEffectText = malfunctionEffectText;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MalfunctionStartDate</b>
     * </p>
     *
     * @param malfunctionStartDate
     *            Start of Malfunction (Date)
     */
    public void setMalfunctionStartDate( @Nullable final LocalDateTime malfunctionStartDate )
    {
        rememberChangedField("MalfunctionStartDate", this.malfunctionStartDate);
        this.malfunctionStartDate = malfunctionStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MalfunctionStartTime</b>
     * </p>
     *
     * @param malfunctionStartTime
     *            Start of Malfunction (Time)
     */
    public void setMalfunctionStartTime( @Nullable final LocalTime malfunctionStartTime )
    {
        rememberChangedField("MalfunctionStartTime", this.malfunctionStartTime);
        this.malfunctionStartTime = malfunctionStartTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MalfunctionEndDate</b>
     * </p>
     *
     * @param malfunctionEndDate
     *            End of Malfunction (Date)
     */
    public void setMalfunctionEndDate( @Nullable final LocalDateTime malfunctionEndDate )
    {
        rememberChangedField("MalfunctionEndDate", this.malfunctionEndDate);
        this.malfunctionEndDate = malfunctionEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MalfunctionEndTime</b>
     * </p>
     *
     * @param malfunctionEndTime
     *            End of Malfunction (Time)
     */
    public void setMalfunctionEndTime( @Nullable final LocalTime malfunctionEndTime )
    {
        rememberChangedField("MalfunctionEndTime", this.malfunctionEndTime);
        this.malfunctionEndTime = malfunctionEndTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotificationCatalog</b>
     * </p>
     *
     * @param maintNotificationCatalog
     *            Catalog Type - Coding
     */
    public void setMaintNotificationCatalog( @Nullable final String maintNotificationCatalog )
    {
        rememberChangedField("MaintNotificationCatalog", this.maintNotificationCatalog);
        this.maintNotificationCatalog = maintNotificationCatalog;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotificationCode</b>
     * </p>
     *
     * @param maintNotificationCode
     *            Coding
     */
    public void setMaintNotificationCode( @Nullable final String maintNotificationCode )
    {
        rememberChangedField("MaintNotificationCode", this.maintNotificationCode);
        this.maintNotificationCode = maintNotificationCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotificationCodeGroup</b>
     * </p>
     *
     * @param maintNotificationCodeGroup
     *            Code Group - Coding
     */
    public void setMaintNotificationCodeGroup( @Nullable final String maintNotificationCodeGroup )
    {
        rememberChangedField("MaintNotificationCodeGroup", this.maintNotificationCodeGroup);
        this.maintNotificationCodeGroup = maintNotificationCodeGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>CatalogProfile</b>
     * </p>
     *
     * @param catalogProfile
     *            Catalog Profile
     */
    public void setCatalogProfile( @Nullable final String catalogProfile )
    {
        rememberChangedField("CatalogProfile", this.catalogProfile);
        this.catalogProfile = catalogProfile;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>NotificationCreationDate</b>
     * </p>
     *
     * @param notificationCreationDate
     *            Date of Notification
     */
    public void setNotificationCreationDate( @Nullable final LocalDateTime notificationCreationDate )
    {
        rememberChangedField("NotificationCreationDate", this.notificationCreationDate);
        this.notificationCreationDate = notificationCreationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>NotificationCreationTime</b>
     * </p>
     *
     * @param notificationCreationTime
     *            Time of Notification
     */
    public void setNotificationCreationTime( @Nullable final LocalTime notificationCreationTime )
    {
        rememberChangedField("NotificationCreationTime", this.notificationCreationTime);
        this.notificationCreationTime = notificationCreationTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>NotificationTimeZone</b>
     * </p>
     *
     * @param notificationTimeZone
     *            Time Zone for Notification
     */
    public void setNotificationTimeZone( @Nullable final String notificationTimeZone )
    {
        rememberChangedField("NotificationTimeZone", this.notificationTimeZone);
        this.notificationTimeZone = notificationTimeZone;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequiredStartDate</b>
     * </p>
     *
     * @param requiredStartDate
     *            Required Start Date
     */
    public void setRequiredStartDate( @Nullable final LocalDateTime requiredStartDate )
    {
        rememberChangedField("RequiredStartDate", this.requiredStartDate);
        this.requiredStartDate = requiredStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequiredStartTime</b>
     * </p>
     *
     * @param requiredStartTime
     *            Required Start Time
     */
    public void setRequiredStartTime( @Nullable final LocalTime requiredStartTime )
    {
        rememberChangedField("RequiredStartTime", this.requiredStartTime);
        this.requiredStartTime = requiredStartTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequiredEndDate</b>
     * </p>
     *
     * @param requiredEndDate
     *            Required End Date
     */
    public void setRequiredEndDate( @Nullable final LocalDateTime requiredEndDate )
    {
        rememberChangedField("RequiredEndDate", this.requiredEndDate);
        this.requiredEndDate = requiredEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequiredEndTime</b>
     * </p>
     *
     * @param requiredEndTime
     *            Required End Time
     */
    public void setRequiredEndTime( @Nullable final LocalTime requiredEndTime )
    {
        rememberChangedField("RequiredEndTime", this.requiredEndTime);
        this.requiredEndTime = requiredEndTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LatestAcceptableCompletionDate</b>
     * </p>
     *
     * @param latestAcceptableCompletionDate
     *            Final Due Date
     */
    public void setLatestAcceptableCompletionDate( @Nullable final LocalDateTime latestAcceptableCompletionDate )
    {
        rememberChangedField("LatestAcceptableCompletionDate", this.latestAcceptableCompletionDate);
        this.latestAcceptableCompletionDate = latestAcceptableCompletionDate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceObjectIsDown</b>
     * </p>
     *
     * @param maintenanceObjectIsDown
     *            Breakdown Indicator
     */
    public void setMaintenanceObjectIsDown( @Nullable final Boolean maintenanceObjectIsDown )
    {
        rememberChangedField("MaintenanceObjectIsDown", this.maintenanceObjectIsDown);
        this.maintenanceObjectIsDown = maintenanceObjectIsDown;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotificationLongText</b>
     * </p>
     *
     * @param maintNotificationLongText
     *            Long Text
     */
    public void setMaintNotificationLongText( @Nullable final String maintNotificationLongText )
    {
        rememberChangedField("MaintNotificationLongText", this.maintNotificationLongText);
        this.maintNotificationLongText = maintNotificationLongText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1333
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifLongTextForEdit</b>
     * </p>
     *
     * @param maintNotifLongTextForEdit
     *            Long Text
     */
    public void setMaintNotifLongTextForEdit( @Nullable final String maintNotifLongTextForEdit )
    {
        rememberChangedField("MaintNotifLongTextForEdit", this.maintNotifLongTextForEdit);
        this.maintNotifLongTextForEdit = maintNotifLongTextForEdit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>TechnicalObject</b>
     * </p>
     *
     * @param technicalObject
     *            Technical Object
     */
    public void setTechnicalObject( @Nullable final String technicalObject )
    {
        rememberChangedField("TechnicalObject", this.technicalObject);
        this.technicalObject = technicalObject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>TechObjIsEquipOrFuncnlLoc</b>
     * </p>
     *
     * @param techObjIsEquipOrFuncnlLoc
     *            Technical Object Type
     */
    public void setTechObjIsEquipOrFuncnlLoc( @Nullable final String techObjIsEquipOrFuncnlLoc )
    {
        rememberChangedField("TechObjIsEquipOrFuncnlLoc", this.techObjIsEquipOrFuncnlLoc);
        this.techObjIsEquipOrFuncnlLoc = techObjIsEquipOrFuncnlLoc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>TechnicalObjectLabel</b>
     * </p>
     *
     * @param technicalObjectLabel
     *            Technical Object Identifier
     */
    public void setTechnicalObjectLabel( @Nullable final String technicalObjectLabel )
    {
        rememberChangedField("TechnicalObjectLabel", this.technicalObjectLabel);
        this.technicalObjectLabel = technicalObjectLabel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlanningPlant</b>
     * </p>
     *
     * @param maintenancePlanningPlant
     *            Maintenance Planning Plant
     */
    public void setMaintenancePlanningPlant( @Nullable final String maintenancePlanningPlant )
    {
        rememberChangedField("MaintenancePlanningPlant", this.maintenancePlanningPlant);
        this.maintenancePlanningPlant = maintenancePlanningPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlannerGroup</b>
     * </p>
     *
     * @param maintenancePlannerGroup
     *            Planner Group for Customer Service and Plant Maintenance
     */
    public void setMaintenancePlannerGroup( @Nullable final String maintenancePlannerGroup )
    {
        rememberChangedField("MaintenancePlannerGroup", this.maintenancePlannerGroup);
        this.maintenancePlannerGroup = maintenancePlannerGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlantSection</b>
     * </p>
     *
     * @param plantSection
     *            Plant Section
     */
    public void setPlantSection( @Nullable final String plantSection )
    {
        rememberChangedField("PlantSection", this.plantSection);
        this.plantSection = plantSection;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ABCIndicator</b>
     * </p>
     *
     * @param aBCIndicator
     *            ABC Indicator for Technical Object
     */
    public void setABCIndicator( @Nullable final String aBCIndicator )
    {
        rememberChangedField("ABCIndicator", this.aBCIndicator);
        this.aBCIndicator = aBCIndicator;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SuperiorTechnicalObject</b>
     * </p>
     *
     * @param superiorTechnicalObject
     *            Technical Object
     */
    public void setSuperiorTechnicalObject( @Nullable final String superiorTechnicalObject )
    {
        rememberChangedField("SuperiorTechnicalObject", this.superiorTechnicalObject);
        this.superiorTechnicalObject = superiorTechnicalObject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SuperiorTechnicalObjectName</b>
     * </p>
     *
     * @param superiorTechnicalObjectName
     *            Technical Object Description
     */
    public void setSuperiorTechnicalObjectName( @Nullable final String superiorTechnicalObjectName )
    {
        rememberChangedField("SuperiorTechnicalObjectName", this.superiorTechnicalObjectName);
        this.superiorTechnicalObjectName = superiorTechnicalObjectName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SuperiorObjIsEquipOrFuncnlLoc</b>
     * </p>
     *
     * @param superiorObjIsEquipOrFuncnlLoc
     *            Technical Object Type
     */
    public void setSuperiorObjIsEquipOrFuncnlLoc( @Nullable final String superiorObjIsEquipOrFuncnlLoc )
    {
        rememberChangedField("SuperiorObjIsEquipOrFuncnlLoc", this.superiorObjIsEquipOrFuncnlLoc);
        this.superiorObjIsEquipOrFuncnlLoc = superiorObjIsEquipOrFuncnlLoc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SuperiorTechnicalObjectLabel</b>
     * </p>
     *
     * @param superiorTechnicalObjectLabel
     *            Technical Object Identifier
     */
    public void setSuperiorTechnicalObjectLabel( @Nullable final String superiorTechnicalObjectLabel )
    {
        rememberChangedField("SuperiorTechnicalObjectLabel", this.superiorTechnicalObjectLabel);
        this.superiorTechnicalObjectLabel = superiorTechnicalObjectLabel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturerPartTypeName</b>
     * </p>
     *
     * @param manufacturerPartTypeName
     *            Manufacturer model number
     */
    public void setManufacturerPartTypeName( @Nullable final String manufacturerPartTypeName )
    {
        rememberChangedField("ManufacturerPartTypeName", this.manufacturerPartTypeName);
        this.manufacturerPartTypeName = manufacturerPartTypeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>TechObjIsEquipOrFuncnlLocDesc</b>
     * </p>
     *
     * @param techObjIsEquipOrFuncnlLocDesc
     *            Description of Technical Object Type
     */
    public void setTechObjIsEquipOrFuncnlLocDesc( @Nullable final String techObjIsEquipOrFuncnlLocDesc )
    {
        rememberChangedField("TechObjIsEquipOrFuncnlLocDesc", this.techObjIsEquipOrFuncnlLocDesc);
        this.techObjIsEquipOrFuncnlLocDesc = techObjIsEquipOrFuncnlLocDesc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocation</b>
     * </p>
     *
     * @param functionalLocation
     *            Object ID of Functional Location or Equipment
     */
    public void setFunctionalLocation( @Nullable final String functionalLocation )
    {
        rememberChangedField("FunctionalLocation", this.functionalLocation);
        this.functionalLocation = functionalLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocationLabelName</b>
     * </p>
     *
     * @param functionalLocationLabelName
     *            Functional Location Label
     */
    public void setFunctionalLocationLabelName( @Nullable final String functionalLocationLabelName )
    {
        rememberChangedField("FunctionalLocationLabelName", this.functionalLocationLabelName);
        this.functionalLocationLabelName = functionalLocationLabelName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>TechnicalObjectDescription</b>
     * </p>
     *
     * @param technicalObjectDescription
     *            Technical Object Description
     */
    public void setTechnicalObjectDescription( @Nullable final String technicalObjectDescription )
    {
        rememberChangedField("TechnicalObjectDescription", this.technicalObjectDescription);
        this.technicalObjectDescription = technicalObjectDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AssetLocation</b>
     * </p>
     *
     * @param assetLocation
     *            Location of maintenance object
     */
    public void setAssetLocation( @Nullable final String assetLocation )
    {
        rememberChangedField("AssetLocation", this.assetLocation);
        this.assetLocation = assetLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>LocationName</b>
     * </p>
     *
     * @param locationName
     *            Location Name
     */
    public void setLocationName( @Nullable final String locationName )
    {
        rememberChangedField("LocationName", this.locationName);
        this.locationName = locationName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @param businessArea
     *            Business Area
     */
    public void setBusinessArea( @Nullable final String businessArea )
    {
        rememberChangedField("BusinessArea", this.businessArea);
        this.businessArea = businessArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TechnicalObjectCategory</b>
     * </p>
     *
     * @param technicalObjectCategory
     *            Technical Object Category
     */
    public void setTechnicalObjectCategory( @Nullable final String technicalObjectCategory )
    {
        rememberChangedField("TechnicalObjectCategory", this.technicalObjectCategory);
        this.technicalObjectCategory = technicalObjectCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>TechnicalObjectType</b>
     * </p>
     *
     * @param technicalObjectType
     *            Type of Technical Object
     */
    public void setTechnicalObjectType( @Nullable final String technicalObjectType )
    {
        rememberChangedField("TechnicalObjectType", this.technicalObjectType);
        this.technicalObjectType = technicalObjectType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MainWorkCenterPlant</b>
     * </p>
     *
     * @param mainWorkCenterPlant
     *            Plant
     */
    public void setMainWorkCenterPlant( @Nullable final String mainWorkCenterPlant )
    {
        rememberChangedField("MainWorkCenterPlant", this.mainWorkCenterPlant);
        this.mainWorkCenterPlant = mainWorkCenterPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MainWorkCenter</b>
     * </p>
     *
     * @param mainWorkCenter
     *            Work Center
     */
    public void setMainWorkCenter( @Nullable final String mainWorkCenter )
    {
        rememberChangedField("MainWorkCenter", this.mainWorkCenter);
        this.mainWorkCenter = mainWorkCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PlantName</b>
     * </p>
     *
     * @param plantName
     *            Plant Name
     */
    public void setPlantName( @Nullable final String plantName )
    {
        rememberChangedField("PlantName", this.plantName);
        this.plantName = plantName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlannerGroupName</b>
     * </p>
     *
     * @param maintenancePlannerGroupName
     *            Name of the Maintenance Planner Group
     */
    public void setMaintenancePlannerGroupName( @Nullable final String maintenancePlannerGroupName )
    {
        rememberChangedField("MaintenancePlannerGroupName", this.maintenancePlannerGroupName);
        this.maintenancePlannerGroupName = maintenancePlannerGroupName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlant</b>
     * </p>
     *
     * @param maintenancePlant
     *            Maintenance Plant
     */
    public void setMaintenancePlant( @Nullable final String maintenancePlant )
    {
        rememberChangedField("MaintenancePlant", this.maintenancePlant);
        this.maintenancePlant = maintenancePlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>LocationDescription</b>
     * </p>
     *
     * @param locationDescription
     *            Description of Current Location
     */
    public void setLocationDescription( @Nullable final String locationDescription )
    {
        rememberChangedField("LocationDescription", this.locationDescription);
        this.locationDescription = locationDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MainWorkCenterText</b>
     * </p>
     *
     * @param mainWorkCenterText
     *            Work Center Text
     */
    public void setMainWorkCenterText( @Nullable final String mainWorkCenterText )
    {
        rememberChangedField("MainWorkCenterText", this.mainWorkCenterText);
        this.mainWorkCenterText = mainWorkCenterText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>MainWorkCenterPlantName</b>
     * </p>
     *
     * @param mainWorkCenterPlantName
     *            Plant Name
     */
    public void setMainWorkCenterPlantName( @Nullable final String mainWorkCenterPlantName )
    {
        rememberChangedField("MainWorkCenterPlantName", this.mainWorkCenterPlantName);
        this.mainWorkCenterPlantName = mainWorkCenterPlantName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlantName</b>
     * </p>
     *
     * @param maintenancePlantName
     *            Plant Name
     */
    public void setMaintenancePlantName( @Nullable final String maintenancePlantName )
    {
        rememberChangedField("MaintenancePlantName", this.maintenancePlantName);
        this.maintenancePlantName = maintenancePlantName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>PlantSectionPersonRespName</b>
     * </p>
     *
     * @param plantSectionPersonRespName
     *            Group of Employees Responsible for Company Area
     */
    public void setPlantSectionPersonRespName( @Nullable final String plantSectionPersonRespName )
    {
        rememberChangedField("PlantSectionPersonRespName", this.plantSectionPersonRespName);
        this.plantSectionPersonRespName = plantSectionPersonRespName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ABCIndicatorDesc</b>
     * </p>
     *
     * @param aBCIndicatorDesc
     *            Description of ABC Indicator of Technical Object
     */
    public void setABCIndicatorDesc( @Nullable final String aBCIndicatorDesc )
    {
        rememberChangedField("ABCIndicatorDesc", this.aBCIndicatorDesc);
        this.aBCIndicatorDesc = aBCIndicatorDesc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PersonResponsibleName</b>
     * </p>
     *
     * @param personResponsibleName
     *            Person Responsible Name
     */
    public void setPersonResponsibleName( @Nullable final String personResponsibleName )
    {
        rememberChangedField("PersonResponsibleName", this.personResponsibleName);
        this.personResponsibleName = personResponsibleName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrder</b>
     * </p>
     *
     * @param maintenanceOrder
     *            Order Number
     */
    public void setMaintenanceOrder( @Nullable final String maintenanceOrder )
    {
        rememberChangedField("MaintenanceOrder", this.maintenanceOrder);
        this.maintenanceOrder = maintenanceOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderType</b>
     * </p>
     *
     * @param maintenanceOrderType
     *            Order Type
     */
    public void setMaintenanceOrderType( @Nullable final String maintenanceOrderType )
    {
        rememberChangedField("MaintenanceOrderType", this.maintenanceOrderType);
        this.maintenanceOrderType = maintenanceOrderType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 224
     * <p>
     * Original property name from the Odata EDM: <b>ConcatenatedActiveSystStsName</b>
     * </p>
     *
     * @param concatenatedActiveSystStsName
     *            Concatenated System Status
     */
    public void setConcatenatedActiveSystStsName( @Nullable final String concatenatedActiveSystStsName )
    {
        rememberChangedField("ConcatenatedActiveSystStsName", this.concatenatedActiveSystStsName);
        this.concatenatedActiveSystStsName = concatenatedActiveSystStsName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceActivityType</b>
     * </p>
     *
     * @param maintenanceActivityType
     *            Maintenance Activity Type
     */
    public void setMaintenanceActivityType( @Nullable final String maintenanceActivityType )
    {
        rememberChangedField("MaintenanceActivityType", this.maintenanceActivityType);
        this.maintenanceActivityType = maintenanceActivityType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaintObjDowntimeDurationUnit</b>
     * </p>
     *
     * @param maintObjDowntimeDurationUnit
     *            Unit for Breakdown Duration
     */
    public void setMaintObjDowntimeDurationUnit( @Nullable final String maintObjDowntimeDurationUnit )
    {
        rememberChangedField("MaintObjDowntimeDurationUnit", this.maintObjDowntimeDurationUnit);
        this.maintObjDowntimeDurationUnit = maintObjDowntimeDurationUnit;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaintObjectDowntimeDuration</b>
     * </p>
     *
     * @param maintObjectDowntimeDuration
     *            Breakdown Duration
     */
    public void setMaintObjectDowntimeDuration( @Nullable final Double maintObjectDowntimeDuration )
    {
        rememberChangedField("MaintObjectDowntimeDuration", this.maintObjectDowntimeDuration);
        this.maintObjectDowntimeDuration = maintObjectDowntimeDuration;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlan</b>
     * </p>
     *
     * @param maintenancePlan
     *            Maintenance Plan
     */
    public void setMaintenancePlan( @Nullable final String maintenancePlan )
    {
        rememberChangedField("MaintenancePlan", this.maintenancePlan);
        this.maintenancePlan = maintenancePlan;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceItem</b>
     * </p>
     *
     * @param maintenanceItem
     *            Maintenance Item
     */
    public void setMaintenanceItem( @Nullable final String maintenanceItem )
    {
        rememberChangedField("MaintenanceItem", this.maintenanceItem);
        this.maintenanceItem = maintenanceItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>TaskListGroup</b>
     * </p>
     *
     * @param taskListGroup
     *            Key for Task List Group
     */
    public void setTaskListGroup( @Nullable final String taskListGroup )
    {
        rememberChangedField("TaskListGroup", this.taskListGroup);
        this.taskListGroup = taskListGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaskListGroupCounter</b>
     * </p>
     *
     * @param taskListGroupCounter
     *            Group Counter
     */
    public void setTaskListGroupCounter( @Nullable final String taskListGroupCounter )
    {
        rememberChangedField("TaskListGroupCounter", this.taskListGroupCounter);
        this.taskListGroupCounter = taskListGroupCounter;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlanCallNumber</b>
     * </p>
     *
     * @param maintenancePlanCallNumber
     *            Maintenance Plan Call Number
     */
    public void setMaintenancePlanCallNumber( @Nullable final Integer maintenancePlanCallNumber )
    {
        rememberChangedField("MaintenancePlanCallNumber", this.maintenancePlanCallNumber);
        this.maintenancePlanCallNumber = maintenancePlanCallNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceTaskListType</b>
     * </p>
     *
     * @param maintenanceTaskListType
     *            Task List Type
     */
    public void setMaintenanceTaskListType( @Nullable final String maintenanceTaskListType )
    {
        rememberChangedField("MaintenanceTaskListType", this.maintenanceTaskListType);
        this.maintenanceTaskListType = maintenanceTaskListType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>TaskList</b>
     * </p>
     *
     * @param taskList
     *            The taskList to set.
     */
    public void setTaskList( @Nullable final String taskList )
    {
        rememberChangedField("TaskList", this.taskList);
        this.taskList = taskList;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>NotificationReferenceDate</b>
     * </p>
     *
     * @param notificationReferenceDate
     *            Notification Reference Date
     */
    public void setNotificationReferenceDate( @Nullable final LocalDateTime notificationReferenceDate )
    {
        rememberChangedField("NotificationReferenceDate", this.notificationReferenceDate);
        this.notificationReferenceDate = notificationReferenceDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>NotificationReferenceTime</b>
     * </p>
     *
     * @param notificationReferenceTime
     *            Notification Reference Time
     */
    public void setNotificationReferenceTime( @Nullable final LocalTime notificationReferenceTime )
    {
        rememberChangedField("NotificationReferenceTime", this.notificationReferenceTime);
        this.notificationReferenceTime = notificationReferenceTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>NotificationCompletionDate</b>
     * </p>
     *
     * @param notificationCompletionDate
     *            Date for Notification Completion
     */
    public void setNotificationCompletionDate( @Nullable final LocalDateTime notificationCompletionDate )
    {
        rememberChangedField("NotificationCompletionDate", this.notificationCompletionDate);
        this.notificationCompletionDate = notificationCompletionDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CompletionTime</b>
     * </p>
     *
     * @param completionTime
     *            Completion Time of Notification
     */
    public void setCompletionTime( @Nullable final LocalTime completionTime )
    {
        rememberChangedField("CompletionTime", this.completionTime);
        this.completionTime = completionTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>AssetRoom</b>
     * </p>
     *
     * @param assetRoom
     *            Room
     */
    public void setAssetRoom( @Nullable final String assetRoom )
    {
        rememberChangedField("AssetRoom", this.assetRoom);
        this.assetRoom = assetRoom;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifExtReferenceNumber</b>
     * </p>
     *
     * @param maintNotifExtReferenceNumber
     *            External Reference Number
     */
    public void setMaintNotifExtReferenceNumber( @Nullable final String maintNotifExtReferenceNumber )
    {
        rememberChangedField("MaintNotifExtReferenceNumber", this.maintNotifExtReferenceNumber);
        this.maintNotifExtReferenceNumber = maintNotifExtReferenceNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifRejectionReasonCode</b>
     * </p>
     *
     * @param maintNotifRejectionReasonCode
     *            Maintenance Reason Code
     */
    public void setMaintNotifRejectionReasonCode( @Nullable final String maintNotifRejectionReasonCode )
    {
        rememberChangedField("MaintNotifRejectionReasonCode", this.maintNotifRejectionReasonCode);
        this.maintNotifRejectionReasonCode = maintNotifRejectionReasonCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifRejectionRsnCodeTxt</b>
     * </p>
     *
     * @param maintNotifRejectionRsnCodeTxt
     *            Maintenance Reason Code Description
     */
    public void setMaintNotifRejectionRsnCodeTxt( @Nullable final String maintNotifRejectionRsnCodeTxt )
    {
        rememberChangedField("MaintNotifRejectionRsnCodeTxt", this.maintNotifRejectionRsnCodeTxt);
        this.maintNotifRejectionRsnCodeTxt = maintNotifRejectionRsnCodeTxt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifDetectionCatalog</b>
     * </p>
     *
     * @param maintNotifDetectionCatalog
     *            Detection Method Profile
     */
    public void setMaintNotifDetectionCatalog( @Nullable final String maintNotifDetectionCatalog )
    {
        rememberChangedField("MaintNotifDetectionCatalog", this.maintNotifDetectionCatalog);
        this.maintNotifDetectionCatalog = maintNotifDetectionCatalog;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifDetectionCode</b>
     * </p>
     *
     * @param maintNotifDetectionCode
     *            Detection Method
     */
    public void setMaintNotifDetectionCode( @Nullable final String maintNotifDetectionCode )
    {
        rememberChangedField("MaintNotifDetectionCode", this.maintNotifDetectionCode);
        this.maintNotifDetectionCode = maintNotifDetectionCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifDetectionCodeText</b>
     * </p>
     *
     * @param maintNotifDetectionCodeText
     *            Detection Method Description
     */
    public void setMaintNotifDetectionCodeText( @Nullable final String maintNotifDetectionCodeText )
    {
        rememberChangedField("MaintNotifDetectionCodeText", this.maintNotifDetectionCodeText);
        this.maintNotifDetectionCodeText = maintNotifDetectionCodeText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifDetectionCodeGroup</b>
     * </p>
     *
     * @param maintNotifDetectionCodeGroup
     *            Detection Method Group
     */
    public void setMaintNotifDetectionCodeGroup( @Nullable final String maintNotifDetectionCodeGroup )
    {
        rememberChangedField("MaintNotifDetectionCodeGroup", this.maintNotifDetectionCodeGroup);
        this.maintNotifDetectionCodeGroup = maintNotifDetectionCodeGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifDetectionCodeGrpTxt</b>
     * </p>
     *
     * @param maintNotifDetectionCodeGrpTxt
     *            Detection Method Group Description
     */
    public void setMaintNotifDetectionCodeGrpTxt( @Nullable final String maintNotifDetectionCodeGrpTxt )
    {
        rememberChangedField("MaintNotifDetectionCodeGrpTxt", this.maintNotifDetectionCodeGrpTxt);
        this.maintNotifDetectionCodeGrpTxt = maintNotifDetectionCodeGrpTxt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifProcessPhaseCode</b>
     * </p>
     *
     * @param maintNotifProcessPhaseCode
     *            Process Phase
     */
    public void setMaintNotifProcessPhaseCode( @Nullable final String maintNotifProcessPhaseCode )
    {
        rememberChangedField("MaintNotifProcessPhaseCode", this.maintNotifProcessPhaseCode);
        this.maintNotifProcessPhaseCode = maintNotifProcessPhaseCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifProcessSubPhaseCode</b>
     * </p>
     *
     * @param maintNotifProcessSubPhaseCode
     *            Process Subphase
     */
    public void setMaintNotifProcessSubPhaseCode( @Nullable final String maintNotifProcessSubPhaseCode )
    {
        rememberChangedField("MaintNotifProcessSubPhaseCode", this.maintNotifProcessSubPhaseCode);
        this.maintNotifProcessSubPhaseCode = maintNotifProcessSubPhaseCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>EAMProcessPhaseCodeDesc</b>
     * </p>
     *
     * @param eAMProcessPhaseCodeDesc
     *            Short Text for Fixed Values
     */
    public void setEAMProcessPhaseCodeDesc( @Nullable final String eAMProcessPhaseCodeDesc )
    {
        rememberChangedField("EAMProcessPhaseCodeDesc", this.eAMProcessPhaseCodeDesc);
        this.eAMProcessPhaseCodeDesc = eAMProcessPhaseCodeDesc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>EAMProcessSubPhaseCodeDesc</b>
     * </p>
     *
     * @param eAMProcessSubPhaseCodeDesc
     *            Description of Overall Process Subphase
     */
    public void setEAMProcessSubPhaseCodeDesc( @Nullable final String eAMProcessSubPhaseCodeDesc )
    {
        rememberChangedField("EAMProcessSubPhaseCodeDesc", this.eAMProcessSubPhaseCodeDesc);
        this.eAMProcessSubPhaseCodeDesc = eAMProcessSubPhaseCodeDesc;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @param creationDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setCreationDateTime( @Nullable final ZonedDateTime creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MalfunctionStartDateTime</b>
     * </p>
     *
     * @param malfunctionStartDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setMalfunctionStartDateTime( @Nullable final ZonedDateTime malfunctionStartDateTime )
    {
        rememberChangedField("MalfunctionStartDateTime", this.malfunctionStartDateTime);
        this.malfunctionStartDateTime = malfunctionStartDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MalfunctionEndDateTime</b>
     * </p>
     *
     * @param malfunctionEndDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setMalfunctionEndDateTime( @Nullable final ZonedDateTime malfunctionEndDateTime )
    {
        rememberChangedField("MalfunctionEndDateTime", this.malfunctionEndDateTime);
        this.malfunctionEndDateTime = malfunctionEndDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>NotificationCreationDateTime</b>
     * </p>
     *
     * @param notificationCreationDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setNotificationCreationDateTime( @Nullable final ZonedDateTime notificationCreationDateTime )
    {
        rememberChangedField("NotificationCreationDateTime", this.notificationCreationDateTime);
        this.notificationCreationDateTime = notificationCreationDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifRqdStartDateTime</b>
     * </p>
     *
     * @param maintNotifRqdStartDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setMaintNotifRqdStartDateTime( @Nullable final ZonedDateTime maintNotifRqdStartDateTime )
    {
        rememberChangedField("MaintNotifRqdStartDateTime", this.maintNotifRqdStartDateTime);
        this.maintNotifRqdStartDateTime = maintNotifRqdStartDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifRqdEndDateTime</b>
     * </p>
     *
     * @param maintNotifRqdEndDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setMaintNotifRqdEndDateTime( @Nullable final ZonedDateTime maintNotifRqdEndDateTime )
    {
        rememberChangedField("MaintNotifRqdEndDateTime", this.maintNotifRqdEndDateTime);
        this.maintNotifRqdEndDateTime = maintNotifRqdEndDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PreviousFinalDueDate</b>
     * </p>
     *
     * @param previousFinalDueDate
     *            Previous Final Due Date
     */
    public void setPreviousFinalDueDate( @Nullable final LocalDateTime previousFinalDueDate )
    {
        rememberChangedField("PreviousFinalDueDate", this.previousFinalDueDate);
        this.previousFinalDueDate = previousFinalDueDate;
    }

    @Override
    protected String getEntityCollection()
    {
        return "MaintenanceNotification";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("MaintenanceNotification", getMaintenanceNotification());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("MaintenanceNotification", getMaintenanceNotification());
        values.put("MaintNotifInternalID", getMaintNotifInternalID());
        values.put("NotificationText", getNotificationText());
        values.put("MaintPriority", getMaintPriority());
        values.put("NotificationType", getNotificationType());
        values.put("NotifProcessingPhase", getNotifProcessingPhase());
        values.put("NotifProcessingPhaseDesc", getNotifProcessingPhaseDesc());
        values.put("MaintPriorityDesc", getMaintPriorityDesc());
        values.put("CreationDate", getCreationDate());
        values.put("LastChangeTime", getLastChangeTime());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("CreationTime", getCreationTime());
        values.put("ReportedByUser", getReportedByUser());
        values.put("ReporterFullName", getReporterFullName());
        values.put("PersonResponsible", getPersonResponsible());
        values.put("MalfunctionEffect", getMalfunctionEffect());
        values.put("MalfunctionEffectText", getMalfunctionEffectText());
        values.put("MalfunctionStartDate", getMalfunctionStartDate());
        values.put("MalfunctionStartTime", getMalfunctionStartTime());
        values.put("MalfunctionEndDate", getMalfunctionEndDate());
        values.put("MalfunctionEndTime", getMalfunctionEndTime());
        values.put("MaintNotificationCatalog", getMaintNotificationCatalog());
        values.put("MaintNotificationCode", getMaintNotificationCode());
        values.put("MaintNotificationCodeGroup", getMaintNotificationCodeGroup());
        values.put("CatalogProfile", getCatalogProfile());
        values.put("NotificationCreationDate", getNotificationCreationDate());
        values.put("NotificationCreationTime", getNotificationCreationTime());
        values.put("NotificationTimeZone", getNotificationTimeZone());
        values.put("RequiredStartDate", getRequiredStartDate());
        values.put("RequiredStartTime", getRequiredStartTime());
        values.put("RequiredEndDate", getRequiredEndDate());
        values.put("RequiredEndTime", getRequiredEndTime());
        values.put("LatestAcceptableCompletionDate", getLatestAcceptableCompletionDate());
        values.put("MaintenanceObjectIsDown", getMaintenanceObjectIsDown());
        values.put("MaintNotificationLongText", getMaintNotificationLongText());
        values.put("MaintNotifLongTextForEdit", getMaintNotifLongTextForEdit());
        values.put("TechnicalObject", getTechnicalObject());
        values.put("TechObjIsEquipOrFuncnlLoc", getTechObjIsEquipOrFuncnlLoc());
        values.put("TechnicalObjectLabel", getTechnicalObjectLabel());
        values.put("MaintenancePlanningPlant", getMaintenancePlanningPlant());
        values.put("MaintenancePlannerGroup", getMaintenancePlannerGroup());
        values.put("PlantSection", getPlantSection());
        values.put("ABCIndicator", getABCIndicator());
        values.put("SuperiorTechnicalObject", getSuperiorTechnicalObject());
        values.put("SuperiorTechnicalObjectName", getSuperiorTechnicalObjectName());
        values.put("SuperiorObjIsEquipOrFuncnlLoc", getSuperiorObjIsEquipOrFuncnlLoc());
        values.put("SuperiorTechnicalObjectLabel", getSuperiorTechnicalObjectLabel());
        values.put("ManufacturerPartTypeName", getManufacturerPartTypeName());
        values.put("TechObjIsEquipOrFuncnlLocDesc", getTechObjIsEquipOrFuncnlLocDesc());
        values.put("FunctionalLocation", getFunctionalLocation());
        values.put("FunctionalLocationLabelName", getFunctionalLocationLabelName());
        values.put("TechnicalObjectDescription", getTechnicalObjectDescription());
        values.put("AssetLocation", getAssetLocation());
        values.put("LocationName", getLocationName());
        values.put("BusinessArea", getBusinessArea());
        values.put("CompanyCode", getCompanyCode());
        values.put("TechnicalObjectCategory", getTechnicalObjectCategory());
        values.put("TechnicalObjectType", getTechnicalObjectType());
        values.put("MainWorkCenterPlant", getMainWorkCenterPlant());
        values.put("MainWorkCenter", getMainWorkCenter());
        values.put("PlantName", getPlantName());
        values.put("MaintenancePlannerGroupName", getMaintenancePlannerGroupName());
        values.put("MaintenancePlant", getMaintenancePlant());
        values.put("LocationDescription", getLocationDescription());
        values.put("MainWorkCenterText", getMainWorkCenterText());
        values.put("MainWorkCenterPlantName", getMainWorkCenterPlantName());
        values.put("MaintenancePlantName", getMaintenancePlantName());
        values.put("PlantSectionPersonRespName", getPlantSectionPersonRespName());
        values.put("ABCIndicatorDesc", getABCIndicatorDesc());
        values.put("PersonResponsibleName", getPersonResponsibleName());
        values.put("MaintenanceOrder", getMaintenanceOrder());
        values.put("MaintenanceOrderType", getMaintenanceOrderType());
        values.put("ConcatenatedActiveSystStsName", getConcatenatedActiveSystStsName());
        values.put("MaintenanceActivityType", getMaintenanceActivityType());
        values.put("MaintObjDowntimeDurationUnit", getMaintObjDowntimeDurationUnit());
        values.put("MaintObjectDowntimeDuration", getMaintObjectDowntimeDuration());
        values.put("MaintenancePlan", getMaintenancePlan());
        values.put("MaintenanceItem", getMaintenanceItem());
        values.put("TaskListGroup", getTaskListGroup());
        values.put("TaskListGroupCounter", getTaskListGroupCounter());
        values.put("MaintenancePlanCallNumber", getMaintenancePlanCallNumber());
        values.put("MaintenanceTaskListType", getMaintenanceTaskListType());
        values.put("TaskList", getTaskList());
        values.put("NotificationReferenceDate", getNotificationReferenceDate());
        values.put("NotificationReferenceTime", getNotificationReferenceTime());
        values.put("NotificationCompletionDate", getNotificationCompletionDate());
        values.put("CompletionTime", getCompletionTime());
        values.put("AssetRoom", getAssetRoom());
        values.put("MaintNotifExtReferenceNumber", getMaintNotifExtReferenceNumber());
        values.put("MaintNotifRejectionReasonCode", getMaintNotifRejectionReasonCode());
        values.put("MaintNotifRejectionRsnCodeTxt", getMaintNotifRejectionRsnCodeTxt());
        values.put("MaintNotifDetectionCatalog", getMaintNotifDetectionCatalog());
        values.put("MaintNotifDetectionCode", getMaintNotifDetectionCode());
        values.put("MaintNotifDetectionCodeText", getMaintNotifDetectionCodeText());
        values.put("MaintNotifDetectionCodeGroup", getMaintNotifDetectionCodeGroup());
        values.put("MaintNotifDetectionCodeGrpTxt", getMaintNotifDetectionCodeGrpTxt());
        values.put("MaintNotifProcessPhaseCode", getMaintNotifProcessPhaseCode());
        values.put("MaintNotifProcessSubPhaseCode", getMaintNotifProcessSubPhaseCode());
        values.put("EAMProcessPhaseCodeDesc", getEAMProcessPhaseCodeDesc());
        values.put("EAMProcessSubPhaseCodeDesc", getEAMProcessSubPhaseCodeDesc());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("MalfunctionStartDateTime", getMalfunctionStartDateTime());
        values.put("MalfunctionEndDateTime", getMalfunctionEndDateTime());
        values.put("NotificationCreationDateTime", getNotificationCreationDateTime());
        values.put("MaintNotifRqdStartDateTime", getMaintNotifRqdStartDateTime());
        values.put("MaintNotifRqdEndDateTime", getMaintNotifRqdEndDateTime());
        values.put("PreviousFinalDueDate", getPreviousFinalDueDate());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("MaintenanceNotification") ) {
                final Object value = values.remove("MaintenanceNotification");
                if( (value == null) || (!value.equals(getMaintenanceNotification())) ) {
                    setMaintenanceNotification(((String) value));
                }
            }
            if( values.containsKey("MaintNotifInternalID") ) {
                final Object value = values.remove("MaintNotifInternalID");
                if( (value == null) || (!value.equals(getMaintNotifInternalID())) ) {
                    setMaintNotifInternalID(((String) value));
                }
            }
            if( values.containsKey("NotificationText") ) {
                final Object value = values.remove("NotificationText");
                if( (value == null) || (!value.equals(getNotificationText())) ) {
                    setNotificationText(((String) value));
                }
            }
            if( values.containsKey("MaintPriority") ) {
                final Object value = values.remove("MaintPriority");
                if( (value == null) || (!value.equals(getMaintPriority())) ) {
                    setMaintPriority(((String) value));
                }
            }
            if( values.containsKey("NotificationType") ) {
                final Object value = values.remove("NotificationType");
                if( (value == null) || (!value.equals(getNotificationType())) ) {
                    setNotificationType(((String) value));
                }
            }
            if( values.containsKey("NotifProcessingPhase") ) {
                final Object value = values.remove("NotifProcessingPhase");
                if( (value == null) || (!value.equals(getNotifProcessingPhase())) ) {
                    setNotifProcessingPhase(((String) value));
                }
            }
            if( values.containsKey("NotifProcessingPhaseDesc") ) {
                final Object value = values.remove("NotifProcessingPhaseDesc");
                if( (value == null) || (!value.equals(getNotifProcessingPhaseDesc())) ) {
                    setNotifProcessingPhaseDesc(((String) value));
                }
            }
            if( values.containsKey("MaintPriorityDesc") ) {
                final Object value = values.remove("MaintPriorityDesc");
                if( (value == null) || (!value.equals(getMaintPriorityDesc())) ) {
                    setMaintPriorityDesc(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangeTime") ) {
                final Object value = values.remove("LastChangeTime");
                if( (value == null) || (!value.equals(getLastChangeTime())) ) {
                    setLastChangeTime(((LocalTime) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("CreationTime") ) {
                final Object value = values.remove("CreationTime");
                if( (value == null) || (!value.equals(getCreationTime())) ) {
                    setCreationTime(((LocalTime) value));
                }
            }
            if( values.containsKey("ReportedByUser") ) {
                final Object value = values.remove("ReportedByUser");
                if( (value == null) || (!value.equals(getReportedByUser())) ) {
                    setReportedByUser(((String) value));
                }
            }
            if( values.containsKey("ReporterFullName") ) {
                final Object value = values.remove("ReporterFullName");
                if( (value == null) || (!value.equals(getReporterFullName())) ) {
                    setReporterFullName(((String) value));
                }
            }
            if( values.containsKey("PersonResponsible") ) {
                final Object value = values.remove("PersonResponsible");
                if( (value == null) || (!value.equals(getPersonResponsible())) ) {
                    setPersonResponsible(((String) value));
                }
            }
            if( values.containsKey("MalfunctionEffect") ) {
                final Object value = values.remove("MalfunctionEffect");
                if( (value == null) || (!value.equals(getMalfunctionEffect())) ) {
                    setMalfunctionEffect(((String) value));
                }
            }
            if( values.containsKey("MalfunctionEffectText") ) {
                final Object value = values.remove("MalfunctionEffectText");
                if( (value == null) || (!value.equals(getMalfunctionEffectText())) ) {
                    setMalfunctionEffectText(((String) value));
                }
            }
            if( values.containsKey("MalfunctionStartDate") ) {
                final Object value = values.remove("MalfunctionStartDate");
                if( (value == null) || (!value.equals(getMalfunctionStartDate())) ) {
                    setMalfunctionStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("MalfunctionStartTime") ) {
                final Object value = values.remove("MalfunctionStartTime");
                if( (value == null) || (!value.equals(getMalfunctionStartTime())) ) {
                    setMalfunctionStartTime(((LocalTime) value));
                }
            }
            if( values.containsKey("MalfunctionEndDate") ) {
                final Object value = values.remove("MalfunctionEndDate");
                if( (value == null) || (!value.equals(getMalfunctionEndDate())) ) {
                    setMalfunctionEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("MalfunctionEndTime") ) {
                final Object value = values.remove("MalfunctionEndTime");
                if( (value == null) || (!value.equals(getMalfunctionEndTime())) ) {
                    setMalfunctionEndTime(((LocalTime) value));
                }
            }
            if( values.containsKey("MaintNotificationCatalog") ) {
                final Object value = values.remove("MaintNotificationCatalog");
                if( (value == null) || (!value.equals(getMaintNotificationCatalog())) ) {
                    setMaintNotificationCatalog(((String) value));
                }
            }
            if( values.containsKey("MaintNotificationCode") ) {
                final Object value = values.remove("MaintNotificationCode");
                if( (value == null) || (!value.equals(getMaintNotificationCode())) ) {
                    setMaintNotificationCode(((String) value));
                }
            }
            if( values.containsKey("MaintNotificationCodeGroup") ) {
                final Object value = values.remove("MaintNotificationCodeGroup");
                if( (value == null) || (!value.equals(getMaintNotificationCodeGroup())) ) {
                    setMaintNotificationCodeGroup(((String) value));
                }
            }
            if( values.containsKey("CatalogProfile") ) {
                final Object value = values.remove("CatalogProfile");
                if( (value == null) || (!value.equals(getCatalogProfile())) ) {
                    setCatalogProfile(((String) value));
                }
            }
            if( values.containsKey("NotificationCreationDate") ) {
                final Object value = values.remove("NotificationCreationDate");
                if( (value == null) || (!value.equals(getNotificationCreationDate())) ) {
                    setNotificationCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("NotificationCreationTime") ) {
                final Object value = values.remove("NotificationCreationTime");
                if( (value == null) || (!value.equals(getNotificationCreationTime())) ) {
                    setNotificationCreationTime(((LocalTime) value));
                }
            }
            if( values.containsKey("NotificationTimeZone") ) {
                final Object value = values.remove("NotificationTimeZone");
                if( (value == null) || (!value.equals(getNotificationTimeZone())) ) {
                    setNotificationTimeZone(((String) value));
                }
            }
            if( values.containsKey("RequiredStartDate") ) {
                final Object value = values.remove("RequiredStartDate");
                if( (value == null) || (!value.equals(getRequiredStartDate())) ) {
                    setRequiredStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("RequiredStartTime") ) {
                final Object value = values.remove("RequiredStartTime");
                if( (value == null) || (!value.equals(getRequiredStartTime())) ) {
                    setRequiredStartTime(((LocalTime) value));
                }
            }
            if( values.containsKey("RequiredEndDate") ) {
                final Object value = values.remove("RequiredEndDate");
                if( (value == null) || (!value.equals(getRequiredEndDate())) ) {
                    setRequiredEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("RequiredEndTime") ) {
                final Object value = values.remove("RequiredEndTime");
                if( (value == null) || (!value.equals(getRequiredEndTime())) ) {
                    setRequiredEndTime(((LocalTime) value));
                }
            }
            if( values.containsKey("LatestAcceptableCompletionDate") ) {
                final Object value = values.remove("LatestAcceptableCompletionDate");
                if( (value == null) || (!value.equals(getLatestAcceptableCompletionDate())) ) {
                    setLatestAcceptableCompletionDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("MaintenanceObjectIsDown") ) {
                final Object value = values.remove("MaintenanceObjectIsDown");
                if( (value == null) || (!value.equals(getMaintenanceObjectIsDown())) ) {
                    setMaintenanceObjectIsDown(((Boolean) value));
                }
            }
            if( values.containsKey("MaintNotificationLongText") ) {
                final Object value = values.remove("MaintNotificationLongText");
                if( (value == null) || (!value.equals(getMaintNotificationLongText())) ) {
                    setMaintNotificationLongText(((String) value));
                }
            }
            if( values.containsKey("MaintNotifLongTextForEdit") ) {
                final Object value = values.remove("MaintNotifLongTextForEdit");
                if( (value == null) || (!value.equals(getMaintNotifLongTextForEdit())) ) {
                    setMaintNotifLongTextForEdit(((String) value));
                }
            }
            if( values.containsKey("TechnicalObject") ) {
                final Object value = values.remove("TechnicalObject");
                if( (value == null) || (!value.equals(getTechnicalObject())) ) {
                    setTechnicalObject(((String) value));
                }
            }
            if( values.containsKey("TechObjIsEquipOrFuncnlLoc") ) {
                final Object value = values.remove("TechObjIsEquipOrFuncnlLoc");
                if( (value == null) || (!value.equals(getTechObjIsEquipOrFuncnlLoc())) ) {
                    setTechObjIsEquipOrFuncnlLoc(((String) value));
                }
            }
            if( values.containsKey("TechnicalObjectLabel") ) {
                final Object value = values.remove("TechnicalObjectLabel");
                if( (value == null) || (!value.equals(getTechnicalObjectLabel())) ) {
                    setTechnicalObjectLabel(((String) value));
                }
            }
            if( values.containsKey("MaintenancePlanningPlant") ) {
                final Object value = values.remove("MaintenancePlanningPlant");
                if( (value == null) || (!value.equals(getMaintenancePlanningPlant())) ) {
                    setMaintenancePlanningPlant(((String) value));
                }
            }
            if( values.containsKey("MaintenancePlannerGroup") ) {
                final Object value = values.remove("MaintenancePlannerGroup");
                if( (value == null) || (!value.equals(getMaintenancePlannerGroup())) ) {
                    setMaintenancePlannerGroup(((String) value));
                }
            }
            if( values.containsKey("PlantSection") ) {
                final Object value = values.remove("PlantSection");
                if( (value == null) || (!value.equals(getPlantSection())) ) {
                    setPlantSection(((String) value));
                }
            }
            if( values.containsKey("ABCIndicator") ) {
                final Object value = values.remove("ABCIndicator");
                if( (value == null) || (!value.equals(getABCIndicator())) ) {
                    setABCIndicator(((String) value));
                }
            }
            if( values.containsKey("SuperiorTechnicalObject") ) {
                final Object value = values.remove("SuperiorTechnicalObject");
                if( (value == null) || (!value.equals(getSuperiorTechnicalObject())) ) {
                    setSuperiorTechnicalObject(((String) value));
                }
            }
            if( values.containsKey("SuperiorTechnicalObjectName") ) {
                final Object value = values.remove("SuperiorTechnicalObjectName");
                if( (value == null) || (!value.equals(getSuperiorTechnicalObjectName())) ) {
                    setSuperiorTechnicalObjectName(((String) value));
                }
            }
            if( values.containsKey("SuperiorObjIsEquipOrFuncnlLoc") ) {
                final Object value = values.remove("SuperiorObjIsEquipOrFuncnlLoc");
                if( (value == null) || (!value.equals(getSuperiorObjIsEquipOrFuncnlLoc())) ) {
                    setSuperiorObjIsEquipOrFuncnlLoc(((String) value));
                }
            }
            if( values.containsKey("SuperiorTechnicalObjectLabel") ) {
                final Object value = values.remove("SuperiorTechnicalObjectLabel");
                if( (value == null) || (!value.equals(getSuperiorTechnicalObjectLabel())) ) {
                    setSuperiorTechnicalObjectLabel(((String) value));
                }
            }
            if( values.containsKey("ManufacturerPartTypeName") ) {
                final Object value = values.remove("ManufacturerPartTypeName");
                if( (value == null) || (!value.equals(getManufacturerPartTypeName())) ) {
                    setManufacturerPartTypeName(((String) value));
                }
            }
            if( values.containsKey("TechObjIsEquipOrFuncnlLocDesc") ) {
                final Object value = values.remove("TechObjIsEquipOrFuncnlLocDesc");
                if( (value == null) || (!value.equals(getTechObjIsEquipOrFuncnlLocDesc())) ) {
                    setTechObjIsEquipOrFuncnlLocDesc(((String) value));
                }
            }
            if( values.containsKey("FunctionalLocation") ) {
                final Object value = values.remove("FunctionalLocation");
                if( (value == null) || (!value.equals(getFunctionalLocation())) ) {
                    setFunctionalLocation(((String) value));
                }
            }
            if( values.containsKey("FunctionalLocationLabelName") ) {
                final Object value = values.remove("FunctionalLocationLabelName");
                if( (value == null) || (!value.equals(getFunctionalLocationLabelName())) ) {
                    setFunctionalLocationLabelName(((String) value));
                }
            }
            if( values.containsKey("TechnicalObjectDescription") ) {
                final Object value = values.remove("TechnicalObjectDescription");
                if( (value == null) || (!value.equals(getTechnicalObjectDescription())) ) {
                    setTechnicalObjectDescription(((String) value));
                }
            }
            if( values.containsKey("AssetLocation") ) {
                final Object value = values.remove("AssetLocation");
                if( (value == null) || (!value.equals(getAssetLocation())) ) {
                    setAssetLocation(((String) value));
                }
            }
            if( values.containsKey("LocationName") ) {
                final Object value = values.remove("LocationName");
                if( (value == null) || (!value.equals(getLocationName())) ) {
                    setLocationName(((String) value));
                }
            }
            if( values.containsKey("BusinessArea") ) {
                final Object value = values.remove("BusinessArea");
                if( (value == null) || (!value.equals(getBusinessArea())) ) {
                    setBusinessArea(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("TechnicalObjectCategory") ) {
                final Object value = values.remove("TechnicalObjectCategory");
                if( (value == null) || (!value.equals(getTechnicalObjectCategory())) ) {
                    setTechnicalObjectCategory(((String) value));
                }
            }
            if( values.containsKey("TechnicalObjectType") ) {
                final Object value = values.remove("TechnicalObjectType");
                if( (value == null) || (!value.equals(getTechnicalObjectType())) ) {
                    setTechnicalObjectType(((String) value));
                }
            }
            if( values.containsKey("MainWorkCenterPlant") ) {
                final Object value = values.remove("MainWorkCenterPlant");
                if( (value == null) || (!value.equals(getMainWorkCenterPlant())) ) {
                    setMainWorkCenterPlant(((String) value));
                }
            }
            if( values.containsKey("MainWorkCenter") ) {
                final Object value = values.remove("MainWorkCenter");
                if( (value == null) || (!value.equals(getMainWorkCenter())) ) {
                    setMainWorkCenter(((String) value));
                }
            }
            if( values.containsKey("PlantName") ) {
                final Object value = values.remove("PlantName");
                if( (value == null) || (!value.equals(getPlantName())) ) {
                    setPlantName(((String) value));
                }
            }
            if( values.containsKey("MaintenancePlannerGroupName") ) {
                final Object value = values.remove("MaintenancePlannerGroupName");
                if( (value == null) || (!value.equals(getMaintenancePlannerGroupName())) ) {
                    setMaintenancePlannerGroupName(((String) value));
                }
            }
            if( values.containsKey("MaintenancePlant") ) {
                final Object value = values.remove("MaintenancePlant");
                if( (value == null) || (!value.equals(getMaintenancePlant())) ) {
                    setMaintenancePlant(((String) value));
                }
            }
            if( values.containsKey("LocationDescription") ) {
                final Object value = values.remove("LocationDescription");
                if( (value == null) || (!value.equals(getLocationDescription())) ) {
                    setLocationDescription(((String) value));
                }
            }
            if( values.containsKey("MainWorkCenterText") ) {
                final Object value = values.remove("MainWorkCenterText");
                if( (value == null) || (!value.equals(getMainWorkCenterText())) ) {
                    setMainWorkCenterText(((String) value));
                }
            }
            if( values.containsKey("MainWorkCenterPlantName") ) {
                final Object value = values.remove("MainWorkCenterPlantName");
                if( (value == null) || (!value.equals(getMainWorkCenterPlantName())) ) {
                    setMainWorkCenterPlantName(((String) value));
                }
            }
            if( values.containsKey("MaintenancePlantName") ) {
                final Object value = values.remove("MaintenancePlantName");
                if( (value == null) || (!value.equals(getMaintenancePlantName())) ) {
                    setMaintenancePlantName(((String) value));
                }
            }
            if( values.containsKey("PlantSectionPersonRespName") ) {
                final Object value = values.remove("PlantSectionPersonRespName");
                if( (value == null) || (!value.equals(getPlantSectionPersonRespName())) ) {
                    setPlantSectionPersonRespName(((String) value));
                }
            }
            if( values.containsKey("ABCIndicatorDesc") ) {
                final Object value = values.remove("ABCIndicatorDesc");
                if( (value == null) || (!value.equals(getABCIndicatorDesc())) ) {
                    setABCIndicatorDesc(((String) value));
                }
            }
            if( values.containsKey("PersonResponsibleName") ) {
                final Object value = values.remove("PersonResponsibleName");
                if( (value == null) || (!value.equals(getPersonResponsibleName())) ) {
                    setPersonResponsibleName(((String) value));
                }
            }
            if( values.containsKey("MaintenanceOrder") ) {
                final Object value = values.remove("MaintenanceOrder");
                if( (value == null) || (!value.equals(getMaintenanceOrder())) ) {
                    setMaintenanceOrder(((String) value));
                }
            }
            if( values.containsKey("MaintenanceOrderType") ) {
                final Object value = values.remove("MaintenanceOrderType");
                if( (value == null) || (!value.equals(getMaintenanceOrderType())) ) {
                    setMaintenanceOrderType(((String) value));
                }
            }
            if( values.containsKey("ConcatenatedActiveSystStsName") ) {
                final Object value = values.remove("ConcatenatedActiveSystStsName");
                if( (value == null) || (!value.equals(getConcatenatedActiveSystStsName())) ) {
                    setConcatenatedActiveSystStsName(((String) value));
                }
            }
            if( values.containsKey("MaintenanceActivityType") ) {
                final Object value = values.remove("MaintenanceActivityType");
                if( (value == null) || (!value.equals(getMaintenanceActivityType())) ) {
                    setMaintenanceActivityType(((String) value));
                }
            }
            if( values.containsKey("MaintObjDowntimeDurationUnit") ) {
                final Object value = values.remove("MaintObjDowntimeDurationUnit");
                if( (value == null) || (!value.equals(getMaintObjDowntimeDurationUnit())) ) {
                    setMaintObjDowntimeDurationUnit(((String) value));
                }
            }
            if( values.containsKey("MaintObjectDowntimeDuration") ) {
                final Object value = values.remove("MaintObjectDowntimeDuration");
                if( (value == null) || (!value.equals(getMaintObjectDowntimeDuration())) ) {
                    setMaintObjectDowntimeDuration(((Double) value));
                }
            }
            if( values.containsKey("MaintenancePlan") ) {
                final Object value = values.remove("MaintenancePlan");
                if( (value == null) || (!value.equals(getMaintenancePlan())) ) {
                    setMaintenancePlan(((String) value));
                }
            }
            if( values.containsKey("MaintenanceItem") ) {
                final Object value = values.remove("MaintenanceItem");
                if( (value == null) || (!value.equals(getMaintenanceItem())) ) {
                    setMaintenanceItem(((String) value));
                }
            }
            if( values.containsKey("TaskListGroup") ) {
                final Object value = values.remove("TaskListGroup");
                if( (value == null) || (!value.equals(getTaskListGroup())) ) {
                    setTaskListGroup(((String) value));
                }
            }
            if( values.containsKey("TaskListGroupCounter") ) {
                final Object value = values.remove("TaskListGroupCounter");
                if( (value == null) || (!value.equals(getTaskListGroupCounter())) ) {
                    setTaskListGroupCounter(((String) value));
                }
            }
            if( values.containsKey("MaintenancePlanCallNumber") ) {
                final Object value = values.remove("MaintenancePlanCallNumber");
                if( (value == null) || (!value.equals(getMaintenancePlanCallNumber())) ) {
                    setMaintenancePlanCallNumber(((Integer) value));
                }
            }
            if( values.containsKey("MaintenanceTaskListType") ) {
                final Object value = values.remove("MaintenanceTaskListType");
                if( (value == null) || (!value.equals(getMaintenanceTaskListType())) ) {
                    setMaintenanceTaskListType(((String) value));
                }
            }
            if( values.containsKey("TaskList") ) {
                final Object value = values.remove("TaskList");
                if( (value == null) || (!value.equals(getTaskList())) ) {
                    setTaskList(((String) value));
                }
            }
            if( values.containsKey("NotificationReferenceDate") ) {
                final Object value = values.remove("NotificationReferenceDate");
                if( (value == null) || (!value.equals(getNotificationReferenceDate())) ) {
                    setNotificationReferenceDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("NotificationReferenceTime") ) {
                final Object value = values.remove("NotificationReferenceTime");
                if( (value == null) || (!value.equals(getNotificationReferenceTime())) ) {
                    setNotificationReferenceTime(((LocalTime) value));
                }
            }
            if( values.containsKey("NotificationCompletionDate") ) {
                final Object value = values.remove("NotificationCompletionDate");
                if( (value == null) || (!value.equals(getNotificationCompletionDate())) ) {
                    setNotificationCompletionDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CompletionTime") ) {
                final Object value = values.remove("CompletionTime");
                if( (value == null) || (!value.equals(getCompletionTime())) ) {
                    setCompletionTime(((LocalTime) value));
                }
            }
            if( values.containsKey("AssetRoom") ) {
                final Object value = values.remove("AssetRoom");
                if( (value == null) || (!value.equals(getAssetRoom())) ) {
                    setAssetRoom(((String) value));
                }
            }
            if( values.containsKey("MaintNotifExtReferenceNumber") ) {
                final Object value = values.remove("MaintNotifExtReferenceNumber");
                if( (value == null) || (!value.equals(getMaintNotifExtReferenceNumber())) ) {
                    setMaintNotifExtReferenceNumber(((String) value));
                }
            }
            if( values.containsKey("MaintNotifRejectionReasonCode") ) {
                final Object value = values.remove("MaintNotifRejectionReasonCode");
                if( (value == null) || (!value.equals(getMaintNotifRejectionReasonCode())) ) {
                    setMaintNotifRejectionReasonCode(((String) value));
                }
            }
            if( values.containsKey("MaintNotifRejectionRsnCodeTxt") ) {
                final Object value = values.remove("MaintNotifRejectionRsnCodeTxt");
                if( (value == null) || (!value.equals(getMaintNotifRejectionRsnCodeTxt())) ) {
                    setMaintNotifRejectionRsnCodeTxt(((String) value));
                }
            }
            if( values.containsKey("MaintNotifDetectionCatalog") ) {
                final Object value = values.remove("MaintNotifDetectionCatalog");
                if( (value == null) || (!value.equals(getMaintNotifDetectionCatalog())) ) {
                    setMaintNotifDetectionCatalog(((String) value));
                }
            }
            if( values.containsKey("MaintNotifDetectionCode") ) {
                final Object value = values.remove("MaintNotifDetectionCode");
                if( (value == null) || (!value.equals(getMaintNotifDetectionCode())) ) {
                    setMaintNotifDetectionCode(((String) value));
                }
            }
            if( values.containsKey("MaintNotifDetectionCodeText") ) {
                final Object value = values.remove("MaintNotifDetectionCodeText");
                if( (value == null) || (!value.equals(getMaintNotifDetectionCodeText())) ) {
                    setMaintNotifDetectionCodeText(((String) value));
                }
            }
            if( values.containsKey("MaintNotifDetectionCodeGroup") ) {
                final Object value = values.remove("MaintNotifDetectionCodeGroup");
                if( (value == null) || (!value.equals(getMaintNotifDetectionCodeGroup())) ) {
                    setMaintNotifDetectionCodeGroup(((String) value));
                }
            }
            if( values.containsKey("MaintNotifDetectionCodeGrpTxt") ) {
                final Object value = values.remove("MaintNotifDetectionCodeGrpTxt");
                if( (value == null) || (!value.equals(getMaintNotifDetectionCodeGrpTxt())) ) {
                    setMaintNotifDetectionCodeGrpTxt(((String) value));
                }
            }
            if( values.containsKey("MaintNotifProcessPhaseCode") ) {
                final Object value = values.remove("MaintNotifProcessPhaseCode");
                if( (value == null) || (!value.equals(getMaintNotifProcessPhaseCode())) ) {
                    setMaintNotifProcessPhaseCode(((String) value));
                }
            }
            if( values.containsKey("MaintNotifProcessSubPhaseCode") ) {
                final Object value = values.remove("MaintNotifProcessSubPhaseCode");
                if( (value == null) || (!value.equals(getMaintNotifProcessSubPhaseCode())) ) {
                    setMaintNotifProcessSubPhaseCode(((String) value));
                }
            }
            if( values.containsKey("EAMProcessPhaseCodeDesc") ) {
                final Object value = values.remove("EAMProcessPhaseCodeDesc");
                if( (value == null) || (!value.equals(getEAMProcessPhaseCodeDesc())) ) {
                    setEAMProcessPhaseCodeDesc(((String) value));
                }
            }
            if( values.containsKey("EAMProcessSubPhaseCodeDesc") ) {
                final Object value = values.remove("EAMProcessSubPhaseCodeDesc");
                if( (value == null) || (!value.equals(getEAMProcessSubPhaseCodeDesc())) ) {
                    setEAMProcessSubPhaseCodeDesc(((String) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("MalfunctionStartDateTime") ) {
                final Object value = values.remove("MalfunctionStartDateTime");
                if( (value == null) || (!value.equals(getMalfunctionStartDateTime())) ) {
                    setMalfunctionStartDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("MalfunctionEndDateTime") ) {
                final Object value = values.remove("MalfunctionEndDateTime");
                if( (value == null) || (!value.equals(getMalfunctionEndDateTime())) ) {
                    setMalfunctionEndDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("NotificationCreationDateTime") ) {
                final Object value = values.remove("NotificationCreationDateTime");
                if( (value == null) || (!value.equals(getNotificationCreationDateTime())) ) {
                    setNotificationCreationDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("MaintNotifRqdStartDateTime") ) {
                final Object value = values.remove("MaintNotifRqdStartDateTime");
                if( (value == null) || (!value.equals(getMaintNotifRqdStartDateTime())) ) {
                    setMaintNotifRqdStartDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("MaintNotifRqdEndDateTime") ) {
                final Object value = values.remove("MaintNotifRqdEndDateTime");
                if( (value == null) || (!value.equals(getMaintNotifRqdEndDateTime())) ) {
                    setMaintNotifRqdEndDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("PreviousFinalDueDate") ) {
                final Object value = values.remove("PreviousFinalDueDate");
                if( (value == null) || (!value.equals(getPreviousFinalDueDate())) ) {
                    setPreviousFinalDueDate(((LocalDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Item") ) {
                final Object value = (values).remove("to_Item");
                if( value instanceof Iterable ) {
                    if( toItem == null ) {
                        toItem = Lists.newArrayList();
                    } else {
                        toItem = Lists.newArrayList(toItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MaintenanceNotificationItem entity;
                        if( toItem.size() > i ) {
                            entity = toItem.get(i);
                        } else {
                            entity = new MaintenanceNotificationItem();
                            toItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Partner") ) {
                final Object value = (values).remove("to_Partner");
                if( value instanceof Iterable ) {
                    if( toPartner == null ) {
                        toPartner = Lists.newArrayList();
                    } else {
                        toPartner = Lists.newArrayList(toPartner);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MaintenanceNotificationPartner entity;
                        if( toPartner.size() > i ) {
                            entity = toPartner.get(i);
                        } else {
                            entity = new MaintenanceNotificationPartner();
                            toPartner.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> MaintenanceNotificationField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new MaintenanceNotificationField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MaintenanceNotificationField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MaintenanceNotificationField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceNotificationService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toItem != null ) {
            (values).put("to_Item", toItem);
        }
        if( toPartner != null ) {
            (values).put("to_Partner", toPartner);
        }
        return values;
    }

    /**
     * Fetches the <b>MaintenanceNotificationItem</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_Item</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>MaintenanceNotificationItem</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintenanceNotificationItem> fetchItem()
    {
        return fetchFieldAsList("to_Item", MaintenanceNotificationItem.class);
    }

    /**
     * Retrieval of associated <b>MaintenanceNotificationItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>MaintenanceNotification</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintenanceNotificationItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintenanceNotificationItem> getItemOrFetch()
    {
        if( toItem == null ) {
            toItem = fetchItem();
        }
        return toItem;
    }

    /**
     * Retrieval of associated <b>MaintenanceNotificationItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Item</b>.
     * <p>
     * If the navigation property for an entity <b>MaintenanceNotification</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Item</b> is already loaded, the result will contain the
     *         <b>MaintenanceNotificationItem</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<MaintenanceNotificationItem>> getItemIfPresent()
    {
        return Option.of(toItem);
    }

    /**
     * Overwrites the list of associated <b>MaintenanceNotificationItem</b> entities for the loaded navigation property
     * <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>MaintenanceNotification</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>MaintenanceNotificationItem</b> entities.
     */
    public void setItem( @Nonnull final List<MaintenanceNotificationItem> value )
    {
        if( toItem == null ) {
            toItem = Lists.newArrayList();
        }
        toItem.clear();
        toItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MaintenanceNotificationItem</b> entities. This corresponds to the
     * OData navigation property <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>MaintenanceNotification</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>MaintenanceNotificationItem</b> entities.
     */
    public void addItem( MaintenanceNotificationItem... entity )
    {
        if( toItem == null ) {
            toItem = Lists.newArrayList();
        }
        toItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>MaintenanceNotificationPartner</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_Partner</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>MaintenanceNotificationPartner</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintenanceNotificationPartner> fetchPartner()
    {
        return fetchFieldAsList("to_Partner", MaintenanceNotificationPartner.class);
    }

    /**
     * Retrieval of associated <b>MaintenanceNotificationPartner</b> entities (one to many). This corresponds to the
     * OData navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>MaintenanceNotification</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintenanceNotificationPartner</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintenanceNotificationPartner> getPartnerOrFetch()
    {
        if( toPartner == null ) {
            toPartner = fetchPartner();
        }
        return toPartner;
    }

    /**
     * Retrieval of associated <b>MaintenanceNotificationPartner</b> entities (one to many). This corresponds to the
     * OData navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property for an entity <b>MaintenanceNotification</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Partner</b> is already loaded, the result will contain
     *         the <b>MaintenanceNotificationPartner</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<MaintenanceNotificationPartner>> getPartnerIfPresent()
    {
        return Option.of(toPartner);
    }

    /**
     * Overwrites the list of associated <b>MaintenanceNotificationPartner</b> entities for the loaded navigation
     * property <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>MaintenanceNotification</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>MaintenanceNotificationPartner</b> entities.
     */
    public void setPartner( @Nonnull final List<MaintenanceNotificationPartner> value )
    {
        if( toPartner == null ) {
            toPartner = Lists.newArrayList();
        }
        toPartner.clear();
        toPartner.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MaintenanceNotificationPartner</b> entities. This corresponds to the
     * OData navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>MaintenanceNotification</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>MaintenanceNotificationPartner</b> entities.
     */
    public void addPartner( MaintenanceNotificationPartner... entity )
    {
        if( toPartner == null ) {
            toPartner = Lists.newArrayList();
        }
        toPartner.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of MaintenanceNotification instances.
     *
     */
    public final static class MaintenanceNotificationBuilder
    {

        private List<MaintenanceNotificationItem> toItem = Lists.newArrayList();
        private List<MaintenanceNotificationPartner> toPartner = Lists.newArrayList();

        private MaintenanceNotification.MaintenanceNotificationBuilder toItem(
            final List<MaintenanceNotificationItem> value )
        {
            toItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Item</b> for <b>MaintenanceNotification</b> to multiple
         * <b>MaintenanceNotificationItem</b>.
         *
         * @param value
         *            The MaintenanceNotificationItems to build this MaintenanceNotification with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenanceNotification.MaintenanceNotificationBuilder item( MaintenanceNotificationItem... value )
        {
            return toItem(Lists.newArrayList(value));
        }

        private MaintenanceNotification.MaintenanceNotificationBuilder toPartner(
            final List<MaintenanceNotificationPartner> value )
        {
            toPartner.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Partner</b> for <b>MaintenanceNotification</b> to multiple
         * <b>MaintenanceNotificationPartner</b>.
         *
         * @param value
         *            The MaintenanceNotificationPartners to build this MaintenanceNotification with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenanceNotification.MaintenanceNotificationBuilder partner( MaintenanceNotificationPartner... value )
        {
            return toPartner(Lists.newArrayList(value));
        }

    }

}
