/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.field.MaintenanceNotificationItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.link.MaintenanceNotificationItemLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.link.MaintenanceNotificationItemOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.selectable.MaintenanceNotificationItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Maintenance Notification Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MaintenanceNotificationItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MaintenanceNotificationItem extends VdmEntity<MaintenanceNotificationItem>
{

    /**
     * Selector for all available fields of MaintenanceNotificationItem.
     *
     */
    public final static MaintenanceNotificationItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceNotification</b>
     * </p>
     *
     * @return Notification Number
     */
    @Key
    @SerializedName( "MaintenanceNotification" )
    @JsonProperty( "MaintenanceNotification" )
    @Nullable
    @ODataField( odataName = "MaintenanceNotification" )
    private String maintenanceNotification;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceNotification</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationItemField<String> MAINTENANCE_NOTIFICATION =
        new MaintenanceNotificationItemField<String>("MaintenanceNotification");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceNotificationItem</b>
     * </p>
     *
     * @return Item Number in Item Record
     */
    @Key
    @SerializedName( "MaintenanceNotificationItem" )
    @JsonProperty( "MaintenanceNotificationItem" )
    @Nullable
    @ODataField( odataName = "MaintenanceNotificationItem" )
    private String maintenanceNotificationItem;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceNotificationItem</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationItemField<String> MAINTENANCE_NOTIFICATION_ITEM =
        new MaintenanceNotificationItemField<String>("MaintenanceNotificationItem");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifItemText</b>
     * </p>
     *
     * @return Notification Item Short Text
     */
    @SerializedName( "MaintNotifItemText" )
    @JsonProperty( "MaintNotifItemText" )
    @Nullable
    @ODataField( odataName = "MaintNotifItemText" )
    private String maintNotifItemText;
    /**
     * Use with available fluent helpers to apply the <b>MaintNotifItemText</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationItemField<String> MAINT_NOTIF_ITEM_TEXT =
        new MaintenanceNotificationItemField<String>("MaintNotifItemText");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifDamageCodeGroup</b>
     * </p>
     *
     * @return Damage Code Group
     */
    @SerializedName( "MaintNotifDamageCodeGroup" )
    @JsonProperty( "MaintNotifDamageCodeGroup" )
    @Nullable
    @ODataField( odataName = "MaintNotifDamageCodeGroup" )
    private String maintNotifDamageCodeGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaintNotifDamageCodeGroup</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationItemField<String> MAINT_NOTIF_DAMAGE_CODE_GROUP =
        new MaintenanceNotificationItemField<String>("MaintNotifDamageCodeGroup");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifDamageCodeGroupName</b>
     * </p>
     *
     * @return Text for Code Group
     */
    @SerializedName( "MaintNotifDamageCodeGroupName" )
    @JsonProperty( "MaintNotifDamageCodeGroupName" )
    @Nullable
    @ODataField( odataName = "MaintNotifDamageCodeGroupName" )
    private String maintNotifDamageCodeGroupName;
    /**
     * Use with available fluent helpers to apply the <b>MaintNotifDamageCodeGroupName</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationItemField<String> MAINT_NOTIF_DAMAGE_CODE_GROUP_NAME =
        new MaintenanceNotificationItemField<String>("MaintNotifDamageCodeGroupName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotificationDamageCode</b>
     * </p>
     *
     * @return Damage Code
     */
    @SerializedName( "MaintNotificationDamageCode" )
    @JsonProperty( "MaintNotificationDamageCode" )
    @Nullable
    @ODataField( odataName = "MaintNotificationDamageCode" )
    private String maintNotificationDamageCode;
    /**
     * Use with available fluent helpers to apply the <b>MaintNotificationDamageCode</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationItemField<String> MAINT_NOTIFICATION_DAMAGE_CODE =
        new MaintenanceNotificationItemField<String>("MaintNotificationDamageCode");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifDamageCodeName</b>
     * </p>
     *
     * @return Text for Code
     */
    @SerializedName( "MaintNotifDamageCodeName" )
    @JsonProperty( "MaintNotifDamageCodeName" )
    @Nullable
    @ODataField( odataName = "MaintNotifDamageCodeName" )
    private String maintNotifDamageCodeName;
    /**
     * Use with available fluent helpers to apply the <b>MaintNotifDamageCodeName</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationItemField<String> MAINT_NOTIF_DAMAGE_CODE_NAME =
        new MaintenanceNotificationItemField<String>("MaintNotifDamageCodeName");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifObjPrtCodeGroup</b>
     * </p>
     *
     * @return Object Part Code Group
     */
    @SerializedName( "MaintNotifObjPrtCodeGroup" )
    @JsonProperty( "MaintNotifObjPrtCodeGroup" )
    @Nullable
    @ODataField( odataName = "MaintNotifObjPrtCodeGroup" )
    private String maintNotifObjPrtCodeGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaintNotifObjPrtCodeGroup</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationItemField<String> MAINT_NOTIF_OBJ_PRT_CODE_GROUP =
        new MaintenanceNotificationItemField<String>("MaintNotifObjPrtCodeGroup");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifObjPrtCodeGroupName</b>
     * </p>
     *
     * @return Text for Code Group
     */
    @SerializedName( "MaintNotifObjPrtCodeGroupName" )
    @JsonProperty( "MaintNotifObjPrtCodeGroupName" )
    @Nullable
    @ODataField( odataName = "MaintNotifObjPrtCodeGroupName" )
    private String maintNotifObjPrtCodeGroupName;
    /**
     * Use with available fluent helpers to apply the <b>MaintNotifObjPrtCodeGroupName</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationItemField<String> MAINT_NOTIF_OBJ_PRT_CODE_GROUP_NAME =
        new MaintenanceNotificationItemField<String>("MaintNotifObjPrtCodeGroupName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifObjPrtCode</b>
     * </p>
     *
     * @return Object Part Code
     */
    @SerializedName( "MaintNotifObjPrtCode" )
    @JsonProperty( "MaintNotifObjPrtCode" )
    @Nullable
    @ODataField( odataName = "MaintNotifObjPrtCode" )
    private String maintNotifObjPrtCode;
    /**
     * Use with available fluent helpers to apply the <b>MaintNotifObjPrtCode</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationItemField<String> MAINT_NOTIF_OBJ_PRT_CODE =
        new MaintenanceNotificationItemField<String>("MaintNotifObjPrtCode");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifObjPrtCodeName</b>
     * </p>
     *
     * @return Text for Code
     */
    @SerializedName( "MaintNotifObjPrtCodeName" )
    @JsonProperty( "MaintNotifObjPrtCodeName" )
    @Nullable
    @ODataField( odataName = "MaintNotifObjPrtCodeName" )
    private String maintNotifObjPrtCodeName;
    /**
     * Use with available fluent helpers to apply the <b>MaintNotifObjPrtCodeName</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationItemField<String> MAINT_NOTIF_OBJ_PRT_CODE_NAME =
        new MaintenanceNotificationItemField<String>("MaintNotifObjPrtCodeName");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsDeleted</b>
     * </p>
     *
     * @return Delete Data Record
     */
    @SerializedName( "IsDeleted" )
    @JsonProperty( "IsDeleted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsDeleted" )
    private Boolean isDeleted;
    /**
     * Use with available fluent helpers to apply the <b>IsDeleted</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationItemField<Boolean> IS_DELETED =
        new MaintenanceNotificationItemField<Boolean>("IsDeleted");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifItemChangedDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "MaintNotifItemChangedDateTime" )
    @JsonProperty( "MaintNotifItemChangedDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "MaintNotifItemChangedDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime maintNotifItemChangedDateTime;
    /**
     * Use with available fluent helpers to apply the <b>MaintNotifItemChangedDateTime</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationItemField<ZonedDateTime> MAINT_NOTIF_ITEM_CHANGED_DATE_TIME =
        new MaintenanceNotificationItemField<ZonedDateTime>("MaintNotifItemChangedDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifItemCreationDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "MaintNotifItemCreationDateTime" )
    @JsonProperty( "MaintNotifItemCreationDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "MaintNotifItemCreationDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime maintNotifItemCreationDateTime;
    /**
     * Use with available fluent helpers to apply the <b>MaintNotifItemCreationDateTime</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationItemField<ZonedDateTime> MAINT_NOTIF_ITEM_CREATION_DATE_TIME =
        new MaintenanceNotificationItemField<ZonedDateTime>("MaintNotifItemCreationDateTime");
    /**
     * Navigation property <b>to_Notif</b> for <b>MaintenanceNotificationItem</b> to single
     * <b>MaintenanceNotification</b>.
     *
     */
    @SerializedName( "to_Notif" )
    @JsonProperty( "to_Notif" )
    @ODataField( odataName = "to_Notif" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private MaintenanceNotification toNotif;
    /**
     * Navigation property <b>to_ItemActivity</b> for <b>MaintenanceNotificationItem</b> to multiple
     * <b>MaintNotificationItemActivity</b>.
     *
     */
    @SerializedName( "to_ItemActivity" )
    @JsonProperty( "to_ItemActivity" )
    @ODataField( odataName = "to_ItemActivity" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MaintNotificationItemActivity> toItemActivity;
    /**
     * Navigation property <b>to_ItemCause</b> for <b>MaintenanceNotificationItem</b> to multiple
     * <b>MaintNotificationItemCause</b>.
     *
     */
    @SerializedName( "to_ItemCause" )
    @JsonProperty( "to_ItemCause" )
    @ODataField( odataName = "to_ItemCause" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MaintNotificationItemCause> toItemCause;
    /**
     * Use with available fluent helpers to apply the <b>to_Notif</b> navigation property to query operations.
     *
     */
    public final static MaintenanceNotificationItemOneToOneLink<MaintenanceNotification> TO_NOTIF =
        new MaintenanceNotificationItemOneToOneLink<MaintenanceNotification>("to_Notif");
    /**
     * Use with available fluent helpers to apply the <b>to_ItemActivity</b> navigation property to query operations.
     *
     */
    public final static MaintenanceNotificationItemLink<MaintNotificationItemActivity> TO_ITEM_ACTIVITY =
        new MaintenanceNotificationItemLink<MaintNotificationItemActivity>("to_ItemActivity");
    /**
     * Use with available fluent helpers to apply the <b>to_ItemCause</b> navigation property to query operations.
     *
     */
    public final static MaintenanceNotificationItemLink<MaintNotificationItemCause> TO_ITEM_CAUSE =
        new MaintenanceNotificationItemLink<MaintNotificationItemCause>("to_ItemCause");

    @Nonnull
    @Override
    public Class<MaintenanceNotificationItem> getType()
    {
        return MaintenanceNotificationItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceNotification</b>
     * </p>
     *
     * @param maintenanceNotification
     *            Notification Number
     */
    public void setMaintenanceNotification( @Nullable final String maintenanceNotification )
    {
        rememberChangedField("MaintenanceNotification", this.maintenanceNotification);
        this.maintenanceNotification = maintenanceNotification;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceNotificationItem</b>
     * </p>
     *
     * @param maintenanceNotificationItem
     *            Item Number in Item Record
     */
    public void setMaintenanceNotificationItem( @Nullable final String maintenanceNotificationItem )
    {
        rememberChangedField("MaintenanceNotificationItem", this.maintenanceNotificationItem);
        this.maintenanceNotificationItem = maintenanceNotificationItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifItemText</b>
     * </p>
     *
     * @param maintNotifItemText
     *            Notification Item Short Text
     */
    public void setMaintNotifItemText( @Nullable final String maintNotifItemText )
    {
        rememberChangedField("MaintNotifItemText", this.maintNotifItemText);
        this.maintNotifItemText = maintNotifItemText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifDamageCodeGroup</b>
     * </p>
     *
     * @param maintNotifDamageCodeGroup
     *            Damage Code Group
     */
    public void setMaintNotifDamageCodeGroup( @Nullable final String maintNotifDamageCodeGroup )
    {
        rememberChangedField("MaintNotifDamageCodeGroup", this.maintNotifDamageCodeGroup);
        this.maintNotifDamageCodeGroup = maintNotifDamageCodeGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifDamageCodeGroupName</b>
     * </p>
     *
     * @param maintNotifDamageCodeGroupName
     *            Text for Code Group
     */
    public void setMaintNotifDamageCodeGroupName( @Nullable final String maintNotifDamageCodeGroupName )
    {
        rememberChangedField("MaintNotifDamageCodeGroupName", this.maintNotifDamageCodeGroupName);
        this.maintNotifDamageCodeGroupName = maintNotifDamageCodeGroupName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotificationDamageCode</b>
     * </p>
     *
     * @param maintNotificationDamageCode
     *            Damage Code
     */
    public void setMaintNotificationDamageCode( @Nullable final String maintNotificationDamageCode )
    {
        rememberChangedField("MaintNotificationDamageCode", this.maintNotificationDamageCode);
        this.maintNotificationDamageCode = maintNotificationDamageCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifDamageCodeName</b>
     * </p>
     *
     * @param maintNotifDamageCodeName
     *            Text for Code
     */
    public void setMaintNotifDamageCodeName( @Nullable final String maintNotifDamageCodeName )
    {
        rememberChangedField("MaintNotifDamageCodeName", this.maintNotifDamageCodeName);
        this.maintNotifDamageCodeName = maintNotifDamageCodeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifObjPrtCodeGroup</b>
     * </p>
     *
     * @param maintNotifObjPrtCodeGroup
     *            Object Part Code Group
     */
    public void setMaintNotifObjPrtCodeGroup( @Nullable final String maintNotifObjPrtCodeGroup )
    {
        rememberChangedField("MaintNotifObjPrtCodeGroup", this.maintNotifObjPrtCodeGroup);
        this.maintNotifObjPrtCodeGroup = maintNotifObjPrtCodeGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifObjPrtCodeGroupName</b>
     * </p>
     *
     * @param maintNotifObjPrtCodeGroupName
     *            Text for Code Group
     */
    public void setMaintNotifObjPrtCodeGroupName( @Nullable final String maintNotifObjPrtCodeGroupName )
    {
        rememberChangedField("MaintNotifObjPrtCodeGroupName", this.maintNotifObjPrtCodeGroupName);
        this.maintNotifObjPrtCodeGroupName = maintNotifObjPrtCodeGroupName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifObjPrtCode</b>
     * </p>
     *
     * @param maintNotifObjPrtCode
     *            Object Part Code
     */
    public void setMaintNotifObjPrtCode( @Nullable final String maintNotifObjPrtCode )
    {
        rememberChangedField("MaintNotifObjPrtCode", this.maintNotifObjPrtCode);
        this.maintNotifObjPrtCode = maintNotifObjPrtCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifObjPrtCodeName</b>
     * </p>
     *
     * @param maintNotifObjPrtCodeName
     *            Text for Code
     */
    public void setMaintNotifObjPrtCodeName( @Nullable final String maintNotifObjPrtCodeName )
    {
        rememberChangedField("MaintNotifObjPrtCodeName", this.maintNotifObjPrtCodeName);
        this.maintNotifObjPrtCodeName = maintNotifObjPrtCodeName;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsDeleted</b>
     * </p>
     *
     * @param isDeleted
     *            Delete Data Record
     */
    public void setIsDeleted( @Nullable final Boolean isDeleted )
    {
        rememberChangedField("IsDeleted", this.isDeleted);
        this.isDeleted = isDeleted;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifItemChangedDateTime</b>
     * </p>
     *
     * @param maintNotifItemChangedDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setMaintNotifItemChangedDateTime( @Nullable final ZonedDateTime maintNotifItemChangedDateTime )
    {
        rememberChangedField("MaintNotifItemChangedDateTime", this.maintNotifItemChangedDateTime);
        this.maintNotifItemChangedDateTime = maintNotifItemChangedDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifItemCreationDateTime</b>
     * </p>
     *
     * @param maintNotifItemCreationDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setMaintNotifItemCreationDateTime( @Nullable final ZonedDateTime maintNotifItemCreationDateTime )
    {
        rememberChangedField("MaintNotifItemCreationDateTime", this.maintNotifItemCreationDateTime);
        this.maintNotifItemCreationDateTime = maintNotifItemCreationDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "MaintenanceNotificationItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("MaintenanceNotification", getMaintenanceNotification());
        result.put("MaintenanceNotificationItem", getMaintenanceNotificationItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("MaintenanceNotification", getMaintenanceNotification());
        values.put("MaintenanceNotificationItem", getMaintenanceNotificationItem());
        values.put("MaintNotifItemText", getMaintNotifItemText());
        values.put("MaintNotifDamageCodeGroup", getMaintNotifDamageCodeGroup());
        values.put("MaintNotifDamageCodeGroupName", getMaintNotifDamageCodeGroupName());
        values.put("MaintNotificationDamageCode", getMaintNotificationDamageCode());
        values.put("MaintNotifDamageCodeName", getMaintNotifDamageCodeName());
        values.put("MaintNotifObjPrtCodeGroup", getMaintNotifObjPrtCodeGroup());
        values.put("MaintNotifObjPrtCodeGroupName", getMaintNotifObjPrtCodeGroupName());
        values.put("MaintNotifObjPrtCode", getMaintNotifObjPrtCode());
        values.put("MaintNotifObjPrtCodeName", getMaintNotifObjPrtCodeName());
        values.put("IsDeleted", getIsDeleted());
        values.put("MaintNotifItemChangedDateTime", getMaintNotifItemChangedDateTime());
        values.put("MaintNotifItemCreationDateTime", getMaintNotifItemCreationDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("MaintenanceNotification") ) {
                final Object value = values.remove("MaintenanceNotification");
                if( (value == null) || (!value.equals(getMaintenanceNotification())) ) {
                    setMaintenanceNotification(((String) value));
                }
            }
            if( values.containsKey("MaintenanceNotificationItem") ) {
                final Object value = values.remove("MaintenanceNotificationItem");
                if( (value == null) || (!value.equals(getMaintenanceNotificationItem())) ) {
                    setMaintenanceNotificationItem(((String) value));
                }
            }
            if( values.containsKey("MaintNotifItemText") ) {
                final Object value = values.remove("MaintNotifItemText");
                if( (value == null) || (!value.equals(getMaintNotifItemText())) ) {
                    setMaintNotifItemText(((String) value));
                }
            }
            if( values.containsKey("MaintNotifDamageCodeGroup") ) {
                final Object value = values.remove("MaintNotifDamageCodeGroup");
                if( (value == null) || (!value.equals(getMaintNotifDamageCodeGroup())) ) {
                    setMaintNotifDamageCodeGroup(((String) value));
                }
            }
            if( values.containsKey("MaintNotifDamageCodeGroupName") ) {
                final Object value = values.remove("MaintNotifDamageCodeGroupName");
                if( (value == null) || (!value.equals(getMaintNotifDamageCodeGroupName())) ) {
                    setMaintNotifDamageCodeGroupName(((String) value));
                }
            }
            if( values.containsKey("MaintNotificationDamageCode") ) {
                final Object value = values.remove("MaintNotificationDamageCode");
                if( (value == null) || (!value.equals(getMaintNotificationDamageCode())) ) {
                    setMaintNotificationDamageCode(((String) value));
                }
            }
            if( values.containsKey("MaintNotifDamageCodeName") ) {
                final Object value = values.remove("MaintNotifDamageCodeName");
                if( (value == null) || (!value.equals(getMaintNotifDamageCodeName())) ) {
                    setMaintNotifDamageCodeName(((String) value));
                }
            }
            if( values.containsKey("MaintNotifObjPrtCodeGroup") ) {
                final Object value = values.remove("MaintNotifObjPrtCodeGroup");
                if( (value == null) || (!value.equals(getMaintNotifObjPrtCodeGroup())) ) {
                    setMaintNotifObjPrtCodeGroup(((String) value));
                }
            }
            if( values.containsKey("MaintNotifObjPrtCodeGroupName") ) {
                final Object value = values.remove("MaintNotifObjPrtCodeGroupName");
                if( (value == null) || (!value.equals(getMaintNotifObjPrtCodeGroupName())) ) {
                    setMaintNotifObjPrtCodeGroupName(((String) value));
                }
            }
            if( values.containsKey("MaintNotifObjPrtCode") ) {
                final Object value = values.remove("MaintNotifObjPrtCode");
                if( (value == null) || (!value.equals(getMaintNotifObjPrtCode())) ) {
                    setMaintNotifObjPrtCode(((String) value));
                }
            }
            if( values.containsKey("MaintNotifObjPrtCodeName") ) {
                final Object value = values.remove("MaintNotifObjPrtCodeName");
                if( (value == null) || (!value.equals(getMaintNotifObjPrtCodeName())) ) {
                    setMaintNotifObjPrtCodeName(((String) value));
                }
            }
            if( values.containsKey("IsDeleted") ) {
                final Object value = values.remove("IsDeleted");
                if( (value == null) || (!value.equals(getIsDeleted())) ) {
                    setIsDeleted(((Boolean) value));
                }
            }
            if( values.containsKey("MaintNotifItemChangedDateTime") ) {
                final Object value = values.remove("MaintNotifItemChangedDateTime");
                if( (value == null) || (!value.equals(getMaintNotifItemChangedDateTime())) ) {
                    setMaintNotifItemChangedDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("MaintNotifItemCreationDateTime") ) {
                final Object value = values.remove("MaintNotifItemCreationDateTime");
                if( (value == null) || (!value.equals(getMaintNotifItemCreationDateTime())) ) {
                    setMaintNotifItemCreationDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Notif") ) {
                final Object value = (values).remove("to_Notif");
                if( value instanceof Map ) {
                    if( toNotif == null ) {
                        toNotif = new MaintenanceNotification();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toNotif.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_ItemActivity") ) {
                final Object value = (values).remove("to_ItemActivity");
                if( value instanceof Iterable ) {
                    if( toItemActivity == null ) {
                        toItemActivity = Lists.newArrayList();
                    } else {
                        toItemActivity = Lists.newArrayList(toItemActivity);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MaintNotificationItemActivity entity;
                        if( toItemActivity.size() > i ) {
                            entity = toItemActivity.get(i);
                        } else {
                            entity = new MaintNotificationItemActivity();
                            toItemActivity.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ItemCause") ) {
                final Object value = (values).remove("to_ItemCause");
                if( value instanceof Iterable ) {
                    if( toItemCause == null ) {
                        toItemCause = Lists.newArrayList();
                    } else {
                        toItemCause = Lists.newArrayList(toItemCause);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MaintNotificationItemCause entity;
                        if( toItemCause.size() > i ) {
                            entity = toItemCause.get(i);
                        } else {
                            entity = new MaintNotificationItemCause();
                            toItemCause.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> MaintenanceNotificationItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new MaintenanceNotificationItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MaintenanceNotificationItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MaintenanceNotificationItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceNotificationService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toNotif != null ) {
            (values).put("to_Notif", toNotif);
        }
        if( toItemActivity != null ) {
            (values).put("to_ItemActivity", toItemActivity);
        }
        if( toItemCause != null ) {
            (values).put("to_ItemCause", toItemCause);
        }
        return values;
    }

    /**
     * Fetches the <b>MaintenanceNotification</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_Notif</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>MaintenanceNotification</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceNotification fetchNotif()
    {
        return fetchFieldAsSingle("to_Notif", MaintenanceNotification.class);
    }

    /**
     * Retrieval of associated <b>MaintenanceNotification</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_Notif</b>.
     * <p>
     * If the navigation property <b>to_Notif</b> of a queried <b>MaintenanceNotificationItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintenanceNotification</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceNotification getNotifOrFetch()
    {
        if( toNotif == null ) {
            toNotif = fetchNotif();
        }
        return toNotif;
    }

    /**
     * Retrieval of associated <b>MaintenanceNotification</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_Notif</b>.
     * <p>
     * If the navigation property for an entity <b>MaintenanceNotificationItem</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Notif</b> is already loaded, the result will contain the
     *         <b>MaintenanceNotification</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<MaintenanceNotification> getNotifIfPresent()
    {
        return Option.of(toNotif);
    }

    /**
     * Overwrites the associated <b>MaintenanceNotification</b> entity for the loaded navigation property
     * <b>to_Notif</b>.
     *
     * @param value
     *            New <b>MaintenanceNotification</b> entity.
     */
    public void setNotif( final MaintenanceNotification value )
    {
        toNotif = value;
    }

    /**
     * Fetches the <b>MaintNotificationItemActivity</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_ItemActivity</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>MaintNotificationItemActivity</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintNotificationItemActivity> fetchItemActivity()
    {
        return fetchFieldAsList("to_ItemActivity", MaintNotificationItemActivity.class);
    }

    /**
     * Retrieval of associated <b>MaintNotificationItemActivity</b> entities (one to many). This corresponds to the
     * OData navigation property <b>to_ItemActivity</b>.
     * <p>
     * If the navigation property <b>to_ItemActivity</b> of a queried <b>MaintenanceNotificationItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintNotificationItemActivity</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintNotificationItemActivity> getItemActivityOrFetch()
    {
        if( toItemActivity == null ) {
            toItemActivity = fetchItemActivity();
        }
        return toItemActivity;
    }

    /**
     * Retrieval of associated <b>MaintNotificationItemActivity</b> entities (one to many). This corresponds to the
     * OData navigation property <b>to_ItemActivity</b>.
     * <p>
     * If the navigation property for an entity <b>MaintenanceNotificationItem</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ItemActivity</b> is already loaded, the result will
     *         contain the <b>MaintNotificationItemActivity</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<MaintNotificationItemActivity>> getItemActivityIfPresent()
    {
        return Option.of(toItemActivity);
    }

    /**
     * Overwrites the list of associated <b>MaintNotificationItemActivity</b> entities for the loaded navigation
     * property <b>to_ItemActivity</b>.
     * <p>
     * If the navigation property <b>to_ItemActivity</b> of a queried <b>MaintenanceNotificationItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>MaintNotificationItemActivity</b> entities.
     */
    public void setItemActivity( @Nonnull final List<MaintNotificationItemActivity> value )
    {
        if( toItemActivity == null ) {
            toItemActivity = Lists.newArrayList();
        }
        toItemActivity.clear();
        toItemActivity.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MaintNotificationItemActivity</b> entities. This corresponds to the
     * OData navigation property <b>to_ItemActivity</b>.
     * <p>
     * If the navigation property <b>to_ItemActivity</b> of a queried <b>MaintenanceNotificationItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>MaintNotificationItemActivity</b> entities.
     */
    public void addItemActivity( MaintNotificationItemActivity... entity )
    {
        if( toItemActivity == null ) {
            toItemActivity = Lists.newArrayList();
        }
        toItemActivity.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>MaintNotificationItemCause</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_ItemCause</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>MaintNotificationItemCause</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintNotificationItemCause> fetchItemCause()
    {
        return fetchFieldAsList("to_ItemCause", MaintNotificationItemCause.class);
    }

    /**
     * Retrieval of associated <b>MaintNotificationItemCause</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ItemCause</b>.
     * <p>
     * If the navigation property <b>to_ItemCause</b> of a queried <b>MaintenanceNotificationItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintNotificationItemCause</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintNotificationItemCause> getItemCauseOrFetch()
    {
        if( toItemCause == null ) {
            toItemCause = fetchItemCause();
        }
        return toItemCause;
    }

    /**
     * Retrieval of associated <b>MaintNotificationItemCause</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ItemCause</b>.
     * <p>
     * If the navigation property for an entity <b>MaintenanceNotificationItem</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ItemCause</b> is already loaded, the result will contain
     *         the <b>MaintNotificationItemCause</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<MaintNotificationItemCause>> getItemCauseIfPresent()
    {
        return Option.of(toItemCause);
    }

    /**
     * Overwrites the list of associated <b>MaintNotificationItemCause</b> entities for the loaded navigation property
     * <b>to_ItemCause</b>.
     * <p>
     * If the navigation property <b>to_ItemCause</b> of a queried <b>MaintenanceNotificationItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>MaintNotificationItemCause</b> entities.
     */
    public void setItemCause( @Nonnull final List<MaintNotificationItemCause> value )
    {
        if( toItemCause == null ) {
            toItemCause = Lists.newArrayList();
        }
        toItemCause.clear();
        toItemCause.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MaintNotificationItemCause</b> entities. This corresponds to the OData
     * navigation property <b>to_ItemCause</b>.
     * <p>
     * If the navigation property <b>to_ItemCause</b> of a queried <b>MaintenanceNotificationItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>MaintNotificationItemCause</b> entities.
     */
    public void addItemCause( MaintNotificationItemCause... entity )
    {
        if( toItemCause == null ) {
            toItemCause = Lists.newArrayList();
        }
        toItemCause.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of MaintenanceNotificationItem instances.
     *
     */
    public final static class MaintenanceNotificationItemBuilder
    {

        private MaintenanceNotification toNotif;
        private List<MaintNotificationItemActivity> toItemActivity = Lists.newArrayList();
        private List<MaintNotificationItemCause> toItemCause = Lists.newArrayList();

        private MaintenanceNotificationItem.MaintenanceNotificationItemBuilder toNotif(
            final MaintenanceNotification value )
        {
            toNotif = value;
            return this;
        }

        /**
         * Navigation property <b>to_Notif</b> for <b>MaintenanceNotificationItem</b> to single
         * <b>MaintenanceNotification</b>.
         *
         * @param value
         *            The MaintenanceNotification to build this MaintenanceNotificationItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenanceNotificationItem.MaintenanceNotificationItemBuilder notif(
            final MaintenanceNotification value )
        {
            return toNotif(value);
        }

        private MaintenanceNotificationItem.MaintenanceNotificationItemBuilder toItemActivity(
            final List<MaintNotificationItemActivity> value )
        {
            toItemActivity.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ItemActivity</b> for <b>MaintenanceNotificationItem</b> to multiple
         * <b>MaintNotificationItemActivity</b>.
         *
         * @param value
         *            The MaintNotificationItemActivitys to build this MaintenanceNotificationItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenanceNotificationItem.MaintenanceNotificationItemBuilder itemActivity(
            MaintNotificationItemActivity... value )
        {
            return toItemActivity(Lists.newArrayList(value));
        }

        private MaintenanceNotificationItem.MaintenanceNotificationItemBuilder toItemCause(
            final List<MaintNotificationItemCause> value )
        {
            toItemCause.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ItemCause</b> for <b>MaintenanceNotificationItem</b> to multiple
         * <b>MaintNotificationItemCause</b>.
         *
         * @param value
         *            The MaintNotificationItemCauses to build this MaintenanceNotificationItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenanceNotificationItem.MaintenanceNotificationItemBuilder itemCause(
            MaintNotificationItemCause... value )
        {
            return toItemCause(Lists.newArrayList(value));
        }

    }

}
