/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.field.MaintenanceNotificationPartnerField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.link.MaintenanceNotificationPartnerOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.selectable.MaintenanceNotificationPartnerSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Maintenance Notification Partner
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MaintenanceNotificationPartnerType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MaintenanceNotificationPartner extends VdmEntity<MaintenanceNotificationPartner>
{

    /**
     * Selector for all available fields of MaintenanceNotificationPartner.
     *
     */
    public final static MaintenanceNotificationPartnerSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceNotification</b>
     * </p>
     *
     * @return Notification Number
     */
    @Key
    @SerializedName( "MaintenanceNotification" )
    @JsonProperty( "MaintenanceNotification" )
    @Nullable
    @ODataField( odataName = "MaintenanceNotification" )
    private String maintenanceNotification;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceNotification</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationPartnerField<String> MAINTENANCE_NOTIFICATION =
        new MaintenanceNotificationPartnerField<String>("MaintenanceNotification");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunction</b>
     * </p>
     *
     * @return Partner Function
     */
    @Key
    @SerializedName( "PartnerFunction" )
    @JsonProperty( "PartnerFunction" )
    @Nullable
    @ODataField( odataName = "PartnerFunction" )
    private String partnerFunction;
    /**
     * Use with available fluent helpers to apply the <b>PartnerFunction</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationPartnerField<String> PARTNER_FUNCTION =
        new MaintenanceNotificationPartnerField<String>("PartnerFunction");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>NotificationPartnerObjectNmbr</b>
     * </p>
     *
     * @return Counter for differentiation 6-digit
     */
    @Key
    @SerializedName( "NotificationPartnerObjectNmbr" )
    @JsonProperty( "NotificationPartnerObjectNmbr" )
    @Nullable
    @ODataField( odataName = "NotificationPartnerObjectNmbr" )
    private String notificationPartnerObjectNmbr;
    /**
     * Use with available fluent helpers to apply the <b>NotificationPartnerObjectNmbr</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationPartnerField<String> NOTIFICATION_PARTNER_OBJECT_NMBR =
        new MaintenanceNotificationPartnerField<String>("NotificationPartnerObjectNmbr");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>Partner</b>
     * </p>
     *
     * @return Partner
     */
    @SerializedName( "Partner" )
    @JsonProperty( "Partner" )
    @Nullable
    @ODataField( odataName = "Partner" )
    private String partner;
    /**
     * Use with available fluent helpers to apply the <b>Partner</b> field to query operations.
     *
     */
    public final static MaintenanceNotificationPartnerField<String> PARTNER =
        new MaintenanceNotificationPartnerField<String>("Partner");
    /**
     * Navigation property <b>to_Notif</b> for <b>MaintenanceNotificationPartner</b> to single
     * <b>MaintenanceNotification</b>.
     *
     */
    @SerializedName( "to_Notif" )
    @JsonProperty( "to_Notif" )
    @ODataField( odataName = "to_Notif" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private MaintenanceNotification toNotif;
    /**
     * Use with available fluent helpers to apply the <b>to_Notif</b> navigation property to query operations.
     *
     */
    public final static MaintenanceNotificationPartnerOneToOneLink<MaintenanceNotification> TO_NOTIF =
        new MaintenanceNotificationPartnerOneToOneLink<MaintenanceNotification>("to_Notif");

    @Nonnull
    @Override
    public Class<MaintenanceNotificationPartner> getType()
    {
        return MaintenanceNotificationPartner.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceNotification</b>
     * </p>
     *
     * @param maintenanceNotification
     *            Notification Number
     */
    public void setMaintenanceNotification( @Nullable final String maintenanceNotification )
    {
        rememberChangedField("MaintenanceNotification", this.maintenanceNotification);
        this.maintenanceNotification = maintenanceNotification;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunction</b>
     * </p>
     *
     * @param partnerFunction
     *            Partner Function
     */
    public void setPartnerFunction( @Nullable final String partnerFunction )
    {
        rememberChangedField("PartnerFunction", this.partnerFunction);
        this.partnerFunction = partnerFunction;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>NotificationPartnerObjectNmbr</b>
     * </p>
     *
     * @param notificationPartnerObjectNmbr
     *            Counter for differentiation 6-digit
     */
    public void setNotificationPartnerObjectNmbr( @Nullable final String notificationPartnerObjectNmbr )
    {
        rememberChangedField("NotificationPartnerObjectNmbr", this.notificationPartnerObjectNmbr);
        this.notificationPartnerObjectNmbr = notificationPartnerObjectNmbr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>Partner</b>
     * </p>
     *
     * @param partner
     *            Partner
     */
    public void setPartner( @Nullable final String partner )
    {
        rememberChangedField("Partner", this.partner);
        this.partner = partner;
    }

    @Override
    protected String getEntityCollection()
    {
        return "MaintenanceNotificationPartner";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("MaintenanceNotification", getMaintenanceNotification());
        result.put("PartnerFunction", getPartnerFunction());
        result.put("NotificationPartnerObjectNmbr", getNotificationPartnerObjectNmbr());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("MaintenanceNotification", getMaintenanceNotification());
        values.put("PartnerFunction", getPartnerFunction());
        values.put("NotificationPartnerObjectNmbr", getNotificationPartnerObjectNmbr());
        values.put("Partner", getPartner());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("MaintenanceNotification") ) {
                final Object value = values.remove("MaintenanceNotification");
                if( (value == null) || (!value.equals(getMaintenanceNotification())) ) {
                    setMaintenanceNotification(((String) value));
                }
            }
            if( values.containsKey("PartnerFunction") ) {
                final Object value = values.remove("PartnerFunction");
                if( (value == null) || (!value.equals(getPartnerFunction())) ) {
                    setPartnerFunction(((String) value));
                }
            }
            if( values.containsKey("NotificationPartnerObjectNmbr") ) {
                final Object value = values.remove("NotificationPartnerObjectNmbr");
                if( (value == null) || (!value.equals(getNotificationPartnerObjectNmbr())) ) {
                    setNotificationPartnerObjectNmbr(((String) value));
                }
            }
            if( values.containsKey("Partner") ) {
                final Object value = values.remove("Partner");
                if( (value == null) || (!value.equals(getPartner())) ) {
                    setPartner(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Notif") ) {
                final Object value = (values).remove("to_Notif");
                if( value instanceof Map ) {
                    if( toNotif == null ) {
                        toNotif = new MaintenanceNotification();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toNotif.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> MaintenanceNotificationPartnerField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new MaintenanceNotificationPartnerField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MaintenanceNotificationPartnerField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MaintenanceNotificationPartnerField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceNotificationService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toNotif != null ) {
            (values).put("to_Notif", toNotif);
        }
        return values;
    }

    /**
     * Fetches the <b>MaintenanceNotification</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_Notif</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>MaintenanceNotification</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceNotification fetchNotif()
    {
        return fetchFieldAsSingle("to_Notif", MaintenanceNotification.class);
    }

    /**
     * Retrieval of associated <b>MaintenanceNotification</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_Notif</b>.
     * <p>
     * If the navigation property <b>to_Notif</b> of a queried <b>MaintenanceNotificationPartner</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintenanceNotification</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceNotification getNotifOrFetch()
    {
        if( toNotif == null ) {
            toNotif = fetchNotif();
        }
        return toNotif;
    }

    /**
     * Retrieval of associated <b>MaintenanceNotification</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_Notif</b>.
     * <p>
     * If the navigation property for an entity <b>MaintenanceNotificationPartner</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Notif</b> is already loaded, the result will contain the
     *         <b>MaintenanceNotification</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<MaintenanceNotification> getNotifIfPresent()
    {
        return Option.of(toNotif);
    }

    /**
     * Overwrites the associated <b>MaintenanceNotification</b> entity for the loaded navigation property
     * <b>to_Notif</b>.
     *
     * @param value
     *            New <b>MaintenanceNotification</b> entity.
     */
    public void setNotif( final MaintenanceNotification value )
    {
        toNotif = value;
    }

    /**
     * Helper class to allow for fluent creation of MaintenanceNotificationPartner instances.
     *
     */
    public final static class MaintenanceNotificationPartnerBuilder
    {

        private MaintenanceNotification toNotif;

        private MaintenanceNotificationPartner.MaintenanceNotificationPartnerBuilder toNotif(
            final MaintenanceNotification value )
        {
            toNotif = value;
            return this;
        }

        /**
         * Navigation property <b>to_Notif</b> for <b>MaintenanceNotificationPartner</b> to single
         * <b>MaintenanceNotification</b>.
         *
         * @param value
         *            The MaintenanceNotification to build this MaintenanceNotificationPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenanceNotificationPartner.MaintenanceNotificationPartnerBuilder notif(
            final MaintenanceNotification value )
        {
            return toNotif(value);
        }

    }

}
