/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.selectable.MaintenanceNotificationPartnerSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationPartner
 * MaintenanceNotificationPartner} entity using key fields. This fluent helper allows methods which modify the
 * underlying query to be called before executing the query itself.
 *
 */
public class MaintenanceNotificationPartnerByKeyFluentHelper
    extends
    FluentHelperByKey<MaintenanceNotificationPartnerByKeyFluentHelper, MaintenanceNotificationPartner, MaintenanceNotificationPartnerSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationPartner
     * MaintenanceNotificationPartner} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code MaintenanceNotificationPartner}
     * @param partnerFunction
     *            Partner Function
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code MaintenanceNotificationPartner}
     * @param maintenanceNotification
     *            Notification Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param notificationPartnerObjectNmbr
     *            Counter for differentiation 6-digit
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     */
    public MaintenanceNotificationPartnerByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String maintenanceNotification,
        final String partnerFunction,
        final String notificationPartnerObjectNmbr )
    {
        super(servicePath, entityCollection);
        this.key.put("MaintenanceNotification", maintenanceNotification);
        this.key.put("PartnerFunction", partnerFunction);
        this.key.put("NotificationPartnerObjectNmbr", notificationPartnerObjectNmbr);
    }

    @Override
    @Nonnull
    protected Class<MaintenanceNotificationPartner> getEntityClass()
    {
        return MaintenanceNotificationPartner.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
