/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link MaintenanceNotificationServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceNotificationService
 * MaintenanceNotificationService}, allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultMaintenanceNotificationServiceBatch
    extends
    BatchFluentHelperBasic<MaintenanceNotificationServiceBatch, MaintenanceNotificationServiceBatchChangeSet>
    implements
    MaintenanceNotificationServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceNotificationService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultMaintenanceNotificationServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultMaintenanceNotificationServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceNotificationService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceNotificationService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultMaintenanceNotificationServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultMaintenanceNotificationServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceNotificationService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultMaintenanceNotificationServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public MaintenanceNotificationServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultMaintenanceNotificationServiceBatchChangeSet(this, service);
    }

}
