/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemCause;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationPartner;

/**
 * Implementation of the {@link MaintenanceNotificationServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceNotificationService
 * MaintenanceNotificationService}.
 *
 */
public class DefaultMaintenanceNotificationServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<MaintenanceNotificationServiceBatch, MaintenanceNotificationServiceBatchChangeSet>
    implements
    MaintenanceNotificationServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceNotificationService service;

    @SuppressWarnings( "deprecation" )
    DefaultMaintenanceNotificationServiceBatchChangeSet(
        @Nonnull final DefaultMaintenanceNotificationServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceNotificationService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultMaintenanceNotificationServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public MaintenanceNotificationServiceBatchChangeSet createMaintenanceNotification(
        @Nonnull final MaintenanceNotification maintenanceNotification )
    {
        return addRequestCreate(service::createMaintenanceNotification, maintenanceNotification);
    }

    @Nonnull
    @Override
    public MaintenanceNotificationServiceBatchChangeSet updateMaintenanceNotification(
        @Nonnull final MaintenanceNotification maintenanceNotification )
    {
        return addRequestUpdate(service::updateMaintenanceNotification, maintenanceNotification);
    }

    @Nonnull
    @Override
    public MaintenanceNotificationServiceBatchChangeSet createMaintenanceNotificationItem(
        @Nonnull final MaintenanceNotificationItem maintenanceNotificationItem )
    {
        return addRequestCreate(service::createMaintenanceNotificationItem, maintenanceNotificationItem);
    }

    @Nonnull
    @Override
    public MaintenanceNotificationServiceBatchChangeSet updateMaintenanceNotificationItem(
        @Nonnull final MaintenanceNotificationItem maintenanceNotificationItem )
    {
        return addRequestUpdate(service::updateMaintenanceNotificationItem, maintenanceNotificationItem);
    }

    @Nonnull
    @Override
    public MaintenanceNotificationServiceBatchChangeSet createMaintenanceNotificationPartner(
        @Nonnull final MaintenanceNotificationPartner maintenanceNotificationPartner )
    {
        return addRequestCreate(service::createMaintenanceNotificationPartner, maintenanceNotificationPartner);
    }

    @Nonnull
    @Override
    public MaintenanceNotificationServiceBatchChangeSet updateMaintenanceNotificationPartner(
        @Nonnull final MaintenanceNotificationPartner maintenanceNotificationPartner )
    {
        return addRequestUpdate(service::updateMaintenanceNotificationPartner, maintenanceNotificationPartner);
    }

    @Nonnull
    @Override
    public MaintenanceNotificationServiceBatchChangeSet createMaintNotificationItemActivity(
        @Nonnull final MaintNotificationItemActivity maintNotificationItemActivity )
    {
        return addRequestCreate(service::createMaintNotificationItemActivity, maintNotificationItemActivity);
    }

    @Nonnull
    @Override
    public MaintenanceNotificationServiceBatchChangeSet updateMaintNotificationItemActivity(
        @Nonnull final MaintNotificationItemActivity maintNotificationItemActivity )
    {
        return addRequestUpdate(service::updateMaintNotificationItemActivity, maintNotificationItemActivity);
    }

    @Nonnull
    @Override
    public MaintenanceNotificationServiceBatchChangeSet createMaintNotificationItemCause(
        @Nonnull final MaintNotificationItemCause maintNotificationItemCause )
    {
        return addRequestCreate(service::createMaintNotificationItemCause, maintNotificationItemCause);
    }

    @Nonnull
    @Override
    public MaintenanceNotificationServiceBatchChangeSet updateMaintNotificationItemCause(
        @Nonnull final MaintNotificationItemCause maintNotificationItemCause )
    {
        return addRequestUpdate(service::updateMaintNotificationItemCause, maintNotificationItemCause);
    }

}
