/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemCause;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationPartner;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceNotificationService
 * MaintenanceNotificationService}.
 *
 */
public interface MaintenanceNotificationServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<MaintenanceNotificationServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<MaintenanceNotificationServiceBatch>
{

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification
     * MaintenanceNotification} entity and save it to the S/4HANA system.
     *
     * @param maintenanceNotification
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification
     *            MaintenanceNotification} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceNotificationServiceBatchChangeSet
        createMaintenanceNotification( @Nonnull final MaintenanceNotification maintenanceNotification );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification
     * MaintenanceNotification} entity and save it to the S/4HANA system.
     *
     * @param maintenanceNotification
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification
     *            MaintenanceNotification} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceNotificationServiceBatchChangeSet
        updateMaintenanceNotification( @Nonnull final MaintenanceNotification maintenanceNotification );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationItem
     * MaintenanceNotificationItem} entity and save it to the S/4HANA system.
     *
     * @param maintenanceNotificationItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationItem
     *            MaintenanceNotificationItem} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceNotificationServiceBatchChangeSet
        createMaintenanceNotificationItem( @Nonnull final MaintenanceNotificationItem maintenanceNotificationItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationItem
     * MaintenanceNotificationItem} entity and save it to the S/4HANA system.
     *
     * @param maintenanceNotificationItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationItem
     *            MaintenanceNotificationItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceNotificationServiceBatchChangeSet
        updateMaintenanceNotificationItem( @Nonnull final MaintenanceNotificationItem maintenanceNotificationItem );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationPartner
     * MaintenanceNotificationPartner} entity and save it to the S/4HANA system.
     *
     * @param maintenanceNotificationPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationPartner
     *            MaintenanceNotificationPartner} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceNotificationServiceBatchChangeSet createMaintenanceNotificationPartner(
        @Nonnull final MaintenanceNotificationPartner maintenanceNotificationPartner );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationPartner
     * MaintenanceNotificationPartner} entity and save it to the S/4HANA system.
     *
     * @param maintenanceNotificationPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationPartner
     *            MaintenanceNotificationPartner} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceNotificationServiceBatchChangeSet updateMaintenanceNotificationPartner(
        @Nonnull final MaintenanceNotificationPartner maintenanceNotificationPartner );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivity
     * MaintNotificationItemActivity} entity and save it to the S/4HANA system.
     *
     * @param maintNotificationItemActivity
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivity
     *            MaintNotificationItemActivity} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceNotificationServiceBatchChangeSet createMaintNotificationItemActivity(
        @Nonnull final MaintNotificationItemActivity maintNotificationItemActivity );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivity
     * MaintNotificationItemActivity} entity and save it to the S/4HANA system.
     *
     * @param maintNotificationItemActivity
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivity
     *            MaintNotificationItemActivity} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceNotificationServiceBatchChangeSet updateMaintNotificationItemActivity(
        @Nonnull final MaintNotificationItemActivity maintNotificationItemActivity );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemCause
     * MaintNotificationItemCause} entity and save it to the S/4HANA system.
     *
     * @param maintNotificationItemCause
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemCause
     *            MaintNotificationItemCause} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceNotificationServiceBatchChangeSet
        createMaintNotificationItemCause( @Nonnull final MaintNotificationItemCause maintNotificationItemCause );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemCause
     * MaintNotificationItemCause} entity and save it to the S/4HANA system.
     *
     * @param maintNotificationItemCause
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemCause
     *            MaintNotificationItemCause} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceNotificationServiceBatchChangeSet
        updateMaintNotificationItemCause( @Nonnull final MaintNotificationItemCause maintNotificationItemCause );

}
