/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivity;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivity
 * MaintNotificationItemActivity}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.field.MaintNotificationItemActivityField
 * MaintNotificationItemActivityField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.link.MaintNotificationItemActivityLink
 * MaintNotificationItemActivityLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivity#MAINT_NOTIFICATION_ACTIVITY
 * MAINT_NOTIFICATION_ACTIVITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivity#MAINTENANCE_NOTIFICATION
 * MAINTENANCE_NOTIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivity#MAINTENANCE_NOTIFICATION_ITEM
 * MAINTENANCE_NOTIFICATION_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivity#MAINT_NOTIF_ACTIVITY_SORT_NUMBER
 * MAINT_NOTIF_ACTIVITY_SORT_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivity#MAINT_NOTIF_ACTY_TXT
 * MAINT_NOTIF_ACTY_TXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivity#MAINT_NOTIF_ACTIVITY_CODE_GROUP
 * MAINT_NOTIF_ACTIVITY_CODE_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivity#NOTIF_ACTIVITY_CODE_GROUP_TEXT
 * NOTIF_ACTIVITY_CODE_GROUP_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivity#MAINT_NOTIFICATION_ACTIVITY_CODE
 * MAINT_NOTIFICATION_ACTIVITY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivity#NOTIF_ACTIVITY_CODE_TEXT
 * NOTIF_ACTIVITY_CODE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivity#PLANNED_START_DATE
 * PLANNED_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivity#PLANNED_START_TIME
 * PLANNED_START_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivity#PLANNED_END_DATE
 * PLANNED_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivity#PLANNED_END_TIME
 * PLANNED_END_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivity#IS_DELETED
 * IS_DELETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivity#MAINT_NOTIF_ITM_ACTY_STRT_DATE_TIME
 * MAINT_NOTIF_ITM_ACTY_STRT_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivity#MAINT_NOTIF_ITEM_ACTY_END_DATE_TIME
 * MAINT_NOTIF_ITEM_ACTY_END_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivity#MAINT_NOTIF_ITEM_ACTY_CRTN_DATE_TIME
 * MAINT_NOTIF_ITEM_ACTY_CRTN_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivity#MAINT_NOTIF_ITEM_ACTY_CHGD_DATE_TIME
 * MAINT_NOTIF_ITEM_ACTY_CHGD_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivity#TO_ITEM
 * TO_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivity#TO_NOTIF
 * TO_NOTIF}</li>
 * </ul>
 *
 */
public interface MaintNotificationItemActivitySelectable extends EntitySelectable<MaintNotificationItemActivity>
{

}
