/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemCause;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemCause
 * MaintNotificationItemCause}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.field.MaintNotificationItemCauseField
 * MaintNotificationItemCauseField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.link.MaintNotificationItemCauseLink
 * MaintNotificationItemCauseLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemCause#MAINTENANCE_NOTIFICATION
 * MAINTENANCE_NOTIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemCause#MAINTENANCE_NOTIFICATION_ITEM
 * MAINTENANCE_NOTIFICATION_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemCause#MAINTENANCE_NOTIFICATION_CAUSE
 * MAINTENANCE_NOTIFICATION_CAUSE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemCause#MAINT_NOTIF_CAUSE_TEXT
 * MAINT_NOTIF_CAUSE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemCause#MAINT_NOTIF_CAUSE_CODE_GROUP
 * MAINT_NOTIF_CAUSE_CODE_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemCause#MAINT_NOTIF_CAUSE_CODE_GROUP_NAME
 * MAINT_NOTIF_CAUSE_CODE_GROUP_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemCause#MAINT_NOTIFICATION_CAUSE_CODE
 * MAINT_NOTIFICATION_CAUSE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemCause#MAINT_NOTIFICATION_CAUSE_CODE_NAME
 * MAINT_NOTIFICATION_CAUSE_CODE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemCause#MAINT_NOTIFICATION_ROOT_CAUSE
 * MAINT_NOTIFICATION_ROOT_CAUSE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemCause#MAINT_NOTIFICATION_ROOT_CAUSE_TEXT
 * MAINT_NOTIFICATION_ROOT_CAUSE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemCause#IS_DELETED
 * IS_DELETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemCause#MAINT_NOTIF_ITM_CAUSE_CHGD_DATE_TIME
 * MAINT_NOTIF_ITM_CAUSE_CHGD_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemCause#MAINT_NOTIF_ITM_CAUSE_CRTN_DATE_TIME
 * MAINT_NOTIF_ITM_CAUSE_CRTN_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemCause#TO_ITEM
 * TO_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemCause#TO_NOTIF
 * TO_NOTIF}</li>
 * </ul>
 *
 */
public interface MaintNotificationItemCauseSelectable extends EntitySelectable<MaintNotificationItemCause>
{

}
