/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationItem
 * MaintenanceNotificationItem}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.field.MaintenanceNotificationItemField
 * MaintenanceNotificationItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.link.MaintenanceNotificationItemLink
 * MaintenanceNotificationItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationItem#MAINTENANCE_NOTIFICATION
 * MAINTENANCE_NOTIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationItem#MAINTENANCE_NOTIFICATION_ITEM
 * MAINTENANCE_NOTIFICATION_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationItem#MAINT_NOTIF_ITEM_TEXT
 * MAINT_NOTIF_ITEM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationItem#MAINT_NOTIF_DAMAGE_CODE_GROUP
 * MAINT_NOTIF_DAMAGE_CODE_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationItem#MAINT_NOTIF_DAMAGE_CODE_GROUP_NAME
 * MAINT_NOTIF_DAMAGE_CODE_GROUP_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationItem#MAINT_NOTIFICATION_DAMAGE_CODE
 * MAINT_NOTIFICATION_DAMAGE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationItem#MAINT_NOTIF_DAMAGE_CODE_NAME
 * MAINT_NOTIF_DAMAGE_CODE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationItem#MAINT_NOTIF_OBJ_PRT_CODE_GROUP
 * MAINT_NOTIF_OBJ_PRT_CODE_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationItem#MAINT_NOTIF_OBJ_PRT_CODE_GROUP_NAME
 * MAINT_NOTIF_OBJ_PRT_CODE_GROUP_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationItem#MAINT_NOTIF_OBJ_PRT_CODE
 * MAINT_NOTIF_OBJ_PRT_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationItem#MAINT_NOTIF_OBJ_PRT_CODE_NAME
 * MAINT_NOTIF_OBJ_PRT_CODE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationItem#IS_DELETED
 * IS_DELETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationItem#MAINT_NOTIF_ITEM_CHANGED_DATE_TIME
 * MAINT_NOTIF_ITEM_CHANGED_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationItem#MAINT_NOTIF_ITEM_CREATION_DATE_TIME
 * MAINT_NOTIF_ITEM_CREATION_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationItem#TO_NOTIF
 * TO_NOTIF}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationItem#TO_ITEM_ACTIVITY
 * TO_ITEM_ACTIVITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationItem#TO_ITEM_CAUSE
 * TO_ITEM_CAUSE}</li>
 * </ul>
 *
 */
public interface MaintenanceNotificationItemSelectable extends EntitySelectable<MaintenanceNotificationItem>
{

}
