/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification
 * MaintenanceNotification}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.field.MaintenanceNotificationField
 * MaintenanceNotificationField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.link.MaintenanceNotificationLink
 * MaintenanceNotificationLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#MAINTENANCE_NOTIFICATION
 * MAINTENANCE_NOTIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#MAINT_NOTIF_INTERNAL_ID
 * MAINT_NOTIF_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#NOTIFICATION_TEXT
 * NOTIFICATION_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#MAINT_PRIORITY
 * MAINT_PRIORITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#NOTIFICATION_TYPE
 * NOTIFICATION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#NOTIF_PROCESSING_PHASE
 * NOTIF_PROCESSING_PHASE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#NOTIF_PROCESSING_PHASE_DESC
 * NOTIF_PROCESSING_PHASE_DESC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#MAINT_PRIORITY_DESC
 * MAINT_PRIORITY_DESC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#LAST_CHANGE_TIME
 * LAST_CHANGE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#LAST_CHANGE_DATE
 * LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#CREATION_TIME
 * CREATION_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#REPORTED_BY_USER
 * REPORTED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#REPORTER_FULL_NAME
 * REPORTER_FULL_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#PERSON_RESPONSIBLE
 * PERSON_RESPONSIBLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#MALFUNCTION_EFFECT
 * MALFUNCTION_EFFECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#MALFUNCTION_EFFECT_TEXT
 * MALFUNCTION_EFFECT_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#MALFUNCTION_START_DATE
 * MALFUNCTION_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#MALFUNCTION_START_TIME
 * MALFUNCTION_START_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#MALFUNCTION_END_DATE
 * MALFUNCTION_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#MALFUNCTION_END_TIME
 * MALFUNCTION_END_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#MAINT_NOTIFICATION_CATALOG
 * MAINT_NOTIFICATION_CATALOG}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#MAINT_NOTIFICATION_CODE
 * MAINT_NOTIFICATION_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#MAINT_NOTIFICATION_CODE_GROUP
 * MAINT_NOTIFICATION_CODE_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#CATALOG_PROFILE
 * CATALOG_PROFILE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#NOTIFICATION_CREATION_DATE
 * NOTIFICATION_CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#NOTIFICATION_CREATION_TIME
 * NOTIFICATION_CREATION_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#NOTIFICATION_TIME_ZONE
 * NOTIFICATION_TIME_ZONE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#REQUIRED_START_DATE
 * REQUIRED_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#REQUIRED_START_TIME
 * REQUIRED_START_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#REQUIRED_END_DATE
 * REQUIRED_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#REQUIRED_END_TIME
 * REQUIRED_END_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#LATEST_ACCEPTABLE_COMPLETION_DATE
 * LATEST_ACCEPTABLE_COMPLETION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#MAINTENANCE_OBJECT_IS_DOWN
 * MAINTENANCE_OBJECT_IS_DOWN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#MAINT_NOTIFICATION_LONG_TEXT
 * MAINT_NOTIFICATION_LONG_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#MAINT_NOTIF_LONG_TEXT_FOR_EDIT
 * MAINT_NOTIF_LONG_TEXT_FOR_EDIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#TECHNICAL_OBJECT
 * TECHNICAL_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#TECH_OBJ_IS_EQUIP_OR_FUNCNL_LOC
 * TECH_OBJ_IS_EQUIP_OR_FUNCNL_LOC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#TECHNICAL_OBJECT_LABEL
 * TECHNICAL_OBJECT_LABEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#MAINTENANCE_PLANNING_PLANT
 * MAINTENANCE_PLANNING_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#MAINTENANCE_PLANNER_GROUP
 * MAINTENANCE_PLANNER_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#PLANT_SECTION
 * PLANT_SECTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#ABC_INDICATOR
 * ABC_INDICATOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#SUPERIOR_TECHNICAL_OBJECT
 * SUPERIOR_TECHNICAL_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#SUPERIOR_TECHNICAL_OBJECT_NAME
 * SUPERIOR_TECHNICAL_OBJECT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#SUPERIOR_OBJ_IS_EQUIP_OR_FUNCNL_LOC
 * SUPERIOR_OBJ_IS_EQUIP_OR_FUNCNL_LOC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#SUPERIOR_TECHNICAL_OBJECT_LABEL
 * SUPERIOR_TECHNICAL_OBJECT_LABEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#MANUFACTURER_PART_TYPE_NAME
 * MANUFACTURER_PART_TYPE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#TECH_OBJ_IS_EQUIP_OR_FUNCNL_LOC_DESC
 * TECH_OBJ_IS_EQUIP_OR_FUNCNL_LOC_DESC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#FUNCTIONAL_LOCATION
 * FUNCTIONAL_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#FUNCTIONAL_LOCATION_LABEL_NAME
 * FUNCTIONAL_LOCATION_LABEL_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#TECHNICAL_OBJECT_DESCRIPTION
 * TECHNICAL_OBJECT_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#ASSET_LOCATION
 * ASSET_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#LOCATION_NAME
 * LOCATION_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#BUSINESS_AREA
 * BUSINESS_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#TECHNICAL_OBJECT_CATEGORY
 * TECHNICAL_OBJECT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#TECHNICAL_OBJECT_TYPE
 * TECHNICAL_OBJECT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#MAIN_WORK_CENTER_PLANT
 * MAIN_WORK_CENTER_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#MAIN_WORK_CENTER
 * MAIN_WORK_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#PLANT_NAME
 * PLANT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#MAINTENANCE_PLANNER_GROUP_NAME
 * MAINTENANCE_PLANNER_GROUP_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#MAINTENANCE_PLANT
 * MAINTENANCE_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#LOCATION_DESCRIPTION
 * LOCATION_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#MAIN_WORK_CENTER_TEXT
 * MAIN_WORK_CENTER_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#MAIN_WORK_CENTER_PLANT_NAME
 * MAIN_WORK_CENTER_PLANT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#MAINTENANCE_PLANT_NAME
 * MAINTENANCE_PLANT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#PLANT_SECTION_PERSON_RESP_NAME
 * PLANT_SECTION_PERSON_RESP_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#ABC_INDICATOR_DESC
 * ABC_INDICATOR_DESC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#PERSON_RESPONSIBLE_NAME
 * PERSON_RESPONSIBLE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#MAINTENANCE_ORDER
 * MAINTENANCE_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#MAINTENANCE_ORDER_TYPE
 * MAINTENANCE_ORDER_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#CONCATENATED_ACTIVE_SYST_STS_NAME
 * CONCATENATED_ACTIVE_SYST_STS_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#MAINTENANCE_ACTIVITY_TYPE
 * MAINTENANCE_ACTIVITY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#MAINT_OBJ_DOWNTIME_DURATION_UNIT
 * MAINT_OBJ_DOWNTIME_DURATION_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#MAINT_OBJECT_DOWNTIME_DURATION
 * MAINT_OBJECT_DOWNTIME_DURATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#MAINTENANCE_PLAN
 * MAINTENANCE_PLAN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#MAINTENANCE_ITEM
 * MAINTENANCE_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#TASK_LIST_GROUP
 * TASK_LIST_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#TASK_LIST_GROUP_COUNTER
 * TASK_LIST_GROUP_COUNTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#MAINTENANCE_PLAN_CALL_NUMBER
 * MAINTENANCE_PLAN_CALL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#MAINTENANCE_TASK_LIST_TYPE
 * MAINTENANCE_TASK_LIST_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#TASK_LIST
 * TASK_LIST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#NOTIFICATION_REFERENCE_DATE
 * NOTIFICATION_REFERENCE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#NOTIFICATION_REFERENCE_TIME
 * NOTIFICATION_REFERENCE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#NOTIFICATION_COMPLETION_DATE
 * NOTIFICATION_COMPLETION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#COMPLETION_TIME
 * COMPLETION_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#ASSET_ROOM
 * ASSET_ROOM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#MAINT_NOTIF_EXT_REFERENCE_NUMBER
 * MAINT_NOTIF_EXT_REFERENCE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#MAINT_NOTIF_REJECTION_REASON_CODE
 * MAINT_NOTIF_REJECTION_REASON_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#MAINT_NOTIF_REJECTION_RSN_CODE_TXT
 * MAINT_NOTIF_REJECTION_RSN_CODE_TXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#MAINT_NOTIF_DETECTION_CATALOG
 * MAINT_NOTIF_DETECTION_CATALOG}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#MAINT_NOTIF_DETECTION_CODE
 * MAINT_NOTIF_DETECTION_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#MAINT_NOTIF_DETECTION_CODE_TEXT
 * MAINT_NOTIF_DETECTION_CODE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#MAINT_NOTIF_DETECTION_CODE_GROUP
 * MAINT_NOTIF_DETECTION_CODE_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#MAINT_NOTIF_DETECTION_CODE_GRP_TXT
 * MAINT_NOTIF_DETECTION_CODE_GRP_TXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#MAINT_NOTIF_PROCESS_PHASE_CODE
 * MAINT_NOTIF_PROCESS_PHASE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#MAINT_NOTIF_PROCESS_SUB_PHASE_CODE
 * MAINT_NOTIF_PROCESS_SUB_PHASE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#EAM_PROCESS_PHASE_CODE_DESC
 * EAM_PROCESS_PHASE_CODE_DESC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#EAM_PROCESS_SUB_PHASE_CODE_DESC
 * EAM_PROCESS_SUB_PHASE_CODE_DESC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#CREATION_DATE_TIME
 * CREATION_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#MALFUNCTION_START_DATE_TIME
 * MALFUNCTION_START_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#MALFUNCTION_END_DATE_TIME
 * MALFUNCTION_END_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#NOTIFICATION_CREATION_DATE_TIME
 * NOTIFICATION_CREATION_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#MAINT_NOTIF_RQD_START_DATE_TIME
 * MAINT_NOTIF_RQD_START_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#MAINT_NOTIF_RQD_END_DATE_TIME
 * MAINT_NOTIF_RQD_END_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#PREVIOUS_FINAL_DUE_DATE
 * PREVIOUS_FINAL_DUE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#TO_ITEM
 * TO_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification#TO_PARTNER
 * TO_PARTNER}</li>
 * </ul>
 *
 */
public interface MaintenanceNotificationSelectable extends EntitySelectable<MaintenanceNotification>
{

}
