/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.selectable.MaintOrdSettlmtDistrRuleHistSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrdSettlmtDistrRuleHist
 * MaintOrdSettlmtDistrRuleHist} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class MaintOrdSettlmtDistrRuleHistByKeyFluentHelper
    extends
    FluentHelperByKey<MaintOrdSettlmtDistrRuleHistByKeyFluentHelper, MaintOrdSettlmtDistrRuleHist, MaintOrdSettlmtDistrRuleHistSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrdSettlmtDistrRuleHist
     * MaintOrdSettlmtDistrRuleHist} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param maintenanceOrder
     *            Order Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param ledger
     *            Ledger in General Ledger Accounting
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code MaintOrdSettlmtDistrRuleHist}
     * @param servicePath
     *            Service path to be used to fetch a single {@code MaintOrdSettlmtDistrRuleHist}
     * @param settlmtDistrRuleSequence
     *            Sequence Number of Distribution Rule
     *            <p>
     *            Constraints: Not nullable, Maximum length: 7
     *            </p>
     */
    public MaintOrdSettlmtDistrRuleHistByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String maintenanceOrder,
        final String settlmtDistrRuleSequence,
        final String ledger )
    {
        super(servicePath, entityCollection);
        this.key.put("MaintenanceOrder", maintenanceOrder);
        this.key.put("SettlmtDistrRuleSequence", settlmtDistrRuleSequence);
        this.key.put("Ledger", ledger);
    }

    @Override
    @Nonnull
    protected Class<MaintOrdSettlmtDistrRuleHist> getEntityClass()
    {
        return MaintOrdSettlmtDistrRuleHist.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
