/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.field.MaintOrderActlPlndCostItmField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.link.MaintOrderActlPlndCostItmOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.selectable.MaintOrderActlPlndCostItmSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Detailed Cost Analysis in Maint. Order
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MaintOrderActlPlndCostItm_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MaintOrderActlPlndCostItm extends VdmEntity<MaintOrderActlPlndCostItm>
{

    /**
     * Selector for all available fields of MaintOrderActlPlndCostItm.
     *
     */
    public final static MaintOrderActlPlndCostItmSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 42
     * <p>
     * Original property name from the Odata EDM: <b>P_GLAccountHierarchy</b>
     * </p>
     *
     * @return Hierarchy ID
     */
    @Key
    @SerializedName( "P_GLAccountHierarchy" )
    @JsonProperty( "P_GLAccountHierarchy" )
    @Nullable
    @ODataField( odataName = "P_GLAccountHierarchy" )
    private String p_GLAccountHierarchy;
    /**
     * Use with available fluent helpers to apply the <b>P_GLAccountHierarchy</b> field to query operations.
     *
     */
    public final static MaintOrderActlPlndCostItmField<String> PGL_ACCOUNT_HIERARCHY =
        new MaintOrderActlPlndCostItmField<String>("P_GLAccountHierarchy");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SourceLedger</b>
     * </p>
     *
     * @return Source Ledger
     */
    @Key
    @SerializedName( "SourceLedger" )
    @JsonProperty( "SourceLedger" )
    @Nullable
    @ODataField( odataName = "SourceLedger" )
    private String sourceLedger;
    /**
     * Use with available fluent helpers to apply the <b>SourceLedger</b> field to query operations.
     *
     */
    public final static MaintOrderActlPlndCostItmField<String> SOURCE_LEDGER =
        new MaintOrderActlPlndCostItmField<String>("SourceLedger");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Ledger</b>
     * </p>
     *
     * @return Ledger in General Ledger Accounting
     */
    @Key
    @SerializedName( "Ledger" )
    @JsonProperty( "Ledger" )
    @Nullable
    @ODataField( odataName = "Ledger" )
    private String ledger;
    /**
     * Use with available fluent helpers to apply the <b>Ledger</b> field to query operations.
     *
     */
    public final static MaintOrderActlPlndCostItmField<String> LEDGER =
        new MaintOrderActlPlndCostItmField<String>("Ledger");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @Key
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static MaintOrderActlPlndCostItmField<String> COMPANY_CODE =
        new MaintOrderActlPlndCostItmField<String>("CompanyCode");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @return Fiscal Year
     */
    @Key
    @SerializedName( "FiscalYear" )
    @JsonProperty( "FiscalYear" )
    @Nullable
    @ODataField( odataName = "FiscalYear" )
    private String fiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYear</b> field to query operations.
     *
     */
    public final static MaintOrderActlPlndCostItmField<String> FISCAL_YEAR =
        new MaintOrderActlPlndCostItmField<String>("FiscalYear");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocument</b>
     * </p>
     *
     * @return Journal Entry
     */
    @Key
    @SerializedName( "AccountingDocument" )
    @JsonProperty( "AccountingDocument" )
    @Nullable
    @ODataField( odataName = "AccountingDocument" )
    private String accountingDocument;
    /**
     * Use with available fluent helpers to apply the <b>AccountingDocument</b> field to query operations.
     *
     */
    public final static MaintOrderActlPlndCostItmField<String> ACCOUNTING_DOCUMENT =
        new MaintOrderActlPlndCostItmField<String>("AccountingDocument");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 23
     * <p>
     * Original property name from the Odata EDM: <b>FinancialPlanningReqTransSqnc</b>
     * </p>
     *
     * @return Financial Planning Request Transaction Sequence Number
     */
    @Key
    @SerializedName( "FinancialPlanningReqTransSqnc" )
    @JsonProperty( "FinancialPlanningReqTransSqnc" )
    @Nullable
    @ODataField( odataName = "FinancialPlanningReqTransSqnc" )
    private String financialPlanningReqTransSqnc;
    /**
     * Use with available fluent helpers to apply the <b>FinancialPlanningReqTransSqnc</b> field to query operations.
     *
     */
    public final static MaintOrderActlPlndCostItmField<String> FINANCIAL_PLANNING_REQ_TRANS_SQNC =
        new MaintOrderActlPlndCostItmField<String>("FinancialPlanningReqTransSqnc");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>FinancialPlanningDataPacket</b>
     * </p>
     *
     * @return Financial Planning Data Packet Number
     */
    @Key
    @SerializedName( "FinancialPlanningDataPacket" )
    @JsonProperty( "FinancialPlanningDataPacket" )
    @Nullable
    @ODataField( odataName = "FinancialPlanningDataPacket" )
    private String financialPlanningDataPacket;
    /**
     * Use with available fluent helpers to apply the <b>FinancialPlanningDataPacket</b> field to query operations.
     *
     */
    public final static MaintOrderActlPlndCostItmField<String> FINANCIAL_PLANNING_DATA_PACKET =
        new MaintOrderActlPlndCostItmField<String>("FinancialPlanningDataPacket");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ActualPlanJournalEntryItem</b>
     * </p>
     *
     * @return Actual Plan Journal Entry Item
     */
    @Key
    @SerializedName( "ActualPlanJournalEntryItem" )
    @JsonProperty( "ActualPlanJournalEntryItem" )
    @Nullable
    @ODataField( odataName = "ActualPlanJournalEntryItem" )
    private String actualPlanJournalEntryItem;
    /**
     * Use with available fluent helpers to apply the <b>ActualPlanJournalEntryItem</b> field to query operations.
     *
     */
    public final static MaintOrderActlPlndCostItmField<String> ACTUAL_PLAN_JOURNAL_ENTRY_ITEM =
        new MaintOrderActlPlndCostItmField<String>("ActualPlanJournalEntryItem");
    /**
     * Constraints: Not nullable, Maximum length: 42
     * <p>
     * Original property name from the Odata EDM: <b>GLAccountHierarchy</b>
     * </p>
     *
     * @return G/L Account Hierarchy
     */
    @SerializedName( "GLAccountHierarchy" )
    @JsonProperty( "GLAccountHierarchy" )
    @Nullable
    @ODataField( odataName = "GLAccountHierarchy" )
    private String gLAccountHierarchy;
    /**
     * Use with available fluent helpers to apply the <b>GLAccountHierarchy</b> field to query operations.
     *
     */
    public final static MaintOrderActlPlndCostItmField<String> GL_ACCOUNT_HIERARCHY =
        new MaintOrderActlPlndCostItmField<String>("GLAccountHierarchy");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdCostAnlysSpendCategory</b>
     * </p>
     *
     * @return Hierarchy parent node
     */
    @SerializedName( "MaintOrdCostAnlysSpendCategory" )
    @JsonProperty( "MaintOrdCostAnlysSpendCategory" )
    @Nullable
    @ODataField( odataName = "MaintOrdCostAnlysSpendCategory" )
    private String maintOrdCostAnlysSpendCategory;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrdCostAnlysSpendCategory</b> field to query operations.
     *
     */
    public final static MaintOrderActlPlndCostItmField<String> MAINT_ORD_COST_ANLYS_SPEND_CATEGORY =
        new MaintOrderActlPlndCostItmField<String>("MaintOrdCostAnlysSpendCategory");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @return G/L Account
     */
    @SerializedName( "GLAccount" )
    @JsonProperty( "GLAccount" )
    @Nullable
    @ODataField( odataName = "GLAccount" )
    private String gLAccount;
    /**
     * Use with available fluent helpers to apply the <b>GLAccount</b> field to query operations.
     *
     */
    public final static MaintOrderActlPlndCostItmField<String> GL_ACCOUNT =
        new MaintOrderActlPlndCostItmField<String>("GLAccount");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrder</b>
     * </p>
     *
     * @return Order ID
     */
    @SerializedName( "MaintenanceOrder" )
    @JsonProperty( "MaintenanceOrder" )
    @Nullable
    @ODataField( odataName = "MaintenanceOrder" )
    private String maintenanceOrder;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceOrder</b> field to query operations.
     *
     */
    public final static MaintOrderActlPlndCostItmField<String> MAINTENANCE_ORDER =
        new MaintOrderActlPlndCostItmField<String>("MaintenanceOrder");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>CostElementGroupName</b>
     * </p>
     *
     * @return Hierarchy node description
     */
    @SerializedName( "CostElementGroupName" )
    @JsonProperty( "CostElementGroupName" )
    @Nullable
    @ODataField( odataName = "CostElementGroupName" )
    private String costElementGroupName;
    /**
     * Use with available fluent helpers to apply the <b>CostElementGroupName</b> field to query operations.
     *
     */
    public final static MaintOrderActlPlndCostItmField<String> COST_ELEMENT_GROUP_NAME =
        new MaintOrderActlPlndCostItmField<String>("CostElementGroupName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderOperation</b>
     * </p>
     *
     * @return Maintenance Order Operation
     */
    @SerializedName( "MaintenanceOrderOperation" )
    @JsonProperty( "MaintenanceOrderOperation" )
    @Nullable
    @ODataField( odataName = "MaintenanceOrderOperation" )
    private String maintenanceOrderOperation;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceOrderOperation</b> field to query operations.
     *
     */
    public final static MaintOrderActlPlndCostItmField<String> MAINTENANCE_ORDER_OPERATION =
        new MaintOrderActlPlndCostItmField<String>("MaintenanceOrderOperation");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderSubOperation</b>
     * </p>
     *
     * @return Maintenance Order Suboperation
     */
    @SerializedName( "MaintenanceOrderSubOperation" )
    @JsonProperty( "MaintenanceOrderSubOperation" )
    @Nullable
    @ODataField( odataName = "MaintenanceOrderSubOperation" )
    private String maintenanceOrderSubOperation;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceOrderSubOperation</b> field to query operations.
     *
     */
    public final static MaintOrderActlPlndCostItmField<String> MAINTENANCE_ORDER_SUB_OPERATION =
        new MaintOrderActlPlndCostItmField<String>("MaintenanceOrderSubOperation");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceActivityType</b>
     * </p>
     *
     * @return Maintenance activity type
     */
    @SerializedName( "MaintenanceActivityType" )
    @JsonProperty( "MaintenanceActivityType" )
    @Nullable
    @ODataField( odataName = "MaintenanceActivityType" )
    private String maintenanceActivityType;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceActivityType</b> field to query operations.
     *
     */
    public final static MaintOrderActlPlndCostItmField<String> MAINTENANCE_ACTIVITY_TYPE =
        new MaintOrderActlPlndCostItmField<String>("MaintenanceActivityType");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GLAccountName</b>
     * </p>
     *
     * @return G/L Account Short Text
     */
    @SerializedName( "GLAccountName" )
    @JsonProperty( "GLAccountName" )
    @Nullable
    @ODataField( odataName = "GLAccountName" )
    private String gLAccountName;
    /**
     * Use with available fluent helpers to apply the <b>GLAccountName</b> field to query operations.
     *
     */
    public final static MaintOrderActlPlndCostItmField<String> GL_ACCOUNT_NAME =
        new MaintOrderActlPlndCostItmField<String>("GLAccountName");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MainWorkCenter</b>
     * </p>
     *
     * @return Main work center for maintenance tasks
     */
    @SerializedName( "MainWorkCenter" )
    @JsonProperty( "MainWorkCenter" )
    @Nullable
    @ODataField( odataName = "MainWorkCenter" )
    private String mainWorkCenter;
    /**
     * Use with available fluent helpers to apply the <b>MainWorkCenter</b> field to query operations.
     *
     */
    public final static MaintOrderActlPlndCostItmField<String> MAIN_WORK_CENTER =
        new MaintOrderActlPlndCostItmField<String>("MainWorkCenter");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>OperationWorkCenter</b>
     * </p>
     *
     * @return Work Center
     */
    @SerializedName( "OperationWorkCenter" )
    @JsonProperty( "OperationWorkCenter" )
    @Nullable
    @ODataField( odataName = "OperationWorkCenter" )
    private String operationWorkCenter;
    /**
     * Use with available fluent helpers to apply the <b>OperationWorkCenter</b> field to query operations.
     *
     */
    public final static MaintOrderActlPlndCostItmField<String> OPERATION_WORK_CENTER =
        new MaintOrderActlPlndCostItmField<String>("OperationWorkCenter");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>ProductGroup</b>
     * </p>
     *
     * @return Product Group
     */
    @SerializedName( "ProductGroup" )
    @JsonProperty( "ProductGroup" )
    @Nullable
    @ODataField( odataName = "ProductGroup" )
    private String productGroup;
    /**
     * Use with available fluent helpers to apply the <b>ProductGroup</b> field to query operations.
     *
     */
    public final static MaintOrderActlPlndCostItmField<String> PRODUCT_GROUP =
        new MaintOrderActlPlndCostItmField<String>("ProductGroup");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Product Number
     */
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static MaintOrderActlPlndCostItmField<String> PRODUCT =
        new MaintOrderActlPlndCostItmField<String>("Product");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Assembly</b>
     * </p>
     *
     * @return Assembly
     */
    @SerializedName( "Assembly" )
    @JsonProperty( "Assembly" )
    @Nullable
    @ODataField( odataName = "Assembly" )
    private String assembly;
    /**
     * Use with available fluent helpers to apply the <b>Assembly</b> field to query operations.
     *
     */
    public final static MaintOrderActlPlndCostItmField<String> ASSEMBLY =
        new MaintOrderActlPlndCostItmField<String>("Assembly");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Equipment</b>
     * </p>
     *
     * @return Equipment Number
     */
    @SerializedName( "Equipment" )
    @JsonProperty( "Equipment" )
    @Nullable
    @ODataField( odataName = "Equipment" )
    private String equipment;
    /**
     * Use with available fluent helpers to apply the <b>Equipment</b> field to query operations.
     *
     */
    public final static MaintOrderActlPlndCostItmField<String> EQUIPMENT =
        new MaintOrderActlPlndCostItmField<String>("Equipment");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocation</b>
     * </p>
     *
     * @return Functional Location
     */
    @SerializedName( "FunctionalLocation" )
    @JsonProperty( "FunctionalLocation" )
    @Nullable
    @ODataField( odataName = "FunctionalLocation" )
    private String functionalLocation;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalLocation</b> field to query operations.
     *
     */
    public final static MaintOrderActlPlndCostItmField<String> FUNCTIONAL_LOCATION =
        new MaintOrderActlPlndCostItmField<String>("FunctionalLocation");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocument</b>
     * </p>
     *
     * @return Reference document number
     */
    @SerializedName( "ReferenceDocument" )
    @JsonProperty( "ReferenceDocument" )
    @Nullable
    @ODataField( odataName = "ReferenceDocument" )
    private String referenceDocument;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceDocument</b> field to query operations.
     *
     */
    public final static MaintOrderActlPlndCostItmField<String> REFERENCE_DOCUMENT =
        new MaintOrderActlPlndCostItmField<String>("ReferenceDocument");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentType</b>
     * </p>
     *
     * @return Reference Document Type
     */
    @SerializedName( "ReferenceDocumentType" )
    @JsonProperty( "ReferenceDocumentType" )
    @Nullable
    @ODataField( odataName = "ReferenceDocumentType" )
    private String referenceDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceDocumentType</b> field to query operations.
     *
     */
    public final static MaintOrderActlPlndCostItmField<String> REFERENCE_DOCUMENT_TYPE =
        new MaintOrderActlPlndCostItmField<String>("ReferenceDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentContext</b>
     * </p>
     *
     * @return Reference Document Context
     */
    @SerializedName( "ReferenceDocumentContext" )
    @JsonProperty( "ReferenceDocumentContext" )
    @Nullable
    @ODataField( odataName = "ReferenceDocumentContext" )
    private String referenceDocumentContext;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceDocumentContext</b> field to query operations.
     *
     */
    public final static MaintOrderActlPlndCostItmField<String> REFERENCE_DOCUMENT_CONTEXT =
        new MaintOrderActlPlndCostItmField<String>("ReferenceDocumentContext");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentItem</b>
     * </p>
     *
     * @return Reference Document Item
     */
    @SerializedName( "ReferenceDocumentItem" )
    @JsonProperty( "ReferenceDocumentItem" )
    @Nullable
    @ODataField( odataName = "ReferenceDocumentItem" )
    private String referenceDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceDocumentItem</b> field to query operations.
     *
     */
    public final static MaintOrderActlPlndCostItmField<String> REFERENCE_DOCUMENT_ITEM =
        new MaintOrderActlPlndCostItmField<String>("ReferenceDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaintPriorityType</b>
     * </p>
     *
     * @return Priority Type
     */
    @SerializedName( "MaintPriorityType" )
    @JsonProperty( "MaintPriorityType" )
    @Nullable
    @ODataField( odataName = "MaintPriorityType" )
    private String maintPriorityType;
    /**
     * Use with available fluent helpers to apply the <b>MaintPriorityType</b> field to query operations.
     *
     */
    public final static MaintOrderActlPlndCostItmField<String> MAINT_PRIORITY_TYPE =
        new MaintOrderActlPlndCostItmField<String>("MaintPriorityType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintPriority</b>
     * </p>
     *
     * @return Priority
     */
    @SerializedName( "MaintPriority" )
    @JsonProperty( "MaintPriority" )
    @Nullable
    @ODataField( odataName = "MaintPriority" )
    private String maintPriority;
    /**
     * Use with available fluent helpers to apply the <b>MaintPriority</b> field to query operations.
     *
     */
    public final static MaintOrderActlPlndCostItmField<String> MAINT_PRIORITY =
        new MaintOrderActlPlndCostItmField<String>("MaintPriority");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrder</b>
     * </p>
     *
     * @return Purchasing Document Number
     */
    @SerializedName( "PurchaseOrder" )
    @JsonProperty( "PurchaseOrder" )
    @Nullable
    @ODataField( odataName = "PurchaseOrder" )
    private String purchaseOrder;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrder</b> field to query operations.
     *
     */
    public final static MaintOrderActlPlndCostItmField<String> PURCHASE_ORDER =
        new MaintOrderActlPlndCostItmField<String>("PurchaseOrder");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderItem</b>
     * </p>
     *
     * @return Item Number of Purchasing Document
     */
    @SerializedName( "PurchaseOrderItem" )
    @JsonProperty( "PurchaseOrderItem" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderItem" )
    private String purchaseOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderItem</b> field to query operations.
     *
     */
    public final static MaintOrderActlPlndCostItmField<String> PURCHASE_ORDER_ITEM =
        new MaintOrderActlPlndCostItmField<String>("PurchaseOrderItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Reservation</b>
     * </p>
     *
     * @return Number of reservation/dependent requirements
     */
    @SerializedName( "Reservation" )
    @JsonProperty( "Reservation" )
    @Nullable
    @ODataField( odataName = "Reservation" )
    private String reservation;
    /**
     * Use with available fluent helpers to apply the <b>Reservation</b> field to query operations.
     *
     */
    public final static MaintOrderActlPlndCostItmField<String> RESERVATION =
        new MaintOrderActlPlndCostItmField<String>("Reservation");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReservationItem</b>
     * </p>
     *
     * @return Item Number of Reservation
     */
    @SerializedName( "ReservationItem" )
    @JsonProperty( "ReservationItem" )
    @Nullable
    @ODataField( odataName = "ReservationItem" )
    private String reservationItem;
    /**
     * Use with available fluent helpers to apply the <b>ReservationItem</b> field to query operations.
     *
     */
    public final static MaintOrderActlPlndCostItmField<String> RESERVATION_ITEM =
        new MaintOrderActlPlndCostItmField<String>("ReservationItem");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ReservationType</b>
     * </p>
     *
     * @return Type of Reservation
     */
    @SerializedName( "ReservationType" )
    @JsonProperty( "ReservationType" )
    @Nullable
    @ODataField( odataName = "ReservationType" )
    private String reservationType;
    /**
     * Use with available fluent helpers to apply the <b>ReservationType</b> field to query operations.
     *
     */
    public final static MaintOrderActlPlndCostItmField<String> RESERVATION_TYPE =
        new MaintOrderActlPlndCostItmField<String>("ReservationType");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>GlobalCurrency</b>
     * </p>
     *
     * @return Global Currency
     */
    @SerializedName( "GlobalCurrency" )
    @JsonProperty( "GlobalCurrency" )
    @Nullable
    @ODataField( odataName = "GlobalCurrency" )
    private String globalCurrency;
    /**
     * Use with available fluent helpers to apply the <b>GlobalCurrency</b> field to query operations.
     *
     */
    public final static MaintOrderActlPlndCostItmField<String> GLOBAL_CURRENCY =
        new MaintOrderActlPlndCostItmField<String>("GlobalCurrency");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInGlobalCurrency</b>
     * </p>
     *
     * @return Amount in Global Currency
     */
    @SerializedName( "AmountInGlobalCurrency" )
    @JsonProperty( "AmountInGlobalCurrency" )
    @Nullable
    @ODataField( odataName = "AmountInGlobalCurrency" )
    private BigDecimal amountInGlobalCurrency;
    /**
     * Use with available fluent helpers to apply the <b>AmountInGlobalCurrency</b> field to query operations.
     *
     */
    public final static MaintOrderActlPlndCostItmField<BigDecimal> AMOUNT_IN_GLOBAL_CURRENCY =
        new MaintOrderActlPlndCostItmField<BigDecimal>("AmountInGlobalCurrency");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ActualMaintAmountInGlobCrcy</b>
     * </p>
     *
     * @return Amount in Company Code Currency
     */
    @SerializedName( "ActualMaintAmountInGlobCrcy" )
    @JsonProperty( "ActualMaintAmountInGlobCrcy" )
    @Nullable
    @ODataField( odataName = "ActualMaintAmountInGlobCrcy" )
    private BigDecimal actualMaintAmountInGlobCrcy;
    /**
     * Use with available fluent helpers to apply the <b>ActualMaintAmountInGlobCrcy</b> field to query operations.
     *
     */
    public final static MaintOrderActlPlndCostItmField<BigDecimal> ACTUAL_MAINT_AMOUNT_IN_GLOB_CRCY =
        new MaintOrderActlPlndCostItmField<BigDecimal>("ActualMaintAmountInGlobCrcy");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlannedMaintAmountInGlobCrcy</b>
     * </p>
     *
     * @return Amount in Company Code Currency
     */
    @SerializedName( "PlannedMaintAmountInGlobCrcy" )
    @JsonProperty( "PlannedMaintAmountInGlobCrcy" )
    @Nullable
    @ODataField( odataName = "PlannedMaintAmountInGlobCrcy" )
    private BigDecimal plannedMaintAmountInGlobCrcy;
    /**
     * Use with available fluent helpers to apply the <b>PlannedMaintAmountInGlobCrcy</b> field to query operations.
     *
     */
    public final static MaintOrderActlPlndCostItmField<BigDecimal> PLANNED_MAINT_AMOUNT_IN_GLOB_CRCY =
        new MaintOrderActlPlndCostItmField<BigDecimal>("PlannedMaintAmountInGlobCrcy");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaselineMaintAmountInGlobCrcy</b>
     * </p>
     *
     * @return Amount in Company Code Currency
     */
    @SerializedName( "BaselineMaintAmountInGlobCrcy" )
    @JsonProperty( "BaselineMaintAmountInGlobCrcy" )
    @Nullable
    @ODataField( odataName = "BaselineMaintAmountInGlobCrcy" )
    private BigDecimal baselineMaintAmountInGlobCrcy;
    /**
     * Use with available fluent helpers to apply the <b>BaselineMaintAmountInGlobCrcy</b> field to query operations.
     *
     */
    public final static MaintOrderActlPlndCostItmField<BigDecimal> BASELINE_MAINT_AMOUNT_IN_GLOB_CRCY =
        new MaintOrderActlPlndCostItmField<BigDecimal>("BaselineMaintAmountInGlobCrcy");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>EstimatedMaintAmountInGlobCrcy</b>
     * </p>
     *
     * @return Amount in Company Code Currency
     */
    @SerializedName( "EstimatedMaintAmountInGlobCrcy" )
    @JsonProperty( "EstimatedMaintAmountInGlobCrcy" )
    @Nullable
    @ODataField( odataName = "EstimatedMaintAmountInGlobCrcy" )
    private BigDecimal estimatedMaintAmountInGlobCrcy;
    /**
     * Use with available fluent helpers to apply the <b>EstimatedMaintAmountInGlobCrcy</b> field to query operations.
     *
     */
    public final static MaintOrderActlPlndCostItmField<BigDecimal> ESTIMATED_MAINT_AMOUNT_IN_GLOB_CRCY =
        new MaintOrderActlPlndCostItmField<BigDecimal>("EstimatedMaintAmountInGlobCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeCurrency</b>
     * </p>
     *
     * @return Company Code Currency
     */
    @SerializedName( "CompanyCodeCurrency" )
    @JsonProperty( "CompanyCodeCurrency" )
    @Nullable
    @ODataField( odataName = "CompanyCodeCurrency" )
    private String companyCodeCurrency;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCodeCurrency</b> field to query operations.
     *
     */
    public final static MaintOrderActlPlndCostItmField<String> COMPANY_CODE_CURRENCY =
        new MaintOrderActlPlndCostItmField<String>("CompanyCodeCurrency");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInCompanyCodeCurrency</b>
     * </p>
     *
     * @return Amount in Company Code Currency
     */
    @SerializedName( "AmountInCompanyCodeCurrency" )
    @JsonProperty( "AmountInCompanyCodeCurrency" )
    @Nullable
    @ODataField( odataName = "AmountInCompanyCodeCurrency" )
    private BigDecimal amountInCompanyCodeCurrency;
    /**
     * Use with available fluent helpers to apply the <b>AmountInCompanyCodeCurrency</b> field to query operations.
     *
     */
    public final static MaintOrderActlPlndCostItmField<BigDecimal> AMOUNT_IN_COMPANY_CODE_CURRENCY =
        new MaintOrderActlPlndCostItmField<BigDecimal>("AmountInCompanyCodeCurrency");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ActualMaintAmountInCoCrcy</b>
     * </p>
     *
     * @return Amount in Company Code Currency
     */
    @SerializedName( "ActualMaintAmountInCoCrcy" )
    @JsonProperty( "ActualMaintAmountInCoCrcy" )
    @Nullable
    @ODataField( odataName = "ActualMaintAmountInCoCrcy" )
    private BigDecimal actualMaintAmountInCoCrcy;
    /**
     * Use with available fluent helpers to apply the <b>ActualMaintAmountInCoCrcy</b> field to query operations.
     *
     */
    public final static MaintOrderActlPlndCostItmField<BigDecimal> ACTUAL_MAINT_AMOUNT_IN_CO_CRCY =
        new MaintOrderActlPlndCostItmField<BigDecimal>("ActualMaintAmountInCoCrcy");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlannedMaintAmountInCoCrcy</b>
     * </p>
     *
     * @return Amount in Company Code Currency
     */
    @SerializedName( "PlannedMaintAmountInCoCrcy" )
    @JsonProperty( "PlannedMaintAmountInCoCrcy" )
    @Nullable
    @ODataField( odataName = "PlannedMaintAmountInCoCrcy" )
    private BigDecimal plannedMaintAmountInCoCrcy;
    /**
     * Use with available fluent helpers to apply the <b>PlannedMaintAmountInCoCrcy</b> field to query operations.
     *
     */
    public final static MaintOrderActlPlndCostItmField<BigDecimal> PLANNED_MAINT_AMOUNT_IN_CO_CRCY =
        new MaintOrderActlPlndCostItmField<BigDecimal>("PlannedMaintAmountInCoCrcy");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaselineMaintAmountInCoCrcy</b>
     * </p>
     *
     * @return Amount in Company Code Currency
     */
    @SerializedName( "BaselineMaintAmountInCoCrcy" )
    @JsonProperty( "BaselineMaintAmountInCoCrcy" )
    @Nullable
    @ODataField( odataName = "BaselineMaintAmountInCoCrcy" )
    private BigDecimal baselineMaintAmountInCoCrcy;
    /**
     * Use with available fluent helpers to apply the <b>BaselineMaintAmountInCoCrcy</b> field to query operations.
     *
     */
    public final static MaintOrderActlPlndCostItmField<BigDecimal> BASELINE_MAINT_AMOUNT_IN_CO_CRCY =
        new MaintOrderActlPlndCostItmField<BigDecimal>("BaselineMaintAmountInCoCrcy");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>EstimatedMaintAmountInCoCrcy</b>
     * </p>
     *
     * @return Amount in Company Code Currency
     */
    @SerializedName( "EstimatedMaintAmountInCoCrcy" )
    @JsonProperty( "EstimatedMaintAmountInCoCrcy" )
    @Nullable
    @ODataField( odataName = "EstimatedMaintAmountInCoCrcy" )
    private BigDecimal estimatedMaintAmountInCoCrcy;
    /**
     * Use with available fluent helpers to apply the <b>EstimatedMaintAmountInCoCrcy</b> field to query operations.
     *
     */
    public final static MaintOrderActlPlndCostItmField<BigDecimal> ESTIMATED_MAINT_AMOUNT_IN_CO_CRCY =
        new MaintOrderActlPlndCostItmField<BigDecimal>("EstimatedMaintAmountInCoCrcy");
    /**
     * Navigation property <b>to_MaintenanceOrder</b> for <b>MaintOrderActlPlndCostItm</b> to single
     * <b>MaintenanceOrder</b>.
     *
     */
    @SerializedName( "to_MaintenanceOrder" )
    @JsonProperty( "to_MaintenanceOrder" )
    @ODataField( odataName = "to_MaintenanceOrder" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private MaintenanceOrder toMaintenanceOrder;
    /**
     * Navigation property <b>to_MaintenanceOrderOpComponent</b> for <b>MaintOrderActlPlndCostItm</b> to single
     * <b>MaintOrderOpComponent</b>.
     *
     */
    @SerializedName( "to_MaintenanceOrderOpComponent" )
    @JsonProperty( "to_MaintenanceOrderOpComponent" )
    @ODataField( odataName = "to_MaintenanceOrderOpComponent" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private MaintOrderOpComponent toMaintenanceOrderOpComponent;
    /**
     * Navigation property <b>to_MaintenanceOrderOperation</b> for <b>MaintOrderActlPlndCostItm</b> to single
     * <b>MaintenanceOrderOperation</b>.
     *
     */
    @SerializedName( "to_MaintenanceOrderOperation" )
    @JsonProperty( "to_MaintenanceOrderOperation" )
    @ODataField( odataName = "to_MaintenanceOrderOperation" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private MaintenanceOrderOperation toMaintenanceOrderOperation;
    /**
     * Navigation property <b>Parameters</b> for <b>MaintOrderActlPlndCostItm</b> to single
     * <b>MaintOrderActlPlndCostItm_TypeParameters</b>.
     *
     */
    @SerializedName( "Parameters" )
    @JsonProperty( "Parameters" )
    @ODataField( odataName = "Parameters" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private MaintOrderActlPlndCostItm_TypeParameters toParameters;
    /**
     * Use with available fluent helpers to apply the <b>to_MaintenanceOrder</b> navigation property to query
     * operations.
     *
     */
    public final static MaintOrderActlPlndCostItmOneToOneLink<MaintenanceOrder> TO_MAINTENANCE_ORDER =
        new MaintOrderActlPlndCostItmOneToOneLink<MaintenanceOrder>("to_MaintenanceOrder");
    /**
     * Use with available fluent helpers to apply the <b>to_MaintenanceOrderOpComponent</b> navigation property to query
     * operations.
     *
     */
    public final static MaintOrderActlPlndCostItmOneToOneLink<MaintOrderOpComponent> TO_MAINTENANCE_ORDER_OP_COMPONENT =
        new MaintOrderActlPlndCostItmOneToOneLink<MaintOrderOpComponent>("to_MaintenanceOrderOpComponent");
    /**
     * Use with available fluent helpers to apply the <b>to_MaintenanceOrderOperation</b> navigation property to query
     * operations.
     *
     */
    public final static MaintOrderActlPlndCostItmOneToOneLink<MaintenanceOrderOperation> TO_MAINTENANCE_ORDER_OPERATION =
        new MaintOrderActlPlndCostItmOneToOneLink<MaintenanceOrderOperation>("to_MaintenanceOrderOperation");
    /**
     * Use with available fluent helpers to apply the <b>Parameters</b> navigation property to query operations.
     *
     */
    public final static MaintOrderActlPlndCostItmOneToOneLink<MaintOrderActlPlndCostItm_TypeParameters> TO_PARAMETERS =
        new MaintOrderActlPlndCostItmOneToOneLink<MaintOrderActlPlndCostItm_TypeParameters>("Parameters");

    @Nonnull
    @Override
    public Class<MaintOrderActlPlndCostItm> getType()
    {
        return MaintOrderActlPlndCostItm.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 42
     * <p>
     * Original property name from the Odata EDM: <b>P_GLAccountHierarchy</b>
     * </p>
     *
     * @param p_GLAccountHierarchy
     *            Hierarchy ID
     */
    public void setP_GLAccountHierarchy( @Nullable final String p_GLAccountHierarchy )
    {
        rememberChangedField("P_GLAccountHierarchy", this.p_GLAccountHierarchy);
        this.p_GLAccountHierarchy = p_GLAccountHierarchy;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SourceLedger</b>
     * </p>
     *
     * @param sourceLedger
     *            Source Ledger
     */
    public void setSourceLedger( @Nullable final String sourceLedger )
    {
        rememberChangedField("SourceLedger", this.sourceLedger);
        this.sourceLedger = sourceLedger;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Ledger</b>
     * </p>
     *
     * @param ledger
     *            Ledger in General Ledger Accounting
     */
    public void setLedger( @Nullable final String ledger )
    {
        rememberChangedField("Ledger", this.ledger);
        this.ledger = ledger;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @param fiscalYear
     *            Fiscal Year
     */
    public void setFiscalYear( @Nullable final String fiscalYear )
    {
        rememberChangedField("FiscalYear", this.fiscalYear);
        this.fiscalYear = fiscalYear;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocument</b>
     * </p>
     *
     * @param accountingDocument
     *            Journal Entry
     */
    public void setAccountingDocument( @Nullable final String accountingDocument )
    {
        rememberChangedField("AccountingDocument", this.accountingDocument);
        this.accountingDocument = accountingDocument;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 23
     * <p>
     * Original property name from the Odata EDM: <b>FinancialPlanningReqTransSqnc</b>
     * </p>
     *
     * @param financialPlanningReqTransSqnc
     *            Financial Planning Request Transaction Sequence Number
     */
    public void setFinancialPlanningReqTransSqnc( @Nullable final String financialPlanningReqTransSqnc )
    {
        rememberChangedField("FinancialPlanningReqTransSqnc", this.financialPlanningReqTransSqnc);
        this.financialPlanningReqTransSqnc = financialPlanningReqTransSqnc;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>FinancialPlanningDataPacket</b>
     * </p>
     *
     * @param financialPlanningDataPacket
     *            Financial Planning Data Packet Number
     */
    public void setFinancialPlanningDataPacket( @Nullable final String financialPlanningDataPacket )
    {
        rememberChangedField("FinancialPlanningDataPacket", this.financialPlanningDataPacket);
        this.financialPlanningDataPacket = financialPlanningDataPacket;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ActualPlanJournalEntryItem</b>
     * </p>
     *
     * @param actualPlanJournalEntryItem
     *            Actual Plan Journal Entry Item
     */
    public void setActualPlanJournalEntryItem( @Nullable final String actualPlanJournalEntryItem )
    {
        rememberChangedField("ActualPlanJournalEntryItem", this.actualPlanJournalEntryItem);
        this.actualPlanJournalEntryItem = actualPlanJournalEntryItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 42
     * <p>
     * Original property name from the Odata EDM: <b>GLAccountHierarchy</b>
     * </p>
     *
     * @param gLAccountHierarchy
     *            G/L Account Hierarchy
     */
    public void setGLAccountHierarchy( @Nullable final String gLAccountHierarchy )
    {
        rememberChangedField("GLAccountHierarchy", this.gLAccountHierarchy);
        this.gLAccountHierarchy = gLAccountHierarchy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdCostAnlysSpendCategory</b>
     * </p>
     *
     * @param maintOrdCostAnlysSpendCategory
     *            Hierarchy parent node
     */
    public void setMaintOrdCostAnlysSpendCategory( @Nullable final String maintOrdCostAnlysSpendCategory )
    {
        rememberChangedField("MaintOrdCostAnlysSpendCategory", this.maintOrdCostAnlysSpendCategory);
        this.maintOrdCostAnlysSpendCategory = maintOrdCostAnlysSpendCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @param gLAccount
     *            G/L Account
     */
    public void setGLAccount( @Nullable final String gLAccount )
    {
        rememberChangedField("GLAccount", this.gLAccount);
        this.gLAccount = gLAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrder</b>
     * </p>
     *
     * @param maintenanceOrder
     *            Order ID
     */
    public void setMaintenanceOrder( @Nullable final String maintenanceOrder )
    {
        rememberChangedField("MaintenanceOrder", this.maintenanceOrder);
        this.maintenanceOrder = maintenanceOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>CostElementGroupName</b>
     * </p>
     *
     * @param costElementGroupName
     *            Hierarchy node description
     */
    public void setCostElementGroupName( @Nullable final String costElementGroupName )
    {
        rememberChangedField("CostElementGroupName", this.costElementGroupName);
        this.costElementGroupName = costElementGroupName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderOperation</b>
     * </p>
     *
     * @param maintenanceOrderOperation
     *            Maintenance Order Operation
     */
    public void setMaintenanceOrderOperation( @Nullable final String maintenanceOrderOperation )
    {
        rememberChangedField("MaintenanceOrderOperation", this.maintenanceOrderOperation);
        this.maintenanceOrderOperation = maintenanceOrderOperation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderSubOperation</b>
     * </p>
     *
     * @param maintenanceOrderSubOperation
     *            Maintenance Order Suboperation
     */
    public void setMaintenanceOrderSubOperation( @Nullable final String maintenanceOrderSubOperation )
    {
        rememberChangedField("MaintenanceOrderSubOperation", this.maintenanceOrderSubOperation);
        this.maintenanceOrderSubOperation = maintenanceOrderSubOperation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceActivityType</b>
     * </p>
     *
     * @param maintenanceActivityType
     *            Maintenance activity type
     */
    public void setMaintenanceActivityType( @Nullable final String maintenanceActivityType )
    {
        rememberChangedField("MaintenanceActivityType", this.maintenanceActivityType);
        this.maintenanceActivityType = maintenanceActivityType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GLAccountName</b>
     * </p>
     *
     * @param gLAccountName
     *            G/L Account Short Text
     */
    public void setGLAccountName( @Nullable final String gLAccountName )
    {
        rememberChangedField("GLAccountName", this.gLAccountName);
        this.gLAccountName = gLAccountName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MainWorkCenter</b>
     * </p>
     *
     * @param mainWorkCenter
     *            Main work center for maintenance tasks
     */
    public void setMainWorkCenter( @Nullable final String mainWorkCenter )
    {
        rememberChangedField("MainWorkCenter", this.mainWorkCenter);
        this.mainWorkCenter = mainWorkCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>OperationWorkCenter</b>
     * </p>
     *
     * @param operationWorkCenter
     *            Work Center
     */
    public void setOperationWorkCenter( @Nullable final String operationWorkCenter )
    {
        rememberChangedField("OperationWorkCenter", this.operationWorkCenter);
        this.operationWorkCenter = operationWorkCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>ProductGroup</b>
     * </p>
     *
     * @param productGroup
     *            Product Group
     */
    public void setProductGroup( @Nullable final String productGroup )
    {
        rememberChangedField("ProductGroup", this.productGroup);
        this.productGroup = productGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Product Number
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Assembly</b>
     * </p>
     *
     * @param assembly
     *            Assembly
     */
    public void setAssembly( @Nullable final String assembly )
    {
        rememberChangedField("Assembly", this.assembly);
        this.assembly = assembly;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Equipment</b>
     * </p>
     *
     * @param equipment
     *            Equipment Number
     */
    public void setEquipment( @Nullable final String equipment )
    {
        rememberChangedField("Equipment", this.equipment);
        this.equipment = equipment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocation</b>
     * </p>
     *
     * @param functionalLocation
     *            Functional Location
     */
    public void setFunctionalLocation( @Nullable final String functionalLocation )
    {
        rememberChangedField("FunctionalLocation", this.functionalLocation);
        this.functionalLocation = functionalLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocument</b>
     * </p>
     *
     * @param referenceDocument
     *            Reference document number
     */
    public void setReferenceDocument( @Nullable final String referenceDocument )
    {
        rememberChangedField("ReferenceDocument", this.referenceDocument);
        this.referenceDocument = referenceDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentType</b>
     * </p>
     *
     * @param referenceDocumentType
     *            Reference Document Type
     */
    public void setReferenceDocumentType( @Nullable final String referenceDocumentType )
    {
        rememberChangedField("ReferenceDocumentType", this.referenceDocumentType);
        this.referenceDocumentType = referenceDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentContext</b>
     * </p>
     *
     * @param referenceDocumentContext
     *            Reference Document Context
     */
    public void setReferenceDocumentContext( @Nullable final String referenceDocumentContext )
    {
        rememberChangedField("ReferenceDocumentContext", this.referenceDocumentContext);
        this.referenceDocumentContext = referenceDocumentContext;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentItem</b>
     * </p>
     *
     * @param referenceDocumentItem
     *            Reference Document Item
     */
    public void setReferenceDocumentItem( @Nullable final String referenceDocumentItem )
    {
        rememberChangedField("ReferenceDocumentItem", this.referenceDocumentItem);
        this.referenceDocumentItem = referenceDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaintPriorityType</b>
     * </p>
     *
     * @param maintPriorityType
     *            Priority Type
     */
    public void setMaintPriorityType( @Nullable final String maintPriorityType )
    {
        rememberChangedField("MaintPriorityType", this.maintPriorityType);
        this.maintPriorityType = maintPriorityType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintPriority</b>
     * </p>
     *
     * @param maintPriority
     *            Priority
     */
    public void setMaintPriority( @Nullable final String maintPriority )
    {
        rememberChangedField("MaintPriority", this.maintPriority);
        this.maintPriority = maintPriority;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrder</b>
     * </p>
     *
     * @param purchaseOrder
     *            Purchasing Document Number
     */
    public void setPurchaseOrder( @Nullable final String purchaseOrder )
    {
        rememberChangedField("PurchaseOrder", this.purchaseOrder);
        this.purchaseOrder = purchaseOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderItem</b>
     * </p>
     *
     * @param purchaseOrderItem
     *            Item Number of Purchasing Document
     */
    public void setPurchaseOrderItem( @Nullable final String purchaseOrderItem )
    {
        rememberChangedField("PurchaseOrderItem", this.purchaseOrderItem);
        this.purchaseOrderItem = purchaseOrderItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Reservation</b>
     * </p>
     *
     * @param reservation
     *            Number of reservation/dependent requirements
     */
    public void setReservation( @Nullable final String reservation )
    {
        rememberChangedField("Reservation", this.reservation);
        this.reservation = reservation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReservationItem</b>
     * </p>
     *
     * @param reservationItem
     *            Item Number of Reservation
     */
    public void setReservationItem( @Nullable final String reservationItem )
    {
        rememberChangedField("ReservationItem", this.reservationItem);
        this.reservationItem = reservationItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ReservationType</b>
     * </p>
     *
     * @param reservationType
     *            Type of Reservation
     */
    public void setReservationType( @Nullable final String reservationType )
    {
        rememberChangedField("ReservationType", this.reservationType);
        this.reservationType = reservationType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>GlobalCurrency</b>
     * </p>
     *
     * @param globalCurrency
     *            Global Currency
     */
    public void setGlobalCurrency( @Nullable final String globalCurrency )
    {
        rememberChangedField("GlobalCurrency", this.globalCurrency);
        this.globalCurrency = globalCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInGlobalCurrency</b>
     * </p>
     *
     * @param amountInGlobalCurrency
     *            Amount in Global Currency
     */
    public void setAmountInGlobalCurrency( @Nullable final BigDecimal amountInGlobalCurrency )
    {
        rememberChangedField("AmountInGlobalCurrency", this.amountInGlobalCurrency);
        this.amountInGlobalCurrency = amountInGlobalCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ActualMaintAmountInGlobCrcy</b>
     * </p>
     *
     * @param actualMaintAmountInGlobCrcy
     *            Amount in Company Code Currency
     */
    public void setActualMaintAmountInGlobCrcy( @Nullable final BigDecimal actualMaintAmountInGlobCrcy )
    {
        rememberChangedField("ActualMaintAmountInGlobCrcy", this.actualMaintAmountInGlobCrcy);
        this.actualMaintAmountInGlobCrcy = actualMaintAmountInGlobCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlannedMaintAmountInGlobCrcy</b>
     * </p>
     *
     * @param plannedMaintAmountInGlobCrcy
     *            Amount in Company Code Currency
     */
    public void setPlannedMaintAmountInGlobCrcy( @Nullable final BigDecimal plannedMaintAmountInGlobCrcy )
    {
        rememberChangedField("PlannedMaintAmountInGlobCrcy", this.plannedMaintAmountInGlobCrcy);
        this.plannedMaintAmountInGlobCrcy = plannedMaintAmountInGlobCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaselineMaintAmountInGlobCrcy</b>
     * </p>
     *
     * @param baselineMaintAmountInGlobCrcy
     *            Amount in Company Code Currency
     */
    public void setBaselineMaintAmountInGlobCrcy( @Nullable final BigDecimal baselineMaintAmountInGlobCrcy )
    {
        rememberChangedField("BaselineMaintAmountInGlobCrcy", this.baselineMaintAmountInGlobCrcy);
        this.baselineMaintAmountInGlobCrcy = baselineMaintAmountInGlobCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>EstimatedMaintAmountInGlobCrcy</b>
     * </p>
     *
     * @param estimatedMaintAmountInGlobCrcy
     *            Amount in Company Code Currency
     */
    public void setEstimatedMaintAmountInGlobCrcy( @Nullable final BigDecimal estimatedMaintAmountInGlobCrcy )
    {
        rememberChangedField("EstimatedMaintAmountInGlobCrcy", this.estimatedMaintAmountInGlobCrcy);
        this.estimatedMaintAmountInGlobCrcy = estimatedMaintAmountInGlobCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeCurrency</b>
     * </p>
     *
     * @param companyCodeCurrency
     *            Company Code Currency
     */
    public void setCompanyCodeCurrency( @Nullable final String companyCodeCurrency )
    {
        rememberChangedField("CompanyCodeCurrency", this.companyCodeCurrency);
        this.companyCodeCurrency = companyCodeCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInCompanyCodeCurrency</b>
     * </p>
     *
     * @param amountInCompanyCodeCurrency
     *            Amount in Company Code Currency
     */
    public void setAmountInCompanyCodeCurrency( @Nullable final BigDecimal amountInCompanyCodeCurrency )
    {
        rememberChangedField("AmountInCompanyCodeCurrency", this.amountInCompanyCodeCurrency);
        this.amountInCompanyCodeCurrency = amountInCompanyCodeCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ActualMaintAmountInCoCrcy</b>
     * </p>
     *
     * @param actualMaintAmountInCoCrcy
     *            Amount in Company Code Currency
     */
    public void setActualMaintAmountInCoCrcy( @Nullable final BigDecimal actualMaintAmountInCoCrcy )
    {
        rememberChangedField("ActualMaintAmountInCoCrcy", this.actualMaintAmountInCoCrcy);
        this.actualMaintAmountInCoCrcy = actualMaintAmountInCoCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlannedMaintAmountInCoCrcy</b>
     * </p>
     *
     * @param plannedMaintAmountInCoCrcy
     *            Amount in Company Code Currency
     */
    public void setPlannedMaintAmountInCoCrcy( @Nullable final BigDecimal plannedMaintAmountInCoCrcy )
    {
        rememberChangedField("PlannedMaintAmountInCoCrcy", this.plannedMaintAmountInCoCrcy);
        this.plannedMaintAmountInCoCrcy = plannedMaintAmountInCoCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaselineMaintAmountInCoCrcy</b>
     * </p>
     *
     * @param baselineMaintAmountInCoCrcy
     *            Amount in Company Code Currency
     */
    public void setBaselineMaintAmountInCoCrcy( @Nullable final BigDecimal baselineMaintAmountInCoCrcy )
    {
        rememberChangedField("BaselineMaintAmountInCoCrcy", this.baselineMaintAmountInCoCrcy);
        this.baselineMaintAmountInCoCrcy = baselineMaintAmountInCoCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>EstimatedMaintAmountInCoCrcy</b>
     * </p>
     *
     * @param estimatedMaintAmountInCoCrcy
     *            Amount in Company Code Currency
     */
    public void setEstimatedMaintAmountInCoCrcy( @Nullable final BigDecimal estimatedMaintAmountInCoCrcy )
    {
        rememberChangedField("EstimatedMaintAmountInCoCrcy", this.estimatedMaintAmountInCoCrcy);
        this.estimatedMaintAmountInCoCrcy = estimatedMaintAmountInCoCrcy;
    }

    @Override
    protected String getEntityCollection()
    {
        return "MaintOrderActlPlndCostItmSet";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("P_GLAccountHierarchy", getP_GLAccountHierarchy());
        result.put("SourceLedger", getSourceLedger());
        result.put("Ledger", getLedger());
        result.put("CompanyCode", getCompanyCode());
        result.put("FiscalYear", getFiscalYear());
        result.put("AccountingDocument", getAccountingDocument());
        result.put("FinancialPlanningReqTransSqnc", getFinancialPlanningReqTransSqnc());
        result.put("FinancialPlanningDataPacket", getFinancialPlanningDataPacket());
        result.put("ActualPlanJournalEntryItem", getActualPlanJournalEntryItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("P_GLAccountHierarchy", getP_GLAccountHierarchy());
        values.put("SourceLedger", getSourceLedger());
        values.put("Ledger", getLedger());
        values.put("CompanyCode", getCompanyCode());
        values.put("FiscalYear", getFiscalYear());
        values.put("AccountingDocument", getAccountingDocument());
        values.put("FinancialPlanningReqTransSqnc", getFinancialPlanningReqTransSqnc());
        values.put("FinancialPlanningDataPacket", getFinancialPlanningDataPacket());
        values.put("ActualPlanJournalEntryItem", getActualPlanJournalEntryItem());
        values.put("GLAccountHierarchy", getGLAccountHierarchy());
        values.put("MaintOrdCostAnlysSpendCategory", getMaintOrdCostAnlysSpendCategory());
        values.put("GLAccount", getGLAccount());
        values.put("MaintenanceOrder", getMaintenanceOrder());
        values.put("CostElementGroupName", getCostElementGroupName());
        values.put("MaintenanceOrderOperation", getMaintenanceOrderOperation());
        values.put("MaintenanceOrderSubOperation", getMaintenanceOrderSubOperation());
        values.put("MaintenanceActivityType", getMaintenanceActivityType());
        values.put("GLAccountName", getGLAccountName());
        values.put("MainWorkCenter", getMainWorkCenter());
        values.put("OperationWorkCenter", getOperationWorkCenter());
        values.put("ProductGroup", getProductGroup());
        values.put("Product", getProduct());
        values.put("Assembly", getAssembly());
        values.put("Equipment", getEquipment());
        values.put("FunctionalLocation", getFunctionalLocation());
        values.put("ReferenceDocument", getReferenceDocument());
        values.put("ReferenceDocumentType", getReferenceDocumentType());
        values.put("ReferenceDocumentContext", getReferenceDocumentContext());
        values.put("ReferenceDocumentItem", getReferenceDocumentItem());
        values.put("MaintPriorityType", getMaintPriorityType());
        values.put("MaintPriority", getMaintPriority());
        values.put("PurchaseOrder", getPurchaseOrder());
        values.put("PurchaseOrderItem", getPurchaseOrderItem());
        values.put("Reservation", getReservation());
        values.put("ReservationItem", getReservationItem());
        values.put("ReservationType", getReservationType());
        values.put("GlobalCurrency", getGlobalCurrency());
        values.put("AmountInGlobalCurrency", getAmountInGlobalCurrency());
        values.put("ActualMaintAmountInGlobCrcy", getActualMaintAmountInGlobCrcy());
        values.put("PlannedMaintAmountInGlobCrcy", getPlannedMaintAmountInGlobCrcy());
        values.put("BaselineMaintAmountInGlobCrcy", getBaselineMaintAmountInGlobCrcy());
        values.put("EstimatedMaintAmountInGlobCrcy", getEstimatedMaintAmountInGlobCrcy());
        values.put("CompanyCodeCurrency", getCompanyCodeCurrency());
        values.put("AmountInCompanyCodeCurrency", getAmountInCompanyCodeCurrency());
        values.put("ActualMaintAmountInCoCrcy", getActualMaintAmountInCoCrcy());
        values.put("PlannedMaintAmountInCoCrcy", getPlannedMaintAmountInCoCrcy());
        values.put("BaselineMaintAmountInCoCrcy", getBaselineMaintAmountInCoCrcy());
        values.put("EstimatedMaintAmountInCoCrcy", getEstimatedMaintAmountInCoCrcy());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("P_GLAccountHierarchy") ) {
                final Object value = values.remove("P_GLAccountHierarchy");
                if( (value == null) || (!value.equals(getP_GLAccountHierarchy())) ) {
                    setP_GLAccountHierarchy(((String) value));
                }
            }
            if( values.containsKey("SourceLedger") ) {
                final Object value = values.remove("SourceLedger");
                if( (value == null) || (!value.equals(getSourceLedger())) ) {
                    setSourceLedger(((String) value));
                }
            }
            if( values.containsKey("Ledger") ) {
                final Object value = values.remove("Ledger");
                if( (value == null) || (!value.equals(getLedger())) ) {
                    setLedger(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("FiscalYear") ) {
                final Object value = values.remove("FiscalYear");
                if( (value == null) || (!value.equals(getFiscalYear())) ) {
                    setFiscalYear(((String) value));
                }
            }
            if( values.containsKey("AccountingDocument") ) {
                final Object value = values.remove("AccountingDocument");
                if( (value == null) || (!value.equals(getAccountingDocument())) ) {
                    setAccountingDocument(((String) value));
                }
            }
            if( values.containsKey("FinancialPlanningReqTransSqnc") ) {
                final Object value = values.remove("FinancialPlanningReqTransSqnc");
                if( (value == null) || (!value.equals(getFinancialPlanningReqTransSqnc())) ) {
                    setFinancialPlanningReqTransSqnc(((String) value));
                }
            }
            if( values.containsKey("FinancialPlanningDataPacket") ) {
                final Object value = values.remove("FinancialPlanningDataPacket");
                if( (value == null) || (!value.equals(getFinancialPlanningDataPacket())) ) {
                    setFinancialPlanningDataPacket(((String) value));
                }
            }
            if( values.containsKey("ActualPlanJournalEntryItem") ) {
                final Object value = values.remove("ActualPlanJournalEntryItem");
                if( (value == null) || (!value.equals(getActualPlanJournalEntryItem())) ) {
                    setActualPlanJournalEntryItem(((String) value));
                }
            }
            if( values.containsKey("GLAccountHierarchy") ) {
                final Object value = values.remove("GLAccountHierarchy");
                if( (value == null) || (!value.equals(getGLAccountHierarchy())) ) {
                    setGLAccountHierarchy(((String) value));
                }
            }
            if( values.containsKey("MaintOrdCostAnlysSpendCategory") ) {
                final Object value = values.remove("MaintOrdCostAnlysSpendCategory");
                if( (value == null) || (!value.equals(getMaintOrdCostAnlysSpendCategory())) ) {
                    setMaintOrdCostAnlysSpendCategory(((String) value));
                }
            }
            if( values.containsKey("GLAccount") ) {
                final Object value = values.remove("GLAccount");
                if( (value == null) || (!value.equals(getGLAccount())) ) {
                    setGLAccount(((String) value));
                }
            }
            if( values.containsKey("MaintenanceOrder") ) {
                final Object value = values.remove("MaintenanceOrder");
                if( (value == null) || (!value.equals(getMaintenanceOrder())) ) {
                    setMaintenanceOrder(((String) value));
                }
            }
            if( values.containsKey("CostElementGroupName") ) {
                final Object value = values.remove("CostElementGroupName");
                if( (value == null) || (!value.equals(getCostElementGroupName())) ) {
                    setCostElementGroupName(((String) value));
                }
            }
            if( values.containsKey("MaintenanceOrderOperation") ) {
                final Object value = values.remove("MaintenanceOrderOperation");
                if( (value == null) || (!value.equals(getMaintenanceOrderOperation())) ) {
                    setMaintenanceOrderOperation(((String) value));
                }
            }
            if( values.containsKey("MaintenanceOrderSubOperation") ) {
                final Object value = values.remove("MaintenanceOrderSubOperation");
                if( (value == null) || (!value.equals(getMaintenanceOrderSubOperation())) ) {
                    setMaintenanceOrderSubOperation(((String) value));
                }
            }
            if( values.containsKey("MaintenanceActivityType") ) {
                final Object value = values.remove("MaintenanceActivityType");
                if( (value == null) || (!value.equals(getMaintenanceActivityType())) ) {
                    setMaintenanceActivityType(((String) value));
                }
            }
            if( values.containsKey("GLAccountName") ) {
                final Object value = values.remove("GLAccountName");
                if( (value == null) || (!value.equals(getGLAccountName())) ) {
                    setGLAccountName(((String) value));
                }
            }
            if( values.containsKey("MainWorkCenter") ) {
                final Object value = values.remove("MainWorkCenter");
                if( (value == null) || (!value.equals(getMainWorkCenter())) ) {
                    setMainWorkCenter(((String) value));
                }
            }
            if( values.containsKey("OperationWorkCenter") ) {
                final Object value = values.remove("OperationWorkCenter");
                if( (value == null) || (!value.equals(getOperationWorkCenter())) ) {
                    setOperationWorkCenter(((String) value));
                }
            }
            if( values.containsKey("ProductGroup") ) {
                final Object value = values.remove("ProductGroup");
                if( (value == null) || (!value.equals(getProductGroup())) ) {
                    setProductGroup(((String) value));
                }
            }
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("Assembly") ) {
                final Object value = values.remove("Assembly");
                if( (value == null) || (!value.equals(getAssembly())) ) {
                    setAssembly(((String) value));
                }
            }
            if( values.containsKey("Equipment") ) {
                final Object value = values.remove("Equipment");
                if( (value == null) || (!value.equals(getEquipment())) ) {
                    setEquipment(((String) value));
                }
            }
            if( values.containsKey("FunctionalLocation") ) {
                final Object value = values.remove("FunctionalLocation");
                if( (value == null) || (!value.equals(getFunctionalLocation())) ) {
                    setFunctionalLocation(((String) value));
                }
            }
            if( values.containsKey("ReferenceDocument") ) {
                final Object value = values.remove("ReferenceDocument");
                if( (value == null) || (!value.equals(getReferenceDocument())) ) {
                    setReferenceDocument(((String) value));
                }
            }
            if( values.containsKey("ReferenceDocumentType") ) {
                final Object value = values.remove("ReferenceDocumentType");
                if( (value == null) || (!value.equals(getReferenceDocumentType())) ) {
                    setReferenceDocumentType(((String) value));
                }
            }
            if( values.containsKey("ReferenceDocumentContext") ) {
                final Object value = values.remove("ReferenceDocumentContext");
                if( (value == null) || (!value.equals(getReferenceDocumentContext())) ) {
                    setReferenceDocumentContext(((String) value));
                }
            }
            if( values.containsKey("ReferenceDocumentItem") ) {
                final Object value = values.remove("ReferenceDocumentItem");
                if( (value == null) || (!value.equals(getReferenceDocumentItem())) ) {
                    setReferenceDocumentItem(((String) value));
                }
            }
            if( values.containsKey("MaintPriorityType") ) {
                final Object value = values.remove("MaintPriorityType");
                if( (value == null) || (!value.equals(getMaintPriorityType())) ) {
                    setMaintPriorityType(((String) value));
                }
            }
            if( values.containsKey("MaintPriority") ) {
                final Object value = values.remove("MaintPriority");
                if( (value == null) || (!value.equals(getMaintPriority())) ) {
                    setMaintPriority(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrder") ) {
                final Object value = values.remove("PurchaseOrder");
                if( (value == null) || (!value.equals(getPurchaseOrder())) ) {
                    setPurchaseOrder(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrderItem") ) {
                final Object value = values.remove("PurchaseOrderItem");
                if( (value == null) || (!value.equals(getPurchaseOrderItem())) ) {
                    setPurchaseOrderItem(((String) value));
                }
            }
            if( values.containsKey("Reservation") ) {
                final Object value = values.remove("Reservation");
                if( (value == null) || (!value.equals(getReservation())) ) {
                    setReservation(((String) value));
                }
            }
            if( values.containsKey("ReservationItem") ) {
                final Object value = values.remove("ReservationItem");
                if( (value == null) || (!value.equals(getReservationItem())) ) {
                    setReservationItem(((String) value));
                }
            }
            if( values.containsKey("ReservationType") ) {
                final Object value = values.remove("ReservationType");
                if( (value == null) || (!value.equals(getReservationType())) ) {
                    setReservationType(((String) value));
                }
            }
            if( values.containsKey("GlobalCurrency") ) {
                final Object value = values.remove("GlobalCurrency");
                if( (value == null) || (!value.equals(getGlobalCurrency())) ) {
                    setGlobalCurrency(((String) value));
                }
            }
            if( values.containsKey("AmountInGlobalCurrency") ) {
                final Object value = values.remove("AmountInGlobalCurrency");
                if( (value == null) || (!value.equals(getAmountInGlobalCurrency())) ) {
                    setAmountInGlobalCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("ActualMaintAmountInGlobCrcy") ) {
                final Object value = values.remove("ActualMaintAmountInGlobCrcy");
                if( (value == null) || (!value.equals(getActualMaintAmountInGlobCrcy())) ) {
                    setActualMaintAmountInGlobCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("PlannedMaintAmountInGlobCrcy") ) {
                final Object value = values.remove("PlannedMaintAmountInGlobCrcy");
                if( (value == null) || (!value.equals(getPlannedMaintAmountInGlobCrcy())) ) {
                    setPlannedMaintAmountInGlobCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("BaselineMaintAmountInGlobCrcy") ) {
                final Object value = values.remove("BaselineMaintAmountInGlobCrcy");
                if( (value == null) || (!value.equals(getBaselineMaintAmountInGlobCrcy())) ) {
                    setBaselineMaintAmountInGlobCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("EstimatedMaintAmountInGlobCrcy") ) {
                final Object value = values.remove("EstimatedMaintAmountInGlobCrcy");
                if( (value == null) || (!value.equals(getEstimatedMaintAmountInGlobCrcy())) ) {
                    setEstimatedMaintAmountInGlobCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("CompanyCodeCurrency") ) {
                final Object value = values.remove("CompanyCodeCurrency");
                if( (value == null) || (!value.equals(getCompanyCodeCurrency())) ) {
                    setCompanyCodeCurrency(((String) value));
                }
            }
            if( values.containsKey("AmountInCompanyCodeCurrency") ) {
                final Object value = values.remove("AmountInCompanyCodeCurrency");
                if( (value == null) || (!value.equals(getAmountInCompanyCodeCurrency())) ) {
                    setAmountInCompanyCodeCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("ActualMaintAmountInCoCrcy") ) {
                final Object value = values.remove("ActualMaintAmountInCoCrcy");
                if( (value == null) || (!value.equals(getActualMaintAmountInCoCrcy())) ) {
                    setActualMaintAmountInCoCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("PlannedMaintAmountInCoCrcy") ) {
                final Object value = values.remove("PlannedMaintAmountInCoCrcy");
                if( (value == null) || (!value.equals(getPlannedMaintAmountInCoCrcy())) ) {
                    setPlannedMaintAmountInCoCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("BaselineMaintAmountInCoCrcy") ) {
                final Object value = values.remove("BaselineMaintAmountInCoCrcy");
                if( (value == null) || (!value.equals(getBaselineMaintAmountInCoCrcy())) ) {
                    setBaselineMaintAmountInCoCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("EstimatedMaintAmountInCoCrcy") ) {
                final Object value = values.remove("EstimatedMaintAmountInCoCrcy");
                if( (value == null) || (!value.equals(getEstimatedMaintAmountInCoCrcy())) ) {
                    setEstimatedMaintAmountInCoCrcy(((BigDecimal) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_MaintenanceOrder") ) {
                final Object value = (values).remove("to_MaintenanceOrder");
                if( value instanceof Map ) {
                    if( toMaintenanceOrder == null ) {
                        toMaintenanceOrder = new MaintenanceOrder();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toMaintenanceOrder.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_MaintenanceOrderOpComponent") ) {
                final Object value = (values).remove("to_MaintenanceOrderOpComponent");
                if( value instanceof Map ) {
                    if( toMaintenanceOrderOpComponent == null ) {
                        toMaintenanceOrderOpComponent = new MaintOrderOpComponent();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toMaintenanceOrderOpComponent.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_MaintenanceOrderOperation") ) {
                final Object value = (values).remove("to_MaintenanceOrderOperation");
                if( value instanceof Map ) {
                    if( toMaintenanceOrderOperation == null ) {
                        toMaintenanceOrderOperation = new MaintenanceOrderOperation();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toMaintenanceOrderOperation.fromMap(inputMap);
                }
            }
            if( (values).containsKey("Parameters") ) {
                final Object value = (values).remove("Parameters");
                if( value instanceof Map ) {
                    if( toParameters == null ) {
                        toParameters = new MaintOrderActlPlndCostItm_TypeParameters();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toParameters.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> MaintOrderActlPlndCostItmField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new MaintOrderActlPlndCostItmField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MaintOrderActlPlndCostItmField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MaintOrderActlPlndCostItmField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceOrderService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toMaintenanceOrder != null ) {
            (values).put("to_MaintenanceOrder", toMaintenanceOrder);
        }
        if( toMaintenanceOrderOpComponent != null ) {
            (values).put("to_MaintenanceOrderOpComponent", toMaintenanceOrderOpComponent);
        }
        if( toMaintenanceOrderOperation != null ) {
            (values).put("to_MaintenanceOrderOperation", toMaintenanceOrderOperation);
        }
        if( toParameters != null ) {
            (values).put("Parameters", toParameters);
        }
        return values;
    }

    /**
     * Fetches the <b>MaintenanceOrder</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_MaintenanceOrder</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>MaintenanceOrder</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceOrder fetchMaintenanceOrder()
    {
        return fetchFieldAsSingle("to_MaintenanceOrder", MaintenanceOrder.class);
    }

    /**
     * Retrieval of associated <b>MaintenanceOrder</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_MaintenanceOrder</b>.
     * <p>
     * If the navigation property <b>to_MaintenanceOrder</b> of a queried <b>MaintOrderActlPlndCostItm</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintenanceOrder</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceOrder getMaintenanceOrderOrFetch()
    {
        if( toMaintenanceOrder == null ) {
            toMaintenanceOrder = fetchMaintenanceOrder();
        }
        return toMaintenanceOrder;
    }

    /**
     * Retrieval of associated <b>MaintenanceOrder</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_MaintenanceOrder</b>.
     * <p>
     * If the navigation property for an entity <b>MaintOrderActlPlndCostItm</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaintenanceOrder</b> is already loaded, the result will
     *         contain the <b>MaintenanceOrder</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<MaintenanceOrder> getMaintenanceOrderIfPresent()
    {
        return Option.of(toMaintenanceOrder);
    }

    /**
     * Overwrites the associated <b>MaintenanceOrder</b> entity for the loaded navigation property
     * <b>to_MaintenanceOrder</b>.
     *
     * @param value
     *            New <b>MaintenanceOrder</b> entity.
     */
    public void setMaintenanceOrder( final MaintenanceOrder value )
    {
        toMaintenanceOrder = value;
    }

    /**
     * Fetches the <b>MaintOrderOpComponent</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_MaintenanceOrderOpComponent</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>MaintOrderOpComponent</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintOrderOpComponent fetchMaintenanceOrderOpComponent()
    {
        return fetchFieldAsSingle("to_MaintenanceOrderOpComponent", MaintOrderOpComponent.class);
    }

    /**
     * Retrieval of associated <b>MaintOrderOpComponent</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_MaintenanceOrderOpComponent</b>.
     * <p>
     * If the navigation property <b>to_MaintenanceOrderOpComponent</b> of a queried <b>MaintOrderActlPlndCostItm</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintOrderOpComponent</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintOrderOpComponent getMaintenanceOrderOpComponentOrFetch()
    {
        if( toMaintenanceOrderOpComponent == null ) {
            toMaintenanceOrderOpComponent = fetchMaintenanceOrderOpComponent();
        }
        return toMaintenanceOrderOpComponent;
    }

    /**
     * Retrieval of associated <b>MaintOrderOpComponent</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_MaintenanceOrderOpComponent</b>.
     * <p>
     * If the navigation property for an entity <b>MaintOrderActlPlndCostItm</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaintenanceOrderOpComponent</b> is already loaded, the
     *         result will contain the <b>MaintOrderOpComponent</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<MaintOrderOpComponent> getMaintenanceOrderOpComponentIfPresent()
    {
        return Option.of(toMaintenanceOrderOpComponent);
    }

    /**
     * Overwrites the associated <b>MaintOrderOpComponent</b> entity for the loaded navigation property
     * <b>to_MaintenanceOrderOpComponent</b>.
     *
     * @param value
     *            New <b>MaintOrderOpComponent</b> entity.
     */
    public void setMaintenanceOrderOpComponent( final MaintOrderOpComponent value )
    {
        toMaintenanceOrderOpComponent = value;
    }

    /**
     * Fetches the <b>MaintenanceOrderOperation</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_MaintenanceOrderOperation</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>MaintenanceOrderOperation</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceOrderOperation fetchMaintenanceOrderOperation()
    {
        return fetchFieldAsSingle("to_MaintenanceOrderOperation", MaintenanceOrderOperation.class);
    }

    /**
     * Retrieval of associated <b>MaintenanceOrderOperation</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_MaintenanceOrderOperation</b>.
     * <p>
     * If the navigation property <b>to_MaintenanceOrderOperation</b> of a queried <b>MaintOrderActlPlndCostItm</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintenanceOrderOperation</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceOrderOperation getMaintenanceOrderOperationOrFetch()
    {
        if( toMaintenanceOrderOperation == null ) {
            toMaintenanceOrderOperation = fetchMaintenanceOrderOperation();
        }
        return toMaintenanceOrderOperation;
    }

    /**
     * Retrieval of associated <b>MaintenanceOrderOperation</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_MaintenanceOrderOperation</b>.
     * <p>
     * If the navigation property for an entity <b>MaintOrderActlPlndCostItm</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaintenanceOrderOperation</b> is already loaded, the
     *         result will contain the <b>MaintenanceOrderOperation</b> entity. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<MaintenanceOrderOperation> getMaintenanceOrderOperationIfPresent()
    {
        return Option.of(toMaintenanceOrderOperation);
    }

    /**
     * Overwrites the associated <b>MaintenanceOrderOperation</b> entity for the loaded navigation property
     * <b>to_MaintenanceOrderOperation</b>.
     *
     * @param value
     *            New <b>MaintenanceOrderOperation</b> entity.
     */
    public void setMaintenanceOrderOperation( final MaintenanceOrderOperation value )
    {
        toMaintenanceOrderOperation = value;
    }

    /**
     * Fetches the <b>MaintOrderActlPlndCostItm_TypeParameters</b> entity (one to one) associated with this entity. This
     * corresponds to the OData navigation property <b>Parameters</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>MaintOrderActlPlndCostItm_TypeParameters</b> entity, or {@code null} if an
     *         entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintOrderActlPlndCostItm_TypeParameters fetchParameters()
    {
        return fetchFieldAsSingle("Parameters", MaintOrderActlPlndCostItm_TypeParameters.class);
    }

    /**
     * Retrieval of associated <b>MaintOrderActlPlndCostItm_TypeParameters</b> entity (one to one). This corresponds to
     * the OData navigation property <b>Parameters</b>.
     * <p>
     * If the navigation property <b>Parameters</b> of a queried <b>MaintOrderActlPlndCostItm</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintOrderActlPlndCostItm_TypeParameters</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintOrderActlPlndCostItm_TypeParameters getParametersOrFetch()
    {
        if( toParameters == null ) {
            toParameters = fetchParameters();
        }
        return toParameters;
    }

    /**
     * Retrieval of associated <b>MaintOrderActlPlndCostItm_TypeParameters</b> entity (one to one). This corresponds to
     * the OData navigation property <b>Parameters</b>.
     * <p>
     * If the navigation property for an entity <b>MaintOrderActlPlndCostItm</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>Parameters</b> is already loaded, the result will contain
     *         the <b>MaintOrderActlPlndCostItm_TypeParameters</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<MaintOrderActlPlndCostItm_TypeParameters> getParametersIfPresent()
    {
        return Option.of(toParameters);
    }

    /**
     * Overwrites the associated <b>MaintOrderActlPlndCostItm_TypeParameters</b> entity for the loaded navigation
     * property <b>Parameters</b>.
     *
     * @param value
     *            New <b>MaintOrderActlPlndCostItm_TypeParameters</b> entity.
     */
    public void setParameters( final MaintOrderActlPlndCostItm_TypeParameters value )
    {
        toParameters = value;
    }

    /**
     * Helper class to allow for fluent creation of MaintOrderActlPlndCostItm instances.
     *
     */
    public final static class MaintOrderActlPlndCostItmBuilder
    {

        private MaintenanceOrder toMaintenanceOrder;
        private String maintenanceOrder = null;
        private MaintOrderOpComponent toMaintenanceOrderOpComponent;
        private MaintenanceOrderOperation toMaintenanceOrderOperation;
        private String maintenanceOrderOperation = null;
        private MaintOrderActlPlndCostItm_TypeParameters toParameters;

        private MaintOrderActlPlndCostItm.MaintOrderActlPlndCostItmBuilder toMaintenanceOrder(
            final MaintenanceOrder value )
        {
            toMaintenanceOrder = value;
            return this;
        }

        /**
         * Navigation property <b>to_MaintenanceOrder</b> for <b>MaintOrderActlPlndCostItm</b> to single
         * <b>MaintenanceOrder</b>.
         *
         * @param value
         *            The MaintenanceOrder to build this MaintOrderActlPlndCostItm with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintOrderActlPlndCostItm.MaintOrderActlPlndCostItmBuilder maintenanceOrder(
            final MaintenanceOrder value )
        {
            return toMaintenanceOrder(value);
        }

        /**
         * Constraints: Not nullable, Maximum length: 12
         * <p>
         * Original property name from the Odata EDM: <b>MaintenanceOrder</b>
         * </p>
         *
         * @param value
         *            The maintenanceOrder to build this MaintOrderActlPlndCostItm with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintOrderActlPlndCostItm.MaintOrderActlPlndCostItmBuilder maintenanceOrder( final String value )
        {
            maintenanceOrder = value;
            return this;
        }

        private MaintOrderActlPlndCostItm.MaintOrderActlPlndCostItmBuilder toMaintenanceOrderOpComponent(
            final MaintOrderOpComponent value )
        {
            toMaintenanceOrderOpComponent = value;
            return this;
        }

        /**
         * Navigation property <b>to_MaintenanceOrderOpComponent</b> for <b>MaintOrderActlPlndCostItm</b> to single
         * <b>MaintOrderOpComponent</b>.
         *
         * @param value
         *            The MaintOrderOpComponent to build this MaintOrderActlPlndCostItm with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintOrderActlPlndCostItm.MaintOrderActlPlndCostItmBuilder maintenanceOrderOpComponent(
            final MaintOrderOpComponent value )
        {
            return toMaintenanceOrderOpComponent(value);
        }

        private MaintOrderActlPlndCostItm.MaintOrderActlPlndCostItmBuilder toMaintenanceOrderOperation(
            final MaintenanceOrderOperation value )
        {
            toMaintenanceOrderOperation = value;
            return this;
        }

        /**
         * Navigation property <b>to_MaintenanceOrderOperation</b> for <b>MaintOrderActlPlndCostItm</b> to single
         * <b>MaintenanceOrderOperation</b>.
         *
         * @param value
         *            The MaintenanceOrderOperation to build this MaintOrderActlPlndCostItm with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintOrderActlPlndCostItm.MaintOrderActlPlndCostItmBuilder maintenanceOrderOperation(
            final MaintenanceOrderOperation value )
        {
            return toMaintenanceOrderOperation(value);
        }

        /**
         * Constraints: Not nullable, Maximum length: 4
         * <p>
         * Original property name from the Odata EDM: <b>MaintenanceOrderOperation</b>
         * </p>
         *
         * @param value
         *            The maintenanceOrderOperation to build this MaintOrderActlPlndCostItm with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintOrderActlPlndCostItm.MaintOrderActlPlndCostItmBuilder maintenanceOrderOperation(
            final String value )
        {
            maintenanceOrderOperation = value;
            return this;
        }

        private MaintOrderActlPlndCostItm.MaintOrderActlPlndCostItmBuilder toParameters(
            final MaintOrderActlPlndCostItm_TypeParameters value )
        {
            toParameters = value;
            return this;
        }

        /**
         * Navigation property <b>Parameters</b> for <b>MaintOrderActlPlndCostItm</b> to single
         * <b>MaintOrderActlPlndCostItm_TypeParameters</b>.
         *
         * @param value
         *            The MaintOrderActlPlndCostItm_TypeParameters to build this MaintOrderActlPlndCostItm with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintOrderActlPlndCostItm.MaintOrderActlPlndCostItmBuilder parameters(
            final MaintOrderActlPlndCostItm_TypeParameters value )
        {
            return toParameters(value);
        }

    }

}
