/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.selectable.MaintOrderActlPlndCostItmSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm
 * MaintOrderActlPlndCostItm} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class MaintOrderActlPlndCostItmByKeyFluentHelper
    extends
    FluentHelperByKey<MaintOrderActlPlndCostItmByKeyFluentHelper, MaintOrderActlPlndCostItm, MaintOrderActlPlndCostItmSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm
     * MaintOrderActlPlndCostItm} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param ledger
     *            Ledger in General Ledger Accounting
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param companyCode
     *            Company Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code MaintOrderActlPlndCostItm}
     * @param financialPlanningReqTransSqnc
     *            Financial Planning Request Transaction Sequence Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 23
     *            </p>
     * @param actualPlanJournalEntryItem
     *            Actual Plan Journal Entry Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param financialPlanningDataPacket
     *            Financial Planning Data Packet Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code MaintOrderActlPlndCostItm}
     * @param accountingDocument
     *            Journal Entry
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param p_GLAccountHierarchy
     *            Hierarchy ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 42
     *            </p>
     * @param sourceLedger
     *            Source Ledger
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param fiscalYear
     *            Fiscal Year
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     */
    public MaintOrderActlPlndCostItmByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String p_GLAccountHierarchy,
        final String sourceLedger,
        final String ledger,
        final String companyCode,
        final String fiscalYear,
        final String accountingDocument,
        final String financialPlanningReqTransSqnc,
        final String financialPlanningDataPacket,
        final String actualPlanJournalEntryItem )
    {
        super(servicePath, entityCollection);
        this.key.put("P_GLAccountHierarchy", p_GLAccountHierarchy);
        this.key.put("SourceLedger", sourceLedger);
        this.key.put("Ledger", ledger);
        this.key.put("CompanyCode", companyCode);
        this.key.put("FiscalYear", fiscalYear);
        this.key.put("AccountingDocument", accountingDocument);
        this.key.put("FinancialPlanningReqTransSqnc", financialPlanningReqTransSqnc);
        this.key.put("FinancialPlanningDataPacket", financialPlanningDataPacket);
        this.key.put("ActualPlanJournalEntryItem", actualPlanJournalEntryItem);
    }

    @Override
    @Nonnull
    protected Class<MaintOrderActlPlndCostItm> getEntityClass()
    {
        return MaintOrderActlPlndCostItm.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
