/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.field.MaintOrderActlPlndCostItm_TypeParametersField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.link.MaintOrderActlPlndCostItm_TypeParametersLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.selectable.MaintOrderActlPlndCostItm_TypeParametersSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>MaintOrderActlPlndCostItm_TypeParameters</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MaintOrderActlPlndCostItm_TypeParameters extends VdmEntity<MaintOrderActlPlndCostItm_TypeParameters>
{

    /**
     * Selector for all available fields of MaintOrderActlPlndCostItm_TypeParameters.
     *
     */
    public final static MaintOrderActlPlndCostItm_TypeParametersSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 42
     * <p>
     * Original property name from the Odata EDM: <b>P_GLAccountHierarchy</b>
     * </p>
     *
     * @return Hierarchy ID
     */
    @Key
    @SerializedName( "P_GLAccountHierarchy" )
    @JsonProperty( "P_GLAccountHierarchy" )
    @Nullable
    @ODataField( odataName = "P_GLAccountHierarchy" )
    private String p_GLAccountHierarchy;
    /**
     * Use with available fluent helpers to apply the <b>P_GLAccountHierarchy</b> field to query operations.
     *
     */
    public final static MaintOrderActlPlndCostItm_TypeParametersField<String> PGL_ACCOUNT_HIERARCHY =
        new MaintOrderActlPlndCostItm_TypeParametersField<String>("P_GLAccountHierarchy");
    /**
     * Navigation property <b>Set</b> for <b>MaintOrderActlPlndCostItm_TypeParameters</b> to multiple
     * <b>MaintOrderActlPlndCostItm</b>.
     *
     */
    @SerializedName( "Set" )
    @JsonProperty( "Set" )
    @ODataField( odataName = "Set" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MaintOrderActlPlndCostItm> toSet;
    /**
     * Use with available fluent helpers to apply the <b>Set</b> navigation property to query operations.
     *
     */
    public final static MaintOrderActlPlndCostItm_TypeParametersLink<MaintOrderActlPlndCostItm> TO_SET =
        new MaintOrderActlPlndCostItm_TypeParametersLink<MaintOrderActlPlndCostItm>("Set");

    @Nonnull
    @Override
    public Class<MaintOrderActlPlndCostItm_TypeParameters> getType()
    {
        return MaintOrderActlPlndCostItm_TypeParameters.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 42
     * <p>
     * Original property name from the Odata EDM: <b>P_GLAccountHierarchy</b>
     * </p>
     *
     * @param p_GLAccountHierarchy
     *            Hierarchy ID
     */
    public void setP_GLAccountHierarchy( @Nullable final String p_GLAccountHierarchy )
    {
        rememberChangedField("P_GLAccountHierarchy", this.p_GLAccountHierarchy);
        this.p_GLAccountHierarchy = p_GLAccountHierarchy;
    }

    @Override
    protected String getEntityCollection()
    {
        return "MaintOrderActlPlndCostItm";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("P_GLAccountHierarchy", getP_GLAccountHierarchy());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("P_GLAccountHierarchy", getP_GLAccountHierarchy());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("P_GLAccountHierarchy") ) {
                final Object value = values.remove("P_GLAccountHierarchy");
                if( (value == null) || (!value.equals(getP_GLAccountHierarchy())) ) {
                    setP_GLAccountHierarchy(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("Set") ) {
                final Object value = (values).remove("Set");
                if( value instanceof Iterable ) {
                    if( toSet == null ) {
                        toSet = Lists.newArrayList();
                    } else {
                        toSet = Lists.newArrayList(toSet);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MaintOrderActlPlndCostItm entity;
                        if( toSet.size() > i ) {
                            entity = toSet.get(i);
                        } else {
                            entity = new MaintOrderActlPlndCostItm();
                            toSet.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> MaintOrderActlPlndCostItm_TypeParametersField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new MaintOrderActlPlndCostItm_TypeParametersField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MaintOrderActlPlndCostItm_TypeParametersField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MaintOrderActlPlndCostItm_TypeParametersField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceOrderService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toSet != null ) {
            (values).put("Set", toSet);
        }
        return values;
    }

    /**
     * Fetches the <b>MaintOrderActlPlndCostItm</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>Set</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>MaintOrderActlPlndCostItm</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintOrderActlPlndCostItm> fetchSet()
    {
        return fetchFieldAsList("Set", MaintOrderActlPlndCostItm.class);
    }

    /**
     * Retrieval of associated <b>MaintOrderActlPlndCostItm</b> entities (one to many). This corresponds to the OData
     * navigation property <b>Set</b>.
     * <p>
     * If the navigation property <b>Set</b> of a queried <b>MaintOrderActlPlndCostItm_TypeParameters</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintOrderActlPlndCostItm</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintOrderActlPlndCostItm> getSetOrFetch()
    {
        if( toSet == null ) {
            toSet = fetchSet();
        }
        return toSet;
    }

    /**
     * Retrieval of associated <b>MaintOrderActlPlndCostItm</b> entities (one to many). This corresponds to the OData
     * navigation property <b>Set</b>.
     * <p>
     * If the navigation property for an entity <b>MaintOrderActlPlndCostItm_TypeParameters</b> has not been resolved
     * yet, this method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>Set</b> is already loaded, the result will contain the
     *         <b>MaintOrderActlPlndCostItm</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<MaintOrderActlPlndCostItm>> getSetIfPresent()
    {
        return Option.of(toSet);
    }

    /**
     * Overwrites the list of associated <b>MaintOrderActlPlndCostItm</b> entities for the loaded navigation property
     * <b>Set</b>.
     * <p>
     * If the navigation property <b>Set</b> of a queried <b>MaintOrderActlPlndCostItm_TypeParameters</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>MaintOrderActlPlndCostItm</b> entities.
     */
    public void setSet( @Nonnull final List<MaintOrderActlPlndCostItm> value )
    {
        if( toSet == null ) {
            toSet = Lists.newArrayList();
        }
        toSet.clear();
        toSet.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MaintOrderActlPlndCostItm</b> entities. This corresponds to the OData
     * navigation property <b>Set</b>.
     * <p>
     * If the navigation property <b>Set</b> of a queried <b>MaintOrderActlPlndCostItm_TypeParameters</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>MaintOrderActlPlndCostItm</b> entities.
     */
    public void addSet( MaintOrderActlPlndCostItm... entity )
    {
        if( toSet == null ) {
            toSet = Lists.newArrayList();
        }
        toSet.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of MaintOrderActlPlndCostItm_TypeParameters instances.
     *
     */
    public final static class MaintOrderActlPlndCostItm_TypeParametersBuilder
    {

        private List<MaintOrderActlPlndCostItm> toSet = Lists.newArrayList();

        private MaintOrderActlPlndCostItm_TypeParameters.MaintOrderActlPlndCostItm_TypeParametersBuilder toSet(
            final List<MaintOrderActlPlndCostItm> value )
        {
            toSet.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>Set</b> for <b>MaintOrderActlPlndCostItm_TypeParameters</b> to multiple
         * <b>MaintOrderActlPlndCostItm</b>.
         *
         * @param value
         *            The MaintOrderActlPlndCostItms to build this MaintOrderActlPlndCostItm_TypeParameters with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintOrderActlPlndCostItm_TypeParameters.MaintOrderActlPlndCostItm_TypeParametersBuilder set(
            MaintOrderActlPlndCostItm... value )
        {
            return toSet(Lists.newArrayList(value));
        }

    }

}
