/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.selectable.MaintOrderActlPlndCostItm_TypeParametersSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm_TypeParameters
 * MaintOrderActlPlndCostItm_TypeParameters} entity using key fields. This fluent helper allows methods which modify the
 * underlying query to be called before executing the query itself.
 *
 */
public class MaintOrderActlPlndCostItm_TypeParametersByKeyFluentHelper
    extends
    FluentHelperByKey<MaintOrderActlPlndCostItm_TypeParametersByKeyFluentHelper, MaintOrderActlPlndCostItm_TypeParameters, MaintOrderActlPlndCostItm_TypeParametersSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm_TypeParameters
     * MaintOrderActlPlndCostItm_TypeParameters} entity with the provided key field values. To perform execution, call
     * the {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code MaintOrderActlPlndCostItm_TypeParameters}
     * @param servicePath
     *            Service path to be used to fetch a single {@code MaintOrderActlPlndCostItm_TypeParameters}
     * @param p_GLAccountHierarchy
     *            Hierarchy ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 42
     *            </p>
     */
    public MaintOrderActlPlndCostItm_TypeParametersByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String p_GLAccountHierarchy )
    {
        super(servicePath, entityCollection);
        this.key.put("P_GLAccountHierarchy", p_GLAccountHierarchy);
    }

    @Override
    @Nonnull
    protected Class<MaintOrderActlPlndCostItm_TypeParameters> getEntityClass()
    {
        return MaintOrderActlPlndCostItm_TypeParameters.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
