/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.field.MaintOrderObjectListItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.link.MaintOrderObjectListItemOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.selectable.MaintOrderObjectListItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Maintenance Order Object List
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MaintOrderObjectListItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MaintOrderObjectListItem extends VdmEntity<MaintOrderObjectListItem>
{

    /**
     * Selector for all available fields of MaintOrderObjectListItem.
     *
     */
    public final static MaintOrderObjectListItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrder</b>
     * </p>
     *
     * @return Order Number
     */
    @Key
    @SerializedName( "MaintenanceOrder" )
    @JsonProperty( "MaintenanceOrder" )
    @Nullable
    @ODataField( odataName = "MaintenanceOrder" )
    private String maintenanceOrder;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceOrder</b> field to query operations.
     *
     */
    public final static MaintOrderObjectListItemField<String> MAINTENANCE_ORDER =
        new MaintOrderObjectListItemField<String>("MaintenanceOrder");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderObjectList</b>
     * </p>
     *
     * @return Object list number
     */
    @Key
    @SerializedName( "MaintenanceOrderObjectList" )
    @JsonProperty( "MaintenanceOrderObjectList" )
    @Nullable
    @ODataField( odataName = "MaintenanceOrderObjectList" )
    private Long maintenanceOrderObjectList;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceOrderObjectList</b> field to query operations.
     *
     */
    public final static MaintOrderObjectListItemField<Long> MAINTENANCE_ORDER_OBJECT_LIST =
        new MaintOrderObjectListItemField<Long>("MaintenanceOrderObjectList");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceObjectListItem</b>
     * </p>
     *
     * @return Object list counters
     */
    @Key
    @SerializedName( "MaintenanceObjectListItem" )
    @JsonProperty( "MaintenanceObjectListItem" )
    @Nullable
    @ODataField( odataName = "MaintenanceObjectListItem" )
    private Integer maintenanceObjectListItem;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceObjectListItem</b> field to query operations.
     *
     */
    public final static MaintOrderObjectListItemField<Integer> MAINTENANCE_OBJECT_LIST_ITEM =
        new MaintOrderObjectListItemField<Integer>("MaintenanceObjectListItem");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Equipment</b>
     * </p>
     *
     * @return Equipment Number
     */
    @SerializedName( "Equipment" )
    @JsonProperty( "Equipment" )
    @Nullable
    @ODataField( odataName = "Equipment" )
    private String equipment;
    /**
     * Use with available fluent helpers to apply the <b>Equipment</b> field to query operations.
     *
     */
    public final static MaintOrderObjectListItemField<String> EQUIPMENT =
        new MaintOrderObjectListItemField<String>("Equipment");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceNotification</b>
     * </p>
     *
     * @return Notification Number
     */
    @SerializedName( "MaintenanceNotification" )
    @JsonProperty( "MaintenanceNotification" )
    @Nullable
    @ODataField( odataName = "MaintenanceNotification" )
    private String maintenanceNotification;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceNotification</b> field to query operations.
     *
     */
    public final static MaintOrderObjectListItemField<String> MAINTENANCE_NOTIFICATION =
        new MaintOrderObjectListItemField<String>("MaintenanceNotification");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Assembly</b>
     * </p>
     *
     * @return Assembly
     */
    @SerializedName( "Assembly" )
    @JsonProperty( "Assembly" )
    @Nullable
    @ODataField( odataName = "Assembly" )
    private String assembly;
    /**
     * Use with available fluent helpers to apply the <b>Assembly</b> field to query operations.
     *
     */
    public final static MaintOrderObjectListItemField<String> ASSEMBLY =
        new MaintOrderObjectListItemField<String>("Assembly");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static MaintOrderObjectListItemField<String> MATERIAL =
        new MaintOrderObjectListItemField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>SerialNumber</b>
     * </p>
     *
     * @return Serial Number
     */
    @SerializedName( "SerialNumber" )
    @JsonProperty( "SerialNumber" )
    @Nullable
    @ODataField( odataName = "SerialNumber" )
    private String serialNumber;
    /**
     * Use with available fluent helpers to apply the <b>SerialNumber</b> field to query operations.
     *
     */
    public final static MaintOrderObjectListItemField<String> SERIAL_NUMBER =
        new MaintOrderObjectListItemField<String>("SerialNumber");
    /**
     * Constraints: Not nullable, Maximum length: 72
     * <p>
     * Original property name from the Odata EDM: <b>UniqueItemIdentifier</b>
     * </p>
     *
     * @return Unique Item Identifier
     */
    @SerializedName( "UniqueItemIdentifier" )
    @JsonProperty( "UniqueItemIdentifier" )
    @Nullable
    @ODataField( odataName = "UniqueItemIdentifier" )
    private String uniqueItemIdentifier;
    /**
     * Use with available fluent helpers to apply the <b>UniqueItemIdentifier</b> field to query operations.
     *
     */
    public final static MaintOrderObjectListItemField<String> UNIQUE_ITEM_IDENTIFIER =
        new MaintOrderObjectListItemField<String>("UniqueItemIdentifier");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocation</b>
     * </p>
     *
     * @return Functional Location
     */
    @SerializedName( "FunctionalLocation" )
    @JsonProperty( "FunctionalLocation" )
    @Nullable
    @ODataField( odataName = "FunctionalLocation" )
    private String functionalLocation;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalLocation</b> field to query operations.
     *
     */
    public final static MaintOrderObjectListItemField<String> FUNCTIONAL_LOCATION =
        new MaintOrderObjectListItemField<String>("FunctionalLocation");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>MaintObjectListItemSequence</b>
     * </p>
     *
     * @return Object list sort field
     */
    @SerializedName( "MaintObjectListItemSequence" )
    @JsonProperty( "MaintObjectListItemSequence" )
    @Nullable
    @ODataField( odataName = "MaintObjectListItemSequence" )
    private String maintObjectListItemSequence;
    /**
     * Use with available fluent helpers to apply the <b>MaintObjectListItemSequence</b> field to query operations.
     *
     */
    public final static MaintOrderObjectListItemField<String> MAINT_OBJECT_LIST_ITEM_SEQUENCE =
        new MaintOrderObjectListItemField<String>("MaintObjectListItemSequence");
    /**
     * Navigation property <b>to_MaintenanceOrder</b> for <b>MaintOrderObjectListItem</b> to single
     * <b>MaintenanceOrder</b>.
     *
     */
    @SerializedName( "to_MaintenanceOrder" )
    @JsonProperty( "to_MaintenanceOrder" )
    @ODataField( odataName = "to_MaintenanceOrder" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private MaintenanceOrder toMaintenanceOrder;
    /**
     * Use with available fluent helpers to apply the <b>to_MaintenanceOrder</b> navigation property to query
     * operations.
     *
     */
    public final static MaintOrderObjectListItemOneToOneLink<MaintenanceOrder> TO_MAINTENANCE_ORDER =
        new MaintOrderObjectListItemOneToOneLink<MaintenanceOrder>("to_MaintenanceOrder");

    @Nonnull
    @Override
    public Class<MaintOrderObjectListItem> getType()
    {
        return MaintOrderObjectListItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrder</b>
     * </p>
     *
     * @param maintenanceOrder
     *            Order Number
     */
    public void setMaintenanceOrder( @Nullable final String maintenanceOrder )
    {
        rememberChangedField("MaintenanceOrder", this.maintenanceOrder);
        this.maintenanceOrder = maintenanceOrder;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderObjectList</b>
     * </p>
     *
     * @param maintenanceOrderObjectList
     *            Object list number
     */
    public void setMaintenanceOrderObjectList( @Nullable final Long maintenanceOrderObjectList )
    {
        rememberChangedField("MaintenanceOrderObjectList", this.maintenanceOrderObjectList);
        this.maintenanceOrderObjectList = maintenanceOrderObjectList;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceObjectListItem</b>
     * </p>
     *
     * @param maintenanceObjectListItem
     *            Object list counters
     */
    public void setMaintenanceObjectListItem( @Nullable final Integer maintenanceObjectListItem )
    {
        rememberChangedField("MaintenanceObjectListItem", this.maintenanceObjectListItem);
        this.maintenanceObjectListItem = maintenanceObjectListItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Equipment</b>
     * </p>
     *
     * @param equipment
     *            Equipment Number
     */
    public void setEquipment( @Nullable final String equipment )
    {
        rememberChangedField("Equipment", this.equipment);
        this.equipment = equipment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceNotification</b>
     * </p>
     *
     * @param maintenanceNotification
     *            Notification Number
     */
    public void setMaintenanceNotification( @Nullable final String maintenanceNotification )
    {
        rememberChangedField("MaintenanceNotification", this.maintenanceNotification);
        this.maintenanceNotification = maintenanceNotification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Assembly</b>
     * </p>
     *
     * @param assembly
     *            Assembly
     */
    public void setAssembly( @Nullable final String assembly )
    {
        rememberChangedField("Assembly", this.assembly);
        this.assembly = assembly;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>SerialNumber</b>
     * </p>
     *
     * @param serialNumber
     *            Serial Number
     */
    public void setSerialNumber( @Nullable final String serialNumber )
    {
        rememberChangedField("SerialNumber", this.serialNumber);
        this.serialNumber = serialNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 72
     * <p>
     * Original property name from the Odata EDM: <b>UniqueItemIdentifier</b>
     * </p>
     *
     * @param uniqueItemIdentifier
     *            Unique Item Identifier
     */
    public void setUniqueItemIdentifier( @Nullable final String uniqueItemIdentifier )
    {
        rememberChangedField("UniqueItemIdentifier", this.uniqueItemIdentifier);
        this.uniqueItemIdentifier = uniqueItemIdentifier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocation</b>
     * </p>
     *
     * @param functionalLocation
     *            Functional Location
     */
    public void setFunctionalLocation( @Nullable final String functionalLocation )
    {
        rememberChangedField("FunctionalLocation", this.functionalLocation);
        this.functionalLocation = functionalLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>MaintObjectListItemSequence</b>
     * </p>
     *
     * @param maintObjectListItemSequence
     *            Object list sort field
     */
    public void setMaintObjectListItemSequence( @Nullable final String maintObjectListItemSequence )
    {
        rememberChangedField("MaintObjectListItemSequence", this.maintObjectListItemSequence);
        this.maintObjectListItemSequence = maintObjectListItemSequence;
    }

    @Override
    protected String getEntityCollection()
    {
        return "MaintOrderObjectListItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("MaintenanceOrder", getMaintenanceOrder());
        result.put("MaintenanceOrderObjectList", getMaintenanceOrderObjectList());
        result.put("MaintenanceObjectListItem", getMaintenanceObjectListItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("MaintenanceOrder", getMaintenanceOrder());
        values.put("MaintenanceOrderObjectList", getMaintenanceOrderObjectList());
        values.put("MaintenanceObjectListItem", getMaintenanceObjectListItem());
        values.put("Equipment", getEquipment());
        values.put("MaintenanceNotification", getMaintenanceNotification());
        values.put("Assembly", getAssembly());
        values.put("Material", getMaterial());
        values.put("SerialNumber", getSerialNumber());
        values.put("UniqueItemIdentifier", getUniqueItemIdentifier());
        values.put("FunctionalLocation", getFunctionalLocation());
        values.put("MaintObjectListItemSequence", getMaintObjectListItemSequence());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("MaintenanceOrder") ) {
                final Object value = values.remove("MaintenanceOrder");
                if( (value == null) || (!value.equals(getMaintenanceOrder())) ) {
                    setMaintenanceOrder(((String) value));
                }
            }
            if( values.containsKey("MaintenanceOrderObjectList") ) {
                final Object value = values.remove("MaintenanceOrderObjectList");
                if( (value == null) || (!value.equals(getMaintenanceOrderObjectList())) ) {
                    setMaintenanceOrderObjectList(((Long) value));
                }
            }
            if( values.containsKey("MaintenanceObjectListItem") ) {
                final Object value = values.remove("MaintenanceObjectListItem");
                if( (value == null) || (!value.equals(getMaintenanceObjectListItem())) ) {
                    setMaintenanceObjectListItem(((Integer) value));
                }
            }
            if( values.containsKey("Equipment") ) {
                final Object value = values.remove("Equipment");
                if( (value == null) || (!value.equals(getEquipment())) ) {
                    setEquipment(((String) value));
                }
            }
            if( values.containsKey("MaintenanceNotification") ) {
                final Object value = values.remove("MaintenanceNotification");
                if( (value == null) || (!value.equals(getMaintenanceNotification())) ) {
                    setMaintenanceNotification(((String) value));
                }
            }
            if( values.containsKey("Assembly") ) {
                final Object value = values.remove("Assembly");
                if( (value == null) || (!value.equals(getAssembly())) ) {
                    setAssembly(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("SerialNumber") ) {
                final Object value = values.remove("SerialNumber");
                if( (value == null) || (!value.equals(getSerialNumber())) ) {
                    setSerialNumber(((String) value));
                }
            }
            if( values.containsKey("UniqueItemIdentifier") ) {
                final Object value = values.remove("UniqueItemIdentifier");
                if( (value == null) || (!value.equals(getUniqueItemIdentifier())) ) {
                    setUniqueItemIdentifier(((String) value));
                }
            }
            if( values.containsKey("FunctionalLocation") ) {
                final Object value = values.remove("FunctionalLocation");
                if( (value == null) || (!value.equals(getFunctionalLocation())) ) {
                    setFunctionalLocation(((String) value));
                }
            }
            if( values.containsKey("MaintObjectListItemSequence") ) {
                final Object value = values.remove("MaintObjectListItemSequence");
                if( (value == null) || (!value.equals(getMaintObjectListItemSequence())) ) {
                    setMaintObjectListItemSequence(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_MaintenanceOrder") ) {
                final Object value = (values).remove("to_MaintenanceOrder");
                if( value instanceof Map ) {
                    if( toMaintenanceOrder == null ) {
                        toMaintenanceOrder = new MaintenanceOrder();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toMaintenanceOrder.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> MaintOrderObjectListItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new MaintOrderObjectListItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MaintOrderObjectListItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MaintOrderObjectListItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceOrderService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toMaintenanceOrder != null ) {
            (values).put("to_MaintenanceOrder", toMaintenanceOrder);
        }
        return values;
    }

    /**
     * Fetches the <b>MaintenanceOrder</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_MaintenanceOrder</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>MaintenanceOrder</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceOrder fetchMaintenanceOrder()
    {
        return fetchFieldAsSingle("to_MaintenanceOrder", MaintenanceOrder.class);
    }

    /**
     * Retrieval of associated <b>MaintenanceOrder</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_MaintenanceOrder</b>.
     * <p>
     * If the navigation property <b>to_MaintenanceOrder</b> of a queried <b>MaintOrderObjectListItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintenanceOrder</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceOrder getMaintenanceOrderOrFetch()
    {
        if( toMaintenanceOrder == null ) {
            toMaintenanceOrder = fetchMaintenanceOrder();
        }
        return toMaintenanceOrder;
    }

    /**
     * Retrieval of associated <b>MaintenanceOrder</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_MaintenanceOrder</b>.
     * <p>
     * If the navigation property for an entity <b>MaintOrderObjectListItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaintenanceOrder</b> is already loaded, the result will
     *         contain the <b>MaintenanceOrder</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<MaintenanceOrder> getMaintenanceOrderIfPresent()
    {
        return Option.of(toMaintenanceOrder);
    }

    /**
     * Overwrites the associated <b>MaintenanceOrder</b> entity for the loaded navigation property
     * <b>to_MaintenanceOrder</b>.
     *
     * @param value
     *            New <b>MaintenanceOrder</b> entity.
     */
    public void setMaintenanceOrder( final MaintenanceOrder value )
    {
        toMaintenanceOrder = value;
    }

    /**
     * Helper class to allow for fluent creation of MaintOrderObjectListItem instances.
     *
     */
    public final static class MaintOrderObjectListItemBuilder
    {

        private MaintenanceOrder toMaintenanceOrder;
        private String maintenanceOrder = null;

        private MaintOrderObjectListItem.MaintOrderObjectListItemBuilder toMaintenanceOrder(
            final MaintenanceOrder value )
        {
            toMaintenanceOrder = value;
            return this;
        }

        /**
         * Navigation property <b>to_MaintenanceOrder</b> for <b>MaintOrderObjectListItem</b> to single
         * <b>MaintenanceOrder</b>.
         *
         * @param value
         *            The MaintenanceOrder to build this MaintOrderObjectListItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintOrderObjectListItem.MaintOrderObjectListItemBuilder maintenanceOrder( final MaintenanceOrder value )
        {
            return toMaintenanceOrder(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 12
         * <p>
         * Original property name from the Odata EDM: <b>MaintenanceOrder</b>
         * </p>
         *
         * @param value
         *            The maintenanceOrder to build this MaintOrderObjectListItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintOrderObjectListItem.MaintOrderObjectListItemBuilder maintenanceOrder( final String value )
        {
            maintenanceOrder = value;
            return this;
        }

    }

}
