/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.field.MaintOrderOpCompLongTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.link.MaintOrderOpCompLongTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.selectable.MaintOrderOpCompLongTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Maintenance Order Component Long Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MaintOrderOpCompLongText_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MaintOrderOpCompLongText extends VdmEntity<MaintOrderOpCompLongText>
{

    /**
     * Selector for all available fields of MaintOrderOpCompLongText.
     *
     */
    public final static MaintOrderOpCompLongTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrder</b>
     * </p>
     *
     * @return Order Number
     */
    @Key
    @SerializedName( "MaintenanceOrder" )
    @JsonProperty( "MaintenanceOrder" )
    @Nullable
    @ODataField( odataName = "MaintenanceOrder" )
    private String maintenanceOrder;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceOrder</b> field to query operations.
     *
     */
    public final static MaintOrderOpCompLongTextField<String> MAINTENANCE_ORDER =
        new MaintOrderOpCompLongTextField<String>("MaintenanceOrder");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderOperation</b>
     * </p>
     *
     * @return Maintenance Order Suboperation
     */
    @Key
    @SerializedName( "MaintenanceOrderOperation" )
    @JsonProperty( "MaintenanceOrderOperation" )
    @Nullable
    @ODataField( odataName = "MaintenanceOrderOperation" )
    private String maintenanceOrderOperation;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceOrderOperation</b> field to query operations.
     *
     */
    public final static MaintOrderOpCompLongTextField<String> MAINTENANCE_ORDER_OPERATION =
        new MaintOrderOpCompLongTextField<String>("MaintenanceOrderOperation");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderSubOperation</b>
     * </p>
     *
     * @return Maintenance Order Suboperation
     */
    @Key
    @SerializedName( "MaintenanceOrderSubOperation" )
    @JsonProperty( "MaintenanceOrderSubOperation" )
    @Nullable
    @ODataField( odataName = "MaintenanceOrderSubOperation" )
    private String maintenanceOrderSubOperation;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceOrderSubOperation</b> field to query operations.
     *
     */
    public final static MaintOrderOpCompLongTextField<String> MAINTENANCE_ORDER_SUB_OPERATION =
        new MaintOrderOpCompLongTextField<String>("MaintenanceOrderSubOperation");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderComponent</b>
     * </p>
     *
     * @return BOM item number
     */
    @Key
    @SerializedName( "MaintenanceOrderComponent" )
    @JsonProperty( "MaintenanceOrderComponent" )
    @Nullable
    @ODataField( odataName = "MaintenanceOrderComponent" )
    private String maintenanceOrderComponent;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceOrderComponent</b> field to query operations.
     *
     */
    public final static MaintOrderOpCompLongTextField<String> MAINTENANCE_ORDER_COMPONENT =
        new MaintOrderOpCompLongTextField<String>("MaintenanceOrderComponent");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>TextObjectType</b>
     * </p>
     *
     * @return Text ID
     */
    @Key
    @SerializedName( "TextObjectType" )
    @JsonProperty( "TextObjectType" )
    @Nullable
    @ODataField( odataName = "TextObjectType" )
    private String textObjectType;
    /**
     * Use with available fluent helpers to apply the <b>TextObjectType</b> field to query operations.
     *
     */
    public final static MaintOrderOpCompLongTextField<String> TEXT_OBJECT_TYPE =
        new MaintOrderOpCompLongTextField<String>("TextObjectType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static MaintOrderOpCompLongTextField<String> LANGUAGE =
        new MaintOrderOpCompLongTextField<String>("Language");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>OrderComponentLongText</b>
     * </p>
     *
     * @return Long Text
     */
    @SerializedName( "OrderComponentLongText" )
    @JsonProperty( "OrderComponentLongText" )
    @Nullable
    @ODataField( odataName = "OrderComponentLongText" )
    private String orderComponentLongText;
    /**
     * Use with available fluent helpers to apply the <b>OrderComponentLongText</b> field to query operations.
     *
     */
    public final static MaintOrderOpCompLongTextField<String> ORDER_COMPONENT_LONG_TEXT =
        new MaintOrderOpCompLongTextField<String>("OrderComponentLongText");
    /**
     * Navigation property <b>to_MaintenanceOrder</b> for <b>MaintOrderOpCompLongText</b> to single
     * <b>MaintenanceOrder</b>.
     *
     */
    @SerializedName( "to_MaintenanceOrder" )
    @JsonProperty( "to_MaintenanceOrder" )
    @ODataField( odataName = "to_MaintenanceOrder" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private MaintenanceOrder toMaintenanceOrder;
    /**
     * Navigation property <b>to_MaintenanceOrderComponent</b> for <b>MaintOrderOpCompLongText</b> to single
     * <b>MaintOrderOpComponent</b>.
     *
     */
    @SerializedName( "to_MaintenanceOrderComponent" )
    @JsonProperty( "to_MaintenanceOrderComponent" )
    @ODataField( odataName = "to_MaintenanceOrderComponent" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private MaintOrderOpComponent toMaintenanceOrderComponent;
    /**
     * Use with available fluent helpers to apply the <b>to_MaintenanceOrder</b> navigation property to query
     * operations.
     *
     */
    public final static MaintOrderOpCompLongTextOneToOneLink<MaintenanceOrder> TO_MAINTENANCE_ORDER =
        new MaintOrderOpCompLongTextOneToOneLink<MaintenanceOrder>("to_MaintenanceOrder");
    /**
     * Use with available fluent helpers to apply the <b>to_MaintenanceOrderComponent</b> navigation property to query
     * operations.
     *
     */
    public final static MaintOrderOpCompLongTextOneToOneLink<MaintOrderOpComponent> TO_MAINTENANCE_ORDER_COMPONENT =
        new MaintOrderOpCompLongTextOneToOneLink<MaintOrderOpComponent>("to_MaintenanceOrderComponent");

    @Nonnull
    @Override
    public Class<MaintOrderOpCompLongText> getType()
    {
        return MaintOrderOpCompLongText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrder</b>
     * </p>
     *
     * @param maintenanceOrder
     *            Order Number
     */
    public void setMaintenanceOrder( @Nullable final String maintenanceOrder )
    {
        rememberChangedField("MaintenanceOrder", this.maintenanceOrder);
        this.maintenanceOrder = maintenanceOrder;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderOperation</b>
     * </p>
     *
     * @param maintenanceOrderOperation
     *            Maintenance Order Suboperation
     */
    public void setMaintenanceOrderOperation( @Nullable final String maintenanceOrderOperation )
    {
        rememberChangedField("MaintenanceOrderOperation", this.maintenanceOrderOperation);
        this.maintenanceOrderOperation = maintenanceOrderOperation;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderSubOperation</b>
     * </p>
     *
     * @param maintenanceOrderSubOperation
     *            Maintenance Order Suboperation
     */
    public void setMaintenanceOrderSubOperation( @Nullable final String maintenanceOrderSubOperation )
    {
        rememberChangedField("MaintenanceOrderSubOperation", this.maintenanceOrderSubOperation);
        this.maintenanceOrderSubOperation = maintenanceOrderSubOperation;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderComponent</b>
     * </p>
     *
     * @param maintenanceOrderComponent
     *            BOM item number
     */
    public void setMaintenanceOrderComponent( @Nullable final String maintenanceOrderComponent )
    {
        rememberChangedField("MaintenanceOrderComponent", this.maintenanceOrderComponent);
        this.maintenanceOrderComponent = maintenanceOrderComponent;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>TextObjectType</b>
     * </p>
     *
     * @param textObjectType
     *            Text ID
     */
    public void setTextObjectType( @Nullable final String textObjectType )
    {
        rememberChangedField("TextObjectType", this.textObjectType);
        this.textObjectType = textObjectType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>OrderComponentLongText</b>
     * </p>
     *
     * @param orderComponentLongText
     *            Long Text
     */
    public void setOrderComponentLongText( @Nullable final String orderComponentLongText )
    {
        rememberChangedField("OrderComponentLongText", this.orderComponentLongText);
        this.orderComponentLongText = orderComponentLongText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "MaintOrderOpCompLongText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("MaintenanceOrder", getMaintenanceOrder());
        result.put("MaintenanceOrderOperation", getMaintenanceOrderOperation());
        result.put("MaintenanceOrderSubOperation", getMaintenanceOrderSubOperation());
        result.put("MaintenanceOrderComponent", getMaintenanceOrderComponent());
        result.put("TextObjectType", getTextObjectType());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("MaintenanceOrder", getMaintenanceOrder());
        values.put("MaintenanceOrderOperation", getMaintenanceOrderOperation());
        values.put("MaintenanceOrderSubOperation", getMaintenanceOrderSubOperation());
        values.put("MaintenanceOrderComponent", getMaintenanceOrderComponent());
        values.put("TextObjectType", getTextObjectType());
        values.put("Language", getLanguage());
        values.put("OrderComponentLongText", getOrderComponentLongText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("MaintenanceOrder") ) {
                final Object value = values.remove("MaintenanceOrder");
                if( (value == null) || (!value.equals(getMaintenanceOrder())) ) {
                    setMaintenanceOrder(((String) value));
                }
            }
            if( values.containsKey("MaintenanceOrderOperation") ) {
                final Object value = values.remove("MaintenanceOrderOperation");
                if( (value == null) || (!value.equals(getMaintenanceOrderOperation())) ) {
                    setMaintenanceOrderOperation(((String) value));
                }
            }
            if( values.containsKey("MaintenanceOrderSubOperation") ) {
                final Object value = values.remove("MaintenanceOrderSubOperation");
                if( (value == null) || (!value.equals(getMaintenanceOrderSubOperation())) ) {
                    setMaintenanceOrderSubOperation(((String) value));
                }
            }
            if( values.containsKey("MaintenanceOrderComponent") ) {
                final Object value = values.remove("MaintenanceOrderComponent");
                if( (value == null) || (!value.equals(getMaintenanceOrderComponent())) ) {
                    setMaintenanceOrderComponent(((String) value));
                }
            }
            if( values.containsKey("TextObjectType") ) {
                final Object value = values.remove("TextObjectType");
                if( (value == null) || (!value.equals(getTextObjectType())) ) {
                    setTextObjectType(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("OrderComponentLongText") ) {
                final Object value = values.remove("OrderComponentLongText");
                if( (value == null) || (!value.equals(getOrderComponentLongText())) ) {
                    setOrderComponentLongText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_MaintenanceOrder") ) {
                final Object value = (values).remove("to_MaintenanceOrder");
                if( value instanceof Map ) {
                    if( toMaintenanceOrder == null ) {
                        toMaintenanceOrder = new MaintenanceOrder();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toMaintenanceOrder.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_MaintenanceOrderComponent") ) {
                final Object value = (values).remove("to_MaintenanceOrderComponent");
                if( value instanceof Map ) {
                    if( toMaintenanceOrderComponent == null ) {
                        toMaintenanceOrderComponent = new MaintOrderOpComponent();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toMaintenanceOrderComponent.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> MaintOrderOpCompLongTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new MaintOrderOpCompLongTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MaintOrderOpCompLongTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MaintOrderOpCompLongTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceOrderService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toMaintenanceOrder != null ) {
            (values).put("to_MaintenanceOrder", toMaintenanceOrder);
        }
        if( toMaintenanceOrderComponent != null ) {
            (values).put("to_MaintenanceOrderComponent", toMaintenanceOrderComponent);
        }
        return values;
    }

    /**
     * Fetches the <b>MaintenanceOrder</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_MaintenanceOrder</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>MaintenanceOrder</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceOrder fetchMaintenanceOrder()
    {
        return fetchFieldAsSingle("to_MaintenanceOrder", MaintenanceOrder.class);
    }

    /**
     * Retrieval of associated <b>MaintenanceOrder</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_MaintenanceOrder</b>.
     * <p>
     * If the navigation property <b>to_MaintenanceOrder</b> of a queried <b>MaintOrderOpCompLongText</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintenanceOrder</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceOrder getMaintenanceOrderOrFetch()
    {
        if( toMaintenanceOrder == null ) {
            toMaintenanceOrder = fetchMaintenanceOrder();
        }
        return toMaintenanceOrder;
    }

    /**
     * Retrieval of associated <b>MaintenanceOrder</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_MaintenanceOrder</b>.
     * <p>
     * If the navigation property for an entity <b>MaintOrderOpCompLongText</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaintenanceOrder</b> is already loaded, the result will
     *         contain the <b>MaintenanceOrder</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<MaintenanceOrder> getMaintenanceOrderIfPresent()
    {
        return Option.of(toMaintenanceOrder);
    }

    /**
     * Overwrites the associated <b>MaintenanceOrder</b> entity for the loaded navigation property
     * <b>to_MaintenanceOrder</b>.
     *
     * @param value
     *            New <b>MaintenanceOrder</b> entity.
     */
    public void setMaintenanceOrder( final MaintenanceOrder value )
    {
        toMaintenanceOrder = value;
    }

    /**
     * Fetches the <b>MaintOrderOpComponent</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_MaintenanceOrderComponent</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>MaintOrderOpComponent</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintOrderOpComponent fetchMaintenanceOrderComponent()
    {
        return fetchFieldAsSingle("to_MaintenanceOrderComponent", MaintOrderOpComponent.class);
    }

    /**
     * Retrieval of associated <b>MaintOrderOpComponent</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_MaintenanceOrderComponent</b>.
     * <p>
     * If the navigation property <b>to_MaintenanceOrderComponent</b> of a queried <b>MaintOrderOpCompLongText</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintOrderOpComponent</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintOrderOpComponent getMaintenanceOrderComponentOrFetch()
    {
        if( toMaintenanceOrderComponent == null ) {
            toMaintenanceOrderComponent = fetchMaintenanceOrderComponent();
        }
        return toMaintenanceOrderComponent;
    }

    /**
     * Retrieval of associated <b>MaintOrderOpComponent</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_MaintenanceOrderComponent</b>.
     * <p>
     * If the navigation property for an entity <b>MaintOrderOpCompLongText</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaintenanceOrderComponent</b> is already loaded, the
     *         result will contain the <b>MaintOrderOpComponent</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<MaintOrderOpComponent> getMaintenanceOrderComponentIfPresent()
    {
        return Option.of(toMaintenanceOrderComponent);
    }

    /**
     * Overwrites the associated <b>MaintOrderOpComponent</b> entity for the loaded navigation property
     * <b>to_MaintenanceOrderComponent</b>.
     *
     * @param value
     *            New <b>MaintOrderOpComponent</b> entity.
     */
    public void setMaintenanceOrderComponent( final MaintOrderOpComponent value )
    {
        toMaintenanceOrderComponent = value;
    }

    /**
     * Helper class to allow for fluent creation of MaintOrderOpCompLongText instances.
     *
     */
    public final static class MaintOrderOpCompLongTextBuilder
    {

        private MaintenanceOrder toMaintenanceOrder;
        private String maintenanceOrder = null;
        private MaintOrderOpComponent toMaintenanceOrderComponent;
        private String maintenanceOrderComponent = null;

        private MaintOrderOpCompLongText.MaintOrderOpCompLongTextBuilder toMaintenanceOrder(
            final MaintenanceOrder value )
        {
            toMaintenanceOrder = value;
            return this;
        }

        /**
         * Navigation property <b>to_MaintenanceOrder</b> for <b>MaintOrderOpCompLongText</b> to single
         * <b>MaintenanceOrder</b>.
         *
         * @param value
         *            The MaintenanceOrder to build this MaintOrderOpCompLongText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintOrderOpCompLongText.MaintOrderOpCompLongTextBuilder maintenanceOrder( final MaintenanceOrder value )
        {
            return toMaintenanceOrder(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 12
         * <p>
         * Original property name from the Odata EDM: <b>MaintenanceOrder</b>
         * </p>
         *
         * @param value
         *            The maintenanceOrder to build this MaintOrderOpCompLongText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintOrderOpCompLongText.MaintOrderOpCompLongTextBuilder maintenanceOrder( final String value )
        {
            maintenanceOrder = value;
            return this;
        }

        private MaintOrderOpCompLongText.MaintOrderOpCompLongTextBuilder toMaintenanceOrderComponent(
            final MaintOrderOpComponent value )
        {
            toMaintenanceOrderComponent = value;
            return this;
        }

        /**
         * Navigation property <b>to_MaintenanceOrderComponent</b> for <b>MaintOrderOpCompLongText</b> to single
         * <b>MaintOrderOpComponent</b>.
         *
         * @param value
         *            The MaintOrderOpComponent to build this MaintOrderOpCompLongText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintOrderOpCompLongText.MaintOrderOpCompLongTextBuilder maintenanceOrderComponent(
            final MaintOrderOpComponent value )
        {
            return toMaintenanceOrderComponent(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 4
         * <p>
         * Original property name from the Odata EDM: <b>MaintenanceOrderComponent</b>
         * </p>
         *
         * @param value
         *            The maintenanceOrderComponent to build this MaintOrderOpCompLongText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintOrderOpCompLongText.MaintOrderOpCompLongTextBuilder maintenanceOrderComponent( final String value )
        {
            maintenanceOrderComponent = value;
            return this;
        }

    }

}
