/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperUpdate;

/**
 * Fluent helper to update an existing
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpCompLongText
 * MaintOrderOpCompLongText} entity and save it to the S/4HANA system.
 * <p>
 * To perform execution, call the {@link #executeRequest executeRequest} method on the fluent helper object.
 *
 */
public class MaintOrderOpCompLongTextUpdateFluentHelper
    extends
    FluentHelperUpdate<MaintOrderOpCompLongTextUpdateFluentHelper, MaintOrderOpCompLongText>
{

    /**
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpCompLongText
     * MaintOrderOpCompLongText} entity object that will be updated in the S/4HANA system.
     *
     */
    private final MaintOrderOpCompLongText entity;

    /**
     * Creates a fluent helper object that will update a
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpCompLongText
     * MaintOrderOpCompLongText} entity on the OData endpoint. To perform execution, call the {@link #executeRequest
     * executeRequest} method on the fluent helper object.
     *
     * @param servicePath
     *            The service path to direct the update requests to.
     * @param entity
     *            The MaintOrderOpCompLongText to take the updated values from.
     */
    public MaintOrderOpCompLongTextUpdateFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final MaintOrderOpCompLongText entity,
        @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
        this.entity = entity;
    }

    @Override
    @Nonnull
    protected MaintOrderOpCompLongText getEntity()
    {
        return entity;
    }

}
