/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.field.MaintOrderOpComponentField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.link.MaintOrderOpComponentLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.link.MaintOrderOpComponentOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.selectable.MaintOrderOpComponentSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Mainteance Order Component
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MaintOrderOpComponentType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MaintOrderOpComponent extends VdmEntity<MaintOrderOpComponent>
{

    /**
     * Selector for all available fields of MaintOrderOpComponent.
     *
     */
    public final static MaintOrderOpComponentSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrder</b>
     * </p>
     *
     * @return Order Number
     */
    @Key
    @SerializedName( "MaintenanceOrder" )
    @JsonProperty( "MaintenanceOrder" )
    @Nullable
    @ODataField( odataName = "MaintenanceOrder" )
    private String maintenanceOrder;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceOrder</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<String> MAINTENANCE_ORDER =
        new MaintOrderOpComponentField<String>("MaintenanceOrder");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderOperation</b>
     * </p>
     *
     * @return Maintenance Order Operation
     */
    @Key
    @SerializedName( "MaintenanceOrderOperation" )
    @JsonProperty( "MaintenanceOrderOperation" )
    @Nullable
    @ODataField( odataName = "MaintenanceOrderOperation" )
    private String maintenanceOrderOperation;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceOrderOperation</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<String> MAINTENANCE_ORDER_OPERATION =
        new MaintOrderOpComponentField<String>("MaintenanceOrderOperation");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderSubOperation</b>
     * </p>
     *
     * @return Maintenance Order Suboperation
     */
    @Key
    @SerializedName( "MaintenanceOrderSubOperation" )
    @JsonProperty( "MaintenanceOrderSubOperation" )
    @Nullable
    @ODataField( odataName = "MaintenanceOrderSubOperation" )
    private String maintenanceOrderSubOperation;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceOrderSubOperation</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<String> MAINTENANCE_ORDER_SUB_OPERATION =
        new MaintOrderOpComponentField<String>("MaintenanceOrderSubOperation");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderComponent</b>
     * </p>
     *
     * @return BOM item number
     */
    @Key
    @SerializedName( "MaintenanceOrderComponent" )
    @JsonProperty( "MaintenanceOrderComponent" )
    @Nullable
    @ODataField( odataName = "MaintenanceOrderComponent" )
    private String maintenanceOrderComponent;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceOrderComponent</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<String> MAINTENANCE_ORDER_COMPONENT =
        new MaintOrderOpComponentField<String>("MaintenanceOrderComponent");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Reservation</b>
     * </p>
     *
     * @return Number of reservation/dependent requirements
     */
    @SerializedName( "Reservation" )
    @JsonProperty( "Reservation" )
    @Nullable
    @ODataField( odataName = "Reservation" )
    private String reservation;
    /**
     * Use with available fluent helpers to apply the <b>Reservation</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<String> RESERVATION =
        new MaintOrderOpComponentField<String>("Reservation");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReservationItem</b>
     * </p>
     *
     * @return Item Number of Reservation / Dependent Requirements
     */
    @SerializedName( "ReservationItem" )
    @JsonProperty( "ReservationItem" )
    @Nullable
    @ODataField( odataName = "ReservationItem" )
    private String reservationItem;
    /**
     * Use with available fluent helpers to apply the <b>ReservationItem</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<String> RESERVATION_ITEM =
        new MaintOrderOpComponentField<String>("ReservationItem");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ReservationType</b>
     * </p>
     *
     * @return Record type
     */
    @SerializedName( "ReservationType" )
    @JsonProperty( "ReservationType" )
    @Nullable
    @ODataField( odataName = "ReservationType" )
    private String reservationType;
    /**
     * Use with available fluent helpers to apply the <b>ReservationType</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<String> RESERVATION_TYPE =
        new MaintOrderOpComponentField<String>("ReservationType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrderRoutingNumber</b>
     * </p>
     *
     * @return Routing number of operations in the order
     */
    @SerializedName( "MaintOrderRoutingNumber" )
    @JsonProperty( "MaintOrderRoutingNumber" )
    @Nullable
    @ODataField( odataName = "MaintOrderRoutingNumber" )
    private String maintOrderRoutingNumber;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrderRoutingNumber</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<String> MAINT_ORDER_ROUTING_NUMBER =
        new MaintOrderOpComponentField<String>("MaintOrderRoutingNumber");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrderOperationCounter</b>
     * </p>
     *
     * @return Internal counter
     */
    @SerializedName( "MaintOrderOperationCounter" )
    @JsonProperty( "MaintOrderOperationCounter" )
    @Nullable
    @ODataField( odataName = "MaintOrderOperationCounter" )
    private String maintOrderOperationCounter;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrderOperationCounter</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<String> MAINT_ORDER_OPERATION_COUNTER =
        new MaintOrderOpComponentField<String>("MaintOrderOperationCounter");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<String> PRODUCT = new MaintOrderOpComponentField<String>("Product");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdOperationComponentText</b>
     * </p>
     *
     * @return The maintOrdOperationComponentText contained in this entity.
     */
    @SerializedName( "MaintOrdOperationComponentText" )
    @JsonProperty( "MaintOrdOperationComponentText" )
    @Nullable
    @ODataField( odataName = "MaintOrdOperationComponentText" )
    private String maintOrdOperationComponentText;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrdOperationComponentText</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<String> MAINT_ORD_OPERATION_COMPONENT_TEXT =
        new MaintOrderOpComponentField<String>("MaintOrdOperationComponentText");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdOpCompRequiredQuantity</b>
     * </p>
     *
     * @return Requirement Quantity
     */
    @SerializedName( "MaintOrdOpCompRequiredQuantity" )
    @JsonProperty( "MaintOrdOpCompRequiredQuantity" )
    @Nullable
    @ODataField( odataName = "MaintOrdOpCompRequiredQuantity" )
    private BigDecimal maintOrdOpCompRequiredQuantity;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrdOpCompRequiredQuantity</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<BigDecimal> MAINT_ORD_OP_COMP_REQUIRED_QUANTITY =
        new MaintOrderOpComponentField<BigDecimal>("MaintOrdOpCompRequiredQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnit</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<String> BASE_UNIT =
        new MaintOrderOpComponentField<String>("BaseUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityInUnitOfEntry</b>
     * </p>
     *
     * @return Quantity in unit of entry
     */
    @SerializedName( "QuantityInUnitOfEntry" )
    @JsonProperty( "QuantityInUnitOfEntry" )
    @Nullable
    @ODataField( odataName = "QuantityInUnitOfEntry" )
    private BigDecimal quantityInUnitOfEntry;
    /**
     * Use with available fluent helpers to apply the <b>QuantityInUnitOfEntry</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<BigDecimal> QUANTITY_IN_UNIT_OF_ENTRY =
        new MaintOrderOpComponentField<BigDecimal>("QuantityInUnitOfEntry");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfEntry</b>
     * </p>
     *
     * @return Unit of entry
     */
    @SerializedName( "UnitOfEntry" )
    @JsonProperty( "UnitOfEntry" )
    @Nullable
    @ODataField( odataName = "UnitOfEntry" )
    private String unitOfEntry;
    /**
     * Use with available fluent helpers to apply the <b>UnitOfEntry</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<String> UNIT_OF_ENTRY =
        new MaintOrderOpComponentField<String>("UnitOfEntry");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequirementDate</b>
     * </p>
     *
     * @return The requirementDate contained in this entity.
     */
    @SerializedName( "RequirementDate" )
    @JsonProperty( "RequirementDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "RequirementDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime requirementDate;
    /**
     * Use with available fluent helpers to apply the <b>RequirementDate</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<LocalDateTime> REQUIREMENT_DATE =
        new MaintOrderOpComponentField<LocalDateTime>("RequirementDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequirementTime</b>
     * </p>
     *
     * @return The requirementTime contained in this entity.
     */
    @SerializedName( "RequirementTime" )
    @JsonProperty( "RequirementTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "RequirementTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime requirementTime;
    /**
     * Use with available fluent helpers to apply the <b>RequirementTime</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<LocalTime> REQUIREMENT_TIME =
        new MaintOrderOpComponentField<LocalTime>("RequirementTime");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Account Number of Supplier
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<String> SUPPLIER =
        new MaintOrderOpComponentField<String>("Supplier");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<String> PLANT = new MaintOrderOpComponentField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @return Storage Location
     */
    @SerializedName( "StorageLocation" )
    @JsonProperty( "StorageLocation" )
    @Nullable
    @ODataField( odataName = "StorageLocation" )
    private String storageLocation;
    /**
     * Use with available fluent helpers to apply the <b>StorageLocation</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<String> STORAGE_LOCATION =
        new MaintOrderOpComponentField<String>("StorageLocation");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdOpCompItemCategory</b>
     * </p>
     *
     * @return Item category (bill of material)
     */
    @SerializedName( "MaintOrdOpCompItemCategory" )
    @JsonProperty( "MaintOrdOpCompItemCategory" )
    @Nullable
    @ODataField( odataName = "MaintOrdOpCompItemCategory" )
    private String maintOrdOpCompItemCategory;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrdOpCompItemCategory</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<String> MAINT_ORD_OP_COMP_ITEM_CATEGORY =
        new MaintOrderOpComponentField<String>("MaintOrdOpCompItemCategory");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>GoodsMovementType</b>
     * </p>
     *
     * @return Movement Type (Inventory Management)
     */
    @SerializedName( "GoodsMovementType" )
    @JsonProperty( "GoodsMovementType" )
    @Nullable
    @ODataField( odataName = "GoodsMovementType" )
    private String goodsMovementType;
    /**
     * Use with available fluent helpers to apply the <b>GoodsMovementType</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<String> GOODS_MOVEMENT_TYPE =
        new MaintOrderOpComponentField<String>("GoodsMovementType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ReservationIsFinallyIssued</b>
     * </p>
     *
     * @return Final Issue for Reservation
     */
    @SerializedName( "ReservationIsFinallyIssued" )
    @JsonProperty( "ReservationIsFinallyIssued" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ReservationIsFinallyIssued" )
    private Boolean reservationIsFinallyIssued;
    /**
     * Use with available fluent helpers to apply the <b>ReservationIsFinallyIssued</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<Boolean> RESERVATION_IS_FINALLY_ISSUED =
        new MaintOrderOpComponentField<Boolean>("ReservationIsFinallyIssued");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @return Material Group
     */
    @SerializedName( "MaterialGroup" )
    @JsonProperty( "MaterialGroup" )
    @Nullable
    @ODataField( odataName = "MaterialGroup" )
    private String materialGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroup</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<String> MATERIAL_GROUP =
        new MaintOrderOpComponentField<String>("MaterialGroup");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProductTypeCode</b>
     * </p>
     *
     * @return Product Type Group
     */
    @SerializedName( "ProductTypeCode" )
    @JsonProperty( "ProductTypeCode" )
    @Nullable
    @ODataField( odataName = "ProductTypeCode" )
    private String productTypeCode;
    /**
     * Use with available fluent helpers to apply the <b>ProductTypeCode</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<String> PRODUCT_TYPE_CODE =
        new MaintOrderOpComponentField<String>("ProductTypeCode");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServicePerformer</b>
     * </p>
     *
     * @return Service Performer
     */
    @SerializedName( "ServicePerformer" )
    @JsonProperty( "ServicePerformer" )
    @Nullable
    @ODataField( odataName = "ServicePerformer" )
    private String servicePerformer;
    /**
     * Use with available fluent helpers to apply the <b>ServicePerformer</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<String> SERVICE_PERFORMER =
        new MaintOrderOpComponentField<String>("ServicePerformer");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PerformancePeriodStartDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "PerformancePeriodStartDateTime" )
    @JsonProperty( "PerformancePeriodStartDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "PerformancePeriodStartDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime performancePeriodStartDateTime;
    /**
     * Use with available fluent helpers to apply the <b>PerformancePeriodStartDateTime</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<ZonedDateTime> PERFORMANCE_PERIOD_START_DATE_TIME =
        new MaintOrderOpComponentField<ZonedDateTime>("PerformancePeriodStartDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PerformancePeriodStartDate</b>
     * </p>
     *
     * @return The performancePeriodStartDate contained in this entity.
     */
    @SerializedName( "PerformancePeriodStartDate" )
    @JsonProperty( "PerformancePeriodStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PerformancePeriodStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime performancePeriodStartDate;
    /**
     * Use with available fluent helpers to apply the <b>PerformancePeriodStartDate</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<LocalDateTime> PERFORMANCE_PERIOD_START_DATE =
        new MaintOrderOpComponentField<LocalDateTime>("PerformancePeriodStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PerformancePeriodEndDate</b>
     * </p>
     *
     * @return The performancePeriodEndDate contained in this entity.
     */
    @SerializedName( "PerformancePeriodEndDate" )
    @JsonProperty( "PerformancePeriodEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PerformancePeriodEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime performancePeriodEndDate;
    /**
     * Use with available fluent helpers to apply the <b>PerformancePeriodEndDate</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<LocalDateTime> PERFORMANCE_PERIOD_END_DATE =
        new MaintOrderOpComponentField<LocalDateTime>("PerformancePeriodEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PerformancePeriodEndDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "PerformancePeriodEndDateTime" )
    @JsonProperty( "PerformancePeriodEndDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "PerformancePeriodEndDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime performancePeriodEndDateTime;
    /**
     * Use with available fluent helpers to apply the <b>PerformancePeriodEndDateTime</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<ZonedDateTime> PERFORMANCE_PERIOD_END_DATE_TIME =
        new MaintOrderOpComponentField<ZonedDateTime>("PerformancePeriodEndDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PerformancePeriodStartTime</b>
     * </p>
     *
     * @return The performancePeriodStartTime contained in this entity.
     */
    @SerializedName( "PerformancePeriodStartTime" )
    @JsonProperty( "PerformancePeriodStartTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "PerformancePeriodStartTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime performancePeriodStartTime;
    /**
     * Use with available fluent helpers to apply the <b>PerformancePeriodStartTime</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<LocalTime> PERFORMANCE_PERIOD_START_TIME =
        new MaintOrderOpComponentField<LocalTime>("PerformancePeriodStartTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PerformancePeriodEndTime</b>
     * </p>
     *
     * @return The performancePeriodEndTime contained in this entity.
     */
    @SerializedName( "PerformancePeriodEndTime" )
    @JsonProperty( "PerformancePeriodEndTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "PerformancePeriodEndTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime performancePeriodEndTime;
    /**
     * Use with available fluent helpers to apply the <b>PerformancePeriodEndTime</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<LocalTime> PERFORMANCE_PERIOD_END_TIME =
        new MaintOrderOpComponentField<LocalTime>("PerformancePeriodEndTime");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>LeanServiceDuration</b>
     * </p>
     *
     * @return Duration of Lean Service
     */
    @SerializedName( "LeanServiceDuration" )
    @JsonProperty( "LeanServiceDuration" )
    @Nullable
    @ODataField( odataName = "LeanServiceDuration" )
    private BigDecimal leanServiceDuration;
    /**
     * Use with available fluent helpers to apply the <b>LeanServiceDuration</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<BigDecimal> LEAN_SERVICE_DURATION =
        new MaintOrderOpComponentField<BigDecimal>("LeanServiceDuration");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>LeanServiceDurationUnit</b>
     * </p>
     *
     * @return Duration Unit for a Lean Service
     */
    @SerializedName( "LeanServiceDurationUnit" )
    @JsonProperty( "LeanServiceDurationUnit" )
    @Nullable
    @ODataField( odataName = "LeanServiceDurationUnit" )
    private String leanServiceDurationUnit;
    /**
     * Use with available fluent helpers to apply the <b>LeanServiceDurationUnit</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<String> LEAN_SERVICE_DURATION_UNIT =
        new MaintOrderOpComponentField<String>("LeanServiceDurationUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DistributionFunction</b>
     * </p>
     *
     * @return Distribution function
     */
    @SerializedName( "DistributionFunction" )
    @JsonProperty( "DistributionFunction" )
    @Nullable
    @ODataField( odataName = "DistributionFunction" )
    private String distributionFunction;
    /**
     * Use with available fluent helpers to apply the <b>DistributionFunction</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<String> DISTRIBUTION_FUNCTION =
        new MaintOrderOpComponentField<String>("DistributionFunction");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SrvcSchedgIsAlignedWthOpWrkCtr</b>
     * </p>
     *
     * @return Align scheduling with work center operating hours
     */
    @SerializedName( "SrvcSchedgIsAlignedWthOpWrkCtr" )
    @JsonProperty( "SrvcSchedgIsAlignedWthOpWrkCtr" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "SrvcSchedgIsAlignedWthOpWrkCtr" )
    private Boolean srvcSchedgIsAlignedWthOpWrkCtr;
    /**
     * Use with available fluent helpers to apply the <b>SrvcSchedgIsAlignedWthOpWrkCtr</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<Boolean> SRVC_SCHEDG_IS_ALIGNED_WTH_OP_WRK_CTR =
        new MaintOrderOpComponentField<Boolean>("SrvcSchedgIsAlignedWthOpWrkCtr");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrderCompDebitCreditCode</b>
     * </p>
     *
     * @return Debit/Credit Indicator
     */
    @SerializedName( "MaintOrderCompDebitCreditCode" )
    @JsonProperty( "MaintOrderCompDebitCreditCode" )
    @Nullable
    @ODataField( odataName = "MaintOrderCompDebitCreditCode" )
    private String maintOrderCompDebitCreditCode;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrderCompDebitCreditCode</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<String> MAINT_ORDER_COMP_DEBIT_CREDIT_CODE =
        new MaintOrderOpComponentField<String>("MaintOrderCompDebitCreditCode");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>GoodsMovementIsAllowed</b>
     * </p>
     *
     * @return Goods Movement for Reservation Allowed
     */
    @SerializedName( "GoodsMovementIsAllowed" )
    @JsonProperty( "GoodsMovementIsAllowed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "GoodsMovementIsAllowed" )
    private Boolean goodsMovementIsAllowed;
    /**
     * Use with available fluent helpers to apply the <b>GoodsMovementIsAllowed</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<Boolean> GOODS_MOVEMENT_IS_ALLOWED =
        new MaintOrderOpComponentField<Boolean>("GoodsMovementIsAllowed");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderComponentBatch</b>
     * </p>
     *
     * @return Batch Number
     */
    @SerializedName( "MaintenanceOrderComponentBatch" )
    @JsonProperty( "MaintenanceOrderComponentBatch" )
    @Nullable
    @ODataField( odataName = "MaintenanceOrderComponentBatch" )
    private String maintenanceOrderComponentBatch;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceOrderComponentBatch</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<String> MAINTENANCE_ORDER_COMPONENT_BATCH =
        new MaintOrderOpComponentField<String>("MaintenanceOrderComponentBatch");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>QuantityIsFixed</b>
     * </p>
     *
     * @return Quantity is fixed
     */
    @SerializedName( "QuantityIsFixed" )
    @JsonProperty( "QuantityIsFixed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "QuantityIsFixed" )
    private Boolean quantityIsFixed;
    /**
     * Use with available fluent helpers to apply the <b>QuantityIsFixed</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<Boolean> QUANTITY_IS_FIXED =
        new MaintOrderOpComponentField<Boolean>("QuantityIsFixed");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdOpComponentGLAccount</b>
     * </p>
     *
     * @return G/L Account Number
     */
    @SerializedName( "MaintOrdOpComponentGLAccount" )
    @JsonProperty( "MaintOrdOpComponentGLAccount" )
    @Nullable
    @ODataField( odataName = "MaintOrdOpComponentGLAccount" )
    private String maintOrdOpComponentGLAccount;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrdOpComponentGLAccount</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<String> MAINT_ORD_OP_COMPONENT_GL_ACCOUNT =
        new MaintOrderOpComponentField<String>("MaintOrdOpComponentGLAccount");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdOpCompCostingRelevancy</b>
     * </p>
     *
     * @return Indicator for Relevancy to Costing
     */
    @SerializedName( "MaintOrdOpCompCostingRelevancy" )
    @JsonProperty( "MaintOrdOpCompCostingRelevancy" )
    @Nullable
    @ODataField( odataName = "MaintOrdOpCompCostingRelevancy" )
    private String maintOrdOpCompCostingRelevancy;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrdOpCompCostingRelevancy</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<String> MAINT_ORD_OP_COMP_COSTING_RELEVANCY =
        new MaintOrderOpComponentField<String>("MaintOrdOpCompCostingRelevancy");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintCompAltvProdUsgeRateInPct</b>
     * </p>
     *
     * @return Usage Probability in % (Alternative Item)
     */
    @SerializedName( "MaintCompAltvProdUsgeRateInPct" )
    @JsonProperty( "MaintCompAltvProdUsgeRateInPct" )
    @Nullable
    @ODataField( odataName = "MaintCompAltvProdUsgeRateInPct" )
    private BigDecimal maintCompAltvProdUsgeRateInPct;
    /**
     * Use with available fluent helpers to apply the <b>MaintCompAltvProdUsgeRateInPct</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<BigDecimal> MAINT_COMP_ALTV_PROD_USGE_RATE_IN_PCT =
        new MaintOrderOpComponentField<BigDecimal>("MaintCompAltvProdUsgeRateInPct");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrderOpComponentSortText</b>
     * </p>
     *
     * @return Sort String
     */
    @SerializedName( "MaintOrderOpComponentSortText" )
    @JsonProperty( "MaintOrderOpComponentSortText" )
    @Nullable
    @ODataField( odataName = "MaintOrderOpComponentSortText" )
    private String maintOrderOpComponentSortText;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrderOpComponentSortText</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<String> MAINT_ORDER_OP_COMPONENT_SORT_TEXT =
        new MaintOrderOpComponentField<String>("MaintOrderOpComponentSortText");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdOpCompIsBulkProduct</b>
     * </p>
     *
     * @return Indicator: Bulk Material
     */
    @SerializedName( "MaintOrdOpCompIsBulkProduct" )
    @JsonProperty( "MaintOrdOpCompIsBulkProduct" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "MaintOrdOpCompIsBulkProduct" )
    private Boolean maintOrdOpCompIsBulkProduct;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrdOpCompIsBulkProduct</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<Boolean> MAINT_ORD_OP_COMP_IS_BULK_PRODUCT =
        new MaintOrderOpComponentField<Boolean>("MaintOrdOpCompIsBulkProduct");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaterialProvisionType</b>
     * </p>
     *
     * @return Material Provision Indicator
     */
    @SerializedName( "MaterialProvisionType" )
    @JsonProperty( "MaterialProvisionType" )
    @Nullable
    @ODataField( odataName = "MaterialProvisionType" )
    private String materialProvisionType;
    /**
     * Use with available fluent helpers to apply the <b>MaterialProvisionType</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<String> MATERIAL_PROVISION_TYPE =
        new MaintOrderOpComponentField<String>("MaterialProvisionType");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdOpCompAssgdWBSElmntInt</b>
     * </p>
     *
     * @return WBS Element
     */
    @SerializedName( "MaintOrdOpCompAssgdWBSElmntInt" )
    @JsonProperty( "MaintOrdOpCompAssgdWBSElmntInt" )
    @Nullable
    @ODataField( odataName = "MaintOrdOpCompAssgdWBSElmntInt" )
    private String maintOrdOpCompAssgdWBSElmntInt;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrdOpCompAssgdWBSElmntInt</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<String> MAINT_ORD_OP_COMP_ASSGD_WBS_ELMNT_INT =
        new MaintOrderOpComponentField<String>("MaintOrdOpCompAssgdWBSElmntInt");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrderOpComponentPrice</b>
     * </p>
     *
     * @return Price in component currency
     */
    @SerializedName( "MaintOrderOpComponentPrice" )
    @JsonProperty( "MaintOrderOpComponentPrice" )
    @Nullable
    @ODataField( odataName = "MaintOrderOpComponentPrice" )
    private BigDecimal maintOrderOpComponentPrice;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrderOpComponentPrice</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<BigDecimal> MAINT_ORDER_OP_COMPONENT_PRICE =
        new MaintOrderOpComponentField<BigDecimal>("MaintOrderOpComponentPrice");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdOpComponentCurrency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "MaintOrdOpComponentCurrency" )
    @JsonProperty( "MaintOrdOpComponentCurrency" )
    @Nullable
    @ODataField( odataName = "MaintOrdOpComponentCurrency" )
    private String maintOrdOpComponentCurrency;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrdOpComponentCurrency</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<String> MAINT_ORD_OP_COMPONENT_CURRENCY =
        new MaintOrderOpComponentField<String>("MaintOrdOpComponentCurrency");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MatlCompIsMarkedForBackflush</b>
     * </p>
     *
     * @return Indicator: Backflush
     */
    @SerializedName( "MatlCompIsMarkedForBackflush" )
    @JsonProperty( "MatlCompIsMarkedForBackflush" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "MatlCompIsMarkedForBackflush" )
    private Boolean matlCompIsMarkedForBackflush;
    /**
     * Use with available fluent helpers to apply the <b>MatlCompIsMarkedForBackflush</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<Boolean> MATL_COMP_IS_MARKED_FOR_BACKFLUSH =
        new MaintOrderOpComponentField<Boolean>("MatlCompIsMarkedForBackflush");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     *
     * @return Purchasing Group
     */
    @SerializedName( "PurchasingGroup" )
    @JsonProperty( "PurchasingGroup" )
    @Nullable
    @ODataField( odataName = "PurchasingGroup" )
    private String purchasingGroup;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingGroup</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<String> PURCHASING_GROUP =
        new MaintOrderOpComponentField<String>("PurchasingGroup");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryTimeInDays</b>
     * </p>
     *
     * @return Delivery time in days
     */
    @SerializedName( "DeliveryTimeInDays" )
    @JsonProperty( "DeliveryTimeInDays" )
    @Nullable
    @ODataField( odataName = "DeliveryTimeInDays" )
    private BigDecimal deliveryTimeInDays;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryTimeInDays</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<BigDecimal> DELIVERY_TIME_IN_DAYS =
        new MaintOrderOpComponentField<BigDecimal>("DeliveryTimeInDays");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdOpCompGdsRecipientName</b>
     * </p>
     *
     * @return Goods Recipient
     */
    @SerializedName( "MaintOrdOpCompGdsRecipientName" )
    @JsonProperty( "MaintOrdOpCompGdsRecipientName" )
    @Nullable
    @ODataField( odataName = "MaintOrdOpCompGdsRecipientName" )
    private String maintOrdOpCompGdsRecipientName;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrdOpCompGdsRecipientName</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<String> MAINT_ORD_OP_COMP_GDS_RECIPIENT_NAME =
        new MaintOrderOpComponentField<String>("MaintOrdOpCompGdsRecipientName");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdOpCompUnloadingPtTxt</b>
     * </p>
     *
     * @return Unloading Point
     */
    @SerializedName( "MaintOrdOpCompUnloadingPtTxt" )
    @JsonProperty( "MaintOrdOpCompUnloadingPtTxt" )
    @Nullable
    @ODataField( odataName = "MaintOrdOpCompUnloadingPtTxt" )
    private String maintOrdOpCompUnloadingPtTxt;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrdOpCompUnloadingPtTxt</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<String> MAINT_ORD_OP_COMP_UNLOADING_PT_TXT =
        new MaintOrderOpComponentField<String>("MaintOrdOpCompUnloadingPtTxt");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>GoodsReceiptDurationInWorkDays</b>
     * </p>
     *
     * @return Goods receipt processing time in days
     */
    @SerializedName( "GoodsReceiptDurationInWorkDays" )
    @JsonProperty( "GoodsReceiptDurationInWorkDays" )
    @Nullable
    @ODataField( odataName = "GoodsReceiptDurationInWorkDays" )
    private BigDecimal goodsReceiptDurationInWorkDays;
    /**
     * Use with available fluent helpers to apply the <b>GoodsReceiptDurationInWorkDays</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<BigDecimal> GOODS_RECEIPT_DURATION_IN_WORK_DAYS =
        new MaintOrderOpComponentField<BigDecimal>("GoodsReceiptDurationInWorkDays");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingInfoRecord</b>
     * </p>
     *
     * @return Number of purchasing info record
     */
    @SerializedName( "PurchasingInfoRecord" )
    @JsonProperty( "PurchasingInfoRecord" )
    @Nullable
    @ODataField( odataName = "PurchasingInfoRecord" )
    private String purchasingInfoRecord;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingInfoRecord</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<String> PURCHASING_INFO_RECORD =
        new MaintOrderOpComponentField<String>("PurchasingInfoRecord");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OperationLeadTimeOffset</b>
     * </p>
     *
     * @return Lead-time offset for operation
     */
    @SerializedName( "OperationLeadTimeOffset" )
    @JsonProperty( "OperationLeadTimeOffset" )
    @Nullable
    @ODataField( odataName = "OperationLeadTimeOffset" )
    private BigDecimal operationLeadTimeOffset;
    /**
     * Use with available fluent helpers to apply the <b>OperationLeadTimeOffset</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<BigDecimal> OPERATION_LEAD_TIME_OFFSET =
        new MaintOrderOpComponentField<BigDecimal>("OperationLeadTimeOffset");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpsLeadTimeOffsetUnit</b>
     * </p>
     *
     * @return Unit for lead-time offset for operation
     */
    @SerializedName( "OpsLeadTimeOffsetUnit" )
    @JsonProperty( "OpsLeadTimeOffsetUnit" )
    @Nullable
    @ODataField( odataName = "OpsLeadTimeOffsetUnit" )
    private String opsLeadTimeOffsetUnit;
    /**
     * Use with available fluent helpers to apply the <b>OpsLeadTimeOffsetUnit</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<String> OPS_LEAD_TIME_OFFSET_UNIT =
        new MaintOrderOpComponentField<String>("OpsLeadTimeOffsetUnit");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdOpCompRequisitioner</b>
     * </p>
     *
     * @return Name of requisitioner/requester
     */
    @SerializedName( "MaintOrdOpCompRequisitioner" )
    @JsonProperty( "MaintOrdOpCompRequisitioner" )
    @Nullable
    @ODataField( odataName = "MaintOrdOpCompRequisitioner" )
    private String maintOrdOpCompRequisitioner;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrdOpCompRequisitioner</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<String> MAINT_ORD_OP_COMP_REQUISITIONER =
        new MaintOrderOpComponentField<String>("MaintOrdOpCompRequisitioner");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdOpCompProcmtTrckgNmbr</b>
     * </p>
     *
     * @return Requirement Tracking Number
     */
    @SerializedName( "MaintOrdOpCompProcmtTrckgNmbr" )
    @JsonProperty( "MaintOrdOpCompProcmtTrckgNmbr" )
    @Nullable
    @ODataField( odataName = "MaintOrdOpCompProcmtTrckgNmbr" )
    private String maintOrdOpCompProcmtTrckgNmbr;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrdOpCompProcmtTrckgNmbr</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<String> MAINT_ORD_OP_COMP_PROCMT_TRCKG_NMBR =
        new MaintOrderOpComponentField<String>("MaintOrdOpCompProcmtTrckgNmbr");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ResponsiblePurchaseOrg</b>
     * </p>
     *
     * @return Purchasing Organization
     */
    @SerializedName( "ResponsiblePurchaseOrg" )
    @JsonProperty( "ResponsiblePurchaseOrg" )
    @Nullable
    @ODataField( odataName = "ResponsiblePurchaseOrg" )
    private String responsiblePurchaseOrg;
    /**
     * Use with available fluent helpers to apply the <b>ResponsiblePurchaseOrg</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<String> RESPONSIBLE_PURCHASE_ORG =
        new MaintOrderOpComponentField<String>("ResponsiblePurchaseOrg");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdOpCompSpecialStockType</b>
     * </p>
     *
     * @return Special Stock Indicator
     */
    @SerializedName( "MaintOrdOpCompSpecialStockType" )
    @JsonProperty( "MaintOrdOpCompSpecialStockType" )
    @Nullable
    @ODataField( odataName = "MaintOrdOpCompSpecialStockType" )
    private String maintOrdOpCompSpecialStockType;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrdOpCompSpecialStockType</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<String> MAINT_ORD_OP_COMP_SPECIAL_STOCK_TYPE =
        new MaintOrderOpComponentField<String>("MaintOrdOpCompSpecialStockType");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>VariableSizeDimension1</b>
     * </p>
     *
     * @return Size 1
     */
    @SerializedName( "VariableSizeDimension1" )
    @JsonProperty( "VariableSizeDimension1" )
    @Nullable
    @ODataField( odataName = "VariableSizeDimension1" )
    private BigDecimal variableSizeDimension1;
    /**
     * Use with available fluent helpers to apply the <b>VariableSizeDimension1</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<BigDecimal> VARIABLE_SIZE_DIMENSION1 =
        new MaintOrderOpComponentField<BigDecimal>("VariableSizeDimension1");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>VariableSizeDimensionUnit</b>
     * </p>
     *
     * @return Unit of measure for sizes 1 to 3
     */
    @SerializedName( "VariableSizeDimensionUnit" )
    @JsonProperty( "VariableSizeDimensionUnit" )
    @Nullable
    @ODataField( odataName = "VariableSizeDimensionUnit" )
    private String variableSizeDimensionUnit;
    /**
     * Use with available fluent helpers to apply the <b>VariableSizeDimensionUnit</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<String> VARIABLE_SIZE_DIMENSION_UNIT =
        new MaintOrderOpComponentField<String>("VariableSizeDimensionUnit");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>VariableSizeCompFormulaKey</b>
     * </p>
     *
     * @return Formula Key for Variable-Size Items
     */
    @SerializedName( "VariableSizeCompFormulaKey" )
    @JsonProperty( "VariableSizeCompFormulaKey" )
    @Nullable
    @ODataField( odataName = "VariableSizeCompFormulaKey" )
    private String variableSizeCompFormulaKey;
    /**
     * Use with available fluent helpers to apply the <b>VariableSizeCompFormulaKey</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<String> VARIABLE_SIZE_COMP_FORMULA_KEY =
        new MaintOrderOpComponentField<String>("VariableSizeCompFormulaKey");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>VariableSizeDimension2</b>
     * </p>
     *
     * @return Size 2
     */
    @SerializedName( "VariableSizeDimension2" )
    @JsonProperty( "VariableSizeDimension2" )
    @Nullable
    @ODataField( odataName = "VariableSizeDimension2" )
    private BigDecimal variableSizeDimension2;
    /**
     * Use with available fluent helpers to apply the <b>VariableSizeDimension2</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<BigDecimal> VARIABLE_SIZE_DIMENSION2 =
        new MaintOrderOpComponentField<BigDecimal>("VariableSizeDimension2");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfVariableSizeItem</b>
     * </p>
     *
     * @return Number of Variable-Size Items
     */
    @SerializedName( "NumberOfVariableSizeItem" )
    @JsonProperty( "NumberOfVariableSizeItem" )
    @Nullable
    @ODataField( odataName = "NumberOfVariableSizeItem" )
    private Integer numberOfVariableSizeItem;
    /**
     * Use with available fluent helpers to apply the <b>NumberOfVariableSizeItem</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<Integer> NUMBER_OF_VARIABLE_SIZE_ITEM =
        new MaintOrderOpComponentField<Integer>("NumberOfVariableSizeItem");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>VariableSizeDimension3</b>
     * </p>
     *
     * @return Size 3
     */
    @SerializedName( "VariableSizeDimension3" )
    @JsonProperty( "VariableSizeDimension3" )
    @Nullable
    @ODataField( odataName = "VariableSizeDimension3" )
    private BigDecimal variableSizeDimension3;
    /**
     * Use with available fluent helpers to apply the <b>VariableSizeDimension3</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<BigDecimal> VARIABLE_SIZE_DIMENSION3 =
        new MaintOrderOpComponentField<BigDecimal>("VariableSizeDimension3");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>VariableSizeItemQuantity</b>
     * </p>
     *
     * @return Variable-Size Item Quantity per Piece (PC)
     */
    @SerializedName( "VariableSizeItemQuantity" )
    @JsonProperty( "VariableSizeItemQuantity" )
    @Nullable
    @ODataField( odataName = "VariableSizeItemQuantity" )
    private BigDecimal variableSizeItemQuantity;
    /**
     * Use with available fluent helpers to apply the <b>VariableSizeItemQuantity</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<BigDecimal> VARIABLE_SIZE_ITEM_QUANTITY =
        new MaintOrderOpComponentField<BigDecimal>("VariableSizeItemQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>VariableSizeComponentUnit</b>
     * </p>
     *
     * @return Unit of Measure for Variable-Size Item
     */
    @SerializedName( "VariableSizeComponentUnit" )
    @JsonProperty( "VariableSizeComponentUnit" )
    @Nullable
    @ODataField( odataName = "VariableSizeComponentUnit" )
    private String variableSizeComponentUnit;
    /**
     * Use with available fluent helpers to apply the <b>VariableSizeComponentUnit</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<String> VARIABLE_SIZE_COMPONENT_UNIT =
        new MaintOrderOpComponentField<String>("VariableSizeComponentUnit");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RqmtDateIsEnteredManually</b>
     * </p>
     *
     * @return Manual Maintenance of Requirement Date
     */
    @SerializedName( "RqmtDateIsEnteredManually" )
    @JsonProperty( "RqmtDateIsEnteredManually" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "RqmtDateIsEnteredManually" )
    private Boolean rqmtDateIsEnteredManually;
    /**
     * Use with available fluent helpers to apply the <b>RqmtDateIsEnteredManually</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<Boolean> RQMT_DATE_IS_ENTERED_MANUALLY =
        new MaintOrderOpComponentField<Boolean>("RqmtDateIsEnteredManually");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SupplierProduct</b>
     * </p>
     *
     * @return Material Number Used by Supplier
     */
    @SerializedName( "SupplierProduct" )
    @JsonProperty( "SupplierProduct" )
    @Nullable
    @ODataField( odataName = "SupplierProduct" )
    private String supplierProduct;
    /**
     * Use with available fluent helpers to apply the <b>SupplierProduct</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<String> SUPPLIER_PRODUCT =
        new MaintOrderOpComponentField<String>("SupplierProduct");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdCompPurOutlineAgrmtItm</b>
     * </p>
     *
     * @return Item Number of Purchasing Document
     */
    @SerializedName( "MaintOrdCompPurOutlineAgrmtItm" )
    @JsonProperty( "MaintOrdCompPurOutlineAgrmtItm" )
    @Nullable
    @ODataField( odataName = "MaintOrdCompPurOutlineAgrmtItm" )
    private String maintOrdCompPurOutlineAgrmtItm;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrdCompPurOutlineAgrmtItm</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<String> MAINT_ORD_COMP_PUR_OUTLINE_AGRMT_ITM =
        new MaintOrderOpComponentField<String>("MaintOrdCompPurOutlineAgrmtItm");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Controlling Area
     */
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<String> CONTROLLING_AREA =
        new MaintOrderOpComponentField<String>("ControllingArea");
    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrderComponentInternalID</b>
     * </p>
     *
     * @return Object Number
     */
    @SerializedName( "MaintOrderComponentInternalID" )
    @JsonProperty( "MaintOrderComponentInternalID" )
    @Nullable
    @ODataField( odataName = "MaintOrderComponentInternalID" )
    private String maintOrderComponentInternalID;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrderComponentInternalID</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<String> MAINT_ORDER_COMPONENT_INTERNAL_ID =
        new MaintOrderOpComponentField<String>("MaintOrderComponentInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisition</b>
     * </p>
     *
     * @return Purchase Requisition Number
     */
    @SerializedName( "PurchaseRequisition" )
    @JsonProperty( "PurchaseRequisition" )
    @Nullable
    @ODataField( odataName = "PurchaseRequisition" )
    private String purchaseRequisition;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseRequisition</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<String> PURCHASE_REQUISITION =
        new MaintOrderOpComponentField<String>("PurchaseRequisition");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisitionItem</b>
     * </p>
     *
     * @return Item number of purchase requisition
     */
    @SerializedName( "PurchaseRequisitionItem" )
    @JsonProperty( "PurchaseRequisitionItem" )
    @Nullable
    @ODataField( odataName = "PurchaseRequisitionItem" )
    private String purchaseRequisitionItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseRequisitionItem</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<String> PURCHASE_REQUISITION_ITEM =
        new MaintOrderOpComponentField<String>("PurchaseRequisitionItem");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OverallLimitAmount</b>
     * </p>
     *
     * @return Overall Limit
     */
    @SerializedName( "OverallLimitAmount" )
    @JsonProperty( "OverallLimitAmount" )
    @Nullable
    @ODataField( odataName = "OverallLimitAmount" )
    private BigDecimal overallLimitAmount;
    /**
     * Use with available fluent helpers to apply the <b>OverallLimitAmount</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<BigDecimal> OVERALL_LIMIT_AMOUNT =
        new MaintOrderOpComponentField<BigDecimal>("OverallLimitAmount");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ExpectedOverallLimitAmount</b>
     * </p>
     *
     * @return Expected Value of Overall Limit
     */
    @SerializedName( "ExpectedOverallLimitAmount" )
    @JsonProperty( "ExpectedOverallLimitAmount" )
    @Nullable
    @ODataField( odataName = "ExpectedOverallLimitAmount" )
    private BigDecimal expectedOverallLimitAmount;
    /**
     * Use with available fluent helpers to apply the <b>ExpectedOverallLimitAmount</b> field to query operations.
     *
     */
    public final static MaintOrderOpComponentField<BigDecimal> EXPECTED_OVERALL_LIMIT_AMOUNT =
        new MaintOrderOpComponentField<BigDecimal>("ExpectedOverallLimitAmount");
    /**
     * Navigation property <b>to_MaintenanceOrderOperation</b> for <b>MaintOrderOpComponent</b> to single
     * <b>MaintenanceOrderOperation</b>.
     *
     */
    @SerializedName( "to_MaintenanceOrderOperation" )
    @JsonProperty( "to_MaintenanceOrderOperation" )
    @ODataField( odataName = "to_MaintenanceOrderOperation" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private MaintenanceOrderOperation toMaintenanceOrderOperation;
    /**
     * Navigation property <b>to_MaintenanceOrder</b> for <b>MaintOrderOpComponent</b> to single
     * <b>MaintenanceOrder</b>.
     *
     */
    @SerializedName( "to_MaintenanceOrder" )
    @JsonProperty( "to_MaintenanceOrder" )
    @ODataField( odataName = "to_MaintenanceOrder" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private MaintenanceOrder toMaintenanceOrder;
    /**
     * Navigation property <b>to_MaintOrderOpCompLongText</b> for <b>MaintOrderOpComponent</b> to multiple
     * <b>MaintOrderOpCompLongText</b>.
     *
     */
    @SerializedName( "to_MaintOrderOpCompLongText" )
    @JsonProperty( "to_MaintOrderOpCompLongText" )
    @ODataField( odataName = "to_MaintOrderOpCompLongText" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MaintOrderOpCompLongText> toMaintOrderOpCompLongText;
    /**
     * Use with available fluent helpers to apply the <b>to_MaintenanceOrderOperation</b> navigation property to query
     * operations.
     *
     */
    public final static MaintOrderOpComponentOneToOneLink<MaintenanceOrderOperation> TO_MAINTENANCE_ORDER_OPERATION =
        new MaintOrderOpComponentOneToOneLink<MaintenanceOrderOperation>("to_MaintenanceOrderOperation");
    /**
     * Use with available fluent helpers to apply the <b>to_MaintenanceOrder</b> navigation property to query
     * operations.
     *
     */
    public final static MaintOrderOpComponentOneToOneLink<MaintenanceOrder> TO_MAINTENANCE_ORDER =
        new MaintOrderOpComponentOneToOneLink<MaintenanceOrder>("to_MaintenanceOrder");
    /**
     * Use with available fluent helpers to apply the <b>to_MaintOrderOpCompLongText</b> navigation property to query
     * operations.
     *
     */
    public final static MaintOrderOpComponentLink<MaintOrderOpCompLongText> TO_MAINT_ORDER_OP_COMP_LONG_TEXT =
        new MaintOrderOpComponentLink<MaintOrderOpCompLongText>("to_MaintOrderOpCompLongText");

    @Nonnull
    @Override
    public Class<MaintOrderOpComponent> getType()
    {
        return MaintOrderOpComponent.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrder</b>
     * </p>
     *
     * @param maintenanceOrder
     *            Order Number
     */
    public void setMaintenanceOrder( @Nullable final String maintenanceOrder )
    {
        rememberChangedField("MaintenanceOrder", this.maintenanceOrder);
        this.maintenanceOrder = maintenanceOrder;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderOperation</b>
     * </p>
     *
     * @param maintenanceOrderOperation
     *            Maintenance Order Operation
     */
    public void setMaintenanceOrderOperation( @Nullable final String maintenanceOrderOperation )
    {
        rememberChangedField("MaintenanceOrderOperation", this.maintenanceOrderOperation);
        this.maintenanceOrderOperation = maintenanceOrderOperation;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderSubOperation</b>
     * </p>
     *
     * @param maintenanceOrderSubOperation
     *            Maintenance Order Suboperation
     */
    public void setMaintenanceOrderSubOperation( @Nullable final String maintenanceOrderSubOperation )
    {
        rememberChangedField("MaintenanceOrderSubOperation", this.maintenanceOrderSubOperation);
        this.maintenanceOrderSubOperation = maintenanceOrderSubOperation;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderComponent</b>
     * </p>
     *
     * @param maintenanceOrderComponent
     *            BOM item number
     */
    public void setMaintenanceOrderComponent( @Nullable final String maintenanceOrderComponent )
    {
        rememberChangedField("MaintenanceOrderComponent", this.maintenanceOrderComponent);
        this.maintenanceOrderComponent = maintenanceOrderComponent;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Reservation</b>
     * </p>
     *
     * @param reservation
     *            Number of reservation/dependent requirements
     */
    public void setReservation( @Nullable final String reservation )
    {
        rememberChangedField("Reservation", this.reservation);
        this.reservation = reservation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReservationItem</b>
     * </p>
     *
     * @param reservationItem
     *            Item Number of Reservation / Dependent Requirements
     */
    public void setReservationItem( @Nullable final String reservationItem )
    {
        rememberChangedField("ReservationItem", this.reservationItem);
        this.reservationItem = reservationItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ReservationType</b>
     * </p>
     *
     * @param reservationType
     *            Record type
     */
    public void setReservationType( @Nullable final String reservationType )
    {
        rememberChangedField("ReservationType", this.reservationType);
        this.reservationType = reservationType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrderRoutingNumber</b>
     * </p>
     *
     * @param maintOrderRoutingNumber
     *            Routing number of operations in the order
     */
    public void setMaintOrderRoutingNumber( @Nullable final String maintOrderRoutingNumber )
    {
        rememberChangedField("MaintOrderRoutingNumber", this.maintOrderRoutingNumber);
        this.maintOrderRoutingNumber = maintOrderRoutingNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrderOperationCounter</b>
     * </p>
     *
     * @param maintOrderOperationCounter
     *            Internal counter
     */
    public void setMaintOrderOperationCounter( @Nullable final String maintOrderOperationCounter )
    {
        rememberChangedField("MaintOrderOperationCounter", this.maintOrderOperationCounter);
        this.maintOrderOperationCounter = maintOrderOperationCounter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Material Number
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdOperationComponentText</b>
     * </p>
     *
     * @param maintOrdOperationComponentText
     *            The maintOrdOperationComponentText to set.
     */
    public void setMaintOrdOperationComponentText( @Nullable final String maintOrdOperationComponentText )
    {
        rememberChangedField("MaintOrdOperationComponentText", this.maintOrdOperationComponentText);
        this.maintOrdOperationComponentText = maintOrdOperationComponentText;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdOpCompRequiredQuantity</b>
     * </p>
     *
     * @param maintOrdOpCompRequiredQuantity
     *            Requirement Quantity
     */
    public void setMaintOrdOpCompRequiredQuantity( @Nullable final BigDecimal maintOrdOpCompRequiredQuantity )
    {
        rememberChangedField("MaintOrdOpCompRequiredQuantity", this.maintOrdOpCompRequiredQuantity);
        this.maintOrdOpCompRequiredQuantity = maintOrdOpCompRequiredQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Base Unit of Measure
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityInUnitOfEntry</b>
     * </p>
     *
     * @param quantityInUnitOfEntry
     *            Quantity in unit of entry
     */
    public void setQuantityInUnitOfEntry( @Nullable final BigDecimal quantityInUnitOfEntry )
    {
        rememberChangedField("QuantityInUnitOfEntry", this.quantityInUnitOfEntry);
        this.quantityInUnitOfEntry = quantityInUnitOfEntry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfEntry</b>
     * </p>
     *
     * @param unitOfEntry
     *            Unit of entry
     */
    public void setUnitOfEntry( @Nullable final String unitOfEntry )
    {
        rememberChangedField("UnitOfEntry", this.unitOfEntry);
        this.unitOfEntry = unitOfEntry;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequirementDate</b>
     * </p>
     *
     * @param requirementDate
     *            The requirementDate to set.
     */
    public void setRequirementDate( @Nullable final LocalDateTime requirementDate )
    {
        rememberChangedField("RequirementDate", this.requirementDate);
        this.requirementDate = requirementDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequirementTime</b>
     * </p>
     *
     * @param requirementTime
     *            The requirementTime to set.
     */
    public void setRequirementTime( @Nullable final LocalTime requirementTime )
    {
        rememberChangedField("RequirementTime", this.requirementTime);
        this.requirementTime = requirementTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Account Number of Supplier
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @param storageLocation
     *            Storage Location
     */
    public void setStorageLocation( @Nullable final String storageLocation )
    {
        rememberChangedField("StorageLocation", this.storageLocation);
        this.storageLocation = storageLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdOpCompItemCategory</b>
     * </p>
     *
     * @param maintOrdOpCompItemCategory
     *            Item category (bill of material)
     */
    public void setMaintOrdOpCompItemCategory( @Nullable final String maintOrdOpCompItemCategory )
    {
        rememberChangedField("MaintOrdOpCompItemCategory", this.maintOrdOpCompItemCategory);
        this.maintOrdOpCompItemCategory = maintOrdOpCompItemCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>GoodsMovementType</b>
     * </p>
     *
     * @param goodsMovementType
     *            Movement Type (Inventory Management)
     */
    public void setGoodsMovementType( @Nullable final String goodsMovementType )
    {
        rememberChangedField("GoodsMovementType", this.goodsMovementType);
        this.goodsMovementType = goodsMovementType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ReservationIsFinallyIssued</b>
     * </p>
     *
     * @param reservationIsFinallyIssued
     *            Final Issue for Reservation
     */
    public void setReservationIsFinallyIssued( @Nullable final Boolean reservationIsFinallyIssued )
    {
        rememberChangedField("ReservationIsFinallyIssued", this.reservationIsFinallyIssued);
        this.reservationIsFinallyIssued = reservationIsFinallyIssued;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @param materialGroup
     *            Material Group
     */
    public void setMaterialGroup( @Nullable final String materialGroup )
    {
        rememberChangedField("MaterialGroup", this.materialGroup);
        this.materialGroup = materialGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProductTypeCode</b>
     * </p>
     *
     * @param productTypeCode
     *            Product Type Group
     */
    public void setProductTypeCode( @Nullable final String productTypeCode )
    {
        rememberChangedField("ProductTypeCode", this.productTypeCode);
        this.productTypeCode = productTypeCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServicePerformer</b>
     * </p>
     *
     * @param servicePerformer
     *            Service Performer
     */
    public void setServicePerformer( @Nullable final String servicePerformer )
    {
        rememberChangedField("ServicePerformer", this.servicePerformer);
        this.servicePerformer = servicePerformer;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PerformancePeriodStartDateTime</b>
     * </p>
     *
     * @param performancePeriodStartDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setPerformancePeriodStartDateTime( @Nullable final ZonedDateTime performancePeriodStartDateTime )
    {
        rememberChangedField("PerformancePeriodStartDateTime", this.performancePeriodStartDateTime);
        this.performancePeriodStartDateTime = performancePeriodStartDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PerformancePeriodStartDate</b>
     * </p>
     *
     * @param performancePeriodStartDate
     *            The performancePeriodStartDate to set.
     */
    public void setPerformancePeriodStartDate( @Nullable final LocalDateTime performancePeriodStartDate )
    {
        rememberChangedField("PerformancePeriodStartDate", this.performancePeriodStartDate);
        this.performancePeriodStartDate = performancePeriodStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PerformancePeriodEndDate</b>
     * </p>
     *
     * @param performancePeriodEndDate
     *            The performancePeriodEndDate to set.
     */
    public void setPerformancePeriodEndDate( @Nullable final LocalDateTime performancePeriodEndDate )
    {
        rememberChangedField("PerformancePeriodEndDate", this.performancePeriodEndDate);
        this.performancePeriodEndDate = performancePeriodEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PerformancePeriodEndDateTime</b>
     * </p>
     *
     * @param performancePeriodEndDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setPerformancePeriodEndDateTime( @Nullable final ZonedDateTime performancePeriodEndDateTime )
    {
        rememberChangedField("PerformancePeriodEndDateTime", this.performancePeriodEndDateTime);
        this.performancePeriodEndDateTime = performancePeriodEndDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PerformancePeriodStartTime</b>
     * </p>
     *
     * @param performancePeriodStartTime
     *            The performancePeriodStartTime to set.
     */
    public void setPerformancePeriodStartTime( @Nullable final LocalTime performancePeriodStartTime )
    {
        rememberChangedField("PerformancePeriodStartTime", this.performancePeriodStartTime);
        this.performancePeriodStartTime = performancePeriodStartTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PerformancePeriodEndTime</b>
     * </p>
     *
     * @param performancePeriodEndTime
     *            The performancePeriodEndTime to set.
     */
    public void setPerformancePeriodEndTime( @Nullable final LocalTime performancePeriodEndTime )
    {
        rememberChangedField("PerformancePeriodEndTime", this.performancePeriodEndTime);
        this.performancePeriodEndTime = performancePeriodEndTime;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>LeanServiceDuration</b>
     * </p>
     *
     * @param leanServiceDuration
     *            Duration of Lean Service
     */
    public void setLeanServiceDuration( @Nullable final BigDecimal leanServiceDuration )
    {
        rememberChangedField("LeanServiceDuration", this.leanServiceDuration);
        this.leanServiceDuration = leanServiceDuration;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>LeanServiceDurationUnit</b>
     * </p>
     *
     * @param leanServiceDurationUnit
     *            Duration Unit for a Lean Service
     */
    public void setLeanServiceDurationUnit( @Nullable final String leanServiceDurationUnit )
    {
        rememberChangedField("LeanServiceDurationUnit", this.leanServiceDurationUnit);
        this.leanServiceDurationUnit = leanServiceDurationUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DistributionFunction</b>
     * </p>
     *
     * @param distributionFunction
     *            Distribution function
     */
    public void setDistributionFunction( @Nullable final String distributionFunction )
    {
        rememberChangedField("DistributionFunction", this.distributionFunction);
        this.distributionFunction = distributionFunction;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SrvcSchedgIsAlignedWthOpWrkCtr</b>
     * </p>
     *
     * @param srvcSchedgIsAlignedWthOpWrkCtr
     *            Align scheduling with work center operating hours
     */
    public void setSrvcSchedgIsAlignedWthOpWrkCtr( @Nullable final Boolean srvcSchedgIsAlignedWthOpWrkCtr )
    {
        rememberChangedField("SrvcSchedgIsAlignedWthOpWrkCtr", this.srvcSchedgIsAlignedWthOpWrkCtr);
        this.srvcSchedgIsAlignedWthOpWrkCtr = srvcSchedgIsAlignedWthOpWrkCtr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrderCompDebitCreditCode</b>
     * </p>
     *
     * @param maintOrderCompDebitCreditCode
     *            Debit/Credit Indicator
     */
    public void setMaintOrderCompDebitCreditCode( @Nullable final String maintOrderCompDebitCreditCode )
    {
        rememberChangedField("MaintOrderCompDebitCreditCode", this.maintOrderCompDebitCreditCode);
        this.maintOrderCompDebitCreditCode = maintOrderCompDebitCreditCode;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>GoodsMovementIsAllowed</b>
     * </p>
     *
     * @param goodsMovementIsAllowed
     *            Goods Movement for Reservation Allowed
     */
    public void setGoodsMovementIsAllowed( @Nullable final Boolean goodsMovementIsAllowed )
    {
        rememberChangedField("GoodsMovementIsAllowed", this.goodsMovementIsAllowed);
        this.goodsMovementIsAllowed = goodsMovementIsAllowed;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderComponentBatch</b>
     * </p>
     *
     * @param maintenanceOrderComponentBatch
     *            Batch Number
     */
    public void setMaintenanceOrderComponentBatch( @Nullable final String maintenanceOrderComponentBatch )
    {
        rememberChangedField("MaintenanceOrderComponentBatch", this.maintenanceOrderComponentBatch);
        this.maintenanceOrderComponentBatch = maintenanceOrderComponentBatch;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>QuantityIsFixed</b>
     * </p>
     *
     * @param quantityIsFixed
     *            Quantity is fixed
     */
    public void setQuantityIsFixed( @Nullable final Boolean quantityIsFixed )
    {
        rememberChangedField("QuantityIsFixed", this.quantityIsFixed);
        this.quantityIsFixed = quantityIsFixed;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdOpComponentGLAccount</b>
     * </p>
     *
     * @param maintOrdOpComponentGLAccount
     *            G/L Account Number
     */
    public void setMaintOrdOpComponentGLAccount( @Nullable final String maintOrdOpComponentGLAccount )
    {
        rememberChangedField("MaintOrdOpComponentGLAccount", this.maintOrdOpComponentGLAccount);
        this.maintOrdOpComponentGLAccount = maintOrdOpComponentGLAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdOpCompCostingRelevancy</b>
     * </p>
     *
     * @param maintOrdOpCompCostingRelevancy
     *            Indicator for Relevancy to Costing
     */
    public void setMaintOrdOpCompCostingRelevancy( @Nullable final String maintOrdOpCompCostingRelevancy )
    {
        rememberChangedField("MaintOrdOpCompCostingRelevancy", this.maintOrdOpCompCostingRelevancy);
        this.maintOrdOpCompCostingRelevancy = maintOrdOpCompCostingRelevancy;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintCompAltvProdUsgeRateInPct</b>
     * </p>
     *
     * @param maintCompAltvProdUsgeRateInPct
     *            Usage Probability in % (Alternative Item)
     */
    public void setMaintCompAltvProdUsgeRateInPct( @Nullable final BigDecimal maintCompAltvProdUsgeRateInPct )
    {
        rememberChangedField("MaintCompAltvProdUsgeRateInPct", this.maintCompAltvProdUsgeRateInPct);
        this.maintCompAltvProdUsgeRateInPct = maintCompAltvProdUsgeRateInPct;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrderOpComponentSortText</b>
     * </p>
     *
     * @param maintOrderOpComponentSortText
     *            Sort String
     */
    public void setMaintOrderOpComponentSortText( @Nullable final String maintOrderOpComponentSortText )
    {
        rememberChangedField("MaintOrderOpComponentSortText", this.maintOrderOpComponentSortText);
        this.maintOrderOpComponentSortText = maintOrderOpComponentSortText;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdOpCompIsBulkProduct</b>
     * </p>
     *
     * @param maintOrdOpCompIsBulkProduct
     *            Indicator: Bulk Material
     */
    public void setMaintOrdOpCompIsBulkProduct( @Nullable final Boolean maintOrdOpCompIsBulkProduct )
    {
        rememberChangedField("MaintOrdOpCompIsBulkProduct", this.maintOrdOpCompIsBulkProduct);
        this.maintOrdOpCompIsBulkProduct = maintOrdOpCompIsBulkProduct;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaterialProvisionType</b>
     * </p>
     *
     * @param materialProvisionType
     *            Material Provision Indicator
     */
    public void setMaterialProvisionType( @Nullable final String materialProvisionType )
    {
        rememberChangedField("MaterialProvisionType", this.materialProvisionType);
        this.materialProvisionType = materialProvisionType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdOpCompAssgdWBSElmntInt</b>
     * </p>
     *
     * @param maintOrdOpCompAssgdWBSElmntInt
     *            WBS Element
     */
    public void setMaintOrdOpCompAssgdWBSElmntInt( @Nullable final String maintOrdOpCompAssgdWBSElmntInt )
    {
        rememberChangedField("MaintOrdOpCompAssgdWBSElmntInt", this.maintOrdOpCompAssgdWBSElmntInt);
        this.maintOrdOpCompAssgdWBSElmntInt = maintOrdOpCompAssgdWBSElmntInt;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrderOpComponentPrice</b>
     * </p>
     *
     * @param maintOrderOpComponentPrice
     *            Price in component currency
     */
    public void setMaintOrderOpComponentPrice( @Nullable final BigDecimal maintOrderOpComponentPrice )
    {
        rememberChangedField("MaintOrderOpComponentPrice", this.maintOrderOpComponentPrice);
        this.maintOrderOpComponentPrice = maintOrderOpComponentPrice;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdOpComponentCurrency</b>
     * </p>
     *
     * @param maintOrdOpComponentCurrency
     *            Currency Key
     */
    public void setMaintOrdOpComponentCurrency( @Nullable final String maintOrdOpComponentCurrency )
    {
        rememberChangedField("MaintOrdOpComponentCurrency", this.maintOrdOpComponentCurrency);
        this.maintOrdOpComponentCurrency = maintOrdOpComponentCurrency;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MatlCompIsMarkedForBackflush</b>
     * </p>
     *
     * @param matlCompIsMarkedForBackflush
     *            Indicator: Backflush
     */
    public void setMatlCompIsMarkedForBackflush( @Nullable final Boolean matlCompIsMarkedForBackflush )
    {
        rememberChangedField("MatlCompIsMarkedForBackflush", this.matlCompIsMarkedForBackflush);
        this.matlCompIsMarkedForBackflush = matlCompIsMarkedForBackflush;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     *
     * @param purchasingGroup
     *            Purchasing Group
     */
    public void setPurchasingGroup( @Nullable final String purchasingGroup )
    {
        rememberChangedField("PurchasingGroup", this.purchasingGroup);
        this.purchasingGroup = purchasingGroup;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryTimeInDays</b>
     * </p>
     *
     * @param deliveryTimeInDays
     *            Delivery time in days
     */
    public void setDeliveryTimeInDays( @Nullable final BigDecimal deliveryTimeInDays )
    {
        rememberChangedField("DeliveryTimeInDays", this.deliveryTimeInDays);
        this.deliveryTimeInDays = deliveryTimeInDays;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdOpCompGdsRecipientName</b>
     * </p>
     *
     * @param maintOrdOpCompGdsRecipientName
     *            Goods Recipient
     */
    public void setMaintOrdOpCompGdsRecipientName( @Nullable final String maintOrdOpCompGdsRecipientName )
    {
        rememberChangedField("MaintOrdOpCompGdsRecipientName", this.maintOrdOpCompGdsRecipientName);
        this.maintOrdOpCompGdsRecipientName = maintOrdOpCompGdsRecipientName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdOpCompUnloadingPtTxt</b>
     * </p>
     *
     * @param maintOrdOpCompUnloadingPtTxt
     *            Unloading Point
     */
    public void setMaintOrdOpCompUnloadingPtTxt( @Nullable final String maintOrdOpCompUnloadingPtTxt )
    {
        rememberChangedField("MaintOrdOpCompUnloadingPtTxt", this.maintOrdOpCompUnloadingPtTxt);
        this.maintOrdOpCompUnloadingPtTxt = maintOrdOpCompUnloadingPtTxt;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>GoodsReceiptDurationInWorkDays</b>
     * </p>
     *
     * @param goodsReceiptDurationInWorkDays
     *            Goods receipt processing time in days
     */
    public void setGoodsReceiptDurationInWorkDays( @Nullable final BigDecimal goodsReceiptDurationInWorkDays )
    {
        rememberChangedField("GoodsReceiptDurationInWorkDays", this.goodsReceiptDurationInWorkDays);
        this.goodsReceiptDurationInWorkDays = goodsReceiptDurationInWorkDays;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingInfoRecord</b>
     * </p>
     *
     * @param purchasingInfoRecord
     *            Number of purchasing info record
     */
    public void setPurchasingInfoRecord( @Nullable final String purchasingInfoRecord )
    {
        rememberChangedField("PurchasingInfoRecord", this.purchasingInfoRecord);
        this.purchasingInfoRecord = purchasingInfoRecord;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OperationLeadTimeOffset</b>
     * </p>
     *
     * @param operationLeadTimeOffset
     *            Lead-time offset for operation
     */
    public void setOperationLeadTimeOffset( @Nullable final BigDecimal operationLeadTimeOffset )
    {
        rememberChangedField("OperationLeadTimeOffset", this.operationLeadTimeOffset);
        this.operationLeadTimeOffset = operationLeadTimeOffset;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpsLeadTimeOffsetUnit</b>
     * </p>
     *
     * @param opsLeadTimeOffsetUnit
     *            Unit for lead-time offset for operation
     */
    public void setOpsLeadTimeOffsetUnit( @Nullable final String opsLeadTimeOffsetUnit )
    {
        rememberChangedField("OpsLeadTimeOffsetUnit", this.opsLeadTimeOffsetUnit);
        this.opsLeadTimeOffsetUnit = opsLeadTimeOffsetUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdOpCompRequisitioner</b>
     * </p>
     *
     * @param maintOrdOpCompRequisitioner
     *            Name of requisitioner/requester
     */
    public void setMaintOrdOpCompRequisitioner( @Nullable final String maintOrdOpCompRequisitioner )
    {
        rememberChangedField("MaintOrdOpCompRequisitioner", this.maintOrdOpCompRequisitioner);
        this.maintOrdOpCompRequisitioner = maintOrdOpCompRequisitioner;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdOpCompProcmtTrckgNmbr</b>
     * </p>
     *
     * @param maintOrdOpCompProcmtTrckgNmbr
     *            Requirement Tracking Number
     */
    public void setMaintOrdOpCompProcmtTrckgNmbr( @Nullable final String maintOrdOpCompProcmtTrckgNmbr )
    {
        rememberChangedField("MaintOrdOpCompProcmtTrckgNmbr", this.maintOrdOpCompProcmtTrckgNmbr);
        this.maintOrdOpCompProcmtTrckgNmbr = maintOrdOpCompProcmtTrckgNmbr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ResponsiblePurchaseOrg</b>
     * </p>
     *
     * @param responsiblePurchaseOrg
     *            Purchasing Organization
     */
    public void setResponsiblePurchaseOrg( @Nullable final String responsiblePurchaseOrg )
    {
        rememberChangedField("ResponsiblePurchaseOrg", this.responsiblePurchaseOrg);
        this.responsiblePurchaseOrg = responsiblePurchaseOrg;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdOpCompSpecialStockType</b>
     * </p>
     *
     * @param maintOrdOpCompSpecialStockType
     *            Special Stock Indicator
     */
    public void setMaintOrdOpCompSpecialStockType( @Nullable final String maintOrdOpCompSpecialStockType )
    {
        rememberChangedField("MaintOrdOpCompSpecialStockType", this.maintOrdOpCompSpecialStockType);
        this.maintOrdOpCompSpecialStockType = maintOrdOpCompSpecialStockType;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>VariableSizeDimension1</b>
     * </p>
     *
     * @param variableSizeDimension1
     *            Size 1
     */
    public void setVariableSizeDimension1( @Nullable final BigDecimal variableSizeDimension1 )
    {
        rememberChangedField("VariableSizeDimension1", this.variableSizeDimension1);
        this.variableSizeDimension1 = variableSizeDimension1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>VariableSizeDimensionUnit</b>
     * </p>
     *
     * @param variableSizeDimensionUnit
     *            Unit of measure for sizes 1 to 3
     */
    public void setVariableSizeDimensionUnit( @Nullable final String variableSizeDimensionUnit )
    {
        rememberChangedField("VariableSizeDimensionUnit", this.variableSizeDimensionUnit);
        this.variableSizeDimensionUnit = variableSizeDimensionUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>VariableSizeCompFormulaKey</b>
     * </p>
     *
     * @param variableSizeCompFormulaKey
     *            Formula Key for Variable-Size Items
     */
    public void setVariableSizeCompFormulaKey( @Nullable final String variableSizeCompFormulaKey )
    {
        rememberChangedField("VariableSizeCompFormulaKey", this.variableSizeCompFormulaKey);
        this.variableSizeCompFormulaKey = variableSizeCompFormulaKey;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>VariableSizeDimension2</b>
     * </p>
     *
     * @param variableSizeDimension2
     *            Size 2
     */
    public void setVariableSizeDimension2( @Nullable final BigDecimal variableSizeDimension2 )
    {
        rememberChangedField("VariableSizeDimension2", this.variableSizeDimension2);
        this.variableSizeDimension2 = variableSizeDimension2;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfVariableSizeItem</b>
     * </p>
     *
     * @param numberOfVariableSizeItem
     *            Number of Variable-Size Items
     */
    public void setNumberOfVariableSizeItem( @Nullable final Integer numberOfVariableSizeItem )
    {
        rememberChangedField("NumberOfVariableSizeItem", this.numberOfVariableSizeItem);
        this.numberOfVariableSizeItem = numberOfVariableSizeItem;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>VariableSizeDimension3</b>
     * </p>
     *
     * @param variableSizeDimension3
     *            Size 3
     */
    public void setVariableSizeDimension3( @Nullable final BigDecimal variableSizeDimension3 )
    {
        rememberChangedField("VariableSizeDimension3", this.variableSizeDimension3);
        this.variableSizeDimension3 = variableSizeDimension3;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>VariableSizeItemQuantity</b>
     * </p>
     *
     * @param variableSizeItemQuantity
     *            Variable-Size Item Quantity per Piece (PC)
     */
    public void setVariableSizeItemQuantity( @Nullable final BigDecimal variableSizeItemQuantity )
    {
        rememberChangedField("VariableSizeItemQuantity", this.variableSizeItemQuantity);
        this.variableSizeItemQuantity = variableSizeItemQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>VariableSizeComponentUnit</b>
     * </p>
     *
     * @param variableSizeComponentUnit
     *            Unit of Measure for Variable-Size Item
     */
    public void setVariableSizeComponentUnit( @Nullable final String variableSizeComponentUnit )
    {
        rememberChangedField("VariableSizeComponentUnit", this.variableSizeComponentUnit);
        this.variableSizeComponentUnit = variableSizeComponentUnit;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RqmtDateIsEnteredManually</b>
     * </p>
     *
     * @param rqmtDateIsEnteredManually
     *            Manual Maintenance of Requirement Date
     */
    public void setRqmtDateIsEnteredManually( @Nullable final Boolean rqmtDateIsEnteredManually )
    {
        rememberChangedField("RqmtDateIsEnteredManually", this.rqmtDateIsEnteredManually);
        this.rqmtDateIsEnteredManually = rqmtDateIsEnteredManually;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SupplierProduct</b>
     * </p>
     *
     * @param supplierProduct
     *            Material Number Used by Supplier
     */
    public void setSupplierProduct( @Nullable final String supplierProduct )
    {
        rememberChangedField("SupplierProduct", this.supplierProduct);
        this.supplierProduct = supplierProduct;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdCompPurOutlineAgrmtItm</b>
     * </p>
     *
     * @param maintOrdCompPurOutlineAgrmtItm
     *            Item Number of Purchasing Document
     */
    public void setMaintOrdCompPurOutlineAgrmtItm( @Nullable final String maintOrdCompPurOutlineAgrmtItm )
    {
        rememberChangedField("MaintOrdCompPurOutlineAgrmtItm", this.maintOrdCompPurOutlineAgrmtItm);
        this.maintOrdCompPurOutlineAgrmtItm = maintOrdCompPurOutlineAgrmtItm;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Controlling Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrderComponentInternalID</b>
     * </p>
     *
     * @param maintOrderComponentInternalID
     *            Object Number
     */
    public void setMaintOrderComponentInternalID( @Nullable final String maintOrderComponentInternalID )
    {
        rememberChangedField("MaintOrderComponentInternalID", this.maintOrderComponentInternalID);
        this.maintOrderComponentInternalID = maintOrderComponentInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisition</b>
     * </p>
     *
     * @param purchaseRequisition
     *            Purchase Requisition Number
     */
    public void setPurchaseRequisition( @Nullable final String purchaseRequisition )
    {
        rememberChangedField("PurchaseRequisition", this.purchaseRequisition);
        this.purchaseRequisition = purchaseRequisition;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisitionItem</b>
     * </p>
     *
     * @param purchaseRequisitionItem
     *            Item number of purchase requisition
     */
    public void setPurchaseRequisitionItem( @Nullable final String purchaseRequisitionItem )
    {
        rememberChangedField("PurchaseRequisitionItem", this.purchaseRequisitionItem);
        this.purchaseRequisitionItem = purchaseRequisitionItem;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OverallLimitAmount</b>
     * </p>
     *
     * @param overallLimitAmount
     *            Overall Limit
     */
    public void setOverallLimitAmount( @Nullable final BigDecimal overallLimitAmount )
    {
        rememberChangedField("OverallLimitAmount", this.overallLimitAmount);
        this.overallLimitAmount = overallLimitAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ExpectedOverallLimitAmount</b>
     * </p>
     *
     * @param expectedOverallLimitAmount
     *            Expected Value of Overall Limit
     */
    public void setExpectedOverallLimitAmount( @Nullable final BigDecimal expectedOverallLimitAmount )
    {
        rememberChangedField("ExpectedOverallLimitAmount", this.expectedOverallLimitAmount);
        this.expectedOverallLimitAmount = expectedOverallLimitAmount;
    }

    @Override
    protected String getEntityCollection()
    {
        return "MaintOrderOpComponent";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("MaintenanceOrder", getMaintenanceOrder());
        result.put("MaintenanceOrderOperation", getMaintenanceOrderOperation());
        result.put("MaintenanceOrderSubOperation", getMaintenanceOrderSubOperation());
        result.put("MaintenanceOrderComponent", getMaintenanceOrderComponent());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("MaintenanceOrder", getMaintenanceOrder());
        values.put("MaintenanceOrderOperation", getMaintenanceOrderOperation());
        values.put("MaintenanceOrderSubOperation", getMaintenanceOrderSubOperation());
        values.put("MaintenanceOrderComponent", getMaintenanceOrderComponent());
        values.put("Reservation", getReservation());
        values.put("ReservationItem", getReservationItem());
        values.put("ReservationType", getReservationType());
        values.put("MaintOrderRoutingNumber", getMaintOrderRoutingNumber());
        values.put("MaintOrderOperationCounter", getMaintOrderOperationCounter());
        values.put("Product", getProduct());
        values.put("MaintOrdOperationComponentText", getMaintOrdOperationComponentText());
        values.put("MaintOrdOpCompRequiredQuantity", getMaintOrdOpCompRequiredQuantity());
        values.put("BaseUnit", getBaseUnit());
        values.put("QuantityInUnitOfEntry", getQuantityInUnitOfEntry());
        values.put("UnitOfEntry", getUnitOfEntry());
        values.put("RequirementDate", getRequirementDate());
        values.put("RequirementTime", getRequirementTime());
        values.put("Supplier", getSupplier());
        values.put("Plant", getPlant());
        values.put("StorageLocation", getStorageLocation());
        values.put("MaintOrdOpCompItemCategory", getMaintOrdOpCompItemCategory());
        values.put("GoodsMovementType", getGoodsMovementType());
        values.put("ReservationIsFinallyIssued", getReservationIsFinallyIssued());
        values.put("MaterialGroup", getMaterialGroup());
        values.put("ProductTypeCode", getProductTypeCode());
        values.put("ServicePerformer", getServicePerformer());
        values.put("PerformancePeriodStartDateTime", getPerformancePeriodStartDateTime());
        values.put("PerformancePeriodStartDate", getPerformancePeriodStartDate());
        values.put("PerformancePeriodEndDate", getPerformancePeriodEndDate());
        values.put("PerformancePeriodEndDateTime", getPerformancePeriodEndDateTime());
        values.put("PerformancePeriodStartTime", getPerformancePeriodStartTime());
        values.put("PerformancePeriodEndTime", getPerformancePeriodEndTime());
        values.put("LeanServiceDuration", getLeanServiceDuration());
        values.put("LeanServiceDurationUnit", getLeanServiceDurationUnit());
        values.put("DistributionFunction", getDistributionFunction());
        values.put("SrvcSchedgIsAlignedWthOpWrkCtr", getSrvcSchedgIsAlignedWthOpWrkCtr());
        values.put("MaintOrderCompDebitCreditCode", getMaintOrderCompDebitCreditCode());
        values.put("GoodsMovementIsAllowed", getGoodsMovementIsAllowed());
        values.put("MaintenanceOrderComponentBatch", getMaintenanceOrderComponentBatch());
        values.put("QuantityIsFixed", getQuantityIsFixed());
        values.put("MaintOrdOpComponentGLAccount", getMaintOrdOpComponentGLAccount());
        values.put("MaintOrdOpCompCostingRelevancy", getMaintOrdOpCompCostingRelevancy());
        values.put("MaintCompAltvProdUsgeRateInPct", getMaintCompAltvProdUsgeRateInPct());
        values.put("MaintOrderOpComponentSortText", getMaintOrderOpComponentSortText());
        values.put("MaintOrdOpCompIsBulkProduct", getMaintOrdOpCompIsBulkProduct());
        values.put("MaterialProvisionType", getMaterialProvisionType());
        values.put("MaintOrdOpCompAssgdWBSElmntInt", getMaintOrdOpCompAssgdWBSElmntInt());
        values.put("MaintOrderOpComponentPrice", getMaintOrderOpComponentPrice());
        values.put("MaintOrdOpComponentCurrency", getMaintOrdOpComponentCurrency());
        values.put("MatlCompIsMarkedForBackflush", getMatlCompIsMarkedForBackflush());
        values.put("PurchasingGroup", getPurchasingGroup());
        values.put("DeliveryTimeInDays", getDeliveryTimeInDays());
        values.put("MaintOrdOpCompGdsRecipientName", getMaintOrdOpCompGdsRecipientName());
        values.put("MaintOrdOpCompUnloadingPtTxt", getMaintOrdOpCompUnloadingPtTxt());
        values.put("GoodsReceiptDurationInWorkDays", getGoodsReceiptDurationInWorkDays());
        values.put("PurchasingInfoRecord", getPurchasingInfoRecord());
        values.put("OperationLeadTimeOffset", getOperationLeadTimeOffset());
        values.put("OpsLeadTimeOffsetUnit", getOpsLeadTimeOffsetUnit());
        values.put("MaintOrdOpCompRequisitioner", getMaintOrdOpCompRequisitioner());
        values.put("MaintOrdOpCompProcmtTrckgNmbr", getMaintOrdOpCompProcmtTrckgNmbr());
        values.put("ResponsiblePurchaseOrg", getResponsiblePurchaseOrg());
        values.put("MaintOrdOpCompSpecialStockType", getMaintOrdOpCompSpecialStockType());
        values.put("VariableSizeDimension1", getVariableSizeDimension1());
        values.put("VariableSizeDimensionUnit", getVariableSizeDimensionUnit());
        values.put("VariableSizeCompFormulaKey", getVariableSizeCompFormulaKey());
        values.put("VariableSizeDimension2", getVariableSizeDimension2());
        values.put("NumberOfVariableSizeItem", getNumberOfVariableSizeItem());
        values.put("VariableSizeDimension3", getVariableSizeDimension3());
        values.put("VariableSizeItemQuantity", getVariableSizeItemQuantity());
        values.put("VariableSizeComponentUnit", getVariableSizeComponentUnit());
        values.put("RqmtDateIsEnteredManually", getRqmtDateIsEnteredManually());
        values.put("SupplierProduct", getSupplierProduct());
        values.put("MaintOrdCompPurOutlineAgrmtItm", getMaintOrdCompPurOutlineAgrmtItm());
        values.put("ControllingArea", getControllingArea());
        values.put("MaintOrderComponentInternalID", getMaintOrderComponentInternalID());
        values.put("PurchaseRequisition", getPurchaseRequisition());
        values.put("PurchaseRequisitionItem", getPurchaseRequisitionItem());
        values.put("OverallLimitAmount", getOverallLimitAmount());
        values.put("ExpectedOverallLimitAmount", getExpectedOverallLimitAmount());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("MaintenanceOrder") ) {
                final Object value = values.remove("MaintenanceOrder");
                if( (value == null) || (!value.equals(getMaintenanceOrder())) ) {
                    setMaintenanceOrder(((String) value));
                }
            }
            if( values.containsKey("MaintenanceOrderOperation") ) {
                final Object value = values.remove("MaintenanceOrderOperation");
                if( (value == null) || (!value.equals(getMaintenanceOrderOperation())) ) {
                    setMaintenanceOrderOperation(((String) value));
                }
            }
            if( values.containsKey("MaintenanceOrderSubOperation") ) {
                final Object value = values.remove("MaintenanceOrderSubOperation");
                if( (value == null) || (!value.equals(getMaintenanceOrderSubOperation())) ) {
                    setMaintenanceOrderSubOperation(((String) value));
                }
            }
            if( values.containsKey("MaintenanceOrderComponent") ) {
                final Object value = values.remove("MaintenanceOrderComponent");
                if( (value == null) || (!value.equals(getMaintenanceOrderComponent())) ) {
                    setMaintenanceOrderComponent(((String) value));
                }
            }
            if( values.containsKey("Reservation") ) {
                final Object value = values.remove("Reservation");
                if( (value == null) || (!value.equals(getReservation())) ) {
                    setReservation(((String) value));
                }
            }
            if( values.containsKey("ReservationItem") ) {
                final Object value = values.remove("ReservationItem");
                if( (value == null) || (!value.equals(getReservationItem())) ) {
                    setReservationItem(((String) value));
                }
            }
            if( values.containsKey("ReservationType") ) {
                final Object value = values.remove("ReservationType");
                if( (value == null) || (!value.equals(getReservationType())) ) {
                    setReservationType(((String) value));
                }
            }
            if( values.containsKey("MaintOrderRoutingNumber") ) {
                final Object value = values.remove("MaintOrderRoutingNumber");
                if( (value == null) || (!value.equals(getMaintOrderRoutingNumber())) ) {
                    setMaintOrderRoutingNumber(((String) value));
                }
            }
            if( values.containsKey("MaintOrderOperationCounter") ) {
                final Object value = values.remove("MaintOrderOperationCounter");
                if( (value == null) || (!value.equals(getMaintOrderOperationCounter())) ) {
                    setMaintOrderOperationCounter(((String) value));
                }
            }
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("MaintOrdOperationComponentText") ) {
                final Object value = values.remove("MaintOrdOperationComponentText");
                if( (value == null) || (!value.equals(getMaintOrdOperationComponentText())) ) {
                    setMaintOrdOperationComponentText(((String) value));
                }
            }
            if( values.containsKey("MaintOrdOpCompRequiredQuantity") ) {
                final Object value = values.remove("MaintOrdOpCompRequiredQuantity");
                if( (value == null) || (!value.equals(getMaintOrdOpCompRequiredQuantity())) ) {
                    setMaintOrdOpCompRequiredQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
            if( values.containsKey("QuantityInUnitOfEntry") ) {
                final Object value = values.remove("QuantityInUnitOfEntry");
                if( (value == null) || (!value.equals(getQuantityInUnitOfEntry())) ) {
                    setQuantityInUnitOfEntry(((BigDecimal) value));
                }
            }
            if( values.containsKey("UnitOfEntry") ) {
                final Object value = values.remove("UnitOfEntry");
                if( (value == null) || (!value.equals(getUnitOfEntry())) ) {
                    setUnitOfEntry(((String) value));
                }
            }
            if( values.containsKey("RequirementDate") ) {
                final Object value = values.remove("RequirementDate");
                if( (value == null) || (!value.equals(getRequirementDate())) ) {
                    setRequirementDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("RequirementTime") ) {
                final Object value = values.remove("RequirementTime");
                if( (value == null) || (!value.equals(getRequirementTime())) ) {
                    setRequirementTime(((LocalTime) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("StorageLocation") ) {
                final Object value = values.remove("StorageLocation");
                if( (value == null) || (!value.equals(getStorageLocation())) ) {
                    setStorageLocation(((String) value));
                }
            }
            if( values.containsKey("MaintOrdOpCompItemCategory") ) {
                final Object value = values.remove("MaintOrdOpCompItemCategory");
                if( (value == null) || (!value.equals(getMaintOrdOpCompItemCategory())) ) {
                    setMaintOrdOpCompItemCategory(((String) value));
                }
            }
            if( values.containsKey("GoodsMovementType") ) {
                final Object value = values.remove("GoodsMovementType");
                if( (value == null) || (!value.equals(getGoodsMovementType())) ) {
                    setGoodsMovementType(((String) value));
                }
            }
            if( values.containsKey("ReservationIsFinallyIssued") ) {
                final Object value = values.remove("ReservationIsFinallyIssued");
                if( (value == null) || (!value.equals(getReservationIsFinallyIssued())) ) {
                    setReservationIsFinallyIssued(((Boolean) value));
                }
            }
            if( values.containsKey("MaterialGroup") ) {
                final Object value = values.remove("MaterialGroup");
                if( (value == null) || (!value.equals(getMaterialGroup())) ) {
                    setMaterialGroup(((String) value));
                }
            }
            if( values.containsKey("ProductTypeCode") ) {
                final Object value = values.remove("ProductTypeCode");
                if( (value == null) || (!value.equals(getProductTypeCode())) ) {
                    setProductTypeCode(((String) value));
                }
            }
            if( values.containsKey("ServicePerformer") ) {
                final Object value = values.remove("ServicePerformer");
                if( (value == null) || (!value.equals(getServicePerformer())) ) {
                    setServicePerformer(((String) value));
                }
            }
            if( values.containsKey("PerformancePeriodStartDateTime") ) {
                final Object value = values.remove("PerformancePeriodStartDateTime");
                if( (value == null) || (!value.equals(getPerformancePeriodStartDateTime())) ) {
                    setPerformancePeriodStartDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("PerformancePeriodStartDate") ) {
                final Object value = values.remove("PerformancePeriodStartDate");
                if( (value == null) || (!value.equals(getPerformancePeriodStartDate())) ) {
                    setPerformancePeriodStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PerformancePeriodEndDate") ) {
                final Object value = values.remove("PerformancePeriodEndDate");
                if( (value == null) || (!value.equals(getPerformancePeriodEndDate())) ) {
                    setPerformancePeriodEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PerformancePeriodEndDateTime") ) {
                final Object value = values.remove("PerformancePeriodEndDateTime");
                if( (value == null) || (!value.equals(getPerformancePeriodEndDateTime())) ) {
                    setPerformancePeriodEndDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("PerformancePeriodStartTime") ) {
                final Object value = values.remove("PerformancePeriodStartTime");
                if( (value == null) || (!value.equals(getPerformancePeriodStartTime())) ) {
                    setPerformancePeriodStartTime(((LocalTime) value));
                }
            }
            if( values.containsKey("PerformancePeriodEndTime") ) {
                final Object value = values.remove("PerformancePeriodEndTime");
                if( (value == null) || (!value.equals(getPerformancePeriodEndTime())) ) {
                    setPerformancePeriodEndTime(((LocalTime) value));
                }
            }
            if( values.containsKey("LeanServiceDuration") ) {
                final Object value = values.remove("LeanServiceDuration");
                if( (value == null) || (!value.equals(getLeanServiceDuration())) ) {
                    setLeanServiceDuration(((BigDecimal) value));
                }
            }
            if( values.containsKey("LeanServiceDurationUnit") ) {
                final Object value = values.remove("LeanServiceDurationUnit");
                if( (value == null) || (!value.equals(getLeanServiceDurationUnit())) ) {
                    setLeanServiceDurationUnit(((String) value));
                }
            }
            if( values.containsKey("DistributionFunction") ) {
                final Object value = values.remove("DistributionFunction");
                if( (value == null) || (!value.equals(getDistributionFunction())) ) {
                    setDistributionFunction(((String) value));
                }
            }
            if( values.containsKey("SrvcSchedgIsAlignedWthOpWrkCtr") ) {
                final Object value = values.remove("SrvcSchedgIsAlignedWthOpWrkCtr");
                if( (value == null) || (!value.equals(getSrvcSchedgIsAlignedWthOpWrkCtr())) ) {
                    setSrvcSchedgIsAlignedWthOpWrkCtr(((Boolean) value));
                }
            }
            if( values.containsKey("MaintOrderCompDebitCreditCode") ) {
                final Object value = values.remove("MaintOrderCompDebitCreditCode");
                if( (value == null) || (!value.equals(getMaintOrderCompDebitCreditCode())) ) {
                    setMaintOrderCompDebitCreditCode(((String) value));
                }
            }
            if( values.containsKey("GoodsMovementIsAllowed") ) {
                final Object value = values.remove("GoodsMovementIsAllowed");
                if( (value == null) || (!value.equals(getGoodsMovementIsAllowed())) ) {
                    setGoodsMovementIsAllowed(((Boolean) value));
                }
            }
            if( values.containsKey("MaintenanceOrderComponentBatch") ) {
                final Object value = values.remove("MaintenanceOrderComponentBatch");
                if( (value == null) || (!value.equals(getMaintenanceOrderComponentBatch())) ) {
                    setMaintenanceOrderComponentBatch(((String) value));
                }
            }
            if( values.containsKey("QuantityIsFixed") ) {
                final Object value = values.remove("QuantityIsFixed");
                if( (value == null) || (!value.equals(getQuantityIsFixed())) ) {
                    setQuantityIsFixed(((Boolean) value));
                }
            }
            if( values.containsKey("MaintOrdOpComponentGLAccount") ) {
                final Object value = values.remove("MaintOrdOpComponentGLAccount");
                if( (value == null) || (!value.equals(getMaintOrdOpComponentGLAccount())) ) {
                    setMaintOrdOpComponentGLAccount(((String) value));
                }
            }
            if( values.containsKey("MaintOrdOpCompCostingRelevancy") ) {
                final Object value = values.remove("MaintOrdOpCompCostingRelevancy");
                if( (value == null) || (!value.equals(getMaintOrdOpCompCostingRelevancy())) ) {
                    setMaintOrdOpCompCostingRelevancy(((String) value));
                }
            }
            if( values.containsKey("MaintCompAltvProdUsgeRateInPct") ) {
                final Object value = values.remove("MaintCompAltvProdUsgeRateInPct");
                if( (value == null) || (!value.equals(getMaintCompAltvProdUsgeRateInPct())) ) {
                    setMaintCompAltvProdUsgeRateInPct(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaintOrderOpComponentSortText") ) {
                final Object value = values.remove("MaintOrderOpComponentSortText");
                if( (value == null) || (!value.equals(getMaintOrderOpComponentSortText())) ) {
                    setMaintOrderOpComponentSortText(((String) value));
                }
            }
            if( values.containsKey("MaintOrdOpCompIsBulkProduct") ) {
                final Object value = values.remove("MaintOrdOpCompIsBulkProduct");
                if( (value == null) || (!value.equals(getMaintOrdOpCompIsBulkProduct())) ) {
                    setMaintOrdOpCompIsBulkProduct(((Boolean) value));
                }
            }
            if( values.containsKey("MaterialProvisionType") ) {
                final Object value = values.remove("MaterialProvisionType");
                if( (value == null) || (!value.equals(getMaterialProvisionType())) ) {
                    setMaterialProvisionType(((String) value));
                }
            }
            if( values.containsKey("MaintOrdOpCompAssgdWBSElmntInt") ) {
                final Object value = values.remove("MaintOrdOpCompAssgdWBSElmntInt");
                if( (value == null) || (!value.equals(getMaintOrdOpCompAssgdWBSElmntInt())) ) {
                    setMaintOrdOpCompAssgdWBSElmntInt(((String) value));
                }
            }
            if( values.containsKey("MaintOrderOpComponentPrice") ) {
                final Object value = values.remove("MaintOrderOpComponentPrice");
                if( (value == null) || (!value.equals(getMaintOrderOpComponentPrice())) ) {
                    setMaintOrderOpComponentPrice(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaintOrdOpComponentCurrency") ) {
                final Object value = values.remove("MaintOrdOpComponentCurrency");
                if( (value == null) || (!value.equals(getMaintOrdOpComponentCurrency())) ) {
                    setMaintOrdOpComponentCurrency(((String) value));
                }
            }
            if( values.containsKey("MatlCompIsMarkedForBackflush") ) {
                final Object value = values.remove("MatlCompIsMarkedForBackflush");
                if( (value == null) || (!value.equals(getMatlCompIsMarkedForBackflush())) ) {
                    setMatlCompIsMarkedForBackflush(((Boolean) value));
                }
            }
            if( values.containsKey("PurchasingGroup") ) {
                final Object value = values.remove("PurchasingGroup");
                if( (value == null) || (!value.equals(getPurchasingGroup())) ) {
                    setPurchasingGroup(((String) value));
                }
            }
            if( values.containsKey("DeliveryTimeInDays") ) {
                final Object value = values.remove("DeliveryTimeInDays");
                if( (value == null) || (!value.equals(getDeliveryTimeInDays())) ) {
                    setDeliveryTimeInDays(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaintOrdOpCompGdsRecipientName") ) {
                final Object value = values.remove("MaintOrdOpCompGdsRecipientName");
                if( (value == null) || (!value.equals(getMaintOrdOpCompGdsRecipientName())) ) {
                    setMaintOrdOpCompGdsRecipientName(((String) value));
                }
            }
            if( values.containsKey("MaintOrdOpCompUnloadingPtTxt") ) {
                final Object value = values.remove("MaintOrdOpCompUnloadingPtTxt");
                if( (value == null) || (!value.equals(getMaintOrdOpCompUnloadingPtTxt())) ) {
                    setMaintOrdOpCompUnloadingPtTxt(((String) value));
                }
            }
            if( values.containsKey("GoodsReceiptDurationInWorkDays") ) {
                final Object value = values.remove("GoodsReceiptDurationInWorkDays");
                if( (value == null) || (!value.equals(getGoodsReceiptDurationInWorkDays())) ) {
                    setGoodsReceiptDurationInWorkDays(((BigDecimal) value));
                }
            }
            if( values.containsKey("PurchasingInfoRecord") ) {
                final Object value = values.remove("PurchasingInfoRecord");
                if( (value == null) || (!value.equals(getPurchasingInfoRecord())) ) {
                    setPurchasingInfoRecord(((String) value));
                }
            }
            if( values.containsKey("OperationLeadTimeOffset") ) {
                final Object value = values.remove("OperationLeadTimeOffset");
                if( (value == null) || (!value.equals(getOperationLeadTimeOffset())) ) {
                    setOperationLeadTimeOffset(((BigDecimal) value));
                }
            }
            if( values.containsKey("OpsLeadTimeOffsetUnit") ) {
                final Object value = values.remove("OpsLeadTimeOffsetUnit");
                if( (value == null) || (!value.equals(getOpsLeadTimeOffsetUnit())) ) {
                    setOpsLeadTimeOffsetUnit(((String) value));
                }
            }
            if( values.containsKey("MaintOrdOpCompRequisitioner") ) {
                final Object value = values.remove("MaintOrdOpCompRequisitioner");
                if( (value == null) || (!value.equals(getMaintOrdOpCompRequisitioner())) ) {
                    setMaintOrdOpCompRequisitioner(((String) value));
                }
            }
            if( values.containsKey("MaintOrdOpCompProcmtTrckgNmbr") ) {
                final Object value = values.remove("MaintOrdOpCompProcmtTrckgNmbr");
                if( (value == null) || (!value.equals(getMaintOrdOpCompProcmtTrckgNmbr())) ) {
                    setMaintOrdOpCompProcmtTrckgNmbr(((String) value));
                }
            }
            if( values.containsKey("ResponsiblePurchaseOrg") ) {
                final Object value = values.remove("ResponsiblePurchaseOrg");
                if( (value == null) || (!value.equals(getResponsiblePurchaseOrg())) ) {
                    setResponsiblePurchaseOrg(((String) value));
                }
            }
            if( values.containsKey("MaintOrdOpCompSpecialStockType") ) {
                final Object value = values.remove("MaintOrdOpCompSpecialStockType");
                if( (value == null) || (!value.equals(getMaintOrdOpCompSpecialStockType())) ) {
                    setMaintOrdOpCompSpecialStockType(((String) value));
                }
            }
            if( values.containsKey("VariableSizeDimension1") ) {
                final Object value = values.remove("VariableSizeDimension1");
                if( (value == null) || (!value.equals(getVariableSizeDimension1())) ) {
                    setVariableSizeDimension1(((BigDecimal) value));
                }
            }
            if( values.containsKey("VariableSizeDimensionUnit") ) {
                final Object value = values.remove("VariableSizeDimensionUnit");
                if( (value == null) || (!value.equals(getVariableSizeDimensionUnit())) ) {
                    setVariableSizeDimensionUnit(((String) value));
                }
            }
            if( values.containsKey("VariableSizeCompFormulaKey") ) {
                final Object value = values.remove("VariableSizeCompFormulaKey");
                if( (value == null) || (!value.equals(getVariableSizeCompFormulaKey())) ) {
                    setVariableSizeCompFormulaKey(((String) value));
                }
            }
            if( values.containsKey("VariableSizeDimension2") ) {
                final Object value = values.remove("VariableSizeDimension2");
                if( (value == null) || (!value.equals(getVariableSizeDimension2())) ) {
                    setVariableSizeDimension2(((BigDecimal) value));
                }
            }
            if( values.containsKey("NumberOfVariableSizeItem") ) {
                final Object value = values.remove("NumberOfVariableSizeItem");
                if( (value == null) || (!value.equals(getNumberOfVariableSizeItem())) ) {
                    setNumberOfVariableSizeItem(((Integer) value));
                }
            }
            if( values.containsKey("VariableSizeDimension3") ) {
                final Object value = values.remove("VariableSizeDimension3");
                if( (value == null) || (!value.equals(getVariableSizeDimension3())) ) {
                    setVariableSizeDimension3(((BigDecimal) value));
                }
            }
            if( values.containsKey("VariableSizeItemQuantity") ) {
                final Object value = values.remove("VariableSizeItemQuantity");
                if( (value == null) || (!value.equals(getVariableSizeItemQuantity())) ) {
                    setVariableSizeItemQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("VariableSizeComponentUnit") ) {
                final Object value = values.remove("VariableSizeComponentUnit");
                if( (value == null) || (!value.equals(getVariableSizeComponentUnit())) ) {
                    setVariableSizeComponentUnit(((String) value));
                }
            }
            if( values.containsKey("RqmtDateIsEnteredManually") ) {
                final Object value = values.remove("RqmtDateIsEnteredManually");
                if( (value == null) || (!value.equals(getRqmtDateIsEnteredManually())) ) {
                    setRqmtDateIsEnteredManually(((Boolean) value));
                }
            }
            if( values.containsKey("SupplierProduct") ) {
                final Object value = values.remove("SupplierProduct");
                if( (value == null) || (!value.equals(getSupplierProduct())) ) {
                    setSupplierProduct(((String) value));
                }
            }
            if( values.containsKey("MaintOrdCompPurOutlineAgrmtItm") ) {
                final Object value = values.remove("MaintOrdCompPurOutlineAgrmtItm");
                if( (value == null) || (!value.equals(getMaintOrdCompPurOutlineAgrmtItm())) ) {
                    setMaintOrdCompPurOutlineAgrmtItm(((String) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("MaintOrderComponentInternalID") ) {
                final Object value = values.remove("MaintOrderComponentInternalID");
                if( (value == null) || (!value.equals(getMaintOrderComponentInternalID())) ) {
                    setMaintOrderComponentInternalID(((String) value));
                }
            }
            if( values.containsKey("PurchaseRequisition") ) {
                final Object value = values.remove("PurchaseRequisition");
                if( (value == null) || (!value.equals(getPurchaseRequisition())) ) {
                    setPurchaseRequisition(((String) value));
                }
            }
            if( values.containsKey("PurchaseRequisitionItem") ) {
                final Object value = values.remove("PurchaseRequisitionItem");
                if( (value == null) || (!value.equals(getPurchaseRequisitionItem())) ) {
                    setPurchaseRequisitionItem(((String) value));
                }
            }
            if( values.containsKey("OverallLimitAmount") ) {
                final Object value = values.remove("OverallLimitAmount");
                if( (value == null) || (!value.equals(getOverallLimitAmount())) ) {
                    setOverallLimitAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("ExpectedOverallLimitAmount") ) {
                final Object value = values.remove("ExpectedOverallLimitAmount");
                if( (value == null) || (!value.equals(getExpectedOverallLimitAmount())) ) {
                    setExpectedOverallLimitAmount(((BigDecimal) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_MaintenanceOrderOperation") ) {
                final Object value = (values).remove("to_MaintenanceOrderOperation");
                if( value instanceof Map ) {
                    if( toMaintenanceOrderOperation == null ) {
                        toMaintenanceOrderOperation = new MaintenanceOrderOperation();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toMaintenanceOrderOperation.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_MaintenanceOrder") ) {
                final Object value = (values).remove("to_MaintenanceOrder");
                if( value instanceof Map ) {
                    if( toMaintenanceOrder == null ) {
                        toMaintenanceOrder = new MaintenanceOrder();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toMaintenanceOrder.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_MaintOrderOpCompLongText") ) {
                final Object value = (values).remove("to_MaintOrderOpCompLongText");
                if( value instanceof Iterable ) {
                    if( toMaintOrderOpCompLongText == null ) {
                        toMaintOrderOpCompLongText = Lists.newArrayList();
                    } else {
                        toMaintOrderOpCompLongText = Lists.newArrayList(toMaintOrderOpCompLongText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MaintOrderOpCompLongText entity;
                        if( toMaintOrderOpCompLongText.size() > i ) {
                            entity = toMaintOrderOpCompLongText.get(i);
                        } else {
                            entity = new MaintOrderOpCompLongText();
                            toMaintOrderOpCompLongText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> MaintOrderOpComponentField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new MaintOrderOpComponentField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MaintOrderOpComponentField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MaintOrderOpComponentField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceOrderService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toMaintenanceOrderOperation != null ) {
            (values).put("to_MaintenanceOrderOperation", toMaintenanceOrderOperation);
        }
        if( toMaintenanceOrder != null ) {
            (values).put("to_MaintenanceOrder", toMaintenanceOrder);
        }
        if( toMaintOrderOpCompLongText != null ) {
            (values).put("to_MaintOrderOpCompLongText", toMaintOrderOpCompLongText);
        }
        return values;
    }

    /**
     * Fetches the <b>MaintenanceOrderOperation</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_MaintenanceOrderOperation</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>MaintenanceOrderOperation</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceOrderOperation fetchMaintenanceOrderOperation()
    {
        return fetchFieldAsSingle("to_MaintenanceOrderOperation", MaintenanceOrderOperation.class);
    }

    /**
     * Retrieval of associated <b>MaintenanceOrderOperation</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_MaintenanceOrderOperation</b>.
     * <p>
     * If the navigation property <b>to_MaintenanceOrderOperation</b> of a queried <b>MaintOrderOpComponent</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintenanceOrderOperation</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceOrderOperation getMaintenanceOrderOperationOrFetch()
    {
        if( toMaintenanceOrderOperation == null ) {
            toMaintenanceOrderOperation = fetchMaintenanceOrderOperation();
        }
        return toMaintenanceOrderOperation;
    }

    /**
     * Retrieval of associated <b>MaintenanceOrderOperation</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_MaintenanceOrderOperation</b>.
     * <p>
     * If the navigation property for an entity <b>MaintOrderOpComponent</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaintenanceOrderOperation</b> is already loaded, the
     *         result will contain the <b>MaintenanceOrderOperation</b> entity. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<MaintenanceOrderOperation> getMaintenanceOrderOperationIfPresent()
    {
        return Option.of(toMaintenanceOrderOperation);
    }

    /**
     * Overwrites the associated <b>MaintenanceOrderOperation</b> entity for the loaded navigation property
     * <b>to_MaintenanceOrderOperation</b>.
     *
     * @param value
     *            New <b>MaintenanceOrderOperation</b> entity.
     */
    public void setMaintenanceOrderOperation( final MaintenanceOrderOperation value )
    {
        toMaintenanceOrderOperation = value;
    }

    /**
     * Fetches the <b>MaintenanceOrder</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_MaintenanceOrder</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>MaintenanceOrder</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceOrder fetchMaintenanceOrder()
    {
        return fetchFieldAsSingle("to_MaintenanceOrder", MaintenanceOrder.class);
    }

    /**
     * Retrieval of associated <b>MaintenanceOrder</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_MaintenanceOrder</b>.
     * <p>
     * If the navigation property <b>to_MaintenanceOrder</b> of a queried <b>MaintOrderOpComponent</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintenanceOrder</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceOrder getMaintenanceOrderOrFetch()
    {
        if( toMaintenanceOrder == null ) {
            toMaintenanceOrder = fetchMaintenanceOrder();
        }
        return toMaintenanceOrder;
    }

    /**
     * Retrieval of associated <b>MaintenanceOrder</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_MaintenanceOrder</b>.
     * <p>
     * If the navigation property for an entity <b>MaintOrderOpComponent</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaintenanceOrder</b> is already loaded, the result will
     *         contain the <b>MaintenanceOrder</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<MaintenanceOrder> getMaintenanceOrderIfPresent()
    {
        return Option.of(toMaintenanceOrder);
    }

    /**
     * Overwrites the associated <b>MaintenanceOrder</b> entity for the loaded navigation property
     * <b>to_MaintenanceOrder</b>.
     *
     * @param value
     *            New <b>MaintenanceOrder</b> entity.
     */
    public void setMaintenanceOrder( final MaintenanceOrder value )
    {
        toMaintenanceOrder = value;
    }

    /**
     * Fetches the <b>MaintOrderOpCompLongText</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_MaintOrderOpCompLongText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>MaintOrderOpCompLongText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintOrderOpCompLongText> fetchMaintOrderOpCompLongText()
    {
        return fetchFieldAsList("to_MaintOrderOpCompLongText", MaintOrderOpCompLongText.class);
    }

    /**
     * Retrieval of associated <b>MaintOrderOpCompLongText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_MaintOrderOpCompLongText</b>.
     * <p>
     * If the navigation property <b>to_MaintOrderOpCompLongText</b> of a queried <b>MaintOrderOpComponent</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintOrderOpCompLongText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintOrderOpCompLongText> getMaintOrderOpCompLongTextOrFetch()
    {
        if( toMaintOrderOpCompLongText == null ) {
            toMaintOrderOpCompLongText = fetchMaintOrderOpCompLongText();
        }
        return toMaintOrderOpCompLongText;
    }

    /**
     * Retrieval of associated <b>MaintOrderOpCompLongText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_MaintOrderOpCompLongText</b>.
     * <p>
     * If the navigation property for an entity <b>MaintOrderOpComponent</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaintOrderOpCompLongText</b> is already loaded, the
     *         result will contain the <b>MaintOrderOpCompLongText</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<MaintOrderOpCompLongText>> getMaintOrderOpCompLongTextIfPresent()
    {
        return Option.of(toMaintOrderOpCompLongText);
    }

    /**
     * Overwrites the list of associated <b>MaintOrderOpCompLongText</b> entities for the loaded navigation property
     * <b>to_MaintOrderOpCompLongText</b>.
     * <p>
     * If the navigation property <b>to_MaintOrderOpCompLongText</b> of a queried <b>MaintOrderOpComponent</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>MaintOrderOpCompLongText</b> entities.
     */
    public void setMaintOrderOpCompLongText( @Nonnull final List<MaintOrderOpCompLongText> value )
    {
        if( toMaintOrderOpCompLongText == null ) {
            toMaintOrderOpCompLongText = Lists.newArrayList();
        }
        toMaintOrderOpCompLongText.clear();
        toMaintOrderOpCompLongText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MaintOrderOpCompLongText</b> entities. This corresponds to the OData
     * navigation property <b>to_MaintOrderOpCompLongText</b>.
     * <p>
     * If the navigation property <b>to_MaintOrderOpCompLongText</b> of a queried <b>MaintOrderOpComponent</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>MaintOrderOpCompLongText</b> entities.
     */
    public void addMaintOrderOpCompLongText( MaintOrderOpCompLongText... entity )
    {
        if( toMaintOrderOpCompLongText == null ) {
            toMaintOrderOpCompLongText = Lists.newArrayList();
        }
        toMaintOrderOpCompLongText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of MaintOrderOpComponent instances.
     *
     */
    public final static class MaintOrderOpComponentBuilder
    {

        private MaintenanceOrderOperation toMaintenanceOrderOperation;
        private String maintenanceOrderOperation = null;
        private MaintenanceOrder toMaintenanceOrder;
        private String maintenanceOrder = null;
        private List<MaintOrderOpCompLongText> toMaintOrderOpCompLongText = Lists.newArrayList();

        private MaintOrderOpComponent.MaintOrderOpComponentBuilder toMaintenanceOrderOperation(
            final MaintenanceOrderOperation value )
        {
            toMaintenanceOrderOperation = value;
            return this;
        }

        /**
         * Navigation property <b>to_MaintenanceOrderOperation</b> for <b>MaintOrderOpComponent</b> to single
         * <b>MaintenanceOrderOperation</b>.
         *
         * @param value
         *            The MaintenanceOrderOperation to build this MaintOrderOpComponent with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintOrderOpComponent.MaintOrderOpComponentBuilder maintenanceOrderOperation(
            final MaintenanceOrderOperation value )
        {
            return toMaintenanceOrderOperation(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 4
         * <p>
         * Original property name from the Odata EDM: <b>MaintenanceOrderOperation</b>
         * </p>
         *
         * @param value
         *            The maintenanceOrderOperation to build this MaintOrderOpComponent with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintOrderOpComponent.MaintOrderOpComponentBuilder maintenanceOrderOperation( final String value )
        {
            maintenanceOrderOperation = value;
            return this;
        }

        private MaintOrderOpComponent.MaintOrderOpComponentBuilder toMaintenanceOrder( final MaintenanceOrder value )
        {
            toMaintenanceOrder = value;
            return this;
        }

        /**
         * Navigation property <b>to_MaintenanceOrder</b> for <b>MaintOrderOpComponent</b> to single
         * <b>MaintenanceOrder</b>.
         *
         * @param value
         *            The MaintenanceOrder to build this MaintOrderOpComponent with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintOrderOpComponent.MaintOrderOpComponentBuilder maintenanceOrder( final MaintenanceOrder value )
        {
            return toMaintenanceOrder(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 12
         * <p>
         * Original property name from the Odata EDM: <b>MaintenanceOrder</b>
         * </p>
         *
         * @param value
         *            The maintenanceOrder to build this MaintOrderOpComponent with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintOrderOpComponent.MaintOrderOpComponentBuilder maintenanceOrder( final String value )
        {
            maintenanceOrder = value;
            return this;
        }

        private MaintOrderOpComponent.MaintOrderOpComponentBuilder toMaintOrderOpCompLongText(
            final List<MaintOrderOpCompLongText> value )
        {
            toMaintOrderOpCompLongText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_MaintOrderOpCompLongText</b> for <b>MaintOrderOpComponent</b> to multiple
         * <b>MaintOrderOpCompLongText</b>.
         *
         * @param value
         *            The MaintOrderOpCompLongTexts to build this MaintOrderOpComponent with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintOrderOpComponent.MaintOrderOpComponentBuilder maintOrderOpCompLongText(
            MaintOrderOpCompLongText... value )
        {
            return toMaintOrderOpCompLongText(Lists.newArrayList(value));
        }

    }

}
