/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.selectable.MaintOrderOpComponentSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpComponent
 * MaintOrderOpComponent} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class MaintOrderOpComponentByKeyFluentHelper
    extends
    FluentHelperByKey<MaintOrderOpComponentByKeyFluentHelper, MaintOrderOpComponent, MaintOrderOpComponentSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpComponent
     * MaintOrderOpComponent} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param maintenanceOrder
     *            Order Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code MaintOrderOpComponent}
     * @param maintenanceOrderOperation
     *            Maintenance Order Operation
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param maintenanceOrderSubOperation
     *            Maintenance Order Suboperation
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param maintenanceOrderComponent
     *            BOM item number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code MaintOrderOpComponent}
     */
    public MaintOrderOpComponentByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String maintenanceOrder,
        final String maintenanceOrderOperation,
        final String maintenanceOrderSubOperation,
        final String maintenanceOrderComponent )
    {
        super(servicePath, entityCollection);
        this.key.put("MaintenanceOrder", maintenanceOrder);
        this.key.put("MaintenanceOrderOperation", maintenanceOrderOperation);
        this.key.put("MaintenanceOrderSubOperation", maintenanceOrderSubOperation);
        this.key.put("MaintenanceOrderComponent", maintenanceOrderComponent);
    }

    @Override
    @Nonnull
    protected Class<MaintOrderOpComponent> getEntityClass()
    {
        return MaintOrderOpComponent.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
