/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.field.MaintOrderOpLongTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.link.MaintOrderOpLongTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.selectable.MaintOrderOpLongTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Maintenance Order Operation Long Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MaintOrderOpLongText_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MaintOrderOpLongText extends VdmEntity<MaintOrderOpLongText>
{

    /**
     * Selector for all available fields of MaintOrderOpLongText.
     *
     */
    public final static MaintOrderOpLongTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrder</b>
     * </p>
     *
     * @return Order Number
     */
    @Key
    @SerializedName( "MaintenanceOrder" )
    @JsonProperty( "MaintenanceOrder" )
    @Nullable
    @ODataField( odataName = "MaintenanceOrder" )
    private String maintenanceOrder;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceOrder</b> field to query operations.
     *
     */
    public final static MaintOrderOpLongTextField<String> MAINTENANCE_ORDER =
        new MaintOrderOpLongTextField<String>("MaintenanceOrder");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderOperation</b>
     * </p>
     *
     * @return Maintenance Order Operation
     */
    @Key
    @SerializedName( "MaintenanceOrderOperation" )
    @JsonProperty( "MaintenanceOrderOperation" )
    @Nullable
    @ODataField( odataName = "MaintenanceOrderOperation" )
    private String maintenanceOrderOperation;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceOrderOperation</b> field to query operations.
     *
     */
    public final static MaintOrderOpLongTextField<String> MAINTENANCE_ORDER_OPERATION =
        new MaintOrderOpLongTextField<String>("MaintenanceOrderOperation");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderSubOperation</b>
     * </p>
     *
     * @return Maintenance Order Suboperation
     */
    @Key
    @SerializedName( "MaintenanceOrderSubOperation" )
    @JsonProperty( "MaintenanceOrderSubOperation" )
    @Nullable
    @ODataField( odataName = "MaintenanceOrderSubOperation" )
    private String maintenanceOrderSubOperation;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceOrderSubOperation</b> field to query operations.
     *
     */
    public final static MaintOrderOpLongTextField<String> MAINTENANCE_ORDER_SUB_OPERATION =
        new MaintOrderOpLongTextField<String>("MaintenanceOrderSubOperation");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>TextObjectType</b>
     * </p>
     *
     * @return Text ID
     */
    @Key
    @SerializedName( "TextObjectType" )
    @JsonProperty( "TextObjectType" )
    @Nullable
    @ODataField( odataName = "TextObjectType" )
    private String textObjectType;
    /**
     * Use with available fluent helpers to apply the <b>TextObjectType</b> field to query operations.
     *
     */
    public final static MaintOrderOpLongTextField<String> TEXT_OBJECT_TYPE =
        new MaintOrderOpLongTextField<String>("TextObjectType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static MaintOrderOpLongTextField<String> LANGUAGE = new MaintOrderOpLongTextField<String>("Language");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>OrderOperationLongText</b>
     * </p>
     *
     * @return Long Text
     */
    @SerializedName( "OrderOperationLongText" )
    @JsonProperty( "OrderOperationLongText" )
    @Nullable
    @ODataField( odataName = "OrderOperationLongText" )
    private String orderOperationLongText;
    /**
     * Use with available fluent helpers to apply the <b>OrderOperationLongText</b> field to query operations.
     *
     */
    public final static MaintOrderOpLongTextField<String> ORDER_OPERATION_LONG_TEXT =
        new MaintOrderOpLongTextField<String>("OrderOperationLongText");
    /**
     * Navigation property <b>to_MaintenanceOrderOperation</b> for <b>MaintOrderOpLongText</b> to single
     * <b>MaintenanceOrderOperation</b>.
     *
     */
    @SerializedName( "to_MaintenanceOrderOperation" )
    @JsonProperty( "to_MaintenanceOrderOperation" )
    @ODataField( odataName = "to_MaintenanceOrderOperation" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private MaintenanceOrderOperation toMaintenanceOrderOperation;
    /**
     * Navigation property <b>to_MaintenanceOrder</b> for <b>MaintOrderOpLongText</b> to single <b>MaintenanceOrder</b>.
     *
     */
    @SerializedName( "to_MaintenanceOrder" )
    @JsonProperty( "to_MaintenanceOrder" )
    @ODataField( odataName = "to_MaintenanceOrder" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private MaintenanceOrder toMaintenanceOrder;
    /**
     * Use with available fluent helpers to apply the <b>to_MaintenanceOrderOperation</b> navigation property to query
     * operations.
     *
     */
    public final static MaintOrderOpLongTextOneToOneLink<MaintenanceOrderOperation> TO_MAINTENANCE_ORDER_OPERATION =
        new MaintOrderOpLongTextOneToOneLink<MaintenanceOrderOperation>("to_MaintenanceOrderOperation");
    /**
     * Use with available fluent helpers to apply the <b>to_MaintenanceOrder</b> navigation property to query
     * operations.
     *
     */
    public final static MaintOrderOpLongTextOneToOneLink<MaintenanceOrder> TO_MAINTENANCE_ORDER =
        new MaintOrderOpLongTextOneToOneLink<MaintenanceOrder>("to_MaintenanceOrder");

    @Nonnull
    @Override
    public Class<MaintOrderOpLongText> getType()
    {
        return MaintOrderOpLongText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrder</b>
     * </p>
     *
     * @param maintenanceOrder
     *            Order Number
     */
    public void setMaintenanceOrder( @Nullable final String maintenanceOrder )
    {
        rememberChangedField("MaintenanceOrder", this.maintenanceOrder);
        this.maintenanceOrder = maintenanceOrder;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderOperation</b>
     * </p>
     *
     * @param maintenanceOrderOperation
     *            Maintenance Order Operation
     */
    public void setMaintenanceOrderOperation( @Nullable final String maintenanceOrderOperation )
    {
        rememberChangedField("MaintenanceOrderOperation", this.maintenanceOrderOperation);
        this.maintenanceOrderOperation = maintenanceOrderOperation;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderSubOperation</b>
     * </p>
     *
     * @param maintenanceOrderSubOperation
     *            Maintenance Order Suboperation
     */
    public void setMaintenanceOrderSubOperation( @Nullable final String maintenanceOrderSubOperation )
    {
        rememberChangedField("MaintenanceOrderSubOperation", this.maintenanceOrderSubOperation);
        this.maintenanceOrderSubOperation = maintenanceOrderSubOperation;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>TextObjectType</b>
     * </p>
     *
     * @param textObjectType
     *            Text ID
     */
    public void setTextObjectType( @Nullable final String textObjectType )
    {
        rememberChangedField("TextObjectType", this.textObjectType);
        this.textObjectType = textObjectType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>OrderOperationLongText</b>
     * </p>
     *
     * @param orderOperationLongText
     *            Long Text
     */
    public void setOrderOperationLongText( @Nullable final String orderOperationLongText )
    {
        rememberChangedField("OrderOperationLongText", this.orderOperationLongText);
        this.orderOperationLongText = orderOperationLongText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "MaintOrderOpLongText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("MaintenanceOrder", getMaintenanceOrder());
        result.put("MaintenanceOrderOperation", getMaintenanceOrderOperation());
        result.put("MaintenanceOrderSubOperation", getMaintenanceOrderSubOperation());
        result.put("TextObjectType", getTextObjectType());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("MaintenanceOrder", getMaintenanceOrder());
        values.put("MaintenanceOrderOperation", getMaintenanceOrderOperation());
        values.put("MaintenanceOrderSubOperation", getMaintenanceOrderSubOperation());
        values.put("TextObjectType", getTextObjectType());
        values.put("Language", getLanguage());
        values.put("OrderOperationLongText", getOrderOperationLongText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("MaintenanceOrder") ) {
                final Object value = values.remove("MaintenanceOrder");
                if( (value == null) || (!value.equals(getMaintenanceOrder())) ) {
                    setMaintenanceOrder(((String) value));
                }
            }
            if( values.containsKey("MaintenanceOrderOperation") ) {
                final Object value = values.remove("MaintenanceOrderOperation");
                if( (value == null) || (!value.equals(getMaintenanceOrderOperation())) ) {
                    setMaintenanceOrderOperation(((String) value));
                }
            }
            if( values.containsKey("MaintenanceOrderSubOperation") ) {
                final Object value = values.remove("MaintenanceOrderSubOperation");
                if( (value == null) || (!value.equals(getMaintenanceOrderSubOperation())) ) {
                    setMaintenanceOrderSubOperation(((String) value));
                }
            }
            if( values.containsKey("TextObjectType") ) {
                final Object value = values.remove("TextObjectType");
                if( (value == null) || (!value.equals(getTextObjectType())) ) {
                    setTextObjectType(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("OrderOperationLongText") ) {
                final Object value = values.remove("OrderOperationLongText");
                if( (value == null) || (!value.equals(getOrderOperationLongText())) ) {
                    setOrderOperationLongText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_MaintenanceOrderOperation") ) {
                final Object value = (values).remove("to_MaintenanceOrderOperation");
                if( value instanceof Map ) {
                    if( toMaintenanceOrderOperation == null ) {
                        toMaintenanceOrderOperation = new MaintenanceOrderOperation();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toMaintenanceOrderOperation.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_MaintenanceOrder") ) {
                final Object value = (values).remove("to_MaintenanceOrder");
                if( value instanceof Map ) {
                    if( toMaintenanceOrder == null ) {
                        toMaintenanceOrder = new MaintenanceOrder();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toMaintenanceOrder.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> MaintOrderOpLongTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new MaintOrderOpLongTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MaintOrderOpLongTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MaintOrderOpLongTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceOrderService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toMaintenanceOrderOperation != null ) {
            (values).put("to_MaintenanceOrderOperation", toMaintenanceOrderOperation);
        }
        if( toMaintenanceOrder != null ) {
            (values).put("to_MaintenanceOrder", toMaintenanceOrder);
        }
        return values;
    }

    /**
     * Fetches the <b>MaintenanceOrderOperation</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_MaintenanceOrderOperation</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>MaintenanceOrderOperation</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceOrderOperation fetchMaintenanceOrderOperation()
    {
        return fetchFieldAsSingle("to_MaintenanceOrderOperation", MaintenanceOrderOperation.class);
    }

    /**
     * Retrieval of associated <b>MaintenanceOrderOperation</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_MaintenanceOrderOperation</b>.
     * <p>
     * If the navigation property <b>to_MaintenanceOrderOperation</b> of a queried <b>MaintOrderOpLongText</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintenanceOrderOperation</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceOrderOperation getMaintenanceOrderOperationOrFetch()
    {
        if( toMaintenanceOrderOperation == null ) {
            toMaintenanceOrderOperation = fetchMaintenanceOrderOperation();
        }
        return toMaintenanceOrderOperation;
    }

    /**
     * Retrieval of associated <b>MaintenanceOrderOperation</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_MaintenanceOrderOperation</b>.
     * <p>
     * If the navigation property for an entity <b>MaintOrderOpLongText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaintenanceOrderOperation</b> is already loaded, the
     *         result will contain the <b>MaintenanceOrderOperation</b> entity. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<MaintenanceOrderOperation> getMaintenanceOrderOperationIfPresent()
    {
        return Option.of(toMaintenanceOrderOperation);
    }

    /**
     * Overwrites the associated <b>MaintenanceOrderOperation</b> entity for the loaded navigation property
     * <b>to_MaintenanceOrderOperation</b>.
     *
     * @param value
     *            New <b>MaintenanceOrderOperation</b> entity.
     */
    public void setMaintenanceOrderOperation( final MaintenanceOrderOperation value )
    {
        toMaintenanceOrderOperation = value;
    }

    /**
     * Fetches the <b>MaintenanceOrder</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_MaintenanceOrder</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>MaintenanceOrder</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceOrder fetchMaintenanceOrder()
    {
        return fetchFieldAsSingle("to_MaintenanceOrder", MaintenanceOrder.class);
    }

    /**
     * Retrieval of associated <b>MaintenanceOrder</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_MaintenanceOrder</b>.
     * <p>
     * If the navigation property <b>to_MaintenanceOrder</b> of a queried <b>MaintOrderOpLongText</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintenanceOrder</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceOrder getMaintenanceOrderOrFetch()
    {
        if( toMaintenanceOrder == null ) {
            toMaintenanceOrder = fetchMaintenanceOrder();
        }
        return toMaintenanceOrder;
    }

    /**
     * Retrieval of associated <b>MaintenanceOrder</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_MaintenanceOrder</b>.
     * <p>
     * If the navigation property for an entity <b>MaintOrderOpLongText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaintenanceOrder</b> is already loaded, the result will
     *         contain the <b>MaintenanceOrder</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<MaintenanceOrder> getMaintenanceOrderIfPresent()
    {
        return Option.of(toMaintenanceOrder);
    }

    /**
     * Overwrites the associated <b>MaintenanceOrder</b> entity for the loaded navigation property
     * <b>to_MaintenanceOrder</b>.
     *
     * @param value
     *            New <b>MaintenanceOrder</b> entity.
     */
    public void setMaintenanceOrder( final MaintenanceOrder value )
    {
        toMaintenanceOrder = value;
    }

    /**
     * Helper class to allow for fluent creation of MaintOrderOpLongText instances.
     *
     */
    public final static class MaintOrderOpLongTextBuilder
    {

        private MaintenanceOrderOperation toMaintenanceOrderOperation;
        private String maintenanceOrderOperation = null;
        private MaintenanceOrder toMaintenanceOrder;
        private String maintenanceOrder = null;

        private MaintOrderOpLongText.MaintOrderOpLongTextBuilder toMaintenanceOrderOperation(
            final MaintenanceOrderOperation value )
        {
            toMaintenanceOrderOperation = value;
            return this;
        }

        /**
         * Navigation property <b>to_MaintenanceOrderOperation</b> for <b>MaintOrderOpLongText</b> to single
         * <b>MaintenanceOrderOperation</b>.
         *
         * @param value
         *            The MaintenanceOrderOperation to build this MaintOrderOpLongText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintOrderOpLongText.MaintOrderOpLongTextBuilder maintenanceOrderOperation(
            final MaintenanceOrderOperation value )
        {
            return toMaintenanceOrderOperation(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 4
         * <p>
         * Original property name from the Odata EDM: <b>MaintenanceOrderOperation</b>
         * </p>
         *
         * @param value
         *            The maintenanceOrderOperation to build this MaintOrderOpLongText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintOrderOpLongText.MaintOrderOpLongTextBuilder maintenanceOrderOperation( final String value )
        {
            maintenanceOrderOperation = value;
            return this;
        }

        private MaintOrderOpLongText.MaintOrderOpLongTextBuilder toMaintenanceOrder( final MaintenanceOrder value )
        {
            toMaintenanceOrder = value;
            return this;
        }

        /**
         * Navigation property <b>to_MaintenanceOrder</b> for <b>MaintOrderOpLongText</b> to single
         * <b>MaintenanceOrder</b>.
         *
         * @param value
         *            The MaintenanceOrder to build this MaintOrderOpLongText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintOrderOpLongText.MaintOrderOpLongTextBuilder maintenanceOrder( final MaintenanceOrder value )
        {
            return toMaintenanceOrder(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 12
         * <p>
         * Original property name from the Odata EDM: <b>MaintenanceOrder</b>
         * </p>
         *
         * @param value
         *            The maintenanceOrder to build this MaintOrderOpLongText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintOrderOpLongText.MaintOrderOpLongTextBuilder maintenanceOrder( final String value )
        {
            maintenanceOrder = value;
            return this;
        }

    }

}
