/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.field.MaintOrderOpProdnRsceToolField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.link.MaintOrderOpProdnRsceToolOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.selectable.MaintOrderOpProdnRsceToolSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Maintenance Order Operation PRT
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MaintOrderOpProdnRsceTool_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MaintOrderOpProdnRsceTool extends VdmEntity<MaintOrderOpProdnRsceTool>
{

    /**
     * Selector for all available fields of MaintOrderOpProdnRsceTool.
     *
     */
    public final static MaintOrderOpProdnRsceToolSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrder</b>
     * </p>
     *
     * @return Order Number
     */
    @Key
    @SerializedName( "MaintenanceOrder" )
    @JsonProperty( "MaintenanceOrder" )
    @Nullable
    @ODataField( odataName = "MaintenanceOrder" )
    private String maintenanceOrder;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceOrder</b> field to query operations.
     *
     */
    public final static MaintOrderOpProdnRsceToolField<String> MAINTENANCE_ORDER =
        new MaintOrderOpProdnRsceToolField<String>("MaintenanceOrder");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderOperation</b>
     * </p>
     *
     * @return Maintenance Order Operation
     */
    @Key
    @SerializedName( "MaintenanceOrderOperation" )
    @JsonProperty( "MaintenanceOrderOperation" )
    @Nullable
    @ODataField( odataName = "MaintenanceOrderOperation" )
    private String maintenanceOrderOperation;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceOrderOperation</b> field to query operations.
     *
     */
    public final static MaintOrderOpProdnRsceToolField<String> MAINTENANCE_ORDER_OPERATION =
        new MaintOrderOpProdnRsceToolField<String>("MaintenanceOrderOperation");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderSubOperation</b>
     * </p>
     *
     * @return Maintenance Order Suboperation
     */
    @Key
    @SerializedName( "MaintenanceOrderSubOperation" )
    @JsonProperty( "MaintenanceOrderSubOperation" )
    @Nullable
    @ODataField( odataName = "MaintenanceOrderSubOperation" )
    private String maintenanceOrderSubOperation;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceOrderSubOperation</b> field to query operations.
     *
     */
    public final static MaintOrderOpProdnRsceToolField<String> MAINTENANCE_ORDER_SUB_OPERATION =
        new MaintOrderOpProdnRsceToolField<String>("MaintenanceOrderSubOperation");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolItemNumber</b>
     * </p>
     *
     * @return Item Number for Production Resource/Tool
     */
    @Key
    @SerializedName( "ProdnRsceToolItemNumber" )
    @JsonProperty( "ProdnRsceToolItemNumber" )
    @Nullable
    @ODataField( odataName = "ProdnRsceToolItemNumber" )
    private String prodnRsceToolItemNumber;
    /**
     * Use with available fluent helpers to apply the <b>ProdnRsceToolItemNumber</b> field to query operations.
     *
     */
    public final static MaintOrderOpProdnRsceToolField<String> PRODN_RSCE_TOOL_ITEM_NUMBER =
        new MaintOrderOpProdnRsceToolField<String>("ProdnRsceToolItemNumber");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>OrderProdnRsceToolText</b>
     * </p>
     *
     * @return First Line of Text for Production Resources/Tools
     */
    @SerializedName( "OrderProdnRsceToolText" )
    @JsonProperty( "OrderProdnRsceToolText" )
    @Nullable
    @ODataField( odataName = "OrderProdnRsceToolText" )
    private String orderProdnRsceToolText;
    /**
     * Use with available fluent helpers to apply the <b>OrderProdnRsceToolText</b> field to query operations.
     *
     */
    public final static MaintOrderOpProdnRsceToolField<String> ORDER_PRODN_RSCE_TOOL_TEXT =
        new MaintOrderOpProdnRsceToolField<String>("OrderProdnRsceToolText");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolCategory</b>
     * </p>
     *
     * @return Production Resources/Tools Category
     */
    @SerializedName( "ProdnRsceToolCategory" )
    @JsonProperty( "ProdnRsceToolCategory" )
    @Nullable
    @ODataField( odataName = "ProdnRsceToolCategory" )
    private String prodnRsceToolCategory;
    /**
     * Use with available fluent helpers to apply the <b>ProdnRsceToolCategory</b> field to query operations.
     *
     */
    public final static MaintOrderOpProdnRsceToolField<String> PRODN_RSCE_TOOL_CATEGORY =
        new MaintOrderOpProdnRsceToolField<String>("ProdnRsceToolCategory");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolCategoryName</b>
     * </p>
     *
     * @return Language-dependent description of the PRT category
     */
    @SerializedName( "ProdnRsceToolCategoryName" )
    @JsonProperty( "ProdnRsceToolCategoryName" )
    @Nullable
    @ODataField( odataName = "ProdnRsceToolCategoryName" )
    private String prodnRsceToolCategoryName;
    /**
     * Use with available fluent helpers to apply the <b>ProdnRsceToolCategoryName</b> field to query operations.
     *
     */
    public final static MaintOrderOpProdnRsceToolField<String> PRODN_RSCE_TOOL_CATEGORY_NAME =
        new MaintOrderOpProdnRsceToolField<String>("ProdnRsceToolCategoryName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProductionResourceTool</b>
     * </p>
     *
     * @return Production Resource/Tool Number
     */
    @SerializedName( "ProductionResourceTool" )
    @JsonProperty( "ProductionResourceTool" )
    @Nullable
    @ODataField( odataName = "ProductionResourceTool" )
    private String productionResourceTool;
    /**
     * Use with available fluent helpers to apply the <b>ProductionResourceTool</b> field to query operations.
     *
     */
    public final static MaintOrderOpProdnRsceToolField<String> PRODUCTION_RESOURCE_TOOL =
        new MaintOrderOpProdnRsceToolField<String>("ProductionResourceTool");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static MaintOrderOpProdnRsceToolField<String> PRODUCT =
        new MaintOrderOpProdnRsceToolField<String>("Product");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>MiscProductionResourceTool</b>
     * </p>
     *
     * @return Miscellaneous Production Resources and Tools
     */
    @SerializedName( "MiscProductionResourceTool" )
    @JsonProperty( "MiscProductionResourceTool" )
    @Nullable
    @ODataField( odataName = "MiscProductionResourceTool" )
    private String miscProductionResourceTool;
    /**
     * Use with available fluent helpers to apply the <b>MiscProductionResourceTool</b> field to query operations.
     *
     */
    public final static MaintOrderOpProdnRsceToolField<String> MISC_PRODUCTION_RESOURCE_TOOL =
        new MaintOrderOpProdnRsceToolField<String>("MiscProductionResourceTool");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProductionResourceToolDesc</b>
     * </p>
     *
     * @return Description of the Production Resource/Tool
     */
    @SerializedName( "ProductionResourceToolDesc" )
    @JsonProperty( "ProductionResourceToolDesc" )
    @Nullable
    @ODataField( odataName = "ProductionResourceToolDesc" )
    private String productionResourceToolDesc;
    /**
     * Use with available fluent helpers to apply the <b>ProductionResourceToolDesc</b> field to query operations.
     *
     */
    public final static MaintOrderOpProdnRsceToolField<String> PRODUCTION_RESOURCE_TOOL_DESC =
        new MaintOrderOpProdnRsceToolField<String>("ProductionResourceToolDesc");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolControlProfile</b>
     * </p>
     *
     * @return Control Profile for Management of Production Resources/Tools
     */
    @SerializedName( "ProdnRsceToolControlProfile" )
    @JsonProperty( "ProdnRsceToolControlProfile" )
    @Nullable
    @ODataField( odataName = "ProdnRsceToolControlProfile" )
    private String prodnRsceToolControlProfile;
    /**
     * Use with available fluent helpers to apply the <b>ProdnRsceToolControlProfile</b> field to query operations.
     *
     */
    public final static MaintOrderOpProdnRsceToolField<String> PRODN_RSCE_TOOL_CONTROL_PROFILE =
        new MaintOrderOpProdnRsceToolField<String>("ProdnRsceToolControlProfile");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolStandardWorkQty</b>
     * </p>
     *
     * @return Standard Value for Quantity of Production Resources/Tools
     */
    @SerializedName( "ProdnRsceToolStandardWorkQty" )
    @JsonProperty( "ProdnRsceToolStandardWorkQty" )
    @Nullable
    @ODataField( odataName = "ProdnRsceToolStandardWorkQty" )
    private BigDecimal prodnRsceToolStandardWorkQty;
    /**
     * Use with available fluent helpers to apply the <b>ProdnRsceToolStandardWorkQty</b> field to query operations.
     *
     */
    public final static MaintOrderOpProdnRsceToolField<BigDecimal> PRODN_RSCE_TOOL_STANDARD_WORK_QTY =
        new MaintOrderOpProdnRsceToolField<BigDecimal>("ProdnRsceToolStandardWorkQty");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolStdWorkQtyUnit</b>
     * </p>
     *
     * @return Unit for Quantity of Production Resources/Tools
     */
    @SerializedName( "ProdnRsceToolStdWorkQtyUnit" )
    @JsonProperty( "ProdnRsceToolStdWorkQtyUnit" )
    @Nullable
    @ODataField( odataName = "ProdnRsceToolStdWorkQtyUnit" )
    private String prodnRsceToolStdWorkQtyUnit;
    /**
     * Use with available fluent helpers to apply the <b>ProdnRsceToolStdWorkQtyUnit</b> field to query operations.
     *
     */
    public final static MaintOrderOpProdnRsceToolField<String> PRODN_RSCE_TOOL_STD_WORK_QTY_UNIT =
        new MaintOrderOpProdnRsceToolField<String>("ProdnRsceToolStdWorkQtyUnit");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static MaintOrderOpProdnRsceToolField<String> PLANT =
        new MaintOrderOpProdnRsceToolField<String>("Plant");
    /**
     * Navigation property <b>to_MaintenanceOrderOperation</b> for <b>MaintOrderOpProdnRsceTool</b> to single
     * <b>MaintenanceOrderOperation</b>.
     *
     */
    @SerializedName( "to_MaintenanceOrderOperation" )
    @JsonProperty( "to_MaintenanceOrderOperation" )
    @ODataField( odataName = "to_MaintenanceOrderOperation" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private MaintenanceOrderOperation toMaintenanceOrderOperation;
    /**
     * Navigation property <b>to_MaintenanceOrder</b> for <b>MaintOrderOpProdnRsceTool</b> to single
     * <b>MaintenanceOrder</b>.
     *
     */
    @SerializedName( "to_MaintenanceOrder" )
    @JsonProperty( "to_MaintenanceOrder" )
    @ODataField( odataName = "to_MaintenanceOrder" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private MaintenanceOrder toMaintenanceOrder;
    /**
     * Use with available fluent helpers to apply the <b>to_MaintenanceOrderOperation</b> navigation property to query
     * operations.
     *
     */
    public final static MaintOrderOpProdnRsceToolOneToOneLink<MaintenanceOrderOperation> TO_MAINTENANCE_ORDER_OPERATION =
        new MaintOrderOpProdnRsceToolOneToOneLink<MaintenanceOrderOperation>("to_MaintenanceOrderOperation");
    /**
     * Use with available fluent helpers to apply the <b>to_MaintenanceOrder</b> navigation property to query
     * operations.
     *
     */
    public final static MaintOrderOpProdnRsceToolOneToOneLink<MaintenanceOrder> TO_MAINTENANCE_ORDER =
        new MaintOrderOpProdnRsceToolOneToOneLink<MaintenanceOrder>("to_MaintenanceOrder");

    @Nonnull
    @Override
    public Class<MaintOrderOpProdnRsceTool> getType()
    {
        return MaintOrderOpProdnRsceTool.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrder</b>
     * </p>
     *
     * @param maintenanceOrder
     *            Order Number
     */
    public void setMaintenanceOrder( @Nullable final String maintenanceOrder )
    {
        rememberChangedField("MaintenanceOrder", this.maintenanceOrder);
        this.maintenanceOrder = maintenanceOrder;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderOperation</b>
     * </p>
     *
     * @param maintenanceOrderOperation
     *            Maintenance Order Operation
     */
    public void setMaintenanceOrderOperation( @Nullable final String maintenanceOrderOperation )
    {
        rememberChangedField("MaintenanceOrderOperation", this.maintenanceOrderOperation);
        this.maintenanceOrderOperation = maintenanceOrderOperation;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderSubOperation</b>
     * </p>
     *
     * @param maintenanceOrderSubOperation
     *            Maintenance Order Suboperation
     */
    public void setMaintenanceOrderSubOperation( @Nullable final String maintenanceOrderSubOperation )
    {
        rememberChangedField("MaintenanceOrderSubOperation", this.maintenanceOrderSubOperation);
        this.maintenanceOrderSubOperation = maintenanceOrderSubOperation;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolItemNumber</b>
     * </p>
     *
     * @param prodnRsceToolItemNumber
     *            Item Number for Production Resource/Tool
     */
    public void setProdnRsceToolItemNumber( @Nullable final String prodnRsceToolItemNumber )
    {
        rememberChangedField("ProdnRsceToolItemNumber", this.prodnRsceToolItemNumber);
        this.prodnRsceToolItemNumber = prodnRsceToolItemNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>OrderProdnRsceToolText</b>
     * </p>
     *
     * @param orderProdnRsceToolText
     *            First Line of Text for Production Resources/Tools
     */
    public void setOrderProdnRsceToolText( @Nullable final String orderProdnRsceToolText )
    {
        rememberChangedField("OrderProdnRsceToolText", this.orderProdnRsceToolText);
        this.orderProdnRsceToolText = orderProdnRsceToolText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolCategory</b>
     * </p>
     *
     * @param prodnRsceToolCategory
     *            Production Resources/Tools Category
     */
    public void setProdnRsceToolCategory( @Nullable final String prodnRsceToolCategory )
    {
        rememberChangedField("ProdnRsceToolCategory", this.prodnRsceToolCategory);
        this.prodnRsceToolCategory = prodnRsceToolCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolCategoryName</b>
     * </p>
     *
     * @param prodnRsceToolCategoryName
     *            Language-dependent description of the PRT category
     */
    public void setProdnRsceToolCategoryName( @Nullable final String prodnRsceToolCategoryName )
    {
        rememberChangedField("ProdnRsceToolCategoryName", this.prodnRsceToolCategoryName);
        this.prodnRsceToolCategoryName = prodnRsceToolCategoryName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProductionResourceTool</b>
     * </p>
     *
     * @param productionResourceTool
     *            Production Resource/Tool Number
     */
    public void setProductionResourceTool( @Nullable final String productionResourceTool )
    {
        rememberChangedField("ProductionResourceTool", this.productionResourceTool);
        this.productionResourceTool = productionResourceTool;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Material Number
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>MiscProductionResourceTool</b>
     * </p>
     *
     * @param miscProductionResourceTool
     *            Miscellaneous Production Resources and Tools
     */
    public void setMiscProductionResourceTool( @Nullable final String miscProductionResourceTool )
    {
        rememberChangedField("MiscProductionResourceTool", this.miscProductionResourceTool);
        this.miscProductionResourceTool = miscProductionResourceTool;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProductionResourceToolDesc</b>
     * </p>
     *
     * @param productionResourceToolDesc
     *            Description of the Production Resource/Tool
     */
    public void setProductionResourceToolDesc( @Nullable final String productionResourceToolDesc )
    {
        rememberChangedField("ProductionResourceToolDesc", this.productionResourceToolDesc);
        this.productionResourceToolDesc = productionResourceToolDesc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolControlProfile</b>
     * </p>
     *
     * @param prodnRsceToolControlProfile
     *            Control Profile for Management of Production Resources/Tools
     */
    public void setProdnRsceToolControlProfile( @Nullable final String prodnRsceToolControlProfile )
    {
        rememberChangedField("ProdnRsceToolControlProfile", this.prodnRsceToolControlProfile);
        this.prodnRsceToolControlProfile = prodnRsceToolControlProfile;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolStandardWorkQty</b>
     * </p>
     *
     * @param prodnRsceToolStandardWorkQty
     *            Standard Value for Quantity of Production Resources/Tools
     */
    public void setProdnRsceToolStandardWorkQty( @Nullable final BigDecimal prodnRsceToolStandardWorkQty )
    {
        rememberChangedField("ProdnRsceToolStandardWorkQty", this.prodnRsceToolStandardWorkQty);
        this.prodnRsceToolStandardWorkQty = prodnRsceToolStandardWorkQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolStdWorkQtyUnit</b>
     * </p>
     *
     * @param prodnRsceToolStdWorkQtyUnit
     *            Unit for Quantity of Production Resources/Tools
     */
    public void setProdnRsceToolStdWorkQtyUnit( @Nullable final String prodnRsceToolStdWorkQtyUnit )
    {
        rememberChangedField("ProdnRsceToolStdWorkQtyUnit", this.prodnRsceToolStdWorkQtyUnit);
        this.prodnRsceToolStdWorkQtyUnit = prodnRsceToolStdWorkQtyUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    @Override
    protected String getEntityCollection()
    {
        return "MaintOrderOpProdnRsceTool";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("MaintenanceOrder", getMaintenanceOrder());
        result.put("MaintenanceOrderOperation", getMaintenanceOrderOperation());
        result.put("MaintenanceOrderSubOperation", getMaintenanceOrderSubOperation());
        result.put("ProdnRsceToolItemNumber", getProdnRsceToolItemNumber());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("MaintenanceOrder", getMaintenanceOrder());
        values.put("MaintenanceOrderOperation", getMaintenanceOrderOperation());
        values.put("MaintenanceOrderSubOperation", getMaintenanceOrderSubOperation());
        values.put("ProdnRsceToolItemNumber", getProdnRsceToolItemNumber());
        values.put("OrderProdnRsceToolText", getOrderProdnRsceToolText());
        values.put("ProdnRsceToolCategory", getProdnRsceToolCategory());
        values.put("ProdnRsceToolCategoryName", getProdnRsceToolCategoryName());
        values.put("ProductionResourceTool", getProductionResourceTool());
        values.put("Product", getProduct());
        values.put("MiscProductionResourceTool", getMiscProductionResourceTool());
        values.put("ProductionResourceToolDesc", getProductionResourceToolDesc());
        values.put("ProdnRsceToolControlProfile", getProdnRsceToolControlProfile());
        values.put("ProdnRsceToolStandardWorkQty", getProdnRsceToolStandardWorkQty());
        values.put("ProdnRsceToolStdWorkQtyUnit", getProdnRsceToolStdWorkQtyUnit());
        values.put("Plant", getPlant());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("MaintenanceOrder") ) {
                final Object value = values.remove("MaintenanceOrder");
                if( (value == null) || (!value.equals(getMaintenanceOrder())) ) {
                    setMaintenanceOrder(((String) value));
                }
            }
            if( values.containsKey("MaintenanceOrderOperation") ) {
                final Object value = values.remove("MaintenanceOrderOperation");
                if( (value == null) || (!value.equals(getMaintenanceOrderOperation())) ) {
                    setMaintenanceOrderOperation(((String) value));
                }
            }
            if( values.containsKey("MaintenanceOrderSubOperation") ) {
                final Object value = values.remove("MaintenanceOrderSubOperation");
                if( (value == null) || (!value.equals(getMaintenanceOrderSubOperation())) ) {
                    setMaintenanceOrderSubOperation(((String) value));
                }
            }
            if( values.containsKey("ProdnRsceToolItemNumber") ) {
                final Object value = values.remove("ProdnRsceToolItemNumber");
                if( (value == null) || (!value.equals(getProdnRsceToolItemNumber())) ) {
                    setProdnRsceToolItemNumber(((String) value));
                }
            }
            if( values.containsKey("OrderProdnRsceToolText") ) {
                final Object value = values.remove("OrderProdnRsceToolText");
                if( (value == null) || (!value.equals(getOrderProdnRsceToolText())) ) {
                    setOrderProdnRsceToolText(((String) value));
                }
            }
            if( values.containsKey("ProdnRsceToolCategory") ) {
                final Object value = values.remove("ProdnRsceToolCategory");
                if( (value == null) || (!value.equals(getProdnRsceToolCategory())) ) {
                    setProdnRsceToolCategory(((String) value));
                }
            }
            if( values.containsKey("ProdnRsceToolCategoryName") ) {
                final Object value = values.remove("ProdnRsceToolCategoryName");
                if( (value == null) || (!value.equals(getProdnRsceToolCategoryName())) ) {
                    setProdnRsceToolCategoryName(((String) value));
                }
            }
            if( values.containsKey("ProductionResourceTool") ) {
                final Object value = values.remove("ProductionResourceTool");
                if( (value == null) || (!value.equals(getProductionResourceTool())) ) {
                    setProductionResourceTool(((String) value));
                }
            }
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("MiscProductionResourceTool") ) {
                final Object value = values.remove("MiscProductionResourceTool");
                if( (value == null) || (!value.equals(getMiscProductionResourceTool())) ) {
                    setMiscProductionResourceTool(((String) value));
                }
            }
            if( values.containsKey("ProductionResourceToolDesc") ) {
                final Object value = values.remove("ProductionResourceToolDesc");
                if( (value == null) || (!value.equals(getProductionResourceToolDesc())) ) {
                    setProductionResourceToolDesc(((String) value));
                }
            }
            if( values.containsKey("ProdnRsceToolControlProfile") ) {
                final Object value = values.remove("ProdnRsceToolControlProfile");
                if( (value == null) || (!value.equals(getProdnRsceToolControlProfile())) ) {
                    setProdnRsceToolControlProfile(((String) value));
                }
            }
            if( values.containsKey("ProdnRsceToolStandardWorkQty") ) {
                final Object value = values.remove("ProdnRsceToolStandardWorkQty");
                if( (value == null) || (!value.equals(getProdnRsceToolStandardWorkQty())) ) {
                    setProdnRsceToolStandardWorkQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("ProdnRsceToolStdWorkQtyUnit") ) {
                final Object value = values.remove("ProdnRsceToolStdWorkQtyUnit");
                if( (value == null) || (!value.equals(getProdnRsceToolStdWorkQtyUnit())) ) {
                    setProdnRsceToolStdWorkQtyUnit(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_MaintenanceOrderOperation") ) {
                final Object value = (values).remove("to_MaintenanceOrderOperation");
                if( value instanceof Map ) {
                    if( toMaintenanceOrderOperation == null ) {
                        toMaintenanceOrderOperation = new MaintenanceOrderOperation();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toMaintenanceOrderOperation.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_MaintenanceOrder") ) {
                final Object value = (values).remove("to_MaintenanceOrder");
                if( value instanceof Map ) {
                    if( toMaintenanceOrder == null ) {
                        toMaintenanceOrder = new MaintenanceOrder();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toMaintenanceOrder.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> MaintOrderOpProdnRsceToolField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new MaintOrderOpProdnRsceToolField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MaintOrderOpProdnRsceToolField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MaintOrderOpProdnRsceToolField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceOrderService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toMaintenanceOrderOperation != null ) {
            (values).put("to_MaintenanceOrderOperation", toMaintenanceOrderOperation);
        }
        if( toMaintenanceOrder != null ) {
            (values).put("to_MaintenanceOrder", toMaintenanceOrder);
        }
        return values;
    }

    /**
     * Fetches the <b>MaintenanceOrderOperation</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_MaintenanceOrderOperation</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>MaintenanceOrderOperation</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceOrderOperation fetchMaintenanceOrderOperation()
    {
        return fetchFieldAsSingle("to_MaintenanceOrderOperation", MaintenanceOrderOperation.class);
    }

    /**
     * Retrieval of associated <b>MaintenanceOrderOperation</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_MaintenanceOrderOperation</b>.
     * <p>
     * If the navigation property <b>to_MaintenanceOrderOperation</b> of a queried <b>MaintOrderOpProdnRsceTool</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintenanceOrderOperation</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceOrderOperation getMaintenanceOrderOperationOrFetch()
    {
        if( toMaintenanceOrderOperation == null ) {
            toMaintenanceOrderOperation = fetchMaintenanceOrderOperation();
        }
        return toMaintenanceOrderOperation;
    }

    /**
     * Retrieval of associated <b>MaintenanceOrderOperation</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_MaintenanceOrderOperation</b>.
     * <p>
     * If the navigation property for an entity <b>MaintOrderOpProdnRsceTool</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaintenanceOrderOperation</b> is already loaded, the
     *         result will contain the <b>MaintenanceOrderOperation</b> entity. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<MaintenanceOrderOperation> getMaintenanceOrderOperationIfPresent()
    {
        return Option.of(toMaintenanceOrderOperation);
    }

    /**
     * Overwrites the associated <b>MaintenanceOrderOperation</b> entity for the loaded navigation property
     * <b>to_MaintenanceOrderOperation</b>.
     *
     * @param value
     *            New <b>MaintenanceOrderOperation</b> entity.
     */
    public void setMaintenanceOrderOperation( final MaintenanceOrderOperation value )
    {
        toMaintenanceOrderOperation = value;
    }

    /**
     * Fetches the <b>MaintenanceOrder</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_MaintenanceOrder</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>MaintenanceOrder</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceOrder fetchMaintenanceOrder()
    {
        return fetchFieldAsSingle("to_MaintenanceOrder", MaintenanceOrder.class);
    }

    /**
     * Retrieval of associated <b>MaintenanceOrder</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_MaintenanceOrder</b>.
     * <p>
     * If the navigation property <b>to_MaintenanceOrder</b> of a queried <b>MaintOrderOpProdnRsceTool</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintenanceOrder</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceOrder getMaintenanceOrderOrFetch()
    {
        if( toMaintenanceOrder == null ) {
            toMaintenanceOrder = fetchMaintenanceOrder();
        }
        return toMaintenanceOrder;
    }

    /**
     * Retrieval of associated <b>MaintenanceOrder</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_MaintenanceOrder</b>.
     * <p>
     * If the navigation property for an entity <b>MaintOrderOpProdnRsceTool</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaintenanceOrder</b> is already loaded, the result will
     *         contain the <b>MaintenanceOrder</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<MaintenanceOrder> getMaintenanceOrderIfPresent()
    {
        return Option.of(toMaintenanceOrder);
    }

    /**
     * Overwrites the associated <b>MaintenanceOrder</b> entity for the loaded navigation property
     * <b>to_MaintenanceOrder</b>.
     *
     * @param value
     *            New <b>MaintenanceOrder</b> entity.
     */
    public void setMaintenanceOrder( final MaintenanceOrder value )
    {
        toMaintenanceOrder = value;
    }

    /**
     * Helper class to allow for fluent creation of MaintOrderOpProdnRsceTool instances.
     *
     */
    public final static class MaintOrderOpProdnRsceToolBuilder
    {

        private MaintenanceOrderOperation toMaintenanceOrderOperation;
        private String maintenanceOrderOperation = null;
        private MaintenanceOrder toMaintenanceOrder;
        private String maintenanceOrder = null;

        private MaintOrderOpProdnRsceTool.MaintOrderOpProdnRsceToolBuilder toMaintenanceOrderOperation(
            final MaintenanceOrderOperation value )
        {
            toMaintenanceOrderOperation = value;
            return this;
        }

        /**
         * Navigation property <b>to_MaintenanceOrderOperation</b> for <b>MaintOrderOpProdnRsceTool</b> to single
         * <b>MaintenanceOrderOperation</b>.
         *
         * @param value
         *            The MaintenanceOrderOperation to build this MaintOrderOpProdnRsceTool with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintOrderOpProdnRsceTool.MaintOrderOpProdnRsceToolBuilder maintenanceOrderOperation(
            final MaintenanceOrderOperation value )
        {
            return toMaintenanceOrderOperation(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 4
         * <p>
         * Original property name from the Odata EDM: <b>MaintenanceOrderOperation</b>
         * </p>
         *
         * @param value
         *            The maintenanceOrderOperation to build this MaintOrderOpProdnRsceTool with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintOrderOpProdnRsceTool.MaintOrderOpProdnRsceToolBuilder maintenanceOrderOperation(
            final String value )
        {
            maintenanceOrderOperation = value;
            return this;
        }

        private MaintOrderOpProdnRsceTool.MaintOrderOpProdnRsceToolBuilder toMaintenanceOrder(
            final MaintenanceOrder value )
        {
            toMaintenanceOrder = value;
            return this;
        }

        /**
         * Navigation property <b>to_MaintenanceOrder</b> for <b>MaintOrderOpProdnRsceTool</b> to single
         * <b>MaintenanceOrder</b>.
         *
         * @param value
         *            The MaintenanceOrder to build this MaintOrderOpProdnRsceTool with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintOrderOpProdnRsceTool.MaintOrderOpProdnRsceToolBuilder maintenanceOrder(
            final MaintenanceOrder value )
        {
            return toMaintenanceOrder(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 12
         * <p>
         * Original property name from the Odata EDM: <b>MaintenanceOrder</b>
         * </p>
         *
         * @param value
         *            The maintenanceOrder to build this MaintOrderOpProdnRsceTool with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintOrderOpProdnRsceTool.MaintOrderOpProdnRsceToolBuilder maintenanceOrder( final String value )
        {
            maintenanceOrder = value;
            return this;
        }

    }

}
