/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.selectable.MaintOrderOpProdnRsceToolSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpProdnRsceTool
 * MaintOrderOpProdnRsceTool} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class MaintOrderOpProdnRsceToolByKeyFluentHelper
    extends
    FluentHelperByKey<MaintOrderOpProdnRsceToolByKeyFluentHelper, MaintOrderOpProdnRsceTool, MaintOrderOpProdnRsceToolSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpProdnRsceTool
     * MaintOrderOpProdnRsceTool} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param maintenanceOrder
     *            Order Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code MaintOrderOpProdnRsceTool}
     * @param maintenanceOrderOperation
     *            Maintenance Order Operation
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param maintenanceOrderSubOperation
     *            Maintenance Order Suboperation
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param prodnRsceToolItemNumber
     *            Item Number for Production Resource/Tool
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code MaintOrderOpProdnRsceTool}
     */
    public MaintOrderOpProdnRsceToolByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String maintenanceOrder,
        final String maintenanceOrderOperation,
        final String maintenanceOrderSubOperation,
        final String prodnRsceToolItemNumber )
    {
        super(servicePath, entityCollection);
        this.key.put("MaintenanceOrder", maintenanceOrder);
        this.key.put("MaintenanceOrderOperation", maintenanceOrderOperation);
        this.key.put("MaintenanceOrderSubOperation", maintenanceOrderSubOperation);
        this.key.put("ProdnRsceToolItemNumber", prodnRsceToolItemNumber);
    }

    @Override
    @Nonnull
    protected Class<MaintOrderOpProdnRsceTool> getEntityClass()
    {
        return MaintOrderOpProdnRsceTool.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
