/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.field.MaintOrderOpRelationshipField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.link.MaintOrderOpRelationshipOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.selectable.MaintOrderOpRelationshipSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Maintenance Order Relationship
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MaintOrderOpRelationshipType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MaintOrderOpRelationship extends VdmEntity<MaintOrderOpRelationship>
{

    /**
     * Selector for all available fields of MaintOrderOpRelationship.
     *
     */
    public final static MaintOrderOpRelationshipSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrder</b>
     * </p>
     *
     * @return Order Number
     */
    @Key
    @SerializedName( "MaintenanceOrder" )
    @JsonProperty( "MaintenanceOrder" )
    @Nullable
    @ODataField( odataName = "MaintenanceOrder" )
    private String maintenanceOrder;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceOrder</b> field to query operations.
     *
     */
    public final static MaintOrderOpRelationshipField<String> MAINTENANCE_ORDER =
        new MaintOrderOpRelationshipField<String>("MaintenanceOrder");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderOperation</b>
     * </p>
     *
     * @return Maintenance Order Operation
     */
    @Key
    @SerializedName( "MaintenanceOrderOperation" )
    @JsonProperty( "MaintenanceOrderOperation" )
    @Nullable
    @ODataField( odataName = "MaintenanceOrderOperation" )
    private String maintenanceOrderOperation;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceOrderOperation</b> field to query operations.
     *
     */
    public final static MaintOrderOpRelationshipField<String> MAINTENANCE_ORDER_OPERATION =
        new MaintOrderOpRelationshipField<String>("MaintenanceOrderOperation");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderSubOperation</b>
     * </p>
     *
     * @return Maintenance Order Suboperation
     */
    @Key
    @SerializedName( "MaintenanceOrderSubOperation" )
    @JsonProperty( "MaintenanceOrderSubOperation" )
    @Nullable
    @ODataField( odataName = "MaintenanceOrderSubOperation" )
    private String maintenanceOrderSubOperation;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceOrderSubOperation</b> field to query operations.
     *
     */
    public final static MaintOrderOpRelationshipField<String> MAINTENANCE_ORDER_SUB_OPERATION =
        new MaintOrderOpRelationshipField<String>("MaintenanceOrderSubOperation");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdOperationIsSuccessor</b>
     * </p>
     *
     * @return Indicator: Activity is successor to selected activity
     */
    @Key
    @SerializedName( "MaintOrdOperationIsSuccessor" )
    @JsonProperty( "MaintOrdOperationIsSuccessor" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "MaintOrdOperationIsSuccessor" )
    private Boolean maintOrdOperationIsSuccessor;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrdOperationIsSuccessor</b> field to query operations.
     *
     */
    public final static MaintOrderOpRelationshipField<Boolean> MAINT_ORD_OPERATION_IS_SUCCESSOR =
        new MaintOrderOpRelationshipField<Boolean>("MaintOrdOperationIsSuccessor");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>RelatedMaintenanceOrder</b>
     * </p>
     *
     * @return Order Number
     */
    @Key
    @SerializedName( "RelatedMaintenanceOrder" )
    @JsonProperty( "RelatedMaintenanceOrder" )
    @Nullable
    @ODataField( odataName = "RelatedMaintenanceOrder" )
    private String relatedMaintenanceOrder;
    /**
     * Use with available fluent helpers to apply the <b>RelatedMaintenanceOrder</b> field to query operations.
     *
     */
    public final static MaintOrderOpRelationshipField<String> RELATED_MAINTENANCE_ORDER =
        new MaintOrderOpRelationshipField<String>("RelatedMaintenanceOrder");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RelatedMaintOrderOperation</b>
     * </p>
     *
     * @return Maintenance Order Operation
     */
    @Key
    @SerializedName( "RelatedMaintOrderOperation" )
    @JsonProperty( "RelatedMaintOrderOperation" )
    @Nullable
    @ODataField( odataName = "RelatedMaintOrderOperation" )
    private String relatedMaintOrderOperation;
    /**
     * Use with available fluent helpers to apply the <b>RelatedMaintOrderOperation</b> field to query operations.
     *
     */
    public final static MaintOrderOpRelationshipField<String> RELATED_MAINT_ORDER_OPERATION =
        new MaintOrderOpRelationshipField<String>("RelatedMaintOrderOperation");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OrderOpRelationshipIntType</b>
     * </p>
     *
     * @return Type of relationship
     */
    @Key
    @SerializedName( "OrderOpRelationshipIntType" )
    @JsonProperty( "OrderOpRelationshipIntType" )
    @Nullable
    @ODataField( odataName = "OrderOpRelationshipIntType" )
    private String orderOpRelationshipIntType;
    /**
     * Use with available fluent helpers to apply the <b>OrderOpRelationshipIntType</b> field to query operations.
     *
     */
    public final static MaintOrderOpRelationshipField<String> ORDER_OP_RELATIONSHIP_INT_TYPE =
        new MaintOrderOpRelationshipField<String>("OrderOpRelationshipIntType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PredecessorMaintOrderRouting</b>
     * </p>
     *
     * @return No. identifying the network to which the predecessor belongs
     */
    @SerializedName( "PredecessorMaintOrderRouting" )
    @JsonProperty( "PredecessorMaintOrderRouting" )
    @Nullable
    @ODataField( odataName = "PredecessorMaintOrderRouting" )
    private String predecessorMaintOrderRouting;
    /**
     * Use with available fluent helpers to apply the <b>PredecessorMaintOrderRouting</b> field to query operations.
     *
     */
    public final static MaintOrderOpRelationshipField<String> PREDECESSOR_MAINT_ORDER_ROUTING =
        new MaintOrderOpRelationshipField<String>("PredecessorMaintOrderRouting");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PredecessorOrderRoutingNode</b>
     * </p>
     *
     * @return Internal counter
     */
    @SerializedName( "PredecessorOrderRoutingNode" )
    @JsonProperty( "PredecessorOrderRoutingNode" )
    @Nullable
    @ODataField( odataName = "PredecessorOrderRoutingNode" )
    private String predecessorOrderRoutingNode;
    /**
     * Use with available fluent helpers to apply the <b>PredecessorOrderRoutingNode</b> field to query operations.
     *
     */
    public final static MaintOrderOpRelationshipField<String> PREDECESSOR_ORDER_ROUTING_NODE =
        new MaintOrderOpRelationshipField<String>("PredecessorOrderRoutingNode");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SuccessorMaintOrderRouting</b>
     * </p>
     *
     * @return No. identifying the network to which the successor belongs
     */
    @SerializedName( "SuccessorMaintOrderRouting" )
    @JsonProperty( "SuccessorMaintOrderRouting" )
    @Nullable
    @ODataField( odataName = "SuccessorMaintOrderRouting" )
    private String successorMaintOrderRouting;
    /**
     * Use with available fluent helpers to apply the <b>SuccessorMaintOrderRouting</b> field to query operations.
     *
     */
    public final static MaintOrderOpRelationshipField<String> SUCCESSOR_MAINT_ORDER_ROUTING =
        new MaintOrderOpRelationshipField<String>("SuccessorMaintOrderRouting");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>SuccessorOrderRoutingNode</b>
     * </p>
     *
     * @return Internal counter
     */
    @SerializedName( "SuccessorOrderRoutingNode" )
    @JsonProperty( "SuccessorOrderRoutingNode" )
    @Nullable
    @ODataField( odataName = "SuccessorOrderRoutingNode" )
    private String successorOrderRoutingNode;
    /**
     * Use with available fluent helpers to apply the <b>SuccessorOrderRoutingNode</b> field to query operations.
     *
     */
    public final static MaintOrderOpRelationshipField<String> SUCCESSOR_ORDER_ROUTING_NODE =
        new MaintOrderOpRelationshipField<String>("SuccessorOrderRoutingNode");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RelatedMaintOrderRouting</b>
     * </p>
     *
     * @return No. identifying the network to which the successor belongs
     */
    @SerializedName( "RelatedMaintOrderRouting" )
    @JsonProperty( "RelatedMaintOrderRouting" )
    @Nullable
    @ODataField( odataName = "RelatedMaintOrderRouting" )
    private String relatedMaintOrderRouting;
    /**
     * Use with available fluent helpers to apply the <b>RelatedMaintOrderRouting</b> field to query operations.
     *
     */
    public final static MaintOrderOpRelationshipField<String> RELATED_MAINT_ORDER_ROUTING =
        new MaintOrderOpRelationshipField<String>("RelatedMaintOrderRouting");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>RelatedOrderRoutingNode</b>
     * </p>
     *
     * @return Internal counter
     */
    @SerializedName( "RelatedOrderRoutingNode" )
    @JsonProperty( "RelatedOrderRoutingNode" )
    @Nullable
    @ODataField( odataName = "RelatedOrderRoutingNode" )
    private String relatedOrderRoutingNode;
    /**
     * Use with available fluent helpers to apply the <b>RelatedOrderRoutingNode</b> field to query operations.
     *
     */
    public final static MaintOrderOpRelationshipField<String> RELATED_ORDER_ROUTING_NODE =
        new MaintOrderOpRelationshipField<String>("RelatedOrderRoutingNode");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FactoryCalendar</b>
     * </p>
     *
     * @return Factory Calendar
     */
    @SerializedName( "FactoryCalendar" )
    @JsonProperty( "FactoryCalendar" )
    @Nullable
    @ODataField( odataName = "FactoryCalendar" )
    private String factoryCalendar;
    /**
     * Use with available fluent helpers to apply the <b>FactoryCalendar</b> field to query operations.
     *
     */
    public final static MaintOrderOpRelationshipField<String> FACTORY_CALENDAR =
        new MaintOrderOpRelationshipField<String>("FactoryCalendar");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>OpRelshpOffsetDuration</b>
     * </p>
     *
     * @return Time Interval Between Relationships
     */
    @SerializedName( "OpRelshpOffsetDuration" )
    @JsonProperty( "OpRelshpOffsetDuration" )
    @Nullable
    @ODataField( odataName = "OpRelshpOffsetDuration" )
    private BigDecimal opRelshpOffsetDuration;
    /**
     * Use with available fluent helpers to apply the <b>OpRelshpOffsetDuration</b> field to query operations.
     *
     */
    public final static MaintOrderOpRelationshipField<BigDecimal> OP_RELSHP_OFFSET_DURATION =
        new MaintOrderOpRelationshipField<BigDecimal>("OpRelshpOffsetDuration");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpRelshpOffsetDurationUnit</b>
     * </p>
     *
     * @return Unit for the time interval between relationships
     */
    @SerializedName( "OpRelshpOffsetDurationUnit" )
    @JsonProperty( "OpRelshpOffsetDurationUnit" )
    @Nullable
    @ODataField( odataName = "OpRelshpOffsetDurationUnit" )
    private String opRelshpOffsetDurationUnit;
    /**
     * Use with available fluent helpers to apply the <b>OpRelshpOffsetDurationUnit</b> field to query operations.
     *
     */
    public final static MaintOrderOpRelationshipField<String> OP_RELSHP_OFFSET_DURATION_UNIT =
        new MaintOrderOpRelationshipField<String>("OpRelshpOffsetDurationUnit");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpRelshpEarliestStartDate</b>
     * </p>
     *
     * @return Earliest start date for the relationship
     */
    @SerializedName( "OpRelshpEarliestStartDate" )
    @JsonProperty( "OpRelshpEarliestStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "OpRelshpEarliestStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime opRelshpEarliestStartDate;
    /**
     * Use with available fluent helpers to apply the <b>OpRelshpEarliestStartDate</b> field to query operations.
     *
     */
    public final static MaintOrderOpRelationshipField<LocalDateTime> OP_RELSHP_EARLIEST_START_DATE =
        new MaintOrderOpRelationshipField<LocalDateTime>("OpRelshpEarliestStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpRelshpEarliestStartTime</b>
     * </p>
     *
     * @return Earliest start time for the relationship
     */
    @SerializedName( "OpRelshpEarliestStartTime" )
    @JsonProperty( "OpRelshpEarliestStartTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "OpRelshpEarliestStartTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime opRelshpEarliestStartTime;
    /**
     * Use with available fluent helpers to apply the <b>OpRelshpEarliestStartTime</b> field to query operations.
     *
     */
    public final static MaintOrderOpRelationshipField<LocalTime> OP_RELSHP_EARLIEST_START_TIME =
        new MaintOrderOpRelationshipField<LocalTime>("OpRelshpEarliestStartTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpRelationshipLatestStartDate</b>
     * </p>
     *
     * @return Latest start date of the relationship
     */
    @SerializedName( "OpRelationshipLatestStartDate" )
    @JsonProperty( "OpRelationshipLatestStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "OpRelationshipLatestStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime opRelationshipLatestStartDate;
    /**
     * Use with available fluent helpers to apply the <b>OpRelationshipLatestStartDate</b> field to query operations.
     *
     */
    public final static MaintOrderOpRelationshipField<LocalDateTime> OP_RELATIONSHIP_LATEST_START_DATE =
        new MaintOrderOpRelationshipField<LocalDateTime>("OpRelationshipLatestStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpRelationshipLatestStartTime</b>
     * </p>
     *
     * @return Latest start time of the relationship
     */
    @SerializedName( "OpRelationshipLatestStartTime" )
    @JsonProperty( "OpRelationshipLatestStartTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "OpRelationshipLatestStartTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime opRelationshipLatestStartTime;
    /**
     * Use with available fluent helpers to apply the <b>OpRelationshipLatestStartTime</b> field to query operations.
     *
     */
    public final static MaintOrderOpRelationshipField<LocalTime> OP_RELATIONSHIP_LATEST_START_TIME =
        new MaintOrderOpRelationshipField<LocalTime>("OpRelationshipLatestStartTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpRelshpEarliestFinishDate</b>
     * </p>
     *
     * @return Earliest finish date for the relationship
     */
    @SerializedName( "OpRelshpEarliestFinishDate" )
    @JsonProperty( "OpRelshpEarliestFinishDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "OpRelshpEarliestFinishDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime opRelshpEarliestFinishDate;
    /**
     * Use with available fluent helpers to apply the <b>OpRelshpEarliestFinishDate</b> field to query operations.
     *
     */
    public final static MaintOrderOpRelationshipField<LocalDateTime> OP_RELSHP_EARLIEST_FINISH_DATE =
        new MaintOrderOpRelationshipField<LocalDateTime>("OpRelshpEarliestFinishDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpRelshpEarliestFinishTime</b>
     * </p>
     *
     * @return Earliest finish time for the relationship
     */
    @SerializedName( "OpRelshpEarliestFinishTime" )
    @JsonProperty( "OpRelshpEarliestFinishTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "OpRelshpEarliestFinishTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime opRelshpEarliestFinishTime;
    /**
     * Use with available fluent helpers to apply the <b>OpRelshpEarliestFinishTime</b> field to query operations.
     *
     */
    public final static MaintOrderOpRelationshipField<LocalTime> OP_RELSHP_EARLIEST_FINISH_TIME =
        new MaintOrderOpRelationshipField<LocalTime>("OpRelshpEarliestFinishTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpRelshpLatestFinishDate</b>
     * </p>
     *
     * @return Latest finish date of the relationship
     */
    @SerializedName( "OpRelshpLatestFinishDate" )
    @JsonProperty( "OpRelshpLatestFinishDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "OpRelshpLatestFinishDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime opRelshpLatestFinishDate;
    /**
     * Use with available fluent helpers to apply the <b>OpRelshpLatestFinishDate</b> field to query operations.
     *
     */
    public final static MaintOrderOpRelationshipField<LocalDateTime> OP_RELSHP_LATEST_FINISH_DATE =
        new MaintOrderOpRelationshipField<LocalDateTime>("OpRelshpLatestFinishDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpRelshpLatestFinishTime</b>
     * </p>
     *
     * @return Latest finish time of the relationship
     */
    @SerializedName( "OpRelshpLatestFinishTime" )
    @JsonProperty( "OpRelshpLatestFinishTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "OpRelshpLatestFinishTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime opRelshpLatestFinishTime;
    /**
     * Use with available fluent helpers to apply the <b>OpRelshpLatestFinishTime</b> field to query operations.
     *
     */
    public final static MaintOrderOpRelationshipField<LocalTime> OP_RELSHP_LATEST_FINISH_TIME =
        new MaintOrderOpRelationshipField<LocalTime>("OpRelshpLatestFinishTime");
    /**
     * Navigation property <b>to_MaintenanceOrderOperation</b> for <b>MaintOrderOpRelationship</b> to single
     * <b>MaintenanceOrderOperation</b>.
     *
     */
    @SerializedName( "to_MaintenanceOrderOperation" )
    @JsonProperty( "to_MaintenanceOrderOperation" )
    @ODataField( odataName = "to_MaintenanceOrderOperation" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private MaintenanceOrderOperation toMaintenanceOrderOperation;
    /**
     * Navigation property <b>to_MaintenanceOrder</b> for <b>MaintOrderOpRelationship</b> to single
     * <b>MaintenanceOrder</b>.
     *
     */
    @SerializedName( "to_MaintenanceOrder" )
    @JsonProperty( "to_MaintenanceOrder" )
    @ODataField( odataName = "to_MaintenanceOrder" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private MaintenanceOrder toMaintenanceOrder;
    /**
     * Use with available fluent helpers to apply the <b>to_MaintenanceOrderOperation</b> navigation property to query
     * operations.
     *
     */
    public final static MaintOrderOpRelationshipOneToOneLink<MaintenanceOrderOperation> TO_MAINTENANCE_ORDER_OPERATION =
        new MaintOrderOpRelationshipOneToOneLink<MaintenanceOrderOperation>("to_MaintenanceOrderOperation");
    /**
     * Use with available fluent helpers to apply the <b>to_MaintenanceOrder</b> navigation property to query
     * operations.
     *
     */
    public final static MaintOrderOpRelationshipOneToOneLink<MaintenanceOrder> TO_MAINTENANCE_ORDER =
        new MaintOrderOpRelationshipOneToOneLink<MaintenanceOrder>("to_MaintenanceOrder");

    @Nonnull
    @Override
    public Class<MaintOrderOpRelationship> getType()
    {
        return MaintOrderOpRelationship.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrder</b>
     * </p>
     *
     * @param maintenanceOrder
     *            Order Number
     */
    public void setMaintenanceOrder( @Nullable final String maintenanceOrder )
    {
        rememberChangedField("MaintenanceOrder", this.maintenanceOrder);
        this.maintenanceOrder = maintenanceOrder;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderOperation</b>
     * </p>
     *
     * @param maintenanceOrderOperation
     *            Maintenance Order Operation
     */
    public void setMaintenanceOrderOperation( @Nullable final String maintenanceOrderOperation )
    {
        rememberChangedField("MaintenanceOrderOperation", this.maintenanceOrderOperation);
        this.maintenanceOrderOperation = maintenanceOrderOperation;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderSubOperation</b>
     * </p>
     *
     * @param maintenanceOrderSubOperation
     *            Maintenance Order Suboperation
     */
    public void setMaintenanceOrderSubOperation( @Nullable final String maintenanceOrderSubOperation )
    {
        rememberChangedField("MaintenanceOrderSubOperation", this.maintenanceOrderSubOperation);
        this.maintenanceOrderSubOperation = maintenanceOrderSubOperation;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdOperationIsSuccessor</b>
     * </p>
     *
     * @param maintOrdOperationIsSuccessor
     *            Indicator: Activity is successor to selected activity
     */
    public void setMaintOrdOperationIsSuccessor( @Nullable final Boolean maintOrdOperationIsSuccessor )
    {
        rememberChangedField("MaintOrdOperationIsSuccessor", this.maintOrdOperationIsSuccessor);
        this.maintOrdOperationIsSuccessor = maintOrdOperationIsSuccessor;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>RelatedMaintenanceOrder</b>
     * </p>
     *
     * @param relatedMaintenanceOrder
     *            Order Number
     */
    public void setRelatedMaintenanceOrder( @Nullable final String relatedMaintenanceOrder )
    {
        rememberChangedField("RelatedMaintenanceOrder", this.relatedMaintenanceOrder);
        this.relatedMaintenanceOrder = relatedMaintenanceOrder;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RelatedMaintOrderOperation</b>
     * </p>
     *
     * @param relatedMaintOrderOperation
     *            Maintenance Order Operation
     */
    public void setRelatedMaintOrderOperation( @Nullable final String relatedMaintOrderOperation )
    {
        rememberChangedField("RelatedMaintOrderOperation", this.relatedMaintOrderOperation);
        this.relatedMaintOrderOperation = relatedMaintOrderOperation;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OrderOpRelationshipIntType</b>
     * </p>
     *
     * @param orderOpRelationshipIntType
     *            Type of relationship
     */
    public void setOrderOpRelationshipIntType( @Nullable final String orderOpRelationshipIntType )
    {
        rememberChangedField("OrderOpRelationshipIntType", this.orderOpRelationshipIntType);
        this.orderOpRelationshipIntType = orderOpRelationshipIntType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PredecessorMaintOrderRouting</b>
     * </p>
     *
     * @param predecessorMaintOrderRouting
     *            No. identifying the network to which the predecessor belongs
     */
    public void setPredecessorMaintOrderRouting( @Nullable final String predecessorMaintOrderRouting )
    {
        rememberChangedField("PredecessorMaintOrderRouting", this.predecessorMaintOrderRouting);
        this.predecessorMaintOrderRouting = predecessorMaintOrderRouting;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PredecessorOrderRoutingNode</b>
     * </p>
     *
     * @param predecessorOrderRoutingNode
     *            Internal counter
     */
    public void setPredecessorOrderRoutingNode( @Nullable final String predecessorOrderRoutingNode )
    {
        rememberChangedField("PredecessorOrderRoutingNode", this.predecessorOrderRoutingNode);
        this.predecessorOrderRoutingNode = predecessorOrderRoutingNode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SuccessorMaintOrderRouting</b>
     * </p>
     *
     * @param successorMaintOrderRouting
     *            No. identifying the network to which the successor belongs
     */
    public void setSuccessorMaintOrderRouting( @Nullable final String successorMaintOrderRouting )
    {
        rememberChangedField("SuccessorMaintOrderRouting", this.successorMaintOrderRouting);
        this.successorMaintOrderRouting = successorMaintOrderRouting;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>SuccessorOrderRoutingNode</b>
     * </p>
     *
     * @param successorOrderRoutingNode
     *            Internal counter
     */
    public void setSuccessorOrderRoutingNode( @Nullable final String successorOrderRoutingNode )
    {
        rememberChangedField("SuccessorOrderRoutingNode", this.successorOrderRoutingNode);
        this.successorOrderRoutingNode = successorOrderRoutingNode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RelatedMaintOrderRouting</b>
     * </p>
     *
     * @param relatedMaintOrderRouting
     *            No. identifying the network to which the successor belongs
     */
    public void setRelatedMaintOrderRouting( @Nullable final String relatedMaintOrderRouting )
    {
        rememberChangedField("RelatedMaintOrderRouting", this.relatedMaintOrderRouting);
        this.relatedMaintOrderRouting = relatedMaintOrderRouting;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>RelatedOrderRoutingNode</b>
     * </p>
     *
     * @param relatedOrderRoutingNode
     *            Internal counter
     */
    public void setRelatedOrderRoutingNode( @Nullable final String relatedOrderRoutingNode )
    {
        rememberChangedField("RelatedOrderRoutingNode", this.relatedOrderRoutingNode);
        this.relatedOrderRoutingNode = relatedOrderRoutingNode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FactoryCalendar</b>
     * </p>
     *
     * @param factoryCalendar
     *            Factory Calendar
     */
    public void setFactoryCalendar( @Nullable final String factoryCalendar )
    {
        rememberChangedField("FactoryCalendar", this.factoryCalendar);
        this.factoryCalendar = factoryCalendar;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>OpRelshpOffsetDuration</b>
     * </p>
     *
     * @param opRelshpOffsetDuration
     *            Time Interval Between Relationships
     */
    public void setOpRelshpOffsetDuration( @Nullable final BigDecimal opRelshpOffsetDuration )
    {
        rememberChangedField("OpRelshpOffsetDuration", this.opRelshpOffsetDuration);
        this.opRelshpOffsetDuration = opRelshpOffsetDuration;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpRelshpOffsetDurationUnit</b>
     * </p>
     *
     * @param opRelshpOffsetDurationUnit
     *            Unit for the time interval between relationships
     */
    public void setOpRelshpOffsetDurationUnit( @Nullable final String opRelshpOffsetDurationUnit )
    {
        rememberChangedField("OpRelshpOffsetDurationUnit", this.opRelshpOffsetDurationUnit);
        this.opRelshpOffsetDurationUnit = opRelshpOffsetDurationUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpRelshpEarliestStartDate</b>
     * </p>
     *
     * @param opRelshpEarliestStartDate
     *            Earliest start date for the relationship
     */
    public void setOpRelshpEarliestStartDate( @Nullable final LocalDateTime opRelshpEarliestStartDate )
    {
        rememberChangedField("OpRelshpEarliestStartDate", this.opRelshpEarliestStartDate);
        this.opRelshpEarliestStartDate = opRelshpEarliestStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpRelshpEarliestStartTime</b>
     * </p>
     *
     * @param opRelshpEarliestStartTime
     *            Earliest start time for the relationship
     */
    public void setOpRelshpEarliestStartTime( @Nullable final LocalTime opRelshpEarliestStartTime )
    {
        rememberChangedField("OpRelshpEarliestStartTime", this.opRelshpEarliestStartTime);
        this.opRelshpEarliestStartTime = opRelshpEarliestStartTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpRelationshipLatestStartDate</b>
     * </p>
     *
     * @param opRelationshipLatestStartDate
     *            Latest start date of the relationship
     */
    public void setOpRelationshipLatestStartDate( @Nullable final LocalDateTime opRelationshipLatestStartDate )
    {
        rememberChangedField("OpRelationshipLatestStartDate", this.opRelationshipLatestStartDate);
        this.opRelationshipLatestStartDate = opRelationshipLatestStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpRelationshipLatestStartTime</b>
     * </p>
     *
     * @param opRelationshipLatestStartTime
     *            Latest start time of the relationship
     */
    public void setOpRelationshipLatestStartTime( @Nullable final LocalTime opRelationshipLatestStartTime )
    {
        rememberChangedField("OpRelationshipLatestStartTime", this.opRelationshipLatestStartTime);
        this.opRelationshipLatestStartTime = opRelationshipLatestStartTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpRelshpEarliestFinishDate</b>
     * </p>
     *
     * @param opRelshpEarliestFinishDate
     *            Earliest finish date for the relationship
     */
    public void setOpRelshpEarliestFinishDate( @Nullable final LocalDateTime opRelshpEarliestFinishDate )
    {
        rememberChangedField("OpRelshpEarliestFinishDate", this.opRelshpEarliestFinishDate);
        this.opRelshpEarliestFinishDate = opRelshpEarliestFinishDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpRelshpEarliestFinishTime</b>
     * </p>
     *
     * @param opRelshpEarliestFinishTime
     *            Earliest finish time for the relationship
     */
    public void setOpRelshpEarliestFinishTime( @Nullable final LocalTime opRelshpEarliestFinishTime )
    {
        rememberChangedField("OpRelshpEarliestFinishTime", this.opRelshpEarliestFinishTime);
        this.opRelshpEarliestFinishTime = opRelshpEarliestFinishTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpRelshpLatestFinishDate</b>
     * </p>
     *
     * @param opRelshpLatestFinishDate
     *            Latest finish date of the relationship
     */
    public void setOpRelshpLatestFinishDate( @Nullable final LocalDateTime opRelshpLatestFinishDate )
    {
        rememberChangedField("OpRelshpLatestFinishDate", this.opRelshpLatestFinishDate);
        this.opRelshpLatestFinishDate = opRelshpLatestFinishDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpRelshpLatestFinishTime</b>
     * </p>
     *
     * @param opRelshpLatestFinishTime
     *            Latest finish time of the relationship
     */
    public void setOpRelshpLatestFinishTime( @Nullable final LocalTime opRelshpLatestFinishTime )
    {
        rememberChangedField("OpRelshpLatestFinishTime", this.opRelshpLatestFinishTime);
        this.opRelshpLatestFinishTime = opRelshpLatestFinishTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "MaintOrderOpRelationship";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("MaintenanceOrder", getMaintenanceOrder());
        result.put("MaintenanceOrderOperation", getMaintenanceOrderOperation());
        result.put("MaintenanceOrderSubOperation", getMaintenanceOrderSubOperation());
        result.put("MaintOrdOperationIsSuccessor", getMaintOrdOperationIsSuccessor());
        result.put("RelatedMaintenanceOrder", getRelatedMaintenanceOrder());
        result.put("RelatedMaintOrderOperation", getRelatedMaintOrderOperation());
        result.put("OrderOpRelationshipIntType", getOrderOpRelationshipIntType());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("MaintenanceOrder", getMaintenanceOrder());
        values.put("MaintenanceOrderOperation", getMaintenanceOrderOperation());
        values.put("MaintenanceOrderSubOperation", getMaintenanceOrderSubOperation());
        values.put("MaintOrdOperationIsSuccessor", getMaintOrdOperationIsSuccessor());
        values.put("RelatedMaintenanceOrder", getRelatedMaintenanceOrder());
        values.put("RelatedMaintOrderOperation", getRelatedMaintOrderOperation());
        values.put("OrderOpRelationshipIntType", getOrderOpRelationshipIntType());
        values.put("PredecessorMaintOrderRouting", getPredecessorMaintOrderRouting());
        values.put("PredecessorOrderRoutingNode", getPredecessorOrderRoutingNode());
        values.put("SuccessorMaintOrderRouting", getSuccessorMaintOrderRouting());
        values.put("SuccessorOrderRoutingNode", getSuccessorOrderRoutingNode());
        values.put("RelatedMaintOrderRouting", getRelatedMaintOrderRouting());
        values.put("RelatedOrderRoutingNode", getRelatedOrderRoutingNode());
        values.put("FactoryCalendar", getFactoryCalendar());
        values.put("OpRelshpOffsetDuration", getOpRelshpOffsetDuration());
        values.put("OpRelshpOffsetDurationUnit", getOpRelshpOffsetDurationUnit());
        values.put("OpRelshpEarliestStartDate", getOpRelshpEarliestStartDate());
        values.put("OpRelshpEarliestStartTime", getOpRelshpEarliestStartTime());
        values.put("OpRelationshipLatestStartDate", getOpRelationshipLatestStartDate());
        values.put("OpRelationshipLatestStartTime", getOpRelationshipLatestStartTime());
        values.put("OpRelshpEarliestFinishDate", getOpRelshpEarliestFinishDate());
        values.put("OpRelshpEarliestFinishTime", getOpRelshpEarliestFinishTime());
        values.put("OpRelshpLatestFinishDate", getOpRelshpLatestFinishDate());
        values.put("OpRelshpLatestFinishTime", getOpRelshpLatestFinishTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("MaintenanceOrder") ) {
                final Object value = values.remove("MaintenanceOrder");
                if( (value == null) || (!value.equals(getMaintenanceOrder())) ) {
                    setMaintenanceOrder(((String) value));
                }
            }
            if( values.containsKey("MaintenanceOrderOperation") ) {
                final Object value = values.remove("MaintenanceOrderOperation");
                if( (value == null) || (!value.equals(getMaintenanceOrderOperation())) ) {
                    setMaintenanceOrderOperation(((String) value));
                }
            }
            if( values.containsKey("MaintenanceOrderSubOperation") ) {
                final Object value = values.remove("MaintenanceOrderSubOperation");
                if( (value == null) || (!value.equals(getMaintenanceOrderSubOperation())) ) {
                    setMaintenanceOrderSubOperation(((String) value));
                }
            }
            if( values.containsKey("MaintOrdOperationIsSuccessor") ) {
                final Object value = values.remove("MaintOrdOperationIsSuccessor");
                if( (value == null) || (!value.equals(getMaintOrdOperationIsSuccessor())) ) {
                    setMaintOrdOperationIsSuccessor(((Boolean) value));
                }
            }
            if( values.containsKey("RelatedMaintenanceOrder") ) {
                final Object value = values.remove("RelatedMaintenanceOrder");
                if( (value == null) || (!value.equals(getRelatedMaintenanceOrder())) ) {
                    setRelatedMaintenanceOrder(((String) value));
                }
            }
            if( values.containsKey("RelatedMaintOrderOperation") ) {
                final Object value = values.remove("RelatedMaintOrderOperation");
                if( (value == null) || (!value.equals(getRelatedMaintOrderOperation())) ) {
                    setRelatedMaintOrderOperation(((String) value));
                }
            }
            if( values.containsKey("OrderOpRelationshipIntType") ) {
                final Object value = values.remove("OrderOpRelationshipIntType");
                if( (value == null) || (!value.equals(getOrderOpRelationshipIntType())) ) {
                    setOrderOpRelationshipIntType(((String) value));
                }
            }
            if( values.containsKey("PredecessorMaintOrderRouting") ) {
                final Object value = values.remove("PredecessorMaintOrderRouting");
                if( (value == null) || (!value.equals(getPredecessorMaintOrderRouting())) ) {
                    setPredecessorMaintOrderRouting(((String) value));
                }
            }
            if( values.containsKey("PredecessorOrderRoutingNode") ) {
                final Object value = values.remove("PredecessorOrderRoutingNode");
                if( (value == null) || (!value.equals(getPredecessorOrderRoutingNode())) ) {
                    setPredecessorOrderRoutingNode(((String) value));
                }
            }
            if( values.containsKey("SuccessorMaintOrderRouting") ) {
                final Object value = values.remove("SuccessorMaintOrderRouting");
                if( (value == null) || (!value.equals(getSuccessorMaintOrderRouting())) ) {
                    setSuccessorMaintOrderRouting(((String) value));
                }
            }
            if( values.containsKey("SuccessorOrderRoutingNode") ) {
                final Object value = values.remove("SuccessorOrderRoutingNode");
                if( (value == null) || (!value.equals(getSuccessorOrderRoutingNode())) ) {
                    setSuccessorOrderRoutingNode(((String) value));
                }
            }
            if( values.containsKey("RelatedMaintOrderRouting") ) {
                final Object value = values.remove("RelatedMaintOrderRouting");
                if( (value == null) || (!value.equals(getRelatedMaintOrderRouting())) ) {
                    setRelatedMaintOrderRouting(((String) value));
                }
            }
            if( values.containsKey("RelatedOrderRoutingNode") ) {
                final Object value = values.remove("RelatedOrderRoutingNode");
                if( (value == null) || (!value.equals(getRelatedOrderRoutingNode())) ) {
                    setRelatedOrderRoutingNode(((String) value));
                }
            }
            if( values.containsKey("FactoryCalendar") ) {
                final Object value = values.remove("FactoryCalendar");
                if( (value == null) || (!value.equals(getFactoryCalendar())) ) {
                    setFactoryCalendar(((String) value));
                }
            }
            if( values.containsKey("OpRelshpOffsetDuration") ) {
                final Object value = values.remove("OpRelshpOffsetDuration");
                if( (value == null) || (!value.equals(getOpRelshpOffsetDuration())) ) {
                    setOpRelshpOffsetDuration(((BigDecimal) value));
                }
            }
            if( values.containsKey("OpRelshpOffsetDurationUnit") ) {
                final Object value = values.remove("OpRelshpOffsetDurationUnit");
                if( (value == null) || (!value.equals(getOpRelshpOffsetDurationUnit())) ) {
                    setOpRelshpOffsetDurationUnit(((String) value));
                }
            }
            if( values.containsKey("OpRelshpEarliestStartDate") ) {
                final Object value = values.remove("OpRelshpEarliestStartDate");
                if( (value == null) || (!value.equals(getOpRelshpEarliestStartDate())) ) {
                    setOpRelshpEarliestStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("OpRelshpEarliestStartTime") ) {
                final Object value = values.remove("OpRelshpEarliestStartTime");
                if( (value == null) || (!value.equals(getOpRelshpEarliestStartTime())) ) {
                    setOpRelshpEarliestStartTime(((LocalTime) value));
                }
            }
            if( values.containsKey("OpRelationshipLatestStartDate") ) {
                final Object value = values.remove("OpRelationshipLatestStartDate");
                if( (value == null) || (!value.equals(getOpRelationshipLatestStartDate())) ) {
                    setOpRelationshipLatestStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("OpRelationshipLatestStartTime") ) {
                final Object value = values.remove("OpRelationshipLatestStartTime");
                if( (value == null) || (!value.equals(getOpRelationshipLatestStartTime())) ) {
                    setOpRelationshipLatestStartTime(((LocalTime) value));
                }
            }
            if( values.containsKey("OpRelshpEarliestFinishDate") ) {
                final Object value = values.remove("OpRelshpEarliestFinishDate");
                if( (value == null) || (!value.equals(getOpRelshpEarliestFinishDate())) ) {
                    setOpRelshpEarliestFinishDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("OpRelshpEarliestFinishTime") ) {
                final Object value = values.remove("OpRelshpEarliestFinishTime");
                if( (value == null) || (!value.equals(getOpRelshpEarliestFinishTime())) ) {
                    setOpRelshpEarliestFinishTime(((LocalTime) value));
                }
            }
            if( values.containsKey("OpRelshpLatestFinishDate") ) {
                final Object value = values.remove("OpRelshpLatestFinishDate");
                if( (value == null) || (!value.equals(getOpRelshpLatestFinishDate())) ) {
                    setOpRelshpLatestFinishDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("OpRelshpLatestFinishTime") ) {
                final Object value = values.remove("OpRelshpLatestFinishTime");
                if( (value == null) || (!value.equals(getOpRelshpLatestFinishTime())) ) {
                    setOpRelshpLatestFinishTime(((LocalTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_MaintenanceOrderOperation") ) {
                final Object value = (values).remove("to_MaintenanceOrderOperation");
                if( value instanceof Map ) {
                    if( toMaintenanceOrderOperation == null ) {
                        toMaintenanceOrderOperation = new MaintenanceOrderOperation();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toMaintenanceOrderOperation.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_MaintenanceOrder") ) {
                final Object value = (values).remove("to_MaintenanceOrder");
                if( value instanceof Map ) {
                    if( toMaintenanceOrder == null ) {
                        toMaintenanceOrder = new MaintenanceOrder();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toMaintenanceOrder.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> MaintOrderOpRelationshipField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new MaintOrderOpRelationshipField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MaintOrderOpRelationshipField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MaintOrderOpRelationshipField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceOrderService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toMaintenanceOrderOperation != null ) {
            (values).put("to_MaintenanceOrderOperation", toMaintenanceOrderOperation);
        }
        if( toMaintenanceOrder != null ) {
            (values).put("to_MaintenanceOrder", toMaintenanceOrder);
        }
        return values;
    }

    /**
     * Fetches the <b>MaintenanceOrderOperation</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_MaintenanceOrderOperation</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>MaintenanceOrderOperation</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceOrderOperation fetchMaintenanceOrderOperation()
    {
        return fetchFieldAsSingle("to_MaintenanceOrderOperation", MaintenanceOrderOperation.class);
    }

    /**
     * Retrieval of associated <b>MaintenanceOrderOperation</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_MaintenanceOrderOperation</b>.
     * <p>
     * If the navigation property <b>to_MaintenanceOrderOperation</b> of a queried <b>MaintOrderOpRelationship</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintenanceOrderOperation</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceOrderOperation getMaintenanceOrderOperationOrFetch()
    {
        if( toMaintenanceOrderOperation == null ) {
            toMaintenanceOrderOperation = fetchMaintenanceOrderOperation();
        }
        return toMaintenanceOrderOperation;
    }

    /**
     * Retrieval of associated <b>MaintenanceOrderOperation</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_MaintenanceOrderOperation</b>.
     * <p>
     * If the navigation property for an entity <b>MaintOrderOpRelationship</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaintenanceOrderOperation</b> is already loaded, the
     *         result will contain the <b>MaintenanceOrderOperation</b> entity. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<MaintenanceOrderOperation> getMaintenanceOrderOperationIfPresent()
    {
        return Option.of(toMaintenanceOrderOperation);
    }

    /**
     * Overwrites the associated <b>MaintenanceOrderOperation</b> entity for the loaded navigation property
     * <b>to_MaintenanceOrderOperation</b>.
     *
     * @param value
     *            New <b>MaintenanceOrderOperation</b> entity.
     */
    public void setMaintenanceOrderOperation( final MaintenanceOrderOperation value )
    {
        toMaintenanceOrderOperation = value;
    }

    /**
     * Fetches the <b>MaintenanceOrder</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_MaintenanceOrder</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>MaintenanceOrder</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceOrder fetchMaintenanceOrder()
    {
        return fetchFieldAsSingle("to_MaintenanceOrder", MaintenanceOrder.class);
    }

    /**
     * Retrieval of associated <b>MaintenanceOrder</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_MaintenanceOrder</b>.
     * <p>
     * If the navigation property <b>to_MaintenanceOrder</b> of a queried <b>MaintOrderOpRelationship</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintenanceOrder</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceOrder getMaintenanceOrderOrFetch()
    {
        if( toMaintenanceOrder == null ) {
            toMaintenanceOrder = fetchMaintenanceOrder();
        }
        return toMaintenanceOrder;
    }

    /**
     * Retrieval of associated <b>MaintenanceOrder</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_MaintenanceOrder</b>.
     * <p>
     * If the navigation property for an entity <b>MaintOrderOpRelationship</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaintenanceOrder</b> is already loaded, the result will
     *         contain the <b>MaintenanceOrder</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<MaintenanceOrder> getMaintenanceOrderIfPresent()
    {
        return Option.of(toMaintenanceOrder);
    }

    /**
     * Overwrites the associated <b>MaintenanceOrder</b> entity for the loaded navigation property
     * <b>to_MaintenanceOrder</b>.
     *
     * @param value
     *            New <b>MaintenanceOrder</b> entity.
     */
    public void setMaintenanceOrder( final MaintenanceOrder value )
    {
        toMaintenanceOrder = value;
    }

    /**
     * Helper class to allow for fluent creation of MaintOrderOpRelationship instances.
     *
     */
    public final static class MaintOrderOpRelationshipBuilder
    {

        private MaintenanceOrderOperation toMaintenanceOrderOperation;
        private String maintenanceOrderOperation = null;
        private MaintenanceOrder toMaintenanceOrder;
        private String maintenanceOrder = null;

        private MaintOrderOpRelationship.MaintOrderOpRelationshipBuilder toMaintenanceOrderOperation(
            final MaintenanceOrderOperation value )
        {
            toMaintenanceOrderOperation = value;
            return this;
        }

        /**
         * Navigation property <b>to_MaintenanceOrderOperation</b> for <b>MaintOrderOpRelationship</b> to single
         * <b>MaintenanceOrderOperation</b>.
         *
         * @param value
         *            The MaintenanceOrderOperation to build this MaintOrderOpRelationship with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintOrderOpRelationship.MaintOrderOpRelationshipBuilder maintenanceOrderOperation(
            final MaintenanceOrderOperation value )
        {
            return toMaintenanceOrderOperation(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 4
         * <p>
         * Original property name from the Odata EDM: <b>MaintenanceOrderOperation</b>
         * </p>
         *
         * @param value
         *            The maintenanceOrderOperation to build this MaintOrderOpRelationship with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintOrderOpRelationship.MaintOrderOpRelationshipBuilder maintenanceOrderOperation( final String value )
        {
            maintenanceOrderOperation = value;
            return this;
        }

        private MaintOrderOpRelationship.MaintOrderOpRelationshipBuilder toMaintenanceOrder(
            final MaintenanceOrder value )
        {
            toMaintenanceOrder = value;
            return this;
        }

        /**
         * Navigation property <b>to_MaintenanceOrder</b> for <b>MaintOrderOpRelationship</b> to single
         * <b>MaintenanceOrder</b>.
         *
         * @param value
         *            The MaintenanceOrder to build this MaintOrderOpRelationship with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintOrderOpRelationship.MaintOrderOpRelationshipBuilder maintenanceOrder( final MaintenanceOrder value )
        {
            return toMaintenanceOrder(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 12
         * <p>
         * Original property name from the Odata EDM: <b>MaintenanceOrder</b>
         * </p>
         *
         * @param value
         *            The maintenanceOrder to build this MaintOrderOpRelationship with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintOrderOpRelationship.MaintOrderOpRelationshipBuilder maintenanceOrder( final String value )
        {
            maintenanceOrder = value;
            return this;
        }

    }

}
