/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.selectable.MaintOrderOpRelationshipSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationship
 * MaintOrderOpRelationship} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class MaintOrderOpRelationshipByKeyFluentHelper
    extends
    FluentHelperByKey<MaintOrderOpRelationshipByKeyFluentHelper, MaintOrderOpRelationship, MaintOrderOpRelationshipSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationship
     * MaintOrderOpRelationship} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param maintenanceOrder
     *            Order Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code MaintOrderOpRelationship}
     * @param maintenanceOrderOperation
     *            Maintenance Order Operation
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param relatedMaintOrderOperation
     *            Maintenance Order Operation
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param orderOpRelationshipIntType
     *            Type of relationship
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param maintenanceOrderSubOperation
     *            Maintenance Order Suboperation
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code MaintOrderOpRelationship}
     * @param relatedMaintenanceOrder
     *            Order Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param maintOrdOperationIsSuccessor
     *            Indicator: Activity is successor to selected activity
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     */
    public MaintOrderOpRelationshipByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String maintenanceOrder,
        final String maintenanceOrderOperation,
        final String maintenanceOrderSubOperation,
        final Boolean maintOrdOperationIsSuccessor,
        final String relatedMaintenanceOrder,
        final String relatedMaintOrderOperation,
        final String orderOpRelationshipIntType )
    {
        super(servicePath, entityCollection);
        this.key.put("MaintenanceOrder", maintenanceOrder);
        this.key.put("MaintenanceOrderOperation", maintenanceOrderOperation);
        this.key.put("MaintenanceOrderSubOperation", maintenanceOrderSubOperation);
        this.key.put("MaintOrdOperationIsSuccessor", maintOrdOperationIsSuccessor);
        this.key.put("RelatedMaintenanceOrder", relatedMaintenanceOrder);
        this.key.put("RelatedMaintOrderOperation", relatedMaintOrderOperation);
        this.key.put("OrderOpRelationshipIntType", orderOpRelationshipIntType);
    }

    @Override
    @Nonnull
    protected Class<MaintOrderOpRelationship> getEntityClass()
    {
        return MaintOrderOpRelationship.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
