/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.field.MaintOrderSettlmtDistrRuleField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.link.MaintOrderSettlmtDistrRuleOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.selectable.MaintOrderSettlmtDistrRuleSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Maintenance Order Settlement Rule
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MaintOrderSettlmtDistrRule_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MaintOrderSettlmtDistrRule extends VdmEntity<MaintOrderSettlmtDistrRule>
{

    /**
     * Selector for all available fields of MaintOrderSettlmtDistrRule.
     *
     */
    public final static MaintOrderSettlmtDistrRuleSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrder</b>
     * </p>
     *
     * @return Order Number
     */
    @Key
    @SerializedName( "MaintenanceOrder" )
    @JsonProperty( "MaintenanceOrder" )
    @Nullable
    @ODataField( odataName = "MaintenanceOrder" )
    private String maintenanceOrder;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceOrder</b> field to query operations.
     *
     */
    public final static MaintOrderSettlmtDistrRuleField<String> MAINTENANCE_ORDER =
        new MaintOrderSettlmtDistrRuleField<String>("MaintenanceOrder");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtDistrRuleSequence</b>
     * </p>
     *
     * @return Sequence Number of Distribution Rule
     */
    @Key
    @SerializedName( "SettlmtDistrRuleSequence" )
    @JsonProperty( "SettlmtDistrRuleSequence" )
    @Nullable
    @ODataField( odataName = "SettlmtDistrRuleSequence" )
    private String settlmtDistrRuleSequence;
    /**
     * Use with available fluent helpers to apply the <b>SettlmtDistrRuleSequence</b> field to query operations.
     *
     */
    public final static MaintOrderSettlmtDistrRuleField<String> SETTLMT_DISTR_RULE_SEQUENCE =
        new MaintOrderSettlmtDistrRuleField<String>("SettlmtDistrRuleSequence");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Ledger</b>
     * </p>
     *
     * @return Ledger in General Ledger Accounting
     */
    @SerializedName( "Ledger" )
    @JsonProperty( "Ledger" )
    @Nullable
    @ODataField( odataName = "Ledger" )
    private String ledger;
    /**
     * Use with available fluent helpers to apply the <b>Ledger</b> field to query operations.
     *
     */
    public final static MaintOrderSettlmtDistrRuleField<String> LEDGER =
        new MaintOrderSettlmtDistrRuleField<String>("Ledger");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SettlementDistributionRuleGrp</b>
     * </p>
     *
     * @return Distribution Rule Group
     */
    @SerializedName( "SettlementDistributionRuleGrp" )
    @JsonProperty( "SettlementDistributionRuleGrp" )
    @Nullable
    @ODataField( odataName = "SettlementDistributionRuleGrp" )
    private String settlementDistributionRuleGrp;
    /**
     * Use with available fluent helpers to apply the <b>SettlementDistributionRuleGrp</b> field to query operations.
     *
     */
    public final static MaintOrderSettlmtDistrRuleField<String> SETTLEMENT_DISTRIBUTION_RULE_GRP =
        new MaintOrderSettlmtDistrRuleField<String>("SettlementDistributionRuleGrp");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LedgerGroup</b>
     * </p>
     *
     * @return Ledger Group
     */
    @SerializedName( "LedgerGroup" )
    @JsonProperty( "LedgerGroup" )
    @Nullable
    @ODataField( odataName = "LedgerGroup" )
    private String ledgerGroup;
    /**
     * Use with available fluent helpers to apply the <b>LedgerGroup</b> field to query operations.
     *
     */
    public final static MaintOrderSettlmtDistrRuleField<String> LEDGER_GROUP =
        new MaintOrderSettlmtDistrRuleField<String>("LedgerGroup");
    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>ControllingObject</b>
     * </p>
     *
     * @return Object Number
     */
    @SerializedName( "ControllingObject" )
    @JsonProperty( "ControllingObject" )
    @Nullable
    @ODataField( odataName = "ControllingObject" )
    private String controllingObject;
    /**
     * Use with available fluent helpers to apply the <b>ControllingObject</b> field to query operations.
     *
     */
    public final static MaintOrderSettlmtDistrRuleField<String> CONTROLLING_OBJECT =
        new MaintOrderSettlmtDistrRuleField<String>("ControllingObject");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SettlementType</b>
     * </p>
     *
     * @return Settlement type
     */
    @SerializedName( "SettlementType" )
    @JsonProperty( "SettlementType" )
    @Nullable
    @ODataField( odataName = "SettlementType" )
    private String settlementType;
    /**
     * Use with available fluent helpers to apply the <b>SettlementType</b> field to query operations.
     *
     */
    public final static MaintOrderSettlmtDistrRuleField<String> SETTLEMENT_TYPE =
        new MaintOrderSettlmtDistrRuleField<String>("SettlementType");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SettlementTypeDesc</b>
     * </p>
     *
     * @return Short Text for Fixed Values
     */
    @SerializedName( "SettlementTypeDesc" )
    @JsonProperty( "SettlementTypeDesc" )
    @Nullable
    @ODataField( odataName = "SettlementTypeDesc" )
    private String settlementTypeDesc;
    /**
     * Use with available fluent helpers to apply the <b>SettlementTypeDesc</b> field to query operations.
     *
     */
    public final static MaintOrderSettlmtDistrRuleField<String> SETTLEMENT_TYPE_DESC =
        new MaintOrderSettlmtDistrRuleField<String>("SettlementTypeDesc");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignmentType</b>
     * </p>
     *
     * @return Account Assignment Type
     */
    @SerializedName( "AccountAssignmentType" )
    @JsonProperty( "AccountAssignmentType" )
    @Nullable
    @ODataField( odataName = "AccountAssignmentType" )
    private String accountAssignmentType;
    /**
     * Use with available fluent helpers to apply the <b>AccountAssignmentType</b> field to query operations.
     *
     */
    public final static MaintOrderSettlmtDistrRuleField<String> ACCOUNT_ASSIGNMENT_TYPE =
        new MaintOrderSettlmtDistrRuleField<String>("AccountAssignmentType");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignmentTypeDesc</b>
     * </p>
     *
     * @return FIS_ACCASTY_TXT60
     */
    @SerializedName( "AccountAssignmentTypeDesc" )
    @JsonProperty( "AccountAssignmentTypeDesc" )
    @Nullable
    @ODataField( odataName = "AccountAssignmentTypeDesc" )
    private String accountAssignmentTypeDesc;
    /**
     * Use with available fluent helpers to apply the <b>AccountAssignmentTypeDesc</b> field to query operations.
     *
     */
    public final static MaintOrderSettlmtDistrRuleField<String> ACCOUNT_ASSIGNMENT_TYPE_DESC =
        new MaintOrderSettlmtDistrRuleField<String>("AccountAssignmentTypeDesc");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DistributionSourceAssignment</b>
     * </p>
     *
     * @return Source Assignment
     */
    @SerializedName( "DistributionSourceAssignment" )
    @JsonProperty( "DistributionSourceAssignment" )
    @Nullable
    @ODataField( odataName = "DistributionSourceAssignment" )
    private String distributionSourceAssignment;
    /**
     * Use with available fluent helpers to apply the <b>DistributionSourceAssignment</b> field to query operations.
     *
     */
    public final static MaintOrderSettlmtDistrRuleField<String> DISTRIBUTION_SOURCE_ASSIGNMENT =
        new MaintOrderSettlmtDistrRuleField<String>("DistributionSourceAssignment");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>SettlementPercentageRate</b>
     * </p>
     *
     * @return Settlement percentage rate
     */
    @SerializedName( "SettlementPercentageRate" )
    @JsonProperty( "SettlementPercentageRate" )
    @Nullable
    @ODataField( odataName = "SettlementPercentageRate" )
    private BigDecimal settlementPercentageRate;
    /**
     * Use with available fluent helpers to apply the <b>SettlementPercentageRate</b> field to query operations.
     *
     */
    public final static MaintOrderSettlmtDistrRuleField<BigDecimal> SETTLEMENT_PERCENTAGE_RATE =
        new MaintOrderSettlmtDistrRuleField<BigDecimal>("SettlementPercentageRate");
    /**
     * Constraints: Not nullable, Precision: 10, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>SettlementEquivalenceFactor</b>
     * </p>
     *
     * @return Equivalence number for order settlement
     */
    @SerializedName( "SettlementEquivalenceFactor" )
    @JsonProperty( "SettlementEquivalenceFactor" )
    @Nullable
    @ODataField( odataName = "SettlementEquivalenceFactor" )
    private BigDecimal settlementEquivalenceFactor;
    /**
     * Use with available fluent helpers to apply the <b>SettlementEquivalenceFactor</b> field to query operations.
     *
     */
    public final static MaintOrderSettlmtDistrRuleField<BigDecimal> SETTLEMENT_EQUIVALENCE_FACTOR =
        new MaintOrderSettlmtDistrRuleField<BigDecimal>("SettlementEquivalenceFactor");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SettlementAmount</b>
     * </p>
     *
     * @return Amount for Amount Rule
     */
    @SerializedName( "SettlementAmount" )
    @JsonProperty( "SettlementAmount" )
    @Nullable
    @ODataField( odataName = "SettlementAmount" )
    private BigDecimal settlementAmount;
    /**
     * Use with available fluent helpers to apply the <b>SettlementAmount</b> field to query operations.
     *
     */
    public final static MaintOrderSettlmtDistrRuleField<BigDecimal> SETTLEMENT_AMOUNT =
        new MaintOrderSettlmtDistrRuleField<BigDecimal>("SettlementAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SettlementAmountCurrency</b>
     * </p>
     *
     * @return Currency for the amount in the amount rule
     */
    @SerializedName( "SettlementAmountCurrency" )
    @JsonProperty( "SettlementAmountCurrency" )
    @Nullable
    @ODataField( odataName = "SettlementAmountCurrency" )
    private String settlementAmountCurrency;
    /**
     * Use with available fluent helpers to apply the <b>SettlementAmountCurrency</b> field to query operations.
     *
     */
    public final static MaintOrderSettlmtDistrRuleField<String> SETTLEMENT_AMOUNT_CURRENCY =
        new MaintOrderSettlmtDistrRuleField<String>("SettlementAmountCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Controlling area of receiver
     */
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static MaintOrderSettlmtDistrRuleField<String> CONTROLLING_AREA =
        new MaintOrderSettlmtDistrRuleField<String>("ControllingArea");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @return Business Area
     */
    @SerializedName( "BusinessArea" )
    @JsonProperty( "BusinessArea" )
    @Nullable
    @ODataField( odataName = "BusinessArea" )
    private String businessArea;
    /**
     * Use with available fluent helpers to apply the <b>BusinessArea</b> field to query operations.
     *
     */
    public final static MaintOrderSettlmtDistrRuleField<String> BUSINESS_AREA =
        new MaintOrderSettlmtDistrRuleField<String>("BusinessArea");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static MaintOrderSettlmtDistrRuleField<String> COMPANY_CODE =
        new MaintOrderSettlmtDistrRuleField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @return G/L Account Number
     */
    @SerializedName( "GLAccount" )
    @JsonProperty( "GLAccount" )
    @Nullable
    @ODataField( odataName = "GLAccount" )
    private String gLAccount;
    /**
     * Use with available fluent helpers to apply the <b>GLAccount</b> field to query operations.
     *
     */
    public final static MaintOrderSettlmtDistrRuleField<String> GL_ACCOUNT =
        new MaintOrderSettlmtDistrRuleField<String>("GLAccount");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @return Profit Center
     */
    @SerializedName( "ProfitCenter" )
    @JsonProperty( "ProfitCenter" )
    @Nullable
    @ODataField( odataName = "ProfitCenter" )
    private String profitCenter;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter</b> field to query operations.
     *
     */
    public final static MaintOrderSettlmtDistrRuleField<String> PROFIT_CENTER =
        new MaintOrderSettlmtDistrRuleField<String>("ProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @return Receiver cost center
     */
    @SerializedName( "CostCenter" )
    @JsonProperty( "CostCenter" )
    @Nullable
    @ODataField( odataName = "CostCenter" )
    private String costCenter;
    /**
     * Use with available fluent helpers to apply the <b>CostCenter</b> field to query operations.
     *
     */
    public final static MaintOrderSettlmtDistrRuleField<String> COST_CENTER =
        new MaintOrderSettlmtDistrRuleField<String>("CostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>OrderID</b>
     * </p>
     *
     * @return Order Number
     */
    @SerializedName( "OrderID" )
    @JsonProperty( "OrderID" )
    @Nullable
    @ODataField( odataName = "OrderID" )
    private String orderID;
    /**
     * Use with available fluent helpers to apply the <b>OrderID</b> field to query operations.
     *
     */
    public final static MaintOrderSettlmtDistrRuleField<String> ORDER_ID =
        new MaintOrderSettlmtDistrRuleField<String>("OrderID");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementInternalID</b>
     * </p>
     *
     * @return WBS Element
     */
    @SerializedName( "WBSElementInternalID" )
    @JsonProperty( "WBSElementInternalID" )
    @Nullable
    @ODataField( odataName = "WBSElementInternalID" )
    private String wBSElementInternalID;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementInternalID</b> field to query operations.
     *
     */
    public final static MaintOrderSettlmtDistrRuleField<String> WBS_ELEMENT_INTERNAL_ID =
        new MaintOrderSettlmtDistrRuleField<String>("WBSElementInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MasterFixedAsset</b>
     * </p>
     *
     * @return Main Asset Number
     */
    @SerializedName( "MasterFixedAsset" )
    @JsonProperty( "MasterFixedAsset" )
    @Nullable
    @ODataField( odataName = "MasterFixedAsset" )
    private String masterFixedAsset;
    /**
     * Use with available fluent helpers to apply the <b>MasterFixedAsset</b> field to query operations.
     *
     */
    public final static MaintOrderSettlmtDistrRuleField<String> MASTER_FIXED_ASSET =
        new MaintOrderSettlmtDistrRuleField<String>("MasterFixedAsset");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FixedAsset</b>
     * </p>
     *
     * @return Asset Subnumber
     */
    @SerializedName( "FixedAsset" )
    @JsonProperty( "FixedAsset" )
    @Nullable
    @ODataField( odataName = "FixedAsset" )
    private String fixedAsset;
    /**
     * Use with available fluent helpers to apply the <b>FixedAsset</b> field to query operations.
     *
     */
    public final static MaintOrderSettlmtDistrRuleField<String> FIXED_ASSET =
        new MaintOrderSettlmtDistrRuleField<String>("FixedAsset");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>NetworkNumberForAcctAssgmt</b>
     * </p>
     *
     * @return Network Number for Account Assignment
     */
    @SerializedName( "NetworkNumberForAcctAssgmt" )
    @JsonProperty( "NetworkNumberForAcctAssgmt" )
    @Nullable
    @ODataField( odataName = "NetworkNumberForAcctAssgmt" )
    private String networkNumberForAcctAssgmt;
    /**
     * Use with available fluent helpers to apply the <b>NetworkNumberForAcctAssgmt</b> field to query operations.
     *
     */
    public final static MaintOrderSettlmtDistrRuleField<String> NETWORK_NUMBER_FOR_ACCT_ASSGMT =
        new MaintOrderSettlmtDistrRuleField<String>("NetworkNumberForAcctAssgmt");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @return Sales Order Number
     */
    @SerializedName( "SalesOrder" )
    @JsonProperty( "SalesOrder" )
    @Nullable
    @ODataField( odataName = "SalesOrder" )
    private String salesOrder;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrder</b> field to query operations.
     *
     */
    public final static MaintOrderSettlmtDistrRuleField<String> SALES_ORDER =
        new MaintOrderSettlmtDistrRuleField<String>("SalesOrder");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @return Item Number in Sales Order
     */
    @SerializedName( "SalesOrderItem" )
    @JsonProperty( "SalesOrderItem" )
    @Nullable
    @ODataField( odataName = "SalesOrderItem" )
    private String salesOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderItem</b> field to query operations.
     *
     */
    public final static MaintOrderSettlmtDistrRuleField<String> SALES_ORDER_ITEM =
        new MaintOrderSettlmtDistrRuleField<String>("SalesOrderItem");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CostObject</b>
     * </p>
     *
     * @return Cost Object
     */
    @SerializedName( "CostObject" )
    @JsonProperty( "CostObject" )
    @Nullable
    @ODataField( odataName = "CostObject" )
    private String costObject;
    /**
     * Use with available fluent helpers to apply the <b>CostObject</b> field to query operations.
     *
     */
    public final static MaintOrderSettlmtDistrRuleField<String> COST_OBJECT =
        new MaintOrderSettlmtDistrRuleField<String>("CostObject");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>BusinessProcess</b>
     * </p>
     *
     * @return Business Process
     */
    @SerializedName( "BusinessProcess" )
    @JsonProperty( "BusinessProcess" )
    @Nullable
    @ODataField( odataName = "BusinessProcess" )
    private String businessProcess;
    /**
     * Use with available fluent helpers to apply the <b>BusinessProcess</b> field to query operations.
     *
     */
    public final static MaintOrderSettlmtDistrRuleField<String> BUSINESS_PROCESS =
        new MaintOrderSettlmtDistrRuleField<String>("BusinessProcess");
    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>AltvSettlmtDistrRuleSequence</b>
     * </p>
     *
     * @return Distribution Rule Number
     */
    @SerializedName( "AltvSettlmtDistrRuleSequence" )
    @JsonProperty( "AltvSettlmtDistrRuleSequence" )
    @Nullable
    @ODataField( odataName = "AltvSettlmtDistrRuleSequence" )
    private String altvSettlmtDistrRuleSequence;
    /**
     * Use with available fluent helpers to apply the <b>AltvSettlmtDistrRuleSequence</b> field to query operations.
     *
     */
    public final static MaintOrderSettlmtDistrRuleField<String> ALTV_SETTLMT_DISTR_RULE_SEQUENCE =
        new MaintOrderSettlmtDistrRuleField<String>("AltvSettlmtDistrRuleSequence");
    /**
     * Navigation property <b>to_MaintenanceOrder</b> for <b>MaintOrderSettlmtDistrRule</b> to single
     * <b>MaintenanceOrder</b>.
     *
     */
    @SerializedName( "to_MaintenanceOrder" )
    @JsonProperty( "to_MaintenanceOrder" )
    @ODataField( odataName = "to_MaintenanceOrder" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private MaintenanceOrder toMaintenanceOrder;
    /**
     * Use with available fluent helpers to apply the <b>to_MaintenanceOrder</b> navigation property to query
     * operations.
     *
     */
    public final static MaintOrderSettlmtDistrRuleOneToOneLink<MaintenanceOrder> TO_MAINTENANCE_ORDER =
        new MaintOrderSettlmtDistrRuleOneToOneLink<MaintenanceOrder>("to_MaintenanceOrder");

    @Nonnull
    @Override
    public Class<MaintOrderSettlmtDistrRule> getType()
    {
        return MaintOrderSettlmtDistrRule.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrder</b>
     * </p>
     *
     * @param maintenanceOrder
     *            Order Number
     */
    public void setMaintenanceOrder( @Nullable final String maintenanceOrder )
    {
        rememberChangedField("MaintenanceOrder", this.maintenanceOrder);
        this.maintenanceOrder = maintenanceOrder;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtDistrRuleSequence</b>
     * </p>
     *
     * @param settlmtDistrRuleSequence
     *            Sequence Number of Distribution Rule
     */
    public void setSettlmtDistrRuleSequence( @Nullable final String settlmtDistrRuleSequence )
    {
        rememberChangedField("SettlmtDistrRuleSequence", this.settlmtDistrRuleSequence);
        this.settlmtDistrRuleSequence = settlmtDistrRuleSequence;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Ledger</b>
     * </p>
     *
     * @param ledger
     *            Ledger in General Ledger Accounting
     */
    public void setLedger( @Nullable final String ledger )
    {
        rememberChangedField("Ledger", this.ledger);
        this.ledger = ledger;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SettlementDistributionRuleGrp</b>
     * </p>
     *
     * @param settlementDistributionRuleGrp
     *            Distribution Rule Group
     */
    public void setSettlementDistributionRuleGrp( @Nullable final String settlementDistributionRuleGrp )
    {
        rememberChangedField("SettlementDistributionRuleGrp", this.settlementDistributionRuleGrp);
        this.settlementDistributionRuleGrp = settlementDistributionRuleGrp;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LedgerGroup</b>
     * </p>
     *
     * @param ledgerGroup
     *            Ledger Group
     */
    public void setLedgerGroup( @Nullable final String ledgerGroup )
    {
        rememberChangedField("LedgerGroup", this.ledgerGroup);
        this.ledgerGroup = ledgerGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>ControllingObject</b>
     * </p>
     *
     * @param controllingObject
     *            Object Number
     */
    public void setControllingObject( @Nullable final String controllingObject )
    {
        rememberChangedField("ControllingObject", this.controllingObject);
        this.controllingObject = controllingObject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SettlementType</b>
     * </p>
     *
     * @param settlementType
     *            Settlement type
     */
    public void setSettlementType( @Nullable final String settlementType )
    {
        rememberChangedField("SettlementType", this.settlementType);
        this.settlementType = settlementType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SettlementTypeDesc</b>
     * </p>
     *
     * @param settlementTypeDesc
     *            Short Text for Fixed Values
     */
    public void setSettlementTypeDesc( @Nullable final String settlementTypeDesc )
    {
        rememberChangedField("SettlementTypeDesc", this.settlementTypeDesc);
        this.settlementTypeDesc = settlementTypeDesc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignmentType</b>
     * </p>
     *
     * @param accountAssignmentType
     *            Account Assignment Type
     */
    public void setAccountAssignmentType( @Nullable final String accountAssignmentType )
    {
        rememberChangedField("AccountAssignmentType", this.accountAssignmentType);
        this.accountAssignmentType = accountAssignmentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignmentTypeDesc</b>
     * </p>
     *
     * @param accountAssignmentTypeDesc
     *            FIS_ACCASTY_TXT60
     */
    public void setAccountAssignmentTypeDesc( @Nullable final String accountAssignmentTypeDesc )
    {
        rememberChangedField("AccountAssignmentTypeDesc", this.accountAssignmentTypeDesc);
        this.accountAssignmentTypeDesc = accountAssignmentTypeDesc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DistributionSourceAssignment</b>
     * </p>
     *
     * @param distributionSourceAssignment
     *            Source Assignment
     */
    public void setDistributionSourceAssignment( @Nullable final String distributionSourceAssignment )
    {
        rememberChangedField("DistributionSourceAssignment", this.distributionSourceAssignment);
        this.distributionSourceAssignment = distributionSourceAssignment;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>SettlementPercentageRate</b>
     * </p>
     *
     * @param settlementPercentageRate
     *            Settlement percentage rate
     */
    public void setSettlementPercentageRate( @Nullable final BigDecimal settlementPercentageRate )
    {
        rememberChangedField("SettlementPercentageRate", this.settlementPercentageRate);
        this.settlementPercentageRate = settlementPercentageRate;
    }

    /**
     * Constraints: Not nullable, Precision: 10, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>SettlementEquivalenceFactor</b>
     * </p>
     *
     * @param settlementEquivalenceFactor
     *            Equivalence number for order settlement
     */
    public void setSettlementEquivalenceFactor( @Nullable final BigDecimal settlementEquivalenceFactor )
    {
        rememberChangedField("SettlementEquivalenceFactor", this.settlementEquivalenceFactor);
        this.settlementEquivalenceFactor = settlementEquivalenceFactor;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SettlementAmount</b>
     * </p>
     *
     * @param settlementAmount
     *            Amount for Amount Rule
     */
    public void setSettlementAmount( @Nullable final BigDecimal settlementAmount )
    {
        rememberChangedField("SettlementAmount", this.settlementAmount);
        this.settlementAmount = settlementAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SettlementAmountCurrency</b>
     * </p>
     *
     * @param settlementAmountCurrency
     *            Currency for the amount in the amount rule
     */
    public void setSettlementAmountCurrency( @Nullable final String settlementAmountCurrency )
    {
        rememberChangedField("SettlementAmountCurrency", this.settlementAmountCurrency);
        this.settlementAmountCurrency = settlementAmountCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Controlling area of receiver
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @param businessArea
     *            Business Area
     */
    public void setBusinessArea( @Nullable final String businessArea )
    {
        rememberChangedField("BusinessArea", this.businessArea);
        this.businessArea = businessArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @param gLAccount
     *            G/L Account Number
     */
    public void setGLAccount( @Nullable final String gLAccount )
    {
        rememberChangedField("GLAccount", this.gLAccount);
        this.gLAccount = gLAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @param profitCenter
     *            Profit Center
     */
    public void setProfitCenter( @Nullable final String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @param costCenter
     *            Receiver cost center
     */
    public void setCostCenter( @Nullable final String costCenter )
    {
        rememberChangedField("CostCenter", this.costCenter);
        this.costCenter = costCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>OrderID</b>
     * </p>
     *
     * @param orderID
     *            Order Number
     */
    public void setOrderID( @Nullable final String orderID )
    {
        rememberChangedField("OrderID", this.orderID);
        this.orderID = orderID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementInternalID</b>
     * </p>
     *
     * @param wBSElementInternalID
     *            WBS Element
     */
    public void setWBSElementInternalID( @Nullable final String wBSElementInternalID )
    {
        rememberChangedField("WBSElementInternalID", this.wBSElementInternalID);
        this.wBSElementInternalID = wBSElementInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MasterFixedAsset</b>
     * </p>
     *
     * @param masterFixedAsset
     *            Main Asset Number
     */
    public void setMasterFixedAsset( @Nullable final String masterFixedAsset )
    {
        rememberChangedField("MasterFixedAsset", this.masterFixedAsset);
        this.masterFixedAsset = masterFixedAsset;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FixedAsset</b>
     * </p>
     *
     * @param fixedAsset
     *            Asset Subnumber
     */
    public void setFixedAsset( @Nullable final String fixedAsset )
    {
        rememberChangedField("FixedAsset", this.fixedAsset);
        this.fixedAsset = fixedAsset;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>NetworkNumberForAcctAssgmt</b>
     * </p>
     *
     * @param networkNumberForAcctAssgmt
     *            Network Number for Account Assignment
     */
    public void setNetworkNumberForAcctAssgmt( @Nullable final String networkNumberForAcctAssgmt )
    {
        rememberChangedField("NetworkNumberForAcctAssgmt", this.networkNumberForAcctAssgmt);
        this.networkNumberForAcctAssgmt = networkNumberForAcctAssgmt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @param salesOrder
     *            Sales Order Number
     */
    public void setSalesOrder( @Nullable final String salesOrder )
    {
        rememberChangedField("SalesOrder", this.salesOrder);
        this.salesOrder = salesOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @param salesOrderItem
     *            Item Number in Sales Order
     */
    public void setSalesOrderItem( @Nullable final String salesOrderItem )
    {
        rememberChangedField("SalesOrderItem", this.salesOrderItem);
        this.salesOrderItem = salesOrderItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CostObject</b>
     * </p>
     *
     * @param costObject
     *            Cost Object
     */
    public void setCostObject( @Nullable final String costObject )
    {
        rememberChangedField("CostObject", this.costObject);
        this.costObject = costObject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>BusinessProcess</b>
     * </p>
     *
     * @param businessProcess
     *            Business Process
     */
    public void setBusinessProcess( @Nullable final String businessProcess )
    {
        rememberChangedField("BusinessProcess", this.businessProcess);
        this.businessProcess = businessProcess;
    }

    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>AltvSettlmtDistrRuleSequence</b>
     * </p>
     *
     * @param altvSettlmtDistrRuleSequence
     *            Distribution Rule Number
     */
    public void setAltvSettlmtDistrRuleSequence( @Nullable final String altvSettlmtDistrRuleSequence )
    {
        rememberChangedField("AltvSettlmtDistrRuleSequence", this.altvSettlmtDistrRuleSequence);
        this.altvSettlmtDistrRuleSequence = altvSettlmtDistrRuleSequence;
    }

    @Override
    protected String getEntityCollection()
    {
        return "MaintOrderSettlmtDistrRule";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("MaintenanceOrder", getMaintenanceOrder());
        result.put("SettlmtDistrRuleSequence", getSettlmtDistrRuleSequence());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("MaintenanceOrder", getMaintenanceOrder());
        values.put("SettlmtDistrRuleSequence", getSettlmtDistrRuleSequence());
        values.put("Ledger", getLedger());
        values.put("SettlementDistributionRuleGrp", getSettlementDistributionRuleGrp());
        values.put("LedgerGroup", getLedgerGroup());
        values.put("ControllingObject", getControllingObject());
        values.put("SettlementType", getSettlementType());
        values.put("SettlementTypeDesc", getSettlementTypeDesc());
        values.put("AccountAssignmentType", getAccountAssignmentType());
        values.put("AccountAssignmentTypeDesc", getAccountAssignmentTypeDesc());
        values.put("DistributionSourceAssignment", getDistributionSourceAssignment());
        values.put("SettlementPercentageRate", getSettlementPercentageRate());
        values.put("SettlementEquivalenceFactor", getSettlementEquivalenceFactor());
        values.put("SettlementAmount", getSettlementAmount());
        values.put("SettlementAmountCurrency", getSettlementAmountCurrency());
        values.put("ControllingArea", getControllingArea());
        values.put("BusinessArea", getBusinessArea());
        values.put("CompanyCode", getCompanyCode());
        values.put("GLAccount", getGLAccount());
        values.put("ProfitCenter", getProfitCenter());
        values.put("CostCenter", getCostCenter());
        values.put("OrderID", getOrderID());
        values.put("WBSElementInternalID", getWBSElementInternalID());
        values.put("MasterFixedAsset", getMasterFixedAsset());
        values.put("FixedAsset", getFixedAsset());
        values.put("NetworkNumberForAcctAssgmt", getNetworkNumberForAcctAssgmt());
        values.put("SalesOrder", getSalesOrder());
        values.put("SalesOrderItem", getSalesOrderItem());
        values.put("CostObject", getCostObject());
        values.put("BusinessProcess", getBusinessProcess());
        values.put("AltvSettlmtDistrRuleSequence", getAltvSettlmtDistrRuleSequence());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("MaintenanceOrder") ) {
                final Object value = values.remove("MaintenanceOrder");
                if( (value == null) || (!value.equals(getMaintenanceOrder())) ) {
                    setMaintenanceOrder(((String) value));
                }
            }
            if( values.containsKey("SettlmtDistrRuleSequence") ) {
                final Object value = values.remove("SettlmtDistrRuleSequence");
                if( (value == null) || (!value.equals(getSettlmtDistrRuleSequence())) ) {
                    setSettlmtDistrRuleSequence(((String) value));
                }
            }
            if( values.containsKey("Ledger") ) {
                final Object value = values.remove("Ledger");
                if( (value == null) || (!value.equals(getLedger())) ) {
                    setLedger(((String) value));
                }
            }
            if( values.containsKey("SettlementDistributionRuleGrp") ) {
                final Object value = values.remove("SettlementDistributionRuleGrp");
                if( (value == null) || (!value.equals(getSettlementDistributionRuleGrp())) ) {
                    setSettlementDistributionRuleGrp(((String) value));
                }
            }
            if( values.containsKey("LedgerGroup") ) {
                final Object value = values.remove("LedgerGroup");
                if( (value == null) || (!value.equals(getLedgerGroup())) ) {
                    setLedgerGroup(((String) value));
                }
            }
            if( values.containsKey("ControllingObject") ) {
                final Object value = values.remove("ControllingObject");
                if( (value == null) || (!value.equals(getControllingObject())) ) {
                    setControllingObject(((String) value));
                }
            }
            if( values.containsKey("SettlementType") ) {
                final Object value = values.remove("SettlementType");
                if( (value == null) || (!value.equals(getSettlementType())) ) {
                    setSettlementType(((String) value));
                }
            }
            if( values.containsKey("SettlementTypeDesc") ) {
                final Object value = values.remove("SettlementTypeDesc");
                if( (value == null) || (!value.equals(getSettlementTypeDesc())) ) {
                    setSettlementTypeDesc(((String) value));
                }
            }
            if( values.containsKey("AccountAssignmentType") ) {
                final Object value = values.remove("AccountAssignmentType");
                if( (value == null) || (!value.equals(getAccountAssignmentType())) ) {
                    setAccountAssignmentType(((String) value));
                }
            }
            if( values.containsKey("AccountAssignmentTypeDesc") ) {
                final Object value = values.remove("AccountAssignmentTypeDesc");
                if( (value == null) || (!value.equals(getAccountAssignmentTypeDesc())) ) {
                    setAccountAssignmentTypeDesc(((String) value));
                }
            }
            if( values.containsKey("DistributionSourceAssignment") ) {
                final Object value = values.remove("DistributionSourceAssignment");
                if( (value == null) || (!value.equals(getDistributionSourceAssignment())) ) {
                    setDistributionSourceAssignment(((String) value));
                }
            }
            if( values.containsKey("SettlementPercentageRate") ) {
                final Object value = values.remove("SettlementPercentageRate");
                if( (value == null) || (!value.equals(getSettlementPercentageRate())) ) {
                    setSettlementPercentageRate(((BigDecimal) value));
                }
            }
            if( values.containsKey("SettlementEquivalenceFactor") ) {
                final Object value = values.remove("SettlementEquivalenceFactor");
                if( (value == null) || (!value.equals(getSettlementEquivalenceFactor())) ) {
                    setSettlementEquivalenceFactor(((BigDecimal) value));
                }
            }
            if( values.containsKey("SettlementAmount") ) {
                final Object value = values.remove("SettlementAmount");
                if( (value == null) || (!value.equals(getSettlementAmount())) ) {
                    setSettlementAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("SettlementAmountCurrency") ) {
                final Object value = values.remove("SettlementAmountCurrency");
                if( (value == null) || (!value.equals(getSettlementAmountCurrency())) ) {
                    setSettlementAmountCurrency(((String) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("BusinessArea") ) {
                final Object value = values.remove("BusinessArea");
                if( (value == null) || (!value.equals(getBusinessArea())) ) {
                    setBusinessArea(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("GLAccount") ) {
                final Object value = values.remove("GLAccount");
                if( (value == null) || (!value.equals(getGLAccount())) ) {
                    setGLAccount(((String) value));
                }
            }
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((String) value));
                }
            }
            if( values.containsKey("CostCenter") ) {
                final Object value = values.remove("CostCenter");
                if( (value == null) || (!value.equals(getCostCenter())) ) {
                    setCostCenter(((String) value));
                }
            }
            if( values.containsKey("OrderID") ) {
                final Object value = values.remove("OrderID");
                if( (value == null) || (!value.equals(getOrderID())) ) {
                    setOrderID(((String) value));
                }
            }
            if( values.containsKey("WBSElementInternalID") ) {
                final Object value = values.remove("WBSElementInternalID");
                if( (value == null) || (!value.equals(getWBSElementInternalID())) ) {
                    setWBSElementInternalID(((String) value));
                }
            }
            if( values.containsKey("MasterFixedAsset") ) {
                final Object value = values.remove("MasterFixedAsset");
                if( (value == null) || (!value.equals(getMasterFixedAsset())) ) {
                    setMasterFixedAsset(((String) value));
                }
            }
            if( values.containsKey("FixedAsset") ) {
                final Object value = values.remove("FixedAsset");
                if( (value == null) || (!value.equals(getFixedAsset())) ) {
                    setFixedAsset(((String) value));
                }
            }
            if( values.containsKey("NetworkNumberForAcctAssgmt") ) {
                final Object value = values.remove("NetworkNumberForAcctAssgmt");
                if( (value == null) || (!value.equals(getNetworkNumberForAcctAssgmt())) ) {
                    setNetworkNumberForAcctAssgmt(((String) value));
                }
            }
            if( values.containsKey("SalesOrder") ) {
                final Object value = values.remove("SalesOrder");
                if( (value == null) || (!value.equals(getSalesOrder())) ) {
                    setSalesOrder(((String) value));
                }
            }
            if( values.containsKey("SalesOrderItem") ) {
                final Object value = values.remove("SalesOrderItem");
                if( (value == null) || (!value.equals(getSalesOrderItem())) ) {
                    setSalesOrderItem(((String) value));
                }
            }
            if( values.containsKey("CostObject") ) {
                final Object value = values.remove("CostObject");
                if( (value == null) || (!value.equals(getCostObject())) ) {
                    setCostObject(((String) value));
                }
            }
            if( values.containsKey("BusinessProcess") ) {
                final Object value = values.remove("BusinessProcess");
                if( (value == null) || (!value.equals(getBusinessProcess())) ) {
                    setBusinessProcess(((String) value));
                }
            }
            if( values.containsKey("AltvSettlmtDistrRuleSequence") ) {
                final Object value = values.remove("AltvSettlmtDistrRuleSequence");
                if( (value == null) || (!value.equals(getAltvSettlmtDistrRuleSequence())) ) {
                    setAltvSettlmtDistrRuleSequence(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_MaintenanceOrder") ) {
                final Object value = (values).remove("to_MaintenanceOrder");
                if( value instanceof Map ) {
                    if( toMaintenanceOrder == null ) {
                        toMaintenanceOrder = new MaintenanceOrder();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toMaintenanceOrder.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> MaintOrderSettlmtDistrRuleField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new MaintOrderSettlmtDistrRuleField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MaintOrderSettlmtDistrRuleField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MaintOrderSettlmtDistrRuleField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceOrderService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toMaintenanceOrder != null ) {
            (values).put("to_MaintenanceOrder", toMaintenanceOrder);
        }
        return values;
    }

    /**
     * Fetches the <b>MaintenanceOrder</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_MaintenanceOrder</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>MaintenanceOrder</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceOrder fetchMaintenanceOrder()
    {
        return fetchFieldAsSingle("to_MaintenanceOrder", MaintenanceOrder.class);
    }

    /**
     * Retrieval of associated <b>MaintenanceOrder</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_MaintenanceOrder</b>.
     * <p>
     * If the navigation property <b>to_MaintenanceOrder</b> of a queried <b>MaintOrderSettlmtDistrRule</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintenanceOrder</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceOrder getMaintenanceOrderOrFetch()
    {
        if( toMaintenanceOrder == null ) {
            toMaintenanceOrder = fetchMaintenanceOrder();
        }
        return toMaintenanceOrder;
    }

    /**
     * Retrieval of associated <b>MaintenanceOrder</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_MaintenanceOrder</b>.
     * <p>
     * If the navigation property for an entity <b>MaintOrderSettlmtDistrRule</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaintenanceOrder</b> is already loaded, the result will
     *         contain the <b>MaintenanceOrder</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<MaintenanceOrder> getMaintenanceOrderIfPresent()
    {
        return Option.of(toMaintenanceOrder);
    }

    /**
     * Overwrites the associated <b>MaintenanceOrder</b> entity for the loaded navigation property
     * <b>to_MaintenanceOrder</b>.
     *
     * @param value
     *            New <b>MaintenanceOrder</b> entity.
     */
    public void setMaintenanceOrder( final MaintenanceOrder value )
    {
        toMaintenanceOrder = value;
    }

    /**
     * Helper class to allow for fluent creation of MaintOrderSettlmtDistrRule instances.
     *
     */
    public final static class MaintOrderSettlmtDistrRuleBuilder
    {

        private MaintenanceOrder toMaintenanceOrder;
        private String maintenanceOrder = null;

        private MaintOrderSettlmtDistrRule.MaintOrderSettlmtDistrRuleBuilder toMaintenanceOrder(
            final MaintenanceOrder value )
        {
            toMaintenanceOrder = value;
            return this;
        }

        /**
         * Navigation property <b>to_MaintenanceOrder</b> for <b>MaintOrderSettlmtDistrRule</b> to single
         * <b>MaintenanceOrder</b>.
         *
         * @param value
         *            The MaintenanceOrder to build this MaintOrderSettlmtDistrRule with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintOrderSettlmtDistrRule.MaintOrderSettlmtDistrRuleBuilder maintenanceOrder(
            final MaintenanceOrder value )
        {
            return toMaintenanceOrder(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 12
         * <p>
         * Original property name from the Odata EDM: <b>MaintenanceOrder</b>
         * </p>
         *
         * @param value
         *            The maintenanceOrder to build this MaintOrderSettlmtDistrRule with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintOrderSettlmtDistrRule.MaintOrderSettlmtDistrRuleBuilder maintenanceOrder( final String value )
        {
            maintenanceOrder = value;
            return this;
        }

    }

}
