/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperDelete;

/**
 * Fluent helper to delete an existing
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderSettlmtDistrRule
 * MaintOrderSettlmtDistrRule} entity in the S/4HANA system.
 * <p>
 * To perform execution, call the {@link #executeRequest executeRequest} method on the fluent helper object.
 *
 */
public class MaintOrderSettlmtDistrRuleDeleteFluentHelper
    extends
    FluentHelperDelete<MaintOrderSettlmtDistrRuleDeleteFluentHelper, MaintOrderSettlmtDistrRule>
{

    /**
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderSettlmtDistrRule
     * MaintOrderSettlmtDistrRule} entity object that will be deleted in the S/4HANA system.
     *
     */
    private final MaintOrderSettlmtDistrRule entity;

    /**
     * Creates a fluent helper object that will delete a
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderSettlmtDistrRule
     * MaintOrderSettlmtDistrRule} entity on the OData endpoint. To perform execution, call the {@link #executeRequest
     * executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            The entity collection to direct the update requests to.
     * @param servicePath
     *            The service path to direct the update requests to.
     * @param entity
     *            The MaintOrderSettlmtDistrRule to delete from the endpoint.
     */
    public MaintOrderSettlmtDistrRuleDeleteFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final MaintOrderSettlmtDistrRule entity,
        @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
        this.entity = entity;
    }

    @Override
    @Nonnull
    protected MaintOrderSettlmtDistrRule getEntity()
    {
        return entity;
    }

}
