/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder;

import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.field.MaintenanceOrderField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.link.MaintenanceOrderLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.selectable.MaintenanceOrderSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Maintenance Order
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MaintenanceOrderType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MaintenanceOrder extends VdmEntity<MaintenanceOrder>
{

    /**
     * Selector for all available fields of MaintenanceOrder.
     *
     */
    public final static MaintenanceOrderSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrder</b>
     * </p>
     *
     * @return Order Number
     */
    @Key
    @SerializedName( "MaintenanceOrder" )
    @JsonProperty( "MaintenanceOrder" )
    @Nullable
    @ODataField( odataName = "MaintenanceOrder" )
    private String maintenanceOrder;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceOrder</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> MAINTENANCE_ORDER =
        new MaintenanceOrderField<String>("MaintenanceOrder");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrderRoutingNumber</b>
     * </p>
     *
     * @return Routing number of operations in the order
     */
    @SerializedName( "MaintOrderRoutingNumber" )
    @JsonProperty( "MaintOrderRoutingNumber" )
    @Nullable
    @ODataField( odataName = "MaintOrderRoutingNumber" )
    private String maintOrderRoutingNumber;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrderRoutingNumber</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> MAINT_ORDER_ROUTING_NUMBER =
        new MaintenanceOrderField<String>("MaintOrderRoutingNumber");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderType</b>
     * </p>
     *
     * @return Order Type
     */
    @SerializedName( "MaintenanceOrderType" )
    @JsonProperty( "MaintenanceOrderType" )
    @Nullable
    @ODataField( odataName = "MaintenanceOrderType" )
    private String maintenanceOrderType;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceOrderType</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> MAINTENANCE_ORDER_TYPE =
        new MaintenanceOrderField<String>("MaintenanceOrderType");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderDesc</b>
     * </p>
     *
     * @return Description
     */
    @SerializedName( "MaintenanceOrderDesc" )
    @JsonProperty( "MaintenanceOrderDesc" )
    @Nullable
    @ODataField( odataName = "MaintenanceOrderDesc" )
    private String maintenanceOrderDesc;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceOrderDesc</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> MAINTENANCE_ORDER_DESC =
        new MaintenanceOrderField<String>("MaintenanceOrderDesc");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdBasicStartDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "MaintOrdBasicStartDateTime" )
    @JsonProperty( "MaintOrdBasicStartDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "MaintOrdBasicStartDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime maintOrdBasicStartDateTime;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrdBasicStartDateTime</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<ZonedDateTime> MAINT_ORD_BASIC_START_DATE_TIME =
        new MaintenanceOrderField<ZonedDateTime>("MaintOrdBasicStartDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdBasicEndDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "MaintOrdBasicEndDateTime" )
    @JsonProperty( "MaintOrdBasicEndDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "MaintOrdBasicEndDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime maintOrdBasicEndDateTime;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrdBasicEndDateTime</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<ZonedDateTime> MAINT_ORD_BASIC_END_DATE_TIME =
        new MaintenanceOrderField<ZonedDateTime>("MaintOrdBasicEndDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdBasicStartDate</b>
     * </p>
     *
     * @return The maintOrdBasicStartDate contained in this entity.
     */
    @SerializedName( "MaintOrdBasicStartDate" )
    @JsonProperty( "MaintOrdBasicStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "MaintOrdBasicStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime maintOrdBasicStartDate;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrdBasicStartDate</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<LocalDateTime> MAINT_ORD_BASIC_START_DATE =
        new MaintenanceOrderField<LocalDateTime>("MaintOrdBasicStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdBasicStartTime</b>
     * </p>
     *
     * @return The maintOrdBasicStartTime contained in this entity.
     */
    @SerializedName( "MaintOrdBasicStartTime" )
    @JsonProperty( "MaintOrdBasicStartTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "MaintOrdBasicStartTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime maintOrdBasicStartTime;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrdBasicStartTime</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<LocalTime> MAINT_ORD_BASIC_START_TIME =
        new MaintenanceOrderField<LocalTime>("MaintOrdBasicStartTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdBasicEndDate</b>
     * </p>
     *
     * @return The maintOrdBasicEndDate contained in this entity.
     */
    @SerializedName( "MaintOrdBasicEndDate" )
    @JsonProperty( "MaintOrdBasicEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "MaintOrdBasicEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime maintOrdBasicEndDate;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrdBasicEndDate</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<LocalDateTime> MAINT_ORD_BASIC_END_DATE =
        new MaintenanceOrderField<LocalDateTime>("MaintOrdBasicEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdBasicEndTime</b>
     * </p>
     *
     * @return The maintOrdBasicEndTime contained in this entity.
     */
    @SerializedName( "MaintOrdBasicEndTime" )
    @JsonProperty( "MaintOrdBasicEndTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "MaintOrdBasicEndTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime maintOrdBasicEndTime;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrdBasicEndTime</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<LocalTime> MAINT_ORD_BASIC_END_TIME =
        new MaintenanceOrderField<LocalTime>("MaintOrdBasicEndTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdSchedldBscStrtDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "MaintOrdSchedldBscStrtDateTime" )
    @JsonProperty( "MaintOrdSchedldBscStrtDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "MaintOrdSchedldBscStrtDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime maintOrdSchedldBscStrtDateTime;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrdSchedldBscStrtDateTime</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<ZonedDateTime> MAINT_ORD_SCHEDLD_BSC_STRT_DATE_TIME =
        new MaintenanceOrderField<ZonedDateTime>("MaintOrdSchedldBscStrtDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdSchedldBscEndDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "MaintOrdSchedldBscEndDateTime" )
    @JsonProperty( "MaintOrdSchedldBscEndDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "MaintOrdSchedldBscEndDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime maintOrdSchedldBscEndDateTime;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrdSchedldBscEndDateTime</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<ZonedDateTime> MAINT_ORD_SCHEDLD_BSC_END_DATE_TIME =
        new MaintenanceOrderField<ZonedDateTime>("MaintOrdSchedldBscEndDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ScheduledBasicStartDate</b>
     * </p>
     *
     * @return The scheduledBasicStartDate contained in this entity.
     */
    @SerializedName( "ScheduledBasicStartDate" )
    @JsonProperty( "ScheduledBasicStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ScheduledBasicStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime scheduledBasicStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ScheduledBasicStartDate</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<LocalDateTime> SCHEDULED_BASIC_START_DATE =
        new MaintenanceOrderField<LocalDateTime>("ScheduledBasicStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ScheduledBasicStartTime</b>
     * </p>
     *
     * @return The scheduledBasicStartTime contained in this entity.
     */
    @SerializedName( "ScheduledBasicStartTime" )
    @JsonProperty( "ScheduledBasicStartTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "ScheduledBasicStartTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime scheduledBasicStartTime;
    /**
     * Use with available fluent helpers to apply the <b>ScheduledBasicStartTime</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<LocalTime> SCHEDULED_BASIC_START_TIME =
        new MaintenanceOrderField<LocalTime>("ScheduledBasicStartTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ScheduledBasicEndDate</b>
     * </p>
     *
     * @return The scheduledBasicEndDate contained in this entity.
     */
    @SerializedName( "ScheduledBasicEndDate" )
    @JsonProperty( "ScheduledBasicEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ScheduledBasicEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime scheduledBasicEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ScheduledBasicEndDate</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<LocalDateTime> SCHEDULED_BASIC_END_DATE =
        new MaintenanceOrderField<LocalDateTime>("ScheduledBasicEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ScheduledBasicEndTime</b>
     * </p>
     *
     * @return The scheduledBasicEndTime contained in this entity.
     */
    @SerializedName( "ScheduledBasicEndTime" )
    @JsonProperty( "ScheduledBasicEndTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "ScheduledBasicEndTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime scheduledBasicEndTime;
    /**
     * Use with available fluent helpers to apply the <b>ScheduledBasicEndTime</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<LocalTime> SCHEDULED_BASIC_END_TIME =
        new MaintenanceOrderField<LocalTime>("ScheduledBasicEndTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrderReferenceDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "MaintOrderReferenceDateTime" )
    @JsonProperty( "MaintOrderReferenceDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "MaintOrderReferenceDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime maintOrderReferenceDateTime;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrderReferenceDateTime</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<ZonedDateTime> MAINT_ORDER_REFERENCE_DATE_TIME =
        new MaintenanceOrderField<ZonedDateTime>("MaintOrderReferenceDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrderReferenceDate</b>
     * </p>
     *
     * @return The maintOrderReferenceDate contained in this entity.
     */
    @SerializedName( "MaintOrderReferenceDate" )
    @JsonProperty( "MaintOrderReferenceDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "MaintOrderReferenceDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime maintOrderReferenceDate;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrderReferenceDate</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<LocalDateTime> MAINT_ORDER_REFERENCE_DATE =
        new MaintenanceOrderField<LocalDateTime>("MaintOrderReferenceDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrderReferenceTime</b>
     * </p>
     *
     * @return The maintOrderReferenceTime contained in this entity.
     */
    @SerializedName( "MaintOrderReferenceTime" )
    @JsonProperty( "MaintOrderReferenceTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "MaintOrderReferenceTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime maintOrderReferenceTime;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrderReferenceTime</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<LocalTime> MAINT_ORDER_REFERENCE_TIME =
        new MaintenanceOrderField<LocalTime>("MaintOrderReferenceTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceNotification</b>
     * </p>
     *
     * @return Notification Number
     */
    @SerializedName( "MaintenanceNotification" )
    @JsonProperty( "MaintenanceNotification" )
    @Nullable
    @ODataField( odataName = "MaintenanceNotification" )
    private String maintenanceNotification;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceNotification</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> MAINTENANCE_NOTIFICATION =
        new MaintenanceOrderField<String>("MaintenanceNotification");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OrdIsNotSchedldAutomatically</b>
     * </p>
     *
     * @return Indicator: Do not schedule automatically
     */
    @SerializedName( "OrdIsNotSchedldAutomatically" )
    @JsonProperty( "OrdIsNotSchedldAutomatically" )
    @Nullable
    @ODataField( odataName = "OrdIsNotSchedldAutomatically" )
    private String ordIsNotSchedldAutomatically;
    /**
     * Use with available fluent helpers to apply the <b>OrdIsNotSchedldAutomatically</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> ORD_IS_NOT_SCHEDLD_AUTOMATICALLY =
        new MaintenanceOrderField<String>("OrdIsNotSchedldAutomatically");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Controlling Area
     */
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> CONTROLLING_AREA =
        new MaintenanceOrderField<String>("ControllingArea");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MainWorkCenterInternalID</b>
     * </p>
     *
     * @return Object ID of the Work Center
     */
    @SerializedName( "MainWorkCenterInternalID" )
    @JsonProperty( "MainWorkCenterInternalID" )
    @Nullable
    @ODataField( odataName = "MainWorkCenterInternalID" )
    private String mainWorkCenterInternalID;
    /**
     * Use with available fluent helpers to apply the <b>MainWorkCenterInternalID</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> MAIN_WORK_CENTER_INTERNAL_ID =
        new MaintenanceOrderField<String>("MainWorkCenterInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MainWorkCenterTypeCode</b>
     * </p>
     *
     * @return Object Type of CIM Resources for Work Center
     */
    @SerializedName( "MainWorkCenterTypeCode" )
    @JsonProperty( "MainWorkCenterTypeCode" )
    @Nullable
    @ODataField( odataName = "MainWorkCenterTypeCode" )
    private String mainWorkCenterTypeCode;
    /**
     * Use with available fluent helpers to apply the <b>MainWorkCenterTypeCode</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> MAIN_WORK_CENTER_TYPE_CODE =
        new MaintenanceOrderField<String>("MainWorkCenterTypeCode");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MainWorkCenter</b>
     * </p>
     *
     * @return Work Center
     */
    @SerializedName( "MainWorkCenter" )
    @JsonProperty( "MainWorkCenter" )
    @Nullable
    @ODataField( odataName = "MainWorkCenter" )
    private String mainWorkCenter;
    /**
     * Use with available fluent helpers to apply the <b>MainWorkCenter</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> MAIN_WORK_CENTER =
        new MaintenanceOrderField<String>("MainWorkCenter");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MainWorkCenterPlant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "MainWorkCenterPlant" )
    @JsonProperty( "MainWorkCenterPlant" )
    @Nullable
    @ODataField( odataName = "MainWorkCenterPlant" )
    private String mainWorkCenterPlant;
    /**
     * Use with available fluent helpers to apply the <b>MainWorkCenterPlant</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> MAIN_WORK_CENTER_PLANT =
        new MaintenanceOrderField<String>("MainWorkCenterPlant");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterInternalID</b>
     * </p>
     *
     * @return Object ID of PP work center
     */
    @SerializedName( "WorkCenterInternalID" )
    @JsonProperty( "WorkCenterInternalID" )
    @Nullable
    @ODataField( odataName = "WorkCenterInternalID" )
    private String workCenterInternalID;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterInternalID</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> WORK_CENTER_INTERNAL_ID =
        new MaintenanceOrderField<String>("WorkCenterInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterTypeCode</b>
     * </p>
     *
     * @return Object types of the CIM resource
     */
    @SerializedName( "WorkCenterTypeCode" )
    @JsonProperty( "WorkCenterTypeCode" )
    @Nullable
    @ODataField( odataName = "WorkCenterTypeCode" )
    private String workCenterTypeCode;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterTypeCode</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> WORK_CENTER_TYPE_CODE =
        new MaintenanceOrderField<String>("WorkCenterTypeCode");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenter</b>
     * </p>
     *
     * @return Work Center
     */
    @SerializedName( "WorkCenter" )
    @JsonProperty( "WorkCenter" )
    @Nullable
    @ODataField( odataName = "WorkCenter" )
    private String workCenter;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenter</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> WORK_CENTER = new MaintenanceOrderField<String>("WorkCenter");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlanningPlant</b>
     * </p>
     *
     * @return Maintenance Planning Plant
     */
    @SerializedName( "MaintenancePlanningPlant" )
    @JsonProperty( "MaintenancePlanningPlant" )
    @Nullable
    @ODataField( odataName = "MaintenancePlanningPlant" )
    private String maintenancePlanningPlant;
    /**
     * Use with available fluent helpers to apply the <b>MaintenancePlanningPlant</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> MAINTENANCE_PLANNING_PLANT =
        new MaintenanceOrderField<String>("MaintenancePlanningPlant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlant</b>
     * </p>
     *
     * @return Maintenance Plant
     */
    @SerializedName( "MaintenancePlant" )
    @JsonProperty( "MaintenancePlant" )
    @Nullable
    @ODataField( odataName = "MaintenancePlant" )
    private String maintenancePlant;
    /**
     * Use with available fluent helpers to apply the <b>MaintenancePlant</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> MAINTENANCE_PLANT =
        new MaintenanceOrderField<String>("MaintenancePlant");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Assembly</b>
     * </p>
     *
     * @return Assembly
     */
    @SerializedName( "Assembly" )
    @JsonProperty( "Assembly" )
    @Nullable
    @ODataField( odataName = "Assembly" )
    private String assembly;
    /**
     * Use with available fluent helpers to apply the <b>Assembly</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> ASSEMBLY = new MaintenanceOrderField<String>("Assembly");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdProcessPhaseCode</b>
     * </p>
     *
     * @return Process Phase
     */
    @SerializedName( "MaintOrdProcessPhaseCode" )
    @JsonProperty( "MaintOrdProcessPhaseCode" )
    @Nullable
    @ODataField( odataName = "MaintOrdProcessPhaseCode" )
    private String maintOrdProcessPhaseCode;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrdProcessPhaseCode</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> MAINT_ORD_PROCESS_PHASE_CODE =
        new MaintenanceOrderField<String>("MaintOrdProcessPhaseCode");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdProcessSubPhaseCode</b>
     * </p>
     *
     * @return Process Subphase
     */
    @SerializedName( "MaintOrdProcessSubPhaseCode" )
    @JsonProperty( "MaintOrdProcessSubPhaseCode" )
    @Nullable
    @ODataField( odataName = "MaintOrdProcessSubPhaseCode" )
    private String maintOrdProcessSubPhaseCode;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrdProcessSubPhaseCode</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> MAINT_ORD_PROCESS_SUB_PHASE_CODE =
        new MaintenanceOrderField<String>("MaintOrdProcessSubPhaseCode");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @return Business Area
     */
    @SerializedName( "BusinessArea" )
    @JsonProperty( "BusinessArea" )
    @Nullable
    @ODataField( odataName = "BusinessArea" )
    private String businessArea;
    /**
     * Use with available fluent helpers to apply the <b>BusinessArea</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> BUSINESS_AREA = new MaintenanceOrderField<String>("BusinessArea");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> COMPANY_CODE = new MaintenanceOrderField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @return Cost Center
     */
    @SerializedName( "CostCenter" )
    @JsonProperty( "CostCenter" )
    @Nullable
    @ODataField( odataName = "CostCenter" )
    private String costCenter;
    /**
     * Use with available fluent helpers to apply the <b>CostCenter</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> COST_CENTER = new MaintenanceOrderField<String>("CostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostingSheet</b>
     * </p>
     *
     * @return Costing Sheet
     */
    @SerializedName( "CostingSheet" )
    @JsonProperty( "CostingSheet" )
    @Nullable
    @ODataField( odataName = "CostingSheet" )
    private String costingSheet;
    /**
     * Use with available fluent helpers to apply the <b>CostingSheet</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> COSTING_SHEET = new MaintenanceOrderField<String>("CostingSheet");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceElement</b>
     * </p>
     *
     * @return Reference Element PM/PS
     */
    @SerializedName( "ReferenceElement" )
    @JsonProperty( "ReferenceElement" )
    @Nullable
    @ODataField( odataName = "ReferenceElement" )
    private String referenceElement;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceElement</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> REFERENCE_ELEMENT =
        new MaintenanceOrderField<String>("ReferenceElement");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @return Functional Area
     */
    @SerializedName( "FunctionalArea" )
    @JsonProperty( "FunctionalArea" )
    @Nullable
    @ODataField( odataName = "FunctionalArea" )
    private String functionalArea;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalArea</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> FUNCTIONAL_AREA =
        new MaintenanceOrderField<String>("FunctionalArea");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalDeviceData</b>
     * </p>
     *
     * @return Additional Device Data
     */
    @SerializedName( "AdditionalDeviceData" )
    @JsonProperty( "AdditionalDeviceData" )
    @Nullable
    @ODataField( odataName = "AdditionalDeviceData" )
    private String additionalDeviceData;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalDeviceData</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> ADDITIONAL_DEVICE_DATA =
        new MaintenanceOrderField<String>("AdditionalDeviceData");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Equipment</b>
     * </p>
     *
     * @return Equipment Number
     */
    @SerializedName( "Equipment" )
    @JsonProperty( "Equipment" )
    @Nullable
    @ODataField( odataName = "Equipment" )
    private String equipment;
    /**
     * Use with available fluent helpers to apply the <b>Equipment</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> EQUIPMENT = new MaintenanceOrderField<String>("Equipment");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>EquipmentName</b>
     * </p>
     *
     * @return Description of technical object
     */
    @SerializedName( "EquipmentName" )
    @JsonProperty( "EquipmentName" )
    @Nullable
    @ODataField( odataName = "EquipmentName" )
    private String equipmentName;
    /**
     * Use with available fluent helpers to apply the <b>EquipmentName</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> EQUIPMENT_NAME =
        new MaintenanceOrderField<String>("EquipmentName");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocation</b>
     * </p>
     *
     * @return Functional Location
     */
    @SerializedName( "FunctionalLocation" )
    @JsonProperty( "FunctionalLocation" )
    @Nullable
    @ODataField( odataName = "FunctionalLocation" )
    private String functionalLocation;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalLocation</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> FUNCTIONAL_LOCATION =
        new MaintenanceOrderField<String>("FunctionalLocation");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderPlanningCode</b>
     * </p>
     *
     * @return Maintenance order planning indicator
     */
    @SerializedName( "MaintenanceOrderPlanningCode" )
    @JsonProperty( "MaintenanceOrderPlanningCode" )
    @Nullable
    @ODataField( odataName = "MaintenanceOrderPlanningCode" )
    private String maintenanceOrderPlanningCode;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceOrderPlanningCode</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> MAINTENANCE_ORDER_PLANNING_CODE =
        new MaintenanceOrderField<String>("MaintenanceOrderPlanningCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlannerGroup</b>
     * </p>
     *
     * @return Planner Group for Customer Service and Plant Maintenance
     */
    @SerializedName( "MaintenancePlannerGroup" )
    @JsonProperty( "MaintenancePlannerGroup" )
    @Nullable
    @ODataField( odataName = "MaintenancePlannerGroup" )
    private String maintenancePlannerGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaintenancePlannerGroup</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> MAINTENANCE_PLANNER_GROUP =
        new MaintenanceOrderField<String>("MaintenancePlannerGroup");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceActivityType</b>
     * </p>
     *
     * @return Maintenance Activity Type
     */
    @SerializedName( "MaintenanceActivityType" )
    @JsonProperty( "MaintenanceActivityType" )
    @Nullable
    @ODataField( odataName = "MaintenanceActivityType" )
    private String maintenanceActivityType;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceActivityType</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> MAINTENANCE_ACTIVITY_TYPE =
        new MaintenanceOrderField<String>("MaintenanceActivityType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintPriority</b>
     * </p>
     *
     * @return Priority
     */
    @SerializedName( "MaintPriority" )
    @JsonProperty( "MaintPriority" )
    @Nullable
    @ODataField( odataName = "MaintPriority" )
    private String maintPriority;
    /**
     * Use with available fluent helpers to apply the <b>MaintPriority</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> MAINT_PRIORITY =
        new MaintenanceOrderField<String>("MaintPriority");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaintPriorityType</b>
     * </p>
     *
     * @return Priority Type
     */
    @SerializedName( "MaintPriorityType" )
    @JsonProperty( "MaintPriorityType" )
    @Nullable
    @ODataField( odataName = "MaintPriorityType" )
    private String maintPriorityType;
    /**
     * Use with available fluent helpers to apply the <b>MaintPriorityType</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> MAINT_PRIORITY_TYPE =
        new MaintenanceOrderField<String>("MaintPriorityType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OrderProcessingGroup</b>
     * </p>
     *
     * @return Processing group
     */
    @SerializedName( "OrderProcessingGroup" )
    @JsonProperty( "OrderProcessingGroup" )
    @Nullable
    @ODataField( odataName = "OrderProcessingGroup" )
    private String orderProcessingGroup;
    /**
     * Use with available fluent helpers to apply the <b>OrderProcessingGroup</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> ORDER_PROCESSING_GROUP =
        new MaintenanceOrderField<String>("OrderProcessingGroup");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @return Profit Center
     */
    @SerializedName( "ProfitCenter" )
    @JsonProperty( "ProfitCenter" )
    @Nullable
    @ODataField( odataName = "ProfitCenter" )
    private String profitCenter;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> PROFIT_CENTER = new MaintenanceOrderField<String>("ProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ResponsibleCostCenter</b>
     * </p>
     *
     * @return Responsible Cost Center
     */
    @SerializedName( "ResponsibleCostCenter" )
    @JsonProperty( "ResponsibleCostCenter" )
    @Nullable
    @ODataField( odataName = "ResponsibleCostCenter" )
    private String responsibleCostCenter;
    /**
     * Use with available fluent helpers to apply the <b>ResponsibleCostCenter</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> RESPONSIBLE_COST_CENTER =
        new MaintenanceOrderField<String>("ResponsibleCostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceRevision</b>
     * </p>
     *
     * @return Revision for Plant Maintenance and Customer Service
     */
    @SerializedName( "MaintenanceRevision" )
    @JsonProperty( "MaintenanceRevision" )
    @Nullable
    @ODataField( odataName = "MaintenanceRevision" )
    private String maintenanceRevision;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceRevision</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> MAINTENANCE_REVISION =
        new MaintenanceOrderField<String>("MaintenanceRevision");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>SerialNumber</b>
     * </p>
     *
     * @return Serial Number
     */
    @SerializedName( "SerialNumber" )
    @JsonProperty( "SerialNumber" )
    @Nullable
    @ODataField( odataName = "SerialNumber" )
    private String serialNumber;
    /**
     * Use with available fluent helpers to apply the <b>SerialNumber</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> SERIAL_NUMBER = new MaintenanceOrderField<String>("SerialNumber");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> PRODUCT = new MaintenanceOrderField<String>("Product");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>SuperiorProjectNetwork</b>
     * </p>
     *
     * @return Number of superior network
     */
    @SerializedName( "SuperiorProjectNetwork" )
    @JsonProperty( "SuperiorProjectNetwork" )
    @Nullable
    @ODataField( odataName = "SuperiorProjectNetwork" )
    private String superiorProjectNetwork;
    /**
     * Use with available fluent helpers to apply the <b>SuperiorProjectNetwork</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> SUPERIOR_PROJECT_NETWORK =
        new MaintenanceOrderField<String>("SuperiorProjectNetwork");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OperationSystemCondition</b>
     * </p>
     *
     * @return System Condition
     */
    @SerializedName( "OperationSystemCondition" )
    @JsonProperty( "OperationSystemCondition" )
    @Nullable
    @ODataField( odataName = "OperationSystemCondition" )
    private String operationSystemCondition;
    /**
     * Use with available fluent helpers to apply the <b>OperationSystemCondition</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> OPERATION_SYSTEM_CONDITION =
        new MaintenanceOrderField<String>("OperationSystemCondition");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @return Work Breakdown Structure Element (WBS Element) Edited
     */
    @SerializedName( "WBSElement" )
    @JsonProperty( "WBSElement" )
    @Nullable
    @ODataField( odataName = "WBSElement" )
    private String wBSElement;
    /**
     * Use with available fluent helpers to apply the <b>WBSElement</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> WBS_ELEMENT = new MaintenanceOrderField<String>("WBSElement");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementInternalID</b>
     * </p>
     *
     * @return WBS Element
     */
    @SerializedName( "WBSElementInternalID" )
    @JsonProperty( "WBSElementInternalID" )
    @Nullable
    @ODataField( odataName = "WBSElementInternalID" )
    private String wBSElementInternalID;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementInternalID</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> WBS_ELEMENT_INTERNAL_ID =
        new MaintenanceOrderField<String>("WBSElementInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ControllingObjectClass</b>
     * </p>
     *
     * @return Controlling Object Class
     */
    @SerializedName( "ControllingObjectClass" )
    @JsonProperty( "ControllingObjectClass" )
    @Nullable
    @ODataField( odataName = "ControllingObjectClass" )
    private String controllingObjectClass;
    /**
     * Use with available fluent helpers to apply the <b>ControllingObjectClass</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> CONTROLLING_OBJECT_CLASS =
        new MaintenanceOrderField<String>("ControllingObjectClass");
    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderInternalID</b>
     * </p>
     *
     * @return Object Number
     */
    @SerializedName( "MaintenanceOrderInternalID" )
    @JsonProperty( "MaintenanceOrderInternalID" )
    @Nullable
    @ODataField( odataName = "MaintenanceOrderInternalID" )
    private String maintenanceOrderInternalID;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceOrderInternalID</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> MAINTENANCE_ORDER_INTERNAL_ID =
        new MaintenanceOrderField<String>("MaintenanceOrderInternalID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceObjectList</b>
     * </p>
     *
     * @return Object list number
     */
    @SerializedName( "MaintenanceObjectList" )
    @JsonProperty( "MaintenanceObjectList" )
    @Nullable
    @ODataField( odataName = "MaintenanceObjectList" )
    private Long maintenanceObjectList;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceObjectList</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<Long> MAINTENANCE_OBJECT_LIST =
        new MaintenanceOrderField<Long>("MaintenanceObjectList");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintObjectLocAcctAssgmtNmbr</b>
     * </p>
     *
     * @return Location and account assignment for technical object
     */
    @SerializedName( "MaintObjectLocAcctAssgmtNmbr" )
    @JsonProperty( "MaintObjectLocAcctAssgmtNmbr" )
    @Nullable
    @ODataField( odataName = "MaintObjectLocAcctAssgmtNmbr" )
    private String maintObjectLocAcctAssgmtNmbr;
    /**
     * Use with available fluent helpers to apply the <b>MaintObjectLocAcctAssgmtNmbr</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> MAINT_OBJECT_LOC_ACCT_ASSGMT_NMBR =
        new MaintenanceOrderField<String>("MaintObjectLocAcctAssgmtNmbr");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AssetLocation</b>
     * </p>
     *
     * @return Location of maintenance object
     */
    @SerializedName( "AssetLocation" )
    @JsonProperty( "AssetLocation" )
    @Nullable
    @ODataField( odataName = "AssetLocation" )
    private String assetLocation;
    /**
     * Use with available fluent helpers to apply the <b>AssetLocation</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> ASSET_LOCATION =
        new MaintenanceOrderField<String>("AssetLocation");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>AssetRoom</b>
     * </p>
     *
     * @return Room
     */
    @SerializedName( "AssetRoom" )
    @JsonProperty( "AssetRoom" )
    @Nullable
    @ODataField( odataName = "AssetRoom" )
    private String assetRoom;
    /**
     * Use with available fluent helpers to apply the <b>AssetRoom</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> ASSET_ROOM = new MaintenanceOrderField<String>("AssetRoom");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlantSection</b>
     * </p>
     *
     * @return Plant Section
     */
    @SerializedName( "PlantSection" )
    @JsonProperty( "PlantSection" )
    @Nullable
    @ODataField( odataName = "PlantSection" )
    private String plantSection;
    /**
     * Use with available fluent helpers to apply the <b>PlantSection</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> PLANT_SECTION = new MaintenanceOrderField<String>("PlantSection");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ABCIndicator</b>
     * </p>
     *
     * @return ABC Indicator for Technical Object
     */
    @SerializedName( "ABCIndicator" )
    @JsonProperty( "ABCIndicator" )
    @Nullable
    @ODataField( odataName = "ABCIndicator" )
    private String aBCIndicator;
    /**
     * Use with available fluent helpers to apply the <b>ABCIndicator</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> ABC_INDICATOR = new MaintenanceOrderField<String>("ABCIndicator");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>MaintObjectFreeDefinedAttrib</b>
     * </p>
     *
     * @return Sort Field
     */
    @SerializedName( "MaintObjectFreeDefinedAttrib" )
    @JsonProperty( "MaintObjectFreeDefinedAttrib" )
    @Nullable
    @ODataField( odataName = "MaintObjectFreeDefinedAttrib" )
    private String maintObjectFreeDefinedAttrib;
    /**
     * Use with available fluent helpers to apply the <b>MaintObjectFreeDefinedAttrib</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> MAINT_OBJECT_FREE_DEFINED_ATTRIB =
        new MaintenanceOrderField<String>("MaintObjectFreeDefinedAttrib");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BasicSchedulingType</b>
     * </p>
     *
     * @return Scheduling type
     */
    @SerializedName( "BasicSchedulingType" )
    @JsonProperty( "BasicSchedulingType" )
    @Nullable
    @ODataField( odataName = "BasicSchedulingType" )
    private String basicSchedulingType;
    /**
     * Use with available fluent helpers to apply the <b>BasicSchedulingType</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> BASIC_SCHEDULING_TYPE =
        new MaintenanceOrderField<String>("BasicSchedulingType");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LatestAcceptableCompletionDate</b>
     * </p>
     *
     * @return Final Due Date
     */
    @SerializedName( "LatestAcceptableCompletionDate" )
    @JsonProperty( "LatestAcceptableCompletionDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LatestAcceptableCompletionDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime latestAcceptableCompletionDate;
    /**
     * Use with available fluent helpers to apply the <b>LatestAcceptableCompletionDate</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<LocalDateTime> LATEST_ACCEPTABLE_COMPLETION_DATE =
        new MaintenanceOrderField<LocalDateTime>("LatestAcceptableCompletionDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdPersonResponsible</b>
     * </p>
     *
     * @return Person Responsible ID
     */
    @SerializedName( "MaintOrdPersonResponsible" )
    @JsonProperty( "MaintOrdPersonResponsible" )
    @Nullable
    @ODataField( odataName = "MaintOrdPersonResponsible" )
    private String maintOrdPersonResponsible;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrdPersonResponsible</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> MAINT_ORD_PERSON_RESPONSIBLE =
        new MaintenanceOrderField<String>("MaintOrdPersonResponsible");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new MaintenanceOrderField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Entered by
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> CREATED_BY_USER =
        new MaintenanceOrderField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>LocAcctAssgmtWBSElement</b>
     * </p>
     *
     * @return Work Breakdown Structure Element (WBS Element) Edited
     */
    @SerializedName( "LocAcctAssgmtWBSElement" )
    @JsonProperty( "LocAcctAssgmtWBSElement" )
    @Nullable
    @ODataField( odataName = "LocAcctAssgmtWBSElement" )
    private String locAcctAssgmtWBSElement;
    /**
     * Use with available fluent helpers to apply the <b>LocAcctAssgmtWBSElement</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> LOC_ACCT_ASSGMT_WBS_ELEMENT =
        new MaintenanceOrderField<String>("LocAcctAssgmtWBSElement");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>LocAcctAssgmtWBSElmntIntID</b>
     * </p>
     *
     * @return WBS Element
     */
    @SerializedName( "LocAcctAssgmtWBSElmntIntID" )
    @JsonProperty( "LocAcctAssgmtWBSElmntIntID" )
    @Nullable
    @ODataField( odataName = "LocAcctAssgmtWBSElmntIntID" )
    private String locAcctAssgmtWBSElmntIntID;
    /**
     * Use with available fluent helpers to apply the <b>LocAcctAssgmtWBSElmntIntID</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> LOC_ACCT_ASSGMT_WBS_ELMNT_INT_ID =
        new MaintenanceOrderField<String>("LocAcctAssgmtWBSElmntIntID");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ControllingSettlementProfile</b>
     * </p>
     *
     * @return Settlement Profile
     */
    @SerializedName( "ControllingSettlementProfile" )
    @JsonProperty( "ControllingSettlementProfile" )
    @Nullable
    @ODataField( odataName = "ControllingSettlementProfile" )
    private String controllingSettlementProfile;
    /**
     * Use with available fluent helpers to apply the <b>ControllingSettlementProfile</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> CONTROLLING_SETTLEMENT_PROFILE =
        new MaintenanceOrderField<String>("ControllingSettlementProfile");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LocAcctAssgmtBusinessArea</b>
     * </p>
     *
     * @return Business Area
     */
    @SerializedName( "LocAcctAssgmtBusinessArea" )
    @JsonProperty( "LocAcctAssgmtBusinessArea" )
    @Nullable
    @ODataField( odataName = "LocAcctAssgmtBusinessArea" )
    private String locAcctAssgmtBusinessArea;
    /**
     * Use with available fluent helpers to apply the <b>LocAcctAssgmtBusinessArea</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> LOC_ACCT_ASSGMT_BUSINESS_AREA =
        new MaintenanceOrderField<String>("LocAcctAssgmtBusinessArea");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrderProcessingContext</b>
     * </p>
     *
     * @return Additional Processing Context for Maintenance Order
     */
    @SerializedName( "MaintOrderProcessingContext" )
    @JsonProperty( "MaintOrderProcessingContext" )
    @Nullable
    @ODataField( odataName = "MaintOrderProcessingContext" )
    private String maintOrderProcessingContext;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrderProcessingContext</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> MAINT_ORDER_PROCESSING_CONTEXT =
        new MaintenanceOrderField<String>("MaintOrderProcessingContext");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SystemStatusText</b>
     * </p>
     *
     * @return System Status Line
     */
    @SerializedName( "SystemStatusText" )
    @JsonProperty( "SystemStatusText" )
    @Nullable
    @ODataField( odataName = "SystemStatusText" )
    private String systemStatusText;
    /**
     * Use with available fluent helpers to apply the <b>SystemStatusText</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> SYSTEM_STATUS_TEXT =
        new MaintenanceOrderField<String>("SystemStatusText");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>UserStatusText</b>
     * </p>
     *
     * @return User Status
     */
    @SerializedName( "UserStatusText" )
    @JsonProperty( "UserStatusText" )
    @Nullable
    @ODataField( odataName = "UserStatusText" )
    private String userStatusText;
    /**
     * Use with available fluent helpers to apply the <b>UserStatusText</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> USER_STATUS_TEXT =
        new MaintenanceOrderField<String>("UserStatusText");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>TechnicalObject</b>
     * </p>
     *
     * @return Technical Object
     */
    @SerializedName( "TechnicalObject" )
    @JsonProperty( "TechnicalObject" )
    @Nullable
    @ODataField( odataName = "TechnicalObject" )
    private String technicalObject;
    /**
     * Use with available fluent helpers to apply the <b>TechnicalObject</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> TECHNICAL_OBJECT =
        new MaintenanceOrderField<String>("TechnicalObject");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>TechnicalObjectLabel</b>
     * </p>
     *
     * @return Technical Object
     */
    @SerializedName( "TechnicalObjectLabel" )
    @JsonProperty( "TechnicalObjectLabel" )
    @Nullable
    @ODataField( odataName = "TechnicalObjectLabel" )
    private String technicalObjectLabel;
    /**
     * Use with available fluent helpers to apply the <b>TechnicalObjectLabel</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> TECHNICAL_OBJECT_LABEL =
        new MaintenanceOrderField<String>("TechnicalObjectLabel");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>TechObjIsEquipOrFuncnlLoc</b>
     * </p>
     *
     * @return Technical Object Type
     */
    @SerializedName( "TechObjIsEquipOrFuncnlLoc" )
    @JsonProperty( "TechObjIsEquipOrFuncnlLoc" )
    @Nullable
    @ODataField( odataName = "TechObjIsEquipOrFuncnlLoc" )
    private String techObjIsEquipOrFuncnlLoc;
    /**
     * Use with available fluent helpers to apply the <b>TechObjIsEquipOrFuncnlLoc</b> field to query operations.
     *
     */
    public final static MaintenanceOrderField<String> TECH_OBJ_IS_EQUIP_OR_FUNCNL_LOC =
        new MaintenanceOrderField<String>("TechObjIsEquipOrFuncnlLoc");
    /**
     * Navigation property <b>to_MaintenanceOrderLongText</b> for <b>MaintenanceOrder</b> to multiple
     * <b>MaintenanceOrderLongText</b>.
     *
     */
    @SerializedName( "to_MaintenanceOrderLongText" )
    @JsonProperty( "to_MaintenanceOrderLongText" )
    @ODataField( odataName = "to_MaintenanceOrderLongText" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MaintenanceOrderLongText> toMaintenanceOrderLongText;
    /**
     * Navigation property <b>to_MaintenanceOrderOperation</b> for <b>MaintenanceOrder</b> to multiple
     * <b>MaintenanceOrderOperation</b>.
     *
     */
    @SerializedName( "to_MaintenanceOrderOperation" )
    @JsonProperty( "to_MaintenanceOrderOperation" )
    @ODataField( odataName = "to_MaintenanceOrderOperation" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MaintenanceOrderOperation> toMaintenanceOrderOperation;
    /**
     * Navigation property <b>to_MaintenanceOrderPartner</b> for <b>MaintenanceOrder</b> to multiple
     * <b>MaintenanceOrderPartner</b>.
     *
     */
    @SerializedName( "to_MaintenanceOrderPartner" )
    @JsonProperty( "to_MaintenanceOrderPartner" )
    @ODataField( odataName = "to_MaintenanceOrderPartner" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MaintenanceOrderPartner> toMaintenanceOrderPartner;
    /**
     * Navigation property <b>to_MaintenanceOrderPhaseControl</b> for <b>MaintenanceOrder</b> to multiple
     * <b>MaintnanceOrderPhaseControl</b>.
     *
     */
    @SerializedName( "to_MaintenanceOrderPhaseControl" )
    @JsonProperty( "to_MaintenanceOrderPhaseControl" )
    @ODataField( odataName = "to_MaintenanceOrderPhaseControl" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MaintnanceOrderPhaseControl> toMaintenanceOrderPhaseControl;
    /**
     * Navigation property <b>to_MaintOrderObjectListItem</b> for <b>MaintenanceOrder</b> to multiple
     * <b>MaintOrderObjectListItem</b>.
     *
     */
    @SerializedName( "to_MaintOrderObjectListItem" )
    @JsonProperty( "to_MaintOrderObjectListItem" )
    @ODataField( odataName = "to_MaintOrderObjectListItem" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MaintOrderObjectListItem> toMaintOrderObjectListItem;
    /**
     * Navigation property <b>to_MaintOrderSettlmtDistrRule</b> for <b>MaintenanceOrder</b> to multiple
     * <b>MaintOrderSettlmtDistrRule</b>.
     *
     */
    @SerializedName( "to_MaintOrderSettlmtDistrRule" )
    @JsonProperty( "to_MaintOrderSettlmtDistrRule" )
    @ODataField( odataName = "to_MaintOrderSettlmtDistrRule" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MaintOrderSettlmtDistrRule> toMaintOrderSettlmtDistrRule;
    /**
     * Navigation property <b>to_MaintOrdSettlmtDistrRuleHist</b> for <b>MaintenanceOrder</b> to multiple
     * <b>MaintOrdSettlmtDistrRuleHist</b>.
     *
     */
    @SerializedName( "to_MaintOrdSettlmtDistrRuleHist" )
    @JsonProperty( "to_MaintOrdSettlmtDistrRuleHist" )
    @ODataField( odataName = "to_MaintOrdSettlmtDistrRuleHist" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MaintOrdSettlmtDistrRuleHist> toMaintOrdSettlmtDistrRuleHist;
    /**
     * Use with available fluent helpers to apply the <b>to_MaintenanceOrderLongText</b> navigation property to query
     * operations.
     *
     */
    public final static MaintenanceOrderLink<MaintenanceOrderLongText> TO_MAINTENANCE_ORDER_LONG_TEXT =
        new MaintenanceOrderLink<MaintenanceOrderLongText>("to_MaintenanceOrderLongText");
    /**
     * Use with available fluent helpers to apply the <b>to_MaintenanceOrderOperation</b> navigation property to query
     * operations.
     *
     */
    public final static MaintenanceOrderLink<MaintenanceOrderOperation> TO_MAINTENANCE_ORDER_OPERATION =
        new MaintenanceOrderLink<MaintenanceOrderOperation>("to_MaintenanceOrderOperation");
    /**
     * Use with available fluent helpers to apply the <b>to_MaintenanceOrderPartner</b> navigation property to query
     * operations.
     *
     */
    public final static MaintenanceOrderLink<MaintenanceOrderPartner> TO_MAINTENANCE_ORDER_PARTNER =
        new MaintenanceOrderLink<MaintenanceOrderPartner>("to_MaintenanceOrderPartner");
    /**
     * Use with available fluent helpers to apply the <b>to_MaintenanceOrderPhaseControl</b> navigation property to
     * query operations.
     *
     */
    public final static MaintenanceOrderLink<MaintnanceOrderPhaseControl> TO_MAINTENANCE_ORDER_PHASE_CONTROL =
        new MaintenanceOrderLink<MaintnanceOrderPhaseControl>("to_MaintenanceOrderPhaseControl");
    /**
     * Use with available fluent helpers to apply the <b>to_MaintOrderObjectListItem</b> navigation property to query
     * operations.
     *
     */
    public final static MaintenanceOrderLink<MaintOrderObjectListItem> TO_MAINT_ORDER_OBJECT_LIST_ITEM =
        new MaintenanceOrderLink<MaintOrderObjectListItem>("to_MaintOrderObjectListItem");
    /**
     * Use with available fluent helpers to apply the <b>to_MaintOrderSettlmtDistrRule</b> navigation property to query
     * operations.
     *
     */
    public final static MaintenanceOrderLink<MaintOrderSettlmtDistrRule> TO_MAINT_ORDER_SETTLMT_DISTR_RULE =
        new MaintenanceOrderLink<MaintOrderSettlmtDistrRule>("to_MaintOrderSettlmtDistrRule");
    /**
     * Use with available fluent helpers to apply the <b>to_MaintOrdSettlmtDistrRuleHist</b> navigation property to
     * query operations.
     *
     */
    public final static MaintenanceOrderLink<MaintOrdSettlmtDistrRuleHist> TO_MAINT_ORD_SETTLMT_DISTR_RULE_HIST =
        new MaintenanceOrderLink<MaintOrdSettlmtDistrRuleHist>("to_MaintOrdSettlmtDistrRuleHist");

    @Nonnull
    @Override
    public Class<MaintenanceOrder> getType()
    {
        return MaintenanceOrder.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrder</b>
     * </p>
     *
     * @param maintenanceOrder
     *            Order Number
     */
    public void setMaintenanceOrder( @Nullable final String maintenanceOrder )
    {
        rememberChangedField("MaintenanceOrder", this.maintenanceOrder);
        this.maintenanceOrder = maintenanceOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrderRoutingNumber</b>
     * </p>
     *
     * @param maintOrderRoutingNumber
     *            Routing number of operations in the order
     */
    public void setMaintOrderRoutingNumber( @Nullable final String maintOrderRoutingNumber )
    {
        rememberChangedField("MaintOrderRoutingNumber", this.maintOrderRoutingNumber);
        this.maintOrderRoutingNumber = maintOrderRoutingNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderType</b>
     * </p>
     *
     * @param maintenanceOrderType
     *            Order Type
     */
    public void setMaintenanceOrderType( @Nullable final String maintenanceOrderType )
    {
        rememberChangedField("MaintenanceOrderType", this.maintenanceOrderType);
        this.maintenanceOrderType = maintenanceOrderType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderDesc</b>
     * </p>
     *
     * @param maintenanceOrderDesc
     *            Description
     */
    public void setMaintenanceOrderDesc( @Nullable final String maintenanceOrderDesc )
    {
        rememberChangedField("MaintenanceOrderDesc", this.maintenanceOrderDesc);
        this.maintenanceOrderDesc = maintenanceOrderDesc;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdBasicStartDateTime</b>
     * </p>
     *
     * @param maintOrdBasicStartDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setMaintOrdBasicStartDateTime( @Nullable final ZonedDateTime maintOrdBasicStartDateTime )
    {
        rememberChangedField("MaintOrdBasicStartDateTime", this.maintOrdBasicStartDateTime);
        this.maintOrdBasicStartDateTime = maintOrdBasicStartDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdBasicEndDateTime</b>
     * </p>
     *
     * @param maintOrdBasicEndDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setMaintOrdBasicEndDateTime( @Nullable final ZonedDateTime maintOrdBasicEndDateTime )
    {
        rememberChangedField("MaintOrdBasicEndDateTime", this.maintOrdBasicEndDateTime);
        this.maintOrdBasicEndDateTime = maintOrdBasicEndDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdBasicStartDate</b>
     * </p>
     *
     * @param maintOrdBasicStartDate
     *            The maintOrdBasicStartDate to set.
     */
    public void setMaintOrdBasicStartDate( @Nullable final LocalDateTime maintOrdBasicStartDate )
    {
        rememberChangedField("MaintOrdBasicStartDate", this.maintOrdBasicStartDate);
        this.maintOrdBasicStartDate = maintOrdBasicStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdBasicStartTime</b>
     * </p>
     *
     * @param maintOrdBasicStartTime
     *            The maintOrdBasicStartTime to set.
     */
    public void setMaintOrdBasicStartTime( @Nullable final LocalTime maintOrdBasicStartTime )
    {
        rememberChangedField("MaintOrdBasicStartTime", this.maintOrdBasicStartTime);
        this.maintOrdBasicStartTime = maintOrdBasicStartTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdBasicEndDate</b>
     * </p>
     *
     * @param maintOrdBasicEndDate
     *            The maintOrdBasicEndDate to set.
     */
    public void setMaintOrdBasicEndDate( @Nullable final LocalDateTime maintOrdBasicEndDate )
    {
        rememberChangedField("MaintOrdBasicEndDate", this.maintOrdBasicEndDate);
        this.maintOrdBasicEndDate = maintOrdBasicEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdBasicEndTime</b>
     * </p>
     *
     * @param maintOrdBasicEndTime
     *            The maintOrdBasicEndTime to set.
     */
    public void setMaintOrdBasicEndTime( @Nullable final LocalTime maintOrdBasicEndTime )
    {
        rememberChangedField("MaintOrdBasicEndTime", this.maintOrdBasicEndTime);
        this.maintOrdBasicEndTime = maintOrdBasicEndTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdSchedldBscStrtDateTime</b>
     * </p>
     *
     * @param maintOrdSchedldBscStrtDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setMaintOrdSchedldBscStrtDateTime( @Nullable final ZonedDateTime maintOrdSchedldBscStrtDateTime )
    {
        rememberChangedField("MaintOrdSchedldBscStrtDateTime", this.maintOrdSchedldBscStrtDateTime);
        this.maintOrdSchedldBscStrtDateTime = maintOrdSchedldBscStrtDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdSchedldBscEndDateTime</b>
     * </p>
     *
     * @param maintOrdSchedldBscEndDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setMaintOrdSchedldBscEndDateTime( @Nullable final ZonedDateTime maintOrdSchedldBscEndDateTime )
    {
        rememberChangedField("MaintOrdSchedldBscEndDateTime", this.maintOrdSchedldBscEndDateTime);
        this.maintOrdSchedldBscEndDateTime = maintOrdSchedldBscEndDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ScheduledBasicStartDate</b>
     * </p>
     *
     * @param scheduledBasicStartDate
     *            The scheduledBasicStartDate to set.
     */
    public void setScheduledBasicStartDate( @Nullable final LocalDateTime scheduledBasicStartDate )
    {
        rememberChangedField("ScheduledBasicStartDate", this.scheduledBasicStartDate);
        this.scheduledBasicStartDate = scheduledBasicStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ScheduledBasicStartTime</b>
     * </p>
     *
     * @param scheduledBasicStartTime
     *            The scheduledBasicStartTime to set.
     */
    public void setScheduledBasicStartTime( @Nullable final LocalTime scheduledBasicStartTime )
    {
        rememberChangedField("ScheduledBasicStartTime", this.scheduledBasicStartTime);
        this.scheduledBasicStartTime = scheduledBasicStartTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ScheduledBasicEndDate</b>
     * </p>
     *
     * @param scheduledBasicEndDate
     *            The scheduledBasicEndDate to set.
     */
    public void setScheduledBasicEndDate( @Nullable final LocalDateTime scheduledBasicEndDate )
    {
        rememberChangedField("ScheduledBasicEndDate", this.scheduledBasicEndDate);
        this.scheduledBasicEndDate = scheduledBasicEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ScheduledBasicEndTime</b>
     * </p>
     *
     * @param scheduledBasicEndTime
     *            The scheduledBasicEndTime to set.
     */
    public void setScheduledBasicEndTime( @Nullable final LocalTime scheduledBasicEndTime )
    {
        rememberChangedField("ScheduledBasicEndTime", this.scheduledBasicEndTime);
        this.scheduledBasicEndTime = scheduledBasicEndTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrderReferenceDateTime</b>
     * </p>
     *
     * @param maintOrderReferenceDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setMaintOrderReferenceDateTime( @Nullable final ZonedDateTime maintOrderReferenceDateTime )
    {
        rememberChangedField("MaintOrderReferenceDateTime", this.maintOrderReferenceDateTime);
        this.maintOrderReferenceDateTime = maintOrderReferenceDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrderReferenceDate</b>
     * </p>
     *
     * @param maintOrderReferenceDate
     *            The maintOrderReferenceDate to set.
     */
    public void setMaintOrderReferenceDate( @Nullable final LocalDateTime maintOrderReferenceDate )
    {
        rememberChangedField("MaintOrderReferenceDate", this.maintOrderReferenceDate);
        this.maintOrderReferenceDate = maintOrderReferenceDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrderReferenceTime</b>
     * </p>
     *
     * @param maintOrderReferenceTime
     *            The maintOrderReferenceTime to set.
     */
    public void setMaintOrderReferenceTime( @Nullable final LocalTime maintOrderReferenceTime )
    {
        rememberChangedField("MaintOrderReferenceTime", this.maintOrderReferenceTime);
        this.maintOrderReferenceTime = maintOrderReferenceTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceNotification</b>
     * </p>
     *
     * @param maintenanceNotification
     *            Notification Number
     */
    public void setMaintenanceNotification( @Nullable final String maintenanceNotification )
    {
        rememberChangedField("MaintenanceNotification", this.maintenanceNotification);
        this.maintenanceNotification = maintenanceNotification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OrdIsNotSchedldAutomatically</b>
     * </p>
     *
     * @param ordIsNotSchedldAutomatically
     *            Indicator: Do not schedule automatically
     */
    public void setOrdIsNotSchedldAutomatically( @Nullable final String ordIsNotSchedldAutomatically )
    {
        rememberChangedField("OrdIsNotSchedldAutomatically", this.ordIsNotSchedldAutomatically);
        this.ordIsNotSchedldAutomatically = ordIsNotSchedldAutomatically;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Controlling Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MainWorkCenterInternalID</b>
     * </p>
     *
     * @param mainWorkCenterInternalID
     *            Object ID of the Work Center
     */
    public void setMainWorkCenterInternalID( @Nullable final String mainWorkCenterInternalID )
    {
        rememberChangedField("MainWorkCenterInternalID", this.mainWorkCenterInternalID);
        this.mainWorkCenterInternalID = mainWorkCenterInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MainWorkCenterTypeCode</b>
     * </p>
     *
     * @param mainWorkCenterTypeCode
     *            Object Type of CIM Resources for Work Center
     */
    public void setMainWorkCenterTypeCode( @Nullable final String mainWorkCenterTypeCode )
    {
        rememberChangedField("MainWorkCenterTypeCode", this.mainWorkCenterTypeCode);
        this.mainWorkCenterTypeCode = mainWorkCenterTypeCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MainWorkCenter</b>
     * </p>
     *
     * @param mainWorkCenter
     *            Work Center
     */
    public void setMainWorkCenter( @Nullable final String mainWorkCenter )
    {
        rememberChangedField("MainWorkCenter", this.mainWorkCenter);
        this.mainWorkCenter = mainWorkCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MainWorkCenterPlant</b>
     * </p>
     *
     * @param mainWorkCenterPlant
     *            Plant
     */
    public void setMainWorkCenterPlant( @Nullable final String mainWorkCenterPlant )
    {
        rememberChangedField("MainWorkCenterPlant", this.mainWorkCenterPlant);
        this.mainWorkCenterPlant = mainWorkCenterPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterInternalID</b>
     * </p>
     *
     * @param workCenterInternalID
     *            Object ID of PP work center
     */
    public void setWorkCenterInternalID( @Nullable final String workCenterInternalID )
    {
        rememberChangedField("WorkCenterInternalID", this.workCenterInternalID);
        this.workCenterInternalID = workCenterInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterTypeCode</b>
     * </p>
     *
     * @param workCenterTypeCode
     *            Object types of the CIM resource
     */
    public void setWorkCenterTypeCode( @Nullable final String workCenterTypeCode )
    {
        rememberChangedField("WorkCenterTypeCode", this.workCenterTypeCode);
        this.workCenterTypeCode = workCenterTypeCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenter</b>
     * </p>
     *
     * @param workCenter
     *            Work Center
     */
    public void setWorkCenter( @Nullable final String workCenter )
    {
        rememberChangedField("WorkCenter", this.workCenter);
        this.workCenter = workCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlanningPlant</b>
     * </p>
     *
     * @param maintenancePlanningPlant
     *            Maintenance Planning Plant
     */
    public void setMaintenancePlanningPlant( @Nullable final String maintenancePlanningPlant )
    {
        rememberChangedField("MaintenancePlanningPlant", this.maintenancePlanningPlant);
        this.maintenancePlanningPlant = maintenancePlanningPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlant</b>
     * </p>
     *
     * @param maintenancePlant
     *            Maintenance Plant
     */
    public void setMaintenancePlant( @Nullable final String maintenancePlant )
    {
        rememberChangedField("MaintenancePlant", this.maintenancePlant);
        this.maintenancePlant = maintenancePlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Assembly</b>
     * </p>
     *
     * @param assembly
     *            Assembly
     */
    public void setAssembly( @Nullable final String assembly )
    {
        rememberChangedField("Assembly", this.assembly);
        this.assembly = assembly;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdProcessPhaseCode</b>
     * </p>
     *
     * @param maintOrdProcessPhaseCode
     *            Process Phase
     */
    public void setMaintOrdProcessPhaseCode( @Nullable final String maintOrdProcessPhaseCode )
    {
        rememberChangedField("MaintOrdProcessPhaseCode", this.maintOrdProcessPhaseCode);
        this.maintOrdProcessPhaseCode = maintOrdProcessPhaseCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdProcessSubPhaseCode</b>
     * </p>
     *
     * @param maintOrdProcessSubPhaseCode
     *            Process Subphase
     */
    public void setMaintOrdProcessSubPhaseCode( @Nullable final String maintOrdProcessSubPhaseCode )
    {
        rememberChangedField("MaintOrdProcessSubPhaseCode", this.maintOrdProcessSubPhaseCode);
        this.maintOrdProcessSubPhaseCode = maintOrdProcessSubPhaseCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @param businessArea
     *            Business Area
     */
    public void setBusinessArea( @Nullable final String businessArea )
    {
        rememberChangedField("BusinessArea", this.businessArea);
        this.businessArea = businessArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @param costCenter
     *            Cost Center
     */
    public void setCostCenter( @Nullable final String costCenter )
    {
        rememberChangedField("CostCenter", this.costCenter);
        this.costCenter = costCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostingSheet</b>
     * </p>
     *
     * @param costingSheet
     *            Costing Sheet
     */
    public void setCostingSheet( @Nullable final String costingSheet )
    {
        rememberChangedField("CostingSheet", this.costingSheet);
        this.costingSheet = costingSheet;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceElement</b>
     * </p>
     *
     * @param referenceElement
     *            Reference Element PM/PS
     */
    public void setReferenceElement( @Nullable final String referenceElement )
    {
        rememberChangedField("ReferenceElement", this.referenceElement);
        this.referenceElement = referenceElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @param functionalArea
     *            Functional Area
     */
    public void setFunctionalArea( @Nullable final String functionalArea )
    {
        rememberChangedField("FunctionalArea", this.functionalArea);
        this.functionalArea = functionalArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalDeviceData</b>
     * </p>
     *
     * @param additionalDeviceData
     *            Additional Device Data
     */
    public void setAdditionalDeviceData( @Nullable final String additionalDeviceData )
    {
        rememberChangedField("AdditionalDeviceData", this.additionalDeviceData);
        this.additionalDeviceData = additionalDeviceData;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Equipment</b>
     * </p>
     *
     * @param equipment
     *            Equipment Number
     */
    public void setEquipment( @Nullable final String equipment )
    {
        rememberChangedField("Equipment", this.equipment);
        this.equipment = equipment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>EquipmentName</b>
     * </p>
     *
     * @param equipmentName
     *            Description of technical object
     */
    public void setEquipmentName( @Nullable final String equipmentName )
    {
        rememberChangedField("EquipmentName", this.equipmentName);
        this.equipmentName = equipmentName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocation</b>
     * </p>
     *
     * @param functionalLocation
     *            Functional Location
     */
    public void setFunctionalLocation( @Nullable final String functionalLocation )
    {
        rememberChangedField("FunctionalLocation", this.functionalLocation);
        this.functionalLocation = functionalLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderPlanningCode</b>
     * </p>
     *
     * @param maintenanceOrderPlanningCode
     *            Maintenance order planning indicator
     */
    public void setMaintenanceOrderPlanningCode( @Nullable final String maintenanceOrderPlanningCode )
    {
        rememberChangedField("MaintenanceOrderPlanningCode", this.maintenanceOrderPlanningCode);
        this.maintenanceOrderPlanningCode = maintenanceOrderPlanningCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlannerGroup</b>
     * </p>
     *
     * @param maintenancePlannerGroup
     *            Planner Group for Customer Service and Plant Maintenance
     */
    public void setMaintenancePlannerGroup( @Nullable final String maintenancePlannerGroup )
    {
        rememberChangedField("MaintenancePlannerGroup", this.maintenancePlannerGroup);
        this.maintenancePlannerGroup = maintenancePlannerGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceActivityType</b>
     * </p>
     *
     * @param maintenanceActivityType
     *            Maintenance Activity Type
     */
    public void setMaintenanceActivityType( @Nullable final String maintenanceActivityType )
    {
        rememberChangedField("MaintenanceActivityType", this.maintenanceActivityType);
        this.maintenanceActivityType = maintenanceActivityType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintPriority</b>
     * </p>
     *
     * @param maintPriority
     *            Priority
     */
    public void setMaintPriority( @Nullable final String maintPriority )
    {
        rememberChangedField("MaintPriority", this.maintPriority);
        this.maintPriority = maintPriority;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaintPriorityType</b>
     * </p>
     *
     * @param maintPriorityType
     *            Priority Type
     */
    public void setMaintPriorityType( @Nullable final String maintPriorityType )
    {
        rememberChangedField("MaintPriorityType", this.maintPriorityType);
        this.maintPriorityType = maintPriorityType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OrderProcessingGroup</b>
     * </p>
     *
     * @param orderProcessingGroup
     *            Processing group
     */
    public void setOrderProcessingGroup( @Nullable final String orderProcessingGroup )
    {
        rememberChangedField("OrderProcessingGroup", this.orderProcessingGroup);
        this.orderProcessingGroup = orderProcessingGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @param profitCenter
     *            Profit Center
     */
    public void setProfitCenter( @Nullable final String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ResponsibleCostCenter</b>
     * </p>
     *
     * @param responsibleCostCenter
     *            Responsible Cost Center
     */
    public void setResponsibleCostCenter( @Nullable final String responsibleCostCenter )
    {
        rememberChangedField("ResponsibleCostCenter", this.responsibleCostCenter);
        this.responsibleCostCenter = responsibleCostCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceRevision</b>
     * </p>
     *
     * @param maintenanceRevision
     *            Revision for Plant Maintenance and Customer Service
     */
    public void setMaintenanceRevision( @Nullable final String maintenanceRevision )
    {
        rememberChangedField("MaintenanceRevision", this.maintenanceRevision);
        this.maintenanceRevision = maintenanceRevision;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>SerialNumber</b>
     * </p>
     *
     * @param serialNumber
     *            Serial Number
     */
    public void setSerialNumber( @Nullable final String serialNumber )
    {
        rememberChangedField("SerialNumber", this.serialNumber);
        this.serialNumber = serialNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Material Number
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>SuperiorProjectNetwork</b>
     * </p>
     *
     * @param superiorProjectNetwork
     *            Number of superior network
     */
    public void setSuperiorProjectNetwork( @Nullable final String superiorProjectNetwork )
    {
        rememberChangedField("SuperiorProjectNetwork", this.superiorProjectNetwork);
        this.superiorProjectNetwork = superiorProjectNetwork;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OperationSystemCondition</b>
     * </p>
     *
     * @param operationSystemCondition
     *            System Condition
     */
    public void setOperationSystemCondition( @Nullable final String operationSystemCondition )
    {
        rememberChangedField("OperationSystemCondition", this.operationSystemCondition);
        this.operationSystemCondition = operationSystemCondition;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @param wBSElement
     *            Work Breakdown Structure Element (WBS Element) Edited
     */
    public void setWBSElement( @Nullable final String wBSElement )
    {
        rememberChangedField("WBSElement", this.wBSElement);
        this.wBSElement = wBSElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementInternalID</b>
     * </p>
     *
     * @param wBSElementInternalID
     *            WBS Element
     */
    public void setWBSElementInternalID( @Nullable final String wBSElementInternalID )
    {
        rememberChangedField("WBSElementInternalID", this.wBSElementInternalID);
        this.wBSElementInternalID = wBSElementInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ControllingObjectClass</b>
     * </p>
     *
     * @param controllingObjectClass
     *            Controlling Object Class
     */
    public void setControllingObjectClass( @Nullable final String controllingObjectClass )
    {
        rememberChangedField("ControllingObjectClass", this.controllingObjectClass);
        this.controllingObjectClass = controllingObjectClass;
    }

    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderInternalID</b>
     * </p>
     *
     * @param maintenanceOrderInternalID
     *            Object Number
     */
    public void setMaintenanceOrderInternalID( @Nullable final String maintenanceOrderInternalID )
    {
        rememberChangedField("MaintenanceOrderInternalID", this.maintenanceOrderInternalID);
        this.maintenanceOrderInternalID = maintenanceOrderInternalID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceObjectList</b>
     * </p>
     *
     * @param maintenanceObjectList
     *            Object list number
     */
    public void setMaintenanceObjectList( @Nullable final Long maintenanceObjectList )
    {
        rememberChangedField("MaintenanceObjectList", this.maintenanceObjectList);
        this.maintenanceObjectList = maintenanceObjectList;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintObjectLocAcctAssgmtNmbr</b>
     * </p>
     *
     * @param maintObjectLocAcctAssgmtNmbr
     *            Location and account assignment for technical object
     */
    public void setMaintObjectLocAcctAssgmtNmbr( @Nullable final String maintObjectLocAcctAssgmtNmbr )
    {
        rememberChangedField("MaintObjectLocAcctAssgmtNmbr", this.maintObjectLocAcctAssgmtNmbr);
        this.maintObjectLocAcctAssgmtNmbr = maintObjectLocAcctAssgmtNmbr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AssetLocation</b>
     * </p>
     *
     * @param assetLocation
     *            Location of maintenance object
     */
    public void setAssetLocation( @Nullable final String assetLocation )
    {
        rememberChangedField("AssetLocation", this.assetLocation);
        this.assetLocation = assetLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>AssetRoom</b>
     * </p>
     *
     * @param assetRoom
     *            Room
     */
    public void setAssetRoom( @Nullable final String assetRoom )
    {
        rememberChangedField("AssetRoom", this.assetRoom);
        this.assetRoom = assetRoom;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlantSection</b>
     * </p>
     *
     * @param plantSection
     *            Plant Section
     */
    public void setPlantSection( @Nullable final String plantSection )
    {
        rememberChangedField("PlantSection", this.plantSection);
        this.plantSection = plantSection;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ABCIndicator</b>
     * </p>
     *
     * @param aBCIndicator
     *            ABC Indicator for Technical Object
     */
    public void setABCIndicator( @Nullable final String aBCIndicator )
    {
        rememberChangedField("ABCIndicator", this.aBCIndicator);
        this.aBCIndicator = aBCIndicator;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>MaintObjectFreeDefinedAttrib</b>
     * </p>
     *
     * @param maintObjectFreeDefinedAttrib
     *            Sort Field
     */
    public void setMaintObjectFreeDefinedAttrib( @Nullable final String maintObjectFreeDefinedAttrib )
    {
        rememberChangedField("MaintObjectFreeDefinedAttrib", this.maintObjectFreeDefinedAttrib);
        this.maintObjectFreeDefinedAttrib = maintObjectFreeDefinedAttrib;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BasicSchedulingType</b>
     * </p>
     *
     * @param basicSchedulingType
     *            Scheduling type
     */
    public void setBasicSchedulingType( @Nullable final String basicSchedulingType )
    {
        rememberChangedField("BasicSchedulingType", this.basicSchedulingType);
        this.basicSchedulingType = basicSchedulingType;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LatestAcceptableCompletionDate</b>
     * </p>
     *
     * @param latestAcceptableCompletionDate
     *            Final Due Date
     */
    public void setLatestAcceptableCompletionDate( @Nullable final LocalDateTime latestAcceptableCompletionDate )
    {
        rememberChangedField("LatestAcceptableCompletionDate", this.latestAcceptableCompletionDate);
        this.latestAcceptableCompletionDate = latestAcceptableCompletionDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdPersonResponsible</b>
     * </p>
     *
     * @param maintOrdPersonResponsible
     *            Person Responsible ID
     */
    public void setMaintOrdPersonResponsible( @Nullable final String maintOrdPersonResponsible )
    {
        rememberChangedField("MaintOrdPersonResponsible", this.maintOrdPersonResponsible);
        this.maintOrdPersonResponsible = maintOrdPersonResponsible;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Entered by
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>LocAcctAssgmtWBSElement</b>
     * </p>
     *
     * @param locAcctAssgmtWBSElement
     *            Work Breakdown Structure Element (WBS Element) Edited
     */
    public void setLocAcctAssgmtWBSElement( @Nullable final String locAcctAssgmtWBSElement )
    {
        rememberChangedField("LocAcctAssgmtWBSElement", this.locAcctAssgmtWBSElement);
        this.locAcctAssgmtWBSElement = locAcctAssgmtWBSElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>LocAcctAssgmtWBSElmntIntID</b>
     * </p>
     *
     * @param locAcctAssgmtWBSElmntIntID
     *            WBS Element
     */
    public void setLocAcctAssgmtWBSElmntIntID( @Nullable final String locAcctAssgmtWBSElmntIntID )
    {
        rememberChangedField("LocAcctAssgmtWBSElmntIntID", this.locAcctAssgmtWBSElmntIntID);
        this.locAcctAssgmtWBSElmntIntID = locAcctAssgmtWBSElmntIntID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ControllingSettlementProfile</b>
     * </p>
     *
     * @param controllingSettlementProfile
     *            Settlement Profile
     */
    public void setControllingSettlementProfile( @Nullable final String controllingSettlementProfile )
    {
        rememberChangedField("ControllingSettlementProfile", this.controllingSettlementProfile);
        this.controllingSettlementProfile = controllingSettlementProfile;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LocAcctAssgmtBusinessArea</b>
     * </p>
     *
     * @param locAcctAssgmtBusinessArea
     *            Business Area
     */
    public void setLocAcctAssgmtBusinessArea( @Nullable final String locAcctAssgmtBusinessArea )
    {
        rememberChangedField("LocAcctAssgmtBusinessArea", this.locAcctAssgmtBusinessArea);
        this.locAcctAssgmtBusinessArea = locAcctAssgmtBusinessArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrderProcessingContext</b>
     * </p>
     *
     * @param maintOrderProcessingContext
     *            Additional Processing Context for Maintenance Order
     */
    public void setMaintOrderProcessingContext( @Nullable final String maintOrderProcessingContext )
    {
        rememberChangedField("MaintOrderProcessingContext", this.maintOrderProcessingContext);
        this.maintOrderProcessingContext = maintOrderProcessingContext;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SystemStatusText</b>
     * </p>
     *
     * @param systemStatusText
     *            System Status Line
     */
    public void setSystemStatusText( @Nullable final String systemStatusText )
    {
        rememberChangedField("SystemStatusText", this.systemStatusText);
        this.systemStatusText = systemStatusText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>UserStatusText</b>
     * </p>
     *
     * @param userStatusText
     *            User Status
     */
    public void setUserStatusText( @Nullable final String userStatusText )
    {
        rememberChangedField("UserStatusText", this.userStatusText);
        this.userStatusText = userStatusText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>TechnicalObject</b>
     * </p>
     *
     * @param technicalObject
     *            Technical Object
     */
    public void setTechnicalObject( @Nullable final String technicalObject )
    {
        rememberChangedField("TechnicalObject", this.technicalObject);
        this.technicalObject = technicalObject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>TechnicalObjectLabel</b>
     * </p>
     *
     * @param technicalObjectLabel
     *            Technical Object
     */
    public void setTechnicalObjectLabel( @Nullable final String technicalObjectLabel )
    {
        rememberChangedField("TechnicalObjectLabel", this.technicalObjectLabel);
        this.technicalObjectLabel = technicalObjectLabel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>TechObjIsEquipOrFuncnlLoc</b>
     * </p>
     *
     * @param techObjIsEquipOrFuncnlLoc
     *            Technical Object Type
     */
    public void setTechObjIsEquipOrFuncnlLoc( @Nullable final String techObjIsEquipOrFuncnlLoc )
    {
        rememberChangedField("TechObjIsEquipOrFuncnlLoc", this.techObjIsEquipOrFuncnlLoc);
        this.techObjIsEquipOrFuncnlLoc = techObjIsEquipOrFuncnlLoc;
    }

    @Override
    protected String getEntityCollection()
    {
        return "MaintenanceOrder";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("MaintenanceOrder", getMaintenanceOrder());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("MaintenanceOrder", getMaintenanceOrder());
        values.put("MaintOrderRoutingNumber", getMaintOrderRoutingNumber());
        values.put("MaintenanceOrderType", getMaintenanceOrderType());
        values.put("MaintenanceOrderDesc", getMaintenanceOrderDesc());
        values.put("MaintOrdBasicStartDateTime", getMaintOrdBasicStartDateTime());
        values.put("MaintOrdBasicEndDateTime", getMaintOrdBasicEndDateTime());
        values.put("MaintOrdBasicStartDate", getMaintOrdBasicStartDate());
        values.put("MaintOrdBasicStartTime", getMaintOrdBasicStartTime());
        values.put("MaintOrdBasicEndDate", getMaintOrdBasicEndDate());
        values.put("MaintOrdBasicEndTime", getMaintOrdBasicEndTime());
        values.put("MaintOrdSchedldBscStrtDateTime", getMaintOrdSchedldBscStrtDateTime());
        values.put("MaintOrdSchedldBscEndDateTime", getMaintOrdSchedldBscEndDateTime());
        values.put("ScheduledBasicStartDate", getScheduledBasicStartDate());
        values.put("ScheduledBasicStartTime", getScheduledBasicStartTime());
        values.put("ScheduledBasicEndDate", getScheduledBasicEndDate());
        values.put("ScheduledBasicEndTime", getScheduledBasicEndTime());
        values.put("MaintOrderReferenceDateTime", getMaintOrderReferenceDateTime());
        values.put("MaintOrderReferenceDate", getMaintOrderReferenceDate());
        values.put("MaintOrderReferenceTime", getMaintOrderReferenceTime());
        values.put("MaintenanceNotification", getMaintenanceNotification());
        values.put("OrdIsNotSchedldAutomatically", getOrdIsNotSchedldAutomatically());
        values.put("ControllingArea", getControllingArea());
        values.put("MainWorkCenterInternalID", getMainWorkCenterInternalID());
        values.put("MainWorkCenterTypeCode", getMainWorkCenterTypeCode());
        values.put("MainWorkCenter", getMainWorkCenter());
        values.put("MainWorkCenterPlant", getMainWorkCenterPlant());
        values.put("WorkCenterInternalID", getWorkCenterInternalID());
        values.put("WorkCenterTypeCode", getWorkCenterTypeCode());
        values.put("WorkCenter", getWorkCenter());
        values.put("MaintenancePlanningPlant", getMaintenancePlanningPlant());
        values.put("MaintenancePlant", getMaintenancePlant());
        values.put("Assembly", getAssembly());
        values.put("MaintOrdProcessPhaseCode", getMaintOrdProcessPhaseCode());
        values.put("MaintOrdProcessSubPhaseCode", getMaintOrdProcessSubPhaseCode());
        values.put("BusinessArea", getBusinessArea());
        values.put("CompanyCode", getCompanyCode());
        values.put("CostCenter", getCostCenter());
        values.put("CostingSheet", getCostingSheet());
        values.put("ReferenceElement", getReferenceElement());
        values.put("FunctionalArea", getFunctionalArea());
        values.put("AdditionalDeviceData", getAdditionalDeviceData());
        values.put("Equipment", getEquipment());
        values.put("EquipmentName", getEquipmentName());
        values.put("FunctionalLocation", getFunctionalLocation());
        values.put("MaintenanceOrderPlanningCode", getMaintenanceOrderPlanningCode());
        values.put("MaintenancePlannerGroup", getMaintenancePlannerGroup());
        values.put("MaintenanceActivityType", getMaintenanceActivityType());
        values.put("MaintPriority", getMaintPriority());
        values.put("MaintPriorityType", getMaintPriorityType());
        values.put("OrderProcessingGroup", getOrderProcessingGroup());
        values.put("ProfitCenter", getProfitCenter());
        values.put("ResponsibleCostCenter", getResponsibleCostCenter());
        values.put("MaintenanceRevision", getMaintenanceRevision());
        values.put("SerialNumber", getSerialNumber());
        values.put("Product", getProduct());
        values.put("SuperiorProjectNetwork", getSuperiorProjectNetwork());
        values.put("OperationSystemCondition", getOperationSystemCondition());
        values.put("WBSElement", getWBSElement());
        values.put("WBSElementInternalID", getWBSElementInternalID());
        values.put("ControllingObjectClass", getControllingObjectClass());
        values.put("MaintenanceOrderInternalID", getMaintenanceOrderInternalID());
        values.put("MaintenanceObjectList", getMaintenanceObjectList());
        values.put("MaintObjectLocAcctAssgmtNmbr", getMaintObjectLocAcctAssgmtNmbr());
        values.put("AssetLocation", getAssetLocation());
        values.put("AssetRoom", getAssetRoom());
        values.put("PlantSection", getPlantSection());
        values.put("ABCIndicator", getABCIndicator());
        values.put("MaintObjectFreeDefinedAttrib", getMaintObjectFreeDefinedAttrib());
        values.put("BasicSchedulingType", getBasicSchedulingType());
        values.put("LatestAcceptableCompletionDate", getLatestAcceptableCompletionDate());
        values.put("MaintOrdPersonResponsible", getMaintOrdPersonResponsible());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("LocAcctAssgmtWBSElement", getLocAcctAssgmtWBSElement());
        values.put("LocAcctAssgmtWBSElmntIntID", getLocAcctAssgmtWBSElmntIntID());
        values.put("ControllingSettlementProfile", getControllingSettlementProfile());
        values.put("LocAcctAssgmtBusinessArea", getLocAcctAssgmtBusinessArea());
        values.put("MaintOrderProcessingContext", getMaintOrderProcessingContext());
        values.put("SystemStatusText", getSystemStatusText());
        values.put("UserStatusText", getUserStatusText());
        values.put("TechnicalObject", getTechnicalObject());
        values.put("TechnicalObjectLabel", getTechnicalObjectLabel());
        values.put("TechObjIsEquipOrFuncnlLoc", getTechObjIsEquipOrFuncnlLoc());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("MaintenanceOrder") ) {
                final Object value = values.remove("MaintenanceOrder");
                if( (value == null) || (!value.equals(getMaintenanceOrder())) ) {
                    setMaintenanceOrder(((String) value));
                }
            }
            if( values.containsKey("MaintOrderRoutingNumber") ) {
                final Object value = values.remove("MaintOrderRoutingNumber");
                if( (value == null) || (!value.equals(getMaintOrderRoutingNumber())) ) {
                    setMaintOrderRoutingNumber(((String) value));
                }
            }
            if( values.containsKey("MaintenanceOrderType") ) {
                final Object value = values.remove("MaintenanceOrderType");
                if( (value == null) || (!value.equals(getMaintenanceOrderType())) ) {
                    setMaintenanceOrderType(((String) value));
                }
            }
            if( values.containsKey("MaintenanceOrderDesc") ) {
                final Object value = values.remove("MaintenanceOrderDesc");
                if( (value == null) || (!value.equals(getMaintenanceOrderDesc())) ) {
                    setMaintenanceOrderDesc(((String) value));
                }
            }
            if( values.containsKey("MaintOrdBasicStartDateTime") ) {
                final Object value = values.remove("MaintOrdBasicStartDateTime");
                if( (value == null) || (!value.equals(getMaintOrdBasicStartDateTime())) ) {
                    setMaintOrdBasicStartDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("MaintOrdBasicEndDateTime") ) {
                final Object value = values.remove("MaintOrdBasicEndDateTime");
                if( (value == null) || (!value.equals(getMaintOrdBasicEndDateTime())) ) {
                    setMaintOrdBasicEndDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("MaintOrdBasicStartDate") ) {
                final Object value = values.remove("MaintOrdBasicStartDate");
                if( (value == null) || (!value.equals(getMaintOrdBasicStartDate())) ) {
                    setMaintOrdBasicStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("MaintOrdBasicStartTime") ) {
                final Object value = values.remove("MaintOrdBasicStartTime");
                if( (value == null) || (!value.equals(getMaintOrdBasicStartTime())) ) {
                    setMaintOrdBasicStartTime(((LocalTime) value));
                }
            }
            if( values.containsKey("MaintOrdBasicEndDate") ) {
                final Object value = values.remove("MaintOrdBasicEndDate");
                if( (value == null) || (!value.equals(getMaintOrdBasicEndDate())) ) {
                    setMaintOrdBasicEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("MaintOrdBasicEndTime") ) {
                final Object value = values.remove("MaintOrdBasicEndTime");
                if( (value == null) || (!value.equals(getMaintOrdBasicEndTime())) ) {
                    setMaintOrdBasicEndTime(((LocalTime) value));
                }
            }
            if( values.containsKey("MaintOrdSchedldBscStrtDateTime") ) {
                final Object value = values.remove("MaintOrdSchedldBscStrtDateTime");
                if( (value == null) || (!value.equals(getMaintOrdSchedldBscStrtDateTime())) ) {
                    setMaintOrdSchedldBscStrtDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("MaintOrdSchedldBscEndDateTime") ) {
                final Object value = values.remove("MaintOrdSchedldBscEndDateTime");
                if( (value == null) || (!value.equals(getMaintOrdSchedldBscEndDateTime())) ) {
                    setMaintOrdSchedldBscEndDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("ScheduledBasicStartDate") ) {
                final Object value = values.remove("ScheduledBasicStartDate");
                if( (value == null) || (!value.equals(getScheduledBasicStartDate())) ) {
                    setScheduledBasicStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ScheduledBasicStartTime") ) {
                final Object value = values.remove("ScheduledBasicStartTime");
                if( (value == null) || (!value.equals(getScheduledBasicStartTime())) ) {
                    setScheduledBasicStartTime(((LocalTime) value));
                }
            }
            if( values.containsKey("ScheduledBasicEndDate") ) {
                final Object value = values.remove("ScheduledBasicEndDate");
                if( (value == null) || (!value.equals(getScheduledBasicEndDate())) ) {
                    setScheduledBasicEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ScheduledBasicEndTime") ) {
                final Object value = values.remove("ScheduledBasicEndTime");
                if( (value == null) || (!value.equals(getScheduledBasicEndTime())) ) {
                    setScheduledBasicEndTime(((LocalTime) value));
                }
            }
            if( values.containsKey("MaintOrderReferenceDateTime") ) {
                final Object value = values.remove("MaintOrderReferenceDateTime");
                if( (value == null) || (!value.equals(getMaintOrderReferenceDateTime())) ) {
                    setMaintOrderReferenceDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("MaintOrderReferenceDate") ) {
                final Object value = values.remove("MaintOrderReferenceDate");
                if( (value == null) || (!value.equals(getMaintOrderReferenceDate())) ) {
                    setMaintOrderReferenceDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("MaintOrderReferenceTime") ) {
                final Object value = values.remove("MaintOrderReferenceTime");
                if( (value == null) || (!value.equals(getMaintOrderReferenceTime())) ) {
                    setMaintOrderReferenceTime(((LocalTime) value));
                }
            }
            if( values.containsKey("MaintenanceNotification") ) {
                final Object value = values.remove("MaintenanceNotification");
                if( (value == null) || (!value.equals(getMaintenanceNotification())) ) {
                    setMaintenanceNotification(((String) value));
                }
            }
            if( values.containsKey("OrdIsNotSchedldAutomatically") ) {
                final Object value = values.remove("OrdIsNotSchedldAutomatically");
                if( (value == null) || (!value.equals(getOrdIsNotSchedldAutomatically())) ) {
                    setOrdIsNotSchedldAutomatically(((String) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("MainWorkCenterInternalID") ) {
                final Object value = values.remove("MainWorkCenterInternalID");
                if( (value == null) || (!value.equals(getMainWorkCenterInternalID())) ) {
                    setMainWorkCenterInternalID(((String) value));
                }
            }
            if( values.containsKey("MainWorkCenterTypeCode") ) {
                final Object value = values.remove("MainWorkCenterTypeCode");
                if( (value == null) || (!value.equals(getMainWorkCenterTypeCode())) ) {
                    setMainWorkCenterTypeCode(((String) value));
                }
            }
            if( values.containsKey("MainWorkCenter") ) {
                final Object value = values.remove("MainWorkCenter");
                if( (value == null) || (!value.equals(getMainWorkCenter())) ) {
                    setMainWorkCenter(((String) value));
                }
            }
            if( values.containsKey("MainWorkCenterPlant") ) {
                final Object value = values.remove("MainWorkCenterPlant");
                if( (value == null) || (!value.equals(getMainWorkCenterPlant())) ) {
                    setMainWorkCenterPlant(((String) value));
                }
            }
            if( values.containsKey("WorkCenterInternalID") ) {
                final Object value = values.remove("WorkCenterInternalID");
                if( (value == null) || (!value.equals(getWorkCenterInternalID())) ) {
                    setWorkCenterInternalID(((String) value));
                }
            }
            if( values.containsKey("WorkCenterTypeCode") ) {
                final Object value = values.remove("WorkCenterTypeCode");
                if( (value == null) || (!value.equals(getWorkCenterTypeCode())) ) {
                    setWorkCenterTypeCode(((String) value));
                }
            }
            if( values.containsKey("WorkCenter") ) {
                final Object value = values.remove("WorkCenter");
                if( (value == null) || (!value.equals(getWorkCenter())) ) {
                    setWorkCenter(((String) value));
                }
            }
            if( values.containsKey("MaintenancePlanningPlant") ) {
                final Object value = values.remove("MaintenancePlanningPlant");
                if( (value == null) || (!value.equals(getMaintenancePlanningPlant())) ) {
                    setMaintenancePlanningPlant(((String) value));
                }
            }
            if( values.containsKey("MaintenancePlant") ) {
                final Object value = values.remove("MaintenancePlant");
                if( (value == null) || (!value.equals(getMaintenancePlant())) ) {
                    setMaintenancePlant(((String) value));
                }
            }
            if( values.containsKey("Assembly") ) {
                final Object value = values.remove("Assembly");
                if( (value == null) || (!value.equals(getAssembly())) ) {
                    setAssembly(((String) value));
                }
            }
            if( values.containsKey("MaintOrdProcessPhaseCode") ) {
                final Object value = values.remove("MaintOrdProcessPhaseCode");
                if( (value == null) || (!value.equals(getMaintOrdProcessPhaseCode())) ) {
                    setMaintOrdProcessPhaseCode(((String) value));
                }
            }
            if( values.containsKey("MaintOrdProcessSubPhaseCode") ) {
                final Object value = values.remove("MaintOrdProcessSubPhaseCode");
                if( (value == null) || (!value.equals(getMaintOrdProcessSubPhaseCode())) ) {
                    setMaintOrdProcessSubPhaseCode(((String) value));
                }
            }
            if( values.containsKey("BusinessArea") ) {
                final Object value = values.remove("BusinessArea");
                if( (value == null) || (!value.equals(getBusinessArea())) ) {
                    setBusinessArea(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("CostCenter") ) {
                final Object value = values.remove("CostCenter");
                if( (value == null) || (!value.equals(getCostCenter())) ) {
                    setCostCenter(((String) value));
                }
            }
            if( values.containsKey("CostingSheet") ) {
                final Object value = values.remove("CostingSheet");
                if( (value == null) || (!value.equals(getCostingSheet())) ) {
                    setCostingSheet(((String) value));
                }
            }
            if( values.containsKey("ReferenceElement") ) {
                final Object value = values.remove("ReferenceElement");
                if( (value == null) || (!value.equals(getReferenceElement())) ) {
                    setReferenceElement(((String) value));
                }
            }
            if( values.containsKey("FunctionalArea") ) {
                final Object value = values.remove("FunctionalArea");
                if( (value == null) || (!value.equals(getFunctionalArea())) ) {
                    setFunctionalArea(((String) value));
                }
            }
            if( values.containsKey("AdditionalDeviceData") ) {
                final Object value = values.remove("AdditionalDeviceData");
                if( (value == null) || (!value.equals(getAdditionalDeviceData())) ) {
                    setAdditionalDeviceData(((String) value));
                }
            }
            if( values.containsKey("Equipment") ) {
                final Object value = values.remove("Equipment");
                if( (value == null) || (!value.equals(getEquipment())) ) {
                    setEquipment(((String) value));
                }
            }
            if( values.containsKey("EquipmentName") ) {
                final Object value = values.remove("EquipmentName");
                if( (value == null) || (!value.equals(getEquipmentName())) ) {
                    setEquipmentName(((String) value));
                }
            }
            if( values.containsKey("FunctionalLocation") ) {
                final Object value = values.remove("FunctionalLocation");
                if( (value == null) || (!value.equals(getFunctionalLocation())) ) {
                    setFunctionalLocation(((String) value));
                }
            }
            if( values.containsKey("MaintenanceOrderPlanningCode") ) {
                final Object value = values.remove("MaintenanceOrderPlanningCode");
                if( (value == null) || (!value.equals(getMaintenanceOrderPlanningCode())) ) {
                    setMaintenanceOrderPlanningCode(((String) value));
                }
            }
            if( values.containsKey("MaintenancePlannerGroup") ) {
                final Object value = values.remove("MaintenancePlannerGroup");
                if( (value == null) || (!value.equals(getMaintenancePlannerGroup())) ) {
                    setMaintenancePlannerGroup(((String) value));
                }
            }
            if( values.containsKey("MaintenanceActivityType") ) {
                final Object value = values.remove("MaintenanceActivityType");
                if( (value == null) || (!value.equals(getMaintenanceActivityType())) ) {
                    setMaintenanceActivityType(((String) value));
                }
            }
            if( values.containsKey("MaintPriority") ) {
                final Object value = values.remove("MaintPriority");
                if( (value == null) || (!value.equals(getMaintPriority())) ) {
                    setMaintPriority(((String) value));
                }
            }
            if( values.containsKey("MaintPriorityType") ) {
                final Object value = values.remove("MaintPriorityType");
                if( (value == null) || (!value.equals(getMaintPriorityType())) ) {
                    setMaintPriorityType(((String) value));
                }
            }
            if( values.containsKey("OrderProcessingGroup") ) {
                final Object value = values.remove("OrderProcessingGroup");
                if( (value == null) || (!value.equals(getOrderProcessingGroup())) ) {
                    setOrderProcessingGroup(((String) value));
                }
            }
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((String) value));
                }
            }
            if( values.containsKey("ResponsibleCostCenter") ) {
                final Object value = values.remove("ResponsibleCostCenter");
                if( (value == null) || (!value.equals(getResponsibleCostCenter())) ) {
                    setResponsibleCostCenter(((String) value));
                }
            }
            if( values.containsKey("MaintenanceRevision") ) {
                final Object value = values.remove("MaintenanceRevision");
                if( (value == null) || (!value.equals(getMaintenanceRevision())) ) {
                    setMaintenanceRevision(((String) value));
                }
            }
            if( values.containsKey("SerialNumber") ) {
                final Object value = values.remove("SerialNumber");
                if( (value == null) || (!value.equals(getSerialNumber())) ) {
                    setSerialNumber(((String) value));
                }
            }
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("SuperiorProjectNetwork") ) {
                final Object value = values.remove("SuperiorProjectNetwork");
                if( (value == null) || (!value.equals(getSuperiorProjectNetwork())) ) {
                    setSuperiorProjectNetwork(((String) value));
                }
            }
            if( values.containsKey("OperationSystemCondition") ) {
                final Object value = values.remove("OperationSystemCondition");
                if( (value == null) || (!value.equals(getOperationSystemCondition())) ) {
                    setOperationSystemCondition(((String) value));
                }
            }
            if( values.containsKey("WBSElement") ) {
                final Object value = values.remove("WBSElement");
                if( (value == null) || (!value.equals(getWBSElement())) ) {
                    setWBSElement(((String) value));
                }
            }
            if( values.containsKey("WBSElementInternalID") ) {
                final Object value = values.remove("WBSElementInternalID");
                if( (value == null) || (!value.equals(getWBSElementInternalID())) ) {
                    setWBSElementInternalID(((String) value));
                }
            }
            if( values.containsKey("ControllingObjectClass") ) {
                final Object value = values.remove("ControllingObjectClass");
                if( (value == null) || (!value.equals(getControllingObjectClass())) ) {
                    setControllingObjectClass(((String) value));
                }
            }
            if( values.containsKey("MaintenanceOrderInternalID") ) {
                final Object value = values.remove("MaintenanceOrderInternalID");
                if( (value == null) || (!value.equals(getMaintenanceOrderInternalID())) ) {
                    setMaintenanceOrderInternalID(((String) value));
                }
            }
            if( values.containsKey("MaintenanceObjectList") ) {
                final Object value = values.remove("MaintenanceObjectList");
                if( (value == null) || (!value.equals(getMaintenanceObjectList())) ) {
                    setMaintenanceObjectList(((Long) value));
                }
            }
            if( values.containsKey("MaintObjectLocAcctAssgmtNmbr") ) {
                final Object value = values.remove("MaintObjectLocAcctAssgmtNmbr");
                if( (value == null) || (!value.equals(getMaintObjectLocAcctAssgmtNmbr())) ) {
                    setMaintObjectLocAcctAssgmtNmbr(((String) value));
                }
            }
            if( values.containsKey("AssetLocation") ) {
                final Object value = values.remove("AssetLocation");
                if( (value == null) || (!value.equals(getAssetLocation())) ) {
                    setAssetLocation(((String) value));
                }
            }
            if( values.containsKey("AssetRoom") ) {
                final Object value = values.remove("AssetRoom");
                if( (value == null) || (!value.equals(getAssetRoom())) ) {
                    setAssetRoom(((String) value));
                }
            }
            if( values.containsKey("PlantSection") ) {
                final Object value = values.remove("PlantSection");
                if( (value == null) || (!value.equals(getPlantSection())) ) {
                    setPlantSection(((String) value));
                }
            }
            if( values.containsKey("ABCIndicator") ) {
                final Object value = values.remove("ABCIndicator");
                if( (value == null) || (!value.equals(getABCIndicator())) ) {
                    setABCIndicator(((String) value));
                }
            }
            if( values.containsKey("MaintObjectFreeDefinedAttrib") ) {
                final Object value = values.remove("MaintObjectFreeDefinedAttrib");
                if( (value == null) || (!value.equals(getMaintObjectFreeDefinedAttrib())) ) {
                    setMaintObjectFreeDefinedAttrib(((String) value));
                }
            }
            if( values.containsKey("BasicSchedulingType") ) {
                final Object value = values.remove("BasicSchedulingType");
                if( (value == null) || (!value.equals(getBasicSchedulingType())) ) {
                    setBasicSchedulingType(((String) value));
                }
            }
            if( values.containsKey("LatestAcceptableCompletionDate") ) {
                final Object value = values.remove("LatestAcceptableCompletionDate");
                if( (value == null) || (!value.equals(getLatestAcceptableCompletionDate())) ) {
                    setLatestAcceptableCompletionDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("MaintOrdPersonResponsible") ) {
                final Object value = values.remove("MaintOrdPersonResponsible");
                if( (value == null) || (!value.equals(getMaintOrdPersonResponsible())) ) {
                    setMaintOrdPersonResponsible(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("LocAcctAssgmtWBSElement") ) {
                final Object value = values.remove("LocAcctAssgmtWBSElement");
                if( (value == null) || (!value.equals(getLocAcctAssgmtWBSElement())) ) {
                    setLocAcctAssgmtWBSElement(((String) value));
                }
            }
            if( values.containsKey("LocAcctAssgmtWBSElmntIntID") ) {
                final Object value = values.remove("LocAcctAssgmtWBSElmntIntID");
                if( (value == null) || (!value.equals(getLocAcctAssgmtWBSElmntIntID())) ) {
                    setLocAcctAssgmtWBSElmntIntID(((String) value));
                }
            }
            if( values.containsKey("ControllingSettlementProfile") ) {
                final Object value = values.remove("ControllingSettlementProfile");
                if( (value == null) || (!value.equals(getControllingSettlementProfile())) ) {
                    setControllingSettlementProfile(((String) value));
                }
            }
            if( values.containsKey("LocAcctAssgmtBusinessArea") ) {
                final Object value = values.remove("LocAcctAssgmtBusinessArea");
                if( (value == null) || (!value.equals(getLocAcctAssgmtBusinessArea())) ) {
                    setLocAcctAssgmtBusinessArea(((String) value));
                }
            }
            if( values.containsKey("MaintOrderProcessingContext") ) {
                final Object value = values.remove("MaintOrderProcessingContext");
                if( (value == null) || (!value.equals(getMaintOrderProcessingContext())) ) {
                    setMaintOrderProcessingContext(((String) value));
                }
            }
            if( values.containsKey("SystemStatusText") ) {
                final Object value = values.remove("SystemStatusText");
                if( (value == null) || (!value.equals(getSystemStatusText())) ) {
                    setSystemStatusText(((String) value));
                }
            }
            if( values.containsKey("UserStatusText") ) {
                final Object value = values.remove("UserStatusText");
                if( (value == null) || (!value.equals(getUserStatusText())) ) {
                    setUserStatusText(((String) value));
                }
            }
            if( values.containsKey("TechnicalObject") ) {
                final Object value = values.remove("TechnicalObject");
                if( (value == null) || (!value.equals(getTechnicalObject())) ) {
                    setTechnicalObject(((String) value));
                }
            }
            if( values.containsKey("TechnicalObjectLabel") ) {
                final Object value = values.remove("TechnicalObjectLabel");
                if( (value == null) || (!value.equals(getTechnicalObjectLabel())) ) {
                    setTechnicalObjectLabel(((String) value));
                }
            }
            if( values.containsKey("TechObjIsEquipOrFuncnlLoc") ) {
                final Object value = values.remove("TechObjIsEquipOrFuncnlLoc");
                if( (value == null) || (!value.equals(getTechObjIsEquipOrFuncnlLoc())) ) {
                    setTechObjIsEquipOrFuncnlLoc(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_MaintenanceOrderLongText") ) {
                final Object value = (values).remove("to_MaintenanceOrderLongText");
                if( value instanceof Iterable ) {
                    if( toMaintenanceOrderLongText == null ) {
                        toMaintenanceOrderLongText = Lists.newArrayList();
                    } else {
                        toMaintenanceOrderLongText = Lists.newArrayList(toMaintenanceOrderLongText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MaintenanceOrderLongText entity;
                        if( toMaintenanceOrderLongText.size() > i ) {
                            entity = toMaintenanceOrderLongText.get(i);
                        } else {
                            entity = new MaintenanceOrderLongText();
                            toMaintenanceOrderLongText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_MaintenanceOrderOperation") ) {
                final Object value = (values).remove("to_MaintenanceOrderOperation");
                if( value instanceof Iterable ) {
                    if( toMaintenanceOrderOperation == null ) {
                        toMaintenanceOrderOperation = Lists.newArrayList();
                    } else {
                        toMaintenanceOrderOperation = Lists.newArrayList(toMaintenanceOrderOperation);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MaintenanceOrderOperation entity;
                        if( toMaintenanceOrderOperation.size() > i ) {
                            entity = toMaintenanceOrderOperation.get(i);
                        } else {
                            entity = new MaintenanceOrderOperation();
                            toMaintenanceOrderOperation.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_MaintenanceOrderPartner") ) {
                final Object value = (values).remove("to_MaintenanceOrderPartner");
                if( value instanceof Iterable ) {
                    if( toMaintenanceOrderPartner == null ) {
                        toMaintenanceOrderPartner = Lists.newArrayList();
                    } else {
                        toMaintenanceOrderPartner = Lists.newArrayList(toMaintenanceOrderPartner);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MaintenanceOrderPartner entity;
                        if( toMaintenanceOrderPartner.size() > i ) {
                            entity = toMaintenanceOrderPartner.get(i);
                        } else {
                            entity = new MaintenanceOrderPartner();
                            toMaintenanceOrderPartner.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_MaintenanceOrderPhaseControl") ) {
                final Object value = (values).remove("to_MaintenanceOrderPhaseControl");
                if( value instanceof Iterable ) {
                    if( toMaintenanceOrderPhaseControl == null ) {
                        toMaintenanceOrderPhaseControl = Lists.newArrayList();
                    } else {
                        toMaintenanceOrderPhaseControl = Lists.newArrayList(toMaintenanceOrderPhaseControl);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MaintnanceOrderPhaseControl entity;
                        if( toMaintenanceOrderPhaseControl.size() > i ) {
                            entity = toMaintenanceOrderPhaseControl.get(i);
                        } else {
                            entity = new MaintnanceOrderPhaseControl();
                            toMaintenanceOrderPhaseControl.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_MaintOrderObjectListItem") ) {
                final Object value = (values).remove("to_MaintOrderObjectListItem");
                if( value instanceof Iterable ) {
                    if( toMaintOrderObjectListItem == null ) {
                        toMaintOrderObjectListItem = Lists.newArrayList();
                    } else {
                        toMaintOrderObjectListItem = Lists.newArrayList(toMaintOrderObjectListItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MaintOrderObjectListItem entity;
                        if( toMaintOrderObjectListItem.size() > i ) {
                            entity = toMaintOrderObjectListItem.get(i);
                        } else {
                            entity = new MaintOrderObjectListItem();
                            toMaintOrderObjectListItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_MaintOrderSettlmtDistrRule") ) {
                final Object value = (values).remove("to_MaintOrderSettlmtDistrRule");
                if( value instanceof Iterable ) {
                    if( toMaintOrderSettlmtDistrRule == null ) {
                        toMaintOrderSettlmtDistrRule = Lists.newArrayList();
                    } else {
                        toMaintOrderSettlmtDistrRule = Lists.newArrayList(toMaintOrderSettlmtDistrRule);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MaintOrderSettlmtDistrRule entity;
                        if( toMaintOrderSettlmtDistrRule.size() > i ) {
                            entity = toMaintOrderSettlmtDistrRule.get(i);
                        } else {
                            entity = new MaintOrderSettlmtDistrRule();
                            toMaintOrderSettlmtDistrRule.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_MaintOrdSettlmtDistrRuleHist") ) {
                final Object value = (values).remove("to_MaintOrdSettlmtDistrRuleHist");
                if( value instanceof Iterable ) {
                    if( toMaintOrdSettlmtDistrRuleHist == null ) {
                        toMaintOrdSettlmtDistrRuleHist = Lists.newArrayList();
                    } else {
                        toMaintOrdSettlmtDistrRuleHist = Lists.newArrayList(toMaintOrdSettlmtDistrRuleHist);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MaintOrdSettlmtDistrRuleHist entity;
                        if( toMaintOrdSettlmtDistrRuleHist.size() > i ) {
                            entity = toMaintOrdSettlmtDistrRuleHist.get(i);
                        } else {
                            entity = new MaintOrdSettlmtDistrRuleHist();
                            toMaintOrdSettlmtDistrRuleHist.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> MaintenanceOrderField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new MaintenanceOrderField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MaintenanceOrderField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MaintenanceOrderField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceOrderService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toMaintenanceOrderLongText != null ) {
            (values).put("to_MaintenanceOrderLongText", toMaintenanceOrderLongText);
        }
        if( toMaintenanceOrderOperation != null ) {
            (values).put("to_MaintenanceOrderOperation", toMaintenanceOrderOperation);
        }
        if( toMaintenanceOrderPartner != null ) {
            (values).put("to_MaintenanceOrderPartner", toMaintenanceOrderPartner);
        }
        if( toMaintenanceOrderPhaseControl != null ) {
            (values).put("to_MaintenanceOrderPhaseControl", toMaintenanceOrderPhaseControl);
        }
        if( toMaintOrderObjectListItem != null ) {
            (values).put("to_MaintOrderObjectListItem", toMaintOrderObjectListItem);
        }
        if( toMaintOrderSettlmtDistrRule != null ) {
            (values).put("to_MaintOrderSettlmtDistrRule", toMaintOrderSettlmtDistrRule);
        }
        if( toMaintOrdSettlmtDistrRuleHist != null ) {
            (values).put("to_MaintOrdSettlmtDistrRuleHist", toMaintOrdSettlmtDistrRuleHist);
        }
        return values;
    }

    /**
     * Fetches the <b>MaintenanceOrderLongText</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_MaintenanceOrderLongText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>MaintenanceOrderLongText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintenanceOrderLongText> fetchMaintenanceOrderLongText()
    {
        return fetchFieldAsList("to_MaintenanceOrderLongText", MaintenanceOrderLongText.class);
    }

    /**
     * Retrieval of associated <b>MaintenanceOrderLongText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_MaintenanceOrderLongText</b>.
     * <p>
     * If the navigation property <b>to_MaintenanceOrderLongText</b> of a queried <b>MaintenanceOrder</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintenanceOrderLongText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintenanceOrderLongText> getMaintenanceOrderLongTextOrFetch()
    {
        if( toMaintenanceOrderLongText == null ) {
            toMaintenanceOrderLongText = fetchMaintenanceOrderLongText();
        }
        return toMaintenanceOrderLongText;
    }

    /**
     * Retrieval of associated <b>MaintenanceOrderLongText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_MaintenanceOrderLongText</b>.
     * <p>
     * If the navigation property for an entity <b>MaintenanceOrder</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaintenanceOrderLongText</b> is already loaded, the
     *         result will contain the <b>MaintenanceOrderLongText</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<MaintenanceOrderLongText>> getMaintenanceOrderLongTextIfPresent()
    {
        return Option.of(toMaintenanceOrderLongText);
    }

    /**
     * Overwrites the list of associated <b>MaintenanceOrderLongText</b> entities for the loaded navigation property
     * <b>to_MaintenanceOrderLongText</b>.
     * <p>
     * If the navigation property <b>to_MaintenanceOrderLongText</b> of a queried <b>MaintenanceOrder</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>MaintenanceOrderLongText</b> entities.
     */
    public void setMaintenanceOrderLongText( @Nonnull final List<MaintenanceOrderLongText> value )
    {
        if( toMaintenanceOrderLongText == null ) {
            toMaintenanceOrderLongText = Lists.newArrayList();
        }
        toMaintenanceOrderLongText.clear();
        toMaintenanceOrderLongText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MaintenanceOrderLongText</b> entities. This corresponds to the OData
     * navigation property <b>to_MaintenanceOrderLongText</b>.
     * <p>
     * If the navigation property <b>to_MaintenanceOrderLongText</b> of a queried <b>MaintenanceOrder</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>MaintenanceOrderLongText</b> entities.
     */
    public void addMaintenanceOrderLongText( MaintenanceOrderLongText... entity )
    {
        if( toMaintenanceOrderLongText == null ) {
            toMaintenanceOrderLongText = Lists.newArrayList();
        }
        toMaintenanceOrderLongText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>MaintenanceOrderOperation</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_MaintenanceOrderOperation</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>MaintenanceOrderOperation</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintenanceOrderOperation> fetchMaintenanceOrderOperation()
    {
        return fetchFieldAsList("to_MaintenanceOrderOperation", MaintenanceOrderOperation.class);
    }

    /**
     * Retrieval of associated <b>MaintenanceOrderOperation</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_MaintenanceOrderOperation</b>.
     * <p>
     * If the navigation property <b>to_MaintenanceOrderOperation</b> of a queried <b>MaintenanceOrder</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintenanceOrderOperation</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintenanceOrderOperation> getMaintenanceOrderOperationOrFetch()
    {
        if( toMaintenanceOrderOperation == null ) {
            toMaintenanceOrderOperation = fetchMaintenanceOrderOperation();
        }
        return toMaintenanceOrderOperation;
    }

    /**
     * Retrieval of associated <b>MaintenanceOrderOperation</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_MaintenanceOrderOperation</b>.
     * <p>
     * If the navigation property for an entity <b>MaintenanceOrder</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaintenanceOrderOperation</b> is already loaded, the
     *         result will contain the <b>MaintenanceOrderOperation</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<MaintenanceOrderOperation>> getMaintenanceOrderOperationIfPresent()
    {
        return Option.of(toMaintenanceOrderOperation);
    }

    /**
     * Overwrites the list of associated <b>MaintenanceOrderOperation</b> entities for the loaded navigation property
     * <b>to_MaintenanceOrderOperation</b>.
     * <p>
     * If the navigation property <b>to_MaintenanceOrderOperation</b> of a queried <b>MaintenanceOrder</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>MaintenanceOrderOperation</b> entities.
     */
    public void setMaintenanceOrderOperation( @Nonnull final List<MaintenanceOrderOperation> value )
    {
        if( toMaintenanceOrderOperation == null ) {
            toMaintenanceOrderOperation = Lists.newArrayList();
        }
        toMaintenanceOrderOperation.clear();
        toMaintenanceOrderOperation.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MaintenanceOrderOperation</b> entities. This corresponds to the OData
     * navigation property <b>to_MaintenanceOrderOperation</b>.
     * <p>
     * If the navigation property <b>to_MaintenanceOrderOperation</b> of a queried <b>MaintenanceOrder</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>MaintenanceOrderOperation</b> entities.
     */
    public void addMaintenanceOrderOperation( MaintenanceOrderOperation... entity )
    {
        if( toMaintenanceOrderOperation == null ) {
            toMaintenanceOrderOperation = Lists.newArrayList();
        }
        toMaintenanceOrderOperation.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>MaintenanceOrderPartner</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_MaintenanceOrderPartner</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>MaintenanceOrderPartner</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintenanceOrderPartner> fetchMaintenanceOrderPartner()
    {
        return fetchFieldAsList("to_MaintenanceOrderPartner", MaintenanceOrderPartner.class);
    }

    /**
     * Retrieval of associated <b>MaintenanceOrderPartner</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_MaintenanceOrderPartner</b>.
     * <p>
     * If the navigation property <b>to_MaintenanceOrderPartner</b> of a queried <b>MaintenanceOrder</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintenanceOrderPartner</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintenanceOrderPartner> getMaintenanceOrderPartnerOrFetch()
    {
        if( toMaintenanceOrderPartner == null ) {
            toMaintenanceOrderPartner = fetchMaintenanceOrderPartner();
        }
        return toMaintenanceOrderPartner;
    }

    /**
     * Retrieval of associated <b>MaintenanceOrderPartner</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_MaintenanceOrderPartner</b>.
     * <p>
     * If the navigation property for an entity <b>MaintenanceOrder</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaintenanceOrderPartner</b> is already loaded, the
     *         result will contain the <b>MaintenanceOrderPartner</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<MaintenanceOrderPartner>> getMaintenanceOrderPartnerIfPresent()
    {
        return Option.of(toMaintenanceOrderPartner);
    }

    /**
     * Overwrites the list of associated <b>MaintenanceOrderPartner</b> entities for the loaded navigation property
     * <b>to_MaintenanceOrderPartner</b>.
     * <p>
     * If the navigation property <b>to_MaintenanceOrderPartner</b> of a queried <b>MaintenanceOrder</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>MaintenanceOrderPartner</b> entities.
     */
    public void setMaintenanceOrderPartner( @Nonnull final List<MaintenanceOrderPartner> value )
    {
        if( toMaintenanceOrderPartner == null ) {
            toMaintenanceOrderPartner = Lists.newArrayList();
        }
        toMaintenanceOrderPartner.clear();
        toMaintenanceOrderPartner.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MaintenanceOrderPartner</b> entities. This corresponds to the OData
     * navigation property <b>to_MaintenanceOrderPartner</b>.
     * <p>
     * If the navigation property <b>to_MaintenanceOrderPartner</b> of a queried <b>MaintenanceOrder</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>MaintenanceOrderPartner</b> entities.
     */
    public void addMaintenanceOrderPartner( MaintenanceOrderPartner... entity )
    {
        if( toMaintenanceOrderPartner == null ) {
            toMaintenanceOrderPartner = Lists.newArrayList();
        }
        toMaintenanceOrderPartner.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>MaintnanceOrderPhaseControl</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_MaintenanceOrderPhaseControl</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>MaintnanceOrderPhaseControl</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintnanceOrderPhaseControl> fetchMaintenanceOrderPhaseControl()
    {
        return fetchFieldAsList("to_MaintenanceOrderPhaseControl", MaintnanceOrderPhaseControl.class);
    }

    /**
     * Retrieval of associated <b>MaintnanceOrderPhaseControl</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_MaintenanceOrderPhaseControl</b>.
     * <p>
     * If the navigation property <b>to_MaintenanceOrderPhaseControl</b> of a queried <b>MaintenanceOrder</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintnanceOrderPhaseControl</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintnanceOrderPhaseControl> getMaintenanceOrderPhaseControlOrFetch()
    {
        if( toMaintenanceOrderPhaseControl == null ) {
            toMaintenanceOrderPhaseControl = fetchMaintenanceOrderPhaseControl();
        }
        return toMaintenanceOrderPhaseControl;
    }

    /**
     * Retrieval of associated <b>MaintnanceOrderPhaseControl</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_MaintenanceOrderPhaseControl</b>.
     * <p>
     * If the navigation property for an entity <b>MaintenanceOrder</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaintenanceOrderPhaseControl</b> is already loaded, the
     *         result will contain the <b>MaintnanceOrderPhaseControl</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<MaintnanceOrderPhaseControl>> getMaintenanceOrderPhaseControlIfPresent()
    {
        return Option.of(toMaintenanceOrderPhaseControl);
    }

    /**
     * Overwrites the list of associated <b>MaintnanceOrderPhaseControl</b> entities for the loaded navigation property
     * <b>to_MaintenanceOrderPhaseControl</b>.
     * <p>
     * If the navigation property <b>to_MaintenanceOrderPhaseControl</b> of a queried <b>MaintenanceOrder</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>MaintnanceOrderPhaseControl</b> entities.
     */
    public void setMaintenanceOrderPhaseControl( @Nonnull final List<MaintnanceOrderPhaseControl> value )
    {
        if( toMaintenanceOrderPhaseControl == null ) {
            toMaintenanceOrderPhaseControl = Lists.newArrayList();
        }
        toMaintenanceOrderPhaseControl.clear();
        toMaintenanceOrderPhaseControl.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MaintnanceOrderPhaseControl</b> entities. This corresponds to the
     * OData navigation property <b>to_MaintenanceOrderPhaseControl</b>.
     * <p>
     * If the navigation property <b>to_MaintenanceOrderPhaseControl</b> of a queried <b>MaintenanceOrder</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>MaintnanceOrderPhaseControl</b> entities.
     */
    public void addMaintenanceOrderPhaseControl( MaintnanceOrderPhaseControl... entity )
    {
        if( toMaintenanceOrderPhaseControl == null ) {
            toMaintenanceOrderPhaseControl = Lists.newArrayList();
        }
        toMaintenanceOrderPhaseControl.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>MaintOrderObjectListItem</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_MaintOrderObjectListItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>MaintOrderObjectListItem</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintOrderObjectListItem> fetchMaintOrderObjectListItem()
    {
        return fetchFieldAsList("to_MaintOrderObjectListItem", MaintOrderObjectListItem.class);
    }

    /**
     * Retrieval of associated <b>MaintOrderObjectListItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_MaintOrderObjectListItem</b>.
     * <p>
     * If the navigation property <b>to_MaintOrderObjectListItem</b> of a queried <b>MaintenanceOrder</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintOrderObjectListItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintOrderObjectListItem> getMaintOrderObjectListItemOrFetch()
    {
        if( toMaintOrderObjectListItem == null ) {
            toMaintOrderObjectListItem = fetchMaintOrderObjectListItem();
        }
        return toMaintOrderObjectListItem;
    }

    /**
     * Retrieval of associated <b>MaintOrderObjectListItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_MaintOrderObjectListItem</b>.
     * <p>
     * If the navigation property for an entity <b>MaintenanceOrder</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaintOrderObjectListItem</b> is already loaded, the
     *         result will contain the <b>MaintOrderObjectListItem</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<MaintOrderObjectListItem>> getMaintOrderObjectListItemIfPresent()
    {
        return Option.of(toMaintOrderObjectListItem);
    }

    /**
     * Overwrites the list of associated <b>MaintOrderObjectListItem</b> entities for the loaded navigation property
     * <b>to_MaintOrderObjectListItem</b>.
     * <p>
     * If the navigation property <b>to_MaintOrderObjectListItem</b> of a queried <b>MaintenanceOrder</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>MaintOrderObjectListItem</b> entities.
     */
    public void setMaintOrderObjectListItem( @Nonnull final List<MaintOrderObjectListItem> value )
    {
        if( toMaintOrderObjectListItem == null ) {
            toMaintOrderObjectListItem = Lists.newArrayList();
        }
        toMaintOrderObjectListItem.clear();
        toMaintOrderObjectListItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MaintOrderObjectListItem</b> entities. This corresponds to the OData
     * navigation property <b>to_MaintOrderObjectListItem</b>.
     * <p>
     * If the navigation property <b>to_MaintOrderObjectListItem</b> of a queried <b>MaintenanceOrder</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>MaintOrderObjectListItem</b> entities.
     */
    public void addMaintOrderObjectListItem( MaintOrderObjectListItem... entity )
    {
        if( toMaintOrderObjectListItem == null ) {
            toMaintOrderObjectListItem = Lists.newArrayList();
        }
        toMaintOrderObjectListItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>MaintOrderSettlmtDistrRule</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_MaintOrderSettlmtDistrRule</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>MaintOrderSettlmtDistrRule</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintOrderSettlmtDistrRule> fetchMaintOrderSettlmtDistrRule()
    {
        return fetchFieldAsList("to_MaintOrderSettlmtDistrRule", MaintOrderSettlmtDistrRule.class);
    }

    /**
     * Retrieval of associated <b>MaintOrderSettlmtDistrRule</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_MaintOrderSettlmtDistrRule</b>.
     * <p>
     * If the navigation property <b>to_MaintOrderSettlmtDistrRule</b> of a queried <b>MaintenanceOrder</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintOrderSettlmtDistrRule</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintOrderSettlmtDistrRule> getMaintOrderSettlmtDistrRuleOrFetch()
    {
        if( toMaintOrderSettlmtDistrRule == null ) {
            toMaintOrderSettlmtDistrRule = fetchMaintOrderSettlmtDistrRule();
        }
        return toMaintOrderSettlmtDistrRule;
    }

    /**
     * Retrieval of associated <b>MaintOrderSettlmtDistrRule</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_MaintOrderSettlmtDistrRule</b>.
     * <p>
     * If the navigation property for an entity <b>MaintenanceOrder</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaintOrderSettlmtDistrRule</b> is already loaded, the
     *         result will contain the <b>MaintOrderSettlmtDistrRule</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<MaintOrderSettlmtDistrRule>> getMaintOrderSettlmtDistrRuleIfPresent()
    {
        return Option.of(toMaintOrderSettlmtDistrRule);
    }

    /**
     * Overwrites the list of associated <b>MaintOrderSettlmtDistrRule</b> entities for the loaded navigation property
     * <b>to_MaintOrderSettlmtDistrRule</b>.
     * <p>
     * If the navigation property <b>to_MaintOrderSettlmtDistrRule</b> of a queried <b>MaintenanceOrder</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>MaintOrderSettlmtDistrRule</b> entities.
     */
    public void setMaintOrderSettlmtDistrRule( @Nonnull final List<MaintOrderSettlmtDistrRule> value )
    {
        if( toMaintOrderSettlmtDistrRule == null ) {
            toMaintOrderSettlmtDistrRule = Lists.newArrayList();
        }
        toMaintOrderSettlmtDistrRule.clear();
        toMaintOrderSettlmtDistrRule.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MaintOrderSettlmtDistrRule</b> entities. This corresponds to the OData
     * navigation property <b>to_MaintOrderSettlmtDistrRule</b>.
     * <p>
     * If the navigation property <b>to_MaintOrderSettlmtDistrRule</b> of a queried <b>MaintenanceOrder</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>MaintOrderSettlmtDistrRule</b> entities.
     */
    public void addMaintOrderSettlmtDistrRule( MaintOrderSettlmtDistrRule... entity )
    {
        if( toMaintOrderSettlmtDistrRule == null ) {
            toMaintOrderSettlmtDistrRule = Lists.newArrayList();
        }
        toMaintOrderSettlmtDistrRule.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>MaintOrdSettlmtDistrRuleHist</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_MaintOrdSettlmtDistrRuleHist</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>MaintOrdSettlmtDistrRuleHist</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintOrdSettlmtDistrRuleHist> fetchMaintOrdSettlmtDistrRuleHist()
    {
        return fetchFieldAsList("to_MaintOrdSettlmtDistrRuleHist", MaintOrdSettlmtDistrRuleHist.class);
    }

    /**
     * Retrieval of associated <b>MaintOrdSettlmtDistrRuleHist</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_MaintOrdSettlmtDistrRuleHist</b>.
     * <p>
     * If the navigation property <b>to_MaintOrdSettlmtDistrRuleHist</b> of a queried <b>MaintenanceOrder</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintOrdSettlmtDistrRuleHist</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintOrdSettlmtDistrRuleHist> getMaintOrdSettlmtDistrRuleHistOrFetch()
    {
        if( toMaintOrdSettlmtDistrRuleHist == null ) {
            toMaintOrdSettlmtDistrRuleHist = fetchMaintOrdSettlmtDistrRuleHist();
        }
        return toMaintOrdSettlmtDistrRuleHist;
    }

    /**
     * Retrieval of associated <b>MaintOrdSettlmtDistrRuleHist</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_MaintOrdSettlmtDistrRuleHist</b>.
     * <p>
     * If the navigation property for an entity <b>MaintenanceOrder</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaintOrdSettlmtDistrRuleHist</b> is already loaded, the
     *         result will contain the <b>MaintOrdSettlmtDistrRuleHist</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<MaintOrdSettlmtDistrRuleHist>> getMaintOrdSettlmtDistrRuleHistIfPresent()
    {
        return Option.of(toMaintOrdSettlmtDistrRuleHist);
    }

    /**
     * Overwrites the list of associated <b>MaintOrdSettlmtDistrRuleHist</b> entities for the loaded navigation property
     * <b>to_MaintOrdSettlmtDistrRuleHist</b>.
     * <p>
     * If the navigation property <b>to_MaintOrdSettlmtDistrRuleHist</b> of a queried <b>MaintenanceOrder</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>MaintOrdSettlmtDistrRuleHist</b> entities.
     */
    public void setMaintOrdSettlmtDistrRuleHist( @Nonnull final List<MaintOrdSettlmtDistrRuleHist> value )
    {
        if( toMaintOrdSettlmtDistrRuleHist == null ) {
            toMaintOrdSettlmtDistrRuleHist = Lists.newArrayList();
        }
        toMaintOrdSettlmtDistrRuleHist.clear();
        toMaintOrdSettlmtDistrRuleHist.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MaintOrdSettlmtDistrRuleHist</b> entities. This corresponds to the
     * OData navigation property <b>to_MaintOrdSettlmtDistrRuleHist</b>.
     * <p>
     * If the navigation property <b>to_MaintOrdSettlmtDistrRuleHist</b> of a queried <b>MaintenanceOrder</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>MaintOrdSettlmtDistrRuleHist</b> entities.
     */
    public void addMaintOrdSettlmtDistrRuleHist( MaintOrdSettlmtDistrRuleHist... entity )
    {
        if( toMaintOrdSettlmtDistrRuleHist == null ) {
            toMaintOrdSettlmtDistrRuleHist = Lists.newArrayList();
        }
        toMaintOrdSettlmtDistrRuleHist.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of MaintenanceOrder instances.
     *
     */
    public final static class MaintenanceOrderBuilder
    {

        private List<MaintenanceOrderLongText> toMaintenanceOrderLongText = Lists.newArrayList();
        private List<MaintenanceOrderOperation> toMaintenanceOrderOperation = Lists.newArrayList();
        private List<MaintenanceOrderPartner> toMaintenanceOrderPartner = Lists.newArrayList();
        private List<MaintnanceOrderPhaseControl> toMaintenanceOrderPhaseControl = Lists.newArrayList();
        private List<MaintOrderObjectListItem> toMaintOrderObjectListItem = Lists.newArrayList();
        private List<MaintOrderSettlmtDistrRule> toMaintOrderSettlmtDistrRule = Lists.newArrayList();
        private List<MaintOrdSettlmtDistrRuleHist> toMaintOrdSettlmtDistrRuleHist = Lists.newArrayList();

        private MaintenanceOrder.MaintenanceOrderBuilder toMaintenanceOrderLongText(
            final List<MaintenanceOrderLongText> value )
        {
            toMaintenanceOrderLongText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_MaintenanceOrderLongText</b> for <b>MaintenanceOrder</b> to multiple
         * <b>MaintenanceOrderLongText</b>.
         *
         * @param value
         *            The MaintenanceOrderLongTexts to build this MaintenanceOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenanceOrder.MaintenanceOrderBuilder maintenanceOrderLongText( MaintenanceOrderLongText... value )
        {
            return toMaintenanceOrderLongText(Lists.newArrayList(value));
        }

        private MaintenanceOrder.MaintenanceOrderBuilder toMaintenanceOrderOperation(
            final List<MaintenanceOrderOperation> value )
        {
            toMaintenanceOrderOperation.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_MaintenanceOrderOperation</b> for <b>MaintenanceOrder</b> to multiple
         * <b>MaintenanceOrderOperation</b>.
         *
         * @param value
         *            The MaintenanceOrderOperations to build this MaintenanceOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenanceOrder.MaintenanceOrderBuilder maintenanceOrderOperation( MaintenanceOrderOperation... value )
        {
            return toMaintenanceOrderOperation(Lists.newArrayList(value));
        }

        private MaintenanceOrder.MaintenanceOrderBuilder toMaintenanceOrderPartner(
            final List<MaintenanceOrderPartner> value )
        {
            toMaintenanceOrderPartner.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_MaintenanceOrderPartner</b> for <b>MaintenanceOrder</b> to multiple
         * <b>MaintenanceOrderPartner</b>.
         *
         * @param value
         *            The MaintenanceOrderPartners to build this MaintenanceOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenanceOrder.MaintenanceOrderBuilder maintenanceOrderPartner( MaintenanceOrderPartner... value )
        {
            return toMaintenanceOrderPartner(Lists.newArrayList(value));
        }

        private MaintenanceOrder.MaintenanceOrderBuilder toMaintenanceOrderPhaseControl(
            final List<MaintnanceOrderPhaseControl> value )
        {
            toMaintenanceOrderPhaseControl.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_MaintenanceOrderPhaseControl</b> for <b>MaintenanceOrder</b> to multiple
         * <b>MaintnanceOrderPhaseControl</b>.
         *
         * @param value
         *            The MaintnanceOrderPhaseControls to build this MaintenanceOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenanceOrder.MaintenanceOrderBuilder maintenanceOrderPhaseControl(
            MaintnanceOrderPhaseControl... value )
        {
            return toMaintenanceOrderPhaseControl(Lists.newArrayList(value));
        }

        private MaintenanceOrder.MaintenanceOrderBuilder toMaintOrderObjectListItem(
            final List<MaintOrderObjectListItem> value )
        {
            toMaintOrderObjectListItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_MaintOrderObjectListItem</b> for <b>MaintenanceOrder</b> to multiple
         * <b>MaintOrderObjectListItem</b>.
         *
         * @param value
         *            The MaintOrderObjectListItems to build this MaintenanceOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenanceOrder.MaintenanceOrderBuilder maintOrderObjectListItem( MaintOrderObjectListItem... value )
        {
            return toMaintOrderObjectListItem(Lists.newArrayList(value));
        }

        private MaintenanceOrder.MaintenanceOrderBuilder toMaintOrderSettlmtDistrRule(
            final List<MaintOrderSettlmtDistrRule> value )
        {
            toMaintOrderSettlmtDistrRule.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_MaintOrderSettlmtDistrRule</b> for <b>MaintenanceOrder</b> to multiple
         * <b>MaintOrderSettlmtDistrRule</b>.
         *
         * @param value
         *            The MaintOrderSettlmtDistrRules to build this MaintenanceOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenanceOrder.MaintenanceOrderBuilder maintOrderSettlmtDistrRule(
            MaintOrderSettlmtDistrRule... value )
        {
            return toMaintOrderSettlmtDistrRule(Lists.newArrayList(value));
        }

        private MaintenanceOrder.MaintenanceOrderBuilder toMaintOrdSettlmtDistrRuleHist(
            final List<MaintOrdSettlmtDistrRuleHist> value )
        {
            toMaintOrdSettlmtDistrRuleHist.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_MaintOrdSettlmtDistrRuleHist</b> for <b>MaintenanceOrder</b> to multiple
         * <b>MaintOrdSettlmtDistrRuleHist</b>.
         *
         * @param value
         *            The MaintOrdSettlmtDistrRuleHists to build this MaintenanceOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenanceOrder.MaintenanceOrderBuilder maintOrdSettlmtDistrRuleHist(
            MaintOrdSettlmtDistrRuleHist... value )
        {
            return toMaintOrdSettlmtDistrRuleHist(Lists.newArrayList(value));
        }

    }

}
