/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.field.MaintenanceOrderOperationField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.link.MaintenanceOrderOperationLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.link.MaintenanceOrderOperationOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.selectable.MaintenanceOrderOperationSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Maintenance Order Operation
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MaintenanceOrderOperationType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MaintenanceOrderOperation extends VdmEntity<MaintenanceOrderOperation>
{

    /**
     * Selector for all available fields of MaintenanceOrderOperation.
     *
     */
    public final static MaintenanceOrderOperationSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrder</b>
     * </p>
     *
     * @return Order Number
     */
    @Key
    @SerializedName( "MaintenanceOrder" )
    @JsonProperty( "MaintenanceOrder" )
    @Nullable
    @ODataField( odataName = "MaintenanceOrder" )
    private String maintenanceOrder;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceOrder</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> MAINTENANCE_ORDER =
        new MaintenanceOrderOperationField<String>("MaintenanceOrder");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderOperation</b>
     * </p>
     *
     * @return Maintenance Order Operation
     */
    @Key
    @SerializedName( "MaintenanceOrderOperation" )
    @JsonProperty( "MaintenanceOrderOperation" )
    @Nullable
    @ODataField( odataName = "MaintenanceOrderOperation" )
    private String maintenanceOrderOperation;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceOrderOperation</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> MAINTENANCE_ORDER_OPERATION =
        new MaintenanceOrderOperationField<String>("MaintenanceOrderOperation");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderSubOperation</b>
     * </p>
     *
     * @return Maintenance Order Suboperation
     */
    @Key
    @SerializedName( "MaintenanceOrderSubOperation" )
    @JsonProperty( "MaintenanceOrderSubOperation" )
    @Nullable
    @ODataField( odataName = "MaintenanceOrderSubOperation" )
    private String maintenanceOrderSubOperation;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceOrderSubOperation</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> MAINTENANCE_ORDER_SUB_OPERATION =
        new MaintenanceOrderOperationField<String>("MaintenanceOrderSubOperation");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OperationControlKey</b>
     * </p>
     *
     * @return Control Key
     */
    @SerializedName( "OperationControlKey" )
    @JsonProperty( "OperationControlKey" )
    @Nullable
    @ODataField( odataName = "OperationControlKey" )
    private String operationControlKey;
    /**
     * Use with available fluent helpers to apply the <b>OperationControlKey</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> OPERATION_CONTROL_KEY =
        new MaintenanceOrderOperationField<String>("OperationControlKey");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>OperationWorkCenterInternalID</b>
     * </p>
     *
     * @return Object ID of the resource
     */
    @SerializedName( "OperationWorkCenterInternalID" )
    @JsonProperty( "OperationWorkCenterInternalID" )
    @Nullable
    @ODataField( odataName = "OperationWorkCenterInternalID" )
    private String operationWorkCenterInternalID;
    /**
     * Use with available fluent helpers to apply the <b>OperationWorkCenterInternalID</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> OPERATION_WORK_CENTER_INTERNAL_ID =
        new MaintenanceOrderOperationField<String>("OperationWorkCenterInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenter</b>
     * </p>
     *
     * @return Work Center
     */
    @SerializedName( "WorkCenter" )
    @JsonProperty( "WorkCenter" )
    @Nullable
    @ODataField( odataName = "WorkCenter" )
    private String workCenter;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenter</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> WORK_CENTER =
        new MaintenanceOrderOperationField<String>("WorkCenter");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> PLANT =
        new MaintenanceOrderOperationField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>OperationStandardTextCode</b>
     * </p>
     *
     * @return Standard text key
     */
    @SerializedName( "OperationStandardTextCode" )
    @JsonProperty( "OperationStandardTextCode" )
    @Nullable
    @ODataField( odataName = "OperationStandardTextCode" )
    private String operationStandardTextCode;
    /**
     * Use with available fluent helpers to apply the <b>OperationStandardTextCode</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> OPERATION_STANDARD_TEXT_CODE =
        new MaintenanceOrderOperationField<String>("OperationStandardTextCode");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>OperationDescription</b>
     * </p>
     *
     * @return Operation Short Text
     */
    @SerializedName( "OperationDescription" )
    @JsonProperty( "OperationDescription" )
    @Nullable
    @ODataField( odataName = "OperationDescription" )
    private String operationDescription;
    /**
     * Use with available fluent helpers to apply the <b>OperationDescription</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> OPERATION_DESCRIPTION =
        new MaintenanceOrderOperationField<String>("OperationDescription");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrderRoutingNumber</b>
     * </p>
     *
     * @return Routing number of operations in the order
     */
    @SerializedName( "MaintOrderRoutingNumber" )
    @JsonProperty( "MaintOrderRoutingNumber" )
    @Nullable
    @ODataField( odataName = "MaintOrderRoutingNumber" )
    private String maintOrderRoutingNumber;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrderRoutingNumber</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> MAINT_ORDER_ROUTING_NUMBER =
        new MaintenanceOrderOperationField<String>("MaintOrderRoutingNumber");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderRoutingNode</b>
     * </p>
     *
     * @return General counter for order
     */
    @SerializedName( "MaintenanceOrderRoutingNode" )
    @JsonProperty( "MaintenanceOrderRoutingNode" )
    @Nullable
    @ODataField( odataName = "MaintenanceOrderRoutingNode" )
    private String maintenanceOrderRoutingNode;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceOrderRoutingNode</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> MAINTENANCE_ORDER_ROUTING_NODE =
        new MaintenanceOrderOperationField<String>("MaintenanceOrderRoutingNode");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>SuperiorOperationInternalID</b>
     * </p>
     *
     * @return Node Number of the Superior Operation
     */
    @SerializedName( "SuperiorOperationInternalID" )
    @JsonProperty( "SuperiorOperationInternalID" )
    @Nullable
    @ODataField( odataName = "SuperiorOperationInternalID" )
    private String superiorOperationInternalID;
    /**
     * Use with available fluent helpers to apply the <b>SuperiorOperationInternalID</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> SUPERIOR_OPERATION_INTERNAL_ID =
        new MaintenanceOrderOperationField<String>("SuperiorOperationInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OperationWorkCenterTypeCode</b>
     * </p>
     *
     * @return The operationWorkCenterTypeCode contained in this entity.
     */
    @SerializedName( "OperationWorkCenterTypeCode" )
    @JsonProperty( "OperationWorkCenterTypeCode" )
    @Nullable
    @ODataField( odataName = "OperationWorkCenterTypeCode" )
    private String operationWorkCenterTypeCode;
    /**
     * Use with available fluent helpers to apply the <b>OperationWorkCenterTypeCode</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> OPERATION_WORK_CENTER_TYPE_CODE =
        new MaintenanceOrderOperationField<String>("OperationWorkCenterTypeCode");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> LANGUAGE =
        new MaintenanceOrderOperationField<String>("Language");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfTimeTickets</b>
     * </p>
     *
     * @return Number of Time Tickets
     */
    @SerializedName( "NumberOfTimeTickets" )
    @JsonProperty( "NumberOfTimeTickets" )
    @Nullable
    @ODataField( odataName = "NumberOfTimeTickets" )
    private BigDecimal numberOfTimeTickets;
    /**
     * Use with available fluent helpers to apply the <b>NumberOfTimeTickets</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<BigDecimal> NUMBER_OF_TIME_TICKETS =
        new MaintenanceOrderOperationField<BigDecimal>("NumberOfTimeTickets");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OperationPurgInfoRecdSearchTxt</b>
     * </p>
     *
     * @return Sort Term for Non-Stock Info Records
     */
    @SerializedName( "OperationPurgInfoRecdSearchTxt" )
    @JsonProperty( "OperationPurgInfoRecdSearchTxt" )
    @Nullable
    @ODataField( odataName = "OperationPurgInfoRecdSearchTxt" )
    private String operationPurgInfoRecdSearchTxt;
    /**
     * Use with available fluent helpers to apply the <b>OperationPurgInfoRecdSearchTxt</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> OPERATION_PURG_INFO_RECD_SEARCH_TXT =
        new MaintenanceOrderOperationField<String>("OperationPurgInfoRecdSearchTxt");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OperationSupplier</b>
     * </p>
     *
     * @return Account Number of Supplier
     */
    @SerializedName( "OperationSupplier" )
    @JsonProperty( "OperationSupplier" )
    @Nullable
    @ODataField( odataName = "OperationSupplier" )
    private String operationSupplier;
    /**
     * Use with available fluent helpers to apply the <b>OperationSupplier</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> OPERATION_SUPPLIER =
        new MaintenanceOrderOperationField<String>("OperationSupplier");
    /**
     * Constraints: Not nullable, Precision: 11, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpExternalProcessingPrice</b>
     * </p>
     *
     * @return Price
     */
    @SerializedName( "OpExternalProcessingPrice" )
    @JsonProperty( "OpExternalProcessingPrice" )
    @Nullable
    @ODataField( odataName = "OpExternalProcessingPrice" )
    private BigDecimal opExternalProcessingPrice;
    /**
     * Use with available fluent helpers to apply the <b>OpExternalProcessingPrice</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<BigDecimal> OP_EXTERNAL_PROCESSING_PRICE =
        new MaintenanceOrderOperationField<BigDecimal>("OpExternalProcessingPrice");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>OpExternalProcessingCurrency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "OpExternalProcessingCurrency" )
    @JsonProperty( "OpExternalProcessingCurrency" )
    @Nullable
    @ODataField( odataName = "OpExternalProcessingCurrency" )
    private String opExternalProcessingCurrency;
    /**
     * Use with available fluent helpers to apply the <b>OpExternalProcessingCurrency</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> OP_EXTERNAL_PROCESSING_CURRENCY =
        new MaintenanceOrderOperationField<String>("OpExternalProcessingCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostElement</b>
     * </p>
     *
     * @return Cost Element
     */
    @SerializedName( "CostElement" )
    @JsonProperty( "CostElement" )
    @Nullable
    @ODataField( odataName = "CostElement" )
    private String costElement;
    /**
     * Use with available fluent helpers to apply the <b>CostElement</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> COST_ELEMENT =
        new MaintenanceOrderOperationField<String>("CostElement");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OperationPurchasingInfoRecord</b>
     * </p>
     *
     * @return Number of purchasing info record
     */
    @SerializedName( "OperationPurchasingInfoRecord" )
    @JsonProperty( "OperationPurchasingInfoRecord" )
    @Nullable
    @ODataField( odataName = "OperationPurchasingInfoRecord" )
    private String operationPurchasingInfoRecord;
    /**
     * Use with available fluent helpers to apply the <b>OperationPurchasingInfoRecord</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> OPERATION_PURCHASING_INFO_RECORD =
        new MaintenanceOrderOperationField<String>("OperationPurchasingInfoRecord");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @return Purchasing Organization
     */
    @SerializedName( "PurchasingOrganization" )
    @JsonProperty( "PurchasingOrganization" )
    @Nullable
    @ODataField( odataName = "PurchasingOrganization" )
    private String purchasingOrganization;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingOrganization</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> PURCHASING_ORGANIZATION =
        new MaintenanceOrderOperationField<String>("PurchasingOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     *
     * @return Purchasing Group for External Processing Activity
     */
    @SerializedName( "PurchasingGroup" )
    @JsonProperty( "PurchasingGroup" )
    @Nullable
    @ODataField( odataName = "PurchasingGroup" )
    private String purchasingGroup;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingGroup</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> PURCHASING_GROUP =
        new MaintenanceOrderOperationField<String>("PurchasingGroup");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @return Material Group
     */
    @SerializedName( "MaterialGroup" )
    @JsonProperty( "MaterialGroup" )
    @Nullable
    @ODataField( odataName = "MaterialGroup" )
    private String materialGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroup</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> MATERIAL_GROUP =
        new MaintenanceOrderOperationField<String>("MaterialGroup");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OpPurchaseOutlineAgreement</b>
     * </p>
     *
     * @return Number of principal purchase agreement
     */
    @SerializedName( "OpPurchaseOutlineAgreement" )
    @JsonProperty( "OpPurchaseOutlineAgreement" )
    @Nullable
    @ODataField( odataName = "OpPurchaseOutlineAgreement" )
    private String opPurchaseOutlineAgreement;
    /**
     * Use with available fluent helpers to apply the <b>OpPurchaseOutlineAgreement</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> OP_PURCHASE_OUTLINE_AGREEMENT =
        new MaintenanceOrderOperationField<String>("OpPurchaseOutlineAgreement");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>OpPurchaseOutlineAgreementItem</b>
     * </p>
     *
     * @return Item Number of Principal Purchase Agreement
     */
    @SerializedName( "OpPurchaseOutlineAgreementItem" )
    @JsonProperty( "OpPurchaseOutlineAgreementItem" )
    @Nullable
    @ODataField( odataName = "OpPurchaseOutlineAgreementItem" )
    private String opPurchaseOutlineAgreementItem;
    /**
     * Use with available fluent helpers to apply the <b>OpPurchaseOutlineAgreementItem</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> OP_PURCHASE_OUTLINE_AGREEMENT_ITEM =
        new MaintenanceOrderOperationField<String>("OpPurchaseOutlineAgreementItem");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>OperationRequisitionerName</b>
     * </p>
     *
     * @return Name of requisitioner/requester
     */
    @SerializedName( "OperationRequisitionerName" )
    @JsonProperty( "OperationRequisitionerName" )
    @Nullable
    @ODataField( odataName = "OperationRequisitionerName" )
    private String operationRequisitionerName;
    /**
     * Use with available fluent helpers to apply the <b>OperationRequisitionerName</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> OPERATION_REQUISITIONER_NAME =
        new MaintenanceOrderOperationField<String>("OperationRequisitionerName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OperationTrackingNumber</b>
     * </p>
     *
     * @return Requirement Tracking Number
     */
    @SerializedName( "OperationTrackingNumber" )
    @JsonProperty( "OperationTrackingNumber" )
    @Nullable
    @ODataField( odataName = "OperationTrackingNumber" )
    private String operationTrackingNumber;
    /**
     * Use with available fluent helpers to apply the <b>OperationTrackingNumber</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> OPERATION_TRACKING_NUMBER =
        new MaintenanceOrderOperationField<String>("OperationTrackingNumber");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfCapacities</b>
     * </p>
     *
     * @return Number of capacities required
     */
    @SerializedName( "NumberOfCapacities" )
    @JsonProperty( "NumberOfCapacities" )
    @Nullable
    @ODataField( odataName = "NumberOfCapacities" )
    private Short numberOfCapacities;
    /**
     * Use with available fluent helpers to apply the <b>NumberOfCapacities</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<Short> NUMBER_OF_CAPACITIES =
        new MaintenanceOrderOperationField<Short>("NumberOfCapacities");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>OperationWorkPercent</b>
     * </p>
     *
     * @return Work percentage
     */
    @SerializedName( "OperationWorkPercent" )
    @JsonProperty( "OperationWorkPercent" )
    @Nullable
    @ODataField( odataName = "OperationWorkPercent" )
    private Short operationWorkPercent;
    /**
     * Use with available fluent helpers to apply the <b>OperationWorkPercent</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<Short> OPERATION_WORK_PERCENT =
        new MaintenanceOrderOperationField<Short>("OperationWorkPercent");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OperationCalculationControl</b>
     * </p>
     *
     * @return Key for calculation
     */
    @SerializedName( "OperationCalculationControl" )
    @JsonProperty( "OperationCalculationControl" )
    @Nullable
    @ODataField( odataName = "OperationCalculationControl" )
    private String operationCalculationControl;
    /**
     * Use with available fluent helpers to apply the <b>OperationCalculationControl</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> OPERATION_CALCULATION_CONTROL =
        new MaintenanceOrderOperationField<String>("OperationCalculationControl");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ActivityType</b>
     * </p>
     *
     * @return Activity Type
     */
    @SerializedName( "ActivityType" )
    @JsonProperty( "ActivityType" )
    @Nullable
    @ODataField( odataName = "ActivityType" )
    private String activityType;
    /**
     * Use with available fluent helpers to apply the <b>ActivityType</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> ACTIVITY_TYPE =
        new MaintenanceOrderOperationField<String>("ActivityType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OperationSystemCondition</b>
     * </p>
     *
     * @return System Condition
     */
    @SerializedName( "OperationSystemCondition" )
    @JsonProperty( "OperationSystemCondition" )
    @Nullable
    @ODataField( odataName = "OperationSystemCondition" )
    private String operationSystemCondition;
    /**
     * Use with available fluent helpers to apply the <b>OperationSystemCondition</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> OPERATION_SYSTEM_CONDITION =
        new MaintenanceOrderOperationField<String>("OperationSystemCondition");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>OperationGoodsRecipientName</b>
     * </p>
     *
     * @return Goods Recipient
     */
    @SerializedName( "OperationGoodsRecipientName" )
    @JsonProperty( "OperationGoodsRecipientName" )
    @Nullable
    @ODataField( odataName = "OperationGoodsRecipientName" )
    private String operationGoodsRecipientName;
    /**
     * Use with available fluent helpers to apply the <b>OperationGoodsRecipientName</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> OPERATION_GOODS_RECIPIENT_NAME =
        new MaintenanceOrderOperationField<String>("OperationGoodsRecipientName");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>OperationUnloadingPointName</b>
     * </p>
     *
     * @return Unloading Point
     */
    @SerializedName( "OperationUnloadingPointName" )
    @JsonProperty( "OperationUnloadingPointName" )
    @Nullable
    @ODataField( odataName = "OperationUnloadingPointName" )
    private String operationUnloadingPointName;
    /**
     * Use with available fluent helpers to apply the <b>OperationUnloadingPointName</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> OPERATION_UNLOADING_POINT_NAME =
        new MaintenanceOrderOperationField<String>("OperationUnloadingPointName");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>OperationPersonResponsible</b>
     * </p>
     *
     * @return Personnel number
     */
    @SerializedName( "OperationPersonResponsible" )
    @JsonProperty( "OperationPersonResponsible" )
    @Nullable
    @ODataField( odataName = "OperationPersonResponsible" )
    private String operationPersonResponsible;
    /**
     * Use with available fluent helpers to apply the <b>OperationPersonResponsible</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> OPERATION_PERSON_RESPONSIBLE =
        new MaintenanceOrderOperationField<String>("OperationPersonResponsible");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryTimeInDays</b>
     * </p>
     *
     * @return Planned Delivery Time in Days
     */
    @SerializedName( "DeliveryTimeInDays" )
    @JsonProperty( "DeliveryTimeInDays" )
    @Nullable
    @ODataField( odataName = "DeliveryTimeInDays" )
    private BigDecimal deliveryTimeInDays;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryTimeInDays</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<BigDecimal> DELIVERY_TIME_IN_DAYS =
        new MaintenanceOrderOperationField<BigDecimal>("DeliveryTimeInDays");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrderOperationDuration</b>
     * </p>
     *
     * @return Normal Duration of Activity
     */
    @SerializedName( "MaintOrderOperationDuration" )
    @JsonProperty( "MaintOrderOperationDuration" )
    @Nullable
    @ODataField( odataName = "MaintOrderOperationDuration" )
    private BigDecimal maintOrderOperationDuration;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrderOperationDuration</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<BigDecimal> MAINT_ORDER_OPERATION_DURATION =
        new MaintenanceOrderOperationField<BigDecimal>("MaintOrderOperationDuration");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdOperationDurationUnit</b>
     * </p>
     *
     * @return Normal Duration/Unit
     */
    @SerializedName( "MaintOrdOperationDurationUnit" )
    @JsonProperty( "MaintOrdOperationDurationUnit" )
    @Nullable
    @ODataField( odataName = "MaintOrdOperationDurationUnit" )
    private String maintOrdOperationDurationUnit;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrdOperationDurationUnit</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> MAINT_ORD_OPERATION_DURATION_UNIT =
        new MaintenanceOrderOperationField<String>("MaintOrdOperationDurationUnit");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OpBscStartDateConstraintType</b>
     * </p>
     *
     * @return Constraint on the basic start date for the activity
     */
    @SerializedName( "OpBscStartDateConstraintType" )
    @JsonProperty( "OpBscStartDateConstraintType" )
    @Nullable
    @ODataField( odataName = "OpBscStartDateConstraintType" )
    private String opBscStartDateConstraintType;
    /**
     * Use with available fluent helpers to apply the <b>OpBscStartDateConstraintType</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> OP_BSC_START_DATE_CONSTRAINT_TYPE =
        new MaintenanceOrderOperationField<String>("OpBscStartDateConstraintType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OpBscEndDateConstraintType</b>
     * </p>
     *
     * @return Constraint on the finish date of the activity
     */
    @SerializedName( "OpBscEndDateConstraintType" )
    @JsonProperty( "OpBscEndDateConstraintType" )
    @Nullable
    @ODataField( odataName = "OpBscEndDateConstraintType" )
    private String opBscEndDateConstraintType;
    /**
     * Use with available fluent helpers to apply the <b>OpBscEndDateConstraintType</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> OP_BSC_END_DATE_CONSTRAINT_TYPE =
        new MaintenanceOrderOperationField<String>("OpBscEndDateConstraintType");
    /**
     * Constraints: Not nullable, Precision: 7, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdOperationWorkDuration</b>
     * </p>
     *
     * @return Work involved in the activity
     */
    @SerializedName( "MaintOrdOperationWorkDuration" )
    @JsonProperty( "MaintOrdOperationWorkDuration" )
    @Nullable
    @ODataField( odataName = "MaintOrdOperationWorkDuration" )
    private BigDecimal maintOrdOperationWorkDuration;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrdOperationWorkDuration</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<BigDecimal> MAINT_ORD_OPERATION_WORK_DURATION =
        new MaintenanceOrderOperationField<BigDecimal>("MaintOrdOperationWorkDuration");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdOpWorkDurationUnit</b>
     * </p>
     *
     * @return Unit for Work
     */
    @SerializedName( "MaintOrdOpWorkDurationUnit" )
    @JsonProperty( "MaintOrdOpWorkDurationUnit" )
    @Nullable
    @ODataField( odataName = "MaintOrdOpWorkDurationUnit" )
    private String maintOrdOpWorkDurationUnit;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrdOpWorkDurationUnit</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> MAINT_ORD_OP_WORK_DURATION_UNIT =
        new MaintenanceOrderOperationField<String>("MaintOrdOpWorkDurationUnit");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdOpConstraintStrtDteTme</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "MaintOrdOpConstraintStrtDteTme" )
    @JsonProperty( "MaintOrdOpConstraintStrtDteTme" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "MaintOrdOpConstraintStrtDteTme",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime maintOrdOpConstraintStrtDteTme;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrdOpConstraintStrtDteTme</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<ZonedDateTime> MAINT_ORD_OP_CONSTRAINT_STRT_DTE_TME =
        new MaintenanceOrderOperationField<ZonedDateTime>("MaintOrdOpConstraintStrtDteTme");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConstraintDateForBscStartDate</b>
     * </p>
     *
     * @return The constraintDateForBscStartDate contained in this entity.
     */
    @SerializedName( "ConstraintDateForBscStartDate" )
    @JsonProperty( "ConstraintDateForBscStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ConstraintDateForBscStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime constraintDateForBscStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ConstraintDateForBscStartDate</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<LocalDateTime> CONSTRAINT_DATE_FOR_BSC_START_DATE =
        new MaintenanceOrderOperationField<LocalDateTime>("ConstraintDateForBscStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConstraintTimeForBscStartTime</b>
     * </p>
     *
     * @return The constraintTimeForBscStartTime contained in this entity.
     */
    @SerializedName( "ConstraintTimeForBscStartTime" )
    @JsonProperty( "ConstraintTimeForBscStartTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "ConstraintTimeForBscStartTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime constraintTimeForBscStartTime;
    /**
     * Use with available fluent helpers to apply the <b>ConstraintTimeForBscStartTime</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<LocalTime> CONSTRAINT_TIME_FOR_BSC_START_TIME =
        new MaintenanceOrderOperationField<LocalTime>("ConstraintTimeForBscStartTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdOpCstrtFinishDteTme</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "MaintOrdOpCstrtFinishDteTme" )
    @JsonProperty( "MaintOrdOpCstrtFinishDteTme" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "MaintOrdOpCstrtFinishDteTme",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime maintOrdOpCstrtFinishDteTme;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrdOpCstrtFinishDteTme</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<ZonedDateTime> MAINT_ORD_OP_CSTRT_FINISH_DTE_TME =
        new MaintenanceOrderOperationField<ZonedDateTime>("MaintOrdOpCstrtFinishDteTme");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConstraintDateForBscFinishDate</b>
     * </p>
     *
     * @return The constraintDateForBscFinishDate contained in this entity.
     */
    @SerializedName( "ConstraintDateForBscFinishDate" )
    @JsonProperty( "ConstraintDateForBscFinishDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ConstraintDateForBscFinishDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime constraintDateForBscFinishDate;
    /**
     * Use with available fluent helpers to apply the <b>ConstraintDateForBscFinishDate</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<LocalDateTime> CONSTRAINT_DATE_FOR_BSC_FINISH_DATE =
        new MaintenanceOrderOperationField<LocalDateTime>("ConstraintDateForBscFinishDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConstraintTimeForBscFinishTime</b>
     * </p>
     *
     * @return The constraintTimeForBscFinishTime contained in this entity.
     */
    @SerializedName( "ConstraintTimeForBscFinishTime" )
    @JsonProperty( "ConstraintTimeForBscFinishTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "ConstraintTimeForBscFinishTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime constraintTimeForBscFinishTime;
    /**
     * Use with available fluent helpers to apply the <b>ConstraintTimeForBscFinishTime</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<LocalTime> CONSTRAINT_TIME_FOR_BSC_FINISH_TIME =
        new MaintenanceOrderOperationField<LocalTime>("ConstraintTimeForBscFinishTime");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdOperationExecutionRate</b>
     * </p>
     *
     * @return Execution Factor
     */
    @SerializedName( "MaintOrdOperationExecutionRate" )
    @JsonProperty( "MaintOrdOperationExecutionRate" )
    @Nullable
    @ODataField( odataName = "MaintOrdOperationExecutionRate" )
    private BigDecimal maintOrdOperationExecutionRate;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrdOperationExecutionRate</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<BigDecimal> MAINT_ORD_OPERATION_EXECUTION_RATE =
        new MaintenanceOrderOperationField<BigDecimal>("MaintOrdOperationExecutionRate");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Equipment</b>
     * </p>
     *
     * @return Equipment Number
     */
    @SerializedName( "Equipment" )
    @JsonProperty( "Equipment" )
    @Nullable
    @ODataField( odataName = "Equipment" )
    private String equipment;
    /**
     * Use with available fluent helpers to apply the <b>Equipment</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> EQUIPMENT =
        new MaintenanceOrderOperationField<String>("Equipment");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocation</b>
     * </p>
     *
     * @return Functional Location
     */
    @SerializedName( "FunctionalLocation" )
    @JsonProperty( "FunctionalLocation" )
    @Nullable
    @ODataField( odataName = "FunctionalLocation" )
    private String functionalLocation;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalLocation</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> FUNCTIONAL_LOCATION =
        new MaintenanceOrderOperationField<String>("FunctionalLocation");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceActivityType</b>
     * </p>
     *
     * @return Maintenance activity type
     */
    @SerializedName( "MaintenanceActivityType" )
    @JsonProperty( "MaintenanceActivityType" )
    @Nullable
    @ODataField( odataName = "MaintenanceActivityType" )
    private String maintenanceActivityType;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceActivityType</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> MAINTENANCE_ACTIVITY_TYPE =
        new MaintenanceOrderOperationField<String>("MaintenanceActivityType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @return Business Area
     */
    @SerializedName( "BusinessArea" )
    @JsonProperty( "BusinessArea" )
    @Nullable
    @ODataField( odataName = "BusinessArea" )
    private String businessArea;
    /**
     * Use with available fluent helpers to apply the <b>BusinessArea</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> BUSINESS_AREA =
        new MaintenanceOrderOperationField<String>("BusinessArea");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @return Profit Center
     */
    @SerializedName( "ProfitCenter" )
    @JsonProperty( "ProfitCenter" )
    @Nullable
    @ODataField( odataName = "ProfitCenter" )
    private String profitCenter;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> PROFIT_CENTER =
        new MaintenanceOrderOperationField<String>("ProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostingSheet</b>
     * </p>
     *
     * @return Costing Sheet
     */
    @SerializedName( "CostingSheet" )
    @JsonProperty( "CostingSheet" )
    @Nullable
    @ODataField( odataName = "CostingSheet" )
    private String costingSheet;
    /**
     * Use with available fluent helpers to apply the <b>CostingSheet</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> COSTING_SHEET =
        new MaintenanceOrderOperationField<String>("CostingSheet");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     *
     * @return Tax Jurisdiction
     */
    @SerializedName( "TaxJurisdiction" )
    @JsonProperty( "TaxJurisdiction" )
    @Nullable
    @ODataField( odataName = "TaxJurisdiction" )
    private String taxJurisdiction;
    /**
     * Use with available fluent helpers to apply the <b>TaxJurisdiction</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> TAX_JURISDICTION =
        new MaintenanceOrderOperationField<String>("TaxJurisdiction");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @return Functional Area
     */
    @SerializedName( "FunctionalArea" )
    @JsonProperty( "FunctionalArea" )
    @Nullable
    @ODataField( odataName = "FunctionalArea" )
    private String functionalArea;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalArea</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> FUNCTIONAL_AREA =
        new MaintenanceOrderOperationField<String>("FunctionalArea");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaintControllingObjectClass</b>
     * </p>
     *
     * @return Object Class
     */
    @SerializedName( "MaintControllingObjectClass" )
    @JsonProperty( "MaintControllingObjectClass" )
    @Nullable
    @ODataField( odataName = "MaintControllingObjectClass" )
    private String maintControllingObjectClass;
    /**
     * Use with available fluent helpers to apply the <b>MaintControllingObjectClass</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> MAINT_CONTROLLING_OBJECT_CLASS =
        new MaintenanceOrderOperationField<String>("MaintControllingObjectClass");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WrkCtrIntCapRqmtsDistr</b>
     * </p>
     *
     * @return Distr.cap.reqmts (plant maint.,process order, network)
     */
    @SerializedName( "WrkCtrIntCapRqmtsDistr" )
    @JsonProperty( "WrkCtrIntCapRqmtsDistr" )
    @Nullable
    @ODataField( odataName = "WrkCtrIntCapRqmtsDistr" )
    private String wrkCtrIntCapRqmtsDistr;
    /**
     * Use with available fluent helpers to apply the <b>WrkCtrIntCapRqmtsDistr</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> WRK_CTR_INT_CAP_RQMTS_DISTR =
        new MaintenanceOrderOperationField<String>("WrkCtrIntCapRqmtsDistr");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdOperationOverheadCode</b>
     * </p>
     *
     * @return Overhead key
     */
    @SerializedName( "MaintOrdOperationOverheadCode" )
    @JsonProperty( "MaintOrdOperationOverheadCode" )
    @Nullable
    @ODataField( odataName = "MaintOrdOperationOverheadCode" )
    private String maintOrdOperationOverheadCode;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrdOperationOverheadCode</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> MAINT_ORD_OPERATION_OVERHEAD_CODE =
        new MaintenanceOrderOperationField<String>("MaintOrdOperationOverheadCode");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrderOperationQuantity</b>
     * </p>
     *
     * @return Operation Total Quantity
     */
    @SerializedName( "MaintOrderOperationQuantity" )
    @JsonProperty( "MaintOrderOperationQuantity" )
    @Nullable
    @ODataField( odataName = "MaintOrderOperationQuantity" )
    private BigDecimal maintOrderOperationQuantity;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrderOperationQuantity</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<BigDecimal> MAINT_ORDER_OPERATION_QUANTITY =
        new MaintenanceOrderOperationField<BigDecimal>("MaintOrderOperationQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdOperationQuantityUnit</b>
     * </p>
     *
     * @return Unit of Measure for Activity/Operation
     */
    @SerializedName( "MaintOrdOperationQuantityUnit" )
    @JsonProperty( "MaintOrdOperationQuantityUnit" )
    @Nullable
    @ODataField( odataName = "MaintOrdOperationQuantityUnit" )
    private String maintOrdOperationQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrdOperationQuantityUnit</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> MAINT_ORD_OPERATION_QUANTITY_UNIT =
        new MaintenanceOrderOperationField<String>("MaintOrdOperationQuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Assembly</b>
     * </p>
     *
     * @return Assembly
     */
    @SerializedName( "Assembly" )
    @JsonProperty( "Assembly" )
    @Nullable
    @ODataField( odataName = "Assembly" )
    private String assembly;
    /**
     * Use with available fluent helpers to apply the <b>Assembly</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> ASSEMBLY =
        new MaintenanceOrderOperationField<String>("Assembly");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MaintOperationExecStageCode</b>
     * </p>
     *
     * @return PRE MAIN POST
     */
    @SerializedName( "MaintOperationExecStageCode" )
    @JsonProperty( "MaintOperationExecStageCode" )
    @Nullable
    @ODataField( odataName = "MaintOperationExecStageCode" )
    private String maintOperationExecStageCode;
    /**
     * Use with available fluent helpers to apply the <b>MaintOperationExecStageCode</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> MAINT_OPERATION_EXEC_STAGE_CODE =
        new MaintenanceOrderOperationField<String>("MaintOperationExecStageCode");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdOpAssgdWBSElmntInt</b>
     * </p>
     *
     * @return WBS Element
     */
    @SerializedName( "MaintOrdOpAssgdWBSElmntInt" )
    @JsonProperty( "MaintOrdOpAssgdWBSElmntInt" )
    @Nullable
    @ODataField( odataName = "MaintOrdOpAssgdWBSElmntInt" )
    private String maintOrdOpAssgdWBSElmntInt;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrdOpAssgdWBSElmntInt</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> MAINT_ORD_OP_ASSGD_WBS_ELMNT_INT =
        new MaintenanceOrderOperationField<String>("MaintOrdOpAssgdWBSElmntInt");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @return Work Breakdown Structure Element (WBS Element)
     */
    @SerializedName( "WBSElement" )
    @JsonProperty( "WBSElement" )
    @Nullable
    @ODataField( odataName = "WBSElement" )
    private String wBSElement;
    /**
     * Use with available fluent helpers to apply the <b>WBSElement</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> WBS_ELEMENT =
        new MaintenanceOrderOperationField<String>("WBSElement");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsMarkedForDeletion</b>
     * </p>
     *
     * @return Deletion Flag
     */
    @SerializedName( "IsMarkedForDeletion" )
    @JsonProperty( "IsMarkedForDeletion" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsMarkedForDeletion" )
    private Boolean isMarkedForDeletion;
    /**
     * Use with available fluent helpers to apply the <b>IsMarkedForDeletion</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<Boolean> IS_MARKED_FOR_DELETION =
        new MaintenanceOrderOperationField<Boolean>("IsMarkedForDeletion");
    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrderOperationInternalID</b>
     * </p>
     *
     * @return Object Number
     */
    @SerializedName( "MaintOrderOperationInternalID" )
    @JsonProperty( "MaintOrderOperationInternalID" )
    @Nullable
    @ODataField( odataName = "MaintOrderOperationInternalID" )
    private String maintOrderOperationInternalID;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrderOperationInternalID</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> MAINT_ORDER_OPERATION_INTERNAL_ID =
        new MaintenanceOrderOperationField<String>("MaintOrderOperationInternalID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceObjectListItem</b>
     * </p>
     *
     * @return Object list counters
     */
    @SerializedName( "MaintenanceObjectListItem" )
    @JsonProperty( "MaintenanceObjectListItem" )
    @Nullable
    @ODataField( odataName = "MaintenanceObjectListItem" )
    private Integer maintenanceObjectListItem;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceObjectListItem</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<Integer> MAINTENANCE_OBJECT_LIST_ITEM =
        new MaintenanceOrderOperationField<Integer>("MaintenanceObjectListItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisition</b>
     * </p>
     *
     * @return Purchase Requisition Number
     */
    @SerializedName( "PurchaseRequisition" )
    @JsonProperty( "PurchaseRequisition" )
    @Nullable
    @ODataField( odataName = "PurchaseRequisition" )
    private String purchaseRequisition;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseRequisition</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> PURCHASE_REQUISITION =
        new MaintenanceOrderOperationField<String>("PurchaseRequisition");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisitionItem</b>
     * </p>
     *
     * @return Item Number of Purchase Requisition in Order
     */
    @SerializedName( "PurchaseRequisitionItem" )
    @JsonProperty( "PurchaseRequisitionItem" )
    @Nullable
    @ODataField( odataName = "PurchaseRequisitionItem" )
    private String purchaseRequisitionItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseRequisitionItem</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> PURCHASE_REQUISITION_ITEM =
        new MaintenanceOrderOperationField<String>("PurchaseRequisitionItem");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpErlstSchedldExecStrtDte</b>
     * </p>
     *
     * @return The opErlstSchedldExecStrtDte contained in this entity.
     */
    @SerializedName( "OpErlstSchedldExecStrtDte" )
    @JsonProperty( "OpErlstSchedldExecStrtDte" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "OpErlstSchedldExecStrtDte",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime opErlstSchedldExecStrtDte;
    /**
     * Use with available fluent helpers to apply the <b>OpErlstSchedldExecStrtDte</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<LocalDateTime> OP_ERLST_SCHEDLD_EXEC_STRT_DTE =
        new MaintenanceOrderOperationField<LocalDateTime>("OpErlstSchedldExecStrtDte");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpErlstSchedldExecStrtTme</b>
     * </p>
     *
     * @return The opErlstSchedldExecStrtTme contained in this entity.
     */
    @SerializedName( "OpErlstSchedldExecStrtTme" )
    @JsonProperty( "OpErlstSchedldExecStrtTme" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "OpErlstSchedldExecStrtTme",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime opErlstSchedldExecStrtTme;
    /**
     * Use with available fluent helpers to apply the <b>OpErlstSchedldExecStrtTme</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<LocalTime> OP_ERLST_SCHEDLD_EXEC_STRT_TME =
        new MaintenanceOrderOperationField<LocalTime>("OpErlstSchedldExecStrtTme");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpErlstSchedldExecEndDte</b>
     * </p>
     *
     * @return The opErlstSchedldExecEndDte contained in this entity.
     */
    @SerializedName( "OpErlstSchedldExecEndDte" )
    @JsonProperty( "OpErlstSchedldExecEndDte" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "OpErlstSchedldExecEndDte",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime opErlstSchedldExecEndDte;
    /**
     * Use with available fluent helpers to apply the <b>OpErlstSchedldExecEndDte</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<LocalDateTime> OP_ERLST_SCHEDLD_EXEC_END_DTE =
        new MaintenanceOrderOperationField<LocalDateTime>("OpErlstSchedldExecEndDte");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpErlstSchedldExecEndTme</b>
     * </p>
     *
     * @return The opErlstSchedldExecEndTme contained in this entity.
     */
    @SerializedName( "OpErlstSchedldExecEndTme" )
    @JsonProperty( "OpErlstSchedldExecEndTme" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "OpErlstSchedldExecEndTme",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime opErlstSchedldExecEndTme;
    /**
     * Use with available fluent helpers to apply the <b>OpErlstSchedldExecEndTme</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<LocalTime> OP_ERLST_SCHEDLD_EXEC_END_TME =
        new MaintenanceOrderOperationField<LocalTime>("OpErlstSchedldExecEndTme");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpLtstSchedldExecStrtDte</b>
     * </p>
     *
     * @return The opLtstSchedldExecStrtDte contained in this entity.
     */
    @SerializedName( "OpLtstSchedldExecStrtDte" )
    @JsonProperty( "OpLtstSchedldExecStrtDte" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "OpLtstSchedldExecStrtDte",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime opLtstSchedldExecStrtDte;
    /**
     * Use with available fluent helpers to apply the <b>OpLtstSchedldExecStrtDte</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<LocalDateTime> OP_LTST_SCHEDLD_EXEC_STRT_DTE =
        new MaintenanceOrderOperationField<LocalDateTime>("OpLtstSchedldExecStrtDte");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpLtstSchedldExecStrtTme</b>
     * </p>
     *
     * @return The opLtstSchedldExecStrtTme contained in this entity.
     */
    @SerializedName( "OpLtstSchedldExecStrtTme" )
    @JsonProperty( "OpLtstSchedldExecStrtTme" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "OpLtstSchedldExecStrtTme",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime opLtstSchedldExecStrtTme;
    /**
     * Use with available fluent helpers to apply the <b>OpLtstSchedldExecStrtTme</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<LocalTime> OP_LTST_SCHEDLD_EXEC_STRT_TME =
        new MaintenanceOrderOperationField<LocalTime>("OpLtstSchedldExecStrtTme");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpLtstSchedldExecEndDte</b>
     * </p>
     *
     * @return The opLtstSchedldExecEndDte contained in this entity.
     */
    @SerializedName( "OpLtstSchedldExecEndDte" )
    @JsonProperty( "OpLtstSchedldExecEndDte" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "OpLtstSchedldExecEndDte",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime opLtstSchedldExecEndDte;
    /**
     * Use with available fluent helpers to apply the <b>OpLtstSchedldExecEndDte</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<LocalDateTime> OP_LTST_SCHEDLD_EXEC_END_DTE =
        new MaintenanceOrderOperationField<LocalDateTime>("OpLtstSchedldExecEndDte");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpLtstSchedldExecEndTme</b>
     * </p>
     *
     * @return The opLtstSchedldExecEndTme contained in this entity.
     */
    @SerializedName( "OpLtstSchedldExecEndTme" )
    @JsonProperty( "OpLtstSchedldExecEndTme" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "OpLtstSchedldExecEndTme",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime opLtstSchedldExecEndTme;
    /**
     * Use with available fluent helpers to apply the <b>OpLtstSchedldExecEndTme</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<LocalTime> OP_LTST_SCHEDLD_EXEC_END_TME =
        new MaintenanceOrderOperationField<LocalTime>("OpLtstSchedldExecEndTme");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpActualExecutionStartDate</b>
     * </p>
     *
     * @return The opActualExecutionStartDate contained in this entity.
     */
    @SerializedName( "OpActualExecutionStartDate" )
    @JsonProperty( "OpActualExecutionStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "OpActualExecutionStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime opActualExecutionStartDate;
    /**
     * Use with available fluent helpers to apply the <b>OpActualExecutionStartDate</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<LocalDateTime> OP_ACTUAL_EXECUTION_START_DATE =
        new MaintenanceOrderOperationField<LocalDateTime>("OpActualExecutionStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpActualExecutionStartTime</b>
     * </p>
     *
     * @return The opActualExecutionStartTime contained in this entity.
     */
    @SerializedName( "OpActualExecutionStartTime" )
    @JsonProperty( "OpActualExecutionStartTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "OpActualExecutionStartTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime opActualExecutionStartTime;
    /**
     * Use with available fluent helpers to apply the <b>OpActualExecutionStartTime</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<LocalTime> OP_ACTUAL_EXECUTION_START_TIME =
        new MaintenanceOrderOperationField<LocalTime>("OpActualExecutionStartTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpActualExecutionEndDate</b>
     * </p>
     *
     * @return The opActualExecutionEndDate contained in this entity.
     */
    @SerializedName( "OpActualExecutionEndDate" )
    @JsonProperty( "OpActualExecutionEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "OpActualExecutionEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime opActualExecutionEndDate;
    /**
     * Use with available fluent helpers to apply the <b>OpActualExecutionEndDate</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<LocalDateTime> OP_ACTUAL_EXECUTION_END_DATE =
        new MaintenanceOrderOperationField<LocalDateTime>("OpActualExecutionEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpActualExecutionEndTime</b>
     * </p>
     *
     * @return The opActualExecutionEndTime contained in this entity.
     */
    @SerializedName( "OpActualExecutionEndTime" )
    @JsonProperty( "OpActualExecutionEndTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "OpActualExecutionEndTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime opActualExecutionEndTime;
    /**
     * Use with available fluent helpers to apply the <b>OpActualExecutionEndTime</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<LocalTime> OP_ACTUAL_EXECUTION_END_TIME =
        new MaintenanceOrderOperationField<LocalTime>("OpActualExecutionEndTime");
    /**
     * Constraints: Not nullable, Precision: 7, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>ForecastWorkQuantity</b>
     * </p>
     *
     * @return Forecast Work (Actual + Remaining)
     */
    @SerializedName( "ForecastWorkQuantity" )
    @JsonProperty( "ForecastWorkQuantity" )
    @Nullable
    @ODataField( odataName = "ForecastWorkQuantity" )
    private BigDecimal forecastWorkQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ForecastWorkQuantity</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<BigDecimal> FORECAST_WORK_QUANTITY =
        new MaintenanceOrderOperationField<BigDecimal>("ForecastWorkQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ActualWorkQuantity</b>
     * </p>
     *
     * @return Actual Work
     */
    @SerializedName( "ActualWorkQuantity" )
    @JsonProperty( "ActualWorkQuantity" )
    @Nullable
    @ODataField( odataName = "ActualWorkQuantity" )
    private BigDecimal actualWorkQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ActualWorkQuantity</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<BigDecimal> ACTUAL_WORK_QUANTITY =
        new MaintenanceOrderOperationField<BigDecimal>("ActualWorkQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdOpProcessPhaseCode</b>
     * </p>
     *
     * @return Process Phase
     */
    @SerializedName( "MaintOrdOpProcessPhaseCode" )
    @JsonProperty( "MaintOrdOpProcessPhaseCode" )
    @Nullable
    @ODataField( odataName = "MaintOrdOpProcessPhaseCode" )
    private String maintOrdOpProcessPhaseCode;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrdOpProcessPhaseCode</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> MAINT_ORD_OP_PROCESS_PHASE_CODE =
        new MaintenanceOrderOperationField<String>("MaintOrdOpProcessPhaseCode");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdOpProcessSubPhaseCode</b>
     * </p>
     *
     * @return Process Subphase
     */
    @SerializedName( "MaintOrdOpProcessSubPhaseCode" )
    @JsonProperty( "MaintOrdOpProcessSubPhaseCode" )
    @Nullable
    @ODataField( odataName = "MaintOrdOpProcessSubPhaseCode" )
    private String maintOrdOpProcessSubPhaseCode;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrdOpProcessSubPhaseCode</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> MAINT_ORD_OP_PROCESS_SUB_PHASE_CODE =
        new MaintenanceOrderOperationField<String>("MaintOrdOpProcessSubPhaseCode");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SystemStatusText</b>
     * </p>
     *
     * @return System Status Line
     */
    @SerializedName( "SystemStatusText" )
    @JsonProperty( "SystemStatusText" )
    @Nullable
    @ODataField( odataName = "SystemStatusText" )
    private String systemStatusText;
    /**
     * Use with available fluent helpers to apply the <b>SystemStatusText</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> SYSTEM_STATUS_TEXT =
        new MaintenanceOrderOperationField<String>("SystemStatusText");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>UserStatusText</b>
     * </p>
     *
     * @return User Status
     */
    @SerializedName( "UserStatusText" )
    @JsonProperty( "UserStatusText" )
    @Nullable
    @ODataField( odataName = "UserStatusText" )
    private String userStatusText;
    /**
     * Use with available fluent helpers to apply the <b>UserStatusText</b> field to query operations.
     *
     */
    public final static MaintenanceOrderOperationField<String> USER_STATUS_TEXT =
        new MaintenanceOrderOperationField<String>("UserStatusText");
    /**
     * Navigation property <b>to_MaintenanceOrder</b> for <b>MaintenanceOrderOperation</b> to single
     * <b>MaintenanceOrder</b>.
     *
     */
    @SerializedName( "to_MaintenanceOrder" )
    @JsonProperty( "to_MaintenanceOrder" )
    @ODataField( odataName = "to_MaintenanceOrder" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private MaintenanceOrder toMaintenanceOrder;
    /**
     * Navigation property <b>to_MaintOrderOpComponent</b> for <b>MaintenanceOrderOperation</b> to multiple
     * <b>MaintOrderOpComponent</b>.
     *
     */
    @SerializedName( "to_MaintOrderOpComponent" )
    @JsonProperty( "to_MaintOrderOpComponent" )
    @ODataField( odataName = "to_MaintOrderOpComponent" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MaintOrderOpComponent> toMaintOrderOpComponent;
    /**
     * Navigation property <b>to_MaintOrderOpLongText</b> for <b>MaintenanceOrderOperation</b> to multiple
     * <b>MaintOrderOpLongText</b>.
     *
     */
    @SerializedName( "to_MaintOrderOpLongText" )
    @JsonProperty( "to_MaintOrderOpLongText" )
    @ODataField( odataName = "to_MaintOrderOpLongText" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MaintOrderOpLongText> toMaintOrderOpLongText;
    /**
     * Navigation property <b>to_MaintOrderOpPhaseControl</b> for <b>MaintenanceOrderOperation</b> to multiple
     * <b>MaintOrderOpPhaseControl</b>.
     *
     */
    @SerializedName( "to_MaintOrderOpPhaseControl" )
    @JsonProperty( "to_MaintOrderOpPhaseControl" )
    @ODataField( odataName = "to_MaintOrderOpPhaseControl" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MaintOrderOpPhaseControl> toMaintOrderOpPhaseControl;
    /**
     * Navigation property <b>to_MaintOrderOpProdnRsceTool</b> for <b>MaintenanceOrderOperation</b> to multiple
     * <b>MaintOrderOpProdnRsceTool</b>.
     *
     */
    @SerializedName( "to_MaintOrderOpProdnRsceTool" )
    @JsonProperty( "to_MaintOrderOpProdnRsceTool" )
    @ODataField( odataName = "to_MaintOrderOpProdnRsceTool" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MaintOrderOpProdnRsceTool> toMaintOrderOpProdnRsceTool;
    /**
     * Navigation property <b>to_MaintOrderOpRelationship</b> for <b>MaintenanceOrderOperation</b> to multiple
     * <b>MaintOrderOpRelationship</b>.
     *
     */
    @SerializedName( "to_MaintOrderOpRelationship" )
    @JsonProperty( "to_MaintOrderOpRelationship" )
    @ODataField( odataName = "to_MaintOrderOpRelationship" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MaintOrderOpRelationship> toMaintOrderOpRelationship;
    /**
     * Use with available fluent helpers to apply the <b>to_MaintenanceOrder</b> navigation property to query
     * operations.
     *
     */
    public final static MaintenanceOrderOperationOneToOneLink<MaintenanceOrder> TO_MAINTENANCE_ORDER =
        new MaintenanceOrderOperationOneToOneLink<MaintenanceOrder>("to_MaintenanceOrder");
    /**
     * Use with available fluent helpers to apply the <b>to_MaintOrderOpComponent</b> navigation property to query
     * operations.
     *
     */
    public final static MaintenanceOrderOperationLink<MaintOrderOpComponent> TO_MAINT_ORDER_OP_COMPONENT =
        new MaintenanceOrderOperationLink<MaintOrderOpComponent>("to_MaintOrderOpComponent");
    /**
     * Use with available fluent helpers to apply the <b>to_MaintOrderOpLongText</b> navigation property to query
     * operations.
     *
     */
    public final static MaintenanceOrderOperationLink<MaintOrderOpLongText> TO_MAINT_ORDER_OP_LONG_TEXT =
        new MaintenanceOrderOperationLink<MaintOrderOpLongText>("to_MaintOrderOpLongText");
    /**
     * Use with available fluent helpers to apply the <b>to_MaintOrderOpPhaseControl</b> navigation property to query
     * operations.
     *
     */
    public final static MaintenanceOrderOperationLink<MaintOrderOpPhaseControl> TO_MAINT_ORDER_OP_PHASE_CONTROL =
        new MaintenanceOrderOperationLink<MaintOrderOpPhaseControl>("to_MaintOrderOpPhaseControl");
    /**
     * Use with available fluent helpers to apply the <b>to_MaintOrderOpProdnRsceTool</b> navigation property to query
     * operations.
     *
     */
    public final static MaintenanceOrderOperationLink<MaintOrderOpProdnRsceTool> TO_MAINT_ORDER_OP_PRODN_RSCE_TOOL =
        new MaintenanceOrderOperationLink<MaintOrderOpProdnRsceTool>("to_MaintOrderOpProdnRsceTool");
    /**
     * Use with available fluent helpers to apply the <b>to_MaintOrderOpRelationship</b> navigation property to query
     * operations.
     *
     */
    public final static MaintenanceOrderOperationLink<MaintOrderOpRelationship> TO_MAINT_ORDER_OP_RELATIONSHIP =
        new MaintenanceOrderOperationLink<MaintOrderOpRelationship>("to_MaintOrderOpRelationship");

    @Nonnull
    @Override
    public Class<MaintenanceOrderOperation> getType()
    {
        return MaintenanceOrderOperation.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrder</b>
     * </p>
     *
     * @param maintenanceOrder
     *            Order Number
     */
    public void setMaintenanceOrder( @Nullable final String maintenanceOrder )
    {
        rememberChangedField("MaintenanceOrder", this.maintenanceOrder);
        this.maintenanceOrder = maintenanceOrder;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderOperation</b>
     * </p>
     *
     * @param maintenanceOrderOperation
     *            Maintenance Order Operation
     */
    public void setMaintenanceOrderOperation( @Nullable final String maintenanceOrderOperation )
    {
        rememberChangedField("MaintenanceOrderOperation", this.maintenanceOrderOperation);
        this.maintenanceOrderOperation = maintenanceOrderOperation;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderSubOperation</b>
     * </p>
     *
     * @param maintenanceOrderSubOperation
     *            Maintenance Order Suboperation
     */
    public void setMaintenanceOrderSubOperation( @Nullable final String maintenanceOrderSubOperation )
    {
        rememberChangedField("MaintenanceOrderSubOperation", this.maintenanceOrderSubOperation);
        this.maintenanceOrderSubOperation = maintenanceOrderSubOperation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OperationControlKey</b>
     * </p>
     *
     * @param operationControlKey
     *            Control Key
     */
    public void setOperationControlKey( @Nullable final String operationControlKey )
    {
        rememberChangedField("OperationControlKey", this.operationControlKey);
        this.operationControlKey = operationControlKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>OperationWorkCenterInternalID</b>
     * </p>
     *
     * @param operationWorkCenterInternalID
     *            Object ID of the resource
     */
    public void setOperationWorkCenterInternalID( @Nullable final String operationWorkCenterInternalID )
    {
        rememberChangedField("OperationWorkCenterInternalID", this.operationWorkCenterInternalID);
        this.operationWorkCenterInternalID = operationWorkCenterInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenter</b>
     * </p>
     *
     * @param workCenter
     *            Work Center
     */
    public void setWorkCenter( @Nullable final String workCenter )
    {
        rememberChangedField("WorkCenter", this.workCenter);
        this.workCenter = workCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>OperationStandardTextCode</b>
     * </p>
     *
     * @param operationStandardTextCode
     *            Standard text key
     */
    public void setOperationStandardTextCode( @Nullable final String operationStandardTextCode )
    {
        rememberChangedField("OperationStandardTextCode", this.operationStandardTextCode);
        this.operationStandardTextCode = operationStandardTextCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>OperationDescription</b>
     * </p>
     *
     * @param operationDescription
     *            Operation Short Text
     */
    public void setOperationDescription( @Nullable final String operationDescription )
    {
        rememberChangedField("OperationDescription", this.operationDescription);
        this.operationDescription = operationDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrderRoutingNumber</b>
     * </p>
     *
     * @param maintOrderRoutingNumber
     *            Routing number of operations in the order
     */
    public void setMaintOrderRoutingNumber( @Nullable final String maintOrderRoutingNumber )
    {
        rememberChangedField("MaintOrderRoutingNumber", this.maintOrderRoutingNumber);
        this.maintOrderRoutingNumber = maintOrderRoutingNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderRoutingNode</b>
     * </p>
     *
     * @param maintenanceOrderRoutingNode
     *            General counter for order
     */
    public void setMaintenanceOrderRoutingNode( @Nullable final String maintenanceOrderRoutingNode )
    {
        rememberChangedField("MaintenanceOrderRoutingNode", this.maintenanceOrderRoutingNode);
        this.maintenanceOrderRoutingNode = maintenanceOrderRoutingNode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>SuperiorOperationInternalID</b>
     * </p>
     *
     * @param superiorOperationInternalID
     *            Node Number of the Superior Operation
     */
    public void setSuperiorOperationInternalID( @Nullable final String superiorOperationInternalID )
    {
        rememberChangedField("SuperiorOperationInternalID", this.superiorOperationInternalID);
        this.superiorOperationInternalID = superiorOperationInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OperationWorkCenterTypeCode</b>
     * </p>
     *
     * @param operationWorkCenterTypeCode
     *            The operationWorkCenterTypeCode to set.
     */
    public void setOperationWorkCenterTypeCode( @Nullable final String operationWorkCenterTypeCode )
    {
        rememberChangedField("OperationWorkCenterTypeCode", this.operationWorkCenterTypeCode);
        this.operationWorkCenterTypeCode = operationWorkCenterTypeCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfTimeTickets</b>
     * </p>
     *
     * @param numberOfTimeTickets
     *            Number of Time Tickets
     */
    public void setNumberOfTimeTickets( @Nullable final BigDecimal numberOfTimeTickets )
    {
        rememberChangedField("NumberOfTimeTickets", this.numberOfTimeTickets);
        this.numberOfTimeTickets = numberOfTimeTickets;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OperationPurgInfoRecdSearchTxt</b>
     * </p>
     *
     * @param operationPurgInfoRecdSearchTxt
     *            Sort Term for Non-Stock Info Records
     */
    public void setOperationPurgInfoRecdSearchTxt( @Nullable final String operationPurgInfoRecdSearchTxt )
    {
        rememberChangedField("OperationPurgInfoRecdSearchTxt", this.operationPurgInfoRecdSearchTxt);
        this.operationPurgInfoRecdSearchTxt = operationPurgInfoRecdSearchTxt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OperationSupplier</b>
     * </p>
     *
     * @param operationSupplier
     *            Account Number of Supplier
     */
    public void setOperationSupplier( @Nullable final String operationSupplier )
    {
        rememberChangedField("OperationSupplier", this.operationSupplier);
        this.operationSupplier = operationSupplier;
    }

    /**
     * Constraints: Not nullable, Precision: 11, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpExternalProcessingPrice</b>
     * </p>
     *
     * @param opExternalProcessingPrice
     *            Price
     */
    public void setOpExternalProcessingPrice( @Nullable final BigDecimal opExternalProcessingPrice )
    {
        rememberChangedField("OpExternalProcessingPrice", this.opExternalProcessingPrice);
        this.opExternalProcessingPrice = opExternalProcessingPrice;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>OpExternalProcessingCurrency</b>
     * </p>
     *
     * @param opExternalProcessingCurrency
     *            Currency Key
     */
    public void setOpExternalProcessingCurrency( @Nullable final String opExternalProcessingCurrency )
    {
        rememberChangedField("OpExternalProcessingCurrency", this.opExternalProcessingCurrency);
        this.opExternalProcessingCurrency = opExternalProcessingCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostElement</b>
     * </p>
     *
     * @param costElement
     *            Cost Element
     */
    public void setCostElement( @Nullable final String costElement )
    {
        rememberChangedField("CostElement", this.costElement);
        this.costElement = costElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OperationPurchasingInfoRecord</b>
     * </p>
     *
     * @param operationPurchasingInfoRecord
     *            Number of purchasing info record
     */
    public void setOperationPurchasingInfoRecord( @Nullable final String operationPurchasingInfoRecord )
    {
        rememberChangedField("OperationPurchasingInfoRecord", this.operationPurchasingInfoRecord);
        this.operationPurchasingInfoRecord = operationPurchasingInfoRecord;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @param purchasingOrganization
     *            Purchasing Organization
     */
    public void setPurchasingOrganization( @Nullable final String purchasingOrganization )
    {
        rememberChangedField("PurchasingOrganization", this.purchasingOrganization);
        this.purchasingOrganization = purchasingOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     *
     * @param purchasingGroup
     *            Purchasing Group for External Processing Activity
     */
    public void setPurchasingGroup( @Nullable final String purchasingGroup )
    {
        rememberChangedField("PurchasingGroup", this.purchasingGroup);
        this.purchasingGroup = purchasingGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @param materialGroup
     *            Material Group
     */
    public void setMaterialGroup( @Nullable final String materialGroup )
    {
        rememberChangedField("MaterialGroup", this.materialGroup);
        this.materialGroup = materialGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OpPurchaseOutlineAgreement</b>
     * </p>
     *
     * @param opPurchaseOutlineAgreement
     *            Number of principal purchase agreement
     */
    public void setOpPurchaseOutlineAgreement( @Nullable final String opPurchaseOutlineAgreement )
    {
        rememberChangedField("OpPurchaseOutlineAgreement", this.opPurchaseOutlineAgreement);
        this.opPurchaseOutlineAgreement = opPurchaseOutlineAgreement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>OpPurchaseOutlineAgreementItem</b>
     * </p>
     *
     * @param opPurchaseOutlineAgreementItem
     *            Item Number of Principal Purchase Agreement
     */
    public void setOpPurchaseOutlineAgreementItem( @Nullable final String opPurchaseOutlineAgreementItem )
    {
        rememberChangedField("OpPurchaseOutlineAgreementItem", this.opPurchaseOutlineAgreementItem);
        this.opPurchaseOutlineAgreementItem = opPurchaseOutlineAgreementItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>OperationRequisitionerName</b>
     * </p>
     *
     * @param operationRequisitionerName
     *            Name of requisitioner/requester
     */
    public void setOperationRequisitionerName( @Nullable final String operationRequisitionerName )
    {
        rememberChangedField("OperationRequisitionerName", this.operationRequisitionerName);
        this.operationRequisitionerName = operationRequisitionerName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OperationTrackingNumber</b>
     * </p>
     *
     * @param operationTrackingNumber
     *            Requirement Tracking Number
     */
    public void setOperationTrackingNumber( @Nullable final String operationTrackingNumber )
    {
        rememberChangedField("OperationTrackingNumber", this.operationTrackingNumber);
        this.operationTrackingNumber = operationTrackingNumber;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfCapacities</b>
     * </p>
     *
     * @param numberOfCapacities
     *            Number of capacities required
     */
    public void setNumberOfCapacities( @Nullable final Short numberOfCapacities )
    {
        rememberChangedField("NumberOfCapacities", this.numberOfCapacities);
        this.numberOfCapacities = numberOfCapacities;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>OperationWorkPercent</b>
     * </p>
     *
     * @param operationWorkPercent
     *            Work percentage
     */
    public void setOperationWorkPercent( @Nullable final Short operationWorkPercent )
    {
        rememberChangedField("OperationWorkPercent", this.operationWorkPercent);
        this.operationWorkPercent = operationWorkPercent;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OperationCalculationControl</b>
     * </p>
     *
     * @param operationCalculationControl
     *            Key for calculation
     */
    public void setOperationCalculationControl( @Nullable final String operationCalculationControl )
    {
        rememberChangedField("OperationCalculationControl", this.operationCalculationControl);
        this.operationCalculationControl = operationCalculationControl;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ActivityType</b>
     * </p>
     *
     * @param activityType
     *            Activity Type
     */
    public void setActivityType( @Nullable final String activityType )
    {
        rememberChangedField("ActivityType", this.activityType);
        this.activityType = activityType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OperationSystemCondition</b>
     * </p>
     *
     * @param operationSystemCondition
     *            System Condition
     */
    public void setOperationSystemCondition( @Nullable final String operationSystemCondition )
    {
        rememberChangedField("OperationSystemCondition", this.operationSystemCondition);
        this.operationSystemCondition = operationSystemCondition;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>OperationGoodsRecipientName</b>
     * </p>
     *
     * @param operationGoodsRecipientName
     *            Goods Recipient
     */
    public void setOperationGoodsRecipientName( @Nullable final String operationGoodsRecipientName )
    {
        rememberChangedField("OperationGoodsRecipientName", this.operationGoodsRecipientName);
        this.operationGoodsRecipientName = operationGoodsRecipientName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>OperationUnloadingPointName</b>
     * </p>
     *
     * @param operationUnloadingPointName
     *            Unloading Point
     */
    public void setOperationUnloadingPointName( @Nullable final String operationUnloadingPointName )
    {
        rememberChangedField("OperationUnloadingPointName", this.operationUnloadingPointName);
        this.operationUnloadingPointName = operationUnloadingPointName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>OperationPersonResponsible</b>
     * </p>
     *
     * @param operationPersonResponsible
     *            Personnel number
     */
    public void setOperationPersonResponsible( @Nullable final String operationPersonResponsible )
    {
        rememberChangedField("OperationPersonResponsible", this.operationPersonResponsible);
        this.operationPersonResponsible = operationPersonResponsible;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryTimeInDays</b>
     * </p>
     *
     * @param deliveryTimeInDays
     *            Planned Delivery Time in Days
     */
    public void setDeliveryTimeInDays( @Nullable final BigDecimal deliveryTimeInDays )
    {
        rememberChangedField("DeliveryTimeInDays", this.deliveryTimeInDays);
        this.deliveryTimeInDays = deliveryTimeInDays;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrderOperationDuration</b>
     * </p>
     *
     * @param maintOrderOperationDuration
     *            Normal Duration of Activity
     */
    public void setMaintOrderOperationDuration( @Nullable final BigDecimal maintOrderOperationDuration )
    {
        rememberChangedField("MaintOrderOperationDuration", this.maintOrderOperationDuration);
        this.maintOrderOperationDuration = maintOrderOperationDuration;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdOperationDurationUnit</b>
     * </p>
     *
     * @param maintOrdOperationDurationUnit
     *            Normal Duration/Unit
     */
    public void setMaintOrdOperationDurationUnit( @Nullable final String maintOrdOperationDurationUnit )
    {
        rememberChangedField("MaintOrdOperationDurationUnit", this.maintOrdOperationDurationUnit);
        this.maintOrdOperationDurationUnit = maintOrdOperationDurationUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OpBscStartDateConstraintType</b>
     * </p>
     *
     * @param opBscStartDateConstraintType
     *            Constraint on the basic start date for the activity
     */
    public void setOpBscStartDateConstraintType( @Nullable final String opBscStartDateConstraintType )
    {
        rememberChangedField("OpBscStartDateConstraintType", this.opBscStartDateConstraintType);
        this.opBscStartDateConstraintType = opBscStartDateConstraintType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OpBscEndDateConstraintType</b>
     * </p>
     *
     * @param opBscEndDateConstraintType
     *            Constraint on the finish date of the activity
     */
    public void setOpBscEndDateConstraintType( @Nullable final String opBscEndDateConstraintType )
    {
        rememberChangedField("OpBscEndDateConstraintType", this.opBscEndDateConstraintType);
        this.opBscEndDateConstraintType = opBscEndDateConstraintType;
    }

    /**
     * Constraints: Not nullable, Precision: 7, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdOperationWorkDuration</b>
     * </p>
     *
     * @param maintOrdOperationWorkDuration
     *            Work involved in the activity
     */
    public void setMaintOrdOperationWorkDuration( @Nullable final BigDecimal maintOrdOperationWorkDuration )
    {
        rememberChangedField("MaintOrdOperationWorkDuration", this.maintOrdOperationWorkDuration);
        this.maintOrdOperationWorkDuration = maintOrdOperationWorkDuration;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdOpWorkDurationUnit</b>
     * </p>
     *
     * @param maintOrdOpWorkDurationUnit
     *            Unit for Work
     */
    public void setMaintOrdOpWorkDurationUnit( @Nullable final String maintOrdOpWorkDurationUnit )
    {
        rememberChangedField("MaintOrdOpWorkDurationUnit", this.maintOrdOpWorkDurationUnit);
        this.maintOrdOpWorkDurationUnit = maintOrdOpWorkDurationUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdOpConstraintStrtDteTme</b>
     * </p>
     *
     * @param maintOrdOpConstraintStrtDteTme
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setMaintOrdOpConstraintStrtDteTme( @Nullable final ZonedDateTime maintOrdOpConstraintStrtDteTme )
    {
        rememberChangedField("MaintOrdOpConstraintStrtDteTme", this.maintOrdOpConstraintStrtDteTme);
        this.maintOrdOpConstraintStrtDteTme = maintOrdOpConstraintStrtDteTme;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConstraintDateForBscStartDate</b>
     * </p>
     *
     * @param constraintDateForBscStartDate
     *            The constraintDateForBscStartDate to set.
     */
    public void setConstraintDateForBscStartDate( @Nullable final LocalDateTime constraintDateForBscStartDate )
    {
        rememberChangedField("ConstraintDateForBscStartDate", this.constraintDateForBscStartDate);
        this.constraintDateForBscStartDate = constraintDateForBscStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConstraintTimeForBscStartTime</b>
     * </p>
     *
     * @param constraintTimeForBscStartTime
     *            The constraintTimeForBscStartTime to set.
     */
    public void setConstraintTimeForBscStartTime( @Nullable final LocalTime constraintTimeForBscStartTime )
    {
        rememberChangedField("ConstraintTimeForBscStartTime", this.constraintTimeForBscStartTime);
        this.constraintTimeForBscStartTime = constraintTimeForBscStartTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdOpCstrtFinishDteTme</b>
     * </p>
     *
     * @param maintOrdOpCstrtFinishDteTme
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setMaintOrdOpCstrtFinishDteTme( @Nullable final ZonedDateTime maintOrdOpCstrtFinishDteTme )
    {
        rememberChangedField("MaintOrdOpCstrtFinishDteTme", this.maintOrdOpCstrtFinishDteTme);
        this.maintOrdOpCstrtFinishDteTme = maintOrdOpCstrtFinishDteTme;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConstraintDateForBscFinishDate</b>
     * </p>
     *
     * @param constraintDateForBscFinishDate
     *            The constraintDateForBscFinishDate to set.
     */
    public void setConstraintDateForBscFinishDate( @Nullable final LocalDateTime constraintDateForBscFinishDate )
    {
        rememberChangedField("ConstraintDateForBscFinishDate", this.constraintDateForBscFinishDate);
        this.constraintDateForBscFinishDate = constraintDateForBscFinishDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConstraintTimeForBscFinishTime</b>
     * </p>
     *
     * @param constraintTimeForBscFinishTime
     *            The constraintTimeForBscFinishTime to set.
     */
    public void setConstraintTimeForBscFinishTime( @Nullable final LocalTime constraintTimeForBscFinishTime )
    {
        rememberChangedField("ConstraintTimeForBscFinishTime", this.constraintTimeForBscFinishTime);
        this.constraintTimeForBscFinishTime = constraintTimeForBscFinishTime;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdOperationExecutionRate</b>
     * </p>
     *
     * @param maintOrdOperationExecutionRate
     *            Execution Factor
     */
    public void setMaintOrdOperationExecutionRate( @Nullable final BigDecimal maintOrdOperationExecutionRate )
    {
        rememberChangedField("MaintOrdOperationExecutionRate", this.maintOrdOperationExecutionRate);
        this.maintOrdOperationExecutionRate = maintOrdOperationExecutionRate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Equipment</b>
     * </p>
     *
     * @param equipment
     *            Equipment Number
     */
    public void setEquipment( @Nullable final String equipment )
    {
        rememberChangedField("Equipment", this.equipment);
        this.equipment = equipment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocation</b>
     * </p>
     *
     * @param functionalLocation
     *            Functional Location
     */
    public void setFunctionalLocation( @Nullable final String functionalLocation )
    {
        rememberChangedField("FunctionalLocation", this.functionalLocation);
        this.functionalLocation = functionalLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceActivityType</b>
     * </p>
     *
     * @param maintenanceActivityType
     *            Maintenance activity type
     */
    public void setMaintenanceActivityType( @Nullable final String maintenanceActivityType )
    {
        rememberChangedField("MaintenanceActivityType", this.maintenanceActivityType);
        this.maintenanceActivityType = maintenanceActivityType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @param businessArea
     *            Business Area
     */
    public void setBusinessArea( @Nullable final String businessArea )
    {
        rememberChangedField("BusinessArea", this.businessArea);
        this.businessArea = businessArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @param profitCenter
     *            Profit Center
     */
    public void setProfitCenter( @Nullable final String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostingSheet</b>
     * </p>
     *
     * @param costingSheet
     *            Costing Sheet
     */
    public void setCostingSheet( @Nullable final String costingSheet )
    {
        rememberChangedField("CostingSheet", this.costingSheet);
        this.costingSheet = costingSheet;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     *
     * @param taxJurisdiction
     *            Tax Jurisdiction
     */
    public void setTaxJurisdiction( @Nullable final String taxJurisdiction )
    {
        rememberChangedField("TaxJurisdiction", this.taxJurisdiction);
        this.taxJurisdiction = taxJurisdiction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @param functionalArea
     *            Functional Area
     */
    public void setFunctionalArea( @Nullable final String functionalArea )
    {
        rememberChangedField("FunctionalArea", this.functionalArea);
        this.functionalArea = functionalArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaintControllingObjectClass</b>
     * </p>
     *
     * @param maintControllingObjectClass
     *            Object Class
     */
    public void setMaintControllingObjectClass( @Nullable final String maintControllingObjectClass )
    {
        rememberChangedField("MaintControllingObjectClass", this.maintControllingObjectClass);
        this.maintControllingObjectClass = maintControllingObjectClass;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WrkCtrIntCapRqmtsDistr</b>
     * </p>
     *
     * @param wrkCtrIntCapRqmtsDistr
     *            Distr.cap.reqmts (plant maint.,process order, network)
     */
    public void setWrkCtrIntCapRqmtsDistr( @Nullable final String wrkCtrIntCapRqmtsDistr )
    {
        rememberChangedField("WrkCtrIntCapRqmtsDistr", this.wrkCtrIntCapRqmtsDistr);
        this.wrkCtrIntCapRqmtsDistr = wrkCtrIntCapRqmtsDistr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdOperationOverheadCode</b>
     * </p>
     *
     * @param maintOrdOperationOverheadCode
     *            Overhead key
     */
    public void setMaintOrdOperationOverheadCode( @Nullable final String maintOrdOperationOverheadCode )
    {
        rememberChangedField("MaintOrdOperationOverheadCode", this.maintOrdOperationOverheadCode);
        this.maintOrdOperationOverheadCode = maintOrdOperationOverheadCode;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrderOperationQuantity</b>
     * </p>
     *
     * @param maintOrderOperationQuantity
     *            Operation Total Quantity
     */
    public void setMaintOrderOperationQuantity( @Nullable final BigDecimal maintOrderOperationQuantity )
    {
        rememberChangedField("MaintOrderOperationQuantity", this.maintOrderOperationQuantity);
        this.maintOrderOperationQuantity = maintOrderOperationQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdOperationQuantityUnit</b>
     * </p>
     *
     * @param maintOrdOperationQuantityUnit
     *            Unit of Measure for Activity/Operation
     */
    public void setMaintOrdOperationQuantityUnit( @Nullable final String maintOrdOperationQuantityUnit )
    {
        rememberChangedField("MaintOrdOperationQuantityUnit", this.maintOrdOperationQuantityUnit);
        this.maintOrdOperationQuantityUnit = maintOrdOperationQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Assembly</b>
     * </p>
     *
     * @param assembly
     *            Assembly
     */
    public void setAssembly( @Nullable final String assembly )
    {
        rememberChangedField("Assembly", this.assembly);
        this.assembly = assembly;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MaintOperationExecStageCode</b>
     * </p>
     *
     * @param maintOperationExecStageCode
     *            PRE MAIN POST
     */
    public void setMaintOperationExecStageCode( @Nullable final String maintOperationExecStageCode )
    {
        rememberChangedField("MaintOperationExecStageCode", this.maintOperationExecStageCode);
        this.maintOperationExecStageCode = maintOperationExecStageCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdOpAssgdWBSElmntInt</b>
     * </p>
     *
     * @param maintOrdOpAssgdWBSElmntInt
     *            WBS Element
     */
    public void setMaintOrdOpAssgdWBSElmntInt( @Nullable final String maintOrdOpAssgdWBSElmntInt )
    {
        rememberChangedField("MaintOrdOpAssgdWBSElmntInt", this.maintOrdOpAssgdWBSElmntInt);
        this.maintOrdOpAssgdWBSElmntInt = maintOrdOpAssgdWBSElmntInt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @param wBSElement
     *            Work Breakdown Structure Element (WBS Element)
     */
    public void setWBSElement( @Nullable final String wBSElement )
    {
        rememberChangedField("WBSElement", this.wBSElement);
        this.wBSElement = wBSElement;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsMarkedForDeletion</b>
     * </p>
     *
     * @param isMarkedForDeletion
     *            Deletion Flag
     */
    public void setIsMarkedForDeletion( @Nullable final Boolean isMarkedForDeletion )
    {
        rememberChangedField("IsMarkedForDeletion", this.isMarkedForDeletion);
        this.isMarkedForDeletion = isMarkedForDeletion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrderOperationInternalID</b>
     * </p>
     *
     * @param maintOrderOperationInternalID
     *            Object Number
     */
    public void setMaintOrderOperationInternalID( @Nullable final String maintOrderOperationInternalID )
    {
        rememberChangedField("MaintOrderOperationInternalID", this.maintOrderOperationInternalID);
        this.maintOrderOperationInternalID = maintOrderOperationInternalID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceObjectListItem</b>
     * </p>
     *
     * @param maintenanceObjectListItem
     *            Object list counters
     */
    public void setMaintenanceObjectListItem( @Nullable final Integer maintenanceObjectListItem )
    {
        rememberChangedField("MaintenanceObjectListItem", this.maintenanceObjectListItem);
        this.maintenanceObjectListItem = maintenanceObjectListItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisition</b>
     * </p>
     *
     * @param purchaseRequisition
     *            Purchase Requisition Number
     */
    public void setPurchaseRequisition( @Nullable final String purchaseRequisition )
    {
        rememberChangedField("PurchaseRequisition", this.purchaseRequisition);
        this.purchaseRequisition = purchaseRequisition;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisitionItem</b>
     * </p>
     *
     * @param purchaseRequisitionItem
     *            Item Number of Purchase Requisition in Order
     */
    public void setPurchaseRequisitionItem( @Nullable final String purchaseRequisitionItem )
    {
        rememberChangedField("PurchaseRequisitionItem", this.purchaseRequisitionItem);
        this.purchaseRequisitionItem = purchaseRequisitionItem;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpErlstSchedldExecStrtDte</b>
     * </p>
     *
     * @param opErlstSchedldExecStrtDte
     *            The opErlstSchedldExecStrtDte to set.
     */
    public void setOpErlstSchedldExecStrtDte( @Nullable final LocalDateTime opErlstSchedldExecStrtDte )
    {
        rememberChangedField("OpErlstSchedldExecStrtDte", this.opErlstSchedldExecStrtDte);
        this.opErlstSchedldExecStrtDte = opErlstSchedldExecStrtDte;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpErlstSchedldExecStrtTme</b>
     * </p>
     *
     * @param opErlstSchedldExecStrtTme
     *            The opErlstSchedldExecStrtTme to set.
     */
    public void setOpErlstSchedldExecStrtTme( @Nullable final LocalTime opErlstSchedldExecStrtTme )
    {
        rememberChangedField("OpErlstSchedldExecStrtTme", this.opErlstSchedldExecStrtTme);
        this.opErlstSchedldExecStrtTme = opErlstSchedldExecStrtTme;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpErlstSchedldExecEndDte</b>
     * </p>
     *
     * @param opErlstSchedldExecEndDte
     *            The opErlstSchedldExecEndDte to set.
     */
    public void setOpErlstSchedldExecEndDte( @Nullable final LocalDateTime opErlstSchedldExecEndDte )
    {
        rememberChangedField("OpErlstSchedldExecEndDte", this.opErlstSchedldExecEndDte);
        this.opErlstSchedldExecEndDte = opErlstSchedldExecEndDte;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpErlstSchedldExecEndTme</b>
     * </p>
     *
     * @param opErlstSchedldExecEndTme
     *            The opErlstSchedldExecEndTme to set.
     */
    public void setOpErlstSchedldExecEndTme( @Nullable final LocalTime opErlstSchedldExecEndTme )
    {
        rememberChangedField("OpErlstSchedldExecEndTme", this.opErlstSchedldExecEndTme);
        this.opErlstSchedldExecEndTme = opErlstSchedldExecEndTme;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpLtstSchedldExecStrtDte</b>
     * </p>
     *
     * @param opLtstSchedldExecStrtDte
     *            The opLtstSchedldExecStrtDte to set.
     */
    public void setOpLtstSchedldExecStrtDte( @Nullable final LocalDateTime opLtstSchedldExecStrtDte )
    {
        rememberChangedField("OpLtstSchedldExecStrtDte", this.opLtstSchedldExecStrtDte);
        this.opLtstSchedldExecStrtDte = opLtstSchedldExecStrtDte;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpLtstSchedldExecStrtTme</b>
     * </p>
     *
     * @param opLtstSchedldExecStrtTme
     *            The opLtstSchedldExecStrtTme to set.
     */
    public void setOpLtstSchedldExecStrtTme( @Nullable final LocalTime opLtstSchedldExecStrtTme )
    {
        rememberChangedField("OpLtstSchedldExecStrtTme", this.opLtstSchedldExecStrtTme);
        this.opLtstSchedldExecStrtTme = opLtstSchedldExecStrtTme;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpLtstSchedldExecEndDte</b>
     * </p>
     *
     * @param opLtstSchedldExecEndDte
     *            The opLtstSchedldExecEndDte to set.
     */
    public void setOpLtstSchedldExecEndDte( @Nullable final LocalDateTime opLtstSchedldExecEndDte )
    {
        rememberChangedField("OpLtstSchedldExecEndDte", this.opLtstSchedldExecEndDte);
        this.opLtstSchedldExecEndDte = opLtstSchedldExecEndDte;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpLtstSchedldExecEndTme</b>
     * </p>
     *
     * @param opLtstSchedldExecEndTme
     *            The opLtstSchedldExecEndTme to set.
     */
    public void setOpLtstSchedldExecEndTme( @Nullable final LocalTime opLtstSchedldExecEndTme )
    {
        rememberChangedField("OpLtstSchedldExecEndTme", this.opLtstSchedldExecEndTme);
        this.opLtstSchedldExecEndTme = opLtstSchedldExecEndTme;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpActualExecutionStartDate</b>
     * </p>
     *
     * @param opActualExecutionStartDate
     *            The opActualExecutionStartDate to set.
     */
    public void setOpActualExecutionStartDate( @Nullable final LocalDateTime opActualExecutionStartDate )
    {
        rememberChangedField("OpActualExecutionStartDate", this.opActualExecutionStartDate);
        this.opActualExecutionStartDate = opActualExecutionStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpActualExecutionStartTime</b>
     * </p>
     *
     * @param opActualExecutionStartTime
     *            The opActualExecutionStartTime to set.
     */
    public void setOpActualExecutionStartTime( @Nullable final LocalTime opActualExecutionStartTime )
    {
        rememberChangedField("OpActualExecutionStartTime", this.opActualExecutionStartTime);
        this.opActualExecutionStartTime = opActualExecutionStartTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpActualExecutionEndDate</b>
     * </p>
     *
     * @param opActualExecutionEndDate
     *            The opActualExecutionEndDate to set.
     */
    public void setOpActualExecutionEndDate( @Nullable final LocalDateTime opActualExecutionEndDate )
    {
        rememberChangedField("OpActualExecutionEndDate", this.opActualExecutionEndDate);
        this.opActualExecutionEndDate = opActualExecutionEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpActualExecutionEndTime</b>
     * </p>
     *
     * @param opActualExecutionEndTime
     *            The opActualExecutionEndTime to set.
     */
    public void setOpActualExecutionEndTime( @Nullable final LocalTime opActualExecutionEndTime )
    {
        rememberChangedField("OpActualExecutionEndTime", this.opActualExecutionEndTime);
        this.opActualExecutionEndTime = opActualExecutionEndTime;
    }

    /**
     * Constraints: Not nullable, Precision: 7, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>ForecastWorkQuantity</b>
     * </p>
     *
     * @param forecastWorkQuantity
     *            Forecast Work (Actual + Remaining)
     */
    public void setForecastWorkQuantity( @Nullable final BigDecimal forecastWorkQuantity )
    {
        rememberChangedField("ForecastWorkQuantity", this.forecastWorkQuantity);
        this.forecastWorkQuantity = forecastWorkQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ActualWorkQuantity</b>
     * </p>
     *
     * @param actualWorkQuantity
     *            Actual Work
     */
    public void setActualWorkQuantity( @Nullable final BigDecimal actualWorkQuantity )
    {
        rememberChangedField("ActualWorkQuantity", this.actualWorkQuantity);
        this.actualWorkQuantity = actualWorkQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdOpProcessPhaseCode</b>
     * </p>
     *
     * @param maintOrdOpProcessPhaseCode
     *            Process Phase
     */
    public void setMaintOrdOpProcessPhaseCode( @Nullable final String maintOrdOpProcessPhaseCode )
    {
        rememberChangedField("MaintOrdOpProcessPhaseCode", this.maintOrdOpProcessPhaseCode);
        this.maintOrdOpProcessPhaseCode = maintOrdOpProcessPhaseCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrdOpProcessSubPhaseCode</b>
     * </p>
     *
     * @param maintOrdOpProcessSubPhaseCode
     *            Process Subphase
     */
    public void setMaintOrdOpProcessSubPhaseCode( @Nullable final String maintOrdOpProcessSubPhaseCode )
    {
        rememberChangedField("MaintOrdOpProcessSubPhaseCode", this.maintOrdOpProcessSubPhaseCode);
        this.maintOrdOpProcessSubPhaseCode = maintOrdOpProcessSubPhaseCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SystemStatusText</b>
     * </p>
     *
     * @param systemStatusText
     *            System Status Line
     */
    public void setSystemStatusText( @Nullable final String systemStatusText )
    {
        rememberChangedField("SystemStatusText", this.systemStatusText);
        this.systemStatusText = systemStatusText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>UserStatusText</b>
     * </p>
     *
     * @param userStatusText
     *            User Status
     */
    public void setUserStatusText( @Nullable final String userStatusText )
    {
        rememberChangedField("UserStatusText", this.userStatusText);
        this.userStatusText = userStatusText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "MaintenanceOrderOperation";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("MaintenanceOrder", getMaintenanceOrder());
        result.put("MaintenanceOrderOperation", getMaintenanceOrderOperation());
        result.put("MaintenanceOrderSubOperation", getMaintenanceOrderSubOperation());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("MaintenanceOrder", getMaintenanceOrder());
        values.put("MaintenanceOrderOperation", getMaintenanceOrderOperation());
        values.put("MaintenanceOrderSubOperation", getMaintenanceOrderSubOperation());
        values.put("OperationControlKey", getOperationControlKey());
        values.put("OperationWorkCenterInternalID", getOperationWorkCenterInternalID());
        values.put("WorkCenter", getWorkCenter());
        values.put("Plant", getPlant());
        values.put("OperationStandardTextCode", getOperationStandardTextCode());
        values.put("OperationDescription", getOperationDescription());
        values.put("MaintOrderRoutingNumber", getMaintOrderRoutingNumber());
        values.put("MaintenanceOrderRoutingNode", getMaintenanceOrderRoutingNode());
        values.put("SuperiorOperationInternalID", getSuperiorOperationInternalID());
        values.put("OperationWorkCenterTypeCode", getOperationWorkCenterTypeCode());
        values.put("Language", getLanguage());
        values.put("NumberOfTimeTickets", getNumberOfTimeTickets());
        values.put("OperationPurgInfoRecdSearchTxt", getOperationPurgInfoRecdSearchTxt());
        values.put("OperationSupplier", getOperationSupplier());
        values.put("OpExternalProcessingPrice", getOpExternalProcessingPrice());
        values.put("OpExternalProcessingCurrency", getOpExternalProcessingCurrency());
        values.put("CostElement", getCostElement());
        values.put("OperationPurchasingInfoRecord", getOperationPurchasingInfoRecord());
        values.put("PurchasingOrganization", getPurchasingOrganization());
        values.put("PurchasingGroup", getPurchasingGroup());
        values.put("MaterialGroup", getMaterialGroup());
        values.put("OpPurchaseOutlineAgreement", getOpPurchaseOutlineAgreement());
        values.put("OpPurchaseOutlineAgreementItem", getOpPurchaseOutlineAgreementItem());
        values.put("OperationRequisitionerName", getOperationRequisitionerName());
        values.put("OperationTrackingNumber", getOperationTrackingNumber());
        values.put("NumberOfCapacities", getNumberOfCapacities());
        values.put("OperationWorkPercent", getOperationWorkPercent());
        values.put("OperationCalculationControl", getOperationCalculationControl());
        values.put("ActivityType", getActivityType());
        values.put("OperationSystemCondition", getOperationSystemCondition());
        values.put("OperationGoodsRecipientName", getOperationGoodsRecipientName());
        values.put("OperationUnloadingPointName", getOperationUnloadingPointName());
        values.put("OperationPersonResponsible", getOperationPersonResponsible());
        values.put("DeliveryTimeInDays", getDeliveryTimeInDays());
        values.put("MaintOrderOperationDuration", getMaintOrderOperationDuration());
        values.put("MaintOrdOperationDurationUnit", getMaintOrdOperationDurationUnit());
        values.put("OpBscStartDateConstraintType", getOpBscStartDateConstraintType());
        values.put("OpBscEndDateConstraintType", getOpBscEndDateConstraintType());
        values.put("MaintOrdOperationWorkDuration", getMaintOrdOperationWorkDuration());
        values.put("MaintOrdOpWorkDurationUnit", getMaintOrdOpWorkDurationUnit());
        values.put("MaintOrdOpConstraintStrtDteTme", getMaintOrdOpConstraintStrtDteTme());
        values.put("ConstraintDateForBscStartDate", getConstraintDateForBscStartDate());
        values.put("ConstraintTimeForBscStartTime", getConstraintTimeForBscStartTime());
        values.put("MaintOrdOpCstrtFinishDteTme", getMaintOrdOpCstrtFinishDteTme());
        values.put("ConstraintDateForBscFinishDate", getConstraintDateForBscFinishDate());
        values.put("ConstraintTimeForBscFinishTime", getConstraintTimeForBscFinishTime());
        values.put("MaintOrdOperationExecutionRate", getMaintOrdOperationExecutionRate());
        values.put("Equipment", getEquipment());
        values.put("FunctionalLocation", getFunctionalLocation());
        values.put("MaintenanceActivityType", getMaintenanceActivityType());
        values.put("BusinessArea", getBusinessArea());
        values.put("ProfitCenter", getProfitCenter());
        values.put("CostingSheet", getCostingSheet());
        values.put("TaxJurisdiction", getTaxJurisdiction());
        values.put("FunctionalArea", getFunctionalArea());
        values.put("MaintControllingObjectClass", getMaintControllingObjectClass());
        values.put("WrkCtrIntCapRqmtsDistr", getWrkCtrIntCapRqmtsDistr());
        values.put("MaintOrdOperationOverheadCode", getMaintOrdOperationOverheadCode());
        values.put("MaintOrderOperationQuantity", getMaintOrderOperationQuantity());
        values.put("MaintOrdOperationQuantityUnit", getMaintOrdOperationQuantityUnit());
        values.put("Assembly", getAssembly());
        values.put("MaintOperationExecStageCode", getMaintOperationExecStageCode());
        values.put("MaintOrdOpAssgdWBSElmntInt", getMaintOrdOpAssgdWBSElmntInt());
        values.put("WBSElement", getWBSElement());
        values.put("IsMarkedForDeletion", getIsMarkedForDeletion());
        values.put("MaintOrderOperationInternalID", getMaintOrderOperationInternalID());
        values.put("MaintenanceObjectListItem", getMaintenanceObjectListItem());
        values.put("PurchaseRequisition", getPurchaseRequisition());
        values.put("PurchaseRequisitionItem", getPurchaseRequisitionItem());
        values.put("OpErlstSchedldExecStrtDte", getOpErlstSchedldExecStrtDte());
        values.put("OpErlstSchedldExecStrtTme", getOpErlstSchedldExecStrtTme());
        values.put("OpErlstSchedldExecEndDte", getOpErlstSchedldExecEndDte());
        values.put("OpErlstSchedldExecEndTme", getOpErlstSchedldExecEndTme());
        values.put("OpLtstSchedldExecStrtDte", getOpLtstSchedldExecStrtDte());
        values.put("OpLtstSchedldExecStrtTme", getOpLtstSchedldExecStrtTme());
        values.put("OpLtstSchedldExecEndDte", getOpLtstSchedldExecEndDte());
        values.put("OpLtstSchedldExecEndTme", getOpLtstSchedldExecEndTme());
        values.put("OpActualExecutionStartDate", getOpActualExecutionStartDate());
        values.put("OpActualExecutionStartTime", getOpActualExecutionStartTime());
        values.put("OpActualExecutionEndDate", getOpActualExecutionEndDate());
        values.put("OpActualExecutionEndTime", getOpActualExecutionEndTime());
        values.put("ForecastWorkQuantity", getForecastWorkQuantity());
        values.put("ActualWorkQuantity", getActualWorkQuantity());
        values.put("MaintOrdOpProcessPhaseCode", getMaintOrdOpProcessPhaseCode());
        values.put("MaintOrdOpProcessSubPhaseCode", getMaintOrdOpProcessSubPhaseCode());
        values.put("SystemStatusText", getSystemStatusText());
        values.put("UserStatusText", getUserStatusText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("MaintenanceOrder") ) {
                final Object value = values.remove("MaintenanceOrder");
                if( (value == null) || (!value.equals(getMaintenanceOrder())) ) {
                    setMaintenanceOrder(((String) value));
                }
            }
            if( values.containsKey("MaintenanceOrderOperation") ) {
                final Object value = values.remove("MaintenanceOrderOperation");
                if( (value == null) || (!value.equals(getMaintenanceOrderOperation())) ) {
                    setMaintenanceOrderOperation(((String) value));
                }
            }
            if( values.containsKey("MaintenanceOrderSubOperation") ) {
                final Object value = values.remove("MaintenanceOrderSubOperation");
                if( (value == null) || (!value.equals(getMaintenanceOrderSubOperation())) ) {
                    setMaintenanceOrderSubOperation(((String) value));
                }
            }
            if( values.containsKey("OperationControlKey") ) {
                final Object value = values.remove("OperationControlKey");
                if( (value == null) || (!value.equals(getOperationControlKey())) ) {
                    setOperationControlKey(((String) value));
                }
            }
            if( values.containsKey("OperationWorkCenterInternalID") ) {
                final Object value = values.remove("OperationWorkCenterInternalID");
                if( (value == null) || (!value.equals(getOperationWorkCenterInternalID())) ) {
                    setOperationWorkCenterInternalID(((String) value));
                }
            }
            if( values.containsKey("WorkCenter") ) {
                final Object value = values.remove("WorkCenter");
                if( (value == null) || (!value.equals(getWorkCenter())) ) {
                    setWorkCenter(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("OperationStandardTextCode") ) {
                final Object value = values.remove("OperationStandardTextCode");
                if( (value == null) || (!value.equals(getOperationStandardTextCode())) ) {
                    setOperationStandardTextCode(((String) value));
                }
            }
            if( values.containsKey("OperationDescription") ) {
                final Object value = values.remove("OperationDescription");
                if( (value == null) || (!value.equals(getOperationDescription())) ) {
                    setOperationDescription(((String) value));
                }
            }
            if( values.containsKey("MaintOrderRoutingNumber") ) {
                final Object value = values.remove("MaintOrderRoutingNumber");
                if( (value == null) || (!value.equals(getMaintOrderRoutingNumber())) ) {
                    setMaintOrderRoutingNumber(((String) value));
                }
            }
            if( values.containsKey("MaintenanceOrderRoutingNode") ) {
                final Object value = values.remove("MaintenanceOrderRoutingNode");
                if( (value == null) || (!value.equals(getMaintenanceOrderRoutingNode())) ) {
                    setMaintenanceOrderRoutingNode(((String) value));
                }
            }
            if( values.containsKey("SuperiorOperationInternalID") ) {
                final Object value = values.remove("SuperiorOperationInternalID");
                if( (value == null) || (!value.equals(getSuperiorOperationInternalID())) ) {
                    setSuperiorOperationInternalID(((String) value));
                }
            }
            if( values.containsKey("OperationWorkCenterTypeCode") ) {
                final Object value = values.remove("OperationWorkCenterTypeCode");
                if( (value == null) || (!value.equals(getOperationWorkCenterTypeCode())) ) {
                    setOperationWorkCenterTypeCode(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("NumberOfTimeTickets") ) {
                final Object value = values.remove("NumberOfTimeTickets");
                if( (value == null) || (!value.equals(getNumberOfTimeTickets())) ) {
                    setNumberOfTimeTickets(((BigDecimal) value));
                }
            }
            if( values.containsKey("OperationPurgInfoRecdSearchTxt") ) {
                final Object value = values.remove("OperationPurgInfoRecdSearchTxt");
                if( (value == null) || (!value.equals(getOperationPurgInfoRecdSearchTxt())) ) {
                    setOperationPurgInfoRecdSearchTxt(((String) value));
                }
            }
            if( values.containsKey("OperationSupplier") ) {
                final Object value = values.remove("OperationSupplier");
                if( (value == null) || (!value.equals(getOperationSupplier())) ) {
                    setOperationSupplier(((String) value));
                }
            }
            if( values.containsKey("OpExternalProcessingPrice") ) {
                final Object value = values.remove("OpExternalProcessingPrice");
                if( (value == null) || (!value.equals(getOpExternalProcessingPrice())) ) {
                    setOpExternalProcessingPrice(((BigDecimal) value));
                }
            }
            if( values.containsKey("OpExternalProcessingCurrency") ) {
                final Object value = values.remove("OpExternalProcessingCurrency");
                if( (value == null) || (!value.equals(getOpExternalProcessingCurrency())) ) {
                    setOpExternalProcessingCurrency(((String) value));
                }
            }
            if( values.containsKey("CostElement") ) {
                final Object value = values.remove("CostElement");
                if( (value == null) || (!value.equals(getCostElement())) ) {
                    setCostElement(((String) value));
                }
            }
            if( values.containsKey("OperationPurchasingInfoRecord") ) {
                final Object value = values.remove("OperationPurchasingInfoRecord");
                if( (value == null) || (!value.equals(getOperationPurchasingInfoRecord())) ) {
                    setOperationPurchasingInfoRecord(((String) value));
                }
            }
            if( values.containsKey("PurchasingOrganization") ) {
                final Object value = values.remove("PurchasingOrganization");
                if( (value == null) || (!value.equals(getPurchasingOrganization())) ) {
                    setPurchasingOrganization(((String) value));
                }
            }
            if( values.containsKey("PurchasingGroup") ) {
                final Object value = values.remove("PurchasingGroup");
                if( (value == null) || (!value.equals(getPurchasingGroup())) ) {
                    setPurchasingGroup(((String) value));
                }
            }
            if( values.containsKey("MaterialGroup") ) {
                final Object value = values.remove("MaterialGroup");
                if( (value == null) || (!value.equals(getMaterialGroup())) ) {
                    setMaterialGroup(((String) value));
                }
            }
            if( values.containsKey("OpPurchaseOutlineAgreement") ) {
                final Object value = values.remove("OpPurchaseOutlineAgreement");
                if( (value == null) || (!value.equals(getOpPurchaseOutlineAgreement())) ) {
                    setOpPurchaseOutlineAgreement(((String) value));
                }
            }
            if( values.containsKey("OpPurchaseOutlineAgreementItem") ) {
                final Object value = values.remove("OpPurchaseOutlineAgreementItem");
                if( (value == null) || (!value.equals(getOpPurchaseOutlineAgreementItem())) ) {
                    setOpPurchaseOutlineAgreementItem(((String) value));
                }
            }
            if( values.containsKey("OperationRequisitionerName") ) {
                final Object value = values.remove("OperationRequisitionerName");
                if( (value == null) || (!value.equals(getOperationRequisitionerName())) ) {
                    setOperationRequisitionerName(((String) value));
                }
            }
            if( values.containsKey("OperationTrackingNumber") ) {
                final Object value = values.remove("OperationTrackingNumber");
                if( (value == null) || (!value.equals(getOperationTrackingNumber())) ) {
                    setOperationTrackingNumber(((String) value));
                }
            }
            if( values.containsKey("NumberOfCapacities") ) {
                final Object value = values.remove("NumberOfCapacities");
                if( (value == null) || (!value.equals(getNumberOfCapacities())) ) {
                    setNumberOfCapacities(((Short) value));
                }
            }
            if( values.containsKey("OperationWorkPercent") ) {
                final Object value = values.remove("OperationWorkPercent");
                if( (value == null) || (!value.equals(getOperationWorkPercent())) ) {
                    setOperationWorkPercent(((Short) value));
                }
            }
            if( values.containsKey("OperationCalculationControl") ) {
                final Object value = values.remove("OperationCalculationControl");
                if( (value == null) || (!value.equals(getOperationCalculationControl())) ) {
                    setOperationCalculationControl(((String) value));
                }
            }
            if( values.containsKey("ActivityType") ) {
                final Object value = values.remove("ActivityType");
                if( (value == null) || (!value.equals(getActivityType())) ) {
                    setActivityType(((String) value));
                }
            }
            if( values.containsKey("OperationSystemCondition") ) {
                final Object value = values.remove("OperationSystemCondition");
                if( (value == null) || (!value.equals(getOperationSystemCondition())) ) {
                    setOperationSystemCondition(((String) value));
                }
            }
            if( values.containsKey("OperationGoodsRecipientName") ) {
                final Object value = values.remove("OperationGoodsRecipientName");
                if( (value == null) || (!value.equals(getOperationGoodsRecipientName())) ) {
                    setOperationGoodsRecipientName(((String) value));
                }
            }
            if( values.containsKey("OperationUnloadingPointName") ) {
                final Object value = values.remove("OperationUnloadingPointName");
                if( (value == null) || (!value.equals(getOperationUnloadingPointName())) ) {
                    setOperationUnloadingPointName(((String) value));
                }
            }
            if( values.containsKey("OperationPersonResponsible") ) {
                final Object value = values.remove("OperationPersonResponsible");
                if( (value == null) || (!value.equals(getOperationPersonResponsible())) ) {
                    setOperationPersonResponsible(((String) value));
                }
            }
            if( values.containsKey("DeliveryTimeInDays") ) {
                final Object value = values.remove("DeliveryTimeInDays");
                if( (value == null) || (!value.equals(getDeliveryTimeInDays())) ) {
                    setDeliveryTimeInDays(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaintOrderOperationDuration") ) {
                final Object value = values.remove("MaintOrderOperationDuration");
                if( (value == null) || (!value.equals(getMaintOrderOperationDuration())) ) {
                    setMaintOrderOperationDuration(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaintOrdOperationDurationUnit") ) {
                final Object value = values.remove("MaintOrdOperationDurationUnit");
                if( (value == null) || (!value.equals(getMaintOrdOperationDurationUnit())) ) {
                    setMaintOrdOperationDurationUnit(((String) value));
                }
            }
            if( values.containsKey("OpBscStartDateConstraintType") ) {
                final Object value = values.remove("OpBscStartDateConstraintType");
                if( (value == null) || (!value.equals(getOpBscStartDateConstraintType())) ) {
                    setOpBscStartDateConstraintType(((String) value));
                }
            }
            if( values.containsKey("OpBscEndDateConstraintType") ) {
                final Object value = values.remove("OpBscEndDateConstraintType");
                if( (value == null) || (!value.equals(getOpBscEndDateConstraintType())) ) {
                    setOpBscEndDateConstraintType(((String) value));
                }
            }
            if( values.containsKey("MaintOrdOperationWorkDuration") ) {
                final Object value = values.remove("MaintOrdOperationWorkDuration");
                if( (value == null) || (!value.equals(getMaintOrdOperationWorkDuration())) ) {
                    setMaintOrdOperationWorkDuration(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaintOrdOpWorkDurationUnit") ) {
                final Object value = values.remove("MaintOrdOpWorkDurationUnit");
                if( (value == null) || (!value.equals(getMaintOrdOpWorkDurationUnit())) ) {
                    setMaintOrdOpWorkDurationUnit(((String) value));
                }
            }
            if( values.containsKey("MaintOrdOpConstraintStrtDteTme") ) {
                final Object value = values.remove("MaintOrdOpConstraintStrtDteTme");
                if( (value == null) || (!value.equals(getMaintOrdOpConstraintStrtDteTme())) ) {
                    setMaintOrdOpConstraintStrtDteTme(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("ConstraintDateForBscStartDate") ) {
                final Object value = values.remove("ConstraintDateForBscStartDate");
                if( (value == null) || (!value.equals(getConstraintDateForBscStartDate())) ) {
                    setConstraintDateForBscStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ConstraintTimeForBscStartTime") ) {
                final Object value = values.remove("ConstraintTimeForBscStartTime");
                if( (value == null) || (!value.equals(getConstraintTimeForBscStartTime())) ) {
                    setConstraintTimeForBscStartTime(((LocalTime) value));
                }
            }
            if( values.containsKey("MaintOrdOpCstrtFinishDteTme") ) {
                final Object value = values.remove("MaintOrdOpCstrtFinishDteTme");
                if( (value == null) || (!value.equals(getMaintOrdOpCstrtFinishDteTme())) ) {
                    setMaintOrdOpCstrtFinishDteTme(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("ConstraintDateForBscFinishDate") ) {
                final Object value = values.remove("ConstraintDateForBscFinishDate");
                if( (value == null) || (!value.equals(getConstraintDateForBscFinishDate())) ) {
                    setConstraintDateForBscFinishDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ConstraintTimeForBscFinishTime") ) {
                final Object value = values.remove("ConstraintTimeForBscFinishTime");
                if( (value == null) || (!value.equals(getConstraintTimeForBscFinishTime())) ) {
                    setConstraintTimeForBscFinishTime(((LocalTime) value));
                }
            }
            if( values.containsKey("MaintOrdOperationExecutionRate") ) {
                final Object value = values.remove("MaintOrdOperationExecutionRate");
                if( (value == null) || (!value.equals(getMaintOrdOperationExecutionRate())) ) {
                    setMaintOrdOperationExecutionRate(((BigDecimal) value));
                }
            }
            if( values.containsKey("Equipment") ) {
                final Object value = values.remove("Equipment");
                if( (value == null) || (!value.equals(getEquipment())) ) {
                    setEquipment(((String) value));
                }
            }
            if( values.containsKey("FunctionalLocation") ) {
                final Object value = values.remove("FunctionalLocation");
                if( (value == null) || (!value.equals(getFunctionalLocation())) ) {
                    setFunctionalLocation(((String) value));
                }
            }
            if( values.containsKey("MaintenanceActivityType") ) {
                final Object value = values.remove("MaintenanceActivityType");
                if( (value == null) || (!value.equals(getMaintenanceActivityType())) ) {
                    setMaintenanceActivityType(((String) value));
                }
            }
            if( values.containsKey("BusinessArea") ) {
                final Object value = values.remove("BusinessArea");
                if( (value == null) || (!value.equals(getBusinessArea())) ) {
                    setBusinessArea(((String) value));
                }
            }
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((String) value));
                }
            }
            if( values.containsKey("CostingSheet") ) {
                final Object value = values.remove("CostingSheet");
                if( (value == null) || (!value.equals(getCostingSheet())) ) {
                    setCostingSheet(((String) value));
                }
            }
            if( values.containsKey("TaxJurisdiction") ) {
                final Object value = values.remove("TaxJurisdiction");
                if( (value == null) || (!value.equals(getTaxJurisdiction())) ) {
                    setTaxJurisdiction(((String) value));
                }
            }
            if( values.containsKey("FunctionalArea") ) {
                final Object value = values.remove("FunctionalArea");
                if( (value == null) || (!value.equals(getFunctionalArea())) ) {
                    setFunctionalArea(((String) value));
                }
            }
            if( values.containsKey("MaintControllingObjectClass") ) {
                final Object value = values.remove("MaintControllingObjectClass");
                if( (value == null) || (!value.equals(getMaintControllingObjectClass())) ) {
                    setMaintControllingObjectClass(((String) value));
                }
            }
            if( values.containsKey("WrkCtrIntCapRqmtsDistr") ) {
                final Object value = values.remove("WrkCtrIntCapRqmtsDistr");
                if( (value == null) || (!value.equals(getWrkCtrIntCapRqmtsDistr())) ) {
                    setWrkCtrIntCapRqmtsDistr(((String) value));
                }
            }
            if( values.containsKey("MaintOrdOperationOverheadCode") ) {
                final Object value = values.remove("MaintOrdOperationOverheadCode");
                if( (value == null) || (!value.equals(getMaintOrdOperationOverheadCode())) ) {
                    setMaintOrdOperationOverheadCode(((String) value));
                }
            }
            if( values.containsKey("MaintOrderOperationQuantity") ) {
                final Object value = values.remove("MaintOrderOperationQuantity");
                if( (value == null) || (!value.equals(getMaintOrderOperationQuantity())) ) {
                    setMaintOrderOperationQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaintOrdOperationQuantityUnit") ) {
                final Object value = values.remove("MaintOrdOperationQuantityUnit");
                if( (value == null) || (!value.equals(getMaintOrdOperationQuantityUnit())) ) {
                    setMaintOrdOperationQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("Assembly") ) {
                final Object value = values.remove("Assembly");
                if( (value == null) || (!value.equals(getAssembly())) ) {
                    setAssembly(((String) value));
                }
            }
            if( values.containsKey("MaintOperationExecStageCode") ) {
                final Object value = values.remove("MaintOperationExecStageCode");
                if( (value == null) || (!value.equals(getMaintOperationExecStageCode())) ) {
                    setMaintOperationExecStageCode(((String) value));
                }
            }
            if( values.containsKey("MaintOrdOpAssgdWBSElmntInt") ) {
                final Object value = values.remove("MaintOrdOpAssgdWBSElmntInt");
                if( (value == null) || (!value.equals(getMaintOrdOpAssgdWBSElmntInt())) ) {
                    setMaintOrdOpAssgdWBSElmntInt(((String) value));
                }
            }
            if( values.containsKey("WBSElement") ) {
                final Object value = values.remove("WBSElement");
                if( (value == null) || (!value.equals(getWBSElement())) ) {
                    setWBSElement(((String) value));
                }
            }
            if( values.containsKey("IsMarkedForDeletion") ) {
                final Object value = values.remove("IsMarkedForDeletion");
                if( (value == null) || (!value.equals(getIsMarkedForDeletion())) ) {
                    setIsMarkedForDeletion(((Boolean) value));
                }
            }
            if( values.containsKey("MaintOrderOperationInternalID") ) {
                final Object value = values.remove("MaintOrderOperationInternalID");
                if( (value == null) || (!value.equals(getMaintOrderOperationInternalID())) ) {
                    setMaintOrderOperationInternalID(((String) value));
                }
            }
            if( values.containsKey("MaintenanceObjectListItem") ) {
                final Object value = values.remove("MaintenanceObjectListItem");
                if( (value == null) || (!value.equals(getMaintenanceObjectListItem())) ) {
                    setMaintenanceObjectListItem(((Integer) value));
                }
            }
            if( values.containsKey("PurchaseRequisition") ) {
                final Object value = values.remove("PurchaseRequisition");
                if( (value == null) || (!value.equals(getPurchaseRequisition())) ) {
                    setPurchaseRequisition(((String) value));
                }
            }
            if( values.containsKey("PurchaseRequisitionItem") ) {
                final Object value = values.remove("PurchaseRequisitionItem");
                if( (value == null) || (!value.equals(getPurchaseRequisitionItem())) ) {
                    setPurchaseRequisitionItem(((String) value));
                }
            }
            if( values.containsKey("OpErlstSchedldExecStrtDte") ) {
                final Object value = values.remove("OpErlstSchedldExecStrtDte");
                if( (value == null) || (!value.equals(getOpErlstSchedldExecStrtDte())) ) {
                    setOpErlstSchedldExecStrtDte(((LocalDateTime) value));
                }
            }
            if( values.containsKey("OpErlstSchedldExecStrtTme") ) {
                final Object value = values.remove("OpErlstSchedldExecStrtTme");
                if( (value == null) || (!value.equals(getOpErlstSchedldExecStrtTme())) ) {
                    setOpErlstSchedldExecStrtTme(((LocalTime) value));
                }
            }
            if( values.containsKey("OpErlstSchedldExecEndDte") ) {
                final Object value = values.remove("OpErlstSchedldExecEndDte");
                if( (value == null) || (!value.equals(getOpErlstSchedldExecEndDte())) ) {
                    setOpErlstSchedldExecEndDte(((LocalDateTime) value));
                }
            }
            if( values.containsKey("OpErlstSchedldExecEndTme") ) {
                final Object value = values.remove("OpErlstSchedldExecEndTme");
                if( (value == null) || (!value.equals(getOpErlstSchedldExecEndTme())) ) {
                    setOpErlstSchedldExecEndTme(((LocalTime) value));
                }
            }
            if( values.containsKey("OpLtstSchedldExecStrtDte") ) {
                final Object value = values.remove("OpLtstSchedldExecStrtDte");
                if( (value == null) || (!value.equals(getOpLtstSchedldExecStrtDte())) ) {
                    setOpLtstSchedldExecStrtDte(((LocalDateTime) value));
                }
            }
            if( values.containsKey("OpLtstSchedldExecStrtTme") ) {
                final Object value = values.remove("OpLtstSchedldExecStrtTme");
                if( (value == null) || (!value.equals(getOpLtstSchedldExecStrtTme())) ) {
                    setOpLtstSchedldExecStrtTme(((LocalTime) value));
                }
            }
            if( values.containsKey("OpLtstSchedldExecEndDte") ) {
                final Object value = values.remove("OpLtstSchedldExecEndDte");
                if( (value == null) || (!value.equals(getOpLtstSchedldExecEndDte())) ) {
                    setOpLtstSchedldExecEndDte(((LocalDateTime) value));
                }
            }
            if( values.containsKey("OpLtstSchedldExecEndTme") ) {
                final Object value = values.remove("OpLtstSchedldExecEndTme");
                if( (value == null) || (!value.equals(getOpLtstSchedldExecEndTme())) ) {
                    setOpLtstSchedldExecEndTme(((LocalTime) value));
                }
            }
            if( values.containsKey("OpActualExecutionStartDate") ) {
                final Object value = values.remove("OpActualExecutionStartDate");
                if( (value == null) || (!value.equals(getOpActualExecutionStartDate())) ) {
                    setOpActualExecutionStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("OpActualExecutionStartTime") ) {
                final Object value = values.remove("OpActualExecutionStartTime");
                if( (value == null) || (!value.equals(getOpActualExecutionStartTime())) ) {
                    setOpActualExecutionStartTime(((LocalTime) value));
                }
            }
            if( values.containsKey("OpActualExecutionEndDate") ) {
                final Object value = values.remove("OpActualExecutionEndDate");
                if( (value == null) || (!value.equals(getOpActualExecutionEndDate())) ) {
                    setOpActualExecutionEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("OpActualExecutionEndTime") ) {
                final Object value = values.remove("OpActualExecutionEndTime");
                if( (value == null) || (!value.equals(getOpActualExecutionEndTime())) ) {
                    setOpActualExecutionEndTime(((LocalTime) value));
                }
            }
            if( values.containsKey("ForecastWorkQuantity") ) {
                final Object value = values.remove("ForecastWorkQuantity");
                if( (value == null) || (!value.equals(getForecastWorkQuantity())) ) {
                    setForecastWorkQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ActualWorkQuantity") ) {
                final Object value = values.remove("ActualWorkQuantity");
                if( (value == null) || (!value.equals(getActualWorkQuantity())) ) {
                    setActualWorkQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaintOrdOpProcessPhaseCode") ) {
                final Object value = values.remove("MaintOrdOpProcessPhaseCode");
                if( (value == null) || (!value.equals(getMaintOrdOpProcessPhaseCode())) ) {
                    setMaintOrdOpProcessPhaseCode(((String) value));
                }
            }
            if( values.containsKey("MaintOrdOpProcessSubPhaseCode") ) {
                final Object value = values.remove("MaintOrdOpProcessSubPhaseCode");
                if( (value == null) || (!value.equals(getMaintOrdOpProcessSubPhaseCode())) ) {
                    setMaintOrdOpProcessSubPhaseCode(((String) value));
                }
            }
            if( values.containsKey("SystemStatusText") ) {
                final Object value = values.remove("SystemStatusText");
                if( (value == null) || (!value.equals(getSystemStatusText())) ) {
                    setSystemStatusText(((String) value));
                }
            }
            if( values.containsKey("UserStatusText") ) {
                final Object value = values.remove("UserStatusText");
                if( (value == null) || (!value.equals(getUserStatusText())) ) {
                    setUserStatusText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_MaintenanceOrder") ) {
                final Object value = (values).remove("to_MaintenanceOrder");
                if( value instanceof Map ) {
                    if( toMaintenanceOrder == null ) {
                        toMaintenanceOrder = new MaintenanceOrder();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toMaintenanceOrder.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_MaintOrderOpComponent") ) {
                final Object value = (values).remove("to_MaintOrderOpComponent");
                if( value instanceof Iterable ) {
                    if( toMaintOrderOpComponent == null ) {
                        toMaintOrderOpComponent = Lists.newArrayList();
                    } else {
                        toMaintOrderOpComponent = Lists.newArrayList(toMaintOrderOpComponent);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MaintOrderOpComponent entity;
                        if( toMaintOrderOpComponent.size() > i ) {
                            entity = toMaintOrderOpComponent.get(i);
                        } else {
                            entity = new MaintOrderOpComponent();
                            toMaintOrderOpComponent.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_MaintOrderOpLongText") ) {
                final Object value = (values).remove("to_MaintOrderOpLongText");
                if( value instanceof Iterable ) {
                    if( toMaintOrderOpLongText == null ) {
                        toMaintOrderOpLongText = Lists.newArrayList();
                    } else {
                        toMaintOrderOpLongText = Lists.newArrayList(toMaintOrderOpLongText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MaintOrderOpLongText entity;
                        if( toMaintOrderOpLongText.size() > i ) {
                            entity = toMaintOrderOpLongText.get(i);
                        } else {
                            entity = new MaintOrderOpLongText();
                            toMaintOrderOpLongText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_MaintOrderOpPhaseControl") ) {
                final Object value = (values).remove("to_MaintOrderOpPhaseControl");
                if( value instanceof Iterable ) {
                    if( toMaintOrderOpPhaseControl == null ) {
                        toMaintOrderOpPhaseControl = Lists.newArrayList();
                    } else {
                        toMaintOrderOpPhaseControl = Lists.newArrayList(toMaintOrderOpPhaseControl);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MaintOrderOpPhaseControl entity;
                        if( toMaintOrderOpPhaseControl.size() > i ) {
                            entity = toMaintOrderOpPhaseControl.get(i);
                        } else {
                            entity = new MaintOrderOpPhaseControl();
                            toMaintOrderOpPhaseControl.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_MaintOrderOpProdnRsceTool") ) {
                final Object value = (values).remove("to_MaintOrderOpProdnRsceTool");
                if( value instanceof Iterable ) {
                    if( toMaintOrderOpProdnRsceTool == null ) {
                        toMaintOrderOpProdnRsceTool = Lists.newArrayList();
                    } else {
                        toMaintOrderOpProdnRsceTool = Lists.newArrayList(toMaintOrderOpProdnRsceTool);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MaintOrderOpProdnRsceTool entity;
                        if( toMaintOrderOpProdnRsceTool.size() > i ) {
                            entity = toMaintOrderOpProdnRsceTool.get(i);
                        } else {
                            entity = new MaintOrderOpProdnRsceTool();
                            toMaintOrderOpProdnRsceTool.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_MaintOrderOpRelationship") ) {
                final Object value = (values).remove("to_MaintOrderOpRelationship");
                if( value instanceof Iterable ) {
                    if( toMaintOrderOpRelationship == null ) {
                        toMaintOrderOpRelationship = Lists.newArrayList();
                    } else {
                        toMaintOrderOpRelationship = Lists.newArrayList(toMaintOrderOpRelationship);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MaintOrderOpRelationship entity;
                        if( toMaintOrderOpRelationship.size() > i ) {
                            entity = toMaintOrderOpRelationship.get(i);
                        } else {
                            entity = new MaintOrderOpRelationship();
                            toMaintOrderOpRelationship.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> MaintenanceOrderOperationField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new MaintenanceOrderOperationField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MaintenanceOrderOperationField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MaintenanceOrderOperationField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceOrderService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toMaintenanceOrder != null ) {
            (values).put("to_MaintenanceOrder", toMaintenanceOrder);
        }
        if( toMaintOrderOpComponent != null ) {
            (values).put("to_MaintOrderOpComponent", toMaintOrderOpComponent);
        }
        if( toMaintOrderOpLongText != null ) {
            (values).put("to_MaintOrderOpLongText", toMaintOrderOpLongText);
        }
        if( toMaintOrderOpPhaseControl != null ) {
            (values).put("to_MaintOrderOpPhaseControl", toMaintOrderOpPhaseControl);
        }
        if( toMaintOrderOpProdnRsceTool != null ) {
            (values).put("to_MaintOrderOpProdnRsceTool", toMaintOrderOpProdnRsceTool);
        }
        if( toMaintOrderOpRelationship != null ) {
            (values).put("to_MaintOrderOpRelationship", toMaintOrderOpRelationship);
        }
        return values;
    }

    /**
     * Fetches the <b>MaintenanceOrder</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_MaintenanceOrder</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>MaintenanceOrder</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceOrder fetchMaintenanceOrder()
    {
        return fetchFieldAsSingle("to_MaintenanceOrder", MaintenanceOrder.class);
    }

    /**
     * Retrieval of associated <b>MaintenanceOrder</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_MaintenanceOrder</b>.
     * <p>
     * If the navigation property <b>to_MaintenanceOrder</b> of a queried <b>MaintenanceOrderOperation</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintenanceOrder</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceOrder getMaintenanceOrderOrFetch()
    {
        if( toMaintenanceOrder == null ) {
            toMaintenanceOrder = fetchMaintenanceOrder();
        }
        return toMaintenanceOrder;
    }

    /**
     * Retrieval of associated <b>MaintenanceOrder</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_MaintenanceOrder</b>.
     * <p>
     * If the navigation property for an entity <b>MaintenanceOrderOperation</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaintenanceOrder</b> is already loaded, the result will
     *         contain the <b>MaintenanceOrder</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<MaintenanceOrder> getMaintenanceOrderIfPresent()
    {
        return Option.of(toMaintenanceOrder);
    }

    /**
     * Overwrites the associated <b>MaintenanceOrder</b> entity for the loaded navigation property
     * <b>to_MaintenanceOrder</b>.
     *
     * @param value
     *            New <b>MaintenanceOrder</b> entity.
     */
    public void setMaintenanceOrder( final MaintenanceOrder value )
    {
        toMaintenanceOrder = value;
    }

    /**
     * Fetches the <b>MaintOrderOpComponent</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_MaintOrderOpComponent</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>MaintOrderOpComponent</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintOrderOpComponent> fetchMaintOrderOpComponent()
    {
        return fetchFieldAsList("to_MaintOrderOpComponent", MaintOrderOpComponent.class);
    }

    /**
     * Retrieval of associated <b>MaintOrderOpComponent</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_MaintOrderOpComponent</b>.
     * <p>
     * If the navigation property <b>to_MaintOrderOpComponent</b> of a queried <b>MaintenanceOrderOperation</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintOrderOpComponent</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintOrderOpComponent> getMaintOrderOpComponentOrFetch()
    {
        if( toMaintOrderOpComponent == null ) {
            toMaintOrderOpComponent = fetchMaintOrderOpComponent();
        }
        return toMaintOrderOpComponent;
    }

    /**
     * Retrieval of associated <b>MaintOrderOpComponent</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_MaintOrderOpComponent</b>.
     * <p>
     * If the navigation property for an entity <b>MaintenanceOrderOperation</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaintOrderOpComponent</b> is already loaded, the result
     *         will contain the <b>MaintOrderOpComponent</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<MaintOrderOpComponent>> getMaintOrderOpComponentIfPresent()
    {
        return Option.of(toMaintOrderOpComponent);
    }

    /**
     * Overwrites the list of associated <b>MaintOrderOpComponent</b> entities for the loaded navigation property
     * <b>to_MaintOrderOpComponent</b>.
     * <p>
     * If the navigation property <b>to_MaintOrderOpComponent</b> of a queried <b>MaintenanceOrderOperation</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>MaintOrderOpComponent</b> entities.
     */
    public void setMaintOrderOpComponent( @Nonnull final List<MaintOrderOpComponent> value )
    {
        if( toMaintOrderOpComponent == null ) {
            toMaintOrderOpComponent = Lists.newArrayList();
        }
        toMaintOrderOpComponent.clear();
        toMaintOrderOpComponent.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MaintOrderOpComponent</b> entities. This corresponds to the OData
     * navigation property <b>to_MaintOrderOpComponent</b>.
     * <p>
     * If the navigation property <b>to_MaintOrderOpComponent</b> of a queried <b>MaintenanceOrderOperation</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>MaintOrderOpComponent</b> entities.
     */
    public void addMaintOrderOpComponent( MaintOrderOpComponent... entity )
    {
        if( toMaintOrderOpComponent == null ) {
            toMaintOrderOpComponent = Lists.newArrayList();
        }
        toMaintOrderOpComponent.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>MaintOrderOpLongText</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_MaintOrderOpLongText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>MaintOrderOpLongText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintOrderOpLongText> fetchMaintOrderOpLongText()
    {
        return fetchFieldAsList("to_MaintOrderOpLongText", MaintOrderOpLongText.class);
    }

    /**
     * Retrieval of associated <b>MaintOrderOpLongText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_MaintOrderOpLongText</b>.
     * <p>
     * If the navigation property <b>to_MaintOrderOpLongText</b> of a queried <b>MaintenanceOrderOperation</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintOrderOpLongText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintOrderOpLongText> getMaintOrderOpLongTextOrFetch()
    {
        if( toMaintOrderOpLongText == null ) {
            toMaintOrderOpLongText = fetchMaintOrderOpLongText();
        }
        return toMaintOrderOpLongText;
    }

    /**
     * Retrieval of associated <b>MaintOrderOpLongText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_MaintOrderOpLongText</b>.
     * <p>
     * If the navigation property for an entity <b>MaintenanceOrderOperation</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaintOrderOpLongText</b> is already loaded, the result
     *         will contain the <b>MaintOrderOpLongText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<MaintOrderOpLongText>> getMaintOrderOpLongTextIfPresent()
    {
        return Option.of(toMaintOrderOpLongText);
    }

    /**
     * Overwrites the list of associated <b>MaintOrderOpLongText</b> entities for the loaded navigation property
     * <b>to_MaintOrderOpLongText</b>.
     * <p>
     * If the navigation property <b>to_MaintOrderOpLongText</b> of a queried <b>MaintenanceOrderOperation</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>MaintOrderOpLongText</b> entities.
     */
    public void setMaintOrderOpLongText( @Nonnull final List<MaintOrderOpLongText> value )
    {
        if( toMaintOrderOpLongText == null ) {
            toMaintOrderOpLongText = Lists.newArrayList();
        }
        toMaintOrderOpLongText.clear();
        toMaintOrderOpLongText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MaintOrderOpLongText</b> entities. This corresponds to the OData
     * navigation property <b>to_MaintOrderOpLongText</b>.
     * <p>
     * If the navigation property <b>to_MaintOrderOpLongText</b> of a queried <b>MaintenanceOrderOperation</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>MaintOrderOpLongText</b> entities.
     */
    public void addMaintOrderOpLongText( MaintOrderOpLongText... entity )
    {
        if( toMaintOrderOpLongText == null ) {
            toMaintOrderOpLongText = Lists.newArrayList();
        }
        toMaintOrderOpLongText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>MaintOrderOpPhaseControl</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_MaintOrderOpPhaseControl</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>MaintOrderOpPhaseControl</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintOrderOpPhaseControl> fetchMaintOrderOpPhaseControl()
    {
        return fetchFieldAsList("to_MaintOrderOpPhaseControl", MaintOrderOpPhaseControl.class);
    }

    /**
     * Retrieval of associated <b>MaintOrderOpPhaseControl</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_MaintOrderOpPhaseControl</b>.
     * <p>
     * If the navigation property <b>to_MaintOrderOpPhaseControl</b> of a queried <b>MaintenanceOrderOperation</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintOrderOpPhaseControl</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintOrderOpPhaseControl> getMaintOrderOpPhaseControlOrFetch()
    {
        if( toMaintOrderOpPhaseControl == null ) {
            toMaintOrderOpPhaseControl = fetchMaintOrderOpPhaseControl();
        }
        return toMaintOrderOpPhaseControl;
    }

    /**
     * Retrieval of associated <b>MaintOrderOpPhaseControl</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_MaintOrderOpPhaseControl</b>.
     * <p>
     * If the navigation property for an entity <b>MaintenanceOrderOperation</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaintOrderOpPhaseControl</b> is already loaded, the
     *         result will contain the <b>MaintOrderOpPhaseControl</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<MaintOrderOpPhaseControl>> getMaintOrderOpPhaseControlIfPresent()
    {
        return Option.of(toMaintOrderOpPhaseControl);
    }

    /**
     * Overwrites the list of associated <b>MaintOrderOpPhaseControl</b> entities for the loaded navigation property
     * <b>to_MaintOrderOpPhaseControl</b>.
     * <p>
     * If the navigation property <b>to_MaintOrderOpPhaseControl</b> of a queried <b>MaintenanceOrderOperation</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>MaintOrderOpPhaseControl</b> entities.
     */
    public void setMaintOrderOpPhaseControl( @Nonnull final List<MaintOrderOpPhaseControl> value )
    {
        if( toMaintOrderOpPhaseControl == null ) {
            toMaintOrderOpPhaseControl = Lists.newArrayList();
        }
        toMaintOrderOpPhaseControl.clear();
        toMaintOrderOpPhaseControl.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MaintOrderOpPhaseControl</b> entities. This corresponds to the OData
     * navigation property <b>to_MaintOrderOpPhaseControl</b>.
     * <p>
     * If the navigation property <b>to_MaintOrderOpPhaseControl</b> of a queried <b>MaintenanceOrderOperation</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>MaintOrderOpPhaseControl</b> entities.
     */
    public void addMaintOrderOpPhaseControl( MaintOrderOpPhaseControl... entity )
    {
        if( toMaintOrderOpPhaseControl == null ) {
            toMaintOrderOpPhaseControl = Lists.newArrayList();
        }
        toMaintOrderOpPhaseControl.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>MaintOrderOpProdnRsceTool</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_MaintOrderOpProdnRsceTool</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>MaintOrderOpProdnRsceTool</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintOrderOpProdnRsceTool> fetchMaintOrderOpProdnRsceTool()
    {
        return fetchFieldAsList("to_MaintOrderOpProdnRsceTool", MaintOrderOpProdnRsceTool.class);
    }

    /**
     * Retrieval of associated <b>MaintOrderOpProdnRsceTool</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_MaintOrderOpProdnRsceTool</b>.
     * <p>
     * If the navigation property <b>to_MaintOrderOpProdnRsceTool</b> of a queried <b>MaintenanceOrderOperation</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintOrderOpProdnRsceTool</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintOrderOpProdnRsceTool> getMaintOrderOpProdnRsceToolOrFetch()
    {
        if( toMaintOrderOpProdnRsceTool == null ) {
            toMaintOrderOpProdnRsceTool = fetchMaintOrderOpProdnRsceTool();
        }
        return toMaintOrderOpProdnRsceTool;
    }

    /**
     * Retrieval of associated <b>MaintOrderOpProdnRsceTool</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_MaintOrderOpProdnRsceTool</b>.
     * <p>
     * If the navigation property for an entity <b>MaintenanceOrderOperation</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaintOrderOpProdnRsceTool</b> is already loaded, the
     *         result will contain the <b>MaintOrderOpProdnRsceTool</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<MaintOrderOpProdnRsceTool>> getMaintOrderOpProdnRsceToolIfPresent()
    {
        return Option.of(toMaintOrderOpProdnRsceTool);
    }

    /**
     * Overwrites the list of associated <b>MaintOrderOpProdnRsceTool</b> entities for the loaded navigation property
     * <b>to_MaintOrderOpProdnRsceTool</b>.
     * <p>
     * If the navigation property <b>to_MaintOrderOpProdnRsceTool</b> of a queried <b>MaintenanceOrderOperation</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>MaintOrderOpProdnRsceTool</b> entities.
     */
    public void setMaintOrderOpProdnRsceTool( @Nonnull final List<MaintOrderOpProdnRsceTool> value )
    {
        if( toMaintOrderOpProdnRsceTool == null ) {
            toMaintOrderOpProdnRsceTool = Lists.newArrayList();
        }
        toMaintOrderOpProdnRsceTool.clear();
        toMaintOrderOpProdnRsceTool.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MaintOrderOpProdnRsceTool</b> entities. This corresponds to the OData
     * navigation property <b>to_MaintOrderOpProdnRsceTool</b>.
     * <p>
     * If the navigation property <b>to_MaintOrderOpProdnRsceTool</b> of a queried <b>MaintenanceOrderOperation</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>MaintOrderOpProdnRsceTool</b> entities.
     */
    public void addMaintOrderOpProdnRsceTool( MaintOrderOpProdnRsceTool... entity )
    {
        if( toMaintOrderOpProdnRsceTool == null ) {
            toMaintOrderOpProdnRsceTool = Lists.newArrayList();
        }
        toMaintOrderOpProdnRsceTool.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>MaintOrderOpRelationship</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_MaintOrderOpRelationship</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>MaintOrderOpRelationship</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintOrderOpRelationship> fetchMaintOrderOpRelationship()
    {
        return fetchFieldAsList("to_MaintOrderOpRelationship", MaintOrderOpRelationship.class);
    }

    /**
     * Retrieval of associated <b>MaintOrderOpRelationship</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_MaintOrderOpRelationship</b>.
     * <p>
     * If the navigation property <b>to_MaintOrderOpRelationship</b> of a queried <b>MaintenanceOrderOperation</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintOrderOpRelationship</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintOrderOpRelationship> getMaintOrderOpRelationshipOrFetch()
    {
        if( toMaintOrderOpRelationship == null ) {
            toMaintOrderOpRelationship = fetchMaintOrderOpRelationship();
        }
        return toMaintOrderOpRelationship;
    }

    /**
     * Retrieval of associated <b>MaintOrderOpRelationship</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_MaintOrderOpRelationship</b>.
     * <p>
     * If the navigation property for an entity <b>MaintenanceOrderOperation</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaintOrderOpRelationship</b> is already loaded, the
     *         result will contain the <b>MaintOrderOpRelationship</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<MaintOrderOpRelationship>> getMaintOrderOpRelationshipIfPresent()
    {
        return Option.of(toMaintOrderOpRelationship);
    }

    /**
     * Overwrites the list of associated <b>MaintOrderOpRelationship</b> entities for the loaded navigation property
     * <b>to_MaintOrderOpRelationship</b>.
     * <p>
     * If the navigation property <b>to_MaintOrderOpRelationship</b> of a queried <b>MaintenanceOrderOperation</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>MaintOrderOpRelationship</b> entities.
     */
    public void setMaintOrderOpRelationship( @Nonnull final List<MaintOrderOpRelationship> value )
    {
        if( toMaintOrderOpRelationship == null ) {
            toMaintOrderOpRelationship = Lists.newArrayList();
        }
        toMaintOrderOpRelationship.clear();
        toMaintOrderOpRelationship.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MaintOrderOpRelationship</b> entities. This corresponds to the OData
     * navigation property <b>to_MaintOrderOpRelationship</b>.
     * <p>
     * If the navigation property <b>to_MaintOrderOpRelationship</b> of a queried <b>MaintenanceOrderOperation</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>MaintOrderOpRelationship</b> entities.
     */
    public void addMaintOrderOpRelationship( MaintOrderOpRelationship... entity )
    {
        if( toMaintOrderOpRelationship == null ) {
            toMaintOrderOpRelationship = Lists.newArrayList();
        }
        toMaintOrderOpRelationship.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of MaintenanceOrderOperation instances.
     *
     */
    public final static class MaintenanceOrderOperationBuilder
    {

        private MaintenanceOrder toMaintenanceOrder;
        private String maintenanceOrder = null;
        private List<MaintOrderOpComponent> toMaintOrderOpComponent = Lists.newArrayList();
        private List<MaintOrderOpLongText> toMaintOrderOpLongText = Lists.newArrayList();
        private List<MaintOrderOpPhaseControl> toMaintOrderOpPhaseControl = Lists.newArrayList();
        private List<MaintOrderOpProdnRsceTool> toMaintOrderOpProdnRsceTool = Lists.newArrayList();
        private List<MaintOrderOpRelationship> toMaintOrderOpRelationship = Lists.newArrayList();

        private MaintenanceOrderOperation.MaintenanceOrderOperationBuilder toMaintenanceOrder(
            final MaintenanceOrder value )
        {
            toMaintenanceOrder = value;
            return this;
        }

        /**
         * Navigation property <b>to_MaintenanceOrder</b> for <b>MaintenanceOrderOperation</b> to single
         * <b>MaintenanceOrder</b>.
         *
         * @param value
         *            The MaintenanceOrder to build this MaintenanceOrderOperation with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenanceOrderOperation.MaintenanceOrderOperationBuilder maintenanceOrder(
            final MaintenanceOrder value )
        {
            return toMaintenanceOrder(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 12
         * <p>
         * Original property name from the Odata EDM: <b>MaintenanceOrder</b>
         * </p>
         *
         * @param value
         *            The maintenanceOrder to build this MaintenanceOrderOperation with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenanceOrderOperation.MaintenanceOrderOperationBuilder maintenanceOrder( final String value )
        {
            maintenanceOrder = value;
            return this;
        }

        private MaintenanceOrderOperation.MaintenanceOrderOperationBuilder toMaintOrderOpComponent(
            final List<MaintOrderOpComponent> value )
        {
            toMaintOrderOpComponent.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_MaintOrderOpComponent</b> for <b>MaintenanceOrderOperation</b> to multiple
         * <b>MaintOrderOpComponent</b>.
         *
         * @param value
         *            The MaintOrderOpComponents to build this MaintenanceOrderOperation with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenanceOrderOperation.MaintenanceOrderOperationBuilder maintOrderOpComponent(
            MaintOrderOpComponent... value )
        {
            return toMaintOrderOpComponent(Lists.newArrayList(value));
        }

        private MaintenanceOrderOperation.MaintenanceOrderOperationBuilder toMaintOrderOpLongText(
            final List<MaintOrderOpLongText> value )
        {
            toMaintOrderOpLongText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_MaintOrderOpLongText</b> for <b>MaintenanceOrderOperation</b> to multiple
         * <b>MaintOrderOpLongText</b>.
         *
         * @param value
         *            The MaintOrderOpLongTexts to build this MaintenanceOrderOperation with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenanceOrderOperation.MaintenanceOrderOperationBuilder maintOrderOpLongText(
            MaintOrderOpLongText... value )
        {
            return toMaintOrderOpLongText(Lists.newArrayList(value));
        }

        private MaintenanceOrderOperation.MaintenanceOrderOperationBuilder toMaintOrderOpPhaseControl(
            final List<MaintOrderOpPhaseControl> value )
        {
            toMaintOrderOpPhaseControl.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_MaintOrderOpPhaseControl</b> for <b>MaintenanceOrderOperation</b> to multiple
         * <b>MaintOrderOpPhaseControl</b>.
         *
         * @param value
         *            The MaintOrderOpPhaseControls to build this MaintenanceOrderOperation with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenanceOrderOperation.MaintenanceOrderOperationBuilder maintOrderOpPhaseControl(
            MaintOrderOpPhaseControl... value )
        {
            return toMaintOrderOpPhaseControl(Lists.newArrayList(value));
        }

        private MaintenanceOrderOperation.MaintenanceOrderOperationBuilder toMaintOrderOpProdnRsceTool(
            final List<MaintOrderOpProdnRsceTool> value )
        {
            toMaintOrderOpProdnRsceTool.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_MaintOrderOpProdnRsceTool</b> for <b>MaintenanceOrderOperation</b> to multiple
         * <b>MaintOrderOpProdnRsceTool</b>.
         *
         * @param value
         *            The MaintOrderOpProdnRsceTools to build this MaintenanceOrderOperation with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenanceOrderOperation.MaintenanceOrderOperationBuilder maintOrderOpProdnRsceTool(
            MaintOrderOpProdnRsceTool... value )
        {
            return toMaintOrderOpProdnRsceTool(Lists.newArrayList(value));
        }

        private MaintenanceOrderOperation.MaintenanceOrderOperationBuilder toMaintOrderOpRelationship(
            final List<MaintOrderOpRelationship> value )
        {
            toMaintOrderOpRelationship.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_MaintOrderOpRelationship</b> for <b>MaintenanceOrderOperation</b> to multiple
         * <b>MaintOrderOpRelationship</b>.
         *
         * @param value
         *            The MaintOrderOpRelationships to build this MaintenanceOrderOperation with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenanceOrderOperation.MaintenanceOrderOperationBuilder maintOrderOpRelationship(
            MaintOrderOpRelationship... value )
        {
            return toMaintOrderOpRelationship(Lists.newArrayList(value));
        }

    }

}
