/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.field.MaintenanceOrderPartnerField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.link.MaintenanceOrderPartnerOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.selectable.MaintenanceOrderPartnerSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Maintenance Order Partners
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MaintenanceOrderPartner_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MaintenanceOrderPartner extends VdmEntity<MaintenanceOrderPartner>
{

    /**
     * Selector for all available fields of MaintenanceOrderPartner.
     *
     */
    public final static MaintenanceOrderPartnerSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrder</b>
     * </p>
     *
     * @return Order Number
     */
    @Key
    @SerializedName( "MaintenanceOrder" )
    @JsonProperty( "MaintenanceOrder" )
    @Nullable
    @ODataField( odataName = "MaintenanceOrder" )
    private String maintenanceOrder;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceOrder</b> field to query operations.
     *
     */
    public final static MaintenanceOrderPartnerField<String> MAINTENANCE_ORDER =
        new MaintenanceOrderPartnerField<String>("MaintenanceOrder");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunction</b>
     * </p>
     *
     * @return Partner Function
     */
    @Key
    @SerializedName( "PartnerFunction" )
    @JsonProperty( "PartnerFunction" )
    @Nullable
    @ODataField( odataName = "PartnerFunction" )
    private String partnerFunction;
    /**
     * Use with available fluent helpers to apply the <b>PartnerFunction</b> field to query operations.
     *
     */
    public final static MaintenanceOrderPartnerField<String> PARTNER_FUNCTION =
        new MaintenanceOrderPartnerField<String>("PartnerFunction");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderPartner</b>
     * </p>
     *
     * @return Partner
     */
    @Key
    @SerializedName( "MaintenanceOrderPartner" )
    @JsonProperty( "MaintenanceOrderPartner" )
    @Nullable
    @ODataField( odataName = "MaintenanceOrderPartner" )
    private String maintenanceOrderPartner;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceOrderPartner</b> field to query operations.
     *
     */
    public final static MaintenanceOrderPartnerField<String> MAINTENANCE_ORDER_PARTNER =
        new MaintenanceOrderPartnerField<String>("MaintenanceOrderPartner");
    /**
     * Navigation property <b>to_MaintenanceOrder</b> for <b>MaintenanceOrderPartner</b> to single
     * <b>MaintenanceOrder</b>.
     *
     */
    @SerializedName( "to_MaintenanceOrder" )
    @JsonProperty( "to_MaintenanceOrder" )
    @ODataField( odataName = "to_MaintenanceOrder" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private MaintenanceOrder toMaintenanceOrder;
    /**
     * Use with available fluent helpers to apply the <b>to_MaintenanceOrder</b> navigation property to query
     * operations.
     *
     */
    public final static MaintenanceOrderPartnerOneToOneLink<MaintenanceOrder> TO_MAINTENANCE_ORDER =
        new MaintenanceOrderPartnerOneToOneLink<MaintenanceOrder>("to_MaintenanceOrder");

    @Nonnull
    @Override
    public Class<MaintenanceOrderPartner> getType()
    {
        return MaintenanceOrderPartner.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrder</b>
     * </p>
     *
     * @param maintenanceOrder
     *            Order Number
     */
    public void setMaintenanceOrder( @Nullable final String maintenanceOrder )
    {
        rememberChangedField("MaintenanceOrder", this.maintenanceOrder);
        this.maintenanceOrder = maintenanceOrder;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunction</b>
     * </p>
     *
     * @param partnerFunction
     *            Partner Function
     */
    public void setPartnerFunction( @Nullable final String partnerFunction )
    {
        rememberChangedField("PartnerFunction", this.partnerFunction);
        this.partnerFunction = partnerFunction;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderPartner</b>
     * </p>
     *
     * @param maintenanceOrderPartner
     *            Partner
     */
    public void setMaintenanceOrderPartner( @Nullable final String maintenanceOrderPartner )
    {
        rememberChangedField("MaintenanceOrderPartner", this.maintenanceOrderPartner);
        this.maintenanceOrderPartner = maintenanceOrderPartner;
    }

    @Override
    protected String getEntityCollection()
    {
        return "MaintenanceOrderPartner";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("MaintenanceOrder", getMaintenanceOrder());
        result.put("PartnerFunction", getPartnerFunction());
        result.put("MaintenanceOrderPartner", getMaintenanceOrderPartner());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("MaintenanceOrder", getMaintenanceOrder());
        values.put("PartnerFunction", getPartnerFunction());
        values.put("MaintenanceOrderPartner", getMaintenanceOrderPartner());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("MaintenanceOrder") ) {
                final Object value = values.remove("MaintenanceOrder");
                if( (value == null) || (!value.equals(getMaintenanceOrder())) ) {
                    setMaintenanceOrder(((String) value));
                }
            }
            if( values.containsKey("PartnerFunction") ) {
                final Object value = values.remove("PartnerFunction");
                if( (value == null) || (!value.equals(getPartnerFunction())) ) {
                    setPartnerFunction(((String) value));
                }
            }
            if( values.containsKey("MaintenanceOrderPartner") ) {
                final Object value = values.remove("MaintenanceOrderPartner");
                if( (value == null) || (!value.equals(getMaintenanceOrderPartner())) ) {
                    setMaintenanceOrderPartner(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_MaintenanceOrder") ) {
                final Object value = (values).remove("to_MaintenanceOrder");
                if( value instanceof Map ) {
                    if( toMaintenanceOrder == null ) {
                        toMaintenanceOrder = new MaintenanceOrder();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toMaintenanceOrder.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> MaintenanceOrderPartnerField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new MaintenanceOrderPartnerField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MaintenanceOrderPartnerField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MaintenanceOrderPartnerField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceOrderService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toMaintenanceOrder != null ) {
            (values).put("to_MaintenanceOrder", toMaintenanceOrder);
        }
        return values;
    }

    /**
     * Fetches the <b>MaintenanceOrder</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_MaintenanceOrder</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>MaintenanceOrder</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceOrder fetchMaintenanceOrder()
    {
        return fetchFieldAsSingle("to_MaintenanceOrder", MaintenanceOrder.class);
    }

    /**
     * Retrieval of associated <b>MaintenanceOrder</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_MaintenanceOrder</b>.
     * <p>
     * If the navigation property <b>to_MaintenanceOrder</b> of a queried <b>MaintenanceOrderPartner</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintenanceOrder</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceOrder getMaintenanceOrderOrFetch()
    {
        if( toMaintenanceOrder == null ) {
            toMaintenanceOrder = fetchMaintenanceOrder();
        }
        return toMaintenanceOrder;
    }

    /**
     * Retrieval of associated <b>MaintenanceOrder</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_MaintenanceOrder</b>.
     * <p>
     * If the navigation property for an entity <b>MaintenanceOrderPartner</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaintenanceOrder</b> is already loaded, the result will
     *         contain the <b>MaintenanceOrder</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<MaintenanceOrder> getMaintenanceOrderIfPresent()
    {
        return Option.of(toMaintenanceOrder);
    }

    /**
     * Overwrites the associated <b>MaintenanceOrder</b> entity for the loaded navigation property
     * <b>to_MaintenanceOrder</b>.
     *
     * @param value
     *            New <b>MaintenanceOrder</b> entity.
     */
    public void setMaintenanceOrder( final MaintenanceOrder value )
    {
        toMaintenanceOrder = value;
    }

    /**
     * Helper class to allow for fluent creation of MaintenanceOrderPartner instances.
     *
     */
    public final static class MaintenanceOrderPartnerBuilder
    {

        private MaintenanceOrder toMaintenanceOrder;
        private String maintenanceOrder = null;

        private MaintenanceOrderPartner.MaintenanceOrderPartnerBuilder toMaintenanceOrder(
            final MaintenanceOrder value )
        {
            toMaintenanceOrder = value;
            return this;
        }

        /**
         * Navigation property <b>to_MaintenanceOrder</b> for <b>MaintenanceOrderPartner</b> to single
         * <b>MaintenanceOrder</b>.
         *
         * @param value
         *            The MaintenanceOrder to build this MaintenanceOrderPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenanceOrderPartner.MaintenanceOrderPartnerBuilder maintenanceOrder( final MaintenanceOrder value )
        {
            return toMaintenanceOrder(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 12
         * <p>
         * Original property name from the Odata EDM: <b>MaintenanceOrder</b>
         * </p>
         *
         * @param value
         *            The maintenanceOrder to build this MaintenanceOrderPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenanceOrderPartner.MaintenanceOrderPartnerBuilder maintenanceOrder( final String value )
        {
            maintenanceOrder = value;
            return this;
        }

    }

}
