/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder;

import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.field.MaintnanceOrderPhaseControlField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.link.MaintnanceOrderPhaseControlOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.selectable.MaintnanceOrderPhaseControlSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Maintenance Order Phase Control
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MaintnanceOrderPhaseControl_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MaintnanceOrderPhaseControl extends VdmEntity<MaintnanceOrderPhaseControl>
{

    /**
     * Selector for all available fields of MaintnanceOrderPhaseControl.
     *
     */
    public final static MaintnanceOrderPhaseControlSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrder</b>
     * </p>
     *
     * @return Order Number
     */
    @Key
    @SerializedName( "MaintenanceOrder" )
    @JsonProperty( "MaintenanceOrder" )
    @Nullable
    @ODataField( odataName = "MaintenanceOrder" )
    private String maintenanceOrder;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceOrder</b> field to query operations.
     *
     */
    public final static MaintnanceOrderPhaseControlField<String> MAINTENANCE_ORDER =
        new MaintnanceOrderPhaseControlField<String>("MaintenanceOrder");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePhaseControl</b>
     * </p>
     *
     * @return Phase Control Code
     */
    @Key
    @SerializedName( "MaintenancePhaseControl" )
    @JsonProperty( "MaintenancePhaseControl" )
    @Nullable
    @ODataField( odataName = "MaintenancePhaseControl" )
    private String maintenancePhaseControl;
    /**
     * Use with available fluent helpers to apply the <b>MaintenancePhaseControl</b> field to query operations.
     *
     */
    public final static MaintnanceOrderPhaseControlField<String> MAINTENANCE_PHASE_CONTROL =
        new MaintnanceOrderPhaseControlField<String>("MaintenancePhaseControl");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePhaseControlName</b>
     * </p>
     *
     * @return Phase Control Code
     */
    @SerializedName( "MaintenancePhaseControlName" )
    @JsonProperty( "MaintenancePhaseControlName" )
    @Nullable
    @ODataField( odataName = "MaintenancePhaseControlName" )
    private String maintenancePhaseControlName;
    /**
     * Use with available fluent helpers to apply the <b>MaintenancePhaseControlName</b> field to query operations.
     *
     */
    public final static MaintnanceOrderPhaseControlField<String> MAINTENANCE_PHASE_CONTROL_NAME =
        new MaintnanceOrderPhaseControlField<String>("MaintenancePhaseControlName");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePhaseControlText</b>
     * </p>
     *
     * @return Description of the Phase Control Code
     */
    @SerializedName( "MaintenancePhaseControlText" )
    @JsonProperty( "MaintenancePhaseControlText" )
    @Nullable
    @ODataField( odataName = "MaintenancePhaseControlText" )
    private String maintenancePhaseControlText;
    /**
     * Use with available fluent helpers to apply the <b>MaintenancePhaseControlText</b> field to query operations.
     *
     */
    public final static MaintnanceOrderPhaseControlField<String> MAINTENANCE_PHASE_CONTROL_TEXT =
        new MaintnanceOrderPhaseControlField<String>("MaintenancePhaseControlText");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaintPhseCtrlIsSetAutomly</b>
     * </p>
     *
     * @return Phase Control Code: Set Automatically
     */
    @SerializedName( "MaintPhseCtrlIsSetAutomly" )
    @JsonProperty( "MaintPhseCtrlIsSetAutomly" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "MaintPhseCtrlIsSetAutomly" )
    private Boolean maintPhseCtrlIsSetAutomly;
    /**
     * Use with available fluent helpers to apply the <b>MaintPhseCtrlIsSetAutomly</b> field to query operations.
     *
     */
    public final static MaintnanceOrderPhaseControlField<Boolean> MAINT_PHSE_CTRL_IS_SET_AUTOMLY =
        new MaintnanceOrderPhaseControlField<Boolean>("MaintPhseCtrlIsSetAutomly");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MaintPhaseControlAuthorityCode</b>
     * </p>
     *
     * @return Authorization Key for Phase Control Code
     */
    @SerializedName( "MaintPhaseControlAuthorityCode" )
    @JsonProperty( "MaintPhaseControlAuthorityCode" )
    @Nullable
    @ODataField( odataName = "MaintPhaseControlAuthorityCode" )
    private String maintPhaseControlAuthorityCode;
    /**
     * Use with available fluent helpers to apply the <b>MaintPhaseControlAuthorityCode</b> field to query operations.
     *
     */
    public final static MaintnanceOrderPhaseControlField<String> MAINT_PHASE_CONTROL_AUTHORITY_CODE =
        new MaintnanceOrderPhaseControlField<String>("MaintPhaseControlAuthorityCode");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaintProcgPhseCtrlActvtnCode</b>
     * </p>
     *
     * @return Phase Control Key
     */
    @SerializedName( "MaintProcgPhseCtrlActvtnCode" )
    @JsonProperty( "MaintProcgPhseCtrlActvtnCode" )
    @Nullable
    @ODataField( odataName = "MaintProcgPhseCtrlActvtnCode" )
    private String maintProcgPhseCtrlActvtnCode;
    /**
     * Use with available fluent helpers to apply the <b>MaintProcgPhseCtrlActvtnCode</b> field to query operations.
     *
     */
    public final static MaintnanceOrderPhaseControlField<String> MAINT_PROCG_PHSE_CTRL_ACTVTN_CODE =
        new MaintnanceOrderPhaseControlField<String>("MaintProcgPhseCtrlActvtnCode");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>MaintProcgPhseCtrlActvtnDesc</b>
     * </p>
     *
     * @return Short Text for Fixed Values
     */
    @SerializedName( "MaintProcgPhseCtrlActvtnDesc" )
    @JsonProperty( "MaintProcgPhseCtrlActvtnDesc" )
    @Nullable
    @ODataField( odataName = "MaintProcgPhseCtrlActvtnDesc" )
    private String maintProcgPhseCtrlActvtnDesc;
    /**
     * Use with available fluent helpers to apply the <b>MaintProcgPhseCtrlActvtnDesc</b> field to query operations.
     *
     */
    public final static MaintnanceOrderPhaseControlField<String> MAINT_PROCG_PHSE_CTRL_ACTVTN_DESC =
        new MaintnanceOrderPhaseControlField<String>("MaintProcgPhseCtrlActvtnDesc");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>EAMProcessPhaseCode</b>
     * </p>
     *
     * @return Process Phase
     */
    @SerializedName( "EAMProcessPhaseCode" )
    @JsonProperty( "EAMProcessPhaseCode" )
    @Nullable
    @ODataField( odataName = "EAMProcessPhaseCode" )
    private String eAMProcessPhaseCode;
    /**
     * Use with available fluent helpers to apply the <b>EAMProcessPhaseCode</b> field to query operations.
     *
     */
    public final static MaintnanceOrderPhaseControlField<String> EAM_PROCESS_PHASE_CODE =
        new MaintnanceOrderPhaseControlField<String>("EAMProcessPhaseCode");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>EAMProcessSubPhaseCode</b>
     * </p>
     *
     * @return Process Subphase
     */
    @SerializedName( "EAMProcessSubPhaseCode" )
    @JsonProperty( "EAMProcessSubPhaseCode" )
    @Nullable
    @ODataField( odataName = "EAMProcessSubPhaseCode" )
    private String eAMProcessSubPhaseCode;
    /**
     * Use with available fluent helpers to apply the <b>EAMProcessSubPhaseCode</b> field to query operations.
     *
     */
    public final static MaintnanceOrderPhaseControlField<String> EAM_PROCESS_SUB_PHASE_CODE =
        new MaintnanceOrderPhaseControlField<String>("EAMProcessSubPhaseCode");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaintObjPhseCtrlStatusIsActive</b>
     * </p>
     *
     * @return The maintObjPhseCtrlStatusIsActive contained in this entity.
     */
    @SerializedName( "MaintObjPhseCtrlStatusIsActive" )
    @JsonProperty( "MaintObjPhseCtrlStatusIsActive" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "MaintObjPhseCtrlStatusIsActive" )
    private Boolean maintObjPhseCtrlStatusIsActive;
    /**
     * Use with available fluent helpers to apply the <b>MaintObjPhseCtrlStatusIsActive</b> field to query operations.
     *
     */
    public final static MaintnanceOrderPhaseControlField<Boolean> MAINT_OBJ_PHSE_CTRL_STATUS_IS_ACTIVE =
        new MaintnanceOrderPhaseControlField<Boolean>("MaintObjPhseCtrlStatusIsActive");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintObjPhaseCtrlCodeSetBy</b>
     * </p>
     *
     * @return Business Object Blocker Code Set By User ID
     */
    @SerializedName( "MaintObjPhaseCtrlCodeSetBy" )
    @JsonProperty( "MaintObjPhaseCtrlCodeSetBy" )
    @Nullable
    @ODataField( odataName = "MaintObjPhaseCtrlCodeSetBy" )
    private String maintObjPhaseCtrlCodeSetBy;
    /**
     * Use with available fluent helpers to apply the <b>MaintObjPhaseCtrlCodeSetBy</b> field to query operations.
     *
     */
    public final static MaintnanceOrderPhaseControlField<String> MAINT_OBJ_PHASE_CTRL_CODE_SET_BY =
        new MaintnanceOrderPhaseControlField<String>("MaintObjPhaseCtrlCodeSetBy");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintObjPhseCtrlCodeSetDteTime</b>
     * </p>
     *
     * @return Business Object Phase Control Code Activated On
     */
    @SerializedName( "MaintObjPhseCtrlCodeSetDteTime" )
    @JsonProperty( "MaintObjPhseCtrlCodeSetDteTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "MaintObjPhseCtrlCodeSetDteTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime maintObjPhseCtrlCodeSetDteTime;
    /**
     * Use with available fluent helpers to apply the <b>MaintObjPhseCtrlCodeSetDteTime</b> field to query operations.
     *
     */
    public final static MaintnanceOrderPhaseControlField<ZonedDateTime> MAINT_OBJ_PHSE_CTRL_CODE_SET_DTE_TIME =
        new MaintnanceOrderPhaseControlField<ZonedDateTime>("MaintObjPhseCtrlCodeSetDteTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintObjPhaseCtrlCodeResetBy</b>
     * </p>
     *
     * @return Business Object Blocker Code Resolved By User ID
     */
    @SerializedName( "MaintObjPhaseCtrlCodeResetBy" )
    @JsonProperty( "MaintObjPhaseCtrlCodeResetBy" )
    @Nullable
    @ODataField( odataName = "MaintObjPhaseCtrlCodeResetBy" )
    private String maintObjPhaseCtrlCodeResetBy;
    /**
     * Use with available fluent helpers to apply the <b>MaintObjPhaseCtrlCodeResetBy</b> field to query operations.
     *
     */
    public final static MaintnanceOrderPhaseControlField<String> MAINT_OBJ_PHASE_CTRL_CODE_RESET_BY =
        new MaintnanceOrderPhaseControlField<String>("MaintObjPhaseCtrlCodeResetBy");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintObjPhseCtrlCodeRsetDteTme</b>
     * </p>
     *
     * @return Business Object Phase Control Code Deactivated On
     */
    @SerializedName( "MaintObjPhseCtrlCodeRsetDteTme" )
    @JsonProperty( "MaintObjPhseCtrlCodeRsetDteTme" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "MaintObjPhseCtrlCodeRsetDteTme",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime maintObjPhseCtrlCodeRsetDteTme;
    /**
     * Use with available fluent helpers to apply the <b>MaintObjPhseCtrlCodeRsetDteTme</b> field to query operations.
     *
     */
    public final static MaintnanceOrderPhaseControlField<ZonedDateTime> MAINT_OBJ_PHSE_CTRL_CODE_RSET_DTE_TME =
        new MaintnanceOrderPhaseControlField<ZonedDateTime>("MaintObjPhseCtrlCodeRsetDteTme");
    /**
     * Navigation property <b>to_MaintenanceOrder</b> for <b>MaintnanceOrderPhaseControl</b> to single
     * <b>MaintenanceOrder</b>.
     *
     */
    @SerializedName( "to_MaintenanceOrder" )
    @JsonProperty( "to_MaintenanceOrder" )
    @ODataField( odataName = "to_MaintenanceOrder" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private MaintenanceOrder toMaintenanceOrder;
    /**
     * Use with available fluent helpers to apply the <b>to_MaintenanceOrder</b> navigation property to query
     * operations.
     *
     */
    public final static MaintnanceOrderPhaseControlOneToOneLink<MaintenanceOrder> TO_MAINTENANCE_ORDER =
        new MaintnanceOrderPhaseControlOneToOneLink<MaintenanceOrder>("to_MaintenanceOrder");

    @Nonnull
    @Override
    public Class<MaintnanceOrderPhaseControl> getType()
    {
        return MaintnanceOrderPhaseControl.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrder</b>
     * </p>
     *
     * @param maintenanceOrder
     *            Order Number
     */
    public void setMaintenanceOrder( @Nullable final String maintenanceOrder )
    {
        rememberChangedField("MaintenanceOrder", this.maintenanceOrder);
        this.maintenanceOrder = maintenanceOrder;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePhaseControl</b>
     * </p>
     *
     * @param maintenancePhaseControl
     *            Phase Control Code
     */
    public void setMaintenancePhaseControl( @Nullable final String maintenancePhaseControl )
    {
        rememberChangedField("MaintenancePhaseControl", this.maintenancePhaseControl);
        this.maintenancePhaseControl = maintenancePhaseControl;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePhaseControlName</b>
     * </p>
     *
     * @param maintenancePhaseControlName
     *            Phase Control Code
     */
    public void setMaintenancePhaseControlName( @Nullable final String maintenancePhaseControlName )
    {
        rememberChangedField("MaintenancePhaseControlName", this.maintenancePhaseControlName);
        this.maintenancePhaseControlName = maintenancePhaseControlName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePhaseControlText</b>
     * </p>
     *
     * @param maintenancePhaseControlText
     *            Description of the Phase Control Code
     */
    public void setMaintenancePhaseControlText( @Nullable final String maintenancePhaseControlText )
    {
        rememberChangedField("MaintenancePhaseControlText", this.maintenancePhaseControlText);
        this.maintenancePhaseControlText = maintenancePhaseControlText;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaintPhseCtrlIsSetAutomly</b>
     * </p>
     *
     * @param maintPhseCtrlIsSetAutomly
     *            Phase Control Code: Set Automatically
     */
    public void setMaintPhseCtrlIsSetAutomly( @Nullable final Boolean maintPhseCtrlIsSetAutomly )
    {
        rememberChangedField("MaintPhseCtrlIsSetAutomly", this.maintPhseCtrlIsSetAutomly);
        this.maintPhseCtrlIsSetAutomly = maintPhseCtrlIsSetAutomly;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MaintPhaseControlAuthorityCode</b>
     * </p>
     *
     * @param maintPhaseControlAuthorityCode
     *            Authorization Key for Phase Control Code
     */
    public void setMaintPhaseControlAuthorityCode( @Nullable final String maintPhaseControlAuthorityCode )
    {
        rememberChangedField("MaintPhaseControlAuthorityCode", this.maintPhaseControlAuthorityCode);
        this.maintPhaseControlAuthorityCode = maintPhaseControlAuthorityCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaintProcgPhseCtrlActvtnCode</b>
     * </p>
     *
     * @param maintProcgPhseCtrlActvtnCode
     *            Phase Control Key
     */
    public void setMaintProcgPhseCtrlActvtnCode( @Nullable final String maintProcgPhseCtrlActvtnCode )
    {
        rememberChangedField("MaintProcgPhseCtrlActvtnCode", this.maintProcgPhseCtrlActvtnCode);
        this.maintProcgPhseCtrlActvtnCode = maintProcgPhseCtrlActvtnCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>MaintProcgPhseCtrlActvtnDesc</b>
     * </p>
     *
     * @param maintProcgPhseCtrlActvtnDesc
     *            Short Text for Fixed Values
     */
    public void setMaintProcgPhseCtrlActvtnDesc( @Nullable final String maintProcgPhseCtrlActvtnDesc )
    {
        rememberChangedField("MaintProcgPhseCtrlActvtnDesc", this.maintProcgPhseCtrlActvtnDesc);
        this.maintProcgPhseCtrlActvtnDesc = maintProcgPhseCtrlActvtnDesc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>EAMProcessPhaseCode</b>
     * </p>
     *
     * @param eAMProcessPhaseCode
     *            Process Phase
     */
    public void setEAMProcessPhaseCode( @Nullable final String eAMProcessPhaseCode )
    {
        rememberChangedField("EAMProcessPhaseCode", this.eAMProcessPhaseCode);
        this.eAMProcessPhaseCode = eAMProcessPhaseCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>EAMProcessSubPhaseCode</b>
     * </p>
     *
     * @param eAMProcessSubPhaseCode
     *            Process Subphase
     */
    public void setEAMProcessSubPhaseCode( @Nullable final String eAMProcessSubPhaseCode )
    {
        rememberChangedField("EAMProcessSubPhaseCode", this.eAMProcessSubPhaseCode);
        this.eAMProcessSubPhaseCode = eAMProcessSubPhaseCode;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaintObjPhseCtrlStatusIsActive</b>
     * </p>
     *
     * @param maintObjPhseCtrlStatusIsActive
     *            The maintObjPhseCtrlStatusIsActive to set.
     */
    public void setMaintObjPhseCtrlStatusIsActive( @Nullable final Boolean maintObjPhseCtrlStatusIsActive )
    {
        rememberChangedField("MaintObjPhseCtrlStatusIsActive", this.maintObjPhseCtrlStatusIsActive);
        this.maintObjPhseCtrlStatusIsActive = maintObjPhseCtrlStatusIsActive;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintObjPhaseCtrlCodeSetBy</b>
     * </p>
     *
     * @param maintObjPhaseCtrlCodeSetBy
     *            Business Object Blocker Code Set By User ID
     */
    public void setMaintObjPhaseCtrlCodeSetBy( @Nullable final String maintObjPhaseCtrlCodeSetBy )
    {
        rememberChangedField("MaintObjPhaseCtrlCodeSetBy", this.maintObjPhaseCtrlCodeSetBy);
        this.maintObjPhaseCtrlCodeSetBy = maintObjPhaseCtrlCodeSetBy;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintObjPhseCtrlCodeSetDteTime</b>
     * </p>
     *
     * @param maintObjPhseCtrlCodeSetDteTime
     *            Business Object Phase Control Code Activated On
     */
    public void setMaintObjPhseCtrlCodeSetDteTime( @Nullable final ZonedDateTime maintObjPhseCtrlCodeSetDteTime )
    {
        rememberChangedField("MaintObjPhseCtrlCodeSetDteTime", this.maintObjPhseCtrlCodeSetDteTime);
        this.maintObjPhseCtrlCodeSetDteTime = maintObjPhseCtrlCodeSetDteTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintObjPhaseCtrlCodeResetBy</b>
     * </p>
     *
     * @param maintObjPhaseCtrlCodeResetBy
     *            Business Object Blocker Code Resolved By User ID
     */
    public void setMaintObjPhaseCtrlCodeResetBy( @Nullable final String maintObjPhaseCtrlCodeResetBy )
    {
        rememberChangedField("MaintObjPhaseCtrlCodeResetBy", this.maintObjPhaseCtrlCodeResetBy);
        this.maintObjPhaseCtrlCodeResetBy = maintObjPhaseCtrlCodeResetBy;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintObjPhseCtrlCodeRsetDteTme</b>
     * </p>
     *
     * @param maintObjPhseCtrlCodeRsetDteTme
     *            Business Object Phase Control Code Deactivated On
     */
    public void setMaintObjPhseCtrlCodeRsetDteTme( @Nullable final ZonedDateTime maintObjPhseCtrlCodeRsetDteTme )
    {
        rememberChangedField("MaintObjPhseCtrlCodeRsetDteTme", this.maintObjPhseCtrlCodeRsetDteTme);
        this.maintObjPhseCtrlCodeRsetDteTme = maintObjPhseCtrlCodeRsetDteTme;
    }

    @Override
    protected String getEntityCollection()
    {
        return "MaintenanceOrderPhaseControl";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("MaintenanceOrder", getMaintenanceOrder());
        result.put("MaintenancePhaseControl", getMaintenancePhaseControl());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("MaintenanceOrder", getMaintenanceOrder());
        values.put("MaintenancePhaseControl", getMaintenancePhaseControl());
        values.put("MaintenancePhaseControlName", getMaintenancePhaseControlName());
        values.put("MaintenancePhaseControlText", getMaintenancePhaseControlText());
        values.put("MaintPhseCtrlIsSetAutomly", getMaintPhseCtrlIsSetAutomly());
        values.put("MaintPhaseControlAuthorityCode", getMaintPhaseControlAuthorityCode());
        values.put("MaintProcgPhseCtrlActvtnCode", getMaintProcgPhseCtrlActvtnCode());
        values.put("MaintProcgPhseCtrlActvtnDesc", getMaintProcgPhseCtrlActvtnDesc());
        values.put("EAMProcessPhaseCode", getEAMProcessPhaseCode());
        values.put("EAMProcessSubPhaseCode", getEAMProcessSubPhaseCode());
        values.put("MaintObjPhseCtrlStatusIsActive", getMaintObjPhseCtrlStatusIsActive());
        values.put("MaintObjPhaseCtrlCodeSetBy", getMaintObjPhaseCtrlCodeSetBy());
        values.put("MaintObjPhseCtrlCodeSetDteTime", getMaintObjPhseCtrlCodeSetDteTime());
        values.put("MaintObjPhaseCtrlCodeResetBy", getMaintObjPhaseCtrlCodeResetBy());
        values.put("MaintObjPhseCtrlCodeRsetDteTme", getMaintObjPhseCtrlCodeRsetDteTme());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("MaintenanceOrder") ) {
                final Object value = values.remove("MaintenanceOrder");
                if( (value == null) || (!value.equals(getMaintenanceOrder())) ) {
                    setMaintenanceOrder(((String) value));
                }
            }
            if( values.containsKey("MaintenancePhaseControl") ) {
                final Object value = values.remove("MaintenancePhaseControl");
                if( (value == null) || (!value.equals(getMaintenancePhaseControl())) ) {
                    setMaintenancePhaseControl(((String) value));
                }
            }
            if( values.containsKey("MaintenancePhaseControlName") ) {
                final Object value = values.remove("MaintenancePhaseControlName");
                if( (value == null) || (!value.equals(getMaintenancePhaseControlName())) ) {
                    setMaintenancePhaseControlName(((String) value));
                }
            }
            if( values.containsKey("MaintenancePhaseControlText") ) {
                final Object value = values.remove("MaintenancePhaseControlText");
                if( (value == null) || (!value.equals(getMaintenancePhaseControlText())) ) {
                    setMaintenancePhaseControlText(((String) value));
                }
            }
            if( values.containsKey("MaintPhseCtrlIsSetAutomly") ) {
                final Object value = values.remove("MaintPhseCtrlIsSetAutomly");
                if( (value == null) || (!value.equals(getMaintPhseCtrlIsSetAutomly())) ) {
                    setMaintPhseCtrlIsSetAutomly(((Boolean) value));
                }
            }
            if( values.containsKey("MaintPhaseControlAuthorityCode") ) {
                final Object value = values.remove("MaintPhaseControlAuthorityCode");
                if( (value == null) || (!value.equals(getMaintPhaseControlAuthorityCode())) ) {
                    setMaintPhaseControlAuthorityCode(((String) value));
                }
            }
            if( values.containsKey("MaintProcgPhseCtrlActvtnCode") ) {
                final Object value = values.remove("MaintProcgPhseCtrlActvtnCode");
                if( (value == null) || (!value.equals(getMaintProcgPhseCtrlActvtnCode())) ) {
                    setMaintProcgPhseCtrlActvtnCode(((String) value));
                }
            }
            if( values.containsKey("MaintProcgPhseCtrlActvtnDesc") ) {
                final Object value = values.remove("MaintProcgPhseCtrlActvtnDesc");
                if( (value == null) || (!value.equals(getMaintProcgPhseCtrlActvtnDesc())) ) {
                    setMaintProcgPhseCtrlActvtnDesc(((String) value));
                }
            }
            if( values.containsKey("EAMProcessPhaseCode") ) {
                final Object value = values.remove("EAMProcessPhaseCode");
                if( (value == null) || (!value.equals(getEAMProcessPhaseCode())) ) {
                    setEAMProcessPhaseCode(((String) value));
                }
            }
            if( values.containsKey("EAMProcessSubPhaseCode") ) {
                final Object value = values.remove("EAMProcessSubPhaseCode");
                if( (value == null) || (!value.equals(getEAMProcessSubPhaseCode())) ) {
                    setEAMProcessSubPhaseCode(((String) value));
                }
            }
            if( values.containsKey("MaintObjPhseCtrlStatusIsActive") ) {
                final Object value = values.remove("MaintObjPhseCtrlStatusIsActive");
                if( (value == null) || (!value.equals(getMaintObjPhseCtrlStatusIsActive())) ) {
                    setMaintObjPhseCtrlStatusIsActive(((Boolean) value));
                }
            }
            if( values.containsKey("MaintObjPhaseCtrlCodeSetBy") ) {
                final Object value = values.remove("MaintObjPhaseCtrlCodeSetBy");
                if( (value == null) || (!value.equals(getMaintObjPhaseCtrlCodeSetBy())) ) {
                    setMaintObjPhaseCtrlCodeSetBy(((String) value));
                }
            }
            if( values.containsKey("MaintObjPhseCtrlCodeSetDteTime") ) {
                final Object value = values.remove("MaintObjPhseCtrlCodeSetDteTime");
                if( (value == null) || (!value.equals(getMaintObjPhseCtrlCodeSetDteTime())) ) {
                    setMaintObjPhseCtrlCodeSetDteTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("MaintObjPhaseCtrlCodeResetBy") ) {
                final Object value = values.remove("MaintObjPhaseCtrlCodeResetBy");
                if( (value == null) || (!value.equals(getMaintObjPhaseCtrlCodeResetBy())) ) {
                    setMaintObjPhaseCtrlCodeResetBy(((String) value));
                }
            }
            if( values.containsKey("MaintObjPhseCtrlCodeRsetDteTme") ) {
                final Object value = values.remove("MaintObjPhseCtrlCodeRsetDteTme");
                if( (value == null) || (!value.equals(getMaintObjPhseCtrlCodeRsetDteTme())) ) {
                    setMaintObjPhseCtrlCodeRsetDteTme(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_MaintenanceOrder") ) {
                final Object value = (values).remove("to_MaintenanceOrder");
                if( value instanceof Map ) {
                    if( toMaintenanceOrder == null ) {
                        toMaintenanceOrder = new MaintenanceOrder();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toMaintenanceOrder.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> MaintnanceOrderPhaseControlField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new MaintnanceOrderPhaseControlField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MaintnanceOrderPhaseControlField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MaintnanceOrderPhaseControlField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceOrderService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toMaintenanceOrder != null ) {
            (values).put("to_MaintenanceOrder", toMaintenanceOrder);
        }
        return values;
    }

    /**
     * Fetches the <b>MaintenanceOrder</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_MaintenanceOrder</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>MaintenanceOrder</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceOrder fetchMaintenanceOrder()
    {
        return fetchFieldAsSingle("to_MaintenanceOrder", MaintenanceOrder.class);
    }

    /**
     * Retrieval of associated <b>MaintenanceOrder</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_MaintenanceOrder</b>.
     * <p>
     * If the navigation property <b>to_MaintenanceOrder</b> of a queried <b>MaintnanceOrderPhaseControl</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintenanceOrder</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceOrder getMaintenanceOrderOrFetch()
    {
        if( toMaintenanceOrder == null ) {
            toMaintenanceOrder = fetchMaintenanceOrder();
        }
        return toMaintenanceOrder;
    }

    /**
     * Retrieval of associated <b>MaintenanceOrder</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_MaintenanceOrder</b>.
     * <p>
     * If the navigation property for an entity <b>MaintnanceOrderPhaseControl</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaintenanceOrder</b> is already loaded, the result will
     *         contain the <b>MaintenanceOrder</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<MaintenanceOrder> getMaintenanceOrderIfPresent()
    {
        return Option.of(toMaintenanceOrder);
    }

    /**
     * Overwrites the associated <b>MaintenanceOrder</b> entity for the loaded navigation property
     * <b>to_MaintenanceOrder</b>.
     *
     * @param value
     *            New <b>MaintenanceOrder</b> entity.
     */
    public void setMaintenanceOrder( final MaintenanceOrder value )
    {
        toMaintenanceOrder = value;
    }

    /**
     * Helper class to allow for fluent creation of MaintnanceOrderPhaseControl instances.
     *
     */
    public final static class MaintnanceOrderPhaseControlBuilder
    {

        private MaintenanceOrder toMaintenanceOrder;
        private String maintenanceOrder = null;

        private MaintnanceOrderPhaseControl.MaintnanceOrderPhaseControlBuilder toMaintenanceOrder(
            final MaintenanceOrder value )
        {
            toMaintenanceOrder = value;
            return this;
        }

        /**
         * Navigation property <b>to_MaintenanceOrder</b> for <b>MaintnanceOrderPhaseControl</b> to single
         * <b>MaintenanceOrder</b>.
         *
         * @param value
         *            The MaintenanceOrder to build this MaintnanceOrderPhaseControl with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintnanceOrderPhaseControl.MaintnanceOrderPhaseControlBuilder maintenanceOrder(
            final MaintenanceOrder value )
        {
            return toMaintenanceOrder(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 12
         * <p>
         * Original property name from the Odata EDM: <b>MaintenanceOrder</b>
         * </p>
         *
         * @param value
         *            The maintenanceOrder to build this MaintnanceOrderPhaseControl with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintnanceOrderPhaseControl.MaintnanceOrderPhaseControlBuilder maintenanceOrder( final String value )
        {
            maintenanceOrder = value;
            return this;
        }

    }

}
