/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.selectable.MaintnanceOrderPhaseControlSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintnanceOrderPhaseControl
 * MaintnanceOrderPhaseControl} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class MaintnanceOrderPhaseControlByKeyFluentHelper
    extends
    FluentHelperByKey<MaintnanceOrderPhaseControlByKeyFluentHelper, MaintnanceOrderPhaseControl, MaintnanceOrderPhaseControlSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintnanceOrderPhaseControl
     * MaintnanceOrderPhaseControl} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param maintenanceOrder
     *            Order Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code MaintnanceOrderPhaseControl}
     * @param servicePath
     *            Service path to be used to fetch a single {@code MaintnanceOrderPhaseControl}
     * @param maintenancePhaseControl
     *            Phase Control Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     */
    public MaintnanceOrderPhaseControlByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String maintenanceOrder,
        final String maintenancePhaseControl )
    {
        super(servicePath, entityCollection);
        this.key.put("MaintenanceOrder", maintenanceOrder);
        this.key.put("MaintenancePhaseControl", maintenancePhaseControl);
    }

    @Override
    @Nonnull
    protected Class<MaintnanceOrderPhaseControl> getEntityClass()
    {
        return MaintnanceOrderPhaseControl.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
