/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder;

import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.SingleValuedFluentHelperFunction;

/**
 * Fluent helper for the <b>SetMaintOrdToTechCompleted</b> OData function import.
 *
 */
public class SetMaintOrdToTechCompletedFluentHelper
    extends
    SingleValuedFluentHelperFunction<SetMaintOrdToTechCompletedFluentHelper, DummyFunctionImportResult, DummyFunctionImportResult>
{

    private final Map<String, Object> values = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will execute the <b>SetMaintOrdToTechCompleted</b> OData function import with
     * the provided parameters. To perform execution, call the {@link #executeRequest executeRequest} method on the
     * fluent helper object.
     *
     * @param maintenanceOrder
     *            Order
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenanceOrder</b>
     *            </p>
     * @param assignedMaintNotifIsToBeClosed
     *            Complete Assigned Notifications
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>AssignedMaintNotifIsToBeClosed</b>
     *            </p>
     * @param servicePath
     *            Service path to be used to call the functions against.
     * @param maintOrderReferenceDateTime
     *            Completion Date/Time
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintOrderReferenceDateTime</b>
     *            </p>
     */
    public SetMaintOrdToTechCompletedFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String maintenanceOrder,
        @Nullable final ZonedDateTime maintOrderReferenceDateTime,
        @Nullable final Boolean assignedMaintNotifIsToBeClosed )
    {
        super(servicePath);
        values.put("MaintenanceOrder", maintenanceOrder);
        if( maintOrderReferenceDateTime != null ) {
            values.put("MaintOrderReferenceDateTime", maintOrderReferenceDateTime);
        }
        if( assignedMaintNotifIsToBeClosed != null ) {
            values.put("AssignedMaintNotifIsToBeClosed", assignedMaintNotifIsToBeClosed);
        }
    }

    /**
     * Creates a fluent helper object that will execute the <b>SetMaintOrdToTechCompleted</b> OData function import with
     * the provided parameters. To perform execution, call the {@link #executeRequest executeRequest} method on the
     * fluent helper object.
     *
     * @param maintenanceOrder
     *            Order
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenanceOrder</b>
     *            </p>
     * @param assignedMaintNotifIsToBeClosed
     *            Complete Assigned Notifications
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>AssignedMaintNotifIsToBeClosed</b>
     *            </p>
     * @param servicePath
     *            Service path to be used to call the functions against.
     * @param mainWrkCmpltdDateTimeIsUsed
     *            Use Main Work Completed Date and Time
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MainWrkCmpltdDateTimeIsUsed</b>
     *            </p>
     * @param maintOrderReferenceDateTime
     *            Completion Date/Time
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintOrderReferenceDateTime</b>
     *            </p>
     */
    public SetMaintOrdToTechCompletedFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String maintenanceOrder,
        @Nullable final ZonedDateTime maintOrderReferenceDateTime,
        @Nullable final Boolean assignedMaintNotifIsToBeClosed,
        @Nullable final Boolean mainWrkCmpltdDateTimeIsUsed )
    {
        super(servicePath);
        values.put("MaintenanceOrder", maintenanceOrder);
        if( maintOrderReferenceDateTime != null ) {
            values.put("MaintOrderReferenceDateTime", maintOrderReferenceDateTime);
        }
        if( assignedMaintNotifIsToBeClosed != null ) {
            values.put("AssignedMaintNotifIsToBeClosed", assignedMaintNotifIsToBeClosed);
        }
        if( mainWrkCmpltdDateTimeIsUsed != null ) {
            values.put("MainWrkCmpltdDateTimeIsUsed", mainWrkCmpltdDateTimeIsUsed);
        }
    }

    @Override
    @Nonnull
    protected Class<DummyFunctionImportResult> getEntityClass()
    {
        return DummyFunctionImportResult.class;
    }

    @Override
    @Nonnull
    protected String getFunctionName()
    {
        return "SetMaintOrdToTechCompleted";
    }

    @Override
    @Nullable
    protected JsonElement refineJsonResponse( @Nullable JsonElement jsonElement )
    {
        if( (jsonElement instanceof JsonObject) && ((JsonObject) jsonElement).has(getFunctionName()) ) {
            jsonElement = ((JsonObject) jsonElement).get(getFunctionName());
        }
        return super.refineJsonResponse(jsonElement);
    }

    @Override
    @Nonnull
    protected Map<String, Object> getParameters()
    {
        return values;
    }

    @Override
    @Nonnull
    protected HttpUriRequest createRequest( @Nonnull final URI uri )
    {
        return new HttpPost(uri);
    }

    /**
     * Execute this function import.
     *
     */
    @Override
    @Nullable
    public DummyFunctionImportResult executeRequest( @Nonnull final HttpDestinationProperties destination )
    {
        return super.executeSingle(destination);
    }

}
