/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder;

import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.SingleValuedFluentHelperFunction;

/**
 * Fluent helper for the <b>SetMaintOrderToDoNotExecute</b> OData function import.
 *
 */
public class SetMaintOrderToDoNotExecuteFluentHelper
    extends
    SingleValuedFluentHelperFunction<SetMaintOrderToDoNotExecuteFluentHelper, DummyFunctionImportResult, DummyFunctionImportResult>
{

    private final Map<String, Object> values = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will execute the <b>SetMaintOrderToDoNotExecute</b> OData function import
     * with the provided parameters. To perform execution, call the {@link #executeRequest executeRequest} method on the
     * fluent helper object.
     *
     * @param maintenanceOrder
     *            Order
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenanceOrder</b>
     *            </p>
     * @param assignedMaintNotifIsToBeClosed
     *            Complete All Assigned Notifications
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>AssignedMaintNotifIsToBeClosed</b>
     *            </p>
     * @param servicePath
     *            Service path to be used to call the functions against.
     * @param assgdMaintNotifIsToBeRsetAlloc
     *            Complete Header Notification and Unassign Others
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>AssgdMaintNotifIsToBeRsetAlloc</b>
     *            </p>
     * @param maintOrderReferenceDateTime
     *            Reference Date/Time
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintOrderReferenceDateTime</b>
     *            </p>
     */
    public SetMaintOrderToDoNotExecuteFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String maintenanceOrder,
        @Nullable final ZonedDateTime maintOrderReferenceDateTime,
        @Nullable final Boolean assignedMaintNotifIsToBeClosed,
        @Nullable final Boolean assgdMaintNotifIsToBeRsetAlloc )
    {
        super(servicePath);
        values.put("MaintenanceOrder", maintenanceOrder);
        if( maintOrderReferenceDateTime != null ) {
            values.put("MaintOrderReferenceDateTime", maintOrderReferenceDateTime);
        }
        if( assignedMaintNotifIsToBeClosed != null ) {
            values.put("AssignedMaintNotifIsToBeClosed", assignedMaintNotifIsToBeClosed);
        }
        if( assgdMaintNotifIsToBeRsetAlloc != null ) {
            values.put("AssgdMaintNotifIsToBeRsetAlloc", assgdMaintNotifIsToBeRsetAlloc);
        }
    }

    /**
     * Creates a fluent helper object that will execute the <b>SetMaintOrderToDoNotExecute</b> OData function import
     * with the provided parameters. To perform execution, call the {@link #executeRequest executeRequest} method on the
     * fluent helper object.
     *
     * @param maintenanceOrder
     *            Order
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenanceOrder</b>
     *            </p>
     * @param assignedMaintNotifIsToBeClosed
     *            Complete All Assigned Notifications
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>AssignedMaintNotifIsToBeClosed</b>
     *            </p>
     * @param servicePath
     *            Service path to be used to call the functions against.
     * @param maintOrdCancellationAction
     *            What should happen to assigned notifications
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintOrdCancellationAction</b>
     *            </p>
     * @param assgdMaintNotifIsToBeRsetAlloc
     *            Complete Header Notification and Unassign Others
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>AssgdMaintNotifIsToBeRsetAlloc</b>
     *            </p>
     * @param maintOrderReferenceDateTime
     *            Reference Date/Time
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintOrderReferenceDateTime</b>
     *            </p>
     */
    public SetMaintOrderToDoNotExecuteFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String maintenanceOrder,
        @Nullable final ZonedDateTime maintOrderReferenceDateTime,
        @Nullable final Boolean assignedMaintNotifIsToBeClosed,
        @Nullable final Boolean assgdMaintNotifIsToBeRsetAlloc,
        @Nullable final String maintOrdCancellationAction )
    {
        super(servicePath);
        values.put("MaintenanceOrder", maintenanceOrder);
        if( maintOrderReferenceDateTime != null ) {
            values.put("MaintOrderReferenceDateTime", maintOrderReferenceDateTime);
        }
        if( assignedMaintNotifIsToBeClosed != null ) {
            values.put("AssignedMaintNotifIsToBeClosed", assignedMaintNotifIsToBeClosed);
        }
        if( assgdMaintNotifIsToBeRsetAlloc != null ) {
            values.put("AssgdMaintNotifIsToBeRsetAlloc", assgdMaintNotifIsToBeRsetAlloc);
        }
        if( maintOrdCancellationAction != null ) {
            values.put("MaintOrdCancellationAction", maintOrdCancellationAction);
        }
    }

    @Override
    @Nonnull
    protected Class<DummyFunctionImportResult> getEntityClass()
    {
        return DummyFunctionImportResult.class;
    }

    @Override
    @Nonnull
    protected String getFunctionName()
    {
        return "SetMaintOrderToDoNotExecute";
    }

    @Override
    @Nullable
    protected JsonElement refineJsonResponse( @Nullable JsonElement jsonElement )
    {
        if( (jsonElement instanceof JsonObject) && ((JsonObject) jsonElement).has(getFunctionName()) ) {
            jsonElement = ((JsonObject) jsonElement).get(getFunctionName());
        }
        return super.refineJsonResponse(jsonElement);
    }

    @Override
    @Nonnull
    protected Map<String, Object> getParameters()
    {
        return values;
    }

    @Override
    @Nonnull
    protected HttpUriRequest createRequest( @Nonnull final URI uri )
    {
        return new HttpPost(uri);
    }

    /**
     * Execute this function import.
     *
     */
    @Override
    @Nullable
    public DummyFunctionImportResult executeRequest( @Nonnull final HttpDestinationProperties destination )
    {
        return super.executeSingle(destination);
    }

}
