/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link MaintenanceOrderServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceOrderService MaintenanceOrderService}, allowing
 * you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultMaintenanceOrderServiceBatch
    extends
    BatchFluentHelperBasic<MaintenanceOrderServiceBatch, MaintenanceOrderServiceBatchChangeSet>
    implements
    MaintenanceOrderServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceOrderService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultMaintenanceOrderServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultMaintenanceOrderServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceOrderService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceOrderService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultMaintenanceOrderServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultMaintenanceOrderServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceOrderService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultMaintenanceOrderServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public MaintenanceOrderServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultMaintenanceOrderServiceBatchChangeSet(this, service);
    }

}
