/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderObjectListItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpCompLongText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpComponent;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpLongText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpProdnRsceTool;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationship;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderSettlmtDistrRule;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrder;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderLongText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderPartner;

/**
 * Implementation of the {@link MaintenanceOrderServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceOrderService MaintenanceOrderService}.
 *
 */
public class DefaultMaintenanceOrderServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<MaintenanceOrderServiceBatch, MaintenanceOrderServiceBatchChangeSet>
    implements
    MaintenanceOrderServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceOrderService service;

    @SuppressWarnings( "deprecation" )
    DefaultMaintenanceOrderServiceBatchChangeSet(
        @Nonnull final DefaultMaintenanceOrderServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceOrderService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultMaintenanceOrderServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public MaintenanceOrderServiceBatchChangeSet createMaintenanceOrder(
        @Nonnull final MaintenanceOrder maintenanceOrder )
    {
        return addRequestCreate(service::createMaintenanceOrder, maintenanceOrder);
    }

    @Nonnull
    @Override
    public MaintenanceOrderServiceBatchChangeSet updateMaintenanceOrder(
        @Nonnull final MaintenanceOrder maintenanceOrder )
    {
        return addRequestUpdate(service::updateMaintenanceOrder, maintenanceOrder);
    }

    @Nonnull
    @Override
    public MaintenanceOrderServiceBatchChangeSet updateMaintenanceOrderLongText(
        @Nonnull final MaintenanceOrderLongText maintenanceOrderLongText )
    {
        return addRequestUpdate(service::updateMaintenanceOrderLongText, maintenanceOrderLongText);
    }

    @Nonnull
    @Override
    public MaintenanceOrderServiceBatchChangeSet deleteMaintenanceOrderLongText(
        @Nonnull final MaintenanceOrderLongText maintenanceOrderLongText )
    {
        return addRequestDelete(service::deleteMaintenanceOrderLongText, maintenanceOrderLongText);
    }

    @Nonnull
    @Override
    public MaintenanceOrderServiceBatchChangeSet createMaintenanceOrderOperation(
        @Nonnull final MaintenanceOrderOperation maintenanceOrderOperation )
    {
        return addRequestCreate(service::createMaintenanceOrderOperation, maintenanceOrderOperation);
    }

    @Nonnull
    @Override
    public MaintenanceOrderServiceBatchChangeSet updateMaintenanceOrderOperation(
        @Nonnull final MaintenanceOrderOperation maintenanceOrderOperation )
    {
        return addRequestUpdate(service::updateMaintenanceOrderOperation, maintenanceOrderOperation);
    }

    @Nonnull
    @Override
    public MaintenanceOrderServiceBatchChangeSet deleteMaintenanceOrderOperation(
        @Nonnull final MaintenanceOrderOperation maintenanceOrderOperation )
    {
        return addRequestDelete(service::deleteMaintenanceOrderOperation, maintenanceOrderOperation);
    }

    @Nonnull
    @Override
    public MaintenanceOrderServiceBatchChangeSet deleteMaintenanceOrderPartner(
        @Nonnull final MaintenanceOrderPartner maintenanceOrderPartner )
    {
        return addRequestDelete(service::deleteMaintenanceOrderPartner, maintenanceOrderPartner);
    }

    @Nonnull
    @Override
    public MaintenanceOrderServiceBatchChangeSet updateMaintOrderObjectListItem(
        @Nonnull final MaintOrderObjectListItem maintOrderObjectListItem )
    {
        return addRequestUpdate(service::updateMaintOrderObjectListItem, maintOrderObjectListItem);
    }

    @Nonnull
    @Override
    public MaintenanceOrderServiceBatchChangeSet deleteMaintOrderObjectListItem(
        @Nonnull final MaintOrderObjectListItem maintOrderObjectListItem )
    {
        return addRequestDelete(service::deleteMaintOrderObjectListItem, maintOrderObjectListItem);
    }

    @Nonnull
    @Override
    public MaintenanceOrderServiceBatchChangeSet updateMaintOrderOpCompLongText(
        @Nonnull final MaintOrderOpCompLongText maintOrderOpCompLongText )
    {
        return addRequestUpdate(service::updateMaintOrderOpCompLongText, maintOrderOpCompLongText);
    }

    @Nonnull
    @Override
    public MaintenanceOrderServiceBatchChangeSet deleteMaintOrderOpCompLongText(
        @Nonnull final MaintOrderOpCompLongText maintOrderOpCompLongText )
    {
        return addRequestDelete(service::deleteMaintOrderOpCompLongText, maintOrderOpCompLongText);
    }

    @Nonnull
    @Override
    public MaintenanceOrderServiceBatchChangeSet createMaintOrderOpComponent(
        @Nonnull final MaintOrderOpComponent maintOrderOpComponent )
    {
        return addRequestCreate(service::createMaintOrderOpComponent, maintOrderOpComponent);
    }

    @Nonnull
    @Override
    public MaintenanceOrderServiceBatchChangeSet updateMaintOrderOpComponent(
        @Nonnull final MaintOrderOpComponent maintOrderOpComponent )
    {
        return addRequestUpdate(service::updateMaintOrderOpComponent, maintOrderOpComponent);
    }

    @Nonnull
    @Override
    public MaintenanceOrderServiceBatchChangeSet deleteMaintOrderOpComponent(
        @Nonnull final MaintOrderOpComponent maintOrderOpComponent )
    {
        return addRequestDelete(service::deleteMaintOrderOpComponent, maintOrderOpComponent);
    }

    @Nonnull
    @Override
    public MaintenanceOrderServiceBatchChangeSet updateMaintOrderOpLongText(
        @Nonnull final MaintOrderOpLongText maintOrderOpLongText )
    {
        return addRequestUpdate(service::updateMaintOrderOpLongText, maintOrderOpLongText);
    }

    @Nonnull
    @Override
    public MaintenanceOrderServiceBatchChangeSet deleteMaintOrderOpLongText(
        @Nonnull final MaintOrderOpLongText maintOrderOpLongText )
    {
        return addRequestDelete(service::deleteMaintOrderOpLongText, maintOrderOpLongText);
    }

    @Nonnull
    @Override
    public MaintenanceOrderServiceBatchChangeSet updateMaintOrderOpProdnRsceTool(
        @Nonnull final MaintOrderOpProdnRsceTool maintOrderOpProdnRsceTool )
    {
        return addRequestUpdate(service::updateMaintOrderOpProdnRsceTool, maintOrderOpProdnRsceTool);
    }

    @Nonnull
    @Override
    public MaintenanceOrderServiceBatchChangeSet deleteMaintOrderOpProdnRsceTool(
        @Nonnull final MaintOrderOpProdnRsceTool maintOrderOpProdnRsceTool )
    {
        return addRequestDelete(service::deleteMaintOrderOpProdnRsceTool, maintOrderOpProdnRsceTool);
    }

    @Nonnull
    @Override
    public MaintenanceOrderServiceBatchChangeSet updateMaintOrderOpRelationship(
        @Nonnull final MaintOrderOpRelationship maintOrderOpRelationship )
    {
        return addRequestUpdate(service::updateMaintOrderOpRelationship, maintOrderOpRelationship);
    }

    @Nonnull
    @Override
    public MaintenanceOrderServiceBatchChangeSet deleteMaintOrderOpRelationship(
        @Nonnull final MaintOrderOpRelationship maintOrderOpRelationship )
    {
        return addRequestDelete(service::deleteMaintOrderOpRelationship, maintOrderOpRelationship);
    }

    @Nonnull
    @Override
    public MaintenanceOrderServiceBatchChangeSet updateMaintOrderSettlmtDistrRule(
        @Nonnull final MaintOrderSettlmtDistrRule maintOrderSettlmtDistrRule )
    {
        return addRequestUpdate(service::updateMaintOrderSettlmtDistrRule, maintOrderSettlmtDistrRule);
    }

    @Nonnull
    @Override
    public MaintenanceOrderServiceBatchChangeSet deleteMaintOrderSettlmtDistrRule(
        @Nonnull final MaintOrderSettlmtDistrRule maintOrderSettlmtDistrRule )
    {
        return addRequestDelete(service::deleteMaintOrderSettlmtDistrRule, maintOrderSettlmtDistrRule);
    }

}
