/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderObjectListItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpCompLongText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpComponent;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpLongText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpProdnRsceTool;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationship;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderSettlmtDistrRule;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrder;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderLongText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderPartner;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceOrderService MaintenanceOrderService}.
 *
 */
public interface MaintenanceOrderServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<MaintenanceOrderServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<MaintenanceOrderServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrder
     * MaintenanceOrder} entity and save it to the S/4HANA system.
     *
     * @param maintenanceOrder
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrder
     *            MaintenanceOrder} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceOrderServiceBatchChangeSet createMaintenanceOrder( @Nonnull final MaintenanceOrder maintenanceOrder );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrder
     * MaintenanceOrder} entity and save it to the S/4HANA system.
     *
     * @param maintenanceOrder
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrder
     *            MaintenanceOrder} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceOrderServiceBatchChangeSet updateMaintenanceOrder( @Nonnull final MaintenanceOrder maintenanceOrder );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderLongText
     * MaintenanceOrderLongText} entity and save it to the S/4HANA system.
     *
     * @param maintenanceOrderLongText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderLongText
     *            MaintenanceOrderLongText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceOrderServiceBatchChangeSet
        updateMaintenanceOrderLongText( @Nonnull final MaintenanceOrderLongText maintenanceOrderLongText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderLongText
     * MaintenanceOrderLongText} entity in the S/4HANA system.
     *
     * @param maintenanceOrderLongText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderLongText
     *            MaintenanceOrderLongText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceOrderServiceBatchChangeSet
        deleteMaintenanceOrderLongText( @Nonnull final MaintenanceOrderLongText maintenanceOrderLongText );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation
     * MaintenanceOrderOperation} entity and save it to the S/4HANA system.
     *
     * @param maintenanceOrderOperation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation
     *            MaintenanceOrderOperation} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceOrderServiceBatchChangeSet
        createMaintenanceOrderOperation( @Nonnull final MaintenanceOrderOperation maintenanceOrderOperation );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation
     * MaintenanceOrderOperation} entity and save it to the S/4HANA system.
     *
     * @param maintenanceOrderOperation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation
     *            MaintenanceOrderOperation} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceOrderServiceBatchChangeSet
        updateMaintenanceOrderOperation( @Nonnull final MaintenanceOrderOperation maintenanceOrderOperation );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation
     * MaintenanceOrderOperation} entity in the S/4HANA system.
     *
     * @param maintenanceOrderOperation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation
     *            MaintenanceOrderOperation} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceOrderServiceBatchChangeSet
        deleteMaintenanceOrderOperation( @Nonnull final MaintenanceOrderOperation maintenanceOrderOperation );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderPartner
     * MaintenanceOrderPartner} entity in the S/4HANA system.
     *
     * @param maintenanceOrderPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderPartner
     *            MaintenanceOrderPartner} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceOrderServiceBatchChangeSet
        deleteMaintenanceOrderPartner( @Nonnull final MaintenanceOrderPartner maintenanceOrderPartner );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderObjectListItem
     * MaintOrderObjectListItem} entity and save it to the S/4HANA system.
     *
     * @param maintOrderObjectListItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderObjectListItem
     *            MaintOrderObjectListItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceOrderServiceBatchChangeSet
        updateMaintOrderObjectListItem( @Nonnull final MaintOrderObjectListItem maintOrderObjectListItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderObjectListItem
     * MaintOrderObjectListItem} entity in the S/4HANA system.
     *
     * @param maintOrderObjectListItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderObjectListItem
     *            MaintOrderObjectListItem} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceOrderServiceBatchChangeSet
        deleteMaintOrderObjectListItem( @Nonnull final MaintOrderObjectListItem maintOrderObjectListItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpCompLongText
     * MaintOrderOpCompLongText} entity and save it to the S/4HANA system.
     *
     * @param maintOrderOpCompLongText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpCompLongText
     *            MaintOrderOpCompLongText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceOrderServiceBatchChangeSet
        updateMaintOrderOpCompLongText( @Nonnull final MaintOrderOpCompLongText maintOrderOpCompLongText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpCompLongText
     * MaintOrderOpCompLongText} entity in the S/4HANA system.
     *
     * @param maintOrderOpCompLongText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpCompLongText
     *            MaintOrderOpCompLongText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceOrderServiceBatchChangeSet
        deleteMaintOrderOpCompLongText( @Nonnull final MaintOrderOpCompLongText maintOrderOpCompLongText );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpComponent
     * MaintOrderOpComponent} entity and save it to the S/4HANA system.
     *
     * @param maintOrderOpComponent
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpComponent
     *            MaintOrderOpComponent} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceOrderServiceBatchChangeSet
        createMaintOrderOpComponent( @Nonnull final MaintOrderOpComponent maintOrderOpComponent );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpComponent
     * MaintOrderOpComponent} entity and save it to the S/4HANA system.
     *
     * @param maintOrderOpComponent
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpComponent
     *            MaintOrderOpComponent} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceOrderServiceBatchChangeSet
        updateMaintOrderOpComponent( @Nonnull final MaintOrderOpComponent maintOrderOpComponent );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpComponent
     * MaintOrderOpComponent} entity in the S/4HANA system.
     *
     * @param maintOrderOpComponent
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpComponent
     *            MaintOrderOpComponent} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceOrderServiceBatchChangeSet
        deleteMaintOrderOpComponent( @Nonnull final MaintOrderOpComponent maintOrderOpComponent );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpLongText
     * MaintOrderOpLongText} entity and save it to the S/4HANA system.
     *
     * @param maintOrderOpLongText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpLongText
     *            MaintOrderOpLongText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceOrderServiceBatchChangeSet
        updateMaintOrderOpLongText( @Nonnull final MaintOrderOpLongText maintOrderOpLongText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpLongText
     * MaintOrderOpLongText} entity in the S/4HANA system.
     *
     * @param maintOrderOpLongText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpLongText
     *            MaintOrderOpLongText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceOrderServiceBatchChangeSet
        deleteMaintOrderOpLongText( @Nonnull final MaintOrderOpLongText maintOrderOpLongText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpProdnRsceTool
     * MaintOrderOpProdnRsceTool} entity and save it to the S/4HANA system.
     *
     * @param maintOrderOpProdnRsceTool
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpProdnRsceTool
     *            MaintOrderOpProdnRsceTool} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceOrderServiceBatchChangeSet
        updateMaintOrderOpProdnRsceTool( @Nonnull final MaintOrderOpProdnRsceTool maintOrderOpProdnRsceTool );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpProdnRsceTool
     * MaintOrderOpProdnRsceTool} entity in the S/4HANA system.
     *
     * @param maintOrderOpProdnRsceTool
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpProdnRsceTool
     *            MaintOrderOpProdnRsceTool} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceOrderServiceBatchChangeSet
        deleteMaintOrderOpProdnRsceTool( @Nonnull final MaintOrderOpProdnRsceTool maintOrderOpProdnRsceTool );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationship
     * MaintOrderOpRelationship} entity and save it to the S/4HANA system.
     *
     * @param maintOrderOpRelationship
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationship
     *            MaintOrderOpRelationship} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceOrderServiceBatchChangeSet
        updateMaintOrderOpRelationship( @Nonnull final MaintOrderOpRelationship maintOrderOpRelationship );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationship
     * MaintOrderOpRelationship} entity in the S/4HANA system.
     *
     * @param maintOrderOpRelationship
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationship
     *            MaintOrderOpRelationship} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceOrderServiceBatchChangeSet
        deleteMaintOrderOpRelationship( @Nonnull final MaintOrderOpRelationship maintOrderOpRelationship );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderSettlmtDistrRule
     * MaintOrderSettlmtDistrRule} entity and save it to the S/4HANA system.
     *
     * @param maintOrderSettlmtDistrRule
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderSettlmtDistrRule
     *            MaintOrderSettlmtDistrRule} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceOrderServiceBatchChangeSet
        updateMaintOrderSettlmtDistrRule( @Nonnull final MaintOrderSettlmtDistrRule maintOrderSettlmtDistrRule );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderSettlmtDistrRule
     * MaintOrderSettlmtDistrRule} entity in the S/4HANA system.
     *
     * @param maintOrderSettlmtDistrRule
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderSettlmtDistrRule
     *            MaintOrderSettlmtDistrRule} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceOrderServiceBatchChangeSet
        deleteMaintOrderSettlmtDistrRule( @Nonnull final MaintOrderSettlmtDistrRule maintOrderSettlmtDistrRule );

}
