/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpCompLongText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.selectable.MaintOrderOpCompLongTextSelectable;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpCompLongText
 * MaintOrderOpCompLongText} to other entities. Instances of this object are used in query modifier methods of the
 * entity fluent helpers. Contains methods to compare a field's value with a provided value.
 *
 * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData
 * field names, so use the constructor with caution.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class MaintOrderOpCompLongTextLink<ObjectT extends VdmObject<?>>
    extends
    EntityLink<MaintOrderOpCompLongTextLink<ObjectT>, MaintOrderOpCompLongText, ObjectT>
    implements
    MaintOrderOpCompLongTextSelectable
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public MaintOrderOpCompLongTextLink( final String fieldName )
    {
        super(fieldName);
    }

    private MaintOrderOpCompLongTextLink(
        final EntityLink<MaintOrderOpCompLongTextLink<ObjectT>, MaintOrderOpCompLongText, ObjectT> toClone )
    {
        super(toClone);
    }

    @Nonnull
    @Override
    protected MaintOrderOpCompLongTextLink<ObjectT> translateLinkType(
        final EntityLink<MaintOrderOpCompLongTextLink<ObjectT>, MaintOrderOpCompLongText, ObjectT> link )
    {
        return new MaintOrderOpCompLongTextLink<ObjectT>(link);
    }

}
