/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrdSettlmtDistrRuleHist;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrdSettlmtDistrRuleHist
 * MaintOrdSettlmtDistrRuleHist}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.field.MaintOrdSettlmtDistrRuleHistField
 * MaintOrdSettlmtDistrRuleHistField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.link.MaintOrdSettlmtDistrRuleHistLink
 * MaintOrdSettlmtDistrRuleHistLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrdSettlmtDistrRuleHist#MAINTENANCE_ORDER
 * MAINTENANCE_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrdSettlmtDistrRuleHist#SETTLMT_DISTR_RULE_SEQUENCE
 * SETTLMT_DISTR_RULE_SEQUENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrdSettlmtDistrRuleHist#LEDGER
 * LEDGER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrdSettlmtDistrRuleHist#SETTLEMENT_DISTRIBUTION_RULE_GRP
 * SETTLEMENT_DISTRIBUTION_RULE_GRP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrdSettlmtDistrRuleHist#LEDGER_GROUP
 * LEDGER_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrdSettlmtDistrRuleHist#CONTROLLING_OBJECT
 * CONTROLLING_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrdSettlmtDistrRuleHist#SETTLEMENT_TYPE
 * SETTLEMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrdSettlmtDistrRuleHist#DISTRIBUTION_SOURCE_ASSIGNMENT
 * DISTRIBUTION_SOURCE_ASSIGNMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrdSettlmtDistrRuleHist#ACCOUNT_ASSIGNMENT_TYPE
 * ACCOUNT_ASSIGNMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrdSettlmtDistrRuleHist#SETTLEMENT_PERCENTAGE_RATE
 * SETTLEMENT_PERCENTAGE_RATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrdSettlmtDistrRuleHist#SETTLEMENT_EQUIVALENCE_FACTOR
 * SETTLEMENT_EQUIVALENCE_FACTOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrdSettlmtDistrRuleHist#SETTLEMENT_AMOUNT
 * SETTLEMENT_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrdSettlmtDistrRuleHist#SETTLEMENT_AMOUNT_CURRENCY
 * SETTLEMENT_AMOUNT_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrdSettlmtDistrRuleHist#CONTROLLING_AREA
 * CONTROLLING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrdSettlmtDistrRuleHist#BUSINESS_AREA
 * BUSINESS_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrdSettlmtDistrRuleHist#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrdSettlmtDistrRuleHist#GL_ACCOUNT
 * GL_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrdSettlmtDistrRuleHist#PROFIT_CENTER
 * PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrdSettlmtDistrRuleHist#COST_CENTER
 * COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrdSettlmtDistrRuleHist#ORDER_ID
 * ORDER_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrdSettlmtDistrRuleHist#WBS_ELEMENT_INTERNAL_ID
 * WBS_ELEMENT_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrdSettlmtDistrRuleHist#MASTER_FIXED_ASSET
 * MASTER_FIXED_ASSET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrdSettlmtDistrRuleHist#FIXED_ASSET
 * FIXED_ASSET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrdSettlmtDistrRuleHist#NETWORK_NUMBER_FOR_ACCT_ASSGMT
 * NETWORK_NUMBER_FOR_ACCT_ASSGMT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrdSettlmtDistrRuleHist#SALES_ORDER
 * SALES_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrdSettlmtDistrRuleHist#SALES_ORDER_ITEM
 * SALES_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrdSettlmtDistrRuleHist#COST_OBJECT
 * COST_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrdSettlmtDistrRuleHist#BUSINESS_PROCESS
 * BUSINESS_PROCESS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrdSettlmtDistrRuleHist#ALTV_SETTLMT_DISTR_RULE_SEQUENCE
 * ALTV_SETTLMT_DISTR_RULE_SEQUENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrdSettlmtDistrRuleHist#VALIDITY_START_FISCAL_PERIOD
 * VALIDITY_START_FISCAL_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrdSettlmtDistrRuleHist#VALIDITY_START_FISCAL_YEAR
 * VALIDITY_START_FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrdSettlmtDistrRuleHist#VALIDITY_END_FISCAL_PERIOD
 * VALIDITY_END_FISCAL_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrdSettlmtDistrRuleHist#VALIDITY_END_FISCAL_YEAR
 * VALIDITY_END_FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrdSettlmtDistrRuleHist#SETTLMT_RULE1ST_USGE_FISCAL_PERIOD
 * SETTLMT_RULE1ST_USGE_FISCAL_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrdSettlmtDistrRuleHist#SETTLMT_RULE1ST_USAGE_FISCAL_YEAR
 * SETTLMT_RULE1ST_USAGE_FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrdSettlmtDistrRuleHist#SETTLMT_RULE_LAST_USGE_FSCL_PERIOD
 * SETTLMT_RULE_LAST_USGE_FSCL_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrdSettlmtDistrRuleHist#SETTLMT_RULE_LAST_USAGE_FISCAL_YEAR
 * SETTLMT_RULE_LAST_USAGE_FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrdSettlmtDistrRuleHist#TO_MAINTENANCE_ORDER
 * TO_MAINTENANCE_ORDER}</li>
 * </ul>
 *
 */
public interface MaintOrdSettlmtDistrRuleHistSelectable extends EntitySelectable<MaintOrdSettlmtDistrRuleHist>
{

}
