/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm
 * MaintOrderActlPlndCostItm}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.field.MaintOrderActlPlndCostItmField
 * MaintOrderActlPlndCostItmField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.link.MaintOrderActlPlndCostItmLink
 * MaintOrderActlPlndCostItmLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm#PGL_ACCOUNT_HIERARCHY
 * PGL_ACCOUNT_HIERARCHY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm#SOURCE_LEDGER
 * SOURCE_LEDGER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm#LEDGER
 * LEDGER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm#FISCAL_YEAR
 * FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm#ACCOUNTING_DOCUMENT
 * ACCOUNTING_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm#FINANCIAL_PLANNING_REQ_TRANS_SQNC
 * FINANCIAL_PLANNING_REQ_TRANS_SQNC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm#FINANCIAL_PLANNING_DATA_PACKET
 * FINANCIAL_PLANNING_DATA_PACKET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm#ACTUAL_PLAN_JOURNAL_ENTRY_ITEM
 * ACTUAL_PLAN_JOURNAL_ENTRY_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm#GL_ACCOUNT_HIERARCHY
 * GL_ACCOUNT_HIERARCHY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm#MAINT_ORD_COST_ANLYS_SPEND_CATEGORY
 * MAINT_ORD_COST_ANLYS_SPEND_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm#GL_ACCOUNT
 * GL_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm#MAINTENANCE_ORDER
 * MAINTENANCE_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm#COST_ELEMENT_GROUP_NAME
 * COST_ELEMENT_GROUP_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm#MAINTENANCE_ORDER_OPERATION
 * MAINTENANCE_ORDER_OPERATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm#MAINTENANCE_ORDER_SUB_OPERATION
 * MAINTENANCE_ORDER_SUB_OPERATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm#MAINTENANCE_ACTIVITY_TYPE
 * MAINTENANCE_ACTIVITY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm#GL_ACCOUNT_NAME
 * GL_ACCOUNT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm#MAIN_WORK_CENTER
 * MAIN_WORK_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm#OPERATION_WORK_CENTER
 * OPERATION_WORK_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm#PRODUCT_GROUP
 * PRODUCT_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm#PRODUCT
 * PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm#ASSEMBLY
 * ASSEMBLY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm#EQUIPMENT
 * EQUIPMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm#FUNCTIONAL_LOCATION
 * FUNCTIONAL_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm#REFERENCE_DOCUMENT
 * REFERENCE_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm#REFERENCE_DOCUMENT_TYPE
 * REFERENCE_DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm#REFERENCE_DOCUMENT_CONTEXT
 * REFERENCE_DOCUMENT_CONTEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm#REFERENCE_DOCUMENT_ITEM
 * REFERENCE_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm#MAINT_PRIORITY_TYPE
 * MAINT_PRIORITY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm#MAINT_PRIORITY
 * MAINT_PRIORITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm#PURCHASE_ORDER
 * PURCHASE_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm#PURCHASE_ORDER_ITEM
 * PURCHASE_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm#RESERVATION
 * RESERVATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm#RESERVATION_ITEM
 * RESERVATION_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm#RESERVATION_TYPE
 * RESERVATION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm#GLOBAL_CURRENCY
 * GLOBAL_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm#AMOUNT_IN_GLOBAL_CURRENCY
 * AMOUNT_IN_GLOBAL_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm#ACTUAL_MAINT_AMOUNT_IN_GLOB_CRCY
 * ACTUAL_MAINT_AMOUNT_IN_GLOB_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm#PLANNED_MAINT_AMOUNT_IN_GLOB_CRCY
 * PLANNED_MAINT_AMOUNT_IN_GLOB_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm#BASELINE_MAINT_AMOUNT_IN_GLOB_CRCY
 * BASELINE_MAINT_AMOUNT_IN_GLOB_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm#ESTIMATED_MAINT_AMOUNT_IN_GLOB_CRCY
 * ESTIMATED_MAINT_AMOUNT_IN_GLOB_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm#COMPANY_CODE_CURRENCY
 * COMPANY_CODE_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm#AMOUNT_IN_COMPANY_CODE_CURRENCY
 * AMOUNT_IN_COMPANY_CODE_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm#ACTUAL_MAINT_AMOUNT_IN_CO_CRCY
 * ACTUAL_MAINT_AMOUNT_IN_CO_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm#PLANNED_MAINT_AMOUNT_IN_CO_CRCY
 * PLANNED_MAINT_AMOUNT_IN_CO_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm#BASELINE_MAINT_AMOUNT_IN_CO_CRCY
 * BASELINE_MAINT_AMOUNT_IN_CO_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm#ESTIMATED_MAINT_AMOUNT_IN_CO_CRCY
 * ESTIMATED_MAINT_AMOUNT_IN_CO_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm#TO_MAINTENANCE_ORDER
 * TO_MAINTENANCE_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm#TO_MAINTENANCE_ORDER_OP_COMPONENT
 * TO_MAINTENANCE_ORDER_OP_COMPONENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm#TO_MAINTENANCE_ORDER_OPERATION
 * TO_MAINTENANCE_ORDER_OPERATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm#TO_PARAMETERS
 * TO_PARAMETERS}</li>
 * </ul>
 *
 */
public interface MaintOrderActlPlndCostItmSelectable extends EntitySelectable<MaintOrderActlPlndCostItm>
{

}
