/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm_TypeParameters;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm_TypeParameters
 * MaintOrderActlPlndCostItm_TypeParameters}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.field.MaintOrderActlPlndCostItm_TypeParametersField
 * MaintOrderActlPlndCostItm_TypeParametersField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.link.MaintOrderActlPlndCostItm_TypeParametersLink
 * MaintOrderActlPlndCostItm_TypeParametersLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm_TypeParameters#PGL_ACCOUNT_HIERARCHY
 * PGL_ACCOUNT_HIERARCHY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm_TypeParameters#TO_SET
 * TO_SET}</li>
 * </ul>
 *
 */
public interface MaintOrderActlPlndCostItm_TypeParametersSelectable
    extends
    EntitySelectable<MaintOrderActlPlndCostItm_TypeParameters>
{

}
