/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpCompLongText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpCompLongText
 * MaintOrderOpCompLongText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.field.MaintOrderOpCompLongTextField
 * MaintOrderOpCompLongTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.link.MaintOrderOpCompLongTextLink
 * MaintOrderOpCompLongTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpCompLongText#MAINTENANCE_ORDER
 * MAINTENANCE_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpCompLongText#MAINTENANCE_ORDER_OPERATION
 * MAINTENANCE_ORDER_OPERATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpCompLongText#MAINTENANCE_ORDER_SUB_OPERATION
 * MAINTENANCE_ORDER_SUB_OPERATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpCompLongText#MAINTENANCE_ORDER_COMPONENT
 * MAINTENANCE_ORDER_COMPONENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpCompLongText#TEXT_OBJECT_TYPE
 * TEXT_OBJECT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpCompLongText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpCompLongText#ORDER_COMPONENT_LONG_TEXT
 * ORDER_COMPONENT_LONG_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpCompLongText#TO_MAINTENANCE_ORDER
 * TO_MAINTENANCE_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpCompLongText#TO_MAINTENANCE_ORDER_COMPONENT
 * TO_MAINTENANCE_ORDER_COMPONENT}</li>
 * </ul>
 *
 */
public interface MaintOrderOpCompLongTextSelectable extends EntitySelectable<MaintOrderOpCompLongText>
{

}
