/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpPhaseControl;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpPhaseControl
 * MaintOrderOpPhaseControl}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.field.MaintOrderOpPhaseControlField
 * MaintOrderOpPhaseControlField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.link.MaintOrderOpPhaseControlLink
 * MaintOrderOpPhaseControlLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpPhaseControl#MAINTENANCE_ORDER
 * MAINTENANCE_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpPhaseControl#MAINTENANCE_ORDER_OPERATION
 * MAINTENANCE_ORDER_OPERATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpPhaseControl#MAINTENANCE_ORDER_SUB_OPERATION
 * MAINTENANCE_ORDER_SUB_OPERATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpPhaseControl#MAINTENANCE_PHASE_CONTROL
 * MAINTENANCE_PHASE_CONTROL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpPhaseControl#MAINTENANCE_PHASE_CONTROL_NAME
 * MAINTENANCE_PHASE_CONTROL_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpPhaseControl#MAINTENANCE_PHASE_CONTROL_TEXT
 * MAINTENANCE_PHASE_CONTROL_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpPhaseControl#MAINT_PHSE_CTRL_IS_SET_AUTOMLY
 * MAINT_PHSE_CTRL_IS_SET_AUTOMLY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpPhaseControl#MAINT_PHASE_CONTROL_AUTHORITY_CODE
 * MAINT_PHASE_CONTROL_AUTHORITY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpPhaseControl#MAINT_PROCG_PHSE_CTRL_ACTVTN_CODE
 * MAINT_PROCG_PHSE_CTRL_ACTVTN_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpPhaseControl#MAINT_PROCG_PHSE_CTRL_ACTVTN_DESC
 * MAINT_PROCG_PHSE_CTRL_ACTVTN_DESC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpPhaseControl#EAM_PROCESS_PHASE_CODE
 * EAM_PROCESS_PHASE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpPhaseControl#EAM_PROCESS_SUB_PHASE_CODE
 * EAM_PROCESS_SUB_PHASE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpPhaseControl#MAINT_OBJ_PHSE_CTRL_STATUS_IS_ACTIVE
 * MAINT_OBJ_PHSE_CTRL_STATUS_IS_ACTIVE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpPhaseControl#MAINT_OBJ_PHASE_CTRL_CODE_SET_BY
 * MAINT_OBJ_PHASE_CTRL_CODE_SET_BY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpPhaseControl#MAINT_OBJ_PHSE_CTRL_CODE_SET_DTE_TIME
 * MAINT_OBJ_PHSE_CTRL_CODE_SET_DTE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpPhaseControl#MAINT_OBJ_PHASE_CTRL_CODE_RESET_BY
 * MAINT_OBJ_PHASE_CTRL_CODE_RESET_BY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpPhaseControl#MAINT_OBJ_PHSE_CTRL_CODE_RSET_DTE_TME
 * MAINT_OBJ_PHSE_CTRL_CODE_RSET_DTE_TME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpPhaseControl#TO_MAINTENANCE_ORDER_OPERATION
 * TO_MAINTENANCE_ORDER_OPERATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpPhaseControl#TO_MAINTENANCE_ORDER
 * TO_MAINTENANCE_ORDER}</li>
 * </ul>
 *
 */
public interface MaintOrderOpPhaseControlSelectable extends EntitySelectable<MaintOrderOpPhaseControl>
{

}
