/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpProdnRsceTool;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpProdnRsceTool
 * MaintOrderOpProdnRsceTool}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.field.MaintOrderOpProdnRsceToolField
 * MaintOrderOpProdnRsceToolField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.link.MaintOrderOpProdnRsceToolLink
 * MaintOrderOpProdnRsceToolLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpProdnRsceTool#MAINTENANCE_ORDER
 * MAINTENANCE_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpProdnRsceTool#MAINTENANCE_ORDER_OPERATION
 * MAINTENANCE_ORDER_OPERATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpProdnRsceTool#MAINTENANCE_ORDER_SUB_OPERATION
 * MAINTENANCE_ORDER_SUB_OPERATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpProdnRsceTool#PRODN_RSCE_TOOL_ITEM_NUMBER
 * PRODN_RSCE_TOOL_ITEM_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpProdnRsceTool#ORDER_PRODN_RSCE_TOOL_TEXT
 * ORDER_PRODN_RSCE_TOOL_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpProdnRsceTool#PRODN_RSCE_TOOL_CATEGORY
 * PRODN_RSCE_TOOL_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpProdnRsceTool#PRODN_RSCE_TOOL_CATEGORY_NAME
 * PRODN_RSCE_TOOL_CATEGORY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpProdnRsceTool#PRODUCTION_RESOURCE_TOOL
 * PRODUCTION_RESOURCE_TOOL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpProdnRsceTool#PRODUCT
 * PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpProdnRsceTool#MISC_PRODUCTION_RESOURCE_TOOL
 * MISC_PRODUCTION_RESOURCE_TOOL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpProdnRsceTool#PRODUCTION_RESOURCE_TOOL_DESC
 * PRODUCTION_RESOURCE_TOOL_DESC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpProdnRsceTool#PRODN_RSCE_TOOL_CONTROL_PROFILE
 * PRODN_RSCE_TOOL_CONTROL_PROFILE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpProdnRsceTool#PRODN_RSCE_TOOL_STANDARD_WORK_QTY
 * PRODN_RSCE_TOOL_STANDARD_WORK_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpProdnRsceTool#PRODN_RSCE_TOOL_STD_WORK_QTY_UNIT
 * PRODN_RSCE_TOOL_STD_WORK_QTY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpProdnRsceTool#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpProdnRsceTool#TO_MAINTENANCE_ORDER_OPERATION
 * TO_MAINTENANCE_ORDER_OPERATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpProdnRsceTool#TO_MAINTENANCE_ORDER
 * TO_MAINTENANCE_ORDER}</li>
 * </ul>
 *
 */
public interface MaintOrderOpProdnRsceToolSelectable extends EntitySelectable<MaintOrderOpProdnRsceTool>
{

}
