/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationship;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationship
 * MaintOrderOpRelationship}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.field.MaintOrderOpRelationshipField
 * MaintOrderOpRelationshipField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.link.MaintOrderOpRelationshipLink
 * MaintOrderOpRelationshipLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationship#MAINTENANCE_ORDER
 * MAINTENANCE_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationship#MAINTENANCE_ORDER_OPERATION
 * MAINTENANCE_ORDER_OPERATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationship#MAINTENANCE_ORDER_SUB_OPERATION
 * MAINTENANCE_ORDER_SUB_OPERATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationship#MAINT_ORD_OPERATION_IS_SUCCESSOR
 * MAINT_ORD_OPERATION_IS_SUCCESSOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationship#RELATED_MAINTENANCE_ORDER
 * RELATED_MAINTENANCE_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationship#RELATED_MAINT_ORDER_OPERATION
 * RELATED_MAINT_ORDER_OPERATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationship#ORDER_OP_RELATIONSHIP_INT_TYPE
 * ORDER_OP_RELATIONSHIP_INT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationship#PREDECESSOR_MAINT_ORDER_ROUTING
 * PREDECESSOR_MAINT_ORDER_ROUTING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationship#PREDECESSOR_ORDER_ROUTING_NODE
 * PREDECESSOR_ORDER_ROUTING_NODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationship#SUCCESSOR_MAINT_ORDER_ROUTING
 * SUCCESSOR_MAINT_ORDER_ROUTING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationship#SUCCESSOR_ORDER_ROUTING_NODE
 * SUCCESSOR_ORDER_ROUTING_NODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationship#RELATED_MAINT_ORDER_ROUTING
 * RELATED_MAINT_ORDER_ROUTING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationship#RELATED_ORDER_ROUTING_NODE
 * RELATED_ORDER_ROUTING_NODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationship#FACTORY_CALENDAR
 * FACTORY_CALENDAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationship#OP_RELSHP_OFFSET_DURATION
 * OP_RELSHP_OFFSET_DURATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationship#OP_RELSHP_OFFSET_DURATION_UNIT
 * OP_RELSHP_OFFSET_DURATION_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationship#OP_RELSHP_EARLIEST_START_DATE
 * OP_RELSHP_EARLIEST_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationship#OP_RELSHP_EARLIEST_START_TIME
 * OP_RELSHP_EARLIEST_START_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationship#OP_RELATIONSHIP_LATEST_START_DATE
 * OP_RELATIONSHIP_LATEST_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationship#OP_RELATIONSHIP_LATEST_START_TIME
 * OP_RELATIONSHIP_LATEST_START_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationship#OP_RELSHP_EARLIEST_FINISH_DATE
 * OP_RELSHP_EARLIEST_FINISH_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationship#OP_RELSHP_EARLIEST_FINISH_TIME
 * OP_RELSHP_EARLIEST_FINISH_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationship#OP_RELSHP_LATEST_FINISH_DATE
 * OP_RELSHP_LATEST_FINISH_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationship#OP_RELSHP_LATEST_FINISH_TIME
 * OP_RELSHP_LATEST_FINISH_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationship#TO_MAINTENANCE_ORDER_OPERATION
 * TO_MAINTENANCE_ORDER_OPERATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationship#TO_MAINTENANCE_ORDER
 * TO_MAINTENANCE_ORDER}</li>
 * </ul>
 *
 */
public interface MaintOrderOpRelationshipSelectable extends EntitySelectable<MaintOrderOpRelationship>
{

}
