/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderLongText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderLongText
 * MaintenanceOrderLongText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.field.MaintenanceOrderLongTextField
 * MaintenanceOrderLongTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.link.MaintenanceOrderLongTextLink
 * MaintenanceOrderLongTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderLongText#MAINTENANCE_ORDER
 * MAINTENANCE_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderLongText#TEXT_OBJECT_TYPE
 * TEXT_OBJECT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderLongText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderLongText#MAINTENANCE_ORDER_LONG_TEXT
 * MAINTENANCE_ORDER_LONG_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderLongText#TO_MAINTENANCE_ORDER
 * TO_MAINTENANCE_ORDER}</li>
 * </ul>
 *
 */
public interface MaintenanceOrderLongTextSelectable extends EntitySelectable<MaintenanceOrderLongText>
{

}
