/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation
 * MaintenanceOrderOperation}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.field.MaintenanceOrderOperationField
 * MaintenanceOrderOperationField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.link.MaintenanceOrderOperationLink
 * MaintenanceOrderOperationLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#MAINTENANCE_ORDER
 * MAINTENANCE_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#MAINTENANCE_ORDER_OPERATION
 * MAINTENANCE_ORDER_OPERATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#MAINTENANCE_ORDER_SUB_OPERATION
 * MAINTENANCE_ORDER_SUB_OPERATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#OPERATION_CONTROL_KEY
 * OPERATION_CONTROL_KEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#OPERATION_WORK_CENTER_INTERNAL_ID
 * OPERATION_WORK_CENTER_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#WORK_CENTER
 * WORK_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#OPERATION_STANDARD_TEXT_CODE
 * OPERATION_STANDARD_TEXT_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#OPERATION_DESCRIPTION
 * OPERATION_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#MAINT_ORDER_ROUTING_NUMBER
 * MAINT_ORDER_ROUTING_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#MAINTENANCE_ORDER_ROUTING_NODE
 * MAINTENANCE_ORDER_ROUTING_NODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#SUPERIOR_OPERATION_INTERNAL_ID
 * SUPERIOR_OPERATION_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#OPERATION_WORK_CENTER_TYPE_CODE
 * OPERATION_WORK_CENTER_TYPE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#NUMBER_OF_TIME_TICKETS
 * NUMBER_OF_TIME_TICKETS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#OPERATION_PURG_INFO_RECD_SEARCH_TXT
 * OPERATION_PURG_INFO_RECD_SEARCH_TXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#OPERATION_SUPPLIER
 * OPERATION_SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#OP_EXTERNAL_PROCESSING_PRICE
 * OP_EXTERNAL_PROCESSING_PRICE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#OP_EXTERNAL_PROCESSING_CURRENCY
 * OP_EXTERNAL_PROCESSING_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#COST_ELEMENT
 * COST_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#OPERATION_PURCHASING_INFO_RECORD
 * OPERATION_PURCHASING_INFO_RECORD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#PURCHASING_ORGANIZATION
 * PURCHASING_ORGANIZATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#PURCHASING_GROUP
 * PURCHASING_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#MATERIAL_GROUP
 * MATERIAL_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#OP_PURCHASE_OUTLINE_AGREEMENT
 * OP_PURCHASE_OUTLINE_AGREEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#OP_PURCHASE_OUTLINE_AGREEMENT_ITEM
 * OP_PURCHASE_OUTLINE_AGREEMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#OPERATION_REQUISITIONER_NAME
 * OPERATION_REQUISITIONER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#OPERATION_TRACKING_NUMBER
 * OPERATION_TRACKING_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#NUMBER_OF_CAPACITIES
 * NUMBER_OF_CAPACITIES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#OPERATION_WORK_PERCENT
 * OPERATION_WORK_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#OPERATION_CALCULATION_CONTROL
 * OPERATION_CALCULATION_CONTROL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#ACTIVITY_TYPE
 * ACTIVITY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#OPERATION_SYSTEM_CONDITION
 * OPERATION_SYSTEM_CONDITION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#OPERATION_GOODS_RECIPIENT_NAME
 * OPERATION_GOODS_RECIPIENT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#OPERATION_UNLOADING_POINT_NAME
 * OPERATION_UNLOADING_POINT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#OPERATION_PERSON_RESPONSIBLE
 * OPERATION_PERSON_RESPONSIBLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#DELIVERY_TIME_IN_DAYS
 * DELIVERY_TIME_IN_DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#MAINT_ORDER_OPERATION_DURATION
 * MAINT_ORDER_OPERATION_DURATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#MAINT_ORD_OPERATION_DURATION_UNIT
 * MAINT_ORD_OPERATION_DURATION_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#OP_BSC_START_DATE_CONSTRAINT_TYPE
 * OP_BSC_START_DATE_CONSTRAINT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#OP_BSC_END_DATE_CONSTRAINT_TYPE
 * OP_BSC_END_DATE_CONSTRAINT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#MAINT_ORD_OPERATION_WORK_DURATION
 * MAINT_ORD_OPERATION_WORK_DURATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#MAINT_ORD_OP_WORK_DURATION_UNIT
 * MAINT_ORD_OP_WORK_DURATION_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#MAINT_ORD_OP_CONSTRAINT_STRT_DTE_TME
 * MAINT_ORD_OP_CONSTRAINT_STRT_DTE_TME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#CONSTRAINT_DATE_FOR_BSC_START_DATE
 * CONSTRAINT_DATE_FOR_BSC_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#CONSTRAINT_TIME_FOR_BSC_START_TIME
 * CONSTRAINT_TIME_FOR_BSC_START_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#MAINT_ORD_OP_CSTRT_FINISH_DTE_TME
 * MAINT_ORD_OP_CSTRT_FINISH_DTE_TME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#CONSTRAINT_DATE_FOR_BSC_FINISH_DATE
 * CONSTRAINT_DATE_FOR_BSC_FINISH_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#CONSTRAINT_TIME_FOR_BSC_FINISH_TIME
 * CONSTRAINT_TIME_FOR_BSC_FINISH_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#MAINT_ORD_OPERATION_EXECUTION_RATE
 * MAINT_ORD_OPERATION_EXECUTION_RATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#EQUIPMENT
 * EQUIPMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#FUNCTIONAL_LOCATION
 * FUNCTIONAL_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#MAINTENANCE_ACTIVITY_TYPE
 * MAINTENANCE_ACTIVITY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#BUSINESS_AREA
 * BUSINESS_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#PROFIT_CENTER
 * PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#COSTING_SHEET
 * COSTING_SHEET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#TAX_JURISDICTION
 * TAX_JURISDICTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#FUNCTIONAL_AREA
 * FUNCTIONAL_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#MAINT_CONTROLLING_OBJECT_CLASS
 * MAINT_CONTROLLING_OBJECT_CLASS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#WRK_CTR_INT_CAP_RQMTS_DISTR
 * WRK_CTR_INT_CAP_RQMTS_DISTR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#MAINT_ORD_OPERATION_OVERHEAD_CODE
 * MAINT_ORD_OPERATION_OVERHEAD_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#MAINT_ORDER_OPERATION_QUANTITY
 * MAINT_ORDER_OPERATION_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#MAINT_ORD_OPERATION_QUANTITY_UNIT
 * MAINT_ORD_OPERATION_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#ASSEMBLY
 * ASSEMBLY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#MAINT_OPERATION_EXEC_STAGE_CODE
 * MAINT_OPERATION_EXEC_STAGE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#MAINT_ORD_OP_ASSGD_WBS_ELMNT_INT
 * MAINT_ORD_OP_ASSGD_WBS_ELMNT_INT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#WBS_ELEMENT
 * WBS_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#IS_MARKED_FOR_DELETION
 * IS_MARKED_FOR_DELETION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#MAINT_ORDER_OPERATION_INTERNAL_ID
 * MAINT_ORDER_OPERATION_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#MAINTENANCE_OBJECT_LIST_ITEM
 * MAINTENANCE_OBJECT_LIST_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#PURCHASE_REQUISITION
 * PURCHASE_REQUISITION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#PURCHASE_REQUISITION_ITEM
 * PURCHASE_REQUISITION_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#OP_ERLST_SCHEDLD_EXEC_STRT_DTE
 * OP_ERLST_SCHEDLD_EXEC_STRT_DTE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#OP_ERLST_SCHEDLD_EXEC_STRT_TME
 * OP_ERLST_SCHEDLD_EXEC_STRT_TME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#OP_ERLST_SCHEDLD_EXEC_END_DTE
 * OP_ERLST_SCHEDLD_EXEC_END_DTE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#OP_ERLST_SCHEDLD_EXEC_END_TME
 * OP_ERLST_SCHEDLD_EXEC_END_TME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#OP_LTST_SCHEDLD_EXEC_STRT_DTE
 * OP_LTST_SCHEDLD_EXEC_STRT_DTE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#OP_LTST_SCHEDLD_EXEC_STRT_TME
 * OP_LTST_SCHEDLD_EXEC_STRT_TME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#OP_LTST_SCHEDLD_EXEC_END_DTE
 * OP_LTST_SCHEDLD_EXEC_END_DTE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#OP_LTST_SCHEDLD_EXEC_END_TME
 * OP_LTST_SCHEDLD_EXEC_END_TME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#OP_ACTUAL_EXECUTION_START_DATE
 * OP_ACTUAL_EXECUTION_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#OP_ACTUAL_EXECUTION_START_TIME
 * OP_ACTUAL_EXECUTION_START_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#OP_ACTUAL_EXECUTION_END_DATE
 * OP_ACTUAL_EXECUTION_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#OP_ACTUAL_EXECUTION_END_TIME
 * OP_ACTUAL_EXECUTION_END_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#FORECAST_WORK_QUANTITY
 * FORECAST_WORK_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#ACTUAL_WORK_QUANTITY
 * ACTUAL_WORK_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#MAINT_ORD_OP_PROCESS_PHASE_CODE
 * MAINT_ORD_OP_PROCESS_PHASE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#MAINT_ORD_OP_PROCESS_SUB_PHASE_CODE
 * MAINT_ORD_OP_PROCESS_SUB_PHASE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#SYSTEM_STATUS_TEXT
 * SYSTEM_STATUS_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#USER_STATUS_TEXT
 * USER_STATUS_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#TO_MAINTENANCE_ORDER
 * TO_MAINTENANCE_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#TO_MAINT_ORDER_OP_COMPONENT
 * TO_MAINT_ORDER_OP_COMPONENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#TO_MAINT_ORDER_OP_LONG_TEXT
 * TO_MAINT_ORDER_OP_LONG_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#TO_MAINT_ORDER_OP_PHASE_CONTROL
 * TO_MAINT_ORDER_OP_PHASE_CONTROL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#TO_MAINT_ORDER_OP_PRODN_RSCE_TOOL
 * TO_MAINT_ORDER_OP_PRODN_RSCE_TOOL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation#TO_MAINT_ORDER_OP_RELATIONSHIP
 * TO_MAINT_ORDER_OP_RELATIONSHIP}</li>
 * </ul>
 *
 */
public interface MaintenanceOrderOperationSelectable extends EntitySelectable<MaintenanceOrderOperation>
{

}
