/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderPartner;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderPartner
 * MaintenanceOrderPartner}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.field.MaintenanceOrderPartnerField
 * MaintenanceOrderPartnerField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.link.MaintenanceOrderPartnerLink
 * MaintenanceOrderPartnerLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderPartner#MAINTENANCE_ORDER
 * MAINTENANCE_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderPartner#PARTNER_FUNCTION
 * PARTNER_FUNCTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderPartner#MAINTENANCE_ORDER_PARTNER
 * MAINTENANCE_ORDER_PARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderPartner#TO_MAINTENANCE_ORDER
 * TO_MAINTENANCE_ORDER}</li>
 * </ul>
 *
 */
public interface MaintenanceOrderPartnerSelectable extends EntitySelectable<MaintenanceOrderPartner>
{

}
